#!/usr/bin/env ruby

require 'socket'
require 'ssl'
require 'getopts'
begin require 'verify_cb'; rescue LoadError; end

include SSL

getopts "v", "C:", "p:2000", "c:", "k:"

host = ARGV[0] || "localhost"

s = TCPSocket.new(host, $OPT_p)
STDERR.print "connect to #{s.peeraddr[3]}.\n"

ssl = SSLSocket.new(s, $OPT_c, $OPT_k)
ssl.ca_file = $OPT_C if $OPT_C && FileTest::file?($OPT_C)
ssl.ca_path = $OPT_C if $OPT_C && FileTest::directory?($OPT_C)
ssl.verify_mode = VERIFY_PEER if $OPT_v
ssl.verify_callback = VerifyCallbackProc if defined? VerifyCallbackProc
STDERR.print "SSLSocket initialized.\n"

ssl.connect
STDERR.print "SSLSocket connected.\n"
STDERR.print ssl.peer_cert.inspect, "\n" if ssl.peer_cert

while line = gets
  ssl.write line
end

ssl.close
s.close
