#ifndef __htmlstreamh__
  #include "../htmlstream.h"
#endif

#ifndef __htmlh__
  #include "../html.h"
#endif

#ifndef __stringproch__
  #include "../stringproc.h"
#endif

#ifndef __pluginh__
  #include "../plugin.h"
#endif

#define __USE_XOPEN
#include <unistd.h>
#include <sys/file.h>
#include <fstream>

static const char *saltset="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789./";

class dsoPasswordFileMod :public Plugin{
public:
  virtual void Init();
  static HTMLStream::iterator MONTH(HTMLStream& stream,HTMLStream::iterator Cur,const ParamMap& paramMap,const string& tag);
private:
  static const int LOCKTIMEOUT=5;
  static void CRYPT(const HTML& Cur,string& data,const vector<string>& params);
  static HTMLStream::iterator SETPASSWORD(HTMLStream& stream,HTMLStream::iterator Cur,const ParamMap& paramMap,const string& tag); 
  static string doCrypt(const string& password);
};

static dsoPasswordFileMod initmodule;

int dsoPasswordFileMod::initclass(const string& fnnamespace){
  Plugin::RegisterFunction("CRYPT",&CRYPT);
  Plugin::RegisterCommand("SETPASSWORD",&SETPASSWORD);
}

void dsoPasswordFileMod::CRYPT(const HTML& Cur,string& data,const vector<string>& params){
  srand(time(NULL));
  char *salt = "  ";
  if (params.size()==0) {
    *salt=*(saltset+(rand()&63));
    *(salt+1)=*(saltset+(rand()&63));
    data=crypt(data.c_str(),salt);
  } else if (params.size()==1) {
    data=crypt(data.c_str(),params[0].c_str());
  } else {
    Error(Cur,"CRYPT",e_ParamWrong);
  }
}

string dsoPasswordFileMod::doCrypt(const string& password) {
  srand(time(NULL));
  string data;
  char *salt = "  ";
  *salt=*(saltset+(rand()&63));
  *(salt+1)=*(saltset+(rand()&63));
  data=crypt(password.c_str(),salt);
  return data;
}

HTMLStream::iterator dsoPasswordFileMod::SETPASSWORD(HTMLStream& stream,HTMLStream::iterator Cur,const ParamMap& paramMap,const string& tag) {
  string src,user,passwd,lock;
  if (!paramMap.Retrieve("SRC",src)) Error(*Cur,"SRC must be set");
  if (!paramMap.Retrieve("USER",user)) {
    char* envuser = getenv("REMOTE_USER");
    if (NULL==envuser) Error(*Cur,"USER must be set when not already authenicated");
    user=envuser;
  }
  if(!paramMap.Retrieve("PASSWORD",passwd)) Error(*Cur,"PASSWORD must be set");
  src=stream.m_ThisPath+src;
  lock=src+".LOCK";
  int kount=0,infd;
  for (;kount<LOCKTIMEOUT;++kount) {
    infd =open(src.c_str(),O_RDONLY);
    if (-1==infd) Error(*Cur,"Could not open password file");
    if (0==flock(infd,LOCK_EX|LOCK_NB)) break;
    close(infd);
    sleep(1);
  }
  ifstream input(infd);
  if (kount==LOCKTIMEOUT)  Error(*Cur,"Could not get a lock on the password file");
  ofstream output;
  output.open(lock.c_str());
  if (!output.is_open()) Error(*Cur,"Could not build the new password file, old one kept");
  string line;
  string::iterator colon;
  while (!input.eof()) {
    getline(input,line);
    if (input.eof()) break;
    colon=find(line.begin(),line.end(),':');
    if (line.end()==colon) Error(*Cur,"Malformed password file specifed, leaving intact");
    if (user==string(line.begin(),colon)) continue;
    output << line << endl;
  }
  output << user << ':' << doCrypt(passwd) <<endl;
  output.close();
  if (0 != unlink(src.c_str()))  Error(*Cur,"Unable to unlink the password file.");
  if (0 != rename(lock.c_str(),src.c_str())) Error(*Cur,"Unable to put new password file in place");
  input.close(); // and release lock
  HTMLStream::iterator next = ++Cur;
  stream.m_stream.erase(Cur);
  return next;
}
