/***************************************************************************
                          gutenbrowser.cpp  -  description
                             -------------------
    begin                : Mon Jul 24 22:33:12 MDT 2000
    copyright            : (C) 2000 by llornkcor
    email                : ljp@llornkcor.com
 ***************************************************************************/
/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
//#include "gutenbrowserData.h"
#include "gutenbrowser.h"
void Gutenbrowser::initSlots()
{

    qDebug("Setting up slots.");
    connect( DownloadButton, SIGNAL(released()), SLOT(DownloadIndex()) );
    connect( LibraryButton, SIGNAL(released()), SLOT(LibraryBtn()) );
    connect( OpenButton, SIGNAL(released()), SLOT(OpenBtn()) );
    connect( ForwardButton, SIGNAL(clicked()), SLOT(ForwardBtn()) );
    connect( BackButton, SIGNAL(clicked()), SLOT(BackBtn()) );
    connect( PrintButton, SIGNAL(released()), SLOT(PrintBtn()) );
    connect( SearchButton, SIGNAL(released()), SLOT(SearchBtn()) );
    connect( ExitButton, SIGNAL(released()), SLOT( ByeBye()) );

    connect( lastBmkButton, SIGNAL(released()), SLOT(Bookmark()) );
//      connect( lastBmkButton, SIGNAL(pressed()), SLOT( annotations() ) );
//      lastBmkButton-> setAutoRepeat(TRUE);
    connect( setBookmarkButton, SIGNAL(released()), SLOT(setBookmark()) );
    connect( FontButton, SIGNAL(clicked()), SLOT(ChangeFont()) );
    connect( ClearButton, SIGNAL(clicked()), SLOT( ClearEdit()) );
    connect( OptionsButton, SIGNAL(clicked()), SLOT( doOptions()) );
    connect( HelpButton, SIGNAL(released()), SLOT(HelpBtn()) );
    connect( dictionaryButton, SIGNAL(released()), SLOT(LookupBtn()) );
    connect( beginButton, SIGNAL(released()), SLOT(BeginBtn()) );
    connect( InfoBar, SIGNAL( clicked()), SLOT( InfoBarClick()) );
}

void Gutenbrowser::initConfig()
{
qDebug("Starting configuration.");
    QDir library(local_library);
    if ( !library.exists()) {
        library.mkdir(local_library, TRUE);
        QString msg;
#if defined(_WS_X11_)
        msg = "chmod 755 " + local_library;
        system(msg);
#endif
    }
    qDebug( "init file is %s",iniFile.latin1());
    int w=0, h=0;
    QString str, str2;

    QWidget *d = QApplication::desktop();
    int width=d->width();
    int height=d->height();

    config->setGroup( "Geometry" );
    if(width < 1030) {
        str = config->readEntry("Frame", "700,500");
        if(  !str.isEmpty() && str.find(',')>=0) {
            sscanf(str,"%d,%d",&w,&h);
            resize(w,h);
            str2.sprintf("%d,%d", (width-w)/2,(height-h)/2);
    str = config->readEntry( "Position", str2);
        } else {
            resize( 740,510 );
            str2.sprintf("%d,%d", (width-w)/2,(height-h)/2);
    str = config->readEntry( "Position",str2);
        }
    } else {// desktop is high res
        str = config->readEntry("Frame", "990,640");
        if(  !str.isEmpty() && str.find(',')>=0) {
            sscanf(str,"%d,%d",&w,&h);
            resize(w,h);
            str2.sprintf("%d,%d", (width-w)/2,(height-h)/2);
    str = config->readEntry( "Position", str2);
        } else {
            resize( 990,640 );
            str2.sprintf("%d,%d", (width-w)/2,(height-h)/2);
    str = config->readEntry( "Position", str2);
        }
    }
    int posX, posY;
    bool ok;
    QString goober;
    goober=str.left( str.find(",", 0, TRUE) );
    posX=goober.toInt( &ok, 10);
    goober=str.right( str.findRev(",", -1, TRUE) );
    posY= goober.toInt( &ok, 10);
//     move( posX, posY);
#if defined(_WS_WIN_)
    move( posX-4, posY-20);
#endif
    str = config->readEntry("Icons", "TRUE");
    if(str == "TRUE")
        useIcons=TRUE;
    else
        useIcons=FALSE;

   QString fontStr, pointSizeStr, weightStr, italicStr, boldStr;
   int italic;
   bool bold;
qDebug("Setting font info.");
   config->setGroup("Font");
    QFont font2;
#if defined(_WS_WIN_)
    fontStr = config->readEntry( "Family", "Century Schoolbook");
#endif
#if defined(_WS_X11_)
    fontStr = config->readEntry( "Family", "helvetica");
#endif

    font2.setFamily( fontStr);
    pointSizeStr = config->readEntry( "Size", "10");
    weightStr=config->readEntry("Weight", "40" );
    italicStr= config->readEntry("Italic", "TRUE" );
    boldStr= config->readEntry("Bold", "FALSE");
    if(italicStr == "TRUE")
      italic= true;
    else
      italic=false;
    if( boldStr == "TRUE")
      bold = true;
    else
      bold=false;

    int pointSize=pointSizeStr.toInt( &ok, 10);
    int weight=weightStr.toInt( &ok, 10);

    font2.setPointSize( pointSize);
    font2.setItalic( italic);
    font2.setWeight( weight);
    font2.setBold( bold);

    Lview->setFont( font2);
    Rview->setFont( font2);

//        lRect = Lview->rect();
//        rRect = Rview->rect();
//        BeginBtn();
//        ResizeEdits();

    config->setGroup( "Browser" );
    brow = config->readEntry( "Preferred", "wget");
    config->setGroup( "FTPsite" );  // ftp server config
    ftp_host=config->readEntry("SiteName", "sailor.gutenberg.org");

//    ftp_host=ftp_host.right(ftp_host.length()-(ftp_host.find(") ",0,TRUE)+1) );
    ftp_host=ftp_host.right(ftp_host.length()-(ftp_host.find(")        ",0,TRUE)+1) );
    ftp_host=ftp_host.stripWhiteSpace();
    qDebug("Default site is %s", ftp_host.latin1());


    ftp_base_dir= config->readEntry("base",  "/pub/gutenberg");

    if( ftp_base_dir.find("base =",0, true)) {
    ftp_host="sailor.gutenberg.org";
    ftp_base_dir="/pub/gutenberg";

    }
qDebug("Setting style.");
    bool ok2;QString temp;
    config->setGroup( "StyleIze" );
    temp = config->readEntry( "Style", "8");
    styleI=temp.toInt( &ok2,10);
  QString copying;
#if defined(_WS_WIN_)
copying=  "C://.gutenbrowser/COPYING";
#endif
 if( styleI==0) stylePlatinum();//"stylePlatinum"));
    if( styleI==1) styleWindows();//"styleWindows") );
    if( styleI==2) styleCDE();//"styleCDE") );
    if( styleI==3) styleMotif();//"styleMotif") );
    if( styleI==4) styleMotifPlus();//"styleMotifPlus"));
    if( styleI==5) styleWood();//"styleWood") );
    if( styleI==6) styleSgi();//"styleSgi") );
    if( styleI==7) stylePlatinumPlus();//"stylePlatinumPlus") );
    if( styleI==8) styleMetal();//"styleMetal"));
#if defined(_WS_X11_)
    if( styleI==9) styleLace();//"styleLace"));
    if( styleI==10) styleLacePlus();//"styleLacePlus"));
copying="/usr/share/gutenbrowser/COPYING";
#endif
//
  config->setGroup( "Bookmarks" );

  file_name=config->readEntry("File Name",copying);
  QString s_pageNum = config->readEntry("Page Number", "0");
  QString s_Bmrkrow;
  s_Bmrkrow = config->readEntry("LineNumber","0");

config->setGroup("General");
QString qExit;
qExit=config->readEntry("queryEntry","TRUE");
if(qExit=="TRUE") {
b_queryExit=TRUE;
    qDebug("Please query before leaving the library.");
}
else {
qDebug("Please DO NOT query before leaving the library.");
 b_queryExit=FALSE;
    }

}//// end initConfig()

void Gutenbrowser::initMenuBar()
{
    qDebug("Starting menu init.");
      // menuBar entry fileMenu
    menubar = new QMenuBar(this);
    fileMenu=new QPopupMenu();
    fileMenu->insertItem("Open Local Library...", this, SLOT( OpenBtn()) );
    fileMenu->insertItem("Quit Gutenbrowser...", this, SLOT( ByeBye()) );
      // menuBar entry editMenu
    editMenu=new QPopupMenu();
    editMenu->insertItem("Forward", this, SLOT(ForwardBtn()) );
    editMenu->insertItem("Backward", this, SLOT(BackBtn()) );
    editMenu->insertItem("Search", this, SLOT(SearchBtn()) );
    editMenu->insertItem("Clear", this, SLOT(ClearEdit()) );
    editMenu->insertItem("Print", this, SLOT(PrintBtn()) );

// menuBar entry viewMenu
    viewMenu=new QPopupMenu();
    viewMenu->insertItem("Local", this, SLOT( OpenBtn()) );
    viewMenu->insertItem("Gutenberg", this, SLOT( LibraryBtn()) );

    DownloadMenu=new QPopupMenu();
    DownloadMenu->insertItem("FTPSite", this, SLOT( downloadFtpList()) );
    DownloadMenu->insertItem("Library Index", this, SLOT( downloadLibIndex()) );

    optionsMenu= new QPopupMenu();
    optionsMenu->insertItem("Configure", this, SLOT(doOptions()) );

    bookmarksMenu = new QPopupMenu();
    bookmarksMenu->insertItem("Goto", this, SLOT(Bookmark() ));
    bookmarksMenu->insertItem("Set", this, SLOT(setBookmark()) );

    donateMenu = new QPopupMenu();
    donateMenu->insertItem("Gutenberg", this, SLOT(donateGutenberg()) );

      // hmmmmmm this'll might cost me some noodles, eh?
      //    donateMenu->insertItem("byteMonkey", this, SLOT(donateByteMonkie()) );
    donateMenu->insertItem("Trolltech", this, SLOT(donateByteMonkie()) );

    // menuBar entry helpMenu
    helpMenu=new QPopupMenu();
    helpMenu->insertItem("About...", this, SLOT( HelpBtn()) );

    menubar->insertItem("File", fileMenu);
    menubar->insertItem("Page", editMenu);
    menubar->insertItem("Library", viewMenu);
    menubar->insertItem("Download", DownloadMenu);
    menubar->insertItem("Options", optionsMenu);
    menubar->insertItem("Bookmarks", bookmarksMenu);
    menubar->insertItem("Donate", donateMenu);

    menubar->insertSeparator();
    menubar->insertItem("Help", helpMenu);

//        connect(fileMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));
//        connect(editMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));
//        connect(viewMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));
//        connect(helpMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));

    menu->addWidget( menubar,0);
    topLayout->addLayout( menu, 0);
}

void Gutenbrowser::initButtonBar()
{
qDebug("Starting buttonbar init.");
  DownloadButton = new QPushButton( this, "DownloadButton" );
    DownloadButton->setFocusPolicy( QWidget::TabFocus );
    DownloadButton->setBackgroundMode( QWidget::PaletteBackground );
    DownloadButton->setAutoRepeat( FALSE );
    DownloadButton->setAutoResize( FALSE );
    DownloadButton->setToggleButton( FALSE );
    DownloadButton->setDefault( FALSE );
    DownloadButton->setAutoDefault( FALSE );
    DownloadButton->setIsMenuButton( FALSE );

    LibraryButton = new QPushButton( this, "LibraryButton" );
    LibraryButton->setFocusPolicy( QWidget::TabFocus );
    LibraryButton->setBackgroundMode( QWidget::PaletteBackground );
    LibraryButton->setAutoRepeat( FALSE );
    LibraryButton->setAutoResize( FALSE );
    LibraryButton->setToggleButton( FALSE );
    LibraryButton->setDefault( FALSE );
    LibraryButton->setAutoDefault( FALSE );
    LibraryButton->setIsMenuButton( FALSE );

    OpenButton = new QPushButton( this, "OpenButton" );
    OpenButton->setFocusPolicy( QWidget::TabFocus );
    OpenButton->setBackgroundMode( QWidget::PaletteBackground );
    OpenButton->setAutoRepeat( FALSE );
    OpenButton->setAutoResize( FALSE );
    OpenButton->setToggleButton( FALSE );
    OpenButton->setDefault( FALSE );
    OpenButton->setAutoDefault( FALSE );
    OpenButton->setIsMenuButton( FALSE );

    ForwardButton = new QPushButton( this, "ForwardButton" );
    ForwardButton->setFocusPolicy( QWidget::TabFocus );
    ForwardButton->setBackgroundMode( QWidget::PaletteBackground );
    ForwardButton->setAutoRepeat( FALSE );
    ForwardButton->setAutoResize( FALSE );
    ForwardButton->setToggleButton( FALSE );
    ForwardButton->setDefault( FALSE );
    ForwardButton->setAutoDefault( FALSE );
    ForwardButton->setIsMenuButton( FALSE );

    BackButton = new QPushButton( this, "BackButton" );
    BackButton->setFocusPolicy( QWidget::TabFocus );
    BackButton->setBackgroundMode( QWidget::PaletteBackground );
    BackButton->setAutoRepeat( FALSE );
    BackButton->setAutoResize( FALSE );
    BackButton->setToggleButton( FALSE );
    BackButton->setDefault( FALSE );
    BackButton->setAutoDefault( FALSE );
    BackButton->setIsMenuButton( FALSE );

    PrintButton = new QPushButton( this, "PrintButton" );
    PrintButton->setFocusPolicy( QWidget::TabFocus );
    PrintButton->setBackgroundMode( QWidget::PaletteBackground );
    PrintButton->setAutoRepeat( FALSE );
    PrintButton->setAutoResize( FALSE );
    PrintButton->setToggleButton( FALSE );
    PrintButton->setDefault( FALSE );
    PrintButton->setAutoDefault( FALSE );
    PrintButton->setIsMenuButton( FALSE );

    SearchButton = new QPushButton( this, "SearchButton" );
    SearchButton->setFocusPolicy( QWidget::TabFocus );
    SearchButton->setBackgroundMode( QWidget::PaletteBackground );
    SearchButton->setAutoRepeat( FALSE );
    SearchButton->setAutoResize( FALSE );
    SearchButton->setToggleButton( FALSE );
    SearchButton->setDefault( FALSE );
    SearchButton->setAutoDefault( FALSE );
    SearchButton->setIsMenuButton( FALSE );

    ExitButton = new QPushButton( this, "ExitButton" );
    ExitButton->setFocusPolicy( QWidget::TabFocus );
    ExitButton->setBackgroundMode( QWidget::PaletteBackground );
    ExitButton->setAutoRepeat( FALSE );
    ExitButton->setAutoResize( FALSE );
    ExitButton->setToggleButton( FALSE );
    ExitButton->setDefault( FALSE );
    ExitButton->setAutoDefault( FALSE );
    ExitButton->setIsMenuButton( FALSE );

    lastBmkButton = new QPushButton( this, "lastBmkButton" );
    lastBmkButton->setFocusPolicy( QWidget::TabFocus );
    lastBmkButton->setBackgroundMode( QWidget::PaletteBackground );
    lastBmkButton->setAutoRepeat( FALSE );
    lastBmkButton->setAutoResize( FALSE );
    lastBmkButton->setToggleButton( FALSE );
    lastBmkButton->setDefault( FALSE );
    lastBmkButton->setAutoDefault( FALSE );
    lastBmkButton->setIsMenuButton( FALSE );

    setBookmarkButton = new QPushButton( this, "setBookmark" );
    setBookmarkButton->setFocusPolicy( QWidget::TabFocus );
    setBookmarkButton->setBackgroundMode( QWidget::PaletteBackground );
    setBookmarkButton->setAutoRepeat( FALSE );
    setBookmarkButton->setAutoResize( FALSE );
    setBookmarkButton->setToggleButton( FALSE );
    setBookmarkButton->setDefault( FALSE );
    setBookmarkButton->setAutoDefault( FALSE );
    setBookmarkButton->setIsMenuButton( FALSE );

    FontButton = new QPushButton( this, "FontButton" );
    FontButton->setFocusPolicy( QWidget::TabFocus );
    FontButton->setBackgroundMode( QWidget::PaletteBackground );
    FontButton->setAutoRepeat( FALSE );
    FontButton->setAutoResize( FALSE );
    FontButton->setToggleButton( FALSE );
    FontButton->setDefault( FALSE );
    FontButton->setAutoDefault( FALSE );
    FontButton->setIsMenuButton( FALSE );

    ClearButton = new QPushButton( this, "ClearButton" );
    ClearButton->setFocusPolicy( QWidget::TabFocus );
    ClearButton->setBackgroundMode( QWidget::PaletteBackground );
    ClearButton->setAutoRepeat( FALSE );
    ClearButton->setAutoResize( FALSE );
    ClearButton->setToggleButton( FALSE );
    ClearButton->setDefault( FALSE );
    ClearButton->setAutoDefault( FALSE );
    ClearButton->setIsMenuButton( FALSE );

    OptionsButton = new QPushButton( this, "OptionsButton" );
    OptionsButton->setFocusPolicy( QWidget::TabFocus );
    OptionsButton->setBackgroundMode( QWidget::PaletteBackground );
    OptionsButton->setAutoRepeat( FALSE );
    OptionsButton->setAutoResize( FALSE );
    OptionsButton->setToggleButton( FALSE );
    OptionsButton->setDefault( FALSE );
    OptionsButton->setAutoDefault( FALSE );
    OptionsButton->setIsMenuButton( FALSE );

    HelpButton = new QPushButton( this, "AboutButton" );
    HelpButton->setFocusPolicy( QWidget::TabFocus );
    HelpButton->setBackgroundMode( QWidget::PaletteBackground );
    HelpButton->setAutoRepeat( FALSE );
    HelpButton->setAutoResize( FALSE );
    HelpButton->setToggleButton( FALSE );
    HelpButton->setDefault( FALSE );
    HelpButton->setAutoDefault( FALSE );
    HelpButton->setIsMenuButton( FALSE );

    dictionaryButton = new QPushButton( this, "dictionaryButton" );
    dictionaryButton->setFocusPolicy( QWidget::TabFocus );
    dictionaryButton->setBackgroundMode( QWidget::PaletteBackground );
    dictionaryButton->setAutoRepeat( FALSE );
    dictionaryButton->setAutoResize( FALSE );
    dictionaryButton->setToggleButton( FALSE );
    dictionaryButton->setDefault( FALSE );
    dictionaryButton->setAutoDefault( FALSE );
    dictionaryButton->setIsMenuButton( FALSE );

//  beginButton
    beginButton = new QPushButton( this, "beginButton" );
    beginButton->setFocusPolicy( QWidget::TabFocus );
    beginButton->setBackgroundMode( QWidget::PaletteBackground );
    beginButton->setText("^");
    beginButton->setAutoRepeat( FALSE );
    beginButton->setAutoResize( FALSE );
    beginButton->setToggleButton( FALSE );
    beginButton->setDefault( FALSE );
    beginButton->setAutoDefault( FALSE );
    beginButton->setIsMenuButton( FALSE );

    DownloadButton->setMinimumSize(60, 22 );
    LibraryButton->setMinimumSize( 60, 22 );
    OpenButton->setMinimumSize( 60, 22 );
    PrintButton->setMinimumSize( 60, 22 );
    SearchButton->setMinimumSize( 60, 22 );
    ForwardButton->setMinimumSize( 60, 22);
    BackButton->setMinimumSize( 60, 22 );
    lastBmkButton->setMinimumSize( 60, 22 );
    setBookmarkButton->setMinimumSize( 60, 22 );
    FontButton->setMinimumSize(  60, 22 );
    ClearButton->setMinimumSize( 60, 22 );
    OptionsButton->setMinimumSize( 60, 22 );
    ExitButton->setMinimumSize( 60, 22 );
    HelpButton->setMinimumSize(  60, 22);

    DownloadButton->setMaximumSize(60, 22 );
    LibraryButton->setMaximumSize( 60, 22 );
    OpenButton->setMaximumSize( 60, 22 );
    PrintButton->setMaximumSize( 60, 22 );
    SearchButton->setMaximumSize( 60, 22 );
    ForwardButton->setMaximumSize( 60, 22);
    BackButton->setMaximumSize( 60, 22 );
    lastBmkButton->setMaximumSize( 60, 22 );
    setBookmarkButton->setMaximumSize( 60, 22 );
    FontButton->setMaximumSize(  60, 22 );
    ClearButton->setMaximumSize( 60, 22 );
    OptionsButton->setMaximumSize( 60, 22 );
    ExitButton->setMaximumSize( 60, 22 );
    HelpButton->setMaximumSize(  60, 22);

    dictionaryButton->setMinimumSize(  60, 22);

    beginButton->setMinimumSize(  20, 33);
    beginButton->setMaximumSize(  20, 33);

    InfoBar = new QPushButton( this, "Info_Bar" );
    InfoBar->setMinimumSize(  250, 22);
#if defined(_WS_WIN_)
    InfoBar->setText( "winuxgutenbrowser ");
#endif
#if defined(_WS_X11_)
    InfoBar->setText( "linuxgutenbrowser ");
#endif

    buttons->addWidget(DownloadButton, 10, AlignTop  );
    buttons->addWidget(LibraryButton, 10, AlignTop );
    buttons->addWidget(PrintButton, 10, AlignTop);
    buttons->addWidget(SearchButton, 10, AlignTop );
    buttons->addWidget(ClearButton, 10, AlignTop);
    buttons->addWidget( OptionsButton, 10, AlignTop );
    buttons->addStretch(3);
    buttons->addWidget( InfoBar, 10, AlignTop );
    buttons->addStretch( 1);
    buttons->addWidget(ExitButton, 10, AlignRight );

    buttons2->addWidget(OpenButton, 10, AlignTop );
    buttons2->addWidget(BackButton, 10, AlignTop );
    buttons2->addWidget(ForwardButton, 10, AlignTop  );
    buttons2->addWidget(setBookmarkButton, 10, AlignTop );
    buttons2->addWidget(lastBmkButton, 10, AlignTop );
    buttons2->addWidget(FontButton, 10, AlignTop );
    buttons2->addWidget( dictionaryButton, 10, AlignTop );
    buttons2->addWidget( beginButton, 10, AlignTop );
    buttons2->addStretch(10);
    buttons2->addWidget(HelpButton, 10, AlignRight );

    QToolTip::add( DownloadButton, ("Download the Library Index, and ftp site list" ));
    QToolTip::add( LibraryButton, ("Select a book to download" ));
    QToolTip::add( OpenButton, ("Open a book from the local library" ));
    QToolTip::add( ForwardButton, ("Page forward" ));
    QToolTip::add( BackButton, ("Page backward" ));
    QToolTip::add( PrintButton, ("Prints the document" ));
    QToolTip::add( SearchButton, ("Searches etext for a word"));
    QToolTip::add( ExitButton, ("Go bye-bye" ));
    QToolTip::add( lastBmkButton, ("Opens last set bookmark" ));
    QToolTip::add( setBookmarkButton, ("Sets bookmark to current etext and page" ));
    QToolTip::add( FontButton, ("Change the current font" ));
    QToolTip::add( ClearButton, ("Clears the text" ));
    QToolTip::add( HelpButton, ("About info" ));
    QToolTip::add( dictionaryButton, ("For wwwebster dictionary lookup, just highlight word, and click this" ));
    QToolTip::add( OptionsButton, ("Opens options configuration dialog" ));
    QToolTip::add( InfoBar, ("Displays etext title, click to search google.com" ));
    QToolTip::add( beginButton, ("scrolls text to the beginning" ));

    qDebug("Adding buttons to topLayout.");
    topLayout->addLayout( buttons, 0);
    qDebug("Adding buttons2 to topLayout.");
    topLayout->addLayout( buttons2, 0);
}

/* STATUSBAR*/
void Gutenbrowser::initStatusBar()
{
  qDebug("Starting statusbar.");
    statusBar = new QStatusBar( this, "Status Bar");
    statusBar->message(IDS_STATUS_DEFAULT, 2000);
}

void Gutenbrowser::initDoc()
{
    doc=new GutenbrowserDoc();
}

void Gutenbrowser::initView()
{
qDebug("Setting up views and splitter.");
  // set the main widget here
    splitter = new QSplitter( Qt::Horizontal, this, "Splitter" );
//    splitter->setResizeMode( KeepSize);
    Lview = new MultiLine_Ex( splitter );
    Rview = new MultiLine_Ex( splitter );

    QFont defaultFont( "clean", 10, 50, 0 );
    qDebug("reading font.");
    config->setGroup("Font");
    QFont font = config->readFontEntry( "Family", &defaultFont);
    Lview->setFont( font );
    Rview->setFont( font );
    Lview->setReadOnly( true);
    Rview->setReadOnly( true);

    printer = new QPrinter;
//    QBrush paper;
//    QString pix_dir = local_library+"/pix/parchment.xpm";
//    QString pix_dir = local_library+"/pix/parchment_2.xpm";
//    QString pix_dir = local_library+"/pix/parchment_3.xpm";
//    paper.setPixmap( QPixmap( pix_dir ) );
//    Lview->setPaper( paper );
//    Rview->setPaper( paper );
    Lview->setFocusPolicy( QWidget::NoFocus);
    Rview->setFocusPolicy( QWidget::NoFocus);
//Lview->clearTableFlags (Tbl_vScrollBar|Tbl_hScrollBar);
//  Lview->adjustSize ();
//  ensureVisible(  -4, -4, 4, 4);
//  center ( 0, 0, 4, 4 );
//  Rview->adjustSize ();
//  ensureVisible(  -4, -4, 4, 4);
//  center ( 0, 0, 4, 4);
      //Lview->setMargin ( 10);
      //Rview->setMargin ( 10 );

//visibleHeight ()
//QScrollView::scrollBy ( int dx, int dy ) [slot]
//QScrollView::contentsHeight () const

#if defined(_WS_X11_)
    Rview->setText( "Hi\nThis is linuxgutenbrowser.\n ");
#endif
#if defined(_WS_WIN_)
    Rview->setText( "Hi\nThis is winuxgutenbrowser.\n ");
#endif

      //    Lview->setMinimumSize( 495,640 );
//    Rview->setMinimumSize( 495,640 );
//   resize( 990,640 );
    qDebug("Adding splitter to edits.");
    edits->addWidget( splitter);
    qDebug("Adding edits to topLayout.");
    topLayout->addLayout( edits, 0);
}

void Gutenbrowser::setStyle(int styleInt)
{
    if( styleInt==0) {styleI=0; stylePlatinum();}//"stylePlatinum"));
    if( styleInt==1) {styleI=1; styleWindows();}//"styleWindows") );
    if( styleInt==2) {styleI=2; styleCDE();}//"styleCDE") );
    if( styleInt==3) {styleI=3; styleMotif();}//"styleMotif") );
    if( styleInt==4) {styleI=4; styleMotifPlus();}//"styleMotifPlus"));
    if( styleInt==5) {styleI=5; styleWood();}//"styleWood") );
    if( styleInt==6) {styleI=6; styleSgi();}//"styleSgi") );
    if( styleInt==7) {styleI=7; stylePlatinumPlus();}//"stylePlatinumPlus") );
    if( styleInt==8) {styleI=8; styleMetal();}//"styleMetal"));
#if defined(_WS_X11_)
    if( styleInt==9) {styleI=9; styleLace();}//"styleLace"));
    if( styleInt==10) {styleI=10; styleLacePlus();}//" styleLacePlus"));
#endif
}
