/* GtkSQL -- an interactive graphical query tool for PostgreSQL
 * Copyright (C) 1998  Lionel ULMER
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <string.h>

#include "common.h"

#include "mytoolbar.h"

#define NORM_KEY "norm"
#define GREY_KEY "grey"
#define MASK_KEY "mask"

static GtkWidget *toolbar;

void SetMyToolbarConfig(int config) {
  /* Nothing yet.. */
}

/* Thanks to Tim Janik for this code... */
static void pixmap_state_changed (GtkWidget *widget,
				  GtkStateType previous_state,
				  gpointer user_data) {
  GtkPixmap *pixmap;
  GdkPixmap *mask, *normal_pixmap, *insensitive_pixmap;

  pixmap = GTK_PIXMAP(widget);

  mask = (GdkPixmap *) gtk_object_get_data(GTK_OBJECT(pixmap), MASK_KEY);
  normal_pixmap =
    (GdkPixmap *) gtk_object_get_data(GTK_OBJECT(pixmap), NORM_KEY);
  insensitive_pixmap =
    (GdkPixmap *) gtk_object_get_data(GTK_OBJECT(pixmap), GREY_KEY);
  
  switch (GTK_WIDGET_STATE(pixmap)) {
  case GTK_STATE_NORMAL:
    gtk_pixmap_set(pixmap, normal_pixmap, mask);
    break;
  case GTK_STATE_INSENSITIVE:
    gtk_pixmap_set(pixmap, insensitive_pixmap, mask);
    break;
  case GTK_STATE_ACTIVE:
  case GTK_STATE_PRELIGHT:
  case GTK_STATE_SELECTED:
    /* we want to ignore these? */
    break;
  }
}     

static GtkWidget *create_pixmap(GtkWidget *ref,
				char **pixmap, char **grey_pixmap) {
  GdkBitmap *mask;
  GdkPixmap *gdkpix, *gdkpix_grey;
  GtkStyle *style;
  GtkWidget *gtkpix;

  style = gtk_widget_get_style(ref);
  gdkpix = gdk_pixmap_create_from_xpm_d(ref->window,
					&mask,
					&(style->bg[GTK_STATE_NORMAL]),
					pixmap);
  gdkpix_grey =
    gdk_pixmap_create_from_xpm_d(ref->window,
				 &mask,
				 &style->bg[GTK_STATE_NORMAL],
				 grey_pixmap);

  gtkpix = gtk_pixmap_new(gdkpix, mask);
  gtk_widget_show(gtkpix);

  gtk_object_set_data(GTK_OBJECT(gtkpix),
		      NORM_KEY,
		      gdkpix);
  gtk_object_set_data(GTK_OBJECT(gtkpix),
		      GREY_KEY,
		      gdkpix_grey);
  gtk_object_set_data(GTK_OBJECT(gtkpix),
		      MASK_KEY,
		      mask);

  gtk_signal_connect (GTK_OBJECT(gtkpix),
		      "state_changed",
		      GTK_SIGNAL_FUNC(pixmap_state_changed),
		      NULL);
  
  return gtkpix;
}

GtkWidget *CreateMyToolbar(GtkWidget *ref, ToolBar *toolbardef) {
  int i;
  
  /* Create the toolbar */
  toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
  gtk_toolbar_set_tooltips (GTK_TOOLBAR(toolbar), TRUE);
  
  /* Builds the toolbar */
  i = 0;
  gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));
  while (toolbardef[i].label != NULL) {
    if (strlen(toolbardef[i].label) == 0) {
      gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));
    } else {
      GtkWidget *gtkpix = create_pixmap(ref,
					toolbardef[i].pixmap,
					toolbardef[i].grey_pixmap);
      GtkWidget *but_vbox;
      
      but_vbox = gtk_toolbar_append_item(GTK_TOOLBAR(toolbar),
					 toolbardef[i].label,
					 toolbardef[i].tooltip,
					 "Private",
					 gtkpix,
					 toolbardef[i].callback,
					 toolbardef[i].data);
      
      *toolbardef[i].store_to = but_vbox;
    }
    i++;
  }
  
  return toolbar;
}
