/*
 * gpal - A friendly GUI frontend for the PayPal micropayment service
 * Copyright (C) 2001 Alp Toker <alp@atoker.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include <stdio.h>

#include <stdlib.h>
#include <string.h>
#include "libgpal.h"
#include "gpal.h"

#include "extra/aboutstr.h"


void on_login_clicked(GtkButton * button, gpointer user_data)
{
    GtkWidget *msgstat = lookup_widget(GTK_WIDGET(button), "msgstat");

    if (line_status == 0) {

	if (pp_login(alogin, apass) == 0) {
	    rec_event(GTK_WIDGET(button), _("Unable to login"));
	    change_stat(GTK_WIDGET(button), 0);
	} else {
	    rec_event(GTK_WIDGET(button), _("Logged in"));
	    change_stat(GTK_WIDGET(button), 1);

	    gtk_entry_set_text(GTK_ENTRY(lookup_widget(GTK_WIDGET(button), "entry2")), g_strdup_printf("%3.2f", pp_getbalance()));	// check balance

	}

    } else {
	pp_logout();
	gtk_label_set_text(GTK_LABEL(msgstat), _("Logged off"));
	change_stat(GTK_WIDGET(button), 0);
    }
}

int transact(GtkWidget * button, int trans_type)
{
    char *p;
    char toaddr[256];
    char optarg[8];
    int dollar = 0;
    int cent = 0;

    GtkWidget *entry3 = lookup_widget(GTK_WIDGET(button), "entry3");
    GtkWidget *entry4 = lookup_widget(GTK_WIDGET(button), "entry4");

    strncpy(toaddr, gtk_entry_get_text(GTK_ENTRY(entry3)), sizeof(toaddr));
    strncpy(optarg, gtk_entry_get_text(GTK_ENTRY(entry4)), sizeof(optarg));

    //TODO: move this to validate() and use strtol to check for errors
    if ((p = strstr(optarg, "."))) {
	p++;
	cent = atoi(p);
	dollar = atoi(optarg);
    } else {
	dollar = atoi(optarg);
    }

    if (trans_type == 0) {
	rec_event(button, _("Sending money"));
	if (pp_send(toaddr, dollar, cent) == 0)
	    rec_event(button, _("Error: Money not sent"));
	else {
	    gtk_entry_set_text(GTK_ENTRY(lookup_widget(GTK_WIDGET(button), "entry2")), g_strdup_printf("%3.2f", pp_getbalance()));	// check balance
	    rec_event(button, _("Money sent"));
	    gtk_entry_set_text(GTK_ENTRY(entry3), "");
	    gtk_entry_set_text(GTK_ENTRY(entry4), "");
	}
    } else if (trans_type == 1) {
	rec_event(button, _("Requesting money"));
	if (pp_request(toaddr, dollar, cent) == 0)
	    rec_event(button, _("Error: Money not requested"));
	else {
	    rec_event(button, _("Money requested"));
	    gtk_entry_set_text(GTK_ENTRY(entry3), "");
	    gtk_entry_set_text(GTK_ENTRY(entry4), "");
	}
    }
    return 1;
}


void on_pay_clicked(GtkButton * button, gpointer user_data)
{
    transact(GTK_WIDGET(button), 0);
}


void on_request_clicked(GtkButton * button, gpointer user_data)
{
    transact(GTK_WIDGET(button), 1);
}


void on_login_changed(GtkEditable * editable, gpointer user_data)
{
    validate(GTK_WIDGET(editable));
}


gboolean
on_window1_delete_event(GtkWidget * widget,
			GdkEvent * event, gpointer user_data)
{
    // Waiting to logout on exit could piss people off greatly. So let's do it.
    if (line_status)
	pp_logout();
    gtk_main_quit();
    return TRUE;
}


void on_about_clicked(GtkButton * button, gpointer user_data)
{
    GtkWidget *window;
    GtkWidget *vbox, *okbutton, *label;

    /* create a new window */
    window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);
    gtk_window_set_modal(GTK_WINDOW(window), TRUE);

    gtk_window_set_title(GTK_WINDOW(window), _("About gPal"));

    label = gtk_label_new(g_strdup_printf(about_str, VERSION));

    //gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);
    gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);

    okbutton = gtk_button_new_with_label(_("OK"));

    gtk_signal_connect_object(GTK_OBJECT(okbutton), "clicked",
			      GTK_SIGNAL_FUNC(gtk_widget_destroy),
			      GTK_OBJECT(window));

    vbox = gtk_vbox_new(FALSE, 10);
    gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox), okbutton, FALSE, FALSE, 0);

    gtk_container_set_border_width(GTK_CONTAINER(vbox), 5);

    gtk_container_add(GTK_CONTAINER(window), vbox);

    gtk_widget_show_all(window);
    gtk_grab_add(window);
    gtk_widget_grab_focus(okbutton);

}

void on_histbtn_clicked(GtkButton * button, gpointer user_data)
{
    GtkWidget *window;
    GtkWidget *vbox, *hbox, *vscrollbar, *okbutton, *label;
    char hist[1024];

    /* create a new window */
    window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    //gtk_window_set_policy (GTK_WINDOW (window), FALSE, FALSE, FALSE);
    gtk_window_set_modal(GTK_WINDOW(window), TRUE);

    gtk_window_set_title(GTK_WINDOW(window), _("Account history"));

    hbox = gtk_hbox_new(FALSE, 0);
    label = gtk_text_new(NULL, NULL);
    vscrollbar = gtk_vscrollbar_new (GTK_TEXT(label)->vadj);

  gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(hbox), vscrollbar, FALSE, FALSE, 0);


    //gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);
    //gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);

    okbutton = gtk_button_new_with_label(_("OK"));

    gtk_signal_connect_object(GTK_OBJECT(okbutton), "clicked",
			      GTK_SIGNAL_FUNC(gtk_widget_destroy),
			      GTK_OBJECT(window));

    vbox = gtk_vbox_new(FALSE, 10);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(vbox), okbutton, FALSE, FALSE, 0);

    gtk_container_set_border_width(GTK_CONTAINER(vbox), 5);

    gtk_container_add(GTK_CONTAINER(window), vbox);

    gtk_widget_show_all(window);
    gtk_grab_add(window);
    gtk_widget_grab_focus(okbutton);

    //TODO: GUI: copy to clipboard button?

    pp_history(hist);
    //gtk_text_freeze (GTK_TEXT (label)); //redundant

    gtk_text_insert(GTK_TEXT(label), NULL, &label->style->black, NULL,
		    hist, -1);
    //gtk_text_thaw (GTK_TEXT (label));

}


void on_transact_changed(GtkEditable * editable, gpointer user_data)
{
    //enable/disable send/rec buttons
    validate(GTK_WIDGET(editable));
}

gboolean
on_entry1_key_press_event              (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
  //TODO: login when Return key pressed on password box
  /*
  if (event->keyval == 65293) {
  }
  */
  return FALSE;
}
