/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Modified by the GTK+ Team and others 1997-1999.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/. 
 */

/*
 * Modified by Jorn Baayen <jorn@nl.linux.org> 2001 to inherit tab bg
 * color, for the Galeon browser.
 */

#ifndef __TAB_BUTTON_H__
#define __TAB_BUTTON_H__


#include <gdk/gdk.h>
#include <gtk/gtkbin.h>
#include <gtk/gtkenums.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define TAB_TYPE_BUTTON			(tab_button_get_type ())
#define TAB_BUTTON(obj)			(GTK_CHECK_CAST ((obj), TAB_TYPE_BUTTON, TabButton))
#define TAB_BUTTON_CLASS(klass)		(GTK_CHECK_CLASS_CAST ((klass), TAB_TYPE_BUTTON, TabButtonClass))
#define TAB_IS_BUTTON(obj)		(GTK_CHECK_TYPE ((obj), TAB_TYPE_BUTTON))
#define TAB_IS_BUTTON_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((klass), TAB_TYPE_BUTTON))


typedef struct _TabButton       TabButton;
typedef struct _TabButtonClass  TabButtonClass;

struct _TabButton
{
  GtkBin bin;

  GtkWidget *child /* deprecapted field,
		    * use GTK_BIN (button)->child instead
		    */;

  guint in_button : 1;
  guint button_down : 1;
  guint relief : 2;
};

struct _TabButtonClass
{
  GtkBinClass        parent_class;
  
  void (* pressed)  (TabButton *button);
  void (* released) (TabButton *button);
  void (* clicked)  (TabButton *button);
  void (* enter)    (TabButton *button);
  void (* leave)    (TabButton *button);
};


GtkType        tab_button_get_type       (void);
GtkWidget*     tab_button_new            (void);
GtkWidget*     tab_button_new_with_label (const gchar *label);
void           tab_button_pressed        (TabButton *button);
void           tab_button_released       (TabButton *button);
void           tab_button_clicked        (TabButton *button);
void           tab_button_enter          (TabButton *button);
void           tab_button_leave          (TabButton *button);
void           tab_button_set_relief     (TabButton *button,
					  GtkReliefStyle newstyle);
GtkReliefStyle tab_button_get_relief      (TabButton *button);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __TAB_BUTTON_H__ */
