/*
 *  Copyright (C) 2001 Jorn Baayen
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "galeon.h"
#include "window.h"
#include "persistent_data_manager.h"

#include <gtk/gtkclist.h>
#include <gdk/gdkkeysyms.h>
#include <libgnome/libgnome.h>
#include <libgnome/gnome-i18n.h>
#include <libgnomeui/gnome-dialog.h>
#include <libgnomeui/gnome-dialog-util.h>

/* dialog function prototypes */
void persistent_data_manager_abandon_clicked_cb (GtkWidget *b,
						 PDMDialog *pd);
void persistent_data_manager_close_clicked_cb (GtkWidget *b,
					       PDMDialog *pd);
gint persistent_data_manager_dialog_close_cb (GtkWidget *w,
					      PDMDialog *pd);
void persistent_data_manager_click_column_cb (GtkCList *clist,
					      gint column,
					      PDMDialog *pd);

/* cookie page function prototypes */
void persistent_data_manager_select_cookie_row_cb (GtkCList *clist,
						   gint row, gint column,
				    		   GdkEventButton *event, 
				    		   PDMDialog *pd);
void persistent_data_manager_unselect_cookie_row_cb (GtkCList *clist,
						   gint row, gint column,
				    		   GdkEventButton *event, 
				    		   PDMDialog *pd);
void persistent_data_manager_remove_cookie_clicked_cb (GtkWidget *b,
						   PDMDialog *pd);
void persistent_data_manager_remove_and_block_cookie_clicked_cb (
						   GtkWidget *b,
						   PDMDialog *pd);
void persistent_data_manager_remove_all_cookies_clicked_cb (
						   GtkWidget *b,
						   PDMDialog *pd);
void persistent_data_manager_cookie_key_press_cb (GtkWidget *w,
						   GdkEventKey *event,
						   PDMDialog *pd);


/* cookie sites page function prototypes */
void persistent_data_manager_select_cookie_site_row_cb (GtkCList *clist,
						   gint row, gint column,
				    		   GdkEventButton *event, 
				    		   PDMDialog *pd);
void persistent_data_manager_unselect_cookie_site_row_cb (
						   GtkCList *clist,
						   gint row,
						   gint column,
				    		   GdkEventButton *event, 
				    		   PDMDialog *pd);
void persistent_data_manager_remove_cookie_site_clicked_cb (
						   GtkWidget *b,
						   PDMDialog *pd);
void persistent_data_manager_remove_all_cookie_site_clicked_cb (
						   GtkWidget *b,
						   PDMDialog *pd);
void persistent_data_manager_cookie_site_key_press_cb (GtkWidget *w,
						   GdkEventKey *event,
						   PDMDialog *pd);

/* images sites page function prototypes */
void persistent_data_manager_select_image_site_row_cb (GtkCList *clist,
						   gint row, gint column,
				    		   GdkEventButton *event, 
				    		   PDMDialog *pd);
void persistent_data_manager_unselect_image_site_row_cb (
						   GtkCList *clist,
						   gint row,
						   gint column,
				    		   GdkEventButton *event, 
				    		   PDMDialog *pd);
void persistent_data_manager_remove_image_site_clicked_cb (
						   GtkWidget *b,
						   PDMDialog *pd);
void persistent_data_manager_remove_all_image_site_clicked_cb (
						   GtkWidget *b,
						   PDMDialog *pd);
void persistent_data_manager_image_site_key_press_cb (GtkWidget *w,
						   GdkEventKey *event,
						   PDMDialog *pd);

/* passwords page function prototypes */
void persistent_data_manager_select_password_row_cb (GtkCList *clist,
						   gint row, gint column,
				    		   GdkEventButton *event, 
				    		   PDMDialog *pd);
void persistent_data_manager_unselect_password_row_cb (GtkCList *clist,
						   gint row,
						   gint column,
				    		   GdkEventButton *event, 
				    		   PDMDialog *pd);
void persistent_data_manager_remove_password_clicked_cb (GtkWidget *b,
						   PDMDialog *pd);
void persistent_data_manager_remove_all_passwords_clicked_cb (
						   GtkWidget *b,
						   PDMDialog *pd);
void persistent_data_manager_password_key_press_cb (GtkWidget *w,
						   GdkEventKey *event,
						   PDMDialog *pd);

/* passwords sites page function prototypes */
void persistent_data_manager_select_password_site_row_cb (
						   GtkCList *clist,
						   gint row, gint column,
				    		   GdkEventButton *event, 
				    		   PDMDialog *pd);
void persistent_data_manager_unselect_password_site_row_cb (
						   GtkCList *clist,
						   gint row,
						   gint column,
				    		   GdkEventButton *event, 
				    		   PDMDialog *pd);
void persistent_data_manager_remove_password_site_clicked_cb (
						   GtkWidget *b,
						   PDMDialog *pd);
void persistent_data_manager_remove_all_password_site_clicked_cb (
						   GtkWidget *b,
						   PDMDialog *pd);
void persistent_data_manager_password_site_key_press_cb (GtkWidget *w,
						   GdkEventKey *event,
						   PDMDialog *pd);

/* dialog functions */
void
persistent_data_manager_abandon_clicked_cb (GtkWidget *b, PDMDialog *pd)
{
	/* close the dialog */
	gnome_dialog_close (GNOME_DIALOG (pd->dialog));
}

void
persistent_data_manager_close_clicked_cb (GtkWidget *b, PDMDialog *pd)
{
	/* apply changes and close the dialog */
	pdm_apply ();
	gnome_dialog_close (GNOME_DIALOG (pd->dialog));
}

gint
persistent_data_manager_dialog_close_cb (GtkWidget *w, PDMDialog *pd)
{
	pdm_close ();

	/* return false, so the GnomeDialog will be destroyed */
	return FALSE;
}

/* cookie page functions */
void
persistent_data_manager_select_cookie_row_cb (GtkCList *clist,
					      gint row, gint column,
				    	      GdkEventButton *event, 
				    	      PDMDialog *pd)
{
	pdm_update_cookie_view ((Cookie *) gtk_clist_get_row_data (clist, row));
}

void
persistent_data_manager_unselect_cookie_row_cb (GtkCList *clist,
						gint row, gint column,
				    		GdkEventButton *event, 
				    		PDMDialog *pd)
{
	pdm_update_cookie_view ((Cookie *) gtk_clist_get_row_data (clist, row));
}

void
persistent_data_manager_remove_cookie_clicked_cb (GtkWidget *b,
						  PDMDialog *pd)
{
	GtkCList *clist = GTK_CLIST (pd->cookie_clist);
	GList *remove = NULL;
	GList *l;

	gtk_clist_freeze (clist);
	
	for (l = clist->selection; l; l = g_list_next (l))
	{
		gint row = GPOINTER_TO_INT (l->data);
		remove = g_list_append (remove,
					gtk_clist_get_row_data (clist, row)); 
	}
	
	for (l = remove; l; l = g_list_next (l))
	{
		pdm_remove_cookie ((Cookie *) l->data, FALSE);
	}

	gtk_clist_thaw (clist);
	g_list_free (remove);
}

void
persistent_data_manager_remove_and_block_cookie_clicked_cb (GtkWidget *b,
						   	    PDMDialog *pd)
{
	GtkCList *clist = GTK_CLIST (pd->cookie_clist);
	GList *remove = NULL;
	GList *l;

	gtk_clist_freeze (clist);
	
	for (l = clist->selection; l; l = g_list_next (l))
	{
		gint row = GPOINTER_TO_INT (l->data);
		remove = g_list_append (remove,
					gtk_clist_get_row_data (clist, row)); 
	}
	
	for (l = remove; l; l = g_list_next (l))
	{
		pdm_remove_cookie ((Cookie *) l->data, TRUE);
	}

	gtk_clist_thaw (clist);
	g_list_free (remove);
}

void
persistent_data_manager_remove_all_cookies_clicked_cb (GtkWidget *b,
						       PDMDialog *pd)
{
	GtkCList *clist = GTK_CLIST (pd->cookie_clist);
	gint i;

	gtk_clist_freeze (clist);

	for (i = clist->rows - 1; i >= 0; i--)
	{
		Cookie *c = (Cookie *) gtk_clist_get_row_data (clist, i);

		pdm_remove_cookie (c, FALSE);
	}

	gtk_clist_thaw (clist);
}

void
persistent_data_manager_cookie_key_press_cb (GtkWidget *w,
				             GdkEventKey *event,
					     PDMDialog *pd)
{
	if (event->state == 0 &&
	   (event->keyval == GDK_Delete || event->keyval == GDK_KP_Delete))
	{
		persistent_data_manager_remove_cookie_clicked_cb (w, pd);
	}
}

/* cookie sites page functions */
void
persistent_data_manager_select_cookie_site_row_cb (GtkCList *clist,
						    gint row, gint column,
				    		    GdkEventButton *event, 
				    		    PDMDialog *pd)
{
	pdm_update_cookie_sites_view (
		(BlockedHost *) gtk_clist_get_row_data (clist, row));
}

void
persistent_data_manager_unselect_cookie_site_row_cb (GtkCList *clist,
						      gint row,
						      gint column,
				    		      GdkEventButton *event, 
				    		      PDMDialog *pd)
{
	pdm_update_cookie_sites_view (
		(BlockedHost *) gtk_clist_get_row_data (clist, row));
}

void
persistent_data_manager_remove_cookie_site_clicked_cb (GtkWidget *b,
						       PDMDialog *pd)
{
	GtkCList *clist = GTK_CLIST (pd->cookie_site_clist);
	GList *remove = NULL;
	GList *l;

	gtk_clist_freeze (clist);
	
	for (l = clist->selection; l; l = g_list_next (l))
	{
		gint row = GPOINTER_TO_INT (l->data);
		remove = g_list_append (remove,
					gtk_clist_get_row_data (clist, row)); 
	}
	
	for (l = remove; l; l = g_list_next (l))
	{
		pdm_remove_cookie_site ((BlockedHost *) l->data);
	}

	gtk_clist_thaw (clist);
	g_list_free (remove);
}

void
persistent_data_manager_remove_all_cookie_site_clicked_cb (GtkWidget *b,
						            PDMDialog *pd)
{
	GtkCList *clist = GTK_CLIST (pd->cookie_site_clist);
	gint i;

	gtk_clist_freeze (clist);

	for (i = clist->rows - 1; i >= 0; i--)
	{
		BlockedHost *c =
			(BlockedHost *) gtk_clist_get_row_data (clist, i);

		pdm_remove_cookie_site (c);
	}

	gtk_clist_thaw (clist);
}

void
persistent_data_manager_cookie_site_key_press_cb (GtkWidget *w,
				                  GdkEventKey *event,
					          PDMDialog *pd)
{
	if (event->state == 0 &&
	   (event->keyval == GDK_Delete || event->keyval == GDK_KP_Delete))
	{
		persistent_data_manager_remove_cookie_site_clicked_cb (w, pd);
	}
}

/* images sites page functions */
void
persistent_data_manager_select_image_site_row_cb (GtkCList *clist,
						   gint row, gint column,
				    		   GdkEventButton *event, 
				    		   PDMDialog *pd)
{
	pdm_update_image_sites_view (
		(BlockedHost *) gtk_clist_get_row_data (clist, row));
}

void
persistent_data_manager_unselect_image_site_row_cb (GtkCList *clist,
						     gint row,
						     gint column,
				    		     GdkEventButton *event, 
				    		     PDMDialog *pd)
{
	pdm_update_image_sites_view (
		(BlockedHost *) gtk_clist_get_row_data (clist, row));
}

void
persistent_data_manager_remove_image_site_clicked_cb (GtkWidget *b,
						      PDMDialog *pd)
{
	GtkCList *clist = GTK_CLIST (pd->image_site_clist);
	GList *remove = NULL;
	GList *l;

	gtk_clist_freeze (clist);
	
	for (l = clist->selection; l; l = g_list_next (l))
	{
		gint row = GPOINTER_TO_INT (l->data);
		remove = g_list_append (remove,
					gtk_clist_get_row_data (clist, row)); 
	}
	
	for (l = remove; l; l = g_list_next (l))
	{
		pdm_remove_image_site ((BlockedHost *) l->data);
	}

	gtk_clist_thaw (clist);
	g_list_free (remove);
}

void
persistent_data_manager_remove_all_image_site_clicked_cb (GtkWidget *b,
						           PDMDialog *pd)
{
	GtkCList *clist = GTK_CLIST (pd->image_site_clist);
	gint i;

	gtk_clist_freeze (clist);

	for (i = clist->rows - 1; i >= 0; i--)
	{
		BlockedHost *c =
			(BlockedHost *) gtk_clist_get_row_data (clist, i);

		pdm_remove_image_site (c);
	}

	gtk_clist_thaw (clist);
}

void
persistent_data_manager_image_site_key_press_cb (GtkWidget *w,
				                 GdkEventKey *event,
					         PDMDialog *pd)
{
	if (event->state == 0 &&
	   (event->keyval == GDK_Delete || event->keyval == GDK_KP_Delete))
	{
		persistent_data_manager_remove_image_site_clicked_cb (w, pd);
	}
}

/* passwords page functions */
void
persistent_data_manager_select_password_row_cb (GtkCList *clist,
						gint row, gint column,
				    		GdkEventButton *event, 
				    		PDMDialog *pd)
{
	pdm_update_password_view (
		(Password *) gtk_clist_get_row_data (clist, row));
}

void
persistent_data_manager_unselect_password_row_cb (GtkCList *clist,
						  gint row,
						  gint column,
				    		  GdkEventButton *event, 
				    		  PDMDialog *pd)
{
	pdm_update_password_view (
		(Password *) gtk_clist_get_row_data (clist, row));
}

void
persistent_data_manager_remove_password_clicked_cb (GtkWidget *b,
						    PDMDialog *pd)
{
	GtkCList *clist = GTK_CLIST (pd->password_clist);
	GList *remove = NULL;
	GList *l;

	gtk_clist_freeze (clist);
	
	for (l = clist->selection; l; l = g_list_next (l))
	{
		gint row = GPOINTER_TO_INT (l->data);
		remove = g_list_append (remove,
					gtk_clist_get_row_data (clist, row)); 
	}
	
	for (l = remove; l; l = g_list_next (l))
	{
		pdm_remove_password ((Password *) l->data);
	}

	gtk_clist_thaw (clist);
	g_list_free (remove);
}

void
persistent_data_manager_remove_all_passwords_clicked_cb (GtkWidget *b,
						         PDMDialog *pd)
{
	GtkCList *clist = GTK_CLIST (pd->password_clist);
	gint i;

	gtk_clist_freeze (clist);

	for (i = clist->rows - 1; i >= 0; i--)
	{
		Password *p = (Password *) gtk_clist_get_row_data (clist, i);

		pdm_remove_password (p);
	}

	gtk_clist_thaw (clist);
}

void
persistent_data_manager_password_key_press_cb (GtkWidget *w,
				               GdkEventKey *event,
					       PDMDialog *pd)
{
	if (event->state == 0 &&
	   (event->keyval == GDK_Delete || event->keyval == GDK_KP_Delete))
	{
		persistent_data_manager_remove_password_clicked_cb (w, pd);
	}
}

/* passwords sites page functions */
void
persistent_data_manager_select_password_site_row_cb (GtkCList *clist,
						      gint row, gint column,
				    		      GdkEventButton *event, 
				    		      PDMDialog *pd)
{
	pdm_update_password_sites_view (
		(Password *) gtk_clist_get_row_data (clist, row));
}

void
persistent_data_manager_unselect_password_site_row_cb (GtkCList *clist,
						        gint row,
						        gint column,
				    		        GdkEventButton *event, 
				    		        PDMDialog *pd)
{
	pdm_update_password_sites_view (
		(Password *) gtk_clist_get_row_data (clist, row));
}

void
persistent_data_manager_remove_password_site_clicked_cb (GtkWidget *b,
						         PDMDialog *pd)
{
	GtkCList *clist = GTK_CLIST (pd->password_site_clist);
	GList *remove = NULL;
	GList *l;

	gtk_clist_freeze (clist);
	
	for (l = clist->selection; l; l = g_list_next (l))
	{
		gint row = GPOINTER_TO_INT (l->data);
		remove = g_list_append (remove,
					gtk_clist_get_row_data (clist, row)); 
	}
	
	for (l = remove; l; l = g_list_next (l))
	{
		pdm_remove_password_site ((Password *) l->data);
	}

	gtk_clist_thaw (clist);
	g_list_free (remove);
}

void
persistent_data_manager_remove_all_password_site_clicked_cb (GtkWidget *b,
						              PDMDialog *pd)
{
	GtkCList *clist = GTK_CLIST (pd->password_site_clist);
	gint i;

	gtk_clist_freeze (clist);

	for (i = clist->rows - 1; i >= 0; i--)
	{
		Password *c = (Password *) gtk_clist_get_row_data (clist, i);

		pdm_remove_password_site (c);
	}

	gtk_clist_thaw (clist);
}

void
persistent_data_manager_password_site_key_press_cb (GtkWidget *w,
				                    GdkEventKey *event,
					            PDMDialog *pd)
{
	if (event->state == 0 &&
	   (event->keyval == GDK_Delete || event->keyval == GDK_KP_Delete))
	{
		persistent_data_manager_remove_password_site_clicked_cb (w, pd);
	}
}

void
persistent_data_manager_click_column_cb (GtkCList *clist, gint column,
					 PDMDialog *pd)
{
	gtk_clist_set_sort_column (clist, column);
	gtk_clist_sort (clist);
}
