/********************************************************************************
 *   Jabberoo/Judo -- C++ Jabber Library                                        *
 *                                                                              * 
 *   Copyright (C) 1999-2000 Dave Smith (dave@jabber.org)                       *
 *                                                                              *
 *   This library is free software; you can redistribute it and/or              *
 *   modify it under the terms of the GNU Lesser General Public                 *
 *   License as published by the Free Software Foundation; either               *
 *   version 2.1 of the License, or (at your option) any later version.         *
 *                                                                              *
 *   This library is distributed in the hope that it will be useful,            *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          *
 *   Lesser General Public License for more details.                            *
 *                                                                              *
 *   You should have received a copy of the GNU Lesser General Public           *
 *   License along with this library; if not, write to the Free Software        *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 ********************************************************************************
 */


#include <judo.hh>

// *************************************************************************
//
// Judo::Element
//
// *************************************************************************
using namespace judo;


const string& Element::getName() const
{
    return _name;
}

Element::Type Element::getType() const
{
    return _type;
}

Element::Element(const string& name, Element::Type etype)
     : _name(name),
       _type(etype)
{}

// Operators
bool judo::operator==(const Element& lhs, Element::Type rhs)
{
     return bool(lhs._type == rhs);
}

bool judo::operator==(const Element& lhs, const string& rhs)
{
     return lhs._name == rhs;
}


