===========================================================================
                                ettercap 0.6.2
============================================================================


       @@@@@@@ @@@@@@@ @@@@@@@ @@@@@@@ @@@@@@@ @@@@@@@ @@@@@@@ @@@@@@@
       @@        @@@     @@@   @@      @@   @@ @@      @@   @@ @@   @@
       @@@@@@    @@@     @@@   @@@@@@  @@@@@@  @@      @@@@@@@ @@@@@@
       @@        @@@     @@@   @@      @@  @@  @@      @@   @@ @@
       @@@@@@@   @@@     @@@   @@@@@@@ @@  @@@ @@@@@@@ @@   @@ @@



            @@@@@@@ @@      @@   @@ @@@@@@@ @@@@ @@@@@@@ @@@@@@@
            @@   @@ @@      @@   @@ @@       @@  @@   @@ @@
            @@@@@@@ @@      @@   @@ @@  @@@  @@  @@   @@ @@@@@@@
            @@      @@      @@   @@ @@   @@  @@  @@   @@      @@
            @@      @@@@@@@ @@@@@@@ @@@@@@@ @@@@ @@   @@ @@@@@@@



        Bibliothques ncessaires :             ettercap ;)

        Installation :                          configure --enable-plugins
                                                make plug-ins
                                                make plug-ins_install

============================================================================
                          TABLE DES MATIERES
============================================================================


   1. INSTALLATION..........................................sez.  1

   2. UTILISATION...........................................sez.  2

      2.1   PLUGINS EXTERNES
         2.1.1   interface ncurses
         2.1.2   ligne de commande
      2.2   PLUGINS D'ACCROCHE

   3. CREATION D'UN PLUGIN..................................sez   3

   APPENDICE A: Illithid illustr

============================================================================
1>                              INSTALLATION
============================================================================


 Pour installer des plugins, vous devez faire :

   configure --enable-plugins  (activ par dfaut)
   make plug-ins
   make plug-ins_install

 ceci crra tous les plugins dans le rpertoire plugins et les installera
 dans le rpertoire spcifi dans configure.

 Si vous programmez un nouveau plugin, crez simplement un nouveau rpertoire
 du nom de votre plugin dans le rpertoire plugins et placez y le code source
 et un petit Makefile. Les plugins doivent avoir cette forme : ec_'name'.so

 L'installation sera alors automatique.

NOTE :

 La recherche des plugins se fait d'abord dans ./ puis dans le rpertoire 
 d'installation.


============================================================================
2>                           UTILISATION
============================================================================

2.1   PLUGIN EXTERNE

 Les plugins externes sont ceux dont le type (plug_type) est PT_EXT, et 
 correspondent aux vieux plugins (avant ettercap 0.6.2)

   2.1.1   INTERFACE NCURSES

      Dans l'interface principale appuyez sur 'p' et vous obtiendrez la liste 
      de tous les plugins disponibles. Choisissez en un et amusez vous... ;)

   2.1.2   LIGNE DE COMMANDE

       Utilisez:

          ettercap -N -p list

       pour obtenir la liste des plugins disponibles. Puis lancez

          ettercap -N -p "nom du plugin"

       pour executer le plugin en question.

       Exemple :
 
         ettercap -Np ooze ghibli

      lancera "ooze" sur l'hote "ghibli". ( le plugin ooze fait un ping sur
      l'hote destination...)

      c'est tout !!

2.2 PLUGINS D'ACCROCHE

 Les plugins "d'accroche" ont t introduits dans ettercap 0.6.2 et peuvent
 interagir avec ettercap. La principale ide est de fournir certains points
 d'accroche dans le moteur de sniff pour qu'un programmeur puisse lancer
 ses propres fonctions  ces niveaux.
 De cette manire quelqu'un peut programmer un plugin qui a besoin de certaines
 donnes sniffes, que ce soit sur un lan switch ou non, et tout le travail
 derrire est effectu par ettercap, et est totalement transparent pour le
 plugin, mme s'il est ncessaire de corrompre les victimes. Seules les donnes
 sniffes seront passes au plugin par ettercap. Il y a beaucoup de points
 d'accroche, donc il peut y avoir diffrents type de plugins, par exemple un 
 nouveau dissecteur, ou un plugin de log, ou mme un IDS si vous voulez ... ;)
 Ce type de plugin est charg par l'interface ou par le fichier de 
 configuration si vous lancez ettercap par la ligne de commande. Et leur ordre
 d'excution est configur  la manire d'un init.d. Les plugins d'accroche ont
 un prfix de 4 caractres "Hxx_" qui informent ettercap sur la priorit (xx
 peut varier de 00  99). La raison  cela est que plusieurs plugins peuvent
 est excut squentiellement sur le mme point d'accroche, et que, comme un
 plugin peut modifier les donnes sniffes, le prochain sera affect par les 
 modifications prcdentses.

============================================================================
3>                         HOW TO CREATE A PLUGIN
============================================================================


 Je pense qu'un exemple est plus efficace que des pages d'explication. Donc
 j'ai cris deux plugins exemples pour montrer comment crire un simple plugin.
 Un, appel "simplet", pour montrer comment crire un plugin externe, et un 
 autre appel "H99_simplet", pour les plugins d'accroche.

 Cependant il y a quelques instructions que vous devez respecter.

 1) LES INCLUDES

      #include "../../src/include/ec_main.h"     // pour les variables globales
      #include "../../src/include/ec_plugins.h"  // pour les entres/sorties

      ceux-ci sont obligatoires, mais vous pouvez en inclure autant que vous
      voulez. Pour avoir la liste des API que vous pouvez utiliser, regardez
      dans ./src/include. Les seuls API que vous ne POUVEZ PAS utiliser dans un
      plugin sont les ec_interface_*.

 2) OPERATION DE PLUGIN

      struct plugin_ops ops = {
         ettercap_version: VERSION,
         plug_info:        "petite descriptoin",
         plug_version:     20,
         plug_type:        PT_HOOK,
         hook_point:       PCK_DECODED,
         hook_function:    &dummy_function,
      };

      tous les plugins doivent remplir cette structure avec les champs 
      appropris. Cette structure DOIT tre passe  la fonction 
      Plugin_Register(...) lors de l'initialisation (voir ci-dessus).

      ettercap_version : DOIT correspondre  la VERSION GLOBALE (pour les tests
                         internes)

      plug_info :        c'est une chane de donnes contenant un description 
                         courte (50 charactres);

      plug_version :     c'est un caractre indiquant la version (notez que 15
                         correspond  la version 1.5)

      plug_type :        peut valoir PT_EXT (pour les plugins externes) ou
                         PT_HOOK (pour les plugins d'accroche)
 
      hook_point :       c'est le point d'accroche (voir ci-dessus pour une 
                         liste des points d'accroche)

      hook_function :    c'est un pointeur sur la fonction  excuter au niveau
                         du point d'accroche. Doit tre "int ($func)(void *)"

 3) INITIALISATION ET FINALISATION

      Tous les plugins DOIVENT contenir deux fonctions. La premire pour 
      l'initialisation et la seconde excute lorsque le plugin est dcharg.

      int Plugin_Init(void *params)
      {
        /*
         *  dans cette fonction nous DEVONS appeler la procdure 
         *  d'enregistrement qui configurera le plugin en fonction de la 
         *  structure plugin_ops.
         *  la valeur retourne DOIT tre la mme que Plugin_Register()
         *  le pointeur pass en paramtre 'params' DOIT tre pass  
         *  Plugin_Register()
         */
         return Plugin_Register(params, &ops);
       }

      int Plugin_Fini(void *params)
      {
         /*
          * Ici vous pouvez librer toutes les ressources alloues
          */
         return 0;
      }

      TRES IMPORTANT : Le plugin ne doit PAS finir par exit() !!

 4) POINT D'ACCROCHE

      HOOK_NONE           rserv pour les plugins externes

      PCK_RECEIVED_RAW    le plugin est excut juste aprs que le paquet
                          est reu, avant que illithid ne le parse, donc
                          les donnes modifies ici vont interfrer avec le
                          boulot d'illithid.
                          le pointeur void * pointeur sur le buffer 
                          correspondant au paquet tel qu'il est reu de la
                          couche liaison de donnes, donc vous devrez le 
                          dcapsuler du header ethernet.

      PCK_RECEIVED_STRUCT_FILLED le plugin est excut juste aprs l'analyse 
                          d'illithid mais avant de passer les donnes 
                          ettercap. le pointeur void * correspond  une 
                          structure SNIFFED_DATA

      PCK_PRE_FORWARD     le plugin est excut avant que le paquet ne soit
                          renvoy (videmment seulement si ettercap fait de la
                          corruption de cache arp). modifier les donnes ici
                          changera seulement le paquet forward, car illithid 
                          l'a dj dcod, enregistr la session correspondante
                          et envoy  ettercap les donnes sniffes.
                          le pointeur void * pointeur sur le buffer 
                          correspondant au paquet tel qu'il est reu de la
                          couche liaison de donnes, donc vous devrez le 
                          dcapsuler du header ethernet.

      PCK_DISSECTOR       le plugin est excut juste aprs que les autres 
                          dissecteur intgrs ont t excut.
                          le pointeur void * correspond  une structure 
                          DISSECTION.

      PCK_DECODED         le plugin est excut aprs que dissecteurs actifs ont
                          t excuts (les dissecteurs actifs sont ceux qui 
                          modifient les donnes avant de les envoyer  ettercap.
                          par exemple SSH, HTTPS, ICQ sont des protocoles 
                          encrypts, donc les donnes doivent tre dcryptes
                          avant la vue utilisateur)
                          le pointeur void * pointe sur une structure 
                          SNIFFED_DATA


      refrer vous  l'APPENDICE A pour avoir une vue complte du systme
      d'accroche.

 5) API ETTERCAP
       
      + Plugin_Output()   pareil que printf(), mais ncessaire pour afficher
                          dans l'interface ncurses.

      + Plugin_Input()    pour demander des donnes  l'utilisateur.

      NOTE : les plugins d'accroche ne DOIVENT PAS utiliser ces fonctions !!
 
      + Plugin_Hook_Output()  identique aux fonctions ci-dessus pour les
                              plugins d'accroche.

      NOTE : tous les appels  Plugin_Hook_Output() provoquent le flush de
             donnes de sortie prcdentes. Donc crez entirement les donnes
              afficher avant de les envoyer. Vous avez seulement trois lignes
             de donnes de sorties et chaque ligne  une longueur minimal de 80
             mais elle peut tre plus large que l'cran;

      + Toutes les autres fonctions dans ec_inet_forge.c, ec_inet.c et
        ec_decodedata.c vous fournissent un accs simple  l'interface
        vers la couche rseau.


  N'hsitez pas  crire un email  alor@users.sourceforge.net
                               ou  crwm@freemail.it


============================================================================
APPENDIX A>                 ILLITHID ILLUSTRE
============================================================================

 Voici un rprsentation en langague trs haut niveau du comportement de
 illithid :

 loop
 {
   Recoit un paquet de la couche liaison de donnes

   HOOK POINT: PCK_RECEIVED_RAW  (void * pointer -> received buffer)

   Analyse le buffer  travers les couches 2, 3 et 4

   *** Seuls les paquets UDP et TCP sont accepts ci-desssous ***

   Remplit la structure CONNECTION

   Excute les dissecteurs intgrs (qui remplissent les champs user, pass et 
   info)

   HOOK POINT: PCK_DISSECTOR  (void * pointer -> DISSECTION structure)

   Met  jour le tableau des connexions affich par ettercap

   if (connection_mode == 0)
   {
      Remplit la structure SNIFFED_DATA

      HOOK POINT: PCK_RECEIVED_STRUCT_FILLED (void * pointer -> SNIFFED_DATA)

      Excute les dissecteurs de donnes intgrs (ex SSH, HTTPS, ICQ, etc)

      HOOK POINT: PCK_DECODED  (void * pointer -> SNIFFED_DATA)

      Place SNIFFED_DATA dans le buffer pour ettercap
   }

   if (man_in_the_middle)
   {

      if (filter_activated)
      {
         Excute le moteur de filtrage sur le paquet

         HOOK POINT: ????  (void * pointer -> ????)
      }

      Cre une session interne (une par connexion) avec les donnes sensibles
      pour maintenir la connexion synchronise

      HOOK POINT: PCK_PRE_FORWARD (void * pointer -> to be sent buffer)

      Renvoie le paquet  la couche liaison de donne
   }

   if (pending_killing_request)
   {
      Tue la connexion
   }

   if (pending_inject_request)
   {
      Injecte des caractres dans la couche liaison de donnes

      Met  jour la sessions interne (numro de squence, ...)
   }

 }


0xABADC0DE==============================================================EC-2K

  Traduction : Julien Bordet (Bordet_J@yahoo.com)
