/* hey emacs! -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * Logger.h
 *   Header file for the Logger class
 *
 * $Id: Logger.h,v 1.7 2000/12/27 16:59:27 rex Exp $
 *
 * Copyright (c) 2000 Remi Lefebvre <remi@debian.org>
 *                and Luca Filipozzi <lfilipoz@debian.org>
 *
 * DDT comes with ABSOLUTELY NO WARRANTY and is licenced under the
 * GNU General Public License (version 2 or later). This license
 * can be retrieved from http://www.gnu.org/copyleft/gnu.html.
 *
 */

#ifndef LOGGER_H
#define LOGGER_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <syslog.h>

/**
 * @class Logger
 * @brief Class for interaction with the syslog and file logging.
 */

class Logger
{
  public:
    /**
     * @brief .
     * @arg ident identification of the logged line.
     * @arg priority syslog priority of that shows up.
     * @arg facility where to file logs. -1 disable syslog logging.
     * @arg fileName path to the file to log. NULL to log only to syslog.
     */
    /*
    Logger (char* ident,        // identifier, usually program name
            int priority,       // syslog priority
            int facility,       // syslog facility, use -1 to disable
            char* fileName);    // file to log to, use "" to disable
     */

    /// Instance.
    static Logger* Instance();

    /// Destructor.
    virtual ~Logger();

    /// start logging through the syslog facility
    int openSyslog(int facility, int priority);
    /// stop logging through the syslog facility
    void closeSyslog();

    /// start logging in a logfile
    int openFilelog(char* fileName, int priority);
    /// stop logging in a logfile
    void closeFilelog();

    /// set the logging priority for the syslog logging
    int setSyslogPriority(int priority);

    /// set the priority for the logfile
    int setFilelogPriority(int priority);

    /// set the identification string
    int setIdent(char* ident);

    /// Set the priority of the logging.
    //void setPriority(int priority);

    void debug(const char* fmt, ...);
    void info(const char* fmt, ...);
    void notice(const char* fmt, ...);
    void warning(const char* fmt, ...);
    void error(const char* fmt, ...);
    void crit(const char* fmt, ...);

  protected:
    /// Default Constructor.
    Logger(); /* hide the default constructor */

  private:
    //void log(int priority, const char *fmt, ...);
    void log(int priority, const char *string);

    char*           ident_;

    bool            isSyslogEnabled_;
    bool            isFilelogEnabled_;
    int             syslogPriority_;
    int             filelogPriority_;

    FILE*           file_;

    static Logger*  instance_;
};

#endif
