/* hey emacs! -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * DbResultSet.cc
 *   description goes here
 *
 * $Id: DbResultSet.cc,v 1.4 2000/12/27 16:59:27 rex Exp $
 *
 * Copyright (c) 2000 Benoit Joly <benoit@ddts.org>
 *                and Remi Lefebvre <remi@dhis.net>
 *                and Luca Filipozzi <lfilipoz@dhis.net>
 *
 * DDT comes with ABSOLUTELY NO WARRANTY and is licenced under the
 * GNU General Public License (version 2 or later). This license
 * can be retrieved from http://www.gnu.org/copyleft/gnu.html.
 *
 */

#include "DbResultSet.h"
#include "Exception.h"

DbResultSet::DbResultSet()
{
    beforeFirst();
}

DbResultSet::~DbResultSet()
{
}

int DbResultSet::getRowCount()
{
    return rows.size();
}

bool DbResultSet::next()
{
    if ((unsigned int) (currentRow + 1) == rows.size())
    {
        return false;
    }
    currentRow++;
    return true;
}

bool DbResultSet::prev()
{
    if (currentRow - 1 < 0)
    {
        return false;
    }
    currentRow--;
    return true;
}

bool DbResultSet::first()
{
    if (rows.size() == 0)
    {
        return false;
    }
    currentRow = 0;
    
    return true;
}

bool DbResultSet::beforeFirst()
{
    if (rows.size() == 0)
    {
        return false;
    }
  
    currentRow = -1;
    
    return true;
}

bool DbResultSet::last()
{
    if (rows.size() == 0)
    {
        return false;
    }
  
    currentRow = rows.size() - 1;
    
    return true;
}

bool DbResultSet::afterLast()
{
    if (rows.size() == 0)
    {
        return false;
    }
  
    currentRow = rows.size();
    
    return true;
}

const char *DbResultSet::getString(int pos)
{
    if (currentRow < 0 || (unsigned int) currentRow > (rows.size() - 1))
    {
        throw DdtException("cursor is not in a valid range");
    }
    if (pos < 0 || (unsigned int) pos > (rows[currentRow].size() - 1))
    {
        throw DdtException("column number is invalid");
    }

    return rows[currentRow][pos].c_str();
}

// int DbResultSet::getInt(int pos)
// {
//   return 0;
// }
// 
// long DbResultSet::getLong(int pos)
// {
//   return 0;
// }
