/* hey emacs! -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * ddt-admin.cc
 *   This is the main file for the command line admin utility.
 *
 * $Id: ddt-admin.cc,v 1.14 2002/03/27 05:46:28 benoit Exp $
 *
 * Copyright (c) 1999 Remi Lefebvre <remi@dhis.net>
 *                and Benoit Joly <benoit@dhis.net>
 *
 * Licensed under the GPLv2
 */

// FIXME: This is doing nothing right now. We have to code this
//        before release 1.0. At least for show/remove hosts.

#include <iostream>
#include <sstream>
#include <string>

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>

#include <readline/readline.h>
#include <readline/history.h>

#include <regexx.hh>
using namespace regexx;

#include "Options.h"
#include "DbAdmin.h"

void showHelp (void);
void showInfo (int hostId);
void removeHost (int hostId);


Logger  *log;
DbAdmin *db;

Options *Options::i_ = NULL;

Options *initConfig(int argc, char **argv, const char *confFile);
bool validateConfig(Options &opts, ostringstream &errorMsg);
bool getFirstParam(const char *command, char *buf, int size);

int main (int argc, char **argv)
{
    Regexx rxx;
    ostringstream errorMsg;

    // parse options and/or config file
    Options *opts = initConfig(argc, argv, CONF_FILE);

    // verify provided values
    if(!validateConfig(*opts, errorMsg))
    {
      cerr << errorMsg.str() << endl;;
      return -1;
    }
    
    try
    {
        // create objects
        log = Logger::Instance();
        db  = new DbAdmin (log, opts->dbname, opts->dbuser, opts->dbpass,
                           opts->domain, opts->banned, opts->reserved);
    }
    catch (DdtException &e)
    {
        cerr << e.message() << endl;
        return -1;
    }

    log->setIdent(argv[0]);
    log->openSyslog(LOG_USER, LOG_DEBUG);
    
    // Holds command line request. Memory is allocated by readline.
    char *line;
    char *command;
    char param[256];
    
    // Main loop. Parse commands.
    while (1)
    {
    	line = readline ("ddt-admin> ");
        if (line == NULL || line[0] == 0x04)
        {
			cerr << "leaving\n";
            break;
        }

		if (strlen(line) == 0)
		{
		  continue;
		}

        command = strdup (line);

        if (rxx.exec (command, "^/*quit", Regexx::nocase))
        {
			cerr << "leaving\n";
            break;
        }

        add_history (line);
        // print help
        if (rxx.exec (command, "^/*help", Regexx::nocase) ||
            rxx.exec (command, "^/*\\?", Regexx::nocase))
        {
            showHelp ();
        }
        
        else if (rxx.exec (command, "^/*show", Regexx::nocase))
        {
            if(!getFirstParam(command, param, 256))
			{
                cerr << "missing params" << endl;
                continue;
			}
            
            int id = atoi(param);
            showInfo(id);
        }
        
        else if (rxx.exec (command, "^/*remove", Regexx::nocase))
        {
            cout << "in remove" << endl;
            rxx.exec (command, "^/*remove +([^ ]+)");

            if(rxx.match.size() > 0 && rxx.match[0].atom.size() > 0)
            {
                int id = atoi(rxx.match[0].atom[0].str().c_str());
                removeHost(id);
            }
            else
            {
                cerr << "missing params" << endl;
                continue;
            }
        }
        else
        {
            cout << "Invalid command!\n";
        }
    }

    free (line);
    return 0;
}

void showHelp (void)
{
    char *help =
        " help / ?                  -- print this help\n"
        " show uid                  -- dump information of user matching uid\n"
        " remove uid                -- attempts to completely remove account matching uid\n"
//        " search pattern            -- seach for 'pattern' in the FQDN and returns uid\n"
//        " showFqdn fqdn             -- dump information of user matching fqdn\n"
//        " deluser uid               -- remove a user\n"
//        " delcname uid fqdn         -- delete CNAME if it belongs to uid\n"
//        " delmx uid mx              -- delete MX if it belongs to uid\n"
//        " adduser                   -- not implemented\n"
//        " addcname uid fqdn         -- add a CNAME for uid\n"
//        " addmx uid fqdn priority   -- add a MX record for uid\n"
        ;
    cout << help << endl;
}

void showInfo(int hostId)
{
    // get the first arg
    if (hostId != 0)
    {
		db->dumpInfo (hostId);
		//userAccount account;
        //if( db->getAcctInfo (hostId, &account));
    }
    else
    {
        cout << "Not a number\n";
    }
}

void removeHost(int hostId)
{
    if (hostId != 0)
    {
        cout << "Are you sure you want to remove " << hostId << " from the database [N/y]? ";

		char ch[16];
		cin.getline(ch, 16);
        //cout << "You entered '" << ch << "' \n";
        switch (ch[0])
        {
            case 'y':
            case 'Y':
                if (db->removeAccount (hostId) == -1)
                {
                    cout << "Failed to remove account\n";
                }
                else
                {
                    cout << "Account removed succesfully.\n";
                }
                break;
            case 'N':
            case 'n':
            default:
                cout << "Account not removed.\n";
                break;
        }
    }
    else
    {
        cout << "Not a number.\n";
    }
}

Options *initConfig(int argc, char **argv, const char *confFile)
{
    Options *opts = Options::Instance();
    optTitle ("CGI - DDT's Registration/Administration CGIs\n");
    optrega (&opts->dbname, OPT_STRING, 'n', "dbname", "*database name");
    optrega (&opts->dbuser, OPT_STRING, 'u', "dbuser", "*database owner");
    optrega (&opts->dbpass, OPT_STRING, 'p', "dbpass", "*database password");
    optrega (&opts->domain, OPT_STRING, 'd', "domain", "*domain name");
    optrega (&opts->banned, OPT_STRING, 'b', "banned", "*banned names file");
    optrega (&opts->head,   OPT_STRING, 'h', "head",   "*header file");
    optrega (&opts->foot,   OPT_STRING, 'f', "foot",   "*footer file");
    optDefaultFile (CONF_FILE);
    opt (&argc, &argv);

    return opts;
}

bool validateConfig(Options &opts, ostringstream &errorMsg)
{
    bool error = false;
    if (!optinvoked(&opts.dbuser))
    {
        errorMsg << "please provide a dbuser" << endl;
        error = true;
    }
    if (!optinvoked(&opts.dbname))
    {
        errorMsg << "please provide a dbname" << endl;
        error = true;
    }
    if (!optinvoked(&opts.dbpass))
    {
        errorMsg << "please provide a dbpass" << endl;
        error = true;
    }
    return !error;
}

bool getFirstParam(const char *command, char *buf, int size)
{
  Regexx rxx;
  rxx.exec (command, "^/*[^ ]* +([^ ]+)");

  if(rxx.match.size() > 0 && rxx.match[0].atom.size() > 0)
  {
    strncpy(buf, rxx.match[0].atom[0].str().c_str(), size);
  }
  else
  {
	return false;
  }
  return true;
}
