/*
** Copyright 2000 Double Precision, Inc.
** See COPYING for distribution information.
*/

#if HAVE_CONFIG_H
#include "config.h"
#endif

#include	<sys/types.h>
#include	<sys/stat.h>
#include	<string.h>
#include	<stdlib.h>
#include	<time.h>
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	<stdio.h>
#include	<ctype.h>
#include	<errno.h>

#include	"maildirmisc.h"

static const char rcsid[]="$Id: maildirpath.c,v 1.5 2000/03/08 17:52:46 mrsam Exp $";

char *maildir_folderdir(const char *maildir, const char *foldername)
{
char	*p;
const char *r;
size_t	l;

	if (!maildir)	maildir=".";
	l=strlen(maildir);

	if (foldername == 0 ||
#if	HAVE_STRCASECMP
		strcasecmp(foldername, INBOX)
#else
		strcmp(foldername, INBOX)
#endif
		== 0)
	{
		if ((p=malloc(l+1)) == 0)	return (0);
		strcpy(p, maildir);
		return(p);
	}

	/* Rules: no leading/trailing periods, no /s */
	if (*foldername == '.' || strchr(foldername, '/'))
	{
		errno=EINVAL;
		return (0);
	}

	for (r=foldername; *r; r++)
	{
		if (*r != '.')	continue;
		if (r[1] == 0 || r[1] == '.')
		{
			errno=EINVAL;
			return (0);
		}
	}

	if ((p=malloc(l+strlen(foldername)+3)) == 0)	return (0);
	*p=0;
	if (strcmp(maildir, "."))
		strcat(strcpy(p, maildir), "/");
	
	return (strcat(strcat(p, "."), foldername));
}
