/*
 * Copyright (c) 1995 - 2000 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _xfs_h
#define _xfs_h

#include <xfs/xfs_common.h>
#include <xfs/xfs_node.h>
#include <linux/types.h>

/*
 * Filesystem struct.
 */
struct xfs {
    u_int status;		/* Inited, opened or mounted */
#define XFS_MOUNTED	0x1
#define XFS_DEVOPEN	0x2
#define XFS_ROOTINSTALLED 0x4
    struct super_block *sb;
    struct xfs_node *root;
    u_int nnodes;
    
    struct xfs_node *nodes;		/* replace with hash table */
    int fd;
};

#define VFS_TO_XFS(v)      ((struct xfs *) ((v)->u.generic_sbp))
#define XFS_TO_VFS(x)      ((x)->sb)

#define XFS_FROM_VNODE(vp) VFS_TO_XFS((vp)->i_sb)
#define XFS_FROM_XNODE(xp) XFS_FROM_VNODE(XNODE_TO_VNODE(xp))

extern struct xfs xfs[];

extern struct vnodeops xfs_vnodeops;

struct xfs_node *xfs_node_find (struct xfs *, struct xfs_handle *);
struct xfs_node *new_xfs_node (struct xfs *, struct xfs_msg_node *);
void free_xfs_node (struct xfs_node *);
void clear_xfs_node (struct xfs_node *);
void free_all_xfs_nodes (struct xfs *xfsp);
void print_nodes (int fd);

int xfs_has_pag(const struct xfs_node *xn, xfs_pag_t);

void xfs_invalid_xnode(struct xfs_node *xnode);
void xfs_force_invalid_xnode(struct xfs_node *xnode);
int  xfs_node_users(struct xfs_node *xnode);
void xfs_attr2inode(const struct xfs_attr *, struct inode *, int);
void vattr2xfs_attr(const struct iattr *iattr, struct xfs_attr *attr);
#endif /* _xfs_h */
