/*
 * Copyright (c) 1998 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/sysconfig.h>

int
main(int argc, char **argv)
{
    struct cfg_load cfg_load;
    struct cfg_kmod cfg_kmod;
    int ret;

    if (argc != 2) {
	fprintf (stderr, "Usage: %s module\n", argv[0]);
	return 1;
    }

    cfg_load.path    = argv[1];
    cfg_load.libpath = NULL;

    ret = sysconfig (SYS_QUERYLOAD, &cfg_load, sizeof(cfg_load));
    if (ret) {
	perror ("sysconfig SYS_QUERYLOAD");
	return 1;
    }
    if (cfg_load.kmid == 0) {
	printf ("not loaded\n");
	return 1;
    }

    cfg_kmod.kmid   = cfg_load.kmid;
    cfg_kmod.cmd    = 1;
    cfg_kmod.mdiptr = NULL;
    cfg_kmod.mdilen = 0;

    ret = sysconfig (SYS_CFGKMOD, &cfg_kmod, sizeof(cfg_kmod));
    if (ret) {
	perror ("sysconfig SYS_CFGKMOD");
	return 1;
    }

    ret = sysconfig (SYS_KULOAD, &cfg_load, sizeof(cfg_load));
    if (ret) {
	perror ("sysconfig SYS_SINGLELOAD");
	return 1;
    }
    return 0;
}
/*

int sysconfig (Cmd, Parmp, Parmlen)
int Cmd;
void *Parmp;
int Parmlen;
*/
