#ifndef	BACKUP_H
#define	BACKUP_H	BACKUP_H

#include <stdio.h>
#include <time.h>
#include <signal.h>
#include <sys/types.h>
#ifdef	HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif
#include <x_types.h>
#include <budefs.h>
#ifndef	O_SYNC
# define O_SYNC O_FSYNC
#endif
#if defined(HPUX_9) && !defined(RLIMIT_STACK)
#define	RLIMIT_STACK	3
#endif

struct fault_msgs {
  UChar		code;
  char		*msg;
};

#define FAULT_MESSAGES  { \
	{ CLOSE_FAILED,		"device cannot be closed" }, \
	{ OPENRD_FAILED,	"opening the device for reading failed" },\
	{ OPENWR_FAILED,	"opening the device for writing failed" },\
	{ DEVINUSE,		"device is in use" },\
	{ SERVICEINUSE,		"service is in use" },\
	{ DEVNOTOPENRD,		"device has not been opened for reading" },\
	{ DEVNOTOPENWR,		"device has not been opened for writing"},\
	{ DEVNOTREADY,		"device is not ready for use" },\
	{ ENDOFFILEREACHED,	"end of file encountered" },\
	{ ENDOFTAPEREACHED,	"end of tape encountered" },\
	{ PROTOCOL_ERROR,	"protocol error" },\
	{ CHANGECART_FAILED,	"cartridge cannot be changed" },\
	{ SETFILE_FAILED,	"setting the file failed" },\
	{ ERASETAPE_FAILED,	"erasing the tape failed" },\
	{ FATAL_ERROR,		"a fatal error occured on the server"},\
	{ CONFIG_ERROR,		"server configuration error"},\
	{ REOPEN_FAILED,	"reopening the device for writing failed" },\
	{ NO_VALID_CARTRIDGE,	"illegal cartridge number" },\
	{ NO_VALID_FILENUM,	"illegal file number" },\
	{ NO_VALID_CARTSET,	"illegal cartridge set" },\
	{ AUTHENTICATION,	"authentication failure" },\
	{ SUBPROCESS_FAILED,	"subprocess failed" },\
	{ EOF,			"connection closed" },\
}

typedef struct aar_params {
  char		*zipcmd;
  char		*unzipcmd;
  FILE		*infp;
  FILE		*outfp;
  FILE		*errfp;
  Uns32		blocksize;
  int		infd;
  int		outfd;
  Int32		(*outputfunc)(UChar *, Int32, struct aar_params *);
  Int32		(*inputfunc)(UChar *, Int32, struct aar_params *);
  Uns32		maxmem;
  UChar		unlink;
  UChar		relative;
  UChar		recursive;
  UChar		verbose;
  UChar		check;
  void		(*verbosefunc)(UChar *, struct aar_params *);
  void		(*pre_verbosefunc)(UChar *, struct aar_params *);
  UChar		mode;
  UChar		ignoreown;
  UChar		skip_garbage;
  time_t	time_newer;
  time_t	time_older;
  Int32		uid;
  UChar		**dont_compress;
  sigset_t	blocked_signals;
  struct {
    Int32	actcart;
    Int32	actfile;
    Int32	firstcart;
    Int32	lastcart;
    Int32	firstfile;
    Int32	lastfile;
    Int32	num_fsentries;
    Real64	bytes_saved;
    Real64	sum_filesizes;
    Real64	sum_compr_filesizes;
    UChar	startdate[32];
    UChar	enddate[32];
    Int32	uid;
  }		vars;
}	AarParams;

#ifndef	_WIN32
#define	AAR_DEFAULT_PARAMS		\
	{				\
		(char *) NULL,		\
		(char *) NULL,		\
		stdin,			\
		stdout,			\
		stderr,			\
		(Uns32) 1024,		\
		0,			\
		1,			\
		default_output,		\
		default_input,		\
		(Uns32) 0,		\
		(UChar) 0,		\
		(UChar) 0,		\
		(UChar) 0,		\
		(UChar) 0,		\
		(UChar) 0,		\
		default_verbose,	\
		NULL,			\
		MODE_NONE,		\
		(UChar) 0,		\
		(UChar) 0,		\
		(time_t) 0,		\
		(time_t) 0,		\
		(Int32) 0,		\
		(UChar **) 0,		\
	}
#else	/* ! defined(_WIN32) */
#define	AAR_DEFAULT_PARAMS		\
	{				\
		(char *) NULL,		\
		(char *) NULL,		\
		NULL,			\
		NULL,			\
		NULL,			\
		(Uns32) 1024,		\
		0,			\
		1,			\
		default_output,		\
		default_input,		\
		(Uns32) 0,		\
		(UChar) 0,		\
		(UChar) 0,		\
		(UChar) 0,		\
		(UChar) 0,		\
		(UChar) 0,		\
		default_verbose,	\
		NULL,			\
		MODE_NONE,		\
		(UChar) 0,		\
		(UChar) 0,		\
		(time_t) 0,		\
		(time_t) 0,		\
		(Int32) 0,		\
		(UChar **) 0,		\
	}
#endif	/* ! defined(_WIN32) */

#ifdef	_WIN32
#define	ntohs	htons
#endif

#define	READ_SPLIT	0
#define	READ_FORCED	1
#define	READ_UNINTR	2
#define	READ_MODEMASK	(READ_SPLIT | READ_FORCED | READ_UNINTR)
#define	READ_NOSELECT	16
#define	READ_OPTMASK	(READ_NOSELECT)

#define	WRITE_SPLIT	0
#define	WRITE_FORCED	1
#define	WRITE_UNINTR	2
#define	WRITE_MODEMASK	(WRITE_SPLIT | WRITE_FORCED | WRITE_UNINTR)
#define	WRITE_NOSELECT	16
#define	WRITE_OPTMASK	(WRITE_NOSELECT)

#define	read_split(fd, buf, num)	read_ext((fd), (buf),\
						(num), READ_SPLIT)
#define	read_forced(fd, buf, num)	read_ext((fd), (buf),\
						(num), READ_FORCED)
#define	read_unintr(fd, buf, num)	read_ext((fd), (buf),\
						(num), READ_UNINTR)

#define	write_split(fd, buf, num)	write_ext((fd), (buf),\
						(num), WRITE_SPLIT)
#define	write_forced(fd, buf, num)	write_ext((fd), (buf),\
						(num), WRITE_FORCED)
#define	write_unintr(fd, buf, num)	write_ext((fd), (buf),\
						(num), WRITE_UNINTR)

extern	Int32	writeout(UChar *, AarParams *, Int16);
extern	Int32	readin(UChar **, AarParams *, UChar *);
extern	Int32	contents(AarParams *);
extern	Int32	verify(UChar **, AarParams *, UChar *);

extern	Int32	default_output(UChar *, Int32, AarParams *);
extern	Int32	default_input(UChar *, Int32, AarParams *);
extern	void	default_verbose(UChar *, AarParams *);

#ifdef	USE_DES_ENCRYPTION
extern	Uns32	encrpt(UChar *);
#else
extern	Uns32	encrpt(Uns32);
#endif
extern	Int32	set_cryptkey(UChar *);
extern	UChar	*actimestr();
extern	time_t	time_from_datestr(UChar *);
extern	time_t	strint2time(UChar *);
extern	UChar	*fault_string(Int32);

extern	Int32	write_ext(int, UChar *, Int32, UChar);
extern	Int32	read_ext(int, UChar *, Int32, UChar);

extern	pid_t	waitpid_forced(pid_t, int *, int);

extern	void	clr_timer();

extern	int	fork_forced();
extern	int	open_to_pipe(UChar *, UChar *, UChar, int *, int);
extern	int	open_from_pipe(UChar *, UChar *, UChar, int *);
extern	Int32	fscanwordq_forced(FILE *, UChar *);
extern	UChar	*Real64_to_intstr(Real64, UChar *);
extern	UChar	*time_t_to_intstr(time_t, UChar *);
extern	UChar	*size_t_to_intstr(size_t, UChar *);
extern	int	connect_afbu_server(UChar *, UChar *, Int32);

#endif	/* !defined(BACKUP_H) */
