/***************************************************************************/
/* 		This code is part of WWW grabber called pavuk		   */
/*		Copyright (c) 1997-2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <limits.h>
#include <errno.h>
#include <ctype.h>

#include "config.h"
#include "http.h"
#include "ftp.h"
#include "gopher.h"
#include "url.h"
#include "html.h"
#include "tools.h"
#include "authinfo.h"
#include "tr.h"
#include "dinfo.h"

static char * url_decode_html(char*, int);

/* here can you specify characters,	*/
/* which are unsafe in file names	*/
#ifdef _WIN32
#define FS_UNSAFE_CHARACTERS "\\:*?\"<>|"
#endif

/* for hexadicimal encoding */
static char hexa[] = "0123456789ABCDEF";
#define HEXASC2HEXNR(x) (((x) >= '0' && (x) <= '9') ? \
	((x) - '0') : (toupper(x) - 'A' + 10))

#define HEX2CHAR(x) (HEXASC2HEXNR(*(x + 1)) << 4) + HEXASC2HEXNR(*(x + 2))

protinfo prottable[] = {
	{URLT_UNKNOWN , NULL , NULL , NULL , 0 , FALSE} ,
	{URLT_BROKEN , NULL , NULL , NULL , 0 , FALSE} ,
	{URLT_HTTP , "http" , "http" , "http://" , 80 , TRUE} ,
#ifdef USE_SSL
	{URLT_HTTPS , "https" , "https" , "https://" , 443 , TRUE} ,
#else
	{URLT_HTTPS , "https" , "https" , "https://" , 443 , FALSE} ,
#endif
	{URLT_SHTTP , "shttp" , "shttp" , "shttp://" , 0 , FALSE} ,
	{URLT_FTP , "ftp" , "ftp" , "ftp://" , 21 , TRUE} ,
#ifdef USE_SSL
	{URLT_FTPS , "ftps" , "ftps" , "ftps://" , 21 , TRUE} ,
#else
	{URLT_FTPS , "ftps" , "ftps" , "ftps://" , 21 , FALSE} ,
#endif
	{URLT_FILE , NULL , "file" , "file://" , 0 , TRUE} ,
	{URLT_GOPHER , "gopher" , "gopher" , "gopher://" , 70 , TRUE} ,
	{URLT_NEWS , "news" , "news" , "news:" , 119 , FALSE} ,
	{URLT_NNTP , "nntp" , "nntp" , "nntp://" , 119 , FALSE} ,
	{URLT_WAIS , NULL , "wais" , "wais://", 0 , FALSE} ,
	{URLT_MAILTO , NULL , "mailto" , "mailto:", 25 , FALSE} ,
	{URLT_TELNET , NULL , "telnet" , "telnet://" , 21 , FALSE} ,
	{URLT_RLOGIN , NULL , "rlogin" , "rlogin://" , 513 , FALSE} ,
	{URLT_TN3270 , NULL , "tn3270" , "tn3270://" , 0 , FALSE} ,
	{URLT_X500 , NULL , "x500" , "x500://" , 0 , FALSE} ,
	{URLT_WHOIS , NULL , "whois" , "whois://" , 0 , FALSE} ,
	{URLT_PROSPERO , NULL , "prospero" , "prospero://" , 0 , FALSE} ,
	{URLT_JAVASCRIPT , NULL , "javascript" , "javascript:" , 0 , FALSE} ,
	{URLT_URN , NULL , "urn" , "urn://" , 0 , FALSE} ,
	{URLT_LDAP , NULL , "ldap" , "ldap://" , 0 , FALSE} ,
	{URLT_Z39_50S , NULL , "z39_50s" , "z39_50s://" , 0 , FALSE} ,
	{URLT_Z39_50R , NULL , "z39_50r" , "z39_50r://" , 0 , FALSE} ,
	{URLT_CID , NULL , "cid" , "cid:" , 0 , FALSE} ,
	{URLT_CLSID , NULL , "clsid" , "clsid:" , FALSE} ,
	{URLT_FINGER , NULL , "finger" , "finger:" , FALSE} ,
	{URLT_HDL , NULL , "hdl" , "hdl:" , FALSE} ,
	{URLT_ILU , NULL , "ilu" , "ilu:" , FALSE} ,
	{URLT_IOR , NULL , "ior" , "ior:" , FALSE} ,
	{URLT_IRC , NULL , "irc" , "irc:" , FALSE} ,
	{URLT_JAVA , NULL , "java" , "java:" , FALSE} ,
	{URLT_LIFN , NULL , "lifn" , "lifn:" , FALSE} ,
	{URLT_MID , NULL , "mid" , "mid:" , FALSE} ,
	{URLT_PATH , NULL , "path" , "path:" , FALSE} ,
	{URLT_SERVICE , NULL , "service" , "service:" , FALSE} ,
	{URLT_SNEWS , NULL , "snews" , "snews:" , FALSE} ,
	{URLT_STANF , NULL , "stanf" , "stanf:" , FALSE} ,
	{URLT_SMS , NULL , "sms" , "sms:" , FALSE} ,
	{URLT_TEL , NULL , "tel" , "tel:" , FALSE} ,
	{URLT_FAX , NULL , "fax" , "fax:" , FALSE} ,
	{URLT_MODEM , NULL , "modem" , "modem:" , FALSE} ,
	{URLT_DATA , NULL , "data" , "data:" , FALSE} ,
	{URLT_VEMMI , NULL , "vemmi" , "vemmi:" , FALSE} ,
};

#define _STRCLS_LOWER "abcdefghijklmnopqrstuvwxyz"
#define _STRCLS_UPER "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
#define _STRCLS_DIGIT "0123456789"

char *url_parse_scheme(urlstr)
char *urlstr;
{
	char *p;
	char *retv = NULL;

	if ((p = strchr(urlstr, ':')) && isalpha(*urlstr))
	{
		int l1 = strspn(urlstr, _STRCLS_LOWER _STRCLS_UPER _STRCLS_DIGIT "+-.");

		if (l1 == (p - urlstr))
		{
			retv = new_n_string(urlstr, l1);
			lowerstr(retv);
		}
	}

	return retv;
}

static char *url_parse_authority(urlschpart)
char *urlschpart;
{
	char *retv = NULL;

	if (urlschpart[0] == '/' && urlschpart[1] == '/')
	{
		int l1 = strcspn(urlschpart+2 , "/?#;");

		retv = new_n_string(urlschpart+2 , l1);
	}

	return retv;
}

static int url_split_authority(authority, user, password, host ,port)
char *authority;
char **user;
char **password;
char **host;
unsigned short* port;
{
	char *p,*p2;

	if (user)
		*user = NULL;
	if (password)
		*password = NULL;
	*host = NULL;
	*port = 0;

	if (user && (p = strchr(authority , '@')))
	{
		p2 = strchr(authority , ':');

		if (p2 && p2 < p)
		{
			*user = url_decode_str(authority, p2 - authority);
			*password = url_decode_str(p2+1, p-p2-1);
		}
		else
		{
			*user = url_decode_str(authority, p - authority);
		}
		p++;
	}
	else p = authority;

	if ((p2 = strchr(p , ':')))
	{
		*host = new_n_string(p , p2-p);
		*port = _atoi(p2+1);
	}
	else
	{
		*host = new_string(p);
	}

	lowerstr(*host);

	return 0;
}

static int url_split_path(urlpath, path, query, anchor)
char *urlpath;
char **path;
char **query;
char **anchor;
{
	char *p = NULL,*p1 = NULL,*p2 = NULL;

	*path = NULL;
	if (query)
		*query = NULL;
	if (anchor)
		*anchor = NULL;

	if (anchor)
		p1 = strchr(urlpath, '#');

	if (query)
		p2 = strchr(urlpath, '?');

	if (p1 && p2)
	{
		if (p1 > p2)
		{
			*anchor = new_string(p1 + 1);
			*query = url_decode_html(p2 + 1, p1 - (p2+1));
			p = p2;
		}
		else
		{
			*query = url_decode_html(p2 + 1, strlen(p2+1));
			*anchor = new_n_string(p1 + 1, p2 - (p1+1));
			p = p1;
		}
	}
	else if (p1)
	{
		*anchor = new_string(p1 + 1);
		p = p1;
	}
	else if (p2)
	{
		*query = url_decode_html(p2 + 1, strlen(p2 + 1));
		p = p2;
	}

	if (p)
	{
		if (p-urlpath)
		{
			*path = url_decode_str(urlpath , p - urlpath);
			if (**path == '/')
			{
				p = *path;
				*path = get_abs_file_path(_strtrchr(p , '\\' , '/'));
				free(p);
			}
		}
	}
	else
	{
		if (*urlpath)
		{
			*path = url_decode_str(urlpath, strlen(urlpath));
			if (**path == '/')
			{
				p = *path;
				*path = get_abs_file_path(_strtrchr(p , '\\' , '/'));
				free(p);
			}
		}
	}

	return 0;
}

protocol url_scheme_to_schemeid(scheme)
char *scheme;
{
	int i;
	for (i = 0 ; i < NUM_ELEM(prottable) ; i++) 
	{
		if (prottable[i].urlid && !strcmp(prottable[i].urlid , scheme))
		{
			return prottable[i].id;
		}
	}
	return URLT_UNKNOWN;
}

url *url_parse(urlstr)
char *urlstr;
{
	char *scheme = NULL;
	char *authority = NULL;
	char *p;
	url ret_url;

	ret_url.type = URLT_UNKNOWN;
	ret_url.status = 0;
	ret_url.parent_url = NULL;
	ret_url.moved_to = NULL;
	ret_url.ref_cnt = 1;
	ret_url.level = 0;
	ret_url.extension = NULL;
	ret_url.local_name = NULL;

#ifdef WITH_TREE
#ifdef I_FACE
	ret_url.prop = NULL;
	ret_url.tree_nfo = NULL;
#endif
#endif
	p = urlstr;

	if (p)
		scheme = url_parse_scheme(urlstr);

	if (scheme)
	{
		ret_url.type = url_scheme_to_schemeid(scheme);

		p += strlen(scheme) + 1;
		authority = url_parse_authority(p);
		if (authority)
			p += strlen(authority) + 2;

		if (authority && *authority)
		{
		    switch(ret_url.type)
		    {
			case URLT_HTTP:
			case URLT_HTTPS:
				url_split_authority(authority,
					&ret_url.p.http.user,
					&ret_url.p.http.password,
					&ret_url.p.http.host,
					&ret_url.p.http.port);

				if (!ret_url.p.http.port)
					ret_url.p.http.port = 
						prottable[ret_url.type].default_port;

				url_split_path(p ,
					&ret_url.p.http.document,
					&ret_url.p.http.searchstr,
					&ret_url.p.http.anchor_name);

				if (!ret_url.p.http.document)
					ret_url.p.http.document = new_string("/");
			break;
			case URLT_FTP:
			case URLT_FTPS:
				url_split_authority(authority,
					&ret_url.p.ftp.user,
					&ret_url.p.ftp.password,
					&ret_url.p.ftp.host,
					&ret_url.p.ftp.port);

				if (!ret_url.p.ftp.port)
					ret_url.p.ftp.port = 
						prottable[ret_url.type].default_port;

				url_split_path(p ,
					&ret_url.p.ftp.path,
					NULL,
					&ret_url.p.ftp.anchor_name);


				if (!ret_url.p.ftp.path)
					ret_url.p.ftp.path = new_string("/");

				if (p && p[0] == '/' && p[1] == '/')
				{
					char *pp = tl_str_concat(NULL, "/" , ret_url.p.ftp.path, NULL);
					_free(ret_url.p.ftp.path);
					ret_url.p.ftp.path = pp;
				}

				if ((p = strchr(ret_url.p.ftp.path , ';')))
					p = '\0';

				ret_url.p.ftp.dir = tl_is_dirname(ret_url.p.ftp.path) != 0;
			break;
			case URLT_GOPHER:
				url_split_authority(authority,
					NULL,
					NULL,
					&ret_url.p.gopher.host,
					&ret_url.p.gopher.port);

				if (!ret_url.p.gopher.port)
					ret_url.p.gopher.port = 
						prottable[ret_url.type].default_port;

				if (*(p+1))
					ret_url.p.gopher.selector = new_string(p+1);
				else
					ret_url.p.gopher.selector = new_string("1");
			break;
			case URLT_FILE:
				url_split_path(p ,
					&ret_url.p.file.filename,
					&ret_url.p.file.searchstr,
					&ret_url.p.file.anchor_name);

				if (!ret_url.p.file.filename)
					ret_url.p.file.filename = new_string("");
			break;
			default:
				ret_url.p.unsup.urlstr = new_string(urlstr);
			break;
		    }
		}
	}

	if (!scheme || !authority || !*authority)
	{
		if (!scheme)
			ret_url.type = URLT_FILE;

		switch(ret_url.type)
		{
		    case URLT_FILE:
		    case URLT_FTP:
		    case URLT_FTPS:
		    case URLT_HTTP:
		    case URLT_HTTPS:
			ret_url.type = URLT_FILE;
			url_split_path(p ,
				&ret_url.p.file.filename,
				&ret_url.p.file.searchstr,
				&ret_url.p.file.anchor_name);

			if (!ret_url.p.file.filename)
				ret_url.p.file.filename = new_string("");
		    break;
		    default:
			ret_url.p.unsup.urlstr = new_string(urlstr);
		    break;
		}
	}

	_free(authority);
	_free(scheme);
	return new_url(&ret_url);
}

/**** presmerovanie URL na absolutne ****/
char *url_to_absolute_url(base , baset , parent , act)
char *base;
char *baset;
url *parent;
char *act;
{
	char *psp = NULL;
	url *purl = url_parse(act);
	char *pom;

	pom = _malloc(strlen(url_to_filename(parent , TRUE)) + strlen(cfg.cache_dir) + strlen(baset) + strlen(act));

	if ((parent->type == URLT_GOPHER) &&
	    cfg.gopher_proxy && cfg.gopher_via_http &&
	    !(parent->status & URL_REDIRECT) &&
	    (!strncmp(act, "//", 2)))
	{
		sprintf(pom , "gopher:%s" , act);
		psp = new_string(pom);
	}
	else if (purl->type == URLT_FILE && 
		(parent->type == URLT_FILE))
	{
		if (!(*purl->p.file.filename))
		{
			strcpy(pom,baset);
		}
		else 
		{
			if (*(purl->p.file.filename) != '/')
			{
				strcpy(pom , base);
				strcat(pom , purl->p.file.filename);

				free(purl->p.file.filename);
				purl->p.file.filename = new_string(pom);						
			}
			else
				sprintf(pom , "%s%s" , 
					prottable[purl->type].typestr ,
					purl->p.file.filename);
		}
		psp = new_string(pom);
	}
	else if ((purl->type == URLT_FILE) && 
		 (cfg.base_level == 0 || cfg.enable_info) && 
		 (parent->status & URL_REDIRECT))
	{
		char *p1,*p;
		url *pomurl;

		if (*purl->p.file.filename == '/')
			strcpy(pom , purl->p.file.filename);
		else
		{
			p = url_to_filename(parent , TRUE);
			strcpy(pom , p);
			p1 = strrchr(pom , '/');
			if (p1) *(p1+1) = '\0';
			strcat(pom, purl->p.file.filename);
		}
		if (purl->p.file.searchstr)
		{
			strcat(pom, "?");
			strcat(pom, purl->p.file.searchstr);
		}

		p = get_abs_file_path(pom);
		pomurl = filename_to_url(p);
		if (pomurl)
		{
			_free(p);
			psp = url_to_urlstr(pomurl , TRUE);
			free_deep_url(pomurl);
			_free(pomurl);
		}
	}
	if ((!psp && purl->type == URLT_FILE) && 
		(parent->type == URLT_HTTP ||
		 parent->type == URLT_HTTPS ||
		 parent->type == URLT_FTPS ||
		 parent->type == URLT_FTP))
	{
		char *ri;
		if (*(purl->p.file.filename) == '/')
		{
			char *idx;

			strcpy(pom , base);
			idx = strfindnchr(pom , '/' , 3);
			if (idx)
				strcpy(idx - 1 , purl->p.file.filename );
			else
				strcat(pom , purl->p.file.filename );
 
			if (purl->p.file.searchstr)
			{
				strcat(pom, "?");
				strcat(pom, purl->p.file.searchstr);
			}

			if (purl->p.file.anchor_name)
			{
				strcat(pom , "#");
				strcat(pom , purl->p.file.anchor_name);
			}
		}
		else if (!(*purl->p.file.filename) && !purl->p.file.searchstr)
		{
			if (purl->p.file.anchor_name)
			{
				strcpy(pom,baset);
				strcat(pom , "#");
				strcat(pom , purl->p.file.anchor_name);
			}
			else
			{
				strcpy(pom,base);
			}
		}
		else
		{
			strcpy(pom , base);
			ri = strrchr(pom , '/');
			if (ri)
				strcpy(ri + 1 , purl->p.file.filename);
			else
				strcat(pom , purl->p.file.filename);

			if ((strlen(purl->p.file.filename) >= strlen(cfg.index_name)) &&
			    !strcmp(cfg.index_name , purl->p.file.filename + strlen(purl->p.file.filename) - strlen(cfg.index_name)))
			{
				*(pom + strlen(pom) - strlen(cfg.index_name)) = '\0';
			}

			if (purl->p.file.searchstr)
			{
				strcat(pom, "?");
				strcat(pom, purl->p.file.searchstr);
			}

			if (purl->p.file.anchor_name)
			{
				strcat(pom , "#");
				strcat(pom , purl->p.file.anchor_name);
			}
		}
		psp = new_string(pom);
	}
	else if (!psp)
	{
		psp = new_string(act);	
	}

	free_deep_url(purl);
	_free(purl);

	if (psp)
	{
		purl = url_parse(psp);
		url_path_abs(purl);
		if (prottable[purl->type].supported)
		{
			free(psp);
			psp = url_to_urlstr(purl , TRUE);
		}
		free_deep_url(purl);
		_free(purl);		
	}

	_free(pom);

	return psp;
}

/**************************************/
/* zakodovanie znakov v URL , ktore   */
/* nie su bezpecne alebo povolene     */
/**************************************/
char * url_encode_str(urlstr, unsafe)
char *urlstr;
char *unsafe;
{
	unsigned char *res,*p,*r;

	if (urlstr == NULL) return NULL;

	res = _malloc(strlen(urlstr) * 3 + 1);

	for (p = urlstr , r = res ; *p ; p++ , r++)
	{
		if (strchr(unsafe , *p ) ||
			((unsigned char)*p > 0x7f) ||
			((unsigned char)*p < 0x20))
		{
			*r = '%';
			r++;
			*r = hexa[*p >> 4];
			r++;
			*r = hexa[*p % 16];
		}
		else
		{
			*r = *p;
		}
	}
	*r = '\0';

	return res;
}

/*****************************************/
/* dekodovanie zakodovanych znakov z URL */
/*****************************************/
char * url_decode_str(urlstr, len)
char *urlstr;
int len;
{
	char *res,*r;
	int i;

	if (urlstr == NULL) return NULL;

	res = new_n_string(urlstr,len);

	for (i = 0 , r = res ; i < len ; r++ , i++)
	{
		if (urlstr[i] == '%' && urlstr[i+1] && urlstr[i+2] && 
			isxdigit(urlstr[i+1]) && isxdigit(urlstr[i+2]))
		{
			*r = HEX2CHAR(urlstr+i);
			i += 2;
		}
		else if (urlstr[i] == '&')
		{
			if (!strncmp(urlstr + i + 1,"amp;" , 4) || !strncmp(urlstr + i + 1, "#38;" , 4))
				i += 4;
			else
				*r = urlstr[i];
		}
		else
		{
			*r = urlstr[i];
		}
	}
	*r = '\0';
	return res;
}

static char * url_decode_html(urlstr, len)
char *urlstr;
int len;
{
	char *res,*r;
	int i;

	if (urlstr == NULL) return NULL;

	res = new_n_string(urlstr,len);

	for (i = 0 , r = res ; i < len ; r++ , i++)
	{
		if (urlstr[i] == '&')
		{
			if (!strncmp(urlstr + i + 1,"amp;" , 4) || !strncmp(urlstr + i + 1, "#38;" , 4))
				i += 4;
			else
				*r = urlstr[i];
		}
		else
		{
			*r = urlstr[i];
		}
	}
	*r = '\0';
	return res;
}


/*************************************/
/* uvolnenie pamate po strukture URL */
/*************************************/
void free_deep_url(urlp)
url *urlp;
{
	switch(urlp->type)
	{
		case URLT_FILE:
			_free(urlp->p.file.filename);
			_free(urlp->p.file.searchstr);
			_free(urlp->p.file.anchor_name);
			break;
		case URLT_HTTP:
		case URLT_HTTPS:
			_free(urlp->p.http.host);
			_free(urlp->p.http.document);
			_free(urlp->p.http.searchstr);
			_free(urlp->p.http.anchor_name);
			_free(urlp->p.http.password);
			_free(urlp->p.http.user);
			if (urlp->status & URL_FORM_ACTION)
			{
				form_info *fi = (form_info *)urlp->extension;
				dllist *ptr;

				_free(fi->text);
				_free(fi->action);
				ptr = fi->infos;
				while (ptr)
				{
					form_field *ff = (form_field *) ptr->data;

					_free(ff->value);
					_free(ff->name);
					_free(ff);

					ptr = dllist_remove_entry(ptr, ptr);
				}
			}
			break;
		case URLT_FTP:
		case URLT_FTPS:
			_free(urlp->p.ftp.host);
			_free(urlp->p.ftp.user);
			_free(urlp->p.ftp.password);
			_free(urlp->p.ftp.anchor_name);
			_free(urlp->p.ftp.path);
			if (urlp->extension)
			{
				_free(((ftp_url_extension*)urlp->extension)->slink);
				_free(urlp->extension);
			}
			break;
		case URLT_GOPHER:
			_free(urlp->p.gopher.host);
			_free(urlp->p.gopher.selector);
		default:
			_free(urlp->p.unsup.urlstr);
			break;
	}

	_free(urlp->parent_url);
	_free(urlp->local_name);
	
#ifdef WITH_TREE
#ifdef I_FACE
	_free(urlp->tree_nfo);

	if (urlp->prop)
	{
		_free(urlp->prop->type);
		free(urlp->prop);
	}

#endif
#endif
}

void append_url_to_list(urlp)
url *urlp;
{
	if (!prottable[urlp->type].supported)
	{
		xprintf(1 , gettext("unsupported URL type \"%s\"\n") , 
			prottable[urlp->type].urlid ? prottable[urlp->type].urlid :
			gettext("unknown"));
		return;
	}

	urlp->ref_cnt = 1;

	cfg.urlstack = dllist_append(cfg.urlstack , urlp);
	cfg.total_cnt++;

	url_add_to_hash_tab(urlp);

	if (!urlp->parent_url)
	{
		urlp->parent_url = _malloc(sizeof(url *));
		urlp->parent_url[0] = NULL;
	}

#ifdef WITH_TREE
#ifdef I_FACE
	if (cfg.xi_face)
	{
		urlp->tree_nfo = (GUI_TREE_RTYPE*) _malloc(sizeof(GUI_TREE_RTYPE));
		urlp->tree_nfo[0] = iface_make_tree_entry(urlp);
	}
#endif
#endif
}

void append_url_list_to_list(list, after)
dllist *list;
dllist *after;
{
	dllist *ptr;

	ptr = list;
	while(ptr)
	{
		url *urlp = (url *)ptr->data;

		urlp->ref_cnt = 1;

		if (!urlp->parent_url)
		{
			urlp->parent_url = _malloc(sizeof(url *));
			urlp->parent_url[0] = NULL;
		}

#ifdef WITH_TREE
#ifdef I_FACE
		if (cfg.xi_face)
		{
			urlp->tree_nfo = (GUI_TREE_RTYPE*) _malloc(sizeof(GUI_TREE_RTYPE));
			urlp->tree_nfo[0] = iface_make_tree_entry(urlp);
		}
#endif
#endif
		ptr = ptr->next;
	}
	if (after)
		cfg.urlstack = dllist_insert_list_after(cfg.urlstack , after , list);
	else
		cfg.urlstack = dllist_concat(cfg.urlstack , list);
}


void link_url_in_list(orig , copy)
url *orig;
url *copy;
{

	if (copy->parent_url && (orig != copy->parent_url[0]))
	{
		int i;
		bool found = FALSE;

		for (i = 0 ; i < orig->ref_cnt ; i++)
			if (orig->parent_url[i] == copy->parent_url[0]) found = TRUE;

		if (!found)
		{
			orig->ref_cnt ++;

			orig->parent_url = (url **)_realloc(orig->parent_url , (orig->ref_cnt + 1) * sizeof(url *));
			orig->parent_url[orig->ref_cnt - 1] = copy->parent_url[0];
			orig->parent_url[orig->ref_cnt] = NULL;

			if ((copy->parent_url[0]) && (orig->status & URL_MOVED) && (orig->status & URL_MOVED))
			{
				url *purl = orig;
				char *fn;

				while(purl->moved_to) purl = purl->moved_to;

				if (purl->status & URL_DOWNLOADED)
				{
					fn = url_to_filename(purl , TRUE);
					rewrite_one_parent_links(copy , copy->parent_url[0] , fn);
				}
			}
#ifdef WITH_TREE
#ifdef I_FACE
			if (cfg.xi_face)
			{
				orig->tree_nfo = (GUI_TREE_RTYPE*) _realloc(orig->tree_nfo , orig->ref_cnt *sizeof(GUI_TREE_RTYPE));
				orig->tree_nfo[orig->ref_cnt - 1] = iface_make_tree_entry(orig);
			}
#endif
#endif
		}
	}
}

int url_redirect_to(src , dst)
url *src;
url *dst;
{
	url *pomurl,*pomurl2;

	src->status |= URL_MOVED;

	url_clear_anchor(dst);
	if ((pomurl = url_was_befor(dst)))
	{
		free_deep_url(dst);
		_free(dst);
		pomurl2 = pomurl;
		while (pomurl2)
		{
			if (src == pomurl2) 
			{
				src->status &= ~URL_MOVED;
				return -1;
			}
			pomurl2 = pomurl2->moved_to;
		}

		pomurl->parent_url = _realloc(pomurl->parent_url , 
				(pomurl->ref_cnt + 2) * sizeof(url *));
		pomurl->parent_url[pomurl->ref_cnt] = src;
		pomurl->parent_url[pomurl->ref_cnt+1] = NULL;
		pomurl->ref_cnt ++;

		src->moved_to = pomurl;
		src->status |= URL_MOVED;

#ifdef WITH_TREE
#ifdef I_FACE
		if (cfg.xi_face)
		{
			pomurl->tree_nfo = (GUI_TREE_RTYPE*) _realloc(pomurl->tree_nfo , 
					(pomurl->ref_cnt) * sizeof(GUI_TREE_RTYPE));
			pomurl->tree_nfo[pomurl->ref_cnt-1] = iface_make_tree_entry(pomurl);
		}
#endif
#endif
		if ((pomurl->status & URL_MOVED) || (pomurl->status & URL_DOWNLOADED))
		{
			url *purl = pomurl;
			char *fn;

			xprintf(1 , gettext("Moved to already processed URL.\n"));

			if (pomurl->status & URL_MOVED)
			{
				while(purl->moved_to) purl = purl->moved_to;
				fn = url_to_filename(purl , TRUE);
			}
			else
				fn = url_to_filename(pomurl , TRUE);

			if (cfg.rewrite_links && (purl->status & URL_DOWNLOADED))
				rewrite_parents_links(src , fn);

		}
		
	}
	else
	{
		dst->parent_url = _malloc(2 * sizeof(url *));
		dst->parent_url[0] = src;
		dst->parent_url[1] = NULL;
		src->moved_to = dst;
		src->status |= URL_MOVED;

		if (src->status & URL_FORM_ACTION)
		{
			form_info *cfi,*ofi;
			dllist *ptr;

			dst->status |= URL_FORM_ACTION;

			ofi = (form_info *) src->extension;
			cfi = _malloc(sizeof(form_info));

			cfi->method = ofi->method;
			cfi->encoding = ofi->encoding;
			cfi->action = NULL;
			cfi->text = NULL;
			cfi->infos = NULL;

			ptr = ofi->infos;
			while (ptr)
			{
				form_field *off,*cff;

				off = (form_field *) ptr->data;
				cff = _malloc(sizeof(form_field));
				cff->type = off->type;
				cff->name = new_string(off->name);
				cff->value = new_string(off->value);

				cfi->infos = dllist_append(cfi->infos, cff);

				ptr = ptr->next;
			}
			dst->extension = cfi;
		}

		url_add_to_hash_tab(dst);

#ifdef WITH_TREE
#ifdef I_FACE
		if (cfg.xi_face)
		{
			dst->tree_nfo = (GUI_TREE_RTYPE*) _malloc(sizeof(GUI_TREE_RTYPE));
			dst->tree_nfo[0] = iface_make_tree_entry(dst);
		}
#endif
#endif
	}
	return 0;
}

void url_add_to_hash_tab(urlp)
url *urlp;
{
	url_clear_anchor(urlp);

	if (!prottable[urlp->type].supported) return;
	LOCK_CFG_URLHASH
	dlhash_insert(cfg.url_hash_tbl , urlp);
	dlhash_insert(cfg.fn_hash_tbl , urlp);
	UNLOCK_CFG_URLHASH
}

void url_remove_from_hash_tab(urlp)
url *urlp;
{
	if (!prottable[urlp->type].supported) return;

	LOCK_CFG_URLHASH
	dlhash_exclude(cfg.url_hash_tbl, urlp);
	dlhash_exclude(cfg.fn_hash_tbl, urlp);
	UNLOCK_CFG_URLHASH
}

/**********************************************/
/* kopirovanie obsahu na nove miesto v pamati */
/**********************************************/
url *new_url(urlo)
url *urlo;
{
	url *res = (url *)_malloc(sizeof(url));

	memcpy(res , urlo , sizeof(url));

	return res;
}


char *url_get_default_local_name(urlp)
url *urlp;
{
	char *pom2 = NULL;
	char pbuf[50];
	char *p;

	sprintf(pbuf, "_%d" , url_get_port(urlp));

	switch(urlp->type)
	{
		case URLT_HTTP:
		case URLT_HTTPS:
			pom2 = tl_str_concat(pom2 ,
				prottable[urlp->type].dirname , "/" ,
				urlp->p.http.host , pbuf , "/" ,
				urlp->p.http.document , NULL);

			if (urlp->p.http.searchstr)
			{
				p = url_decode_str(urlp->p.http.searchstr, strlen(urlp->p.http.searchstr));
				pom2 = tl_str_concat(pom2 , "?", p, NULL);
				free(p);
			}
			if (tl_is_dirname(pom2))
				pom2 = tl_str_append(pom2, cfg.index_name);
			break;

		case URLT_FILE:
			pom2 = new_string(urlp->p.file.filename);
			if (urlp->p.file.searchstr)
			{
				p = url_decode_str(urlp->p.file.searchstr, strlen(urlp->p.file.searchstr));
				pom2 = tl_str_concat(pom2 , "?", p, NULL);
				free(p);
			}
			break;
		case URLT_FTP:
		case URLT_FTPS:
			pom2 = tl_str_concat(pom2,
				prottable[urlp->type].dirname , "/" ,
				urlp->p.ftp.host , pbuf , "/" ,
				urlp->p.ftp.path ,
				urlp->p.ftp.dir ? "/" : NULL ,
				cfg.index_name, NULL);
			break;
		case URLT_GOPHER:
			pom2 = tl_str_concat(pom2,
				prottable[URLT_GOPHER].dirname , "/" ,
				urlp->p.gopher.host , pbuf ,
				urlp->p.gopher.selector ,
				(urlp->p.gopher.selector[0] == '1') ? cfg.index_name : NULL ,
				NULL);
			break;
		default:
			return NULL;
	}
	return pom2;
}

/**********************************************/
static char *url_get_local_name(urlp)
url *urlp;
{
	char *pom = NULL;
	char *pom2 = NULL;
	char *p1,*p2;
	char *p;
	int isdinfo = FALSE;
	struct stat estat;

	if ((urlp->status & URL_ISFIRST) &&
		cfg.store_name && cfg.mode == MODE_SINGLE)
	{
		return get_abs_file_path_oss(cfg.store_name);
	}

	if (urlp->type == URLT_FILE)
		pom = url_get_default_local_name(urlp);
	else
		pom2 = url_get_default_local_name(urlp);

	if (pom2)
	{
		char *trs;

		if (urlp->type != URLT_FILE)
		{
			trs = tr(urlp , pom2 , &isdinfo);
			_free(pom2);
			if (tl_is_dirname(trs))
				pom = tl_str_concat(pom , cfg.cache_dir ,
					(*trs == '/' ? "" : "/") , trs,
					cfg.index_name, NULL);
			else
				pom = tl_str_concat(pom , cfg.cache_dir ,
					(*trs == '/' ? "" : "/") , trs, NULL);
			_free(trs);
		}
		else
		{
			pom = pom2;
			pom2 = NULL;
		}
	}

#ifdef FS_UNSAFE_CHARACTERS
	/* This is for automatic handling of windoze	*/
	/* filesystem unsafe characters	- \:*?"<>|	*/
	if (urlp->type != URLT_FILE && strlen(pom) != strcspn(pom , FS_UNSAFE_CHARACTERS))
	{
		if (strchr(FS_UNSAFE_CHARACTERS, '_'))
			p = tr_del_chr(pom , FS_UNSAFE_CHARACTERS);
		else
			p = tr_chr_chr(pom , FS_UNSAFE_CHARACTERS , '_');
		_free(pom);
		pom = p;
	}
#endif

	/* adjusting of filename size if required	 */
	if (urlp->type != URLT_FILE && tl_filename_needs_adjust(pom))
	{
		p = tl_adjust_filename(pom);
		_free(pom);
		pom = p;
	}

	if (!stat(pom , &estat) && S_ISDIR(estat.st_mode))
        {
                pom = tl_str_concat(pom , "/" , cfg.index_name, NULL);
        }

	if ((urlp->type != URLT_FILE) && cfg.base_level && !isdinfo)
	{
		p = get_abs_file_path_oss(pom);
		_free(pom);
		pom = p;
		p1 = pom + strlen(cfg.cache_dir) + 
			(tl_is_dirname(cfg.cache_dir) == 0);

		if (!(p2 = strfindnchr(p1 , '/' , cfg.base_level)))
		{
			if ((p2 = strrchr(pom , '/'))) p2 ++;
		}

		if (p2)
			memmove(p1 , p2 , strlen(p2) + 1);
	}

	/* this is here for ensure, that we	*/
	/* don't have directory as filename :-)	*/
	if (tl_is_dirname(pom))
		pom = tl_str_append(pom , cfg.index_name);

	p = get_abs_file_path_oss(pom);
	_free(pom);

	return p;
}

/******************************************************/
/* k danemu URL vytvori meno suboru v lokalnom strome */
/******************************************************/
char *url_to_filename(urlp, lockfn)
url *urlp;
int lockfn;
{
	char *p;

	LOCK_GETLFNAME
	if (!urlp->local_name && prottable[urlp->type].supported)
	{
		p = url_get_local_name(urlp);
		if (cfg.enable_info  && urlp->type != URLT_FILE &&
                	!(urlp->status & URL_REDIRECT))
		{
			char *di = dinfo_get_unique_name(urlp , p , lockfn);
			if (di)
			{
				_free(p);
				p = di;
			}
		}
		else if (!cfg.enable_info && 
			urlp->type != URLT_FILE && !(urlp->status & URL_REDIRECT))
		{
			/*** such filename have already other URL   ***/
			/*** we need to compute new unique filename ***/
			char *f;
			char *pom;
			int i;
			void *inhash;

			LOCK_CFG_URLHASH
			inhash = dlhash_find_by_key(cfg.fn_hash_tbl , p);
			UNLOCK_CFG_URLHASH
			if (inhash)
			{
				pom = _malloc(strlen(p) + 6);

				f = strrchr(p , '/');
				if (!f) f = "";
				else
				{
					*f='\0';
					f++;
				}

				i = 0;
				do
				{
					i++;
					sprintf(pom , "%s/%03d%s" , p , i , f);
					LOCK_CFG_URLHASH
					inhash = dlhash_find_by_key(cfg.fn_hash_tbl , pom);
					UNLOCK_CFG_URLHASH
				} while (inhash);

				_free(p);
				p = pom;
			}
		}
		urlp->local_name = p;
	}
	UNLOCK_GETLFNAME
	return urlp->local_name;
}

/******************************************************/
/* k danemu URL vytvori meno suboru v lokalnom strome */
/******************************************************/
void url_changed_filename(urlp)
url *urlp;
{
	_free(urlp->local_name);
	urlp->local_name = url_get_local_name(urlp);
}

/****************************************************************/
/* k danemu URL vytvori meno docasneho suboru v lokalnom strome */
/****************************************************************/
char *url_to_in_filename(urlp)
url *urlp;
{
	char *pom;
	char *p;

	if (cfg.mode == MODE_NOSTORE || cfg.mode == MODE_FTPDIR)
	{
		pom = _malloc(strlen(cfg.cache_dir) + 25);
		sprintf(pom , "%s/.in_pavuk_nostore_%d" , cfg.cache_dir ,
			getpid());
		return pom;
	}

	p = url_to_filename(urlp , TRUE);

	pom = _malloc(strlen(p) + 5);
	strcpy(pom , p);
	p = strrchr(pom , '/');
	if (!p) p = pom;
	else p++;
	memmove(p + 4 , p , strlen(p) + 1);
	strncpy(p, ".in_" , 4);
		
	return pom;
}

/************************************************/
/* zo struktury URL vytvori retazec URL + hesla */
/************************************************/
char *url_to_urlstr(urlp , wa)
url *urlp;
int wa;
{
	char *p;
	char portstr[10];
	char *retv;

	sprintf(portstr , ":%d" ,  url_get_port(urlp));
	switch(urlp->type)
	{
		case URLT_HTTP:
		case URLT_HTTPS:
			retv = _malloc(strlen(prottable[urlp->type].typestr) +
				(urlp->p.http.user ? strlen(urlp->p.http.user)+1 : 0) +
				(urlp->p.http.password ? strlen(urlp->p.http.password)+1 : 0) +
				strlen(urlp->p.http.host) +
				(urlp->p.http.port == prottable[urlp->type].default_port ? 0 : strlen(portstr) + 1) +
				strlen(urlp->p.http.document) +
				(urlp->p.http.searchstr ? strlen(urlp->p.http.searchstr)+1 : 0) +
				(urlp->p.http.anchor_name ? strlen(urlp->p.http.anchor_name)+1 : 0) + 1);
				

			sprintf(retv ,"%s%s%s%s%s%s%s%s%s%s%s%s", prottable[urlp->type].typestr ,
				urlp->p.http.user ? urlp->p.http.user : "" ,
				urlp->p.http.password ? ":" : "" ,
				urlp->p.http.password ? urlp->p.http.password : "" ,					
				(urlp->p.http.password || urlp->p.http.user) ? "@" : "" ,
				urlp->p.http.host , 
				(urlp->p.http.port == prottable[urlp->type].default_port ? "" : portstr) ,
				urlp->p.http.document ,
				urlp->p.http.searchstr ? "?" : "" ,
				urlp->p.http.searchstr ? urlp->p.http.searchstr : "" ,
				wa && urlp->p.http.anchor_name ? "#" : "" ,
				wa && urlp->p.http.anchor_name ? urlp->p.http.anchor_name : "");

			if (!urlp->p.http.searchstr &&
				(urlp->status & URL_FORM_ACTION) &&
				(((form_info *)urlp->extension)->method == FORM_M_GET))
			{
				char *ss;

				ss = form_encode_urlencoded(((form_info *)urlp->extension)->infos);
				if (ss)
					retv = tl_str_concat(retv, "?" , ss , NULL);
				_free(ss);
			}

			return retv;
		case URLT_FILE:
			p = get_abs_file_path(urlp->p.file.filename);
			retv = _malloc(strlen(prottable[URLT_FILE].typestr) +
				strlen(p) +
				(urlp->p.file.searchstr ? strlen(urlp->p.file.searchstr) + 1 : 0) +
				((wa && urlp->p.file.anchor_name) ? strlen(urlp->p.file.anchor_name) + 1 : 0) + 1);

			sprintf(retv ,"%s%s%s%s%s%s", prottable[URLT_FILE].typestr , p ,
				urlp->p.file.searchstr ? "?" : "" ,
				urlp->p.file.searchstr ? urlp->p.http.searchstr : "" ,
				urlp->p.file.anchor_name ? "#" : "" ,
				urlp->p.file.anchor_name ? urlp->p.file.anchor_name : "");

			free(p);

			return retv;
		case URLT_FTP:
		case URLT_FTPS:
			retv = _malloc(strlen(prottable[urlp->type].typestr) +
				(urlp->p.ftp.user ? strlen(urlp->p.ftp.user)+1 : 0) +
				(urlp->p.ftp.password ? strlen(urlp->p.ftp.password)+1 : 0) +
				strlen(urlp->p.ftp.host) +
				(urlp->p.ftp.port == prottable[urlp->type].default_port ? 0 : strlen(portstr)+1) +
				strlen(urlp->p.ftp.path) +
				(urlp->p.ftp.anchor_name ? strlen(urlp->p.ftp.anchor_name)+1 : 0) + 1);

			sprintf(retv , "%s%s%s%s%s%s%s%s%s%s", prottable[urlp->type].typestr ,
				urlp->p.ftp.user ? urlp->p.ftp.user : "" ,
				urlp->p.ftp.password ? ":" : "" ,
				urlp->p.ftp.password ? urlp->p.ftp.password : "" ,					
				(urlp->p.ftp.password || urlp->p.ftp.user) ? "@" : "" ,
				urlp->p.ftp.host , 
				(urlp->p.ftp.port == prottable[urlp->type].default_port ? "" : portstr) ,
				urlp->p.ftp.path ,
				wa && urlp->p.ftp.anchor_name ? "#" : "" ,
				wa && urlp->p.ftp.anchor_name ? urlp->p.ftp.anchor_name : "");

			return retv;
		case URLT_GOPHER:
			retv = _malloc(strlen(prottable[URLT_GOPHER].typestr) +
				strlen(urlp->p.gopher.host) +
				(urlp->p.gopher.port == prottable[urlp->type].default_port ? 0 : strlen(portstr)+1) +
				strlen(urlp->p.gopher.selector) + 2);
				

			sprintf(retv , "%s%s%s/%s" , prottable[URLT_GOPHER].typestr ,
				urlp->p.gopher.host ,
				(urlp->p.gopher.port == prottable[urlp->type].default_port ? "" : portstr) ,
				urlp->p.gopher.selector);
	
			return retv;
		default:
			return NULL;
	}
}


/****************************************************/
/* zo struktury URL vytvori retazec URL - bez hesla */
/****************************************************/
char *url_to_urlstr_woauth(urlp, with_auth)
url *urlp;
int with_auth;
{
	char *p,*p2,*unam = NULL,*pass = NULL;
	char *retv;
	char portstr[10];

	sprintf(portstr , ":%d" ,  url_get_port(urlp));
	
	switch(urlp->type)
	{
		case URLT_HTTP:
		case URLT_HTTPS:
			p = url_encode_str(urlp->p.http.document, URL_PATH_UNSAFE);
			p2 = urlp->p.http.searchstr ? url_encode_str(urlp->p.http.searchstr, URL_QUERY_UNSAFE) : NULL;
			if (with_auth)
			{
				pass = urlp->p.http.password ? url_encode_str(urlp->p.http.password, URL_AUTH_UNSAFE) : NULL;
				unam = urlp->p.http.user ? url_encode_str(urlp->p.http.password, URL_AUTH_UNSAFE) : NULL;
			}
			retv = _malloc(strlen(prottable[urlp->type].typestr) +
				(unam ? strlen(unam) + 1 : 0) +
				(pass ? strlen(pass) + 1 : 0) +
				strlen(urlp->p.http.host) +
				(urlp->p.http.port == prottable[urlp->type].default_port ? 0 : 1 + strlen(portstr)) +
				strlen(p) +
				(p2 ? strlen(p2) + 1 : 0) + 
				(urlp->p.http.anchor_name ? strlen(urlp->p.http.anchor_name) + 1 : 0) + 1);

			sprintf(retv ,"%s%s%s%s%s%s%s%s%s%s%s%s", prottable[urlp->type].typestr ,
				unam ? unam : "" ,
				pass ? ":" : "" ,
				pass ? pass : "" ,
				(pass || unam) ? "@" : "" ,
				urlp->p.http.host ,
 				(urlp->p.http.port == prottable[urlp->type].default_port ? "" : portstr) ,
				p ,
				p2 ? "?" : "" ,
				p2 ? p2 : "" ,
				urlp->p.http.anchor_name ? "#" : "" ,
				urlp->p.http.anchor_name ? urlp->p.http.anchor_name : "");

			if (!urlp->p.http.searchstr &&
				(urlp->status & URL_FORM_ACTION) &&
				(((form_info *)urlp->extension)->method == FORM_M_GET))
			{
				char *ss;

				ss = form_encode_urlencoded(((form_info *)urlp->extension)->infos);
				if (ss)
					retv = tl_str_concat(retv, "?" , ss , NULL);
				_free(ss);
			}

			_free(p);
			_free(p2);
			_free(pass);
			_free(unam);
			return retv;
		case URLT_FILE:
			p = get_abs_file_path(urlp->p.file.filename);
			p2 = urlp->p.file.searchstr ? url_encode_str(urlp->p.file.searchstr, URL_QUERY_UNSAFE) : NULL;
			retv = _malloc(strlen(prottable[urlp->type].typestr) +
				strlen(p) + 
				(p2 ? strlen(p2) + 1 : 0) +
				(urlp->p.file.anchor_name ? strlen(urlp->p.file.anchor_name) + 1 : 0) + 1);

			sprintf(retv ,"%s%s%s%s%s%s", prottable[URLT_FILE].typestr , p ,
				p2 ? "?" : "" ,
				p2 ? p2 : "" ,
				urlp->p.file.anchor_name ? "#" : "" ,
				urlp->p.file.anchor_name ? urlp->p.file.anchor_name : "");
			_free(p);
			_free(p2);
			return retv;
		case URLT_FTP:
		case URLT_FTPS:
			p = url_encode_str(urlp->p.ftp.path, URL_PATH_UNSAFE);
			if (with_auth)
			{
				pass = urlp->p.ftp.password ? url_encode_str(urlp->p.ftp.password, URL_AUTH_UNSAFE) : NULL;
				unam = urlp->p.ftp.user ? url_encode_str(urlp->p.ftp.user, URL_AUTH_UNSAFE) : NULL;
			}
			retv = _malloc(strlen(prottable[urlp->type].typestr) +
				(pass ? strlen(pass) + 1 : 0) +
				(unam ? strlen(unam) + 1 : 0) +
				strlen(urlp->p.ftp.host) +
				(urlp->p.ftp.port == prottable[urlp->type].default_port ? 0 : 1 + strlen(portstr)) +
				strlen(p) +
				(urlp->p.ftp.anchor_name ? strlen(urlp->p.ftp.anchor_name) + 1 : 0) + 1);

			sprintf(retv , "%s%s%s%s%s%s%s%s%s%s", prottable[urlp->type].typestr ,
				unam ? unam : "" ,
				pass ? ":" : "" ,
				pass ? pass : "" ,
				(pass || unam) ? "@" : "" ,
				urlp->p.ftp.host , 
				(urlp->p.ftp.port == prottable[urlp->type].default_port ? "" : portstr) , 
				p ,
				urlp->p.ftp.anchor_name ? "#" : "" ,
				urlp->p.ftp.anchor_name ? urlp->p.ftp.anchor_name : "");
			_free(p);
			_free(pass);
			_free(unam);
			return retv;
		case URLT_GOPHER:
			p = url_encode_str(urlp->p.gopher.selector, URL_PATH_UNSAFE);
			retv = _malloc(strlen(prottable[urlp->type].typestr) +
				strlen(urlp->p.gopher.host) +
				(urlp->p.gopher.port == prottable[urlp->type].default_port ? 0 : strlen(portstr) + 1) +
				+ strlen(p) + 2);
			sprintf(retv , "%s%s%s/%s" , prottable[urlp->type].typestr ,
				urlp->p.gopher.host ,
				(urlp->p.gopher.port == prottable[urlp->type].default_port ? "" : portstr) ,
				p);
			_free(p);
			return retv;
		default:
			return NULL;
	}
}


/********************************************************/
/* z URL vrati adresu servera pre dokument		*/
/********************************************************/
char *url_get_site(urlr)
url *urlr;
{
	switch(urlr->type)
	{
		case URLT_HTTP:
		case URLT_HTTPS:
			return urlr->p.http.host;
		case URLT_FTP:
		case URLT_FTPS:
			return urlr->p.ftp.host;
		case URLT_GOPHER:
			return urlr->p.gopher.host;
		default: return NULL;
	}
}

int url_get_port(urlr)
url *urlr;
{
	switch(urlr->type)
	{
                case URLT_HTTP:
                case URLT_HTTPS:
                        return urlr->p.http.port;
                case URLT_FTP:
                case URLT_FTPS:
                        return urlr->p.ftp.port;
                case URLT_GOPHER:
                        return urlr->p.gopher.port;
                default: return 0;
	}
}

char *url_get_path(urlr)
url *urlr;
{
	switch(urlr->type)
	{
		case URLT_HTTP:
		case URLT_HTTPS:
			return urlr->p.http.document;
		case URLT_FTP:
		case URLT_FTPS:
			return urlr->p.ftp.path;
		case URLT_GOPHER:
			return urlr->p.gopher.selector;
		case URLT_FILE:
			return urlr->p.file.filename;
		default: return NULL;
	}
}

void url_set_path(urlr, path)
url *urlr;
char *path;
{
	switch(urlr->type)
	{
		case URLT_HTTP:
		case URLT_HTTPS:
			_free(urlr->p.http.document);
			urlr->p.http.document = new_string(path);
			break;
		case URLT_FTP:
		case URLT_FTPS:
			_free(urlr->p.ftp.path);
			urlr->p.ftp.path = new_string(path);
			break;
		case URLT_GOPHER:
			_free(urlr->p.gopher.selector);
			urlr->p.gopher.selector = new_string(path);
			break;
		case URLT_FILE:
			_free(urlr->p.file.filename);
			urlr->p.file.filename = new_string(path);
			break;
		default: return;
	}
	url_changed_filename(urlr);
}

char * url_get_pass(urlr , realm)
url *urlr;
char *realm;
{
	char *pass = NULL;
	authinfo *ai;

	switch(urlr->type)
	{
                case URLT_HTTP:
                case URLT_HTTPS:
                        pass = urlr->p.http.password;
			break;
                case URLT_FTP:
                case URLT_FTPS:
                        pass = urlr->p.ftp.password;
			break;
                default: return NULL;
	}

	if (!pass)
	{
		ai = authinfo_match_entry(urlr->type , url_get_site(urlr) , 
					  url_get_port(urlr) , url_get_path(urlr) , realm);
		if (ai) pass = ai->pass;
	}

	if (!pass)
	{
		pass = cfg.passwd_auth;
	}

	return pass;
}

char * url_get_user(urlr , realm)
url *urlr;
char *realm;
{
	char *user = NULL;
	authinfo *ai;

	switch(urlr->type)
	{
                case URLT_HTTP:
                case URLT_HTTPS:
                        user = urlr->p.http.user;
			break;
                case URLT_FTP:
                case URLT_FTPS:
                        user = urlr->p.ftp.user;
                       	break;
                default: return NULL;
	}

	if (!user)
	{
		ai = authinfo_match_entry(urlr->type , url_get_site(urlr) , 
					  url_get_port(urlr) , url_get_path(urlr) , realm);
		if (ai) user = ai->user;
	}

	if (!user)
	{
		user = cfg.name_auth;
	}
	
	return user;
}

int url_get_auth_scheme(urlr , realm)
url *urlr;
char *realm;
{
	authinfo *ai;
	int scheme = cfg.auth_scheme;

	ai = authinfo_match_entry(urlr->type , url_get_site(urlr) , 
				  url_get_port(urlr) , url_get_path(urlr) , realm);
	if (ai) scheme = ai->type;

	return scheme;
}

char * url_get_anchor_name(urlp)
url *urlp;
{
	char *anchor;

	switch(urlp->type)
	{
		case URLT_HTTP:
		case URLT_HTTPS:
			anchor = urlp->p.http.anchor_name;
			break;
		case URLT_FTP:
		case URLT_FTPS:
			anchor = urlp->p.ftp.anchor_name;
			break;
		case URLT_FILE:
			anchor = urlp->p.file.anchor_name;
			break;
		default:
			anchor = NULL;
			break;
	}

	return anchor;
}

void url_clear_anchor(urlp)
url *urlp;
{
	switch(urlp->type)
	{
		case URLT_HTTP:
		case URLT_HTTPS:
			_free(urlp->p.http.anchor_name);
			break;
		case URLT_FTP:
		case URLT_FTPS:
			_free(urlp->p.ftp.anchor_name);
			break;
		case URLT_FILE:
			_free(urlp->p.file.anchor_name);
			break;
		default:
			break;
	}
}

char * url_get_search_str(urlp)
url *urlp;
{
	char *sstr;

	switch(urlp->type)
	{
		case URLT_HTTP:
		case URLT_HTTPS:
			sstr = urlp->p.http.searchstr;
			break;
		case URLT_FILE:
			sstr = urlp->p.file.searchstr;
			break;
		default:
			sstr = NULL;
			break;
	}

	return sstr;
}

int url_is_dir_index(urlp)
url *urlp;
{
	return ((urlp->type == URLT_HTTP || urlp->type == URLT_HTTPS) &&
		tl_is_dirname(urlp->p.http.document)) ||
		((urlp->type == URLT_FTP || urlp->type == URLT_FTPS) && urlp->p.ftp.dir);

}

/**************************************************/
/* absolutna cesta k dokumentu z lokalneho stromu */
/* ktory je referencovany relativne		  */
/**************************************************/
char *get_redirect_abs_path(rurl , fstr)
url *rurl;
char *fstr;
{
	char *pom , *p , *p1;
	
	pom = new_string(url_to_filename(rurl , TRUE));
	p = strrchr(pom , '/');

	p1 = realloc(pom , strlen(fstr) + (p - pom) + 2);
	strcpy(p1 + (p - pom) + 1 , fstr);

	p = get_abs_file_path_oss(p1);
	free(p1);
	
	return p;
}

void url_path_abs(urlp)
url *urlp;
{
	char *p;

	switch (urlp->type)
	{
		case URLT_HTTP:
		case URLT_HTTPS:
			p = get_abs_file_path(urlp->p.http.document);
			free(urlp->p.http.document);
			urlp->p.http.document = p;
			break;
		case URLT_FTP:
		case URLT_FTPS:
			p = get_abs_file_path(urlp->p.ftp.path);
			if (urlp->p.ftp.path[0] == '/' && urlp->p.ftp.path[1] == '/')
			{
				char *pp = tl_str_concat(NULL, "/", p, NULL);
				_free(p);
				p = pp;
			}
			free(urlp->p.ftp.path);
			urlp->p.ftp.path = p;
			break;
		case URLT_FILE:
			p = get_abs_file_path(urlp->p.file.filename);
			free(urlp->p.file.filename);
			urlp->p.file.filename = p;
			break;
		default:
			break;
	}
}

url *filename_to_url(ifn)
char *ifn;
{
	int cdln = strlen(cfg.cache_dir);
	bool isok = FALSE;

	if (*ifn != '/') return NULL;

	if (cfg.enable_info)
	{
		url *nurl = dinfo_get_url_for_filename(ifn);

		if (nurl) return nurl;
	}

	if (!strncmp(ifn , cfg.cache_dir , cdln))
	{
		char *p;
		int i;
		url *nurl = _malloc(sizeof(url));
		char *fn = new_string(ifn);

		p = fn + cdln;
		p += (*p == '/');
		
		nurl->status = 0;
		nurl->level = 0;
		nurl->parent_url = NULL;
		nurl->moved_to = NULL;
		nurl->extension = NULL;
		nurl->local_name = new_string(ifn);

#ifdef WITH_TREE
#ifdef I_FACE
		nurl->prop = NULL;
		nurl->tree_nfo = NULL;
#endif
#endif

		for (i = 0 ; i < NUM_ELEM(prottable) ; i++)
		{
			if (prottable[i].dirname && 
			    !strncmp(p , prottable[i].dirname , 
				strlen(prottable[i].dirname)))
			{
				isok = TRUE;
			}
		}
		if (isok)
		{
			char *p2,*p3;

			nurl->type = prottable[i].id;
			nurl->parent_url = NULL;
			p += strlen(prottable[i].dirname) + 1;

			if (!p)
			{
				free(nurl);
				free(fn);
				return NULL;
			}

			switch (nurl->type)
			{
			    case URLT_HTTP:
			    case URLT_HTTPS:
				nurl->p.http.password = NULL;
				nurl->p.http.user = NULL;
				nurl->p.http.anchor_name = NULL;
				nurl->p.http.searchstr = NULL;
				nurl->p.http.port = prottable[i].default_port;
				if ((p2 = strchr(p , '/')))
				{
					int p2_len = strlen(p2);
					int idx_len = strlen(cfg.index_name);

					if (idx_len <= p2_len &&
					    !strcmp((p2 + p2_len - idx_len) , cfg.index_name) && 
					    ((p2_len > idx_len && *(p2 + p2_len - idx_len - 1) == '/') || idx_len == p2_len))
					{
						*(p2 + p2_len - idx_len) = '\0';
					}

					p3 = strchr(p2 , '?');
					if (p3)
					{
						*p3 = '\0';
						nurl->p.http.searchstr = new_string(p3+1);
					}
					nurl->p.http.document = new_string(p2);
					*p2 = '\0';
					p2 = strrchr(p , '_');
					if (p2)
					{
						p2++;
						nurl->p.http.port = _atoi(p2);
						if (errno == ERANGE)
						{
							nurl->p.http.host = 
								new_string(p);
							nurl->p.http.port = prottable[i].default_port;
						}
						else
						{
							nurl->p.http.host = 
								new_n_string(p , p2 - p - 1);
						}
					}
					else nurl->p.http.host = new_string(p);
				}
				else
				{
					free(nurl);
					free(fn);
					return NULL;
				}
				break;
			    case URLT_GOPHER:
				nurl->p.gopher.port = prottable[i].default_port;
				if ((p2 = strchr(p , '/')))
				{
					int p2_len = strlen(p2);
					int idx_len = strlen(cfg.index_name);

					p2++;

					if (idx_len <= p2_len &&
					    !strcmp((p2 + p2_len - idx_len) , cfg.index_name) && 
					    ((p2_len > idx_len && *(p2 + p2_len - idx_len - 1) == '1') || idx_len == p2_len))
					{
						*(p2 + p2_len - idx_len) = '\0';
					}
					nurl->p.gopher.selector = 
						new_string(p2);
					*p2 = '\0';
					p2 = strrchr(p , '_');
					if (p2)
					{
						p2++;
						nurl->p.gopher.port = _atoi(p2);
						if (errno == ERANGE)
						{
							nurl->p.gopher.host = 
								new_string(p);
							nurl->p.gopher.port = prottable[i].default_port;
						}
						else
						{
							nurl->p.gopher.host = 
								new_n_string(p , p2 - p - 1);
						}
					}
					else nurl->p.gopher.host = new_string(p);
				}
				else
				{
					free(nurl);
					free(fn);
					return NULL;
				}
				break;
			    case URLT_FTP:
			    case URLT_FTPS:
				nurl->p.ftp.port = prottable[i].default_port;
				nurl->p.ftp.password = NULL;
				nurl->p.ftp.user = NULL;
				nurl->p.ftp.dir = FALSE;
				nurl->p.ftp.anchor_name = NULL;
				if ((p2 = strchr(p , '/')))
				{
					int p2_len = strlen(p2);
					int idx_len = strlen(cfg.index_name);

					if (idx_len <= p2_len &&
					    !strcmp((p2 + p2_len - idx_len) , cfg.index_name) && 
					    ((p2_len > idx_len && *(p2 + p2_len - idx_len - 1) == '/') || idx_len == p2_len))
					{
						*(p2 + p2_len - idx_len) = '\0';
						nurl->p.ftp.dir = TRUE;
					}
					nurl->p.ftp.path = new_string(p2);
					*p2 = '\0';
					p2 = strrchr(p , '_');
					if (p2)
					{
						p2++;
						nurl->p.ftp.port = _atoi(p2);
						if (errno == ERANGE)
						{
							nurl->p.ftp.host = 
								new_string(p);
							nurl->p.ftp.port = prottable[i].default_port;
						}
						else
						{
							nurl->p.ftp.host = 
								new_n_string(p , p2 - p - 1);
						}
					}
					else nurl->p.ftp.host = new_string(p);
				}
				else
				{
					free(nurl);
					free(fn);
					return NULL;
				}
				break;
			    default:
				free(nurl);
				nurl = NULL;
				break;
			}
			free(fn);
			return nurl;
		}
		free(nurl);
	}
	return NULL;
}

/****************************************/
/* zisti ci bol dokument referencovany  */ 
/* v predchadzajucich cykloch		*/
/****************************************/
url *url_was_befor(urlp)
url *urlp;
{
	url *ret;

	if (!prottable[urlp->type].supported) return NULL;

	LOCK_CFG_URLHASH
	ret = (url *)dlhash_find(cfg.url_hash_tbl , urlp);
	UNLOCK_CFG_URLHASH

	return ret;
}

void url_forget_filename(urlp)
url *urlp;
{
	url_remove_from_hash_tab(urlp);
	_free(urlp->local_name);
	url_add_to_hash_tab(urlp);
}

int url_compare(u1, u2)
url *u1;
url *u2;
{
	int rv;

	if (u1->type != u2->type)
		return u1->type - u2->type;

	switch (u1->type)
	{
		case URLT_HTTP:
		case URLT_HTTPS:
			if ((rv = strcmp(u1->p.http.document, u2->p.http.document)))
				return !rv;

			if (u1->p.http.searchstr && u2->p.http.searchstr)
				rv = strcmp(u1->p.http.searchstr , u2->p.http.searchstr);
			else
				rv = u1->p.http.searchstr - u2->p.http.searchstr;

			if (rv) return !rv;

			if (u1->p.http.user && u2->p.http.user)
				rv = strcmp(u1->p.http.user , u2->p.http.user);
			else
				rv = u1->p.http.user - u2->p.http.user;

			if (rv) return !rv;

			if (u1->p.http.password && u2->p.http.password)
				rv = strcmp(u1->p.http.password , u2->p.http.password);
			else
				rv = u1->p.http.password - u2->p.http.password;

			if (rv) return !rv;

			if ((rv = strcmp(u1->p.http.host, u2->p.http.host)))
				return !rv;

			if (u1->p.http.port != u2->p.http.port)
				return FALSE;

			if ((u1->status & URL_FORM_ACTION) !=
			    (u2->status & URL_FORM_ACTION))
				return FALSE;

			if ((u1->status & URL_FORM_ACTION) &&
			    (u2->status & URL_FORM_ACTION))
			{
				dllist *ptr;
				form_info *fi1 = (form_info *) u1->extension;
				form_info *fi2 = (form_info *) u2->extension;

				if (fi1->method != fi2->method)
					return FALSE;
				if (fi1->encoding != fi2->encoding)
					return FALSE;

				ptr = fi1->infos;
				while (ptr)
				{
					if (!dllist_find2(fi2->infos, ptr->data, (dlcomp_func)form_field_compare))
						return FALSE;
					ptr = ptr->next;
				}
			}

			return TRUE;
		break;
		case URLT_FTP:
		case URLT_FTPS:
			if ((rv = strcmp(u1->p.ftp.path, u2->p.ftp.path)))
				return !rv;

			if (u1->p.ftp.user && u2->p.ftp.user)
				rv = strcmp(u1->p.ftp.user , u2->p.ftp.user);
			else
				rv = u1->p.ftp.user - u2->p.ftp.user;

			if (rv) return !rv;

			if (u1->p.ftp.password && u2->p.ftp.password)
				rv = strcmp(u1->p.ftp.password , u2->p.ftp.password);
			else
				rv = u1->p.ftp.password - u2->p.ftp.password;

			if (rv) return !rv;

			if ((rv = strcmp(u1->p.ftp.host, u2->p.ftp.host)))
				return !rv;

			return u1->p.ftp.port == u2->p.ftp.port;
		break;
		case URLT_GOPHER:
			if ((rv = strcmp(u1->p.gopher.selector, u2->p.gopher.selector)))
				return !rv;

			if ((rv = strcmp(u1->p.gopher.host, u2->p.gopher.host)))
				return !rv;

			return u1->p.gopher.port == u2->p.gopher.port;
		break;
		case URLT_FILE:
			if ((rv = strcmp(u1->p.file.filename, u2->p.file.filename)))
				return !rv;

			if (u1->p.file.searchstr && u2->p.file.searchstr)
				rv = strcmp(u1->p.file.searchstr , u2->p.file.searchstr);
			else
				rv = u1->p.file.searchstr - u2->p.file.searchstr;

			return !rv;
		break;
		default:
			return 0;
	}
	return 0;
}

url_info *url_info_new(urlstr)
char *urlstr;
{
	url_info *ui;

	ui = _malloc(sizeof(url_info));
	ui->urlstr = new_string(urlstr);
	ui->type = URLI_NORMAL;
	ui->fields = NULL;
	ui->encoding = FORM_E_UNKNOWN;
	ui->method = FORM_M_GET;

	return ui;
}

void url_info_free(ui)
url_info *ui;
{
	dllist *ptr;

	_free(ui->urlstr);

	if (ui->type == URLI_FORM)
	{
		for (ptr = ui->fields ; ptr ; ptr = dllist_remove_entry(ptr, ptr))
		{
			form_field *fi = (form_field *) ptr->data;

			_free(fi->name);
			_free(fi->value);
			_free(fi);
		}
	}

	_free(ui);
}

static struct {
	enum {
		_RQF_URL,
		_RQF_METHOD,
		_RQF_ENCODING,
		_RQF_FIELD,
		_RQF_FILE
	} type;
	char *str;
} _request_fields[] = {
	{_RQF_URL, "URL:"} ,
	{_RQF_METHOD, "METHOD:"},
	{_RQF_ENCODING, "ENCODING:"},
	{_RQF_FIELD, "FIELD:"},
	{_RQF_FILE, "FILE:"},
};

url_info *url_info_parse(str)
char *str;
{
	url_info *ui;
	char *p,*tp;
	int l;
	bool err = FALSE;
	bool found = FALSE;
	int i;

	ui = url_info_new(NULL);
	ui->type = URLI_FORM;

	p = str;
	while (!err && *p)
	{
		p += strspn(p , " \t");

		found = FALSE;
		for (i = 0; i < NUM_ELEM(_request_fields) ; i++)
		{
			if (!strncasecmp(p, _request_fields[i].str, strlen(_request_fields[i].str)))
			{
				found = TRUE;
				p += strlen(_request_fields[i].str);
				if (*p == '\"')
				{
					p++;
					l = strcspn(p , "\"");
				}
				else
					l = strcspn(p , " \t");
				if (!l)
					err = TRUE;

				break;
			}
		}
		if (err || !found)
		{
			err = TRUE;
			break;
		}
		switch(_request_fields[i].type)
		{
		    case _RQF_URL:
			ui->urlstr = new_n_string(p, l);
		    break;
		    case _RQF_METHOD:
			if (!strncasecmp(p , "GET", l))
				ui->method = FORM_M_GET;
			else if (!strncasecmp(p, "POST", l))
				ui->method = FORM_M_POST;
			else
				err = TRUE;
		    break;
		    case _RQF_ENCODING:
			if (!strncasecmp(p , "m", l))
				ui->encoding = FORM_E_MULTIPART;
			else if (!strncasecmp(p , "u", l))
				ui->encoding = FORM_E_URLENCODED;
			else
				err = TRUE;
		    break;
		    case _RQF_FIELD:
		    case _RQF_FILE:
		    {
			form_field *fi;

			fi = _malloc(sizeof(form_field));

			fi->name = NULL;
			fi->value = NULL;

			fi->type = (_request_fields[i].type == _RQF_FILE) ?
					FORM_T_FILE : FORM_T_TEXT;

			tp = strchr(p , '=');

			if (!tp || (tp - p) > l)
				err = TRUE;
			else
			{
				fi->name = form_decode_urlencoded_str(p, tp-p);
				fi->value = form_decode_urlencoded_str(tp+1 , l - (tp-p+1));
				if (fi->type == FORM_T_TEXT && strchr(fi->value, '\n'))
					fi->type = FORM_T_TEXTAREA;
			}
			if (err || !fi->name || !fi->value)
			{
				_free(fi->value);
				_free(fi->name);
				_free(fi);
			}
			else
				ui->fields = dllist_append(ui->fields, fi);
		    }
		    break;
		}
		p += l;
		p += *p == '\"';
	}

	if (err)
	{
		url_info_free(ui);
		ui = NULL;
	}

	return ui;
}

char *url_info_dump(ui)
url_info *ui;
{
	char *retv = NULL;

	if (ui->type == URLI_FORM)
	{
		dllist *ptr;

		retv = tl_str_concat(retv, "URL:\"" , ui->urlstr , "\" " , NULL);

		if (ui->method == FORM_M_GET)
			retv = tl_str_append(retv, "METHOD:GET ");
		else if (ui->method == FORM_M_POST)
			retv = tl_str_append(retv , "METHOD:POST ");

		if (ui->encoding == FORM_E_URLENCODED)
			retv = tl_str_append(retv , "ENCODING:application/x-www-form-urlencoded ");
		if (ui->encoding == FORM_E_MULTIPART)
			retv = tl_str_append(retv , "ENCODING:multipart/form-data ");

		ptr = ui->fields;
		while (ptr)
		{
			char *n,*v;
			form_field *ff = (form_field *) ptr->data;

			n = form_encode_urlencoded_str(ff->name);
			v = form_encode_urlencoded_str(ff->value);

			if (ff->type == FORM_T_FILE)
				retv = tl_str_concat(retv, "FILE:\"" , n , "=" , v , "\" ", NULL);
			else
				retv = tl_str_concat(retv, "FIELD:\"" , n , "=" , v , "\" ", NULL);

			_free(n);
			_free(v);
			ptr = ptr->next;
		}
	}

	return retv;
}

url_info *url_info_duplicate(ui)
url_info *ui;
{
	url_info *cui;
	dllist *ptr;

	cui = url_info_new(ui->urlstr);
	cui->method = ui->method;
	cui->encoding = ui->encoding;
	cui->type = ui->type;

	ptr = ui->fields;
	while (ptr)
	{
		form_field *ff = (form_field *) ptr->data;
		form_field *cff = (form_field *) _malloc(sizeof(form_field));

		cff->type = ff->type;
		cff->name = new_string(ff->name);
		cff->value = new_string(ff->value);

		cui->fields = dllist_append(cui->fields, cff);

		ptr = ptr->next;
	}
	return cui;
}

