/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <stdio.h>

#include	"ScrollbarP.h"
#include	"Init.h"
#include	"utils.h"
#include	"cvt.h"

#define offset(field) XtOffsetOf(ScrollbarRec, scrollbar.field)

static XtResource resources[] = { 
	{
	 XtNactive_arrows ,
	 XtCActive_arrows ,
	 XtRBoolean ,
	 sizeof(Boolean) ,
	 offset(active_arrows) ,
	 XtRImmediate ,
	 (XtPointer) True
	},
	{
	 XtNlength ,
	 XtCLength ,
	 XtRInt ,
	 sizeof(int) ,
	 offset(length) ,
	 XtRImmediate ,
	 (XtPointer) 0
	},
	{
	 XtNthickness ,
	 XtCThickness ,
	 XtRInt ,
	 sizeof(int) ,
	 offset(thickness) ,
	 XtRImmediate ,
	 (XtPointer)  10
	},
	{
	 XtNorientation ,
	 XtCOrientation ,
	 XtROrientation ,
	 sizeof(int) ,
	 offset(orientation) ,
	 XtRImmediate ,
	 (XtPointer) XtCvertical
	},
	{
	 XtNrepeat_delay ,
	 XtCRepeat_delay ,
	 XtRInt ,
	 sizeof(int) ,
	 offset(repeat_delay) ,
	 XtRImmediate ,
	 (XtPointer) 50
	},
	{
	 XtNinit_delay ,
	 XtCInit_delay ,
	 XtRInt ,
	 sizeof(int) ,
	 offset(init_delay) ,
	 XtRImmediate ,
	 (XtPointer) 500
	},
	{
	 XtNslider_position ,
	 XtCSlider_position ,
	 XtRFloat ,
	 sizeof(float) ,
	 offset(slider_position) ,
	 XtRString ,
	 (XtPointer) "0.0"
	},
	{
	 XtNslider_size ,
	 XtCSlider_size ,
	 XtRFloat ,
	 sizeof(float) ,
	 offset(slider_size) ,
	 XtRString ,
	 (XtPointer) "1.0"
	},
	{
	 XtNslider_min_length ,
	 XtCSlider_min_length ,
	 XtRInt ,
	 sizeof(int) ,
	 offset(slider_min_length) ,
	 XtRImmediate ,
	 (XtPointer) 5
	},
	{
	 XtNscroll_cb ,
	 XtCScroll_cb ,
	 XtRCallback ,
	 sizeof(XtCallbackList) ,
	 offset(scroll_cb) ,
	 XtRCallback ,
	 (XtPointer) NULL
	},
	{
	 XtNbox_type ,
	 XtCBox_type ,
	 XtRBox_type ,
	 sizeof(int) ,
	 XtOffsetOf(ScrollbarRec,base.box_type) ,
	 XtRImmediate ,
	 (XtPointer) XtCdown_box
	},
	{
	 XtNbox_width ,
	 XtCBox_width ,
	 XtRInt ,
	 sizeof(int) ,
	 XtOffsetOf(ScrollbarRec,base.box_width) ,
	 XtRImmediate ,
	 (XtPointer) 2
	},
	{
	 XtNspacing ,
	 XtCSpacing ,
	 XtRInt ,
	 sizeof(int) ,
	 offset(spacing) ,
	 XtRImmediate ,
	 (XtPointer) 1
	},
	{
	 XtNauto_scrolling ,
	 XtCAuto_scrolling ,
	 XtRBoolean ,
	 sizeof(Boolean) ,
	 offset(auto_scrolling) ,
	 XtRImmediate ,
	 (XtPointer) True
	},
	{
	 XtNslider_inc ,
	 XtCSlider_inc ,
	 XtRFloat ,
	 sizeof(float) ,
	 offset(slider_inc) ,
	 XtRString ,
	 (XtPointer) "0.01"
	},
};

static void Initialize ();
static Boolean SetValues ();
static void Redisplay ();
static void Destroy ();
static void ClassInitialize();
static void Resize ();
static XtGeometryResult QueryGeometry();

static void Scroll();

static int GetEventObject();
static void DispatchEvent();
static void EventNotify();
static void timerCB();


static XtActionsRec action [] = {
	{"scroll", Scroll}};
	
ScrollbarClassRec scrollbarClassRec = {
/* core */
   {
    /* superclass            */ (WidgetClass) &baseClassRec,
    /* class_name            */ "Scrollbar",
    /* widget_size           */ sizeof(ScrollbarRec),
    /* class_initialize      */ ClassInitialize,
    /* class_part_initialize */ NULL,
    /* class_inited          */ FALSE,
    /* initialize            */ (XtInitProc) Initialize,
    /* initialize_hook       */ NULL,
    /* realize               */ XtInheritRealize,
    /* actions               */ action,
    /* num_actions           */ XtNumber(action),
    /* resources             */ resources,
    /* num_resources         */ XtNumber(resources),
    /* xrm_class             */ NULLQUARK,
    /* compress_motion       */ True,
    /* compress_exposure     */ True,
    /* compress_enterleave   */ True,
    /* visible_interest      */ FALSE,
    /* destroy               */ Destroy,
    /* resize                */ Resize,
    /* expose                */ Redisplay,
    /* set_values            */ (XtSetValuesFunc) SetValues,
    /* set_values_hook       */ NULL,
    /* set_values_almost     */ XtInheritSetValuesAlmost,
    /* get_values_hook       */ NULL,
    /* accept_focus          */ NULL /*XtInheritAcceptFocus*/,
    /* version               */ XtVersion,
    /* callback_private      */ NULL,
    /* tm_table              */ NULL,
    /* query_geometry        */ QueryGeometry,
    /* display_accelerator   */ XtInheritDisplayAccelerator,
    /* extension             */ NULL
   },
/* base */
   {
    /* get_internal_dimension  */ XtInheritGetInternalDimension,
    /* set_internal_dimension  */ XtInheritSetInternalDimension,
    /* highlight	       */ XtInheritHighlight,
    /* unhighlight	       */ XtInheritUnhighlight,
    /* highlightBorder	       */ XtInheritHighlightBorder,
    /* unhighlightBorder       */ XtInheritUnhighlightBorder,
   },
/* scrollbar */
   {
   /* empty		       */ 0
   },
};

WidgetClass scrollbarWidgetClass = (WidgetClass) &scrollbarClassRec;

static void ClassInitialize()
{
    _InitializeWidgetSet();

    XtSetTypeConverter(XtRString, XtRBox_type, cvtStringToOrientation,
                       NULL, 0, XtCacheNone, NULL);
}

static void Initialize(req_widget,new_widget,args,num_args)
Widget req_widget;
Widget new_widget;
ArgList args;
Cardinal *num_args;
{
	ScrollbarWidget nw = (ScrollbarWidget) new_widget;
	Display *dpy = XtDisplay(new_widget);
	XColor  dark,light,bg;
	
	bg.pixel = nw->base.foreground;

	XQueryColor(dpy,DefaultColormap(dpy,DefaultScreen(dpy)),&bg);

	LightColor(nw->base.box_intensity,bg,light);
	DarkColor(nw->base.box_intensity,bg,dark);

	nw->scrollbar.light = light.pixel;
	nw->scrollbar.dark = dark.pixel;

	switch (nw->scrollbar.orientation)
	{
		case XtCvertical:
			XtVaSetValues(new_widget , 
				XtNwidth , nw->scrollbar.thickness,
				XtNheight , nw->scrollbar.length , NULL);
			break;
		case XtChorizontal:
			XtVaSetValues(new_widget , 
				XtNheight , nw->scrollbar.thickness,
				XtNwidth , nw->scrollbar.length , NULL);
			break;
		default:
			printf("Scrollbar : bad orientation\n");
	}

	SetScrollbar(new_widget , nw->scrollbar.slider_position , 
		nw->scrollbar.slider_size);

	nw->scrollbar.old_position = nw->scrollbar.slider_position;

	XtAddEventHandler(new_widget ,  ButtonPressMask | ButtonReleaseMask | 
		ButtonMotionMask, 
		True , DispatchEvent , (XtPointer)NULL);
}

static void Destroy(w)
Widget w;
{
}

static void Redisplay(w,event,region)
Widget w;
XEvent * event;
Region  region;
{
	ScrollbarWidget nw = (ScrollbarWidget) w;
	Display *dpy = XtDisplay(w);
	Window win = XtWindow(w);
	Dimension width , height;
	Position x , y;
	Pixel light,dark;


	scrollbarClassRec.base_class.get_internal_dimension(w , &x , &y , &width ,
		&height);

	switch (nw->scrollbar.orientation)
	{
		case XtCvertical:
			X_Draw3DRectangle(dpy , win , x + nw->scrollbar.spacing ,
				nw->scrollbar.slider_start , 
				width - 2 * nw->scrollbar.spacing ,
				nw->scrollbar.slider_length , 2 ,
				nw->scrollbar.light , nw->scrollbar.dark ,
				nw->base.foreground);

			if (nw->scrollbar.active_arrows)
			{
				if (nw->scrollbar.where == TOP_ARROW)
				{
					light = nw->scrollbar.dark;
					dark = nw->scrollbar.light;
				}
				else
				{
					light = nw->scrollbar.light;
					dark = nw->scrollbar.dark;
				}
				X_Draw3DArrow(dpy , win , x + nw->scrollbar.spacing ,
					y + nw->scrollbar.spacing ,
					width - 2 * nw->scrollbar.spacing ,
					width - nw->scrollbar.spacing, XtCtop ,
					light , dark ,
					nw->base.foreground);
				if (nw->scrollbar.where == BOTTOM_ARROW)
				{
					light = nw->scrollbar.dark;
					dark = nw->scrollbar.light;
				}
				else
				{
					light = nw->scrollbar.light;
					dark = nw->scrollbar.dark;
				}
				X_Draw3DArrow(dpy , win , x + nw->scrollbar.spacing , 
					y + height - width , 
					width - 2 * nw->scrollbar.spacing ,
					width - nw->scrollbar.spacing , XtCbottom ,
					light , dark ,
					nw->base.foreground);
			}
			break;
		case XtChorizontal:
			X_Draw3DRectangle(dpy , win , nw->scrollbar.slider_start ,
				y + nw->scrollbar.spacing ,
				nw->scrollbar.slider_length ,
				height - 2 * nw->scrollbar.spacing , 2 ,
				nw->scrollbar.light , nw->scrollbar.dark ,
				nw->base.foreground);

			if (nw->scrollbar.active_arrows)
			{
				if (nw->scrollbar.where == LEFT_ARROW)
				{
					light = nw->scrollbar.dark;
					dark = nw->scrollbar.light;
				}
				else
				{
					light = nw->scrollbar.light;
					dark = nw->scrollbar.dark;
				}
				X_Draw3DArrow(dpy , win , x + nw->scrollbar.spacing ,
					y + nw->scrollbar.spacing , 
					height - nw->scrollbar.spacing,
					height - 2 * nw->scrollbar.spacing , XtCleft ,
					light , dark ,
					nw->base.foreground);
				if (nw->scrollbar.where == RIGHT_ARROW)
				{
					light = nw->scrollbar.dark;
					dark = nw->scrollbar.light;
				}
				else
				{
					light = nw->scrollbar.light;
					dark = nw->scrollbar.dark;
				}
				X_Draw3DArrow(dpy , win , x + width - height ,
					y + nw->scrollbar.spacing ,
					height - nw->scrollbar.spacing, 
					height - 2 * nw->scrollbar.spacing , XtCright ,
					light , dark ,
					nw->base.foreground);
			}
			break;
	}
	baseClassRec.core_class.expose(w , event  , region);
}

static void Resize(w)
Widget w;
{
	ScrollbarWidget cw = (ScrollbarWidget) w;

	SetScrollbar(w , cw->scrollbar.slider_position , cw->scrollbar.slider_size);
}


#define WidgetValuesDiffer(w1,w2,component) (w1 -> scrollbar.component != \
                                             w2 -> scrollbar.component)

static Boolean SetValues(current, request, new_widget, args, num_args)
Widget current;
Widget request;
Widget new_widget;
ArgList args;
Cardinal *num_args;
{
	ScrollbarWidget cw = (ScrollbarWidget) current;
	ScrollbarWidget nw = (ScrollbarWidget) new_widget;
	Boolean redraw = False;

	if (WidgetValuesDiffer(cw , nw , slider_size) ||
		WidgetValuesDiffer(cw , nw , slider_position) ||
		WidgetValuesDiffer(cw , nw , spacing) ||
		WidgetValuesDiffer(cw , nw ,active_arrows))
	{
		SetScrollbar(new_widget , nw->scrollbar.slider_position ,
			nw->scrollbar.slider_size);

		redraw = True;
	}

	if (WidgetValuesDiffer(cw , nw , length) ||
		WidgetValuesDiffer(cw , nw , thickness))
	{
		if (nw->scrollbar.orientation == XtChorizontal)
		{
			XtVaSetValues(new_widget , XtNwidth , nw->scrollbar.length ,
				XtNheight , nw->scrollbar.thickness , NULL);
		}
		else
		{
			XtVaSetValues(new_widget , XtNwidth , nw->scrollbar.thickness ,
				XtNheight , nw->scrollbar.length , NULL);
		}
		SetScrollbar(new_widget , nw->scrollbar.slider_position ,
			nw->scrollbar.slider_size);
	}

	return redraw;
}

static XtGeometryResult QueryGeometry(w, intended , preferred)
Widget w;
XtWidgetGeometry *intended;
XtWidgetGeometry *preferred;
{
	ScrollbarWidget cw = (ScrollbarWidget) w;
	Dimension pwidth = 0 , pheight = 0;
	Dimension width , height;
	Position x,y;
	
	scrollbarClassRec.base_class.get_internal_dimension(w , &x , &y ,
			&width , &height);

	if (cw->scrollbar.thickness)
	{
		pheight = 2 * cw->scrollbar.spacing + 5 + 
			(cw->scrollbar.active_arrows == True) *
			(2 * cw->scrollbar.spacing +  (cw->core.height - height) + 
			2 * (cw->scrollbar.thickness - 2 * (cw->core.height - height)));

		pheight = cw->scrollbar.thickness ;

	}
	else
	{
		pwidth = 2 * cw->scrollbar.spacing + 5 + 
			(cw->scrollbar.active_arrows == True) *
			(2 * cw->scrollbar.spacing +  (cw->core.width - width) + 
			2 * (cw->scrollbar.thickness - 2 * (cw->core.width - width)));

		pwidth = cw->scrollbar.thickness ;

	}
		
	preferred->request_mode = CWWidth | CWHeight;
	preferred->width = pwidth;
	preferred->height = pheight;

	if (((intended->request_mode & (CWWidth | CWHeight))
		== (CWWidth | CWHeight)) &&
		intended->width == preferred->width &&
		intended->height == preferred->height)
		return XtGeometryYes;

	else if (preferred->width == cw->core.width &&
		preferred->height == cw->core.height)
		return XtGeometryNo;

	else return XtGeometryAlmost;
	
}

static void Scroll(w , event , params , num_params)
Widget w;
XEvent*event;
String*params;
Cardinal*num_params;
{
	return;
}

void SetScrollbar(w , position , size)
Widget w;
float position;
float size;
{
	ScrollbarWidget nw = (ScrollbarWidget) w;
	Display *dpy = XtDisplay(w);
	Window win = XtWindow(w);
	Position x , y;
	Dimension width , height;
	int old_start = nw->scrollbar.slider_start,
		old_length = nw->scrollbar.slider_length;
	float old_position =  nw->scrollbar.slider_position,
		old_size =  nw->scrollbar.slider_size;

	scrollbarClassRec.base_class.get_internal_dimension(w , &x , &y , &width ,
		&height);

	size = (size > 1.0) ? 1.0  : size;
	position = (position < 0.0) ?  0.0  : position;


	switch (nw->scrollbar.orientation)
	{
		case XtCvertical:
			nw->scrollbar.slider_area_length = 1 + height - 2 *
				(nw->scrollbar.active_arrows == True) * 
				( width ) - 
				2 * nw->scrollbar.spacing;

			size = (size < ((float) nw->scrollbar.slider_min_length /
				(float) nw->scrollbar.slider_area_length)) ?
				((float) nw->scrollbar.slider_min_length /
				(float) nw->scrollbar.slider_area_length)
				: size;

			position = (position > 1.0) ? 1.0 : position;

			nw->scrollbar.slider_position = position;
			nw->scrollbar.slider_size = size;

			nw->scrollbar.slider_length = (int)(size *
				(float)nw->scrollbar.slider_area_length);

			if (nw->scrollbar.slider_length <5) 
					nw->scrollbar.slider_length=5; 

			nw->scrollbar.slider_start = y + (nw->scrollbar.active_arrows ==
				True) * width + nw->scrollbar.spacing + (int)(position * 
				(float)(nw->scrollbar.slider_area_length - 
				nw->scrollbar.slider_length));


		    if (XtIsRealized(w) && ((old_position != position) ||
			(old_size != size)))
		    {
			XClearArea(dpy , win , x , old_start , 
				width , old_length , False);
			X_Draw3DRectangle(dpy , win , x + nw->scrollbar.spacing ,
				nw->scrollbar.slider_start , 
				width - 2 * nw->scrollbar.spacing ,
				nw->scrollbar.slider_length , 2 ,
				nw->scrollbar.light , nw->scrollbar.dark ,
				nw->base.foreground);
		    }
			break;

		case XtChorizontal:

			nw->scrollbar.slider_area_length = 1 + width - 2 *
				(nw->scrollbar.active_arrows == True) * 
				(height) -
				2 * nw->scrollbar.spacing;

			size = (size < ((float) nw->scrollbar.slider_min_length /
				(float) nw->scrollbar.slider_area_length)) ?
				((float) nw->scrollbar.slider_min_length /
				(float) nw->scrollbar.slider_area_length)
				: size;

			position = (position > 1.0) ? 1.0 : position;

			nw->scrollbar.slider_position = position;
			nw->scrollbar.slider_size = size;

			nw->scrollbar.slider_length = (int)(size *
				(float)nw->scrollbar.slider_area_length);

			if (nw->scrollbar.slider_length <5) 
					nw->scrollbar.slider_length=5; 

			nw->scrollbar.slider_start = x + (nw->scrollbar.active_arrows ==
				True) * height + nw->scrollbar.spacing + (int)(position *
				(float)(nw->scrollbar.slider_area_length -
				nw->scrollbar.slider_length));

		    if (XtIsRealized(w) && ((old_position != position) ||
			(old_size != size)))
		    {
			XClearArea(dpy , win , old_start , y ,
				old_length , height , False);
			X_Draw3DRectangle(dpy , win , nw->scrollbar.slider_start ,
				y + nw->scrollbar.spacing ,
				nw->scrollbar.slider_length ,
				height - 2 * nw->scrollbar.spacing , 2 ,
				nw->scrollbar.light , nw->scrollbar.dark ,
				nw->base.foreground);
		     }
			break;
	}
}

static void DispatchEvent(w , client_data , event , ctd)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean * ctd;
{
	ScrollbarWidget cw = (ScrollbarWidget) w;
	Position px , py;
	Dimension width , height;
	static ScrollbarSetting retv;


	scrollbarClassRec.base_class.get_internal_dimension(w , &px , &py , &width ,
		&height);

	switch (event->type) 
	{
		case ButtonPress:
			cw->scrollbar.where = GetEventObject(w , event->xbutton.x ,
				event->xbutton.y);
			switch (cw->scrollbar.where)
			{
				case RIGHT_GAP:
				case LEFT_GAP:
				case TOP_GAP:
				case BOTTOM_GAP:
				case LEFT_ARROW:
				case RIGHT_ARROW:
				case TOP_ARROW:
				case BOTTOM_ARROW:
					EventNotify(cw , cw->scrollbar.init_delay);
					break;
				case SLIDER:
				    cw->scrollbar.old_position =
					cw->scrollbar.slider_position;
				    if (cw->scrollbar.orientation == XtChorizontal)
				    	cw->scrollbar.drag_position = event->xbutton.x -
						cw->scrollbar.slider_start;
				    else
					cw->scrollbar.drag_position = event->xbutton.y -
						cw->scrollbar.slider_start;
				    break;
			}
			break;
		case ButtonRelease:
			switch (cw->scrollbar.where)
			{
				case RIGHT_GAP:
				case LEFT_GAP:
				case TOP_GAP:
				case BOTTOM_GAP:
				case LEFT_ARROW:
				case RIGHT_ARROW:
				case TOP_ARROW:
				case BOTTOM_ARROW:
					XtRemoveTimeOut(cw->scrollbar.timer);
					break;
			}
			cw->scrollbar.where = NOTHING;
			scrollbarClassRec.core_class.expose(w , NULL , NULL);
                	break;
		case MotionNotify:
			if (cw->scrollbar.where == SLIDER)
			{
			    if (cw->scrollbar.orientation == XtChorizontal)
				SetScrollbar(w , (float)(event->xcrossing.x - px -
					cw->scrollbar.drag_position -
					(cw->scrollbar.active_arrows == True) * 
					( height ))/
					(float)(cw->scrollbar.slider_area_length -
					cw->scrollbar.slider_length),
					cw->scrollbar.slider_size);

			    else
				SetScrollbar(w , (float)(event->xcrossing.y - py -
					cw->scrollbar.drag_position -
					(cw->scrollbar.active_arrows == True) * 
					( width ))/
					(float)(cw->scrollbar.slider_area_length -
					cw->scrollbar.slider_length),
					cw->scrollbar.slider_size);

			    if (cw->scrollbar.slider_position !=
			    	cw->scrollbar.old_position)
			    {
				retv.size = cw->scrollbar.slider_size;
				retv.position = cw->scrollbar.slider_position;
				retv.where = cw->scrollbar.where;

				XtCallCallbackList(w , cw->scrollbar.scroll_cb ,
			    		(XtPointer) &retv);
			    }
			    cw->scrollbar.old_position = cw->scrollbar.slider_position;
			}
			break;
	}
}


static int GetEventObject(w , x , y)
Widget w;
int x;
int y;
{
	ScrollbarWidget cw = (ScrollbarWidget) w;
	Position px , py;
	Dimension width , height;

	scrollbarClassRec.base_class.get_internal_dimension(w , &px , &py , &width ,
		&height);

	if (cw->scrollbar.orientation == XtChorizontal)
	{
		if ((x >= cw->scrollbar.slider_start) &&
		    (x <= (cw->scrollbar.slider_start + cw->scrollbar.slider_length)) &&
		    (y >= (py + cw->scrollbar.spacing)) &&
		    (y <= (py + height - cw->scrollbar.spacing))) return SLIDER;

		if (cw->scrollbar.active_arrows &&
		    (y >= (py + cw->scrollbar.spacing)) &&
		    (y <= (py + height - cw->scrollbar.spacing)) &&
		    (x > px) &&
		    (x <= (px + height))) return LEFT_ARROW;

		if (cw->scrollbar.active_arrows &&
		    (y >= (py + cw->scrollbar.spacing)) &&
		    (y <= (py + height - cw->scrollbar.spacing)) &&
		    (x >= (px + width - height)) &&
		    (x < (px + width))) return RIGHT_ARROW;

		if ((x < cw->scrollbar.slider_start) &&
		    (x >= (px + (height * (cw->scrollbar.active_arrows == True)))) &&
		    (y <= (py + height)) &&
		    (y >= py)) return LEFT_GAP;

		if ((x <= (px + width - height * (cw->scrollbar.active_arrows == True))) &&
		    (x > (cw->scrollbar.slider_start + cw->scrollbar.slider_length)) &&
		    (y <= (py + height)) &&
		    (y >= py)) return RIGHT_GAP;

	}
	else
	{
		if ((y >= cw->scrollbar.slider_start) &&
		    (y <= (cw->scrollbar.slider_start + cw->scrollbar.slider_length)) &&
		    (x >= (px + cw->scrollbar.spacing)) &&
		    (x <= (px + width - cw->scrollbar.spacing))) return SLIDER;

		if (cw->scrollbar.active_arrows &&
		    (y > py) &&
		    (y <= (py + width)) &&
		    (x >= (px + cw->scrollbar.spacing)) &&
		    (x <= (px + width - cw->scrollbar.spacing))) return TOP_ARROW;

		if (cw->scrollbar.active_arrows &&
		    (y >= (py + height - width)) &&
		    (y < (py + height)) &&
		    (x >= (px + cw->scrollbar.spacing)) &&
		    (x <= (px + width - cw->scrollbar.spacing))) return BOTTOM_ARROW;

		if ((y < cw->scrollbar.slider_start) &&
		    (y >= (py + (width * (cw->scrollbar.active_arrows == True)))) &&
		    (x >= px) &&
		    (x <= (px + width))) return TOP_GAP;

		if ((y > (cw->scrollbar.slider_start + cw->scrollbar.slider_length)) &&
		    (y <= (py + height - width * (cw->scrollbar.active_arrows == True))) &&
		    (x >= px) &&
		    (x <= (px + width))) return BOTTOM_GAP;

	}
	return NOTHING;
}

static void timerCB(client_data,timer)
XtPointer  client_data;
XtIntervalId * timer;
{
	EventNotify((ScrollbarWidget) client_data ,
		((ScrollbarWidget) client_data)->scrollbar.repeat_delay);
        	
}


static void EventNotify(w,delay)
ScrollbarWidget w;
int delay;
{

	static ScrollbarSetting retv;

	switch(w->scrollbar.where)
	{
		case TOP_GAP:
		case LEFT_GAP:
		    if (w->scrollbar.auto_scrolling)
		    	SetScrollbar((Widget)w, w->scrollbar.slider_position -
				w->scrollbar.slider_size , w->scrollbar.slider_size);
		    break;
		case RIGHT_GAP:
		case BOTTOM_GAP:
		    if (w->scrollbar.auto_scrolling)
		    	SetScrollbar((Widget)w, w->scrollbar.slider_position +
				w->scrollbar.slider_size , w->scrollbar.slider_size);
		    break;
		case LEFT_ARROW:
		case TOP_ARROW:
		    if (w->scrollbar.auto_scrolling)
		    	SetScrollbar((Widget)w, w->scrollbar.slider_position -
				w->scrollbar.slider_inc , w->scrollbar.slider_size);
		    scrollbarClassRec.core_class.expose((Widget) w , NULL , NULL);
		    break;
		case RIGHT_ARROW:
		case BOTTOM_ARROW:
		    if (w->scrollbar.auto_scrolling)
		    	SetScrollbar((Widget)w, w->scrollbar.slider_position +
				w->scrollbar.slider_inc , w->scrollbar.slider_size);
		    scrollbarClassRec.core_class.expose((Widget) w , NULL , NULL);
		    break;
	}
	retv.size = w->scrollbar.slider_size;
	retv.position = w->scrollbar.slider_position;
	retv.where = w->scrollbar.where;

	if ((w->scrollbar.old_position != w->scrollbar.slider_position)	
	    && w->scrollbar.auto_scrolling)
	{
		XtCallCallbackList((Widget)w , w->scrollbar.scroll_cb ,
			(XtPointer) &retv);
	}
	if (!w->scrollbar.auto_scrolling)
	{
		XtCallCallbackList((Widget)w , w->scrollbar.scroll_cb ,
			(XtPointer) &retv);
	}

	w->scrollbar.old_position = w->scrollbar.slider_position;

	w->scrollbar.timer = XtAppAddTimeOut(XtWidgetToApplicationContext((Widget)w) , 
		delay , timerCB , (Widget)w);	
}
