/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#include <X11/Xlib.h>

#include "ObjButtonP.h"
#include "Init.h"
#include "cvt.h"

#define offset(field) XtOffsetOf(ObjButtonRec,objButton.field)

static XtResource resources [] = {
        {
         XtNspacing,
         XtCSpacing,
         XtRInt,
         sizeof(int),
         offset(spacing),
         XtRImmediate,
         (XtPointer) 2
        },
       	{
         XtNobj_type,
         XtCObj_type,
         XtRObject_type,
         sizeof(int),
         offset(obj_type),
         XtRImmediate,
         (XtPointer) XtCleft_arrow
        },
};


static void ClassInitialize ();
static void Initialize ();
static void Destroy ();
static void Redisplay ();
static Boolean SetValues ();


static char trans_tab [] =
        "<FocusIn>: focusIn()\n\
         <FocusOut>: focusOut()\n\
	 ~Shift<Key>Tab: traverseForward()\n\
	 Shift<Key>Tab: traverseBackward()\n\
	 <Key>Return: KBactivate()\n\
	 <Key>space: KBactivate()\n\
	 <Btn1Down>: hide_help() activate() \n\
	 <Btn1Up>: deactivate() \n\
	 <Enter>: enter_leave() highlight() show_help() \n\
	 <Leave>: enter_leave() unhighlight() hide_help() \n\
	 <BtnDown>: hide_help() \n\
	 <KeyDown>: hide_help()";

ObjButtonClassRec objButtonClassRec = {
/* core */
   {
    /* superclass            */ (WidgetClass) &sButtonClassRec,
    /* class_name            */ "ObjButton",
    /* widget_size           */ sizeof(ObjButtonRec),
    /* class_initialize      */ ClassInitialize,
    /* class_part_initialize */ NULL,
    /* class_inited          */ FALSE,
    /* initialize            */ (XtInitProc) Initialize,
    /* initialize_hook       */ NULL,
    /* realize               */ XtInheritRealize,
    /* actions               */ NULL,
    /* num_actions           */ 0,
    /* resources             */ resources,
    /* num_resources         */ XtNumber(resources),
    /* xrm_class             */ NULLQUARK,
    /* compress_motion       */ TRUE,
    /* compress_exposure     */ TRUE,
    /* compress_enterleave   */ TRUE,
    /* visible_interest      */ FALSE,
    /* destroy               */ (XtWidgetProc) Destroy,
    /* resize                */ XtInheritResize,
    /* expose                */ (XtExposeProc) Redisplay,
    /* set_values            */ (XtSetValuesFunc) SetValues,
    /* set_values_hook       */ NULL,
    /* set_values_almost     */ XtInheritSetValuesAlmost,
    /* get_values_hook       */ NULL,
    /* accept_focus          */ XtInheritAcceptFocus,
    /* version               */ XtVersion,
    /* callback_private      */ NULL,
    /* tm_table              */ trans_tab,
    /* query_geometry        */ XtInheritQueryGeometry,
    /* display_accelerator   */ XtInheritDisplayAccelerator,
    /* extension             */ NULL
   },
/* base */
   {
    /* get_internal_dimension  */ XtInheritGetInternalDimension,
    /* set_internal_dimension  */ XtInheritSetInternalDimension,
    /* highlight	       */ XtInheritHighlight,
    /* unhighlight	       */ XtInheritUnhighlight,
    /* highlightBorder	       */ XtInheritHighlightBorder,
    /* unhighlightBorder       */ XtInheritUnhighlightBorder,
   },
/* objButton */
   {
    /* empty                 */ 0
   }
};

WidgetClass objButtonWidgetClass = (WidgetClass) & objButtonClassRec;

static void ClassInitialize ()
{
    _InitializeWidgetSet();

    XtSetTypeConverter(XtRString , XtRObject_type , cvtStringToObjectType ,
                       NULL, 0, XtCacheNone, NULL);

}

static void Initialize(req_widget,new_widget,args,num_args)
Widget req_widget;
Widget new_widget;
ArgList args;
Cardinal *num_args;
{
	ObjButtonWidget nw = (ObjButtonWidget) new_widget;
	XGCValues gc_res;
	XtGCMask gc_mask;
	Display *dpy=XtDisplay(new_widget);

	gc_mask = GCBackground | GCForeground ;
	gc_res.background = nw->core.background_pixel;
	gc_res.foreground = nw->base.foreground;

	nw->objButton.grc= XCreateGC(dpy,DefaultRootWindow(dpy),gc_mask,&gc_res);

}


static void Destroy(w)
Widget w;
{
	ObjButtonWidget cw = (ObjButtonWidget) w;

	XFreeGC(XtDisplay(w),cw->objButton.grc);
}


static void Redisplay(w , event , region)
Widget w;
XEvent *event;
Region region;
{
	ObjButtonWidget cw = (ObjButtonWidget) w;
	Position x , y;
	Dimension width , height;
	XPoint triangel[3];

	objButtonClassRec.base_class.get_internal_dimension(w , &x , &y , 
		&width , &height);


	switch(cw->objButton.obj_type)
	{
		case XtCtop_arrow:
			triangel[0].x = cw->objButton.spacing + x;
			triangel[0].y = height - cw->objButton.spacing + y;
			triangel[1].x = width - cw->objButton.spacing + x;
			triangel[1].y = height - cw->objButton.spacing + y;
			triangel[2].x = width / 2 + x;
			triangel[2].y = cw->objButton.spacing + y;
			break;
		case XtCbottom_arrow:
			triangel[0].x = cw->objButton.spacing + x;
			triangel[0].y = cw->objButton.spacing + y;
			triangel[1].x = width - cw->objButton.spacing + x;
			triangel[1].y = cw->objButton.spacing + y;
			triangel[2].x = width / 2 + x;
			triangel[2].y = height - cw->objButton.spacing + y;
			break;
		case XtCleft_arrow:
			triangel[0].x = cw->objButton.spacing + x;
			triangel[0].y = y + height / 2;
			triangel[1].x = width - cw->objButton.spacing + x;
			triangel[1].y = cw->objButton.spacing + y;
			triangel[2].x = width - cw->objButton.spacing + x;
			triangel[2].y =  height - cw->objButton.spacing + y;
			break;
		case XtCright_arrow:
			triangel[0].x = cw->objButton.spacing + x;
			triangel[0].y = cw->objButton.spacing + y;
			triangel[1].x = cw->objButton.spacing + x;
			triangel[1].y = height - cw->objButton.spacing + y;
			triangel[2].x = width - cw->objButton.spacing + x;
			triangel[2].y = height / 2 + y;		
	}

	if (cw->base.entered)
		XSetForeground(XtDisplay(w),cw->objButton.grc,cw->base.activ_fg);
	else
		XSetForeground(XtDisplay(w),cw->objButton.grc,cw->base.foreground);

	XFillPolygon(XtDisplay(w),XtWindow(w),cw->objButton.grc,triangel,
			XtNumber(triangel),Convex,CoordModeOrigin);
			
	sButtonClassRec.core_class.expose(w , event , region);
}

#define WidgetValuesDiffer(w1,w2,component) (w1 -> objButton.component != \
                                             w2 -> objButton.component)


static Boolean SetValues(current, request, new_widget, args, num_args)
Widget current;
Widget request;
Widget new_widget;
ArgList args;
Cardinal *num_args;
{
	ObjButtonWidget nw = (ObjButtonWidget) new_widget;
	ObjButtonWidget cw = (ObjButtonWidget) current;
	Boolean redraw = False;
	
	if  WidgetValuesDiffer(cw , nw , obj_type)
	{
		redraw = True;
	}
	return redraw;

}
