/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include "CardBoxP.h"
#include "Card.h"
#include "BBox.h"
#include "BBoxP.h"
#include "Init.h"
#include "misc.h"
#include <stdio.h>


#define offset(field) XtOffsetOf(CardBoxRec,cardBox.field)

static XtResource cardBoxConstraintResources [] = {
	{XtNassociated_button,
	 XtCAssociated_button,
	 XtRString,
	 sizeof(String),
	 XtOffsetOf(CardBoxConstraintsRec,cardBox.associated_button),
	 XtRString,
	 (XtPointer)NULL
	}
};


static XtResource resources [] = {
	{XtNfont,
	 XtCFont,
	 XtRFontStruct,
	 sizeof(XFontStruct *),
	 offset(font),
	 XtRString,
	 (XtPointer) XtDefaultFont 
	},
	{XtNbutton_labels,
	 XtCButton_labels,
	 XtRStringArray,
	 sizeof(String *),
	 offset(button_labels),
	 XtRImmediate,
	 (XtPointer) NULL
	},
	{XtNcard_background,
	 XtCCard_background,
	 XtRPixel,
	 sizeof(Pixel),
	 offset(card_background),
	 XtRString,
	 (XtPointer)XtDefaultBackground
	},
	{
	 XtNborderWidth ,
	 XtCBorderWidth ,
	 XtRDimension ,
	 sizeof(Dimension) ,
	 XtOffsetOf(CardBoxRec,core.border_width) ,
	 XtRImmediate ,
	 (XtPointer) 0
	},
	{
	 XtNnumber_of_buttons ,
	 XtCNumber_of_buttons ,
	 XtRInt ,
	 sizeof(int) ,
	 offset(number_of_buttons) ,
	 XtRImmediate ,
	 (XtPointer) 0,
	},
	{
	 XtNswitch ,
	 XtCSwitch ,
	 XtRCallback ,
	 sizeof(XtCallbackList) ,
	 offset(switch_) ,
	 XtRCallback ,
	 (XtPointer) 0
	},
};

#undef offset

static void Resize();
static void ClassInitialize();
static void Initialize ();
static void Switch();
static void InsertChild ();
static void Destroy ();
static XtGeometryResult QueryGeometry();

CardBoxClassRec cardBoxClassRec = {
/* core */
{
    /* superclass            */ (WidgetClass) &baseConstClassRec,
    /* class_name            */ "CardBox",
    /* widget_size           */ sizeof(CardBoxRec),
    /* class_initialize      */ ClassInitialize,
    /* class_part_initialize */ NULL,
    /* class_inited          */ FALSE,
    /* initialize            */ (XtInitProc) Initialize,
    /* initialize_hook       */ NULL,
    /* realize               */ XtInheritRealize,
    /* actions               */ NULL,
    /* num_actions           */ 0,
    /* resources             */ resources,
    /* num_resources         */ XtNumber(resources),
    /* xrm_class             */ NULLQUARK,
    /* compress_motion       */ TRUE,
    /* compress_exposure     */ TRUE,
    /* compress_enterleave   */ TRUE,
    /* visible_interest      */ FALSE,
    /* destroy               */ Destroy,
    /* resize                */ Resize,
    /* expose                */ XtInheritExpose,
    /* set_values            */ NULL,
    /* set_values_hook       */ NULL,
    /* set_values_almost     */ XtInheritSetValuesAlmost,
    /* get_values_hook       */ NULL,
    /* accept_focus          */ XtInheritAcceptFocus,
    /* version               */ XtVersion,
    /* callback_private      */ NULL,
    /* tm_table              */ NULL,
    /* query_geometry        */ QueryGeometry,
    /* display_accelerator   */ XtInheritDisplayAccelerator,
    /* extension             */ NULL
   },
  {
/* composite */
    /* geometry_manager	     */ XtInheritGeometryManager,
    /* change_managed	     */ XtInheritChangeManaged,
    /* insert_child	     */ InsertChild,
    /* delete_child	     */ XtInheritDeleteChild,
    /* extension	     */ NULL 
   },
  { 
/* constraint */
    /* subresourses       */   cardBoxConstraintResources,
    /* subresource_count  */   XtNumber(cardBoxConstraintResources),
    /* constraint_size    */   sizeof(CardBoxConstraintsRec),
    /* initialize         */   NULL,
    /* destroy            */   NULL,
    /* set_values         */   NULL,
    /* extension          */   NULL
  },
/* baseConst */
  {
    /* get_internal_dimension  */ XtInheritGetInternalDimension,
    /* set_internal_dimension  */ XtInheritSetInternalDimension,
    /* traverse		       */ XtInheritTraverse,
    /* traverseTo              */ XtInheritTraverseTo,
    /* traverseOut	       */ XtInheritTraverseOut,
    /* traverseInside          */ XtInheritTraverseInside,
    /* highlightBorder         */ XtInheritHighlightBorder,
    /* unhighlightBorder       */ XtInheritUnhighlightBorder,
  },
  {
/* cardBox */
   /* empty		     */	0
   },
};

WidgetClass cardBoxWidgetClass = (WidgetClass) & cardBoxClassRec; 

static void ClassInitialize()
{
	_InitializeWidgetSet();
}

static void Initialize(req_widget,w,args,num_args)
Widget req_widget;
Widget w;
ArgList args;
Cardinal *num_args;
{
	CardBoxWidget cw = (CardBoxWidget) w;
	int i,xpos = 0;
	Position x;
	Dimension width,height;
	Widget parent = XtParent(w);

	cw->cardBox.initializing = True;

	cw->cardBox.pairs = (Associated_pair *)XtCalloc(cw->cardBox.number_of_buttons,
				sizeof(Associated_pair));

	cw->core.background_pixel = ((CoreWidget)parent)->core.background_pixel;
	
	for (i = 0 ; i < cw->cardBox.number_of_buttons ; i++)
	{
		cw->cardBox.button_labels[i] = XtNewString(cw->cardBox.button_labels[i]);

		cw->cardBox.pairs[i].button = XtVaCreateManagedWidget(
			cw->cardBox.button_labels[i],cardWidgetClass,w,
			XtNx,xpos,
			XtNy,0,
			XtNlabel,cw->cardBox.button_labels[i],
			XtNforeground,cw->baseConst.foreground,
			XtNbackground,cw->cardBox.card_background,
			XtNbox_intensity,cw->baseConst.box_intensity,
			XtNbox_width,cw->baseConst.box_width,
			XtNbox_color , cw->baseConst.box_color ,
			NULL);

		cw->cardBox.pairs[i].box = NULL;

		XtAddCallback(cw->cardBox.pairs[i].button , XtNactivate,
				Switch , (XtPointer) i);

		XtVaGetValues(cw->cardBox.pairs[i].button,
				XtNwidth,&width,
				XtNx,&x,
				NULL);
		xpos = x + width;
	}

	cw->cardBox.activated  = -1;

	if (cw->cardBox.number_of_buttons)
	{
		XtVaGetValues(cw->cardBox.pairs[0].button,
				XtNheight,&height,
				XtNwidth,&width,
				XtNx,&x,
				NULL);
		cw->cardBox.bBox = XtVaCreateManagedWidget("__bBox" , 
				bBoxWidgetClass , w ,
				XtNx,0,
				XtNy,height,
				XtNheight, cw->core.height - height,
				XtNwidth, cw->core.width,
				XtNbackground, cw->cardBox.card_background,
				XtNbox_intensity, cw->baseConst.box_intensity,
				XtNbox_width, cw->baseConst.box_width,
				XtNbreak_width, width - 2 * cw->baseConst.box_width,
				XtNbox_color , cw->baseConst.box_color ,
				XtNbreak_xposition, x + cw->baseConst.box_width,
				NULL);
	}			
	cw->cardBox.initializing = False;
}

static void Destroy (w)
Widget w;
{
	XtFree((char *)((CardBoxWidget)w)->cardBox.pairs);
}

static int get_button(w,name)
CardBoxWidget w;
char * name;
{
	int i;

	for(i=0 ; i < w->cardBox.number_of_buttons ; i++)
	{
		if (strcmp(XtName(w->cardBox.pairs[i].button),name) == 0)
			return i;
	}
	return -1;
}


static void InsertChild(child)
Widget  child;
{
	CardBoxWidget parent = (CardBoxWidget) XtParent(child);
	char *catr,s[100];
	int i;
	Position x;
	Dimension width;

	if (parent->cardBox.initializing)
		constraintClassRec.composite_class.insert_child(child);
  	else
	{
		XtVaGetValues(child,XtNassociated_button,&catr,NULL);
		if (catr  == NULL)
		{
			sprintf(s,"Cannot insert child \"%s\" to CardBox \"%s\" cause \
doesn't associate with any CardButton",XtName(child),XtName((Widget)parent));
			XtWarning(s);
			return;
		}
		if ((i = get_button(parent,catr)) == -1)
		{
			sprintf(s,"Cannot insert child \"%s\" to CardBox \"%s\" cause \
doesn't associate with any CardButton",XtName(child),XtName((Widget)parent));
			XtWarning(s);
			return;
		}
		parent->cardBox.pairs[i].box = child;
		if (parent->cardBox.activated == -1)
		{
			parent->cardBox.activated = i;
			XtVaGetValues(parent->cardBox.pairs[i].button,
				XtNwidth,&width,XtNx,&x,NULL);
			XtVaSetValues(parent->cardBox.bBox,
				XtNbreak_width,width - 2 * parent->baseConst.box_width,
				XtNbreak_xposition,x + parent->baseConst.box_width,
				NULL);
		}
		((CoreWidget) child)->core.parent = parent->cardBox.bBox;
	
		bBoxClassRec.composite_class.insert_child(child);
 	}
}

static void Switch(w,client_data,inf_ptr)
Widget w;
XtPointer client_data,inf_ptr;
{
	CardBoxWidget cw = (CardBoxWidget) XtParent(w);
	int which = (int) client_data;
	char s[100];
	Position x;
	Dimension width;
	String from_to[2];

	if (which == cw->cardBox.activated) return;

	from_to[0] = XtMalloc(strlen(
			XtName(cw->cardBox.pairs[cw->cardBox.activated].button)) + 1);

	from_to[1] = XtMalloc(strlen(XtName(cw->cardBox.pairs[which].button)) + 1);

	strcpy(from_to[0],XtName(cw->cardBox.pairs[cw->cardBox.activated].button));
	strcpy(from_to[1],XtName(cw->cardBox.pairs[which].button));

	XtCallCallbackList(w,cw->cardBox.switch_,(XtPointer) from_to);

	XtVaGetValues(w,XtNwidth,&width,XtNx,&x,NULL);
	XtVaSetValues(cw->cardBox.bBox,
		XtNbreak_width,width - 2 * cw->baseConst.box_width,
		XtNbreak_xposition,x + cw->baseConst.box_width,
		NULL);

	if (!cw->cardBox.pairs[which].box) 
	{
		sprintf(s,"Cannot associate any widget with CardButton \"%s\"\
in CardBox \"%s\" ",XtName(w),XtName((Widget)cw)); 
		XtWarning(s);
		if (cw->cardBox.activated != -1)
			XtUnmanageChild(cw->cardBox.pairs[cw->cardBox.activated].box);

	}
	else 
	{
		if (cw->cardBox.activated != -1)
			XtUnmanageChild(cw->cardBox.pairs[cw->cardBox.activated].box);
		XtManageChild(cw->cardBox.pairs[which].box);
		cw->cardBox.activated = which;
	}

}
void Resize(w)
Widget w;
{
	Dimension width,height,x;
	CardBoxWidget cw = (CardBoxWidget) w;
	
	if (cw->cardBox.number_of_buttons)
	{
		XtVaGetValues(cw->cardBox.pairs[0].button,
				XtNheight,&height,
				XtNwidth,&width,
				XtNx,&x,
				NULL);
		XtConfigureWidget(cw->cardBox.bBox , 0 , height , cw->core.width ,
			cw->core.height - height , 0);
	}
	else
	{
		XtConfigureWidget(cw->cardBox.bBox , 0 , 0 , cw->core.width ,
			cw->core.height , 0);

	}
}

static XtGeometryResult QueryGeometry(w, intended , preferred)
Widget w;
XtWidgetGeometry *intended;
XtWidgetGeometry *preferred;
{
	CardBoxWidget cw = (CardBoxWidget) w;
	int i;
	XtWidgetGeometry pref_geom , inten_geom;
	Dimension width , height;
	Position x,y;
	int bheight = 0,bwidth = 0;
	
	cardBoxClassRec.baseConst_class.get_internal_dimension(w , &x , &y , &width,&height);

	preferred->request_mode = CWWidth | CWHeight;
	preferred->width = cw->core.width - width;
	preferred->height = cw->core.height - height;
	
	inten_geom.request_mode = CWWidth | CWHeight;
	inten_geom.width = width;
	inten_geom.height = height;

	for(i=0 ; i < cw->cardBox.number_of_buttons ; i++)
	{
		XtQueryGeometry(cw->cardBox.pairs[i].button , &inten_geom , &pref_geom);		

		bheight = MAX(bheight , pref_geom.height);
		bwidth = bwidth + pref_geom.width;
	}

	if (cw->cardBox.bBox)
	{
		XtQueryGeometry(cw->cardBox.bBox , &inten_geom , &pref_geom);		
	}
	
	preferred->height += bheight + pref_geom.height;
	preferred->width += MAX(bwidth , pref_geom.width);

	if (((intended->request_mode & (CWWidth | CWHeight))
		== (CWWidth | CWHeight)) &&
		intended->width == preferred->width &&
		intended->height == preferred->height)
		return XtGeometryYes;

	else if (preferred->width == cw->core.width &&
		preferred->height == cw->core.height)
		return XtGeometryNo;

	else return XtGeometryAlmost;
}

int CardBoxSwitchTo(w , which)
Widget w;
int which;
{
	CardBoxWidget cw = (CardBoxWidget) w;
	char s[100];
	Position x;
	Dimension width;
	String from_to[2];

	if (which >= cw->cardBox.number_of_buttons || which < 0) return 0;
	
	if (which == cw->cardBox.activated) return 1;

	from_to[0] = XtMalloc(strlen(
			XtName(cw->cardBox.pairs[cw->cardBox.activated].button)) + 1);

	from_to[1] = XtMalloc(strlen(XtName(cw->cardBox.pairs[which].button)) + 1);

	strcpy(from_to[0],XtName(cw->cardBox.pairs[cw->cardBox.activated].button));
	strcpy(from_to[1],XtName(cw->cardBox.pairs[which].button));

	XtCallCallbackList(w,cw->cardBox.switch_,(XtPointer) from_to);

	XtVaGetValues(cw->cardBox.pairs[which].button,XtNwidth,&width,XtNx,&x,NULL);
	XtVaSetValues(cw->cardBox.bBox,
		XtNbreak_width,width - 2 * cw->baseConst.box_width,
		XtNbreak_xposition,x + cw->baseConst.box_width,
		NULL);

	if (!cw->cardBox.pairs[which].box) 
	{
		sprintf(s,"Cannot associate any widget with CardButton \"%s\"\
in CardBox \"%s\" ",XtName(w),XtName((Widget)cw)); 
		XtWarning(s);
		if (cw->cardBox.activated != -1)
			XtUnmanageChild(cw->cardBox.pairs[cw->cardBox.activated].box);

	}
	else 
	{
		if (cw->cardBox.activated != -1)
			XtUnmanageChild(cw->cardBox.pairs[cw->cardBox.activated].box);
		XtManageChild(cw->cardBox.pairs[which].box);
		cw->cardBox.activated = which;
	}
	
	return 1;
}
