package target

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"github.com/chromedp/cdproto/cdp"
)

// ID [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Target#type-TargetID
type ID string

// String returns the ID as string value.
func (t ID) String() string {
	return string(t)
}

// SessionID unique identifier of attached debugging session.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Target#type-SessionID
type SessionID string

// String returns the SessionID as string value.
func (t SessionID) String() string {
	return string(t)
}

// Info [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Target#type-TargetInfo
type Info struct {
	TargetID         ID                   `json:"targetId"`
	Type             string               `json:"type"`
	Title            string               `json:"title"`
	URL              string               `json:"url"`
	Attached         bool                 `json:"attached"`                // Whether the target has an attached client.
	OpenerID         ID                   `json:"openerId,omitempty"`      // Opener target Id
	CanAccessOpener  bool                 `json:"canAccessOpener"`         // Whether the target has access to the originating window.
	OpenerFrameID    cdp.FrameID          `json:"openerFrameId,omitempty"` // Frame id of originating window (is only set if target has an opener).
	BrowserContextID cdp.BrowserContextID `json:"browserContextId,omitempty"`
}

// RemoteLocation [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Target#type-RemoteLocation
type RemoteLocation struct {
	Host string `json:"host"`
	Port int64  `json:"port"`
}
