# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.10
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.




"""
Python wrappers around the WiredTiger C API

This provides an API similar to the C API, with the following modifications:
  - Many C functions are exposed as OO methods. See the Python examples and test suite
  - Errors are handled in a Pythonic way; wrap calls in try/except blocks
  - Cursors have extra accessor methods and iterators that are higher-level than the C API
  - Statistics cursors behave a little differently and are best handled using the C-like functions
  - C Constants starting with WT_STAT_DSRC are instead exposed under wiredtiger.stat.dsrc
  - C Constants starting with WT_STAT_CONN are instead exposed under wiredtiger.stat.conn

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (3, 0, 0):
    new_instancemethod = lambda func, inst, cls: _wiredtiger.SWIG_PyInstanceMethod_New(func)
else:
    from new import instancemethod as new_instancemethod
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_wiredtiger')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_wiredtiger')
    _wiredtiger = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_wiredtiger', [dirname(__file__)])
        except ImportError:
            import _wiredtiger
            return _wiredtiger
        if fp is not None:
            try:
                _mod = imp.load_module('_wiredtiger', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _wiredtiger = swig_import_helper()
    del swig_import_helper
else:
    import _wiredtiger
del _swig_python_version_info
try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        object.__setattr__(self, name, value)
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_method(set):
    def set_attr(self, name, value):
        if (name == "thisown"):
            return self.this.own(value)
        if hasattr(self, name) or (name == "this"):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add attributes to %s" % self)
    return set_attr



from packing import pack, unpack
## @endcond


WiredTigerError = _wiredtiger.WiredTigerError

## @cond DISABLE
# Implements the iterable contract
class IterableCursor:
	def __init__(self, cursor):
		self.cursor = cursor

	def __iter__(self):
		return self

	def next(self):
		if self.cursor.next() == WT_NOTFOUND:
			raise StopIteration
		return self.cursor.get_keys() + self.cursor.get_values()
## @endcond

# An abstract class, which must be subclassed with notify() overridden.
class AsyncCallback:
	def __init__(self):
		raise NotImplementedError

	def notify(self, op, op_ret, flags):
		raise NotImplementedError



def diagnostic_build():
    """diagnostic_build() -> int"""
    return _wiredtiger.diagnostic_build()

def timestamp_build():
    """timestamp_build() -> int"""
    return _wiredtiger.timestamp_build()
WIREDTIGER_VERSION_MAJOR = _wiredtiger.WIREDTIGER_VERSION_MAJOR
WIREDTIGER_VERSION_MINOR = _wiredtiger.WIREDTIGER_VERSION_MINOR
WIREDTIGER_VERSION_PATCH = _wiredtiger.WIREDTIGER_VERSION_PATCH
WIREDTIGER_VERSION_STRING = _wiredtiger.WIREDTIGER_VERSION_STRING
class Modify(object):
    """Proxy of C __wt_modify struct."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def __init__(self, data = '', offset = 0, size = 0):
    	self.data = data
    	self.offset = offset
    	self.size = size

Modify_swigregister = _wiredtiger.Modify_swigregister
Modify_swigregister(Modify)

class Cursor(object):
    """Proxy of C __wt_cursor struct."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    session = _swig_property(_wiredtiger.Cursor_session_get)
    uri = _swig_property(_wiredtiger.Cursor_uri_get)

    def next(self, cursor):
        """next(self, cursor) -> int"""
        return _wiredtiger.Cursor_next(self, cursor)


    def prev(self, cursor):
        """prev(self, cursor) -> int"""
        return _wiredtiger.Cursor_prev(self, cursor)


    def reset(self, cursor):
        """reset(self, cursor) -> int"""
        return _wiredtiger.Cursor_reset(self, cursor)


    def search(self, cursor):
        """search(self, cursor) -> int"""
        return _wiredtiger.Cursor_search(self, cursor)


    def insert(self, cursor):
        """insert(self, cursor) -> int"""
        return _wiredtiger.Cursor_insert(self, cursor)


    def update(self, cursor):
        """update(self, cursor) -> int"""
        return _wiredtiger.Cursor_update(self, cursor)


    def remove(self, cursor):
        """remove(self, cursor) -> int"""
        return _wiredtiger.Cursor_remove(self, cursor)


    def reserve(self, cursor):
        """reserve(self, cursor) -> int"""
        return _wiredtiger.Cursor_reserve(self, cursor)


    def close(self, *args):
    	'''close(self, config) -> int

    	@copydoc __wt_cursor::close'''
    	try:
    		self._freecb()
    		return _wiredtiger.Cursor_close(self, *args)
    	finally:
    		self.this = None



    def reconfigure(self, *args):
        """reconfigure(self, cursor, config) -> int"""
        return _wiredtiger.Cursor_reconfigure(self, *args)


    def compare(self, *args):
    	'''compare (self, other) -> int

    	@copydoc class::compare'''
    	return self._compare(*args)


    def equals(self, *args):
    	'''equals (self, other) -> int

    	@copydoc class::equals'''
    	return self._equals(*args)


    def search_near(self, *args):
    	'''search_near (self) -> int

    	@copydoc class::search_near'''
    	return self._search_near(*args)


    def _set_key(self, data):
        """_set_key(self, data)"""
        return _wiredtiger.Cursor__set_key(self, data)


    def _set_key_str(self, str):
        """_set_key_str(self, str)"""
        return _wiredtiger.Cursor__set_key_str(self, str)


    def _set_recno(self, recno):
        """_set_recno(self, recno) -> int_void"""
        return _wiredtiger.Cursor__set_recno(self, recno)


    def _set_value(self, data):
        """_set_value(self, data)"""
        return _wiredtiger.Cursor__set_value(self, data)


    def _set_value_str(self, str):
        """_set_value_str(self, str)"""
        return _wiredtiger.Cursor__set_value_str(self, str)


    def _get_key(self):
        """_get_key(self) -> int_void"""
        return _wiredtiger.Cursor__get_key(self)


    def _get_json_key(self):
        """_get_json_key(self) -> int_void"""
        return _wiredtiger.Cursor__get_json_key(self)


    def _get_recno(self):
        """_get_recno(self) -> int_void"""
        return _wiredtiger.Cursor__get_recno(self)


    def _get_value(self):
        """_get_value(self) -> int_void"""
        return _wiredtiger.Cursor__get_value(self)


    def _get_json_value(self):
        """_get_json_value(self) -> int_void"""
        return _wiredtiger.Cursor__get_json_value(self)


    def _compare(self, other):
        """_compare(self, other) -> int"""
        return _wiredtiger.Cursor__compare(self, other)


    def _equals(self, other):
        """_equals(self, other) -> int"""
        return _wiredtiger.Cursor__equals(self, other)


    def _search_near(self):
        """_search_near(self) -> int"""
        return _wiredtiger.Cursor__search_near(self)


    def _freecb(self):
        """_freecb(self) -> int"""
        return _wiredtiger.Cursor__freecb(self)


    def modify(self, list):
        """modify(self, list) -> int"""
        return _wiredtiger.Cursor_modify(self, list)


    def get_key(self):
    	'''get_key(self) -> object

    	@copydoc WT_CURSOR::get_key
    	Returns only the first column.'''
    	k = self.get_keys()
    	if len(k) == 1:
    		return k[0]
    	return k

    def get_keys(self):
    	'''get_keys(self) -> (object, ...)

    	@copydoc WT_CURSOR::get_key'''
    	if self.is_json:
    		return [self._get_json_key()]
    	elif self.is_column:
    		return [self._get_recno(),]
    	else:
    		return unpack(self.key_format, self._get_key())

    def get_value(self):
    	'''get_value(self) -> object

    	@copydoc WT_CURSOR::get_value
    	Returns only the first column.'''
    	v = self.get_values()
    	if len(v) == 1:
    		return v[0]
    	return v

    def get_values(self):
    	'''get_values(self) -> (object, ...)

    	@copydoc WT_CURSOR::get_value'''
    	if self.is_json:
    		return [self._get_json_value()]
    	else:
    		return unpack(self.value_format, self._get_value())

    def set_key(self, *args):
    	'''set_key(self) -> None

    	@copydoc WT_CURSOR::set_key'''
    	if len(args) == 1 and type(args[0]) == tuple:
    		args = args[0]
    	if self.is_column:
    		self._set_recno(long(args[0]))
    	elif self.is_json:
    		self._set_key_str(args[0])
    	else:
    # Keep the Python string pinned
    		self._key = pack(self.key_format, *args)
    		self._set_key(self._key)

    def set_value(self, *args):
    	'''set_value(self) -> None

    	@copydoc WT_CURSOR::set_value'''
    	if self.is_json:
    		self._set_value_str(args[0])
    	else:
    		if len(args) == 1 and type(args[0]) == tuple:
    			args = args[0]
    # Keep the Python string pinned
    		self._value = pack(self.value_format, *args)
    		self._set_value(self._value)

    def __iter__(self):
    	'''Cursor objects support iteration, equivalent to calling
    	WT_CURSOR::next until it returns ::WT_NOTFOUND.'''
    	if not hasattr(self, '_iterable'):
    		self._iterable = IterableCursor(self)
    	return self._iterable

    def __delitem__(self, key):
    	'''Python convenience for removing'''
    	self.set_key(key)
    	if self.remove() != 0:
    		raise KeyError

    def __getitem__(self, key):
    	'''Python convenience for searching'''
    	self.set_key(key)
    	if self.search() != 0:
    		raise KeyError
    	return self.get_value()

    def __setitem__(self, key, value):
    	'''Python convenience for inserting'''
    	self.set_key(key)
    	self.set_value(value)
    	if self.insert() != 0:
    		raise KeyError

Cursor.next = new_instancemethod(_wiredtiger.Cursor_next, None, Cursor)
Cursor.prev = new_instancemethod(_wiredtiger.Cursor_prev, None, Cursor)
Cursor.reset = new_instancemethod(_wiredtiger.Cursor_reset, None, Cursor)
Cursor.search = new_instancemethod(_wiredtiger.Cursor_search, None, Cursor)
Cursor.insert = new_instancemethod(_wiredtiger.Cursor_insert, None, Cursor)
Cursor.update = new_instancemethod(_wiredtiger.Cursor_update, None, Cursor)
Cursor.remove = new_instancemethod(_wiredtiger.Cursor_remove, None, Cursor)
Cursor.reserve = new_instancemethod(_wiredtiger.Cursor_reserve, None, Cursor)
Cursor.reconfigure = new_instancemethod(_wiredtiger.Cursor_reconfigure, None, Cursor)
Cursor._set_key = new_instancemethod(_wiredtiger.Cursor__set_key, None, Cursor)
Cursor._set_key_str = new_instancemethod(_wiredtiger.Cursor__set_key_str, None, Cursor)
Cursor._set_recno = new_instancemethod(_wiredtiger.Cursor__set_recno, None, Cursor)
Cursor._set_value = new_instancemethod(_wiredtiger.Cursor__set_value, None, Cursor)
Cursor._set_value_str = new_instancemethod(_wiredtiger.Cursor__set_value_str, None, Cursor)
Cursor._get_key = new_instancemethod(_wiredtiger.Cursor__get_key, None, Cursor)
Cursor._get_json_key = new_instancemethod(_wiredtiger.Cursor__get_json_key, None, Cursor)
Cursor._get_recno = new_instancemethod(_wiredtiger.Cursor__get_recno, None, Cursor)
Cursor._get_value = new_instancemethod(_wiredtiger.Cursor__get_value, None, Cursor)
Cursor._get_json_value = new_instancemethod(_wiredtiger.Cursor__get_json_value, None, Cursor)
Cursor._compare = new_instancemethod(_wiredtiger.Cursor__compare, None, Cursor)
Cursor._equals = new_instancemethod(_wiredtiger.Cursor__equals, None, Cursor)
Cursor._search_near = new_instancemethod(_wiredtiger.Cursor__search_near, None, Cursor)
Cursor._freecb = new_instancemethod(_wiredtiger.Cursor__freecb, None, Cursor)
Cursor.modify = new_instancemethod(_wiredtiger.Cursor_modify, None, Cursor)
Cursor_swigregister = _wiredtiger.Cursor_swigregister
Cursor_swigregister(Cursor)

WT_AOP_NONE = _wiredtiger.WT_AOP_NONE
WT_AOP_COMPACT = _wiredtiger.WT_AOP_COMPACT
WT_AOP_INSERT = _wiredtiger.WT_AOP_INSERT
WT_AOP_REMOVE = _wiredtiger.WT_AOP_REMOVE
WT_AOP_SEARCH = _wiredtiger.WT_AOP_SEARCH
WT_AOP_UPDATE = _wiredtiger.WT_AOP_UPDATE
class AsyncOp(object):
    """Proxy of C __wt_async_op struct."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    connection = _swig_property(_wiredtiger.AsyncOp_connection_get)

    def search(self, op):
        """search(self, op) -> int"""
        return _wiredtiger.AsyncOp_search(self, op)


    def insert(self, op):
        """insert(self, op) -> int"""
        return _wiredtiger.AsyncOp_insert(self, op)


    def update(self, op):
        """update(self, op) -> int"""
        return _wiredtiger.AsyncOp_update(self, op)


    def remove(self, op):
        """remove(self, op) -> int"""
        return _wiredtiger.AsyncOp_remove(self, op)


    def compact(self, op):
        """compact(self, op) -> int"""
        return _wiredtiger.AsyncOp_compact(self, op)


    def get_id(self, op):
        """get_id(self, op) -> uint64_t"""
        return _wiredtiger.AsyncOp_get_id(self, op)


    def get_type(self, op):
        """get_type(self, op) -> WT_ASYNC_OPTYPE"""
        return _wiredtiger.AsyncOp_get_type(self, op)


    def _set_key(self, data):
        """_set_key(self, data)"""
        return _wiredtiger.AsyncOp__set_key(self, data)


    def _set_recno(self, recno):
        """_set_recno(self, recno) -> int_void"""
        return _wiredtiger.AsyncOp__set_recno(self, recno)


    def _set_value(self, data):
        """_set_value(self, data)"""
        return _wiredtiger.AsyncOp__set_value(self, data)


    def _get_key(self):
        """_get_key(self) -> int_void"""
        return _wiredtiger.AsyncOp__get_key(self)


    def _get_recno(self):
        """_get_recno(self) -> int_void"""
        return _wiredtiger.AsyncOp__get_recno(self)


    def _get_value(self):
        """_get_value(self) -> int_void"""
        return _wiredtiger.AsyncOp__get_value(self)


    def _freecb(self):
        """_freecb(self) -> int"""
        return _wiredtiger.AsyncOp__freecb(self)


    def get_key(self):
    	'''get_key(self) -> object

    	@copydoc WT_ASYNC_OP::get_key
    	Returns only the first column.'''
    	k = self.get_keys()
    	if len(k) == 1:
    		return k[0]
    	return k

    def get_keys(self):
    	'''get_keys(self) -> (object, ...)

    	@copydoc WT_ASYNC_OP::get_key'''
    	if self.is_column:
    		return [self._get_recno(),]
    	else:
    		return unpack(self.key_format, self._get_key())

    def get_value(self):
    	'''get_value(self) -> object

    	@copydoc WT_ASYNC_OP::get_value
    	Returns only the first column.'''
    	v = self.get_values()
    	if len(v) == 1:
    		return v[0]
    	return v

    def get_values(self):
    	'''get_values(self) -> (object, ...)

    	@copydoc WT_ASYNC_OP::get_value'''
    	return unpack(self.value_format, self._get_value())

    def set_key(self, *args):
    	'''set_key(self) -> None

    	@copydoc WT_ASYNC_OP::set_key'''
    	if len(args) == 1 and type(args[0]) == tuple:
    		args = args[0]
    	if self.is_column:
    		self._set_recno(long(args[0]))
    	else:
    # Keep the Python string pinned
    		self._key = pack(self.key_format, *args)
    		self._set_key(self._key)

    def set_value(self, *args):
    	'''set_value(self) -> None

    	@copydoc WT_ASYNC_OP::set_value'''
    	if len(args) == 1 and type(args[0]) == tuple:
    		args = args[0]
    # Keep the Python string pinned
    	self._value = pack(self.value_format, *args)
    	self._set_value(self._value)

    def __getitem__(self, key):
    	'''Python convenience for searching'''
    	self.set_key(key)
    	if self.search() != 0:
    		raise KeyError
    	return self.get_value()

    def __setitem__(self, key, value):
    	'''Python convenience for inserting'''
    	self.set_key(key)
    	self.set_key(value)
    	self.insert()

AsyncOp.search = new_instancemethod(_wiredtiger.AsyncOp_search, None, AsyncOp)
AsyncOp.insert = new_instancemethod(_wiredtiger.AsyncOp_insert, None, AsyncOp)
AsyncOp.update = new_instancemethod(_wiredtiger.AsyncOp_update, None, AsyncOp)
AsyncOp.remove = new_instancemethod(_wiredtiger.AsyncOp_remove, None, AsyncOp)
AsyncOp.compact = new_instancemethod(_wiredtiger.AsyncOp_compact, None, AsyncOp)
AsyncOp.get_id = new_instancemethod(_wiredtiger.AsyncOp_get_id, None, AsyncOp)
AsyncOp.get_type = new_instancemethod(_wiredtiger.AsyncOp_get_type, None, AsyncOp)
AsyncOp._set_key = new_instancemethod(_wiredtiger.AsyncOp__set_key, None, AsyncOp)
AsyncOp._set_recno = new_instancemethod(_wiredtiger.AsyncOp__set_recno, None, AsyncOp)
AsyncOp._set_value = new_instancemethod(_wiredtiger.AsyncOp__set_value, None, AsyncOp)
AsyncOp._get_key = new_instancemethod(_wiredtiger.AsyncOp__get_key, None, AsyncOp)
AsyncOp._get_recno = new_instancemethod(_wiredtiger.AsyncOp__get_recno, None, AsyncOp)
AsyncOp._get_value = new_instancemethod(_wiredtiger.AsyncOp__get_value, None, AsyncOp)
AsyncOp._freecb = new_instancemethod(_wiredtiger.AsyncOp__freecb, None, AsyncOp)
AsyncOp_swigregister = _wiredtiger.AsyncOp_swigregister
AsyncOp_swigregister(AsyncOp)

class Session(object):
    """Proxy of C __wt_session struct."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    connection = _swig_property(_wiredtiger.Session_connection_get)

    def close(self, *args):
    	'''close(self, config) -> int

    	@copydoc __wt_session::close'''
    	try:
    		self._freecb()
    		return _wiredtiger.Session_close(self, *args)
    	finally:
    		self.this = None



    def reconfigure(self, *args):
        """reconfigure(self, session, config) -> int"""
        return _wiredtiger.Session_reconfigure(self, *args)


    def strerror(self, session, error):
        """strerror(self, session, error) -> char const *"""
        return _wiredtiger.Session_strerror(self, session, error)


    def open_cursor(self, *args):
        """open_cursor(self, session, uri, to_dup, config) -> int"""
        return _wiredtiger.Session_open_cursor(self, *args)


    def alter(self, *args):
        """alter(self, session, name, config) -> int"""
        return _wiredtiger.Session_alter(self, *args)


    def create(self, *args):
        """create(self, session, name, config) -> int"""
        return _wiredtiger.Session_create(self, *args)


    def compact(self, *args):
        """compact(self, session, name, config) -> int"""
        return _wiredtiger.Session_compact(self, *args)


    def drop(self, *args):
        """drop(self, session, name, config) -> int"""
        return _wiredtiger.Session_drop(self, *args)


    def join(self, *args):
        """join(self, session, join_cursor, ref_cursor, config) -> int"""
        return _wiredtiger.Session_join(self, *args)


    def log_flush(self, *args):
        """log_flush(self, session, config) -> int"""
        return _wiredtiger.Session_log_flush(self, *args)


    def rebalance(self, *args):
        """rebalance(self, session, uri, config) -> int"""
        return _wiredtiger.Session_rebalance(self, *args)


    def rename(self, *args):
        """rename(self, session, uri, newuri, config) -> int"""
        return _wiredtiger.Session_rename(self, *args)


    def reset(self, session):
        """reset(self, session) -> int"""
        return _wiredtiger.Session_reset(self, session)


    def salvage(self, *args):
        """salvage(self, session, name, config) -> int"""
        return _wiredtiger.Session_salvage(self, *args)


    def truncate(self, *args):
        """truncate(self, session, name, start, stop, config) -> int"""
        return _wiredtiger.Session_truncate(self, *args)


    def upgrade(self, *args):
        """upgrade(self, session, name, config) -> int"""
        return _wiredtiger.Session_upgrade(self, *args)


    def verify(self, *args):
        """verify(self, session, name, config) -> int"""
        return _wiredtiger.Session_verify(self, *args)


    def begin_transaction(self, *args):
        """begin_transaction(self, session, config) -> int"""
        return _wiredtiger.Session_begin_transaction(self, *args)


    def commit_transaction(self, *args):
        """commit_transaction(self, session, config) -> int"""
        return _wiredtiger.Session_commit_transaction(self, *args)


    def prepare_transaction(self, *args):
        """prepare_transaction(self, session, config) -> int"""
        return _wiredtiger.Session_prepare_transaction(self, *args)


    def rollback_transaction(self, *args):
        """rollback_transaction(self, session, config) -> int"""
        return _wiredtiger.Session_rollback_transaction(self, *args)


    def timestamp_transaction(self, *args):
        """timestamp_transaction(self, session, config) -> int"""
        return _wiredtiger.Session_timestamp_transaction(self, *args)


    def checkpoint(self, *args):
        """checkpoint(self, session, config) -> int"""
        return _wiredtiger.Session_checkpoint(self, *args)


    def snapshot(self, *args):
        """snapshot(self, session, config) -> int"""
        return _wiredtiger.Session_snapshot(self, *args)


    def transaction_pinned_range(self, session, range):
        """transaction_pinned_range(self, session, range) -> int"""
        return _wiredtiger.Session_transaction_pinned_range(self, session, range)


    def transaction_sync(self, *args):
        """transaction_sync(self, session, config) -> int"""
        return _wiredtiger.Session_transaction_sync(self, *args)


    def breakpoint(self, session):
        """breakpoint(self, session) -> int"""
        return _wiredtiger.Session_breakpoint(self, session)


    def _log_printf(self, msg):
        """_log_printf(self, msg) -> int"""
        return _wiredtiger.Session__log_printf(self, msg)


    def _freecb(self):
        """_freecb(self) -> int"""
        return _wiredtiger.Session__freecb(self)


    def log_printf(self, *args):
    	'''log_printf (self, msg) -> int

    	@copydoc class::log_printf'''
    	return self._log_printf(*args)

Session.reconfigure = new_instancemethod(_wiredtiger.Session_reconfigure, None, Session)
Session.strerror = new_instancemethod(_wiredtiger.Session_strerror, None, Session)
Session.open_cursor = new_instancemethod(_wiredtiger.Session_open_cursor, None, Session)
Session.alter = new_instancemethod(_wiredtiger.Session_alter, None, Session)
Session.create = new_instancemethod(_wiredtiger.Session_create, None, Session)
Session.compact = new_instancemethod(_wiredtiger.Session_compact, None, Session)
Session.drop = new_instancemethod(_wiredtiger.Session_drop, None, Session)
Session.join = new_instancemethod(_wiredtiger.Session_join, None, Session)
Session.log_flush = new_instancemethod(_wiredtiger.Session_log_flush, None, Session)
Session.rebalance = new_instancemethod(_wiredtiger.Session_rebalance, None, Session)
Session.rename = new_instancemethod(_wiredtiger.Session_rename, None, Session)
Session.reset = new_instancemethod(_wiredtiger.Session_reset, None, Session)
Session.salvage = new_instancemethod(_wiredtiger.Session_salvage, None, Session)
Session.truncate = new_instancemethod(_wiredtiger.Session_truncate, None, Session)
Session.upgrade = new_instancemethod(_wiredtiger.Session_upgrade, None, Session)
Session.verify = new_instancemethod(_wiredtiger.Session_verify, None, Session)
Session.begin_transaction = new_instancemethod(_wiredtiger.Session_begin_transaction, None, Session)
Session.commit_transaction = new_instancemethod(_wiredtiger.Session_commit_transaction, None, Session)
Session.prepare_transaction = new_instancemethod(_wiredtiger.Session_prepare_transaction, None, Session)
Session.rollback_transaction = new_instancemethod(_wiredtiger.Session_rollback_transaction, None, Session)
Session.timestamp_transaction = new_instancemethod(_wiredtiger.Session_timestamp_transaction, None, Session)
Session.checkpoint = new_instancemethod(_wiredtiger.Session_checkpoint, None, Session)
Session.snapshot = new_instancemethod(_wiredtiger.Session_snapshot, None, Session)
Session.transaction_pinned_range = new_instancemethod(_wiredtiger.Session_transaction_pinned_range, None, Session)
Session.transaction_sync = new_instancemethod(_wiredtiger.Session_transaction_sync, None, Session)
Session.breakpoint = new_instancemethod(_wiredtiger.Session_breakpoint, None, Session)
Session._log_printf = new_instancemethod(_wiredtiger.Session__log_printf, None, Session)
Session._freecb = new_instancemethod(_wiredtiger.Session__freecb, None, Session)
Session_swigregister = _wiredtiger.Session_swigregister
Session_swigregister(Session)

class Connection(object):
    """Proxy of C __wt_connection struct."""

    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def async_flush(self, connection):
        """async_flush(self, connection) -> int"""
        return _wiredtiger.Connection_async_flush(self, connection)


    def async_new_op(self, *args):
        """async_new_op(self, connection, uri, config, callback) -> int"""
        return _wiredtiger.Connection_async_new_op(self, *args)


    def close(self, *args):
    	'''close(self, config) -> int

    	@copydoc __wt_connection::close'''
    	try:
    		self._freecb()
    		return _wiredtiger.Connection_close(self, *args)
    	finally:
    		self.this = None



    def debug_info(self, *args):
        """debug_info(self, connection, config) -> int"""
        return _wiredtiger.Connection_debug_info(self, *args)


    def reconfigure(self, *args):
        """reconfigure(self, connection, config) -> int"""
        return _wiredtiger.Connection_reconfigure(self, *args)


    def get_home(self, connection):
        """get_home(self, connection) -> char const *"""
        return _wiredtiger.Connection_get_home(self, connection)


    def configure_method(self, *args):
        """configure_method(self, connection, method, uri, config, type, check) -> int"""
        return _wiredtiger.Connection_configure_method(self, *args)


    def is_new(self, connection):
        """is_new(self, connection) -> int"""
        return _wiredtiger.Connection_is_new(self, connection)


    def open_session(self, *args):
        """open_session(self, connection, config) -> int"""
        return _wiredtiger.Connection_open_session(self, *args)


    def query_timestamp(self, *args):
        """query_timestamp(self, connection, config) -> int"""
        return _wiredtiger.Connection_query_timestamp(self, *args)


    def set_timestamp(self, *args):
        """set_timestamp(self, connection, config) -> int"""
        return _wiredtiger.Connection_set_timestamp(self, *args)


    def rollback_to_stable(self, *args):
        """rollback_to_stable(self, connection, config) -> int"""
        return _wiredtiger.Connection_rollback_to_stable(self, *args)


    def load_extension(self, *args):
        """load_extension(self, connection, path, config) -> int"""
        return _wiredtiger.Connection_load_extension(self, *args)


    def set_file_system(self, *args):
        """set_file_system(self, connection, fs, config) -> int"""
        return _wiredtiger.Connection_set_file_system(self, *args)


    def _freecb(self):
        """_freecb(self) -> int"""
        return _wiredtiger.Connection__freecb(self)

Connection.async_flush = new_instancemethod(_wiredtiger.Connection_async_flush, None, Connection)
Connection.async_new_op = new_instancemethod(_wiredtiger.Connection_async_new_op, None, Connection)
Connection.debug_info = new_instancemethod(_wiredtiger.Connection_debug_info, None, Connection)
Connection.reconfigure = new_instancemethod(_wiredtiger.Connection_reconfigure, None, Connection)
Connection.get_home = new_instancemethod(_wiredtiger.Connection_get_home, None, Connection)
Connection.configure_method = new_instancemethod(_wiredtiger.Connection_configure_method, None, Connection)
Connection.is_new = new_instancemethod(_wiredtiger.Connection_is_new, None, Connection)
Connection.open_session = new_instancemethod(_wiredtiger.Connection_open_session, None, Connection)
Connection.query_timestamp = new_instancemethod(_wiredtiger.Connection_query_timestamp, None, Connection)
Connection.set_timestamp = new_instancemethod(_wiredtiger.Connection_set_timestamp, None, Connection)
Connection.rollback_to_stable = new_instancemethod(_wiredtiger.Connection_rollback_to_stable, None, Connection)
Connection.load_extension = new_instancemethod(_wiredtiger.Connection_load_extension, None, Connection)
Connection.set_file_system = new_instancemethod(_wiredtiger.Connection_set_file_system, None, Connection)
Connection._freecb = new_instancemethod(_wiredtiger.Connection__freecb, None, Connection)
Connection_swigregister = _wiredtiger.Connection_swigregister
Connection_swigregister(Connection)


def wiredtiger_open(*args):
    """wiredtiger_open(home, config) -> int"""
    return _wiredtiger.wiredtiger_open(*args)

def wiredtiger_strerror(error):
    """wiredtiger_strerror(error) -> char const *"""
    return _wiredtiger.wiredtiger_strerror(error)

def wiredtiger_version():
    """wiredtiger_version() -> char const *"""
    return _wiredtiger.wiredtiger_version()
WT_ROLLBACK = _wiredtiger.WT_ROLLBACK
WT_DUPLICATE_KEY = _wiredtiger.WT_DUPLICATE_KEY
WT_ERROR = _wiredtiger.WT_ERROR
WT_NOTFOUND = _wiredtiger.WT_NOTFOUND
WT_PANIC = _wiredtiger.WT_PANIC
WT_RESTART = _wiredtiger.WT_RESTART
WT_RUN_RECOVERY = _wiredtiger.WT_RUN_RECOVERY
WT_CACHE_FULL = _wiredtiger.WT_CACHE_FULL
WT_PREPARE_CONFLICT = _wiredtiger.WT_PREPARE_CONFLICT
WT_DEADLOCK = _wiredtiger.WT_DEADLOCK
WT_LOGREC_CHECKPOINT = _wiredtiger.WT_LOGREC_CHECKPOINT
WT_LOGREC_COMMIT = _wiredtiger.WT_LOGREC_COMMIT
WT_LOGREC_FILE_SYNC = _wiredtiger.WT_LOGREC_FILE_SYNC
WT_LOGREC_MESSAGE = _wiredtiger.WT_LOGREC_MESSAGE
WT_LOGREC_SYSTEM = _wiredtiger.WT_LOGREC_SYSTEM
WT_LOGOP_INVALID = _wiredtiger.WT_LOGOP_INVALID
WT_LOGOP_COL_PUT = _wiredtiger.WT_LOGOP_COL_PUT
WT_LOGOP_COL_REMOVE = _wiredtiger.WT_LOGOP_COL_REMOVE
WT_LOGOP_COL_TRUNCATE = _wiredtiger.WT_LOGOP_COL_TRUNCATE
WT_LOGOP_ROW_PUT = _wiredtiger.WT_LOGOP_ROW_PUT
WT_LOGOP_ROW_REMOVE = _wiredtiger.WT_LOGOP_ROW_REMOVE
WT_LOGOP_ROW_TRUNCATE = _wiredtiger.WT_LOGOP_ROW_TRUNCATE
WT_LOGOP_CHECKPOINT_START = _wiredtiger.WT_LOGOP_CHECKPOINT_START
WT_LOGOP_PREV_LSN = _wiredtiger.WT_LOGOP_PREV_LSN
WT_LOGOP_COL_MODIFY = _wiredtiger.WT_LOGOP_COL_MODIFY
WT_LOGOP_ROW_MODIFY = _wiredtiger.WT_LOGOP_ROW_MODIFY
WT_STAT_CONN_LSM_WORK_QUEUE_APP = _wiredtiger.WT_STAT_CONN_LSM_WORK_QUEUE_APP
WT_STAT_CONN_LSM_WORK_QUEUE_MANAGER = _wiredtiger.WT_STAT_CONN_LSM_WORK_QUEUE_MANAGER
WT_STAT_CONN_LSM_ROWS_MERGED = _wiredtiger.WT_STAT_CONN_LSM_ROWS_MERGED
WT_STAT_CONN_LSM_CHECKPOINT_THROTTLE = _wiredtiger.WT_STAT_CONN_LSM_CHECKPOINT_THROTTLE
WT_STAT_CONN_LSM_MERGE_THROTTLE = _wiredtiger.WT_STAT_CONN_LSM_MERGE_THROTTLE
WT_STAT_CONN_LSM_WORK_QUEUE_SWITCH = _wiredtiger.WT_STAT_CONN_LSM_WORK_QUEUE_SWITCH
WT_STAT_CONN_LSM_WORK_UNITS_DISCARDED = _wiredtiger.WT_STAT_CONN_LSM_WORK_UNITS_DISCARDED
WT_STAT_CONN_LSM_WORK_UNITS_DONE = _wiredtiger.WT_STAT_CONN_LSM_WORK_UNITS_DONE
WT_STAT_CONN_LSM_WORK_UNITS_CREATED = _wiredtiger.WT_STAT_CONN_LSM_WORK_UNITS_CREATED
WT_STAT_CONN_LSM_WORK_QUEUE_MAX = _wiredtiger.WT_STAT_CONN_LSM_WORK_QUEUE_MAX
WT_STAT_CONN_ASYNC_CUR_QUEUE = _wiredtiger.WT_STAT_CONN_ASYNC_CUR_QUEUE
WT_STAT_CONN_ASYNC_MAX_QUEUE = _wiredtiger.WT_STAT_CONN_ASYNC_MAX_QUEUE
WT_STAT_CONN_ASYNC_ALLOC_RACE = _wiredtiger.WT_STAT_CONN_ASYNC_ALLOC_RACE
WT_STAT_CONN_ASYNC_FLUSH = _wiredtiger.WT_STAT_CONN_ASYNC_FLUSH
WT_STAT_CONN_ASYNC_ALLOC_VIEW = _wiredtiger.WT_STAT_CONN_ASYNC_ALLOC_VIEW
WT_STAT_CONN_ASYNC_FULL = _wiredtiger.WT_STAT_CONN_ASYNC_FULL
WT_STAT_CONN_ASYNC_NOWORK = _wiredtiger.WT_STAT_CONN_ASYNC_NOWORK
WT_STAT_CONN_ASYNC_OP_ALLOC = _wiredtiger.WT_STAT_CONN_ASYNC_OP_ALLOC
WT_STAT_CONN_ASYNC_OP_COMPACT = _wiredtiger.WT_STAT_CONN_ASYNC_OP_COMPACT
WT_STAT_CONN_ASYNC_OP_INSERT = _wiredtiger.WT_STAT_CONN_ASYNC_OP_INSERT
WT_STAT_CONN_ASYNC_OP_REMOVE = _wiredtiger.WT_STAT_CONN_ASYNC_OP_REMOVE
WT_STAT_CONN_ASYNC_OP_SEARCH = _wiredtiger.WT_STAT_CONN_ASYNC_OP_SEARCH
WT_STAT_CONN_ASYNC_OP_UPDATE = _wiredtiger.WT_STAT_CONN_ASYNC_OP_UPDATE
WT_STAT_CONN_BLOCK_PRELOAD = _wiredtiger.WT_STAT_CONN_BLOCK_PRELOAD
WT_STAT_CONN_BLOCK_READ = _wiredtiger.WT_STAT_CONN_BLOCK_READ
WT_STAT_CONN_BLOCK_WRITE = _wiredtiger.WT_STAT_CONN_BLOCK_WRITE
WT_STAT_CONN_BLOCK_BYTE_READ = _wiredtiger.WT_STAT_CONN_BLOCK_BYTE_READ
WT_STAT_CONN_BLOCK_BYTE_WRITE = _wiredtiger.WT_STAT_CONN_BLOCK_BYTE_WRITE
WT_STAT_CONN_BLOCK_BYTE_WRITE_CHECKPOINT = _wiredtiger.WT_STAT_CONN_BLOCK_BYTE_WRITE_CHECKPOINT
WT_STAT_CONN_BLOCK_MAP_READ = _wiredtiger.WT_STAT_CONN_BLOCK_MAP_READ
WT_STAT_CONN_BLOCK_BYTE_MAP_READ = _wiredtiger.WT_STAT_CONN_BLOCK_BYTE_MAP_READ
WT_STAT_CONN_CACHE_READ_APP_COUNT = _wiredtiger.WT_STAT_CONN_CACHE_READ_APP_COUNT
WT_STAT_CONN_CACHE_READ_APP_TIME = _wiredtiger.WT_STAT_CONN_CACHE_READ_APP_TIME
WT_STAT_CONN_CACHE_WRITE_APP_COUNT = _wiredtiger.WT_STAT_CONN_CACHE_WRITE_APP_COUNT
WT_STAT_CONN_CACHE_WRITE_APP_TIME = _wiredtiger.WT_STAT_CONN_CACHE_WRITE_APP_TIME
WT_STAT_CONN_CACHE_BYTES_IMAGE = _wiredtiger.WT_STAT_CONN_CACHE_BYTES_IMAGE
WT_STAT_CONN_CACHE_BYTES_LOOKASIDE = _wiredtiger.WT_STAT_CONN_CACHE_BYTES_LOOKASIDE
WT_STAT_CONN_CACHE_BYTES_INUSE = _wiredtiger.WT_STAT_CONN_CACHE_BYTES_INUSE
WT_STAT_CONN_CACHE_BYTES_OTHER = _wiredtiger.WT_STAT_CONN_CACHE_BYTES_OTHER
WT_STAT_CONN_CACHE_BYTES_READ = _wiredtiger.WT_STAT_CONN_CACHE_BYTES_READ
WT_STAT_CONN_CACHE_BYTES_WRITE = _wiredtiger.WT_STAT_CONN_CACHE_BYTES_WRITE
WT_STAT_CONN_CACHE_EVICTION_CHECKPOINT = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_CHECKPOINT
WT_STAT_CONN_CACHE_EVICTION_GET_REF = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_GET_REF
WT_STAT_CONN_CACHE_EVICTION_GET_REF_EMPTY = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_GET_REF_EMPTY
WT_STAT_CONN_CACHE_EVICTION_GET_REF_EMPTY2 = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_GET_REF_EMPTY2
WT_STAT_CONN_CACHE_EVICTION_AGGRESSIVE_SET = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_AGGRESSIVE_SET
WT_STAT_CONN_CACHE_EVICTION_EMPTY_SCORE = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_EMPTY_SCORE
WT_STAT_CONN_CACHE_EVICTION_WALK_PASSES = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_WALK_PASSES
WT_STAT_CONN_CACHE_EVICTION_QUEUE_EMPTY = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_QUEUE_EMPTY
WT_STAT_CONN_CACHE_EVICTION_QUEUE_NOT_EMPTY = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_QUEUE_NOT_EMPTY
WT_STAT_CONN_CACHE_EVICTION_SERVER_EVICTING = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_SERVER_EVICTING
WT_STAT_CONN_CACHE_EVICTION_SERVER_SLEPT = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_SERVER_SLEPT
WT_STAT_CONN_CACHE_EVICTION_SLOW = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_SLOW
WT_STAT_CONN_CACHE_EVICTION_STATE = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_STATE
WT_STAT_CONN_CACHE_EVICTION_TARGET_PAGE_LT10 = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_TARGET_PAGE_LT10
WT_STAT_CONN_CACHE_EVICTION_TARGET_PAGE_LT32 = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_TARGET_PAGE_LT32
WT_STAT_CONN_CACHE_EVICTION_TARGET_PAGE_GE128 = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_TARGET_PAGE_GE128
WT_STAT_CONN_CACHE_EVICTION_TARGET_PAGE_LT64 = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_TARGET_PAGE_LT64
WT_STAT_CONN_CACHE_EVICTION_TARGET_PAGE_LT128 = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_TARGET_PAGE_LT128
WT_STAT_CONN_CACHE_EVICTION_WALKS_ABANDONED = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_WALKS_ABANDONED
WT_STAT_CONN_CACHE_EVICTION_WALKS_STOPPED = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_WALKS_STOPPED
WT_STAT_CONN_CACHE_EVICTION_WALKS_GAVE_UP_NO_TARGETS = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_WALKS_GAVE_UP_NO_TARGETS
WT_STAT_CONN_CACHE_EVICTION_WALKS_GAVE_UP_RATIO = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_WALKS_GAVE_UP_RATIO
WT_STAT_CONN_CACHE_EVICTION_WALKS_ENDED = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_WALKS_ENDED
WT_STAT_CONN_CACHE_EVICTION_WALK_FROM_ROOT = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_WALK_FROM_ROOT
WT_STAT_CONN_CACHE_EVICTION_WALK_SAVED_POS = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_WALK_SAVED_POS
WT_STAT_CONN_CACHE_EVICTION_ACTIVE_WORKERS = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_ACTIVE_WORKERS
WT_STAT_CONN_CACHE_EVICTION_WORKER_CREATED = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_WORKER_CREATED
WT_STAT_CONN_CACHE_EVICTION_WORKER_EVICTING = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_WORKER_EVICTING
WT_STAT_CONN_CACHE_EVICTION_WORKER_REMOVED = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_WORKER_REMOVED
WT_STAT_CONN_CACHE_EVICTION_STABLE_STATE_WORKERS = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_STABLE_STATE_WORKERS
WT_STAT_CONN_CACHE_EVICTION_FORCE_FAIL = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_FORCE_FAIL
WT_STAT_CONN_CACHE_EVICTION_FORCE_FAIL_TIME = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_FORCE_FAIL_TIME
WT_STAT_CONN_CACHE_EVICTION_WALKS_ACTIVE = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_WALKS_ACTIVE
WT_STAT_CONN_CACHE_EVICTION_WALKS_STARTED = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_WALKS_STARTED
WT_STAT_CONN_CACHE_EVICTION_FORCE_RETUNE = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_FORCE_RETUNE
WT_STAT_CONN_CACHE_EVICTION_HAZARD = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_HAZARD
WT_STAT_CONN_CACHE_HAZARD_CHECKS = _wiredtiger.WT_STAT_CONN_CACHE_HAZARD_CHECKS
WT_STAT_CONN_CACHE_HAZARD_WALKS = _wiredtiger.WT_STAT_CONN_CACHE_HAZARD_WALKS
WT_STAT_CONN_CACHE_HAZARD_MAX = _wiredtiger.WT_STAT_CONN_CACHE_HAZARD_MAX
WT_STAT_CONN_CACHE_INMEM_SPLITTABLE = _wiredtiger.WT_STAT_CONN_CACHE_INMEM_SPLITTABLE
WT_STAT_CONN_CACHE_INMEM_SPLIT = _wiredtiger.WT_STAT_CONN_CACHE_INMEM_SPLIT
WT_STAT_CONN_CACHE_EVICTION_INTERNAL = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_INTERNAL
WT_STAT_CONN_CACHE_EVICTION_SPLIT_INTERNAL = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_SPLIT_INTERNAL
WT_STAT_CONN_CACHE_EVICTION_SPLIT_LEAF = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_SPLIT_LEAF
WT_STAT_CONN_CACHE_LOOKASIDE_SCORE = _wiredtiger.WT_STAT_CONN_CACHE_LOOKASIDE_SCORE
WT_STAT_CONN_CACHE_LOOKASIDE_ENTRIES = _wiredtiger.WT_STAT_CONN_CACHE_LOOKASIDE_ENTRIES
WT_STAT_CONN_CACHE_LOOKASIDE_INSERT = _wiredtiger.WT_STAT_CONN_CACHE_LOOKASIDE_INSERT
WT_STAT_CONN_CACHE_LOOKASIDE_REMOVE = _wiredtiger.WT_STAT_CONN_CACHE_LOOKASIDE_REMOVE
WT_STAT_CONN_CACHE_BYTES_MAX = _wiredtiger.WT_STAT_CONN_CACHE_BYTES_MAX
WT_STAT_CONN_CACHE_EVICTION_MAXIMUM_PAGE_SIZE = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_MAXIMUM_PAGE_SIZE
WT_STAT_CONN_CACHE_EVICTION_DIRTY = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_DIRTY
WT_STAT_CONN_CACHE_EVICTION_APP_DIRTY = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_APP_DIRTY
WT_STAT_CONN_CACHE_READ_OVERFLOW = _wiredtiger.WT_STAT_CONN_CACHE_READ_OVERFLOW
WT_STAT_CONN_CACHE_EVICTION_DEEPEN = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_DEEPEN
WT_STAT_CONN_CACHE_WRITE_LOOKASIDE = _wiredtiger.WT_STAT_CONN_CACHE_WRITE_LOOKASIDE
WT_STAT_CONN_CACHE_PAGES_INUSE = _wiredtiger.WT_STAT_CONN_CACHE_PAGES_INUSE
WT_STAT_CONN_CACHE_EVICTION_FORCE = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_FORCE
WT_STAT_CONN_CACHE_EVICTION_FORCE_TIME = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_FORCE_TIME
WT_STAT_CONN_CACHE_EVICTION_FORCE_DELETE = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_FORCE_DELETE
WT_STAT_CONN_CACHE_EVICTION_FORCE_DELETE_TIME = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_FORCE_DELETE_TIME
WT_STAT_CONN_CACHE_EVICTION_APP = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_APP
WT_STAT_CONN_CACHE_EVICTION_PAGES_QUEUED = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_PAGES_QUEUED
WT_STAT_CONN_CACHE_EVICTION_PAGES_QUEUED_URGENT = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_PAGES_QUEUED_URGENT
WT_STAT_CONN_CACHE_EVICTION_PAGES_QUEUED_OLDEST = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_PAGES_QUEUED_OLDEST
WT_STAT_CONN_CACHE_READ = _wiredtiger.WT_STAT_CONN_CACHE_READ
WT_STAT_CONN_CACHE_READ_DELETED = _wiredtiger.WT_STAT_CONN_CACHE_READ_DELETED
WT_STAT_CONN_CACHE_READ_DELETED_PREPARED = _wiredtiger.WT_STAT_CONN_CACHE_READ_DELETED_PREPARED
WT_STAT_CONN_CACHE_READ_LOOKASIDE = _wiredtiger.WT_STAT_CONN_CACHE_READ_LOOKASIDE
WT_STAT_CONN_CACHE_READ_LOOKASIDE_CHECKPOINT = _wiredtiger.WT_STAT_CONN_CACHE_READ_LOOKASIDE_CHECKPOINT
WT_STAT_CONN_CACHE_READ_LOOKASIDE_SKIPPED = _wiredtiger.WT_STAT_CONN_CACHE_READ_LOOKASIDE_SKIPPED
WT_STAT_CONN_CACHE_READ_LOOKASIDE_DELAY = _wiredtiger.WT_STAT_CONN_CACHE_READ_LOOKASIDE_DELAY
WT_STAT_CONN_CACHE_READ_LOOKASIDE_DELAY_CHECKPOINT = _wiredtiger.WT_STAT_CONN_CACHE_READ_LOOKASIDE_DELAY_CHECKPOINT
WT_STAT_CONN_CACHE_PAGES_REQUESTED = _wiredtiger.WT_STAT_CONN_CACHE_PAGES_REQUESTED
WT_STAT_CONN_CACHE_EVICTION_PAGES_SEEN = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_PAGES_SEEN
WT_STAT_CONN_CACHE_EVICTION_FAIL = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_FAIL
WT_STAT_CONN_CACHE_EVICTION_WALK = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_WALK
WT_STAT_CONN_CACHE_WRITE = _wiredtiger.WT_STAT_CONN_CACHE_WRITE
WT_STAT_CONN_CACHE_WRITE_RESTORE = _wiredtiger.WT_STAT_CONN_CACHE_WRITE_RESTORE
WT_STAT_CONN_CACHE_OVERHEAD = _wiredtiger.WT_STAT_CONN_CACHE_OVERHEAD
WT_STAT_CONN_CACHE_BYTES_INTERNAL = _wiredtiger.WT_STAT_CONN_CACHE_BYTES_INTERNAL
WT_STAT_CONN_CACHE_BYTES_LEAF = _wiredtiger.WT_STAT_CONN_CACHE_BYTES_LEAF
WT_STAT_CONN_CACHE_BYTES_DIRTY = _wiredtiger.WT_STAT_CONN_CACHE_BYTES_DIRTY
WT_STAT_CONN_CACHE_PAGES_DIRTY = _wiredtiger.WT_STAT_CONN_CACHE_PAGES_DIRTY
WT_STAT_CONN_CACHE_EVICTION_CLEAN = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_CLEAN
WT_STAT_CONN_COND_AUTO_WAIT_RESET = _wiredtiger.WT_STAT_CONN_COND_AUTO_WAIT_RESET
WT_STAT_CONN_COND_AUTO_WAIT = _wiredtiger.WT_STAT_CONN_COND_AUTO_WAIT
WT_STAT_CONN_TIME_TRAVEL = _wiredtiger.WT_STAT_CONN_TIME_TRAVEL
WT_STAT_CONN_FILE_OPEN = _wiredtiger.WT_STAT_CONN_FILE_OPEN
WT_STAT_CONN_MEMORY_ALLOCATION = _wiredtiger.WT_STAT_CONN_MEMORY_ALLOCATION
WT_STAT_CONN_MEMORY_FREE = _wiredtiger.WT_STAT_CONN_MEMORY_FREE
WT_STAT_CONN_MEMORY_GROW = _wiredtiger.WT_STAT_CONN_MEMORY_GROW
WT_STAT_CONN_COND_WAIT = _wiredtiger.WT_STAT_CONN_COND_WAIT
WT_STAT_CONN_RWLOCK_READ = _wiredtiger.WT_STAT_CONN_RWLOCK_READ
WT_STAT_CONN_RWLOCK_WRITE = _wiredtiger.WT_STAT_CONN_RWLOCK_WRITE
WT_STAT_CONN_FSYNC_IO = _wiredtiger.WT_STAT_CONN_FSYNC_IO
WT_STAT_CONN_READ_IO = _wiredtiger.WT_STAT_CONN_READ_IO
WT_STAT_CONN_WRITE_IO = _wiredtiger.WT_STAT_CONN_WRITE_IO
WT_STAT_CONN_CURSOR_CREATE = _wiredtiger.WT_STAT_CONN_CURSOR_CREATE
WT_STAT_CONN_CURSOR_INSERT = _wiredtiger.WT_STAT_CONN_CURSOR_INSERT
WT_STAT_CONN_CURSOR_MODIFY = _wiredtiger.WT_STAT_CONN_CURSOR_MODIFY
WT_STAT_CONN_CURSOR_NEXT = _wiredtiger.WT_STAT_CONN_CURSOR_NEXT
WT_STAT_CONN_CURSOR_PREV = _wiredtiger.WT_STAT_CONN_CURSOR_PREV
WT_STAT_CONN_CURSOR_REMOVE = _wiredtiger.WT_STAT_CONN_CURSOR_REMOVE
WT_STAT_CONN_CURSOR_RESERVE = _wiredtiger.WT_STAT_CONN_CURSOR_RESERVE
WT_STAT_CONN_CURSOR_RESET = _wiredtiger.WT_STAT_CONN_CURSOR_RESET
WT_STAT_CONN_CURSOR_RESTART = _wiredtiger.WT_STAT_CONN_CURSOR_RESTART
WT_STAT_CONN_CURSOR_SEARCH = _wiredtiger.WT_STAT_CONN_CURSOR_SEARCH
WT_STAT_CONN_CURSOR_SEARCH_NEAR = _wiredtiger.WT_STAT_CONN_CURSOR_SEARCH_NEAR
WT_STAT_CONN_CURSOR_SWEEP_BUCKETS = _wiredtiger.WT_STAT_CONN_CURSOR_SWEEP_BUCKETS
WT_STAT_CONN_CURSOR_SWEEP_CLOSED = _wiredtiger.WT_STAT_CONN_CURSOR_SWEEP_CLOSED
WT_STAT_CONN_CURSOR_SWEEP_EXAMINED = _wiredtiger.WT_STAT_CONN_CURSOR_SWEEP_EXAMINED
WT_STAT_CONN_CURSOR_SWEEP = _wiredtiger.WT_STAT_CONN_CURSOR_SWEEP
WT_STAT_CONN_CURSOR_UPDATE = _wiredtiger.WT_STAT_CONN_CURSOR_UPDATE
WT_STAT_CONN_CURSOR_CACHE = _wiredtiger.WT_STAT_CONN_CURSOR_CACHE
WT_STAT_CONN_CURSOR_REOPEN = _wiredtiger.WT_STAT_CONN_CURSOR_REOPEN
WT_STAT_CONN_CURSOR_TRUNCATE = _wiredtiger.WT_STAT_CONN_CURSOR_TRUNCATE
WT_STAT_CONN_DH_CONN_HANDLE_COUNT = _wiredtiger.WT_STAT_CONN_DH_CONN_HANDLE_COUNT
WT_STAT_CONN_DH_SWEEP_REF = _wiredtiger.WT_STAT_CONN_DH_SWEEP_REF
WT_STAT_CONN_DH_SWEEP_CLOSE = _wiredtiger.WT_STAT_CONN_DH_SWEEP_CLOSE
WT_STAT_CONN_DH_SWEEP_REMOVE = _wiredtiger.WT_STAT_CONN_DH_SWEEP_REMOVE
WT_STAT_CONN_DH_SWEEP_TOD = _wiredtiger.WT_STAT_CONN_DH_SWEEP_TOD
WT_STAT_CONN_DH_SWEEPS = _wiredtiger.WT_STAT_CONN_DH_SWEEPS
WT_STAT_CONN_DH_SESSION_HANDLES = _wiredtiger.WT_STAT_CONN_DH_SESSION_HANDLES
WT_STAT_CONN_DH_SESSION_SWEEPS = _wiredtiger.WT_STAT_CONN_DH_SESSION_SWEEPS
WT_STAT_CONN_LOCK_CHECKPOINT_COUNT = _wiredtiger.WT_STAT_CONN_LOCK_CHECKPOINT_COUNT
WT_STAT_CONN_LOCK_CHECKPOINT_WAIT_APPLICATION = _wiredtiger.WT_STAT_CONN_LOCK_CHECKPOINT_WAIT_APPLICATION
WT_STAT_CONN_LOCK_CHECKPOINT_WAIT_INTERNAL = _wiredtiger.WT_STAT_CONN_LOCK_CHECKPOINT_WAIT_INTERNAL
WT_STAT_CONN_LOCK_COMMIT_TIMESTAMP_WAIT_APPLICATION = _wiredtiger.WT_STAT_CONN_LOCK_COMMIT_TIMESTAMP_WAIT_APPLICATION
WT_STAT_CONN_LOCK_COMMIT_TIMESTAMP_WAIT_INTERNAL = _wiredtiger.WT_STAT_CONN_LOCK_COMMIT_TIMESTAMP_WAIT_INTERNAL
WT_STAT_CONN_LOCK_COMMIT_TIMESTAMP_READ_COUNT = _wiredtiger.WT_STAT_CONN_LOCK_COMMIT_TIMESTAMP_READ_COUNT
WT_STAT_CONN_LOCK_COMMIT_TIMESTAMP_WRITE_COUNT = _wiredtiger.WT_STAT_CONN_LOCK_COMMIT_TIMESTAMP_WRITE_COUNT
WT_STAT_CONN_LOCK_DHANDLE_WAIT_APPLICATION = _wiredtiger.WT_STAT_CONN_LOCK_DHANDLE_WAIT_APPLICATION
WT_STAT_CONN_LOCK_DHANDLE_WAIT_INTERNAL = _wiredtiger.WT_STAT_CONN_LOCK_DHANDLE_WAIT_INTERNAL
WT_STAT_CONN_LOCK_DHANDLE_READ_COUNT = _wiredtiger.WT_STAT_CONN_LOCK_DHANDLE_READ_COUNT
WT_STAT_CONN_LOCK_DHANDLE_WRITE_COUNT = _wiredtiger.WT_STAT_CONN_LOCK_DHANDLE_WRITE_COUNT
WT_STAT_CONN_LOCK_METADATA_COUNT = _wiredtiger.WT_STAT_CONN_LOCK_METADATA_COUNT
WT_STAT_CONN_LOCK_METADATA_WAIT_APPLICATION = _wiredtiger.WT_STAT_CONN_LOCK_METADATA_WAIT_APPLICATION
WT_STAT_CONN_LOCK_METADATA_WAIT_INTERNAL = _wiredtiger.WT_STAT_CONN_LOCK_METADATA_WAIT_INTERNAL
WT_STAT_CONN_LOCK_READ_TIMESTAMP_WAIT_APPLICATION = _wiredtiger.WT_STAT_CONN_LOCK_READ_TIMESTAMP_WAIT_APPLICATION
WT_STAT_CONN_LOCK_READ_TIMESTAMP_WAIT_INTERNAL = _wiredtiger.WT_STAT_CONN_LOCK_READ_TIMESTAMP_WAIT_INTERNAL
WT_STAT_CONN_LOCK_READ_TIMESTAMP_READ_COUNT = _wiredtiger.WT_STAT_CONN_LOCK_READ_TIMESTAMP_READ_COUNT
WT_STAT_CONN_LOCK_READ_TIMESTAMP_WRITE_COUNT = _wiredtiger.WT_STAT_CONN_LOCK_READ_TIMESTAMP_WRITE_COUNT
WT_STAT_CONN_LOCK_SCHEMA_COUNT = _wiredtiger.WT_STAT_CONN_LOCK_SCHEMA_COUNT
WT_STAT_CONN_LOCK_SCHEMA_WAIT_APPLICATION = _wiredtiger.WT_STAT_CONN_LOCK_SCHEMA_WAIT_APPLICATION
WT_STAT_CONN_LOCK_SCHEMA_WAIT_INTERNAL = _wiredtiger.WT_STAT_CONN_LOCK_SCHEMA_WAIT_INTERNAL
WT_STAT_CONN_LOCK_TABLE_WAIT_APPLICATION = _wiredtiger.WT_STAT_CONN_LOCK_TABLE_WAIT_APPLICATION
WT_STAT_CONN_LOCK_TABLE_WAIT_INTERNAL = _wiredtiger.WT_STAT_CONN_LOCK_TABLE_WAIT_INTERNAL
WT_STAT_CONN_LOCK_TABLE_READ_COUNT = _wiredtiger.WT_STAT_CONN_LOCK_TABLE_READ_COUNT
WT_STAT_CONN_LOCK_TABLE_WRITE_COUNT = _wiredtiger.WT_STAT_CONN_LOCK_TABLE_WRITE_COUNT
WT_STAT_CONN_LOCK_TXN_GLOBAL_WAIT_APPLICATION = _wiredtiger.WT_STAT_CONN_LOCK_TXN_GLOBAL_WAIT_APPLICATION
WT_STAT_CONN_LOCK_TXN_GLOBAL_WAIT_INTERNAL = _wiredtiger.WT_STAT_CONN_LOCK_TXN_GLOBAL_WAIT_INTERNAL
WT_STAT_CONN_LOCK_TXN_GLOBAL_READ_COUNT = _wiredtiger.WT_STAT_CONN_LOCK_TXN_GLOBAL_READ_COUNT
WT_STAT_CONN_LOCK_TXN_GLOBAL_WRITE_COUNT = _wiredtiger.WT_STAT_CONN_LOCK_TXN_GLOBAL_WRITE_COUNT
WT_STAT_CONN_LOG_SLOT_SWITCH_BUSY = _wiredtiger.WT_STAT_CONN_LOG_SLOT_SWITCH_BUSY
WT_STAT_CONN_LOG_FORCE_ARCHIVE_SLEEP = _wiredtiger.WT_STAT_CONN_LOG_FORCE_ARCHIVE_SLEEP
WT_STAT_CONN_LOG_BYTES_PAYLOAD = _wiredtiger.WT_STAT_CONN_LOG_BYTES_PAYLOAD
WT_STAT_CONN_LOG_BYTES_WRITTEN = _wiredtiger.WT_STAT_CONN_LOG_BYTES_WRITTEN
WT_STAT_CONN_LOG_ZERO_FILLS = _wiredtiger.WT_STAT_CONN_LOG_ZERO_FILLS
WT_STAT_CONN_LOG_FLUSH = _wiredtiger.WT_STAT_CONN_LOG_FLUSH
WT_STAT_CONN_LOG_FORCE_WRITE = _wiredtiger.WT_STAT_CONN_LOG_FORCE_WRITE
WT_STAT_CONN_LOG_FORCE_WRITE_SKIP = _wiredtiger.WT_STAT_CONN_LOG_FORCE_WRITE_SKIP
WT_STAT_CONN_LOG_COMPRESS_WRITES = _wiredtiger.WT_STAT_CONN_LOG_COMPRESS_WRITES
WT_STAT_CONN_LOG_COMPRESS_WRITE_FAILS = _wiredtiger.WT_STAT_CONN_LOG_COMPRESS_WRITE_FAILS
WT_STAT_CONN_LOG_COMPRESS_SMALL = _wiredtiger.WT_STAT_CONN_LOG_COMPRESS_SMALL
WT_STAT_CONN_LOG_RELEASE_WRITE_LSN = _wiredtiger.WT_STAT_CONN_LOG_RELEASE_WRITE_LSN
WT_STAT_CONN_LOG_SCANS = _wiredtiger.WT_STAT_CONN_LOG_SCANS
WT_STAT_CONN_LOG_SCAN_REREADS = _wiredtiger.WT_STAT_CONN_LOG_SCAN_REREADS
WT_STAT_CONN_LOG_WRITE_LSN = _wiredtiger.WT_STAT_CONN_LOG_WRITE_LSN
WT_STAT_CONN_LOG_WRITE_LSN_SKIP = _wiredtiger.WT_STAT_CONN_LOG_WRITE_LSN_SKIP
WT_STAT_CONN_LOG_SYNC = _wiredtiger.WT_STAT_CONN_LOG_SYNC
WT_STAT_CONN_LOG_SYNC_DURATION = _wiredtiger.WT_STAT_CONN_LOG_SYNC_DURATION
WT_STAT_CONN_LOG_SYNC_DIR = _wiredtiger.WT_STAT_CONN_LOG_SYNC_DIR
WT_STAT_CONN_LOG_SYNC_DIR_DURATION = _wiredtiger.WT_STAT_CONN_LOG_SYNC_DIR_DURATION
WT_STAT_CONN_LOG_WRITES = _wiredtiger.WT_STAT_CONN_LOG_WRITES
WT_STAT_CONN_LOG_SLOT_CONSOLIDATED = _wiredtiger.WT_STAT_CONN_LOG_SLOT_CONSOLIDATED
WT_STAT_CONN_LOG_MAX_FILESIZE = _wiredtiger.WT_STAT_CONN_LOG_MAX_FILESIZE
WT_STAT_CONN_LOG_PREALLOC_MAX = _wiredtiger.WT_STAT_CONN_LOG_PREALLOC_MAX
WT_STAT_CONN_LOG_PREALLOC_MISSED = _wiredtiger.WT_STAT_CONN_LOG_PREALLOC_MISSED
WT_STAT_CONN_LOG_PREALLOC_FILES = _wiredtiger.WT_STAT_CONN_LOG_PREALLOC_FILES
WT_STAT_CONN_LOG_PREALLOC_USED = _wiredtiger.WT_STAT_CONN_LOG_PREALLOC_USED
WT_STAT_CONN_LOG_SCAN_RECORDS = _wiredtiger.WT_STAT_CONN_LOG_SCAN_RECORDS
WT_STAT_CONN_LOG_SLOT_CLOSE_RACE = _wiredtiger.WT_STAT_CONN_LOG_SLOT_CLOSE_RACE
WT_STAT_CONN_LOG_SLOT_CLOSE_UNBUF = _wiredtiger.WT_STAT_CONN_LOG_SLOT_CLOSE_UNBUF
WT_STAT_CONN_LOG_SLOT_CLOSES = _wiredtiger.WT_STAT_CONN_LOG_SLOT_CLOSES
WT_STAT_CONN_LOG_SLOT_RACES = _wiredtiger.WT_STAT_CONN_LOG_SLOT_RACES
WT_STAT_CONN_LOG_SLOT_YIELD_RACE = _wiredtiger.WT_STAT_CONN_LOG_SLOT_YIELD_RACE
WT_STAT_CONN_LOG_SLOT_IMMEDIATE = _wiredtiger.WT_STAT_CONN_LOG_SLOT_IMMEDIATE
WT_STAT_CONN_LOG_SLOT_YIELD_CLOSE = _wiredtiger.WT_STAT_CONN_LOG_SLOT_YIELD_CLOSE
WT_STAT_CONN_LOG_SLOT_YIELD_SLEEP = _wiredtiger.WT_STAT_CONN_LOG_SLOT_YIELD_SLEEP
WT_STAT_CONN_LOG_SLOT_YIELD = _wiredtiger.WT_STAT_CONN_LOG_SLOT_YIELD
WT_STAT_CONN_LOG_SLOT_ACTIVE_CLOSED = _wiredtiger.WT_STAT_CONN_LOG_SLOT_ACTIVE_CLOSED
WT_STAT_CONN_LOG_SLOT_YIELD_DURATION = _wiredtiger.WT_STAT_CONN_LOG_SLOT_YIELD_DURATION
WT_STAT_CONN_LOG_SLOT_NO_FREE_SLOTS = _wiredtiger.WT_STAT_CONN_LOG_SLOT_NO_FREE_SLOTS
WT_STAT_CONN_LOG_SLOT_UNBUFFERED = _wiredtiger.WT_STAT_CONN_LOG_SLOT_UNBUFFERED
WT_STAT_CONN_LOG_COMPRESS_MEM = _wiredtiger.WT_STAT_CONN_LOG_COMPRESS_MEM
WT_STAT_CONN_LOG_BUFFER_SIZE = _wiredtiger.WT_STAT_CONN_LOG_BUFFER_SIZE
WT_STAT_CONN_LOG_COMPRESS_LEN = _wiredtiger.WT_STAT_CONN_LOG_COMPRESS_LEN
WT_STAT_CONN_LOG_SLOT_COALESCED = _wiredtiger.WT_STAT_CONN_LOG_SLOT_COALESCED
WT_STAT_CONN_LOG_CLOSE_YIELDS = _wiredtiger.WT_STAT_CONN_LOG_CLOSE_YIELDS
WT_STAT_CONN_PERF_HIST_FSREAD_LATENCY_LT50 = _wiredtiger.WT_STAT_CONN_PERF_HIST_FSREAD_LATENCY_LT50
WT_STAT_CONN_PERF_HIST_FSREAD_LATENCY_LT100 = _wiredtiger.WT_STAT_CONN_PERF_HIST_FSREAD_LATENCY_LT100
WT_STAT_CONN_PERF_HIST_FSREAD_LATENCY_LT250 = _wiredtiger.WT_STAT_CONN_PERF_HIST_FSREAD_LATENCY_LT250
WT_STAT_CONN_PERF_HIST_FSREAD_LATENCY_LT500 = _wiredtiger.WT_STAT_CONN_PERF_HIST_FSREAD_LATENCY_LT500
WT_STAT_CONN_PERF_HIST_FSREAD_LATENCY_LT1000 = _wiredtiger.WT_STAT_CONN_PERF_HIST_FSREAD_LATENCY_LT1000
WT_STAT_CONN_PERF_HIST_FSREAD_LATENCY_GT1000 = _wiredtiger.WT_STAT_CONN_PERF_HIST_FSREAD_LATENCY_GT1000
WT_STAT_CONN_PERF_HIST_FSWRITE_LATENCY_LT50 = _wiredtiger.WT_STAT_CONN_PERF_HIST_FSWRITE_LATENCY_LT50
WT_STAT_CONN_PERF_HIST_FSWRITE_LATENCY_LT100 = _wiredtiger.WT_STAT_CONN_PERF_HIST_FSWRITE_LATENCY_LT100
WT_STAT_CONN_PERF_HIST_FSWRITE_LATENCY_LT250 = _wiredtiger.WT_STAT_CONN_PERF_HIST_FSWRITE_LATENCY_LT250
WT_STAT_CONN_PERF_HIST_FSWRITE_LATENCY_LT500 = _wiredtiger.WT_STAT_CONN_PERF_HIST_FSWRITE_LATENCY_LT500
WT_STAT_CONN_PERF_HIST_FSWRITE_LATENCY_LT1000 = _wiredtiger.WT_STAT_CONN_PERF_HIST_FSWRITE_LATENCY_LT1000
WT_STAT_CONN_PERF_HIST_FSWRITE_LATENCY_GT1000 = _wiredtiger.WT_STAT_CONN_PERF_HIST_FSWRITE_LATENCY_GT1000
WT_STAT_CONN_PERF_HIST_OPREAD_LATENCY_LT250 = _wiredtiger.WT_STAT_CONN_PERF_HIST_OPREAD_LATENCY_LT250
WT_STAT_CONN_PERF_HIST_OPREAD_LATENCY_LT500 = _wiredtiger.WT_STAT_CONN_PERF_HIST_OPREAD_LATENCY_LT500
WT_STAT_CONN_PERF_HIST_OPREAD_LATENCY_LT1000 = _wiredtiger.WT_STAT_CONN_PERF_HIST_OPREAD_LATENCY_LT1000
WT_STAT_CONN_PERF_HIST_OPREAD_LATENCY_LT10000 = _wiredtiger.WT_STAT_CONN_PERF_HIST_OPREAD_LATENCY_LT10000
WT_STAT_CONN_PERF_HIST_OPREAD_LATENCY_GT10000 = _wiredtiger.WT_STAT_CONN_PERF_HIST_OPREAD_LATENCY_GT10000
WT_STAT_CONN_PERF_HIST_OPWRITE_LATENCY_LT250 = _wiredtiger.WT_STAT_CONN_PERF_HIST_OPWRITE_LATENCY_LT250
WT_STAT_CONN_PERF_HIST_OPWRITE_LATENCY_LT500 = _wiredtiger.WT_STAT_CONN_PERF_HIST_OPWRITE_LATENCY_LT500
WT_STAT_CONN_PERF_HIST_OPWRITE_LATENCY_LT1000 = _wiredtiger.WT_STAT_CONN_PERF_HIST_OPWRITE_LATENCY_LT1000
WT_STAT_CONN_PERF_HIST_OPWRITE_LATENCY_LT10000 = _wiredtiger.WT_STAT_CONN_PERF_HIST_OPWRITE_LATENCY_LT10000
WT_STAT_CONN_PERF_HIST_OPWRITE_LATENCY_GT10000 = _wiredtiger.WT_STAT_CONN_PERF_HIST_OPWRITE_LATENCY_GT10000
WT_STAT_CONN_REC_PAGE_DELETE_FAST = _wiredtiger.WT_STAT_CONN_REC_PAGE_DELETE_FAST
WT_STAT_CONN_REC_PAGES = _wiredtiger.WT_STAT_CONN_REC_PAGES
WT_STAT_CONN_REC_PAGES_EVICTION = _wiredtiger.WT_STAT_CONN_REC_PAGES_EVICTION
WT_STAT_CONN_REC_PAGE_DELETE = _wiredtiger.WT_STAT_CONN_REC_PAGE_DELETE
WT_STAT_CONN_REC_SPLIT_STASHED_BYTES = _wiredtiger.WT_STAT_CONN_REC_SPLIT_STASHED_BYTES
WT_STAT_CONN_REC_SPLIT_STASHED_OBJECTS = _wiredtiger.WT_STAT_CONN_REC_SPLIT_STASHED_OBJECTS
WT_STAT_CONN_SESSION_CURSOR_OPEN = _wiredtiger.WT_STAT_CONN_SESSION_CURSOR_OPEN
WT_STAT_CONN_SESSION_OPEN = _wiredtiger.WT_STAT_CONN_SESSION_OPEN
WT_STAT_CONN_SESSION_TABLE_ALTER_FAIL = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_ALTER_FAIL
WT_STAT_CONN_SESSION_TABLE_ALTER_SUCCESS = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_ALTER_SUCCESS
WT_STAT_CONN_SESSION_TABLE_ALTER_SKIP = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_ALTER_SKIP
WT_STAT_CONN_SESSION_TABLE_COMPACT_FAIL = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_COMPACT_FAIL
WT_STAT_CONN_SESSION_TABLE_COMPACT_SUCCESS = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_COMPACT_SUCCESS
WT_STAT_CONN_SESSION_TABLE_CREATE_FAIL = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_CREATE_FAIL
WT_STAT_CONN_SESSION_TABLE_CREATE_SUCCESS = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_CREATE_SUCCESS
WT_STAT_CONN_SESSION_TABLE_DROP_FAIL = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_DROP_FAIL
WT_STAT_CONN_SESSION_TABLE_DROP_SUCCESS = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_DROP_SUCCESS
WT_STAT_CONN_SESSION_TABLE_REBALANCE_FAIL = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_REBALANCE_FAIL
WT_STAT_CONN_SESSION_TABLE_REBALANCE_SUCCESS = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_REBALANCE_SUCCESS
WT_STAT_CONN_SESSION_TABLE_RENAME_FAIL = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_RENAME_FAIL
WT_STAT_CONN_SESSION_TABLE_RENAME_SUCCESS = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_RENAME_SUCCESS
WT_STAT_CONN_SESSION_TABLE_SALVAGE_FAIL = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_SALVAGE_FAIL
WT_STAT_CONN_SESSION_TABLE_SALVAGE_SUCCESS = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_SALVAGE_SUCCESS
WT_STAT_CONN_SESSION_TABLE_TRUNCATE_FAIL = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_TRUNCATE_FAIL
WT_STAT_CONN_SESSION_TABLE_TRUNCATE_SUCCESS = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_TRUNCATE_SUCCESS
WT_STAT_CONN_SESSION_TABLE_VERIFY_FAIL = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_VERIFY_FAIL
WT_STAT_CONN_SESSION_TABLE_VERIFY_SUCCESS = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_VERIFY_SUCCESS
WT_STAT_CONN_THREAD_FSYNC_ACTIVE = _wiredtiger.WT_STAT_CONN_THREAD_FSYNC_ACTIVE
WT_STAT_CONN_THREAD_READ_ACTIVE = _wiredtiger.WT_STAT_CONN_THREAD_READ_ACTIVE
WT_STAT_CONN_THREAD_WRITE_ACTIVE = _wiredtiger.WT_STAT_CONN_THREAD_WRITE_ACTIVE
WT_STAT_CONN_APPLICATION_EVICT_TIME = _wiredtiger.WT_STAT_CONN_APPLICATION_EVICT_TIME
WT_STAT_CONN_APPLICATION_CACHE_TIME = _wiredtiger.WT_STAT_CONN_APPLICATION_CACHE_TIME
WT_STAT_CONN_TXN_RELEASE_BLOCKED = _wiredtiger.WT_STAT_CONN_TXN_RELEASE_BLOCKED
WT_STAT_CONN_CONN_CLOSE_BLOCKED_LSM = _wiredtiger.WT_STAT_CONN_CONN_CLOSE_BLOCKED_LSM
WT_STAT_CONN_DHANDLE_LOCK_BLOCKED = _wiredtiger.WT_STAT_CONN_DHANDLE_LOCK_BLOCKED
WT_STAT_CONN_PAGE_INDEX_SLOT_REF_BLOCKED = _wiredtiger.WT_STAT_CONN_PAGE_INDEX_SLOT_REF_BLOCKED
WT_STAT_CONN_LOG_SERVER_SYNC_BLOCKED = _wiredtiger.WT_STAT_CONN_LOG_SERVER_SYNC_BLOCKED
WT_STAT_CONN_PREPARED_TRANSITION_BLOCKED_PAGE = _wiredtiger.WT_STAT_CONN_PREPARED_TRANSITION_BLOCKED_PAGE
WT_STAT_CONN_PAGE_BUSY_BLOCKED = _wiredtiger.WT_STAT_CONN_PAGE_BUSY_BLOCKED
WT_STAT_CONN_PAGE_FORCIBLE_EVICT_BLOCKED = _wiredtiger.WT_STAT_CONN_PAGE_FORCIBLE_EVICT_BLOCKED
WT_STAT_CONN_PAGE_LOCKED_BLOCKED = _wiredtiger.WT_STAT_CONN_PAGE_LOCKED_BLOCKED
WT_STAT_CONN_PAGE_READ_BLOCKED = _wiredtiger.WT_STAT_CONN_PAGE_READ_BLOCKED
WT_STAT_CONN_PAGE_SLEEP = _wiredtiger.WT_STAT_CONN_PAGE_SLEEP
WT_STAT_CONN_PAGE_DEL_ROLLBACK_BLOCKED = _wiredtiger.WT_STAT_CONN_PAGE_DEL_ROLLBACK_BLOCKED
WT_STAT_CONN_CHILD_MODIFY_BLOCKED_PAGE = _wiredtiger.WT_STAT_CONN_CHILD_MODIFY_BLOCKED_PAGE
WT_STAT_CONN_TXN_COMMIT_QUEUE_EMPTY = _wiredtiger.WT_STAT_CONN_TXN_COMMIT_QUEUE_EMPTY
WT_STAT_CONN_TXN_COMMIT_QUEUE_TAIL = _wiredtiger.WT_STAT_CONN_TXN_COMMIT_QUEUE_TAIL
WT_STAT_CONN_TXN_COMMIT_QUEUE_INSERTS = _wiredtiger.WT_STAT_CONN_TXN_COMMIT_QUEUE_INSERTS
WT_STAT_CONN_TXN_COMMIT_QUEUE_LEN = _wiredtiger.WT_STAT_CONN_TXN_COMMIT_QUEUE_LEN
WT_STAT_CONN_TXN_SNAPSHOTS_CREATED = _wiredtiger.WT_STAT_CONN_TXN_SNAPSHOTS_CREATED
WT_STAT_CONN_TXN_SNAPSHOTS_DROPPED = _wiredtiger.WT_STAT_CONN_TXN_SNAPSHOTS_DROPPED
WT_STAT_CONN_TXN_PREPARE = _wiredtiger.WT_STAT_CONN_TXN_PREPARE
WT_STAT_CONN_TXN_PREPARE_COMMIT = _wiredtiger.WT_STAT_CONN_TXN_PREPARE_COMMIT
WT_STAT_CONN_TXN_PREPARE_ACTIVE = _wiredtiger.WT_STAT_CONN_TXN_PREPARE_ACTIVE
WT_STAT_CONN_TXN_PREPARE_ROLLBACK = _wiredtiger.WT_STAT_CONN_TXN_PREPARE_ROLLBACK
WT_STAT_CONN_TXN_QUERY_TS = _wiredtiger.WT_STAT_CONN_TXN_QUERY_TS
WT_STAT_CONN_TXN_READ_QUEUE_EMPTY = _wiredtiger.WT_STAT_CONN_TXN_READ_QUEUE_EMPTY
WT_STAT_CONN_TXN_READ_QUEUE_HEAD = _wiredtiger.WT_STAT_CONN_TXN_READ_QUEUE_HEAD
WT_STAT_CONN_TXN_READ_QUEUE_INSERTS = _wiredtiger.WT_STAT_CONN_TXN_READ_QUEUE_INSERTS
WT_STAT_CONN_TXN_READ_QUEUE_LEN = _wiredtiger.WT_STAT_CONN_TXN_READ_QUEUE_LEN
WT_STAT_CONN_TXN_ROLLBACK_TO_STABLE = _wiredtiger.WT_STAT_CONN_TXN_ROLLBACK_TO_STABLE
WT_STAT_CONN_TXN_ROLLBACK_UPD_ABORTED = _wiredtiger.WT_STAT_CONN_TXN_ROLLBACK_UPD_ABORTED
WT_STAT_CONN_TXN_ROLLBACK_LAS_REMOVED = _wiredtiger.WT_STAT_CONN_TXN_ROLLBACK_LAS_REMOVED
WT_STAT_CONN_TXN_SET_TS = _wiredtiger.WT_STAT_CONN_TXN_SET_TS
WT_STAT_CONN_TXN_SET_TS_COMMIT = _wiredtiger.WT_STAT_CONN_TXN_SET_TS_COMMIT
WT_STAT_CONN_TXN_SET_TS_COMMIT_UPD = _wiredtiger.WT_STAT_CONN_TXN_SET_TS_COMMIT_UPD
WT_STAT_CONN_TXN_SET_TS_OLDEST = _wiredtiger.WT_STAT_CONN_TXN_SET_TS_OLDEST
WT_STAT_CONN_TXN_SET_TS_OLDEST_UPD = _wiredtiger.WT_STAT_CONN_TXN_SET_TS_OLDEST_UPD
WT_STAT_CONN_TXN_SET_TS_STABLE = _wiredtiger.WT_STAT_CONN_TXN_SET_TS_STABLE
WT_STAT_CONN_TXN_SET_TS_STABLE_UPD = _wiredtiger.WT_STAT_CONN_TXN_SET_TS_STABLE_UPD
WT_STAT_CONN_TXN_BEGIN = _wiredtiger.WT_STAT_CONN_TXN_BEGIN
WT_STAT_CONN_TXN_CHECKPOINT_RUNNING = _wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_RUNNING
WT_STAT_CONN_TXN_CHECKPOINT_GENERATION = _wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_GENERATION
WT_STAT_CONN_TXN_CHECKPOINT_TIME_MAX = _wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_TIME_MAX
WT_STAT_CONN_TXN_CHECKPOINT_TIME_MIN = _wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_TIME_MIN
WT_STAT_CONN_TXN_CHECKPOINT_TIME_RECENT = _wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_TIME_RECENT
WT_STAT_CONN_TXN_CHECKPOINT_SCRUB_TARGET = _wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_SCRUB_TARGET
WT_STAT_CONN_TXN_CHECKPOINT_SCRUB_TIME = _wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_SCRUB_TIME
WT_STAT_CONN_TXN_CHECKPOINT_TIME_TOTAL = _wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_TIME_TOTAL
WT_STAT_CONN_TXN_CHECKPOINT = _wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT
WT_STAT_CONN_TXN_CHECKPOINT_SKIPPED = _wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_SKIPPED
WT_STAT_CONN_TXN_FAIL_CACHE = _wiredtiger.WT_STAT_CONN_TXN_FAIL_CACHE
WT_STAT_CONN_TXN_CHECKPOINT_FSYNC_POST = _wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_FSYNC_POST
WT_STAT_CONN_TXN_CHECKPOINT_FSYNC_POST_DURATION = _wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_FSYNC_POST_DURATION
WT_STAT_CONN_TXN_PINNED_RANGE = _wiredtiger.WT_STAT_CONN_TXN_PINNED_RANGE
WT_STAT_CONN_TXN_PINNED_CHECKPOINT_RANGE = _wiredtiger.WT_STAT_CONN_TXN_PINNED_CHECKPOINT_RANGE
WT_STAT_CONN_TXN_PINNED_SNAPSHOT_RANGE = _wiredtiger.WT_STAT_CONN_TXN_PINNED_SNAPSHOT_RANGE
WT_STAT_CONN_TXN_PINNED_TIMESTAMP = _wiredtiger.WT_STAT_CONN_TXN_PINNED_TIMESTAMP
WT_STAT_CONN_TXN_PINNED_TIMESTAMP_OLDEST = _wiredtiger.WT_STAT_CONN_TXN_PINNED_TIMESTAMP_OLDEST
WT_STAT_CONN_TXN_SYNC = _wiredtiger.WT_STAT_CONN_TXN_SYNC
WT_STAT_CONN_TXN_COMMIT = _wiredtiger.WT_STAT_CONN_TXN_COMMIT
WT_STAT_CONN_TXN_ROLLBACK = _wiredtiger.WT_STAT_CONN_TXN_ROLLBACK
WT_STAT_CONN_TXN_UPDATE_CONFLICT = _wiredtiger.WT_STAT_CONN_TXN_UPDATE_CONFLICT
WT_STAT_DSRC_BLOOM_FALSE_POSITIVE = _wiredtiger.WT_STAT_DSRC_BLOOM_FALSE_POSITIVE
WT_STAT_DSRC_BLOOM_HIT = _wiredtiger.WT_STAT_DSRC_BLOOM_HIT
WT_STAT_DSRC_BLOOM_MISS = _wiredtiger.WT_STAT_DSRC_BLOOM_MISS
WT_STAT_DSRC_BLOOM_PAGE_EVICT = _wiredtiger.WT_STAT_DSRC_BLOOM_PAGE_EVICT
WT_STAT_DSRC_BLOOM_PAGE_READ = _wiredtiger.WT_STAT_DSRC_BLOOM_PAGE_READ
WT_STAT_DSRC_BLOOM_COUNT = _wiredtiger.WT_STAT_DSRC_BLOOM_COUNT
WT_STAT_DSRC_LSM_CHUNK_COUNT = _wiredtiger.WT_STAT_DSRC_LSM_CHUNK_COUNT
WT_STAT_DSRC_LSM_GENERATION_MAX = _wiredtiger.WT_STAT_DSRC_LSM_GENERATION_MAX
WT_STAT_DSRC_LSM_LOOKUP_NO_BLOOM = _wiredtiger.WT_STAT_DSRC_LSM_LOOKUP_NO_BLOOM
WT_STAT_DSRC_LSM_CHECKPOINT_THROTTLE = _wiredtiger.WT_STAT_DSRC_LSM_CHECKPOINT_THROTTLE
WT_STAT_DSRC_LSM_MERGE_THROTTLE = _wiredtiger.WT_STAT_DSRC_LSM_MERGE_THROTTLE
WT_STAT_DSRC_BLOOM_SIZE = _wiredtiger.WT_STAT_DSRC_BLOOM_SIZE
WT_STAT_DSRC_BLOCK_EXTENSION = _wiredtiger.WT_STAT_DSRC_BLOCK_EXTENSION
WT_STAT_DSRC_BLOCK_ALLOC = _wiredtiger.WT_STAT_DSRC_BLOCK_ALLOC
WT_STAT_DSRC_BLOCK_FREE = _wiredtiger.WT_STAT_DSRC_BLOCK_FREE
WT_STAT_DSRC_BLOCK_CHECKPOINT_SIZE = _wiredtiger.WT_STAT_DSRC_BLOCK_CHECKPOINT_SIZE
WT_STAT_DSRC_ALLOCATION_SIZE = _wiredtiger.WT_STAT_DSRC_ALLOCATION_SIZE
WT_STAT_DSRC_BLOCK_REUSE_BYTES = _wiredtiger.WT_STAT_DSRC_BLOCK_REUSE_BYTES
WT_STAT_DSRC_BLOCK_MAGIC = _wiredtiger.WT_STAT_DSRC_BLOCK_MAGIC
WT_STAT_DSRC_BLOCK_MAJOR = _wiredtiger.WT_STAT_DSRC_BLOCK_MAJOR
WT_STAT_DSRC_BLOCK_SIZE = _wiredtiger.WT_STAT_DSRC_BLOCK_SIZE
WT_STAT_DSRC_BLOCK_MINOR = _wiredtiger.WT_STAT_DSRC_BLOCK_MINOR
WT_STAT_DSRC_BTREE_CHECKPOINT_GENERATION = _wiredtiger.WT_STAT_DSRC_BTREE_CHECKPOINT_GENERATION
WT_STAT_DSRC_BTREE_COLUMN_FIX = _wiredtiger.WT_STAT_DSRC_BTREE_COLUMN_FIX
WT_STAT_DSRC_BTREE_COLUMN_INTERNAL = _wiredtiger.WT_STAT_DSRC_BTREE_COLUMN_INTERNAL
WT_STAT_DSRC_BTREE_COLUMN_RLE = _wiredtiger.WT_STAT_DSRC_BTREE_COLUMN_RLE
WT_STAT_DSRC_BTREE_COLUMN_DELETED = _wiredtiger.WT_STAT_DSRC_BTREE_COLUMN_DELETED
WT_STAT_DSRC_BTREE_COLUMN_VARIABLE = _wiredtiger.WT_STAT_DSRC_BTREE_COLUMN_VARIABLE
WT_STAT_DSRC_BTREE_FIXED_LEN = _wiredtiger.WT_STAT_DSRC_BTREE_FIXED_LEN
WT_STAT_DSRC_BTREE_MAXINTLKEY = _wiredtiger.WT_STAT_DSRC_BTREE_MAXINTLKEY
WT_STAT_DSRC_BTREE_MAXINTLPAGE = _wiredtiger.WT_STAT_DSRC_BTREE_MAXINTLPAGE
WT_STAT_DSRC_BTREE_MAXLEAFKEY = _wiredtiger.WT_STAT_DSRC_BTREE_MAXLEAFKEY
WT_STAT_DSRC_BTREE_MAXLEAFPAGE = _wiredtiger.WT_STAT_DSRC_BTREE_MAXLEAFPAGE
WT_STAT_DSRC_BTREE_MAXLEAFVALUE = _wiredtiger.WT_STAT_DSRC_BTREE_MAXLEAFVALUE
WT_STAT_DSRC_BTREE_MAXIMUM_DEPTH = _wiredtiger.WT_STAT_DSRC_BTREE_MAXIMUM_DEPTH
WT_STAT_DSRC_BTREE_ENTRIES = _wiredtiger.WT_STAT_DSRC_BTREE_ENTRIES
WT_STAT_DSRC_BTREE_OVERFLOW = _wiredtiger.WT_STAT_DSRC_BTREE_OVERFLOW
WT_STAT_DSRC_BTREE_COMPACT_REWRITE = _wiredtiger.WT_STAT_DSRC_BTREE_COMPACT_REWRITE
WT_STAT_DSRC_BTREE_ROW_INTERNAL = _wiredtiger.WT_STAT_DSRC_BTREE_ROW_INTERNAL
WT_STAT_DSRC_BTREE_ROW_LEAF = _wiredtiger.WT_STAT_DSRC_BTREE_ROW_LEAF
WT_STAT_DSRC_CACHE_BYTES_INUSE = _wiredtiger.WT_STAT_DSRC_CACHE_BYTES_INUSE
WT_STAT_DSRC_CACHE_BYTES_READ = _wiredtiger.WT_STAT_DSRC_CACHE_BYTES_READ
WT_STAT_DSRC_CACHE_BYTES_WRITE = _wiredtiger.WT_STAT_DSRC_CACHE_BYTES_WRITE
WT_STAT_DSRC_CACHE_EVICTION_CHECKPOINT = _wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_CHECKPOINT
WT_STAT_DSRC_CACHE_EVICTION_FAIL = _wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_FAIL
WT_STAT_DSRC_CACHE_EVICTION_WALK_PASSES = _wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_WALK_PASSES
WT_STAT_DSRC_CACHE_EVICTION_TARGET_PAGE_LT10 = _wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_TARGET_PAGE_LT10
WT_STAT_DSRC_CACHE_EVICTION_TARGET_PAGE_LT32 = _wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_TARGET_PAGE_LT32
WT_STAT_DSRC_CACHE_EVICTION_TARGET_PAGE_GE128 = _wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_TARGET_PAGE_GE128
WT_STAT_DSRC_CACHE_EVICTION_TARGET_PAGE_LT64 = _wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_TARGET_PAGE_LT64
WT_STAT_DSRC_CACHE_EVICTION_TARGET_PAGE_LT128 = _wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_TARGET_PAGE_LT128
WT_STAT_DSRC_CACHE_EVICTION_WALKS_ABANDONED = _wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_WALKS_ABANDONED
WT_STAT_DSRC_CACHE_EVICTION_WALKS_STOPPED = _wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_WALKS_STOPPED
WT_STAT_DSRC_CACHE_EVICTION_WALKS_GAVE_UP_NO_TARGETS = _wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_WALKS_GAVE_UP_NO_TARGETS
WT_STAT_DSRC_CACHE_EVICTION_WALKS_GAVE_UP_RATIO = _wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_WALKS_GAVE_UP_RATIO
WT_STAT_DSRC_CACHE_EVICTION_WALKS_ENDED = _wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_WALKS_ENDED
WT_STAT_DSRC_CACHE_EVICTION_WALK_FROM_ROOT = _wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_WALK_FROM_ROOT
WT_STAT_DSRC_CACHE_EVICTION_WALK_SAVED_POS = _wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_WALK_SAVED_POS
WT_STAT_DSRC_CACHE_EVICTION_HAZARD = _wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_HAZARD
WT_STAT_DSRC_CACHE_INMEM_SPLITTABLE = _wiredtiger.WT_STAT_DSRC_CACHE_INMEM_SPLITTABLE
WT_STAT_DSRC_CACHE_INMEM_SPLIT = _wiredtiger.WT_STAT_DSRC_CACHE_INMEM_SPLIT
WT_STAT_DSRC_CACHE_EVICTION_INTERNAL = _wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_INTERNAL
WT_STAT_DSRC_CACHE_EVICTION_SPLIT_INTERNAL = _wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_SPLIT_INTERNAL
WT_STAT_DSRC_CACHE_EVICTION_SPLIT_LEAF = _wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_SPLIT_LEAF
WT_STAT_DSRC_CACHE_EVICTION_DIRTY = _wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_DIRTY
WT_STAT_DSRC_CACHE_READ_OVERFLOW = _wiredtiger.WT_STAT_DSRC_CACHE_READ_OVERFLOW
WT_STAT_DSRC_CACHE_EVICTION_DEEPEN = _wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_DEEPEN
WT_STAT_DSRC_CACHE_WRITE_LOOKASIDE = _wiredtiger.WT_STAT_DSRC_CACHE_WRITE_LOOKASIDE
WT_STAT_DSRC_CACHE_READ = _wiredtiger.WT_STAT_DSRC_CACHE_READ
WT_STAT_DSRC_CACHE_READ_DELETED = _wiredtiger.WT_STAT_DSRC_CACHE_READ_DELETED
WT_STAT_DSRC_CACHE_READ_DELETED_PREPARED = _wiredtiger.WT_STAT_DSRC_CACHE_READ_DELETED_PREPARED
WT_STAT_DSRC_CACHE_READ_LOOKASIDE = _wiredtiger.WT_STAT_DSRC_CACHE_READ_LOOKASIDE
WT_STAT_DSRC_CACHE_PAGES_REQUESTED = _wiredtiger.WT_STAT_DSRC_CACHE_PAGES_REQUESTED
WT_STAT_DSRC_CACHE_EVICTION_PAGES_SEEN = _wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_PAGES_SEEN
WT_STAT_DSRC_CACHE_WRITE = _wiredtiger.WT_STAT_DSRC_CACHE_WRITE
WT_STAT_DSRC_CACHE_WRITE_RESTORE = _wiredtiger.WT_STAT_DSRC_CACHE_WRITE_RESTORE
WT_STAT_DSRC_CACHE_BYTES_DIRTY = _wiredtiger.WT_STAT_DSRC_CACHE_BYTES_DIRTY
WT_STAT_DSRC_CACHE_EVICTION_CLEAN = _wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_CLEAN
WT_STAT_DSRC_CACHE_STATE_GEN_AVG_GAP = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_GEN_AVG_GAP
WT_STAT_DSRC_CACHE_STATE_AVG_WRITTEN_SIZE = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_AVG_WRITTEN_SIZE
WT_STAT_DSRC_CACHE_STATE_AVG_VISITED_AGE = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_AVG_VISITED_AGE
WT_STAT_DSRC_CACHE_STATE_AVG_UNVISITED_AGE = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_AVG_UNVISITED_AGE
WT_STAT_DSRC_CACHE_STATE_PAGES_CLEAN = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_PAGES_CLEAN
WT_STAT_DSRC_CACHE_STATE_GEN_CURRENT = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_GEN_CURRENT
WT_STAT_DSRC_CACHE_STATE_PAGES_DIRTY = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_PAGES_DIRTY
WT_STAT_DSRC_CACHE_STATE_ROOT_ENTRIES = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_ROOT_ENTRIES
WT_STAT_DSRC_CACHE_STATE_PAGES_INTERNAL = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_PAGES_INTERNAL
WT_STAT_DSRC_CACHE_STATE_PAGES_LEAF = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_PAGES_LEAF
WT_STAT_DSRC_CACHE_STATE_GEN_MAX_GAP = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_GEN_MAX_GAP
WT_STAT_DSRC_CACHE_STATE_MAX_PAGESIZE = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_MAX_PAGESIZE
WT_STAT_DSRC_CACHE_STATE_MIN_WRITTEN_SIZE = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_MIN_WRITTEN_SIZE
WT_STAT_DSRC_CACHE_STATE_UNVISITED_COUNT = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_UNVISITED_COUNT
WT_STAT_DSRC_CACHE_STATE_SMALLER_ALLOC_SIZE = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_SMALLER_ALLOC_SIZE
WT_STAT_DSRC_CACHE_STATE_MEMORY = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_MEMORY
WT_STAT_DSRC_CACHE_STATE_QUEUED = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_QUEUED
WT_STAT_DSRC_CACHE_STATE_NOT_QUEUEABLE = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_NOT_QUEUEABLE
WT_STAT_DSRC_CACHE_STATE_REFS_SKIPPED = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_REFS_SKIPPED
WT_STAT_DSRC_CACHE_STATE_ROOT_SIZE = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_ROOT_SIZE
WT_STAT_DSRC_CACHE_STATE_PAGES = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_PAGES
WT_STAT_DSRC_COMPRESS_READ = _wiredtiger.WT_STAT_DSRC_COMPRESS_READ
WT_STAT_DSRC_COMPRESS_WRITE = _wiredtiger.WT_STAT_DSRC_COMPRESS_WRITE
WT_STAT_DSRC_COMPRESS_WRITE_FAIL = _wiredtiger.WT_STAT_DSRC_COMPRESS_WRITE_FAIL
WT_STAT_DSRC_COMPRESS_WRITE_TOO_SMALL = _wiredtiger.WT_STAT_DSRC_COMPRESS_WRITE_TOO_SMALL
WT_STAT_DSRC_COMPRESS_RAW_FAIL_TEMPORARY = _wiredtiger.WT_STAT_DSRC_COMPRESS_RAW_FAIL_TEMPORARY
WT_STAT_DSRC_COMPRESS_RAW_FAIL = _wiredtiger.WT_STAT_DSRC_COMPRESS_RAW_FAIL
WT_STAT_DSRC_COMPRESS_RAW_OK = _wiredtiger.WT_STAT_DSRC_COMPRESS_RAW_OK
WT_STAT_DSRC_CURSOR_INSERT_BULK = _wiredtiger.WT_STAT_DSRC_CURSOR_INSERT_BULK
WT_STAT_DSRC_CURSOR_CREATE = _wiredtiger.WT_STAT_DSRC_CURSOR_CREATE
WT_STAT_DSRC_CURSOR_INSERT_BYTES = _wiredtiger.WT_STAT_DSRC_CURSOR_INSERT_BYTES
WT_STAT_DSRC_CURSOR_REMOVE_BYTES = _wiredtiger.WT_STAT_DSRC_CURSOR_REMOVE_BYTES
WT_STAT_DSRC_CURSOR_UPDATE_BYTES = _wiredtiger.WT_STAT_DSRC_CURSOR_UPDATE_BYTES
WT_STAT_DSRC_CURSOR_CACHE = _wiredtiger.WT_STAT_DSRC_CURSOR_CACHE
WT_STAT_DSRC_CURSOR_REOPEN = _wiredtiger.WT_STAT_DSRC_CURSOR_REOPEN
WT_STAT_DSRC_CURSOR_INSERT = _wiredtiger.WT_STAT_DSRC_CURSOR_INSERT
WT_STAT_DSRC_CURSOR_MODIFY = _wiredtiger.WT_STAT_DSRC_CURSOR_MODIFY
WT_STAT_DSRC_CURSOR_NEXT = _wiredtiger.WT_STAT_DSRC_CURSOR_NEXT
WT_STAT_DSRC_CURSOR_PREV = _wiredtiger.WT_STAT_DSRC_CURSOR_PREV
WT_STAT_DSRC_CURSOR_REMOVE = _wiredtiger.WT_STAT_DSRC_CURSOR_REMOVE
WT_STAT_DSRC_CURSOR_RESERVE = _wiredtiger.WT_STAT_DSRC_CURSOR_RESERVE
WT_STAT_DSRC_CURSOR_RESET = _wiredtiger.WT_STAT_DSRC_CURSOR_RESET
WT_STAT_DSRC_CURSOR_RESTART = _wiredtiger.WT_STAT_DSRC_CURSOR_RESTART
WT_STAT_DSRC_CURSOR_SEARCH = _wiredtiger.WT_STAT_DSRC_CURSOR_SEARCH
WT_STAT_DSRC_CURSOR_SEARCH_NEAR = _wiredtiger.WT_STAT_DSRC_CURSOR_SEARCH_NEAR
WT_STAT_DSRC_CURSOR_TRUNCATE = _wiredtiger.WT_STAT_DSRC_CURSOR_TRUNCATE
WT_STAT_DSRC_CURSOR_UPDATE = _wiredtiger.WT_STAT_DSRC_CURSOR_UPDATE
WT_STAT_DSRC_REC_DICTIONARY = _wiredtiger.WT_STAT_DSRC_REC_DICTIONARY
WT_STAT_DSRC_REC_PAGE_DELETE_FAST = _wiredtiger.WT_STAT_DSRC_REC_PAGE_DELETE_FAST
WT_STAT_DSRC_REC_SUFFIX_COMPRESSION = _wiredtiger.WT_STAT_DSRC_REC_SUFFIX_COMPRESSION
WT_STAT_DSRC_REC_MULTIBLOCK_INTERNAL = _wiredtiger.WT_STAT_DSRC_REC_MULTIBLOCK_INTERNAL
WT_STAT_DSRC_REC_OVERFLOW_KEY_INTERNAL = _wiredtiger.WT_STAT_DSRC_REC_OVERFLOW_KEY_INTERNAL
WT_STAT_DSRC_REC_PREFIX_COMPRESSION = _wiredtiger.WT_STAT_DSRC_REC_PREFIX_COMPRESSION
WT_STAT_DSRC_REC_MULTIBLOCK_LEAF = _wiredtiger.WT_STAT_DSRC_REC_MULTIBLOCK_LEAF
WT_STAT_DSRC_REC_OVERFLOW_KEY_LEAF = _wiredtiger.WT_STAT_DSRC_REC_OVERFLOW_KEY_LEAF
WT_STAT_DSRC_REC_MULTIBLOCK_MAX = _wiredtiger.WT_STAT_DSRC_REC_MULTIBLOCK_MAX
WT_STAT_DSRC_REC_OVERFLOW_VALUE = _wiredtiger.WT_STAT_DSRC_REC_OVERFLOW_VALUE
WT_STAT_DSRC_REC_PAGE_MATCH = _wiredtiger.WT_STAT_DSRC_REC_PAGE_MATCH
WT_STAT_DSRC_REC_PAGES = _wiredtiger.WT_STAT_DSRC_REC_PAGES
WT_STAT_DSRC_REC_PAGES_EVICTION = _wiredtiger.WT_STAT_DSRC_REC_PAGES_EVICTION
WT_STAT_DSRC_REC_PAGE_DELETE = _wiredtiger.WT_STAT_DSRC_REC_PAGE_DELETE
WT_STAT_DSRC_SESSION_CURSOR_CACHED = _wiredtiger.WT_STAT_DSRC_SESSION_CURSOR_CACHED
WT_STAT_DSRC_SESSION_COMPACT = _wiredtiger.WT_STAT_DSRC_SESSION_COMPACT
WT_STAT_DSRC_SESSION_CURSOR_OPEN = _wiredtiger.WT_STAT_DSRC_SESSION_CURSOR_OPEN
WT_STAT_DSRC_TXN_UPDATE_CONFLICT = _wiredtiger.WT_STAT_DSRC_TXN_UPDATE_CONFLICT
WT_STAT_JOIN_MAIN_ACCESS = _wiredtiger.WT_STAT_JOIN_MAIN_ACCESS
WT_STAT_JOIN_BLOOM_FALSE_POSITIVE = _wiredtiger.WT_STAT_JOIN_BLOOM_FALSE_POSITIVE
WT_STAT_JOIN_MEMBERSHIP_CHECK = _wiredtiger.WT_STAT_JOIN_MEMBERSHIP_CHECK
WT_STAT_JOIN_BLOOM_INSERT = _wiredtiger.WT_STAT_JOIN_BLOOM_INSERT
WT_STAT_JOIN_ITERATED = _wiredtiger.WT_STAT_JOIN_ITERATED

class stat:
	'''keys for statistics cursors'''

	class conn:
		'''keys for cursors on connection statistics'''
		pass

	class dsrc:
		'''keys for cursors on data source statistics'''
		pass

## @}

import sys
# All names starting with 'WT_STAT_DSRC_' are renamed to
# the wiredtiger.stat.dsrc class, those starting with 'WT_STAT_CONN' are
# renamed to wiredtiger.stat.conn class.
def _rename_with_prefix(prefix, toclass):
	curmodule = sys.modules[__name__]
	for name in dir(curmodule):
		if name.startswith(prefix):
			shortname = name[len(prefix):].lower()
			setattr(toclass, shortname, getattr(curmodule, name))
			delattr(curmodule, name)

_rename_with_prefix('WT_STAT_CONN_', stat.conn)
_rename_with_prefix('WT_STAT_DSRC_', stat.dsrc)
del _rename_with_prefix



