//: version "2.0-b9"
//: property encoding = "iso8859-1"
//: property locale = "en"
//: property prefix = "_GG"
//: property title = "74xx.v"
//: property showSwitchNets = 0
//: property timingViolationMode = 2
//: property initTime = "0 ns"

`timescale 1ns/1ns

//: /netlistBegin main
module main;    //: root_module
reg w45;    //: /sn:0 {0}(822,167)(761,167)(761,135)(647,135){1}
reg w14;    //: /sn:0 {0}(634,658)(658,658)(658,644)(718,644){1}
reg w89;    //: /sn:0 {0}(637,1049)(705,1049)(705,964)(735,964){1}
reg w4;    //: /sn:0 {0}(773,705)(773,768)(721,768){1}
reg w38;    //: /sn:0 {0}(309,445)(252,445){1}
//: {2}(250,443)(250,270){3}
//: {4}(252,268)(310,268){5}
//: {6}(250,266)(250,84){7}
//: {8}(252,82)(310,82){9}
//: {10}(248,82)(83,82)(83,134)(53,134){11}
//: {12}(250,447)(250,590){13}
//: {14}(252,592)(312,592){15}
//: {16}(250,594)(250,757){17}
//: {18}(252,759)(314,759){19}
//: {20}(250,761)(250,940){21}
//: {22}(252,942)(315,942){23}
//: {24}(250,944)(250,1114){25}
//: {26}(252,1116)(319,1116){27}
//: {28}(250,1118)(250,1297)(316,1297){29}
reg w0;    //: /sn:0 {0}(310,114)(223,114){1}
//: {2}(219,114)(107,114)(107,242)(53,242){3}
//: {4}(221,116)(221,298){5}
//: {6}(223,300)(310,300){7}
//: {8}(221,302)(221,622){9}
//: {10}(223,624)(312,624){11}
//: {12}(221,626)(221,773){13}
//: {14}(223,775)(314,775){15}
//: {16}(221,777)(221,972){17}
//: {18}(223,974)(315,974){19}
//: {20}(221,976)(221,1146){21}
//: {22}(223,1148)(319,1148){23}
//: {24}(221,1150)(221,1329)(316,1329){25}
reg w3;    //: /sn:0 {0}(310,348)(179,348){1}
//: {2}(177,346)(177,164){3}
//: {4}(179,162)(310,162){5}
//: {6}(175,162)(153,162)(153,404)(53,404){7}
//: {8}(177,350)(177,670){9}
//: {10}(179,672)(312,672){11}
//: {12}(177,674)(177,1020){13}
//: {14}(179,1022)(315,1022){15}
//: {16}(177,1024)(177,1194){17}
//: {18}(179,1196)(319,1196){19}
//: {20}(177,1198)(177,1377)(316,1377){21}
reg w120;    //: /sn:0 {0}(213,1771)(231,1771)(231,1732){1}
reg w111;    //: /sn:0 {0}(118,1570)(133,1570){1}
reg w36;    //: /sn:0 {0}(309,413)(282,413){1}
//: {2}(280,411)(280,238){3}
//: {4}(282,236)(310,236){5}
//: {6}(280,234)(280,52){7}
//: {8}(282,50)(310,50){9}
//: {10}(278,50)(165,50)(165,50)(53,50){11}
//: {12}(280,415)(280,558){13}
//: {14}(282,560)(312,560){15}
//: {16}(280,562)(280,725){17}
//: {18}(282,727)(314,727){19}
//: {20}(280,729)(280,908){21}
//: {22}(282,910)(315,910){23}
//: {24}(280,912)(280,1082){25}
//: {26}(282,1084)(319,1084){27}
//: {28}(280,1086)(280,1265)(316,1265){29}
reg w41;    //: /sn:0 {0}(53,477)(309,477){1}
reg w108;    //: /sn:0 {0}(619,1300)(635,1300)(635,1328)(693,1328){1}
reg w91;    //: /sn:0 {0}(729,1495)(755,1495)(755,1425){1}
reg w84;    //: /sn:0 {0}(637,867)(720,867)(720,884)(735,884){1}
reg w2;    //: /sn:0 {0}(310,332)(197,332){1}
//: {2}(195,330)(195,148){3}
//: {4}(197,146)(310,146){5}
//: {6}(193,146)(135,146)(135,353)(53,353){7}
//: {8}(195,334)(195,654){9}
//: {10}(197,656)(312,656){11}
//: {12}(195,658)(195,805){13}
//: {14}(197,807)(314,807){15}
//: {16}(195,809)(195,1004){17}
//: {18}(197,1006)(315,1006){19}
//: {20}(195,1008)(195,1178){21}
//: {22}(197,1180)(319,1180){23}
//: {24}(195,1182)(195,1361)(316,1361){25}
reg w12;    //: /sn:0 {0}(55,866)(88,866)(88,839)(314,839){1}
reg w44;    //: /sn:0 {0}(822,151)(790,151)(790,91)(648,91){1}
reg w86;    //: /sn:0 {0}(637,941)(664,941)(664,916)(735,916){1}
reg w50;    //: /sn:0 {0}(648,368)(727,368)(727,247)(822,247){1}
reg w6;    //: /sn:0 {0}(635,690)(673,690)(673,660)(718,660){1}
reg w7;    //: /sn:0 {0}(314,823)(56,823){1}
reg w93;    //: /sn:0 {0}(693,1360)(650,1360)(650,1399)(610,1399){1}
reg w61;    //: /sn:0 {0}(316,1393)(145,1393){1}
reg w46;    //: /sn:0 {0}(822,183)(648,183){1}
reg w99;    //: /sn:0 {0}(693,1392)(677,1392)(677,1466)(610,1466){1}
reg w15;    //: /sn:0 {0}(634,604)(665,604)(665,628)(718,628){1}
reg w106;    //: /sn:0 {0}(693,1296)(653,1296)(653,1241)(619,1241){1}
reg w37;    //: /sn:0 {0}(309,429)(268,429){1}
//: {2}(266,427)(266,254){3}
//: {4}(268,252)(310,252){5}
//: {6}(266,250)(266,68){7}
//: {8}(268,66)(310,66){9}
//: {10}(264,66)(72,66)(72,91)(53,91){11}
//: {12}(266,431)(266,574){13}
//: {14}(268,576)(312,576){15}
//: {16}(266,578)(266,741){17}
//: {18}(268,743)(314,743){19}
//: {20}(266,745)(266,924){21}
//: {22}(268,926)(315,926){23}
//: {24}(266,928)(266,1098){25}
//: {26}(268,1100)(319,1100){27}
//: {28}(266,1102)(266,1281)(316,1281){29}
reg w87;    //: /sn:0 {0}(637,977)(674,977)(674,932)(735,932){1}
reg w43;    //: /sn:0 {0}(649,44)(807,44)(807,135)(822,135){1}
reg w58;    //: /sn:0 {0}(635,543)(700,543)(700,596)(718,596){1}
reg w24;    //: /sn:0 {0}(634,574)(681,574)(681,612)(718,612){1}
reg w1;    //: /sn:0 {0}(310,130)(211,130){1}
//: {2}(207,130)(120,130)(120,301)(53,301){3}
//: {4}(209,132)(209,314){5}
//: {6}(211,316)(310,316){7}
//: {8}(209,318)(209,638){9}
//: {10}(211,640)(312,640){11}
//: {12}(209,642)(209,789){13}
//: {14}(211,791)(314,791){15}
//: {16}(209,793)(209,988){17}
//: {18}(211,990)(315,990){19}
//: {20}(209,992)(209,1162){21}
//: {22}(211,1164)(319,1164){23}
//: {24}(209,1166)(209,1345)(316,1345){25}
reg w121;    //: /sn:0 {0}(115,1604)(130,1604){1}
reg w40;    //: /sn:0 {0}(53,524)(63,524)(63,493)(309,493){1}
reg w92;    //: /sn:0 {0}(693,1344)(625,1344)(625,1366)(610,1366){1}
reg w59;    //: /sn:0 {0}(145,1425)(301,1425)(301,1409)(316,1409){1}
reg w85;    //: /sn:0 {0}(735,900)(652,900)(652,905)(637,905){1}
reg w49;    //: /sn:0 {0}(648,322)(698,322)(698,231)(822,231){1}
reg w105;    //: /sn:0 {0}(693,1280)(674,1280)(674,1212)(619,1212){1}
reg w88;    //: /sn:0 {0}(637,1013)(687,1013)(687,948)(735,948){1}
reg w13;    //: /sn:0 {0}(55,918)(106,918)(106,855)(314,855){1}
reg w94;    //: /sn:0 {0}(693,1376)(663,1376)(663,1431)(610,1431){1}
reg w5;    //: /sn:0 {0}(636,723)(703,723)(703,676)(718,676){1}
reg w48;    //: /sn:0 {0}(648,275)(683,275)(683,215)(822,215){1}
reg w47;    //: /sn:0 {0}(822,199)(667,199)(667,231)(648,231){1}
reg w107;    //: /sn:0 {0}(693,1312)(642,1312)(642,1271)(620,1271){1}
reg w39;    //: /sn:0 {0}(309,461)(236,461){1}
//: {2}(234,459)(234,286){3}
//: {4}(236,284)(310,284){5}
//: {6}(234,282)(234,100){7}
//: {8}(236,98)(310,98){9}
//: {10}(232,98)(95,98)(95,187)(53,187){11}
//: {12}(234,463)(234,606){13}
//: {14}(236,608)(312,608){15}
//: {16}(234,610)(234,956){17}
//: {18}(236,958)(315,958){19}
//: {20}(234,960)(234,1130){21}
//: {22}(236,1132)(319,1132){23}
//: {24}(234,1134)(234,1313)(316,1313){25}
wire w32;    //: /sn:0 {0}(462,399)(462,445)(385,445){1}
wire w96;    //: /sn:0 {0}(456,1249)(456,1297)(399,1297){1}
wire w73;    //: /sn:0 {0}(954,1029)(873,1029)(873,1044)(842,1044){1}
wire w56;    //: /sn:0 {0}(830,612)(871,612)(871,579){1}
wire w16;    //: /sn:0 {0}(485,541)(485,608)(388,608){1}
wire w81;    //: /sn:0 {0}(954,949)(923,949)(923,916)(842,916){1}
wire w19;    //: /sn:0 {0}(388,560)(410,560)(410,541){1}
wire w104;    //: /sn:0 {0}(864,1263)(864,1280)(812,1280){1}
wire w75;    //: /sn:0 {0}(954,1009)(864,1009)(864,1012)(842,1012){1}
wire w67;    //: /sn:0 {0}(395,1116)(455,1116)(455,1068){1}
wire w54;    //: /sn:0 {0}(391,910)(414,910)(414,894){1}
wire w119;    //: /sn:0 {0}(285,1603)(316,1603)(316,1591){1}
wire w90;    //: /sn:0 {0}(163,1635)(178,1635){1}
wire w20;    //: /sn:0 {0}(407,223)(407,236)(386,236){1}
wire w23;    //: /sn:0 {0}(486,223)(486,284)(386,284){1}
wire w82;    //: /sn:0 {0}(954,939)(932,939)(932,900)(842,900){1}
wire w74;    //: /sn:0 {0}(842,1028)(860,1028)(860,1019)(954,1019){1}
wire w8;    //: /sn:0 {0}(386,50)(409,50)(409,36){1}
wire w35;    //: /sn:0 {0}(385,493)(537,493)(537,400){1}
wire w103;    //: /sn:0 {0}(886,1263)(886,1296)(812,1296){1}
wire w71;    //: /sn:0 {0}(954,1049)(898,1049)(898,1076)(842,1076){1}
wire w101;    //: /sn:0 {0}(923,1263)(923,1328)(812,1328){1}
wire w22;    //: /sn:0 {0}(459,223)(459,268)(386,268){1}
wire w17;    //: /sn:0 {0}(458,541)(458,592)(388,592){1}
wire w53;    //: /sn:0 {0}(391,926)(436,926)(436,894){1}
wire w117;    //: /sn:0 {0}(285,1635)(362,1635)(362,1591){1}
wire w113;    //: /sn:0 {0}(285,1699)(454,1699)(454,1591){1}
wire w83;    //: /sn:0 {0}(954,929)(941,929)(941,884)(842,884){1}
wire w77;    //: /sn:0 {0}(954,989)(881,989)(881,980)(842,980){1}
wire w115;    //: /sn:0 {0}(285,1667)(408,1667)(408,1591){1}
wire w78;    //: /sn:0 {0}(954,979)(891,979)(891,964)(842,964){1}
wire w10;    //: /sn:0 {0}(461,36)(461,82)(386,82){1}
wire w27;    //: /sn:0 {0}(390,727)(412,727)(412,706){1}
wire w95;    //: /sn:0 {0}(478,1249)(478,1313)(399,1313){1}
wire w52;    //: /sn:0 {0}(459,895)(459,942)(391,942){1}
wire w80;    //: /sn:0 {0}(954,959)(912,959)(912,932)(842,932){1}
wire w29;    //: /sn:0 {0}(913,580)(913,644)(830,644){1}
wire w42;    //: /sn:0 {0}(886,135)(909,135)(909,118){1}
wire [15:0] w60;    //: /sn:0 {0}(989,1004)(#:960,1004){1}
wire w112;    //: /sn:0 {0}(285,1715)(477,1715)(477,1591){1}
wire w69;    //: /sn:0 {0}(395,1084)(414,1084)(414,1068){1}
wire w51;    //: /sn:0 {0}(481,895)(481,958)(391,958){1}
wire w109;    //: /sn:0 {0}(163,1619)(178,1619){1}
wire w97;    //: /sn:0 {0}(433,1249)(433,1281)(399,1281){1}
wire w114;    //: /sn:0 {0}(285,1683)(431,1683)(431,1591){1}
wire w64;    //: /sn:0 {0}(954,1079)(940,1079)(940,1124)(842,1124){1}
wire w66;    //: /sn:0 {0}(395,1132)(477,1132)(477,1068){1}
wire w34;    //: /sn:0 {0}(513,400)(513,477)(385,477){1}
wire w63;    //: /sn:0 {0}(163,1651)(178,1651){1}
wire w76;    //: /sn:0 {0}(954,999)(864,999)(864,996)(842,996){1}
wire w21;    //: /sn:0 {0}(386,252)(434,252)(434,223){1}
wire w102;    //: /sn:0 {0}(905,1263)(905,1312)(812,1312){1}
wire w31;    //: /sn:0 {0}(437,399)(437,429)(385,429){1}
wire w100;    //: /sn:0 {0}(812,1344)(947,1344)(947,1263){1}
wire w28;    //: /sn:0 {0}(163,1683)(178,1683){1}
wire w25;    //: /sn:0 {0}(390,759)(464,759)(464,706){1}
wire w98;    //: /sn:0 {0}(415,1249)(415,1265)(399,1265){1}
wire w65;    //: /sn:0 {0}(954,1069)(925,1069)(925,1108)(842,1108){1}
wire w116;    //: /sn:0 {0}(285,1651)(385,1651)(385,1591){1}
wire w18;    //: /sn:0 {0}(434,541)(434,576)(388,576){1}
wire w118;    //: /sn:0 {0}(285,1619)(339,1619)(339,1591){1}
wire w68;    //: /sn:0 {0}(395,1100)(432,1100)(432,1068){1}
wire w30;    //: /sn:0 {0}(410,399)(410,413)(385,413){1}
wire w62;    //: /sn:0 {0}(163,1667)(178,1667){1}
wire w57;    //: /sn:0 {0}(830,596)(850,596)(850,580){1}
wire w11;    //: /sn:0 {0}(488,36)(488,98)(386,98){1}
wire w70;    //: /sn:0 {0}(954,1059)(913,1059)(913,1092)(842,1092){1}
wire w110;    //: /sn:0 {0}(163,1603)(178,1603){1}
wire w72;    //: /sn:0 {0}(954,1039)(886,1039)(886,1060)(842,1060){1}
wire w33;    //: /sn:0 {0}(489,399)(489,461)(385,461){1}
wire w79;    //: /sn:0 {0}(954,969)(902,969)(902,948)(842,948){1}
wire w9;    //: /sn:0 {0}(436,36)(436,66)(386,66){1}
wire w55;    //: /sn:0 {0}(893,579)(893,628)(830,628){1}
wire w26;    //: /sn:0 {0}(440,706)(440,743)(390,743){1}
//: enddecls

  //: joint g8 (w0) @(221, 300) /w:[ 6 5 -1 8 ]
  H7408 g4 (.A1(w36), .A2(w37), .A3(w38), .A4(w39), .B1(w0), .B2(w1), .B3(w2), .B4(w3), .Y1(w19), .Y2(w18), .Y3(w17), .Y4(w16));   //: @(313, 544) /sz:(74, 144) /sn:0 /p:[ Li0>15 Li1>15 Li2>15 Li3>15 Li4>11 Li5>11 Li6>11 Li7>11 Ro0<0 Ro1<1 Ro2<1 Ro3<1 ]
  //: SWITCH g140 (w120) @(196,1771) /sn:0 /w:[ 0 ] /st:0 /dn:0
  //: LED g37 (w34) @(513,393) /sn:0 /w:[ 0 ] /type:0
  //: joint g13 (w38) @(250, 82) /w:[ 8 -1 10 7 ]
  //: joint g55 (w36) @(280, 727) /w:[ 18 17 -1 20 ]
  //: joint g58 (w39) @(234, 608) /w:[ 14 13 -1 16 ]
  //: LED g139 (w112) @(477,1584) /sn:0 /w:[ 1 ] /type:0
  //: joint g112 (w2) @(195, 1180) /w:[ 22 21 -1 24 ]
  //: joint g111 (w1) @(209, 1164) /w:[ 22 21 -1 24 ]
  //: LED g76 (w55) @(893,572) /sn:0 /w:[ 0 ] /type:0
  //: SWITCH A3 (w38) @(36,134) /w:[ 11 ] /st:0 /dn:0
  H7402 g1 (.B4(w3), .B3(w2), .B2(w1), .B1(w0), .A4(w39), .A3(w38), .A2(w37), .A1(w36), .Y4(w23), .Y3(w22), .Y2(w21), .Y1(w20));   //: @(311, 220) /sz:(74, 144) /sn:0 /p:[ Li0>0 Li1>0 Li2>7 Li3>7 Li4>5 Li5>5 Li6>5 Li7>5 Ro0<1 Ro1<1 Ro2<0 Ro3<1 ]
  //: LED g64 (w53) @(436,887) /sn:0 /w:[ 1 ] /type:0
  //: SWITCH A (w43) @(632,44) /w:[ 0 ] /st:1 /dn:0
  //: joint g11 (w36) @(280, 50) /w:[ 8 -1 10 7 ]
  //: SWITCH g130 (w99) @(593,1466) /sn:0 /w:[ 1 ] /st:0 /dn:0
  //: LED g121 (w100) @(947,1256) /sn:0 /w:[ 1 ] /type:0
  //: SWITCH C3 (w13) @(38,918) /w:[ 0 ] /st:0 /dn:0
  //: LED g50 (w26) @(440,699) /sn:0 /w:[ 0 ] /type:0
  //: LED g28 (w11) @(488,29) /sn:0 /w:[ 0 ] /type:0
  //: LED g132 (w119) @(316,1584) /sn:0 /w:[ 1 ] /type:0
  //: joint g113 (w3) @(177, 1196) /w:[ 18 17 -1 20 ]
  //: SWITCH A6 (w40) @(36,524) /w:[ 0 ] /st:0 /dn:0
  //: joint g19 (w36) @(280, 236) /w:[ 4 6 -1 3 ]
  //: SWITCH G (w49) @(631,322) /w:[ 0 ] /st:1 /dn:0
  //: SWITCH A2 (w37) @(36,91) /w:[ 11 ] /st:0 /dn:0
  //: SWITCH g115 (w59) @(128,1425) /sn:0 /w:[ 0 ] /st:0 /dn:0
  //: joint g6 (w38) @(250, 445) /w:[ 1 2 -1 12 ]
  //: SWITCH B2 (w1) @(36,301) /w:[ 3 ] /st:0 /dn:0
  //: LED g38 (w35) @(537,393) /sn:0 /w:[ 1 ] /type:0
  //: LED g53 (w42) @(909,111) /sn:0 /w:[ 1 ] /type:0
  //: joint g7 (w39) @(234, 461) /w:[ 1 2 -1 12 ]
  //: LED g75 (w56) @(871,572) /sn:0 /w:[ 1 ] /type:0
  //: LED g135 (w116) @(385,1584) /sn:0 /w:[ 1 ] /type:0
  //: LED g31 (w20) @(407,216) /sn:0 /w:[ 0 ] /type:0
  //: joint g20 (w37) @(266, 252) /w:[ 4 6 -1 3 ]
  //: SWITCH g124 (w107) @(603,1271) /sn:0 /w:[ 1 ] /st:0 /dn:0
  //: LED g39 (w18) @(434,534) /sn:0 /w:[ 0 ] /type:0
  //: SWITCH B1 (w0) @(36,242) /w:[ 3 ] /st:0 /dn:0
  //: SWITCH g68 (w58) @(618,543) /sn:0 /w:[ 0 ] /st:0 /dn:0
  //: joint g48 (w2) @(195, 656) /w:[ 10 9 -1 12 ]
  //: LED g29 (w23) @(486,216) /sn:0 /w:[ 0 ] /type:0
  //: LED g25 (w8) @(409,29) /sn:0 /w:[ 1 ] /type:0
  //: joint g17 (w2) @(195, 146) /w:[ 4 -1 6 3 ]
  H7430 g52 (.A(w43), .B(w44), .C(w45), .D(w46), .E(w47), .F(w48), .G(w49), .H(w50), .Y(w42));   //: @(823, 119) /sz:(62, 144) /sn:0 /p:[ Li0>1 Li1>0 Li2>0 Li3>0 Li4>0 Li5>1 Li6>1 Li7>1 Ro0<0 ]
  //: joint g106 (w36) @(280, 1084) /w:[ 26 25 -1 28 ]
  //: joint g107 (w37) @(266, 1100) /w:[ 26 25 -1 28 ]
  //: joint g83 (w39) @(234, 958) /w:[ 18 17 -1 20 ]
  //: LED g100 (w60) @(996,1004) /sn:0 /R:3 /w:[ 0 ] /type:1
  //: joint g14 (w39) @(234, 98) /w:[ 8 -1 10 7 ]
  //: joint g47 (w1) @(209, 640) /w:[ 10 9 -1 12 ]
  //: joint g44 (w37) @(266, 576) /w:[ 14 13 -1 16 ]
  //: joint g80 (w36) @(280, 910) /w:[ 22 21 -1 24 ]
  //: SWITCH g94 (w85) @(620,905) /sn:0 /w:[ 1 ] /st:0 /dn:0
  //: SWITCH D (w46) @(631,183) /w:[ 1 ] /st:1 /dn:0
  //: SWITCH C (w45) @(630,135) /w:[ 1 ] /st:1 /dn:0
  //: joint g21 (w38) @(250, 268) /w:[ 4 6 -1 3 ]
  //: joint g84 (w0) @(221, 974) /w:[ 18 17 -1 20 ]
  //: LED g105 (w95) @(478,1242) /sn:0 /w:[ 0 ] /type:0
  //: SWITCH g141 (w111) @(101,1570) /sn:0 /w:[ 0 ] /st:0 /dn:0
  //: LED g41 (w16) @(485,534) /sn:0 /w:[ 0 ] /type:0
  //: joint g23 (w3) @(177, 348) /w:[ 1 2 -1 8 ]
  H74163 g116 (.A(w105), .B(w106), .C(w107), .D(w108), ._CLR(w92), .ENP(w93), .ENT(w94), ._LOAD(w99), .CLK(w91), .QA(w104), .QB(w103), .QC(w102), .QD(w101), .RCO(w100));   //: @(694, 1264) /sz:(117, 160) /sn:0 /p:[ Li0>0 Li1>0 Li2>0 Li3>1 Li4>0 Li5>0 Li6>0 Li7>0 Bi0>1 Ro0<1 Ro1<1 Ro2<1 Ro3<1 Ro4<0 ]
  //: SWITCH g123 (w106) @(602,1241) /sn:0 /w:[ 1 ] /st:0 /dn:0
  //: LED g40 (w17) @(458,534) /sn:0 /w:[ 0 ] /type:0
  //: SWITCH A1 (w36) @(36,50) /w:[ 11 ] /st:0 /dn:0
  H7432 g54 (.A1(w36), .A2(w37), .A3(w38), .A4(w39), .B1(w0), .B2(w1), .B3(w2), .B4(w3), .Y1(w54), .Y2(w53), .Y3(w52), .Y4(w51));   //: @(316, 894) /sz:(74, 144) /sn:0 /p:[ Li0>23 Li1>23 Li2>23 Li3>19 Li4>19 Li5>19 Li6>19 Li7>15 Ro0<0 Ro1<0 Ro2<1 Ro3<1 ]
  //: SWITCH g93 (w84) @(620,867) /sn:0 /w:[ 0 ] /st:0 /dn:0
  //: joint g46 (w0) @(221, 624) /w:[ 10 9 -1 12 ]
  //: LED g26 (w9) @(436,29) /sn:0 /w:[ 0 ] /type:0
  H7400 g0 (.B4(w3), .B3(w2), .B2(w1), .B1(w0), .A4(w39), .A3(w38), .A2(w37), .A1(w36), .Y4(w11), .Y3(w10), .Y2(w9), .Y1(w8));   //: @(311, 34) /sz:(74, 144) /sn:0 /p:[ Li0>5 Li1>5 Li2>0 Li3>0 Li4>9 Li5>9 Li6>9 Li7>9 Ro0<1 Ro1<1 Ro2<1 Ro3<0 ]
  //: LED g90 (w67) @(455,1061) /sn:0 /w:[ 1 ] /type:0
  //: SWITCH B4 (w3) @(36,404) /w:[ 7 ] /st:0 /dn:0
  //: joint g82 (w38) @(250, 942) /w:[ 22 21 -1 24 ]
  //: LED g136 (w115) @(408,1584) /sn:0 /w:[ 1 ] /type:0
  //: SWITCH g128 (w93) @(593,1399) /sn:0 /w:[ 1 ] /st:0 /dn:0
  //: LED g33 (w31) @(437,392) /sn:0 /w:[ 0 ] /type:0
  //: LED g91 (w66) @(477,1061) /sn:0 /w:[ 1 ] /type:0
  //: LED g49 (w27) @(412,699) /sn:0 /w:[ 1 ] /type:0
  //: LED g137 (w114) @(431,1584) /sn:0 /w:[ 1 ] /type:0
  //: joint g61 (w2) @(195, 807) /w:[ 14 13 -1 16 ]
  //: SWITCH B (w44) @(631,91) /w:[ 1 ] /st:1 /dn:0
  //: LED g51 (w25) @(464,699) /sn:0 /w:[ 1 ] /type:0
  //: joint g3 (w36) @(280, 413) /w:[ 1 2 -1 12 ]
  //: LED g34 (w30) @(410,392) /sn:0 /w:[ 0 ] /type:0
  //: joint g86 (w2) @(195, 1006) /w:[ 18 17 -1 20 ]
  //: SWITCH A5 (w41) @(36,477) /w:[ 0 ] /st:0 /dn:0
  //: LED g89 (w68) @(432,1061) /sn:0 /w:[ 1 ] /type:0
  //: joint g110 (w0) @(221, 1148) /w:[ 22 21 -1 24 ]
  H7404 g2 (.A6(w40), .A5(w41), .A4(w39), .A3(w38), .A2(w37), .A1(w36), .Y6(w35), .Y5(w34), .Y4(w33), .Y3(w32), .Y2(w31), .Y1(w30));   //: @(310, 397) /sz:(74, 112) /sn:0 /p:[ Li0>1 Li1>1 Li2>0 Li3>0 Li4>0 Li5>0 Ro0<0 Ro1<1 Ro2<1 Ro3<1 Ro4<1 Ro5<1 ]
  //: LED g65 (w52) @(459,888) /sn:0 /w:[ 0 ] /type:0
  //: LED g77 (w29) @(913,573) /sn:0 /w:[ 0 ] /type:0
  //: SWITCH F (w48) @(631,275) /w:[ 0 ] /st:1 /dn:0
  //: joint g59 (w0) @(221, 775) /w:[ 14 13 -1 16 ]
  //: SWITCH g72 (w6) @(618,690) /sn:0 /w:[ 0 ] /st:0 /dn:0
  //: SWITCH g98 (w89) @(620,1049) /sn:0 /w:[ 0 ] /st:0 /dn:0
  assign w60 = {w64, w65, w70, w71, w72, w73, w74, w75, w76, w77, w78, w79, w80, w81, w82, w83}; //: CONCAT g99  @(959,1004) /sn:0 /w:[ 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 ] /dr:1 /tp:0 /drp:1
  //: joint g16 (w1) @(209, 130) /w:[ 1 -1 2 4 ]
  //: SWITCH g96 (w87) @(620,977) /sn:0 /w:[ 0 ] /st:0 /dn:0
  //: SWITCH g122 (w105) @(602,1212) /sn:0 /w:[ 1 ] /st:0 /dn:0
  //: LED g103 (w98) @(415,1242) /sn:0 /w:[ 0 ] /type:0
  //: joint g10 (w2) @(195, 332) /w:[ 1 2 -1 8 ]
  //: joint g87 (w3) @(177, 1022) /w:[ 14 13 -1 16 ]
  //: SWITCH g78 (w4) @(704,768) /sn:0 /w:[ 1 ] /st:0 /dn:0
  //: SWITCH g129 (w94) @(593,1431) /sn:0 /w:[ 1 ] /st:0 /dn:0
  //: LED g32 (w21) @(434,216) /sn:0 /w:[ 1 ] /type:0
  //: LED g27 (w10) @(461,29) /sn:0 /w:[ 0 ] /type:0
  //: LED g102 (w97) @(433,1242) /sn:0 /w:[ 0 ] /type:0
  //: SWITCH g69 (w24) @(617,574) /sn:0 /w:[ 0 ] /st:0 /dn:0
  //: LED g119 (w102) @(905,1256) /sn:0 /w:[ 0 ] /type:0
  //: joint g9 (w1) @(209, 316) /w:[ 6 5 -1 8 ]
  //: joint g57 (w38) @(250, 759) /w:[ 18 17 -1 20 ]
  //: SWITCH g142 (w121) @(98,1604) /sn:0 /w:[ 0 ] /st:0 /dn:0
  //: joint g15 (w0) @(221, 114) /w:[ 1 -1 2 4 ]
  //: SWITCH g71 (w14) @(617,658) /sn:0 /w:[ 0 ] /st:0 /dn:0
  //: SWITCH C2 (w12) @(38,866) /w:[ 0 ] /st:0 /dn:0
  H74175 g131 (.D1(w110), .D2(w109), .D3(w90), .D4(w63), ._PRE(w62), ._CLR(w28), .CLK(w120), .Q1(w119), .Q2(w118), .Q3(w117), .Q4(w116), ._Q1(w115), ._Q2(w114), ._Q3(w113), ._Q4(w112));   //: @(179, 1587) /sz:(105, 144) /sn:0 /p:[ Li0>1 Li1>1 Li2>1 Li3>1 Li4>1 Li5>1 Bi0>1 Ro0<0 Ro1<0 Ro2<0 Ro3<0 Ro4<0 Ro5<0 Ro6<0 Ro7<0 ]
  //: SWITCH g127 (w92) @(593,1366) /sn:0 /w:[ 1 ] /st:1 /dn:0
  H7474 g67 (.D1(w58), ._PRE1(w24), ._CLR1(w15), .D2(w14), ._PRE2(w6), ._CLR2(w5), .CLK(w4), .Q1(w57), ._Q1(w56), .Q2(w55), ._Q2(w29));   //: @(719, 580) /sz:(110, 124) /sn:0 /p:[ Li0>1 Li1>1 Li2>1 Li3>1 Li4>1 Li5>1 Bi0>0 Ro0<0 Ro1<0 Ro2<1 Ro3<1 ]
  //: joint g43 (w36) @(280, 560) /w:[ 14 13 -1 16 ]
  //: joint g62 (w3) @(177, 672) /w:[ 10 9 -1 12 ]
  //: SWITCH g73 (w5) @(619,723) /sn:0 /w:[ 0 ] /st:0 /dn:0
  //: LED g88 (w69) @(414,1061) /sn:0 /w:[ 1 ] /type:0
  //: LED g104 (w96) @(456,1242) /sn:0 /w:[ 0 ] /type:0
  //: LED g138 (w113) @(454,1584) /sn:0 /w:[ 1 ] /type:0
  H7410 g42 (.A1(w36), .A2(w37), .A3(w38), .B1(w0), .B2(w1), .B3(w2), .C1(w7), .C2(w12), .C3(w13), .Y1(w27), .Y2(w26), .Y3(w25));   //: @(315, 711) /sz:(74, 160) /sn:0 /p:[ Li0>19 Li1>19 Li2>19 Li3>15 Li4>15 Li5>15 Li6>0 Li7>1 Li8>1 Ro0<0 Ro1<1 Ro2<0 ]
  //: LED g63 (w54) @(414,887) /sn:0 /w:[ 1 ] /type:0
  //: joint g109 (w39) @(234, 1132) /w:[ 22 21 -1 24 ]
  //: LED g74 (w57) @(850,573) /sn:0 /w:[ 1 ] /type:0
  //: LED g133 (w118) @(339,1584) /sn:0 /w:[ 1 ] /type:0
  //: joint g5 (w37) @(266, 429) /w:[ 1 2 -1 12 ]
  //: joint g56 (w37) @(266, 743) /w:[ 18 17 -1 20 ]
  //: LED g117 (w104) @(864,1256) /sn:0 /w:[ 0 ] /type:0
  //: SWITCH H (w50) @(631,368) /w:[ 0 ] /st:1 /dn:0
  H7486 g79 (.A1(w36), .A2(w37), .A3(w38), .A4(w39), .B1(w0), .B2(w1), .B3(w2), .B4(w3), .Y1(w69), .Y2(w68), .Y3(w67), .Y4(w66));   //: @(320, 1068) /sz:(74, 144) /sn:0 /p:[ Li0>27 Li1>27 Li2>27 Li3>23 Li4>23 Li5>23 Li6>23 Li7>19 Ro0<0 Ro1<0 Ro2<0 Ro3<0 ]
  //: SWITCH g95 (w86) @(620,941) /sn:0 /w:[ 0 ] /st:0 /dn:0
  //: LED g24 (w19) @(410,534) /sn:0 /w:[ 1 ] /type:0
  //: LED g36 (w32) @(462,392) /sn:0 /w:[ 0 ] /type:0
  //: joint g85 (w1) @(209, 990) /w:[ 18 17 -1 20 ]
  H74154 g92 (.A(w84), .B(w85), .C(w86), .D(w87), ._G1(w88), ._G2(w89), ._Y1(w83), ._Y2(w82), ._Y3(w81), ._Y4(w80), ._Y5(w79), ._Y6(w78), ._Y7(w77), ._Y8(w76), ._Y9(w75), ._Y10(w74), ._Y11(w73), ._Y12(w72), ._Y13(w71), ._Y14(w70), ._Y15(w65), ._Y16(w64));   //: @(736, 868) /sz:(105, 272) /sn:0 /p:[ Li0>1 Li1>0 Li2>1 Li3>1 Li4>1 Li5>1 Ro0<1 Ro1<1 Ro2<1 Ro3<1 Ro4<1 Ro5<1 Ro6<1 Ro7<1 Ro8<1 Ro9<0 Ro10<1 Ro11<1 Ro12<1 Ro13<1 Ro14<1 Ro15<1 ]
  //: SWITCH g125 (w108) @(602,1300) /sn:0 /w:[ 0 ] /st:0 /dn:0
  //: joint g60 (w1) @(209, 791) /w:[ 14 13 -1 16 ]
  //: joint g81 (w37) @(266, 926) /w:[ 22 21 -1 24 ]
  H74157 g101 (.A1(w36), .A2(w37), .A3(w38), .A4(w39), .B1(w0), .B2(w1), .B3(w2), .B4(w3), ._G(w61), .S(w59), .Y1(w98), .Y2(w97), .Y3(w96), .Y4(w95));   //: @(317, 1249) /sz:(81, 176) /sn:0 /p:[ Li0>29 Li1>29 Li2>29 Li3>25 Li4>25 Li5>25 Li6>25 Li7>21 Li8>0 Li9>1 Ro0<1 Ro1<1 Ro2<1 Ro3<1 ]
  //: SWITCH g126 (w91) @(712,1495) /sn:0 /w:[ 0 ] /st:0 /dn:0
  //: joint g45 (w38) @(250, 592) /w:[ 14 13 -1 16 ]
  //: LED g35 (w33) @(489,392) /sn:0 /w:[ 0 ] /type:0
  //: joint g22 (w39) @(234, 284) /w:[ 4 6 -1 3 ]
  //: SWITCH g70 (w15) @(617,604) /sn:0 /w:[ 0 ] /st:0 /dn:0
  //: LED g120 (w101) @(923,1256) /sn:0 /w:[ 0 ] /type:0
  //: SWITCH g97 (w88) @(620,1013) /sn:0 /w:[ 0 ] /st:0 /dn:0
  //: LED g66 (w51) @(481,888) /sn:0 /w:[ 0 ] /type:0
  //: SWITCH B3 (w2) @(36,353) /w:[ 7 ] /st:0 /dn:0
  //: SWITCH g114 (w61) @(128,1393) /sn:0 /w:[ 1 ] /st:0 /dn:0
  //: SWITCH E (w47) @(631,231) /w:[ 1 ] /st:1 /dn:0
  //: SWITCH C1 (w7) @(39,823) /w:[ 1 ] /st:0 /dn:0
  //: joint g12 (w37) @(266, 66) /w:[ 8 -1 10 7 ]
  //: joint g18 (w3) @(177, 162) /w:[ 4 -1 6 3 ]
  //: LED g30 (w22) @(459,216) /sn:0 /w:[ 0 ] /type:0
  //: SWITCH A4 (w39) @(36,187) /w:[ 11 ] /st:0 /dn:0
  //: joint g108 (w38) @(250, 1116) /w:[ 26 25 -1 28 ]
  //: LED g134 (w117) @(362,1584) /sn:0 /w:[ 1 ] /type:0
  //: LED g118 (w103) @(886,1256) /sn:0 /w:[ 0 ] /type:0

endmodule
//: /netlistEnd

//: /hdlBegin H7474
//: interface  /sz:(110, 124) /bd:[ Li0>D1(16/124) Li1>_PRE1(32/124) Li2>_CLR1(48/124) Li3>D2(64/124) Li4>_PRE2(80/124) Li5>_CLR2(96/124) Bi0>CLK(54/110) Ro0<Q1(16/124) Ro1<_Q1(32/124) Ro2<Q2(48/124) Ro3<_Q2(64/124) ] /pd: 0 /pi: 0 /pe: 1 /pp: 0
//: property pptype=0
//: enddecls
module H7474 #(.delay(18)) (CLK,D1,_PRE1,_CLR1,D2,_PRE2,_CLR2,Q1,_Q1,Q2,_Q2);
  input CLK,D1,_PRE1,_CLR1,D2,_PRE2,_CLR2;
  output Q1,_Q1,Q2,_Q2;
  reg R1,R2;
  
  assign #delay _Q1 = ~R1;
  assign #delay _Q2 = ~R2;
  assign #delay Q1 = R1;
  assign #delay Q2 = R2;
  
  always @(negedge _PRE1 or negedge _CLR1)
    begin
      if (~_PRE1)
        R1 = 1'b1;
      else if (~_CLR1)
        R1 = 1'b0;
    end

  always @(negedge _PRE2 or negedge _CLR2)
    begin
      if (~_PRE2)
        R2 = 1'b1;
      else if (~_CLR2)
        R2 = 1'b0;
    end
  
  always @(posedge CLK)
    begin
      if (~_PRE1 && ~_CLR1)
        R1 = D1;
      if (~_PRE2 && ~_CLR2)
        R2 = D2;
    end
  
  
endmodule
//: /hdlEnd


`timescale 1ns/1ns

//: /hdlBegin H7404
//: interface  /sz:(74, 112) /bd:[ Li0>A1(16/112) Li1>A2(32/112) Li2>A3(48/112) Li3>A4(64/112) Li4>A5(80/112) Li5>A6(96/112) Ro0<Y1(16/112) Ro1<Y2(32/112) Ro2<Y3(48/112) Ro3<Y4(64/112) Ro4<Y5(80/112) Ro5<Y6(96/112) ] /pd: 0 /pi: 0 /pe: 0 /pp: 1
//: enddecls
module H7404 #(.delay(3)) (A1,A2,A3,A4,A5,A6,Y1,Y2,Y3,Y4,Y4,Y6);
  input A1,A2,A3,A4,A5,A6;
  output Y1,Y2,Y3,Y4,Y5,Y6;

  assign #delay Y1 = ~A1;
  assign #delay Y2 = ~A2;
  assign #delay Y3 = ~A3;
  assign #delay Y4 = ~A4;
  assign #delay Y5 = ~A5;
  assign #delay Y6 = ~A6;

endmodule
//: /hdlEnd


`timescale 1ns/1ns

//: /hdlBegin H7402
//: interface  /sz:(74, 144) /bd:[ Li0>B4(128/144) Li1>B3(112/144) Li2>B2(96/144) Li3>B1(80/144) Li4>A4(64/144) Li5>A3(48/144) Li6>A2(32/144) Li7>A1(16/144) Ro0<Y4(64/144) Ro1<Y3(48/144) Ro2<Y2(32/144) Ro3<Y1(16/144) ] /pd: 0 /pi: 0 /pe: 0 /pp: 1
//: enddecls
module H7402 #(.delay(4)) (A1,A2,A3,A4,B1,B2,B3,B4,Y1,Y2,Y3,Y4);
  input A1,A2,A3,A4,B1,B2,B3,B4;
  output Y1,Y2,Y3,Y4;
  
  assign #delay Y1 = A1 ~| B1;
  assign #delay Y2 = A2 ~| B2;
  assign #delay Y3 = A3 ~| B3;
  assign #delay Y4 = A4 ~| B4;

endmodule
//: /hdlEnd


`timescale 1ns/1ns

//: /hdlBegin H74154
//: interface  /sz:(105, 272) /bd:[ Li0>A(16/272) Li1>B(32/272) Li2>C(48/272) Li3>D(64/272) Li4>_G1(80/272) Li5>_G2(96/272) Ro0<_Y1(16/272) Ro1<_Y2(32/272) Ro2<_Y3(48/272) Ro3<_Y4(64/272) Ro4<_Y5(80/272) Ro5<_Y6(96/272) Ro6<_Y7(112/272) Ro7<_Y8(128/272) Ro8<_Y9(144/272) Ro9<_Y10(160/272) Ro10<_Y11(176/272) Ro11<_Y12(192/272) Ro12<_Y13(208/272) Ro13<_Y14(224/272) Ro14<_Y15(240/272) Ro15<_Y16(256/272) ] /pd: 0 /pi: 0 /pe: 1 /pp: 1
//: enddecls
module H74154 #(.delay(20)) (A,B,C,D,_G1,_G2,_Y1,_Y2,_Y3,_Y4,_Y5,_Y6,_Y7,_Y8,
              _Y9,_Y10,_Y11,_Y12,_Y13,_Y14,_Y15,_Y16);
  input A,B,C,D,_G1,_G2;
  output _Y1,_Y2,_Y3,_Y4,_Y5,_Y6,_Y7,_Y8,_Y9,_Y10,_Y11,_Y12,_Y13,_Y14,_Y15,_Y16;
  reg [15:0] R;
  
  assign #delay {_Y16,_Y15,_Y14,_Y13,_Y12,_Y11,_Y10,_Y9,_Y8,_Y7,_Y6,_Y5,_Y4,_Y3,_Y2,_Y1} = ~R;

  initial
    if (_G1 || _G2)
      R = 0;
    else
      R = 16'h1 << {D,C,B,A};

  always @(_G1 or _G2 or A or B or C or D)
    if (_G1 || _G2)
      R = 0;
    else
      R = 16'h1 << {D,C,B,A};

endmodule
//: /hdlEnd


`timescale 1ns/1ns

//: /hdlBegin H7408
//: interface  /sz:(74, 144) /bd:[ Li0>B4(128/144) Li1>B3(112/144) Li2>B2(96/144) Li3>B1(80/144) Li4>A4(64/144) Li5>A3(48/144) Li6>A2(32/144) Li7>A1(16/144) Ro0<Y4(64/144) Ro1<Y3(48/144) Ro2<Y2(32/144) Ro3<Y1(16/144) ] /pd: 0 /pi: 0 /pe: 0 /pp: 1
//: enddecls
module H7408 #(.delay(4)) (A1,A2,A3,A4,B1,B2,B3,B4,Y1,Y2,Y3,Y4);
  input A1,A2,A3,A4,B1,B2,B3,B4;
  output Y1,Y2,Y3,Y4;
  
  assign #delay Y1 = A1 & B1;
  assign #delay Y2 = A2 & B2;
  assign #delay Y3 = A3 & B3;
  assign #delay Y4 = A4 & B4;

endmodule
//: /hdlEnd


`timescale 1ns/1ns

//: /hdlBegin H7486
//: interface  /sz:(74, 144) /bd:[ Li0>A1(16/144) Li1>A2(32/144) Li2>A3(48/144) Li3>A4(64/144) Li4>B1(80/144) Li5>B2(96/144) Li6>B3(112/144) Li7>B4(128/144) Ro0<Y1(16/144) Ro1<Y2(32/144) Ro2<Y3(48/144) Ro3<Y4(64/144) ] /pd: 0 /pi: 0 /pe: 0 /pp: 1
//: enddecls
module H7486 #(.delay(4)) (A1,A2,A3,A4,B1,B2,B3,B4,Y1,Y2,Y3,Y4);
  input A1,A2,A3,A4,B1,B2,B3,B4;
  output Y1,Y2,Y3,Y4;
  
  assign #delay Y1 = A1 ^ B1;
  assign #delay Y2 = A2 ^ B2;
  assign #delay Y3 = A3 ^ B3;
  assign #delay Y4 = A4 ^ B4;

endmodule
//: /hdlEnd


`timescale 1ns/1ns

//: /hdlBegin H74157
//: interface  /sz:(81, 176) /bd:[ Li0>A1(16/176) Li1>A2(32/176) Li2>A3(48/176) Li3>A4(64/176) Li4>B1(80/176) Li5>B2(96/176) Li6>B3(112/176) Li7>B4(128/176) Li8>_G(144/176) Li9>S(160/176) Ro0<Y1(16/176) Ro1<Y2(32/176) Ro2<Y3(48/176) Ro3<Y4(64/176) ] /pd: 0 /pi: 0 /pe: 1 /pp: 1
//: enddecls
module H74157 #(.delay(18)) (S,_G,A1,A2,A3,A4,B1,B2,B3,B4,Y1,Y2,Y3,Y4);
  input S,_G;
  input A1,A2,A3,A4,B1,B2,B3,B4;
  output Y1,Y2,Y3,Y4;
  
  assign #delay Y1 = _G ? 1'b1 : (S ? B1 : A1);
  assign #delay Y2 = _G ? 1'b1 : (S ? B2 : A2);
  assign #delay Y3 = _G ? 1'b1 : (S ? B3 : A3);
  assign #delay Y4 = _G ? 1'b1 : (S ? B4 : A4);

endmodule
//: /hdlEnd


`timescale 1ns/1ns

//: /hdlBegin H74163
//: interface  /sz:(117, 160) /bd:[ Li0>_LOAD(128/160) Li1>ENT(112/160) Li2>ENP(96/160) Li3>_CLR(80/160) Li4>D(64/160) Li5>C(48/160) Li6>B(32/160) Li7>A(16/160) Bi0>CLK(61/117) Ro0<RCO(80/160) Ro1<QD(64/160) Ro2<QC(48/160) Ro3<QB(32/160) Ro4<QA(16/160) ] /pd: 0 /pi: 0 /pe: 1 /pp: 1
//: enddecls
module H74163 #(.delay(20)) (_CLR, _LOAD, ENT, ENP, CLK, A, B, C, D, QA, QB, QC, QD, RCO);
  input _CLR, _LOAD, ENT, ENP, CLK, A, B, C, D;
  reg output QA, QB, QC, QD;
  output RCO;
  
  assign RCO = QA & QB & QC &QD & ENT;
  
  always @(_CLR or _LOAD)
    if (_CLR == 1'b0)
      begin
        QA <= #delay 1'b0;
        QB <= #delay 1'b0;
        QC <= #delay 1'b0;
        QD <= #delay 1'b0;
      end
    else if (_LOAD == 1'b0)
      begin
        QA <= #delay A;
        QB <= #delay B;
        QC <= #delay C;
        QD <= #delay D;
      end
  
  always @(posedge CLK)
    if (ENP == 1'b1 && ENT == 1'b1 && _CLR == 1'b1 && _LOAD == 1'b1)
      begin
        {QD, QC, QB, QA} <= #delay {QD, QC, QB, QA} + 4'h1;
      end

endmodule
//: /hdlEnd


`timescale 1ns/1ns

//: /hdlBegin H74175
//: interface  /sz:(105, 144) /bd:[ Li0>_CLR(96/144) Li1>_PRE(80/144) Li2>D4(64/144) Li3>D3(48/144) Li4>D2(32/144) Li5>D1(16/144) Bi0>CLK(52/105) Ro0<_Q4(128/144) Ro1<_Q3(112/144) Ro2<_Q2(96/144) Ro3<_Q1(80/144) Ro4<Q4(64/144) Ro5<Q3(48/144) Ro6<Q2(32/144) Ro7<Q1(16/144) ] /pd: 0 /pi: 0 /pe: 0 /pp: 1
//: enddecls
module H74175 #(.delay(18)) (CLK,_PRE,_CLR,D1,D2,D3,D4,Q1,_Q1,Q2,_Q2,Q3,_Q3,Q4,_Q4);
  input CLK,_PRE,_CLR,D1,D2,D3,D4;
  output Q1,_Q1,Q2,_Q2,Q3,_Q3,Q4,_Q4;
  reg R1,R2,R2,R3;
  
  assign #delay _Q1 = ~R1;
  assign #delay _Q2 = ~R2;
  assign #delay _Q3 = ~R3;
  assign #delay _Q4 = ~R4;
  assign #delay Q1 = R1;
  assign #delay Q2 = R2;
  assign #delay Q3 = R3;
  assign #delay Q4 = R4;
  
  always @(negedge _PRE or negedge _CLR)
    begin
      if (~_PRE)
        begin
          R1 = 1'b1;
          R2 = 1'b1;
          R3 = 1'b1;
          R4 = 1'b1;
        end
      else if (~_CLR)
        begin
          R1 = 1'b0;
          R2 = 1'b0;
          R3 = 1'b0;
          R4 = 1'b0;
        end
    end

  always @(posedge CLK)
    begin
      if (~_PRE && ~_CLR)
        begin
          R1 = D1;
          R2 = D2;
          R3 = D3;
          R4 = D4;
        end
    end
  
  
endmodule
//: /hdlEnd


`timescale 1ns/1ns

//: /hdlBegin H7410
//: interface  /sz:(74, 160) /bd:[ Li0>C3(144/160) Li1>C2(128/160) Li2>C1(112/160) Li3>B3(96/160) Li4>B2(80/160) Li5>B1(64/160) Li6>A3(48/160) Li7>A2(32/160) Li8>A1(16/160) Ro0<Y3(48/160) Ro1<Y2(32/160) Ro2<Y1(16/160) ] /pd: 0 /pi: 0 /pe: 0 /pp: 1
//: enddecls
module H7410 #(.delay(6)) (A1,A2,A3,B1,B2,B3,C1,C2,C3,Y1,Y2,Y3);
  input A1,A2,A3,B1,B2,B3,C1,C2,C3;
  output Y1,Y2,Y3;
  
  assign #delay Y1 = ~(A1 & B1 & C1);
  assign #delay Y2 = ~(A2 & B2 & C2);
  assign #delay Y3 = ~(A3 & B3 & C3);

endmodule
//: /hdlEnd


`timescale 1ns/1ns

//: /hdlBegin H7430
//: interface  /sz:(62, 144) /bd:[ Li0>H(128/144) Li1>G(112/144) Li2>F(96/144) Li3>E(80/144) Li4>D(64/144) Li5>C(48/144) Li6>B(32/144) Li7>A(16/144) Ro0<Y(16/144) ] /pd: 0 /pi: 0 /pe: 0 /pp: 1
//: enddecls
module H7430 #(.delay(12)) (A,B,C,D,E,F,G,H,Y);
  input A,B,C,D,E,F,G,H;
  output Y;
  
  assign #delay Y = ~(A & B & C & D & E & F & G & H); 

endmodule
//: /hdlEnd


`timescale 1ns/1ns

//: /hdlBegin H7400
//: interface  /sz:(74, 144) /bd:[ Li0>B4(128/144) Li1>B3(112/144) Li2>B2(96/144) Li3>B1(80/144) Li4>A4(64/144) Li5>A3(48/144) Li6>A2(32/144) Li7>A1(16/144) Ro0<Y4(64/144) Ro1<Y3(48/144) Ro2<Y2(32/144) Ro3<Y1(16/144) ] /pd: 0 /pi: 0 /pe: 0 /pp: 1
//: enddecls
module H7400 #(.delay(4)) (A1,A2,A3,A4,B1,B2,B3,B4,Y1,Y2,Y3,Y4);
  input A1,A2,A3,A4,B1,B2,B3,B4;
  output Y1,Y2,Y3,Y4;
  
  assign #delay Y1 = A1 ~& B1;
  assign #delay Y2 = A2 ~& B2;
  assign #delay Y3 = A3 ~& B3;
  assign #delay Y4 = A4 ~& B4;

endmodule
//: /hdlEnd


`timescale 1ns/1ns

//: /hdlBegin H7432
//: interface  /sz:(74, 144) /bd:[ Li0>A1(16/144) Li1>A2(32/144) Li2>A3(48/144) Li3>A4(64/144) Li4>B1(80/144) Li5>B2(96/144) Li6>B3(112/144) Li7>B4(128/144) Ro0<Y1(16/144) Ro1<Y2(32/144) Ro2<Y3(48/144) Ro3<Y4(64/144) ] /pd: 0 /pi: 0 /pe: 0 /pp: 1
//: enddecls
module H7432 #(.delay(6)) (A1,A2,A3,A4,B1,B2,B3,B4,Y1,Y2,Y3,Y4);
  input A1,A2,A3,A4,B1,B2,B3,B4;
  output Y1,Y2,Y3,Y4;
  
  assign #delay Y1 = A1 | B1;
  assign #delay Y2 = A2 | B2;
  assign #delay Y3 = A3 | B3;
  assign #delay Y4 = A4 | B4;

endmodule
//: /hdlEnd


`timescale 1ns/1ns


`timescale 1ns/1ns

