# Windows precompiled headers

Using precompiled headers on Windows can speed builds up by around 25%.

Precompiled headers are used by default when GYP generates project files for
Visual Studio 2010.

When using Visual Studio 2008, use of precompiled headers is off by default (see
discussion below). To turn on precompiled headers in your client when using
MSVS 2008, make sure your `~\.gyp\include.gypi` file looks something like this,
then run `gclient runhooks` to update the solution files generated by GYP:

    {
      'variables': {
        'chromium_win_pch': 1,
      }
    }

Since [r174228](http://src.chromium.org/viewvc/chrome?view=rev&revision=174228),
default is using precompiled header for non `Official` build.

## Discussion

MSVS 2008 has some limitations in how well it handles precompiled headers.
We've run into two issues:

1.  Using precompiled headers can push our official builders over the edge of
    the world, into the dangerous Kingdom of Oom (out of memory).
1.  When compilation flags are changed, instead of doing the right thing and
    rebuilding the precompiled headers and their dependents, MSVS prints a
    warning instead, saying the precompiled header file was built with
    different flags than the current file.

Because of the above, we disabled use of precompiled headers by default, and
required the `chromium_win_pch` flag discussed above to be set.

We may be able to turn use of precompiled headers back on for Debug builds by
default, by adding a workaround to MSVS's limitations to GYP, i.e. if it detects
a change in compile flags it could blow away MSVS's output directory.

## Troubleshooting

Both of these apply to Visual Studio 2008 only.

### Precompiled header is missing

**Problem**: You didn't rebuild recently, and you want to build an individual
source file (Ctrl+F7). MSVS complains that the precompiled header is missing.

**Solution**: You could do a full build of the target your source file is in. If
you'd like to avoid that, find the precompiled header generator file, located
within a filter somewhere like `../../build/precompile.cc` in your project,
individually build that file, then individually build the source file you
intended to build. The `precompile.cc` file is the generator for the precompiled
header file.

### specified for precompiled header but not for current compile

**Problem**: MSVS prints out a warning like this (that we treat as an error):
`warning C4651: '/D_FOOBAR' specified for precompiled header but not for current
compile`

**Solution**: This means compilation flags have changed from when the
precompiled header file was generated. The issue is that MSVS does not handle
this correctly. As compilation flags may affect the precompiled header file, it
should be rebuilt along with its dependents. The workaround for now is to do a
full rebuild, or (if you want to try to be minimal) a rebuild of all projects
previously built that use precompiled headers.
