/*
 * This file is part of PhysicsFS (https://icculus.org/physfs/)
 *
 * This data generated by physfs/extras/makecasefoldhashtable.pl ...
 * Do not manually edit this file!
 *
 * Please see the file LICENSE.txt in the source's root directory.
 */

#ifndef _INCLUDE_PHYSFS_CASEFOLDING_H_
#define _INCLUDE_PHYSFS_CASEFOLDING_H_

#ifndef __PHYSICSFS_INTERNAL__
#error Do not include this header from your applications.
#endif

/* We build three simple hashmaps here: one that maps Unicode codepoints to
a one, two, or three lowercase codepoints. To retrieve this info: look at
case_fold_hashX, where X is 1, 2, or 3. Most foldable codepoints fold to one,
a few dozen fold to two, and a handful fold to three. If the codepoint isn't
in any of these hashes, it doesn't fold (no separate upper and lowercase).

Almost all these codepoints fit into 16 bits, so we hash them as such to save
memory. If a codepoint is > 0xFFFF, we have separate hashes for them,
since there are (currently) only about 120 of them and (currently) all of them
map to a single lowercase codepoint. */

typedef struct CaseFoldMapping1_32
{
    PHYSFS_uint32 from;
    PHYSFS_uint32 to0;
} CaseFoldMapping1_32;

typedef struct CaseFoldMapping1_16
{
    PHYSFS_uint16 from;
    PHYSFS_uint16 to0;
} CaseFoldMapping1_16;

typedef struct CaseFoldMapping2_16
{
    PHYSFS_uint16 from;
    PHYSFS_uint16 to0;
    PHYSFS_uint16 to1;
} CaseFoldMapping2_16;

typedef struct CaseFoldMapping3_16
{
    PHYSFS_uint16 from;
    PHYSFS_uint16 to0;
    PHYSFS_uint16 to1;
    PHYSFS_uint16 to2;
} CaseFoldMapping3_16;

typedef struct CaseFoldHashBucket1_16
{
    const CaseFoldMapping1_16 *list;
    const PHYSFS_uint8 count;
} CaseFoldHashBucket1_16;

typedef struct CaseFoldHashBucket1_32
{
    const CaseFoldMapping1_32 *list;
    const PHYSFS_uint8 count;
} CaseFoldHashBucket1_32;

typedef struct CaseFoldHashBucket2_16
{
    const CaseFoldMapping2_16 *list;
    const PHYSFS_uint8 count;
} CaseFoldHashBucket2_16;

typedef struct CaseFoldHashBucket3_16
{
    const CaseFoldMapping3_16 *list;
    const PHYSFS_uint8 count;
} CaseFoldHashBucket3_16;

static const CaseFoldMapping1_16 case_fold1_16_000[] = {
    { 0x0202, 0x0203 },
    { 0x0404, 0x0454 },
    { 0x1E1E, 0x1E1F },
    { 0x2C2C, 0x2C5C },
    { 0xABAB, 0x13DB }
};

static const CaseFoldMapping1_16 case_fold1_16_001[] = {
    { 0x0100, 0x0101 },
    { 0x0405, 0x0455 },
    { 0x0504, 0x0505 },
    { 0x2C2D, 0x2C5D },
    { 0xA7A6, 0xA7A7 },
    { 0xABAA, 0x13DA }
};

static const CaseFoldMapping1_16 case_fold1_16_002[] = {
    { 0x0200, 0x0201 },
    { 0x0406, 0x0456 },
    { 0x1E1C, 0x1E1D },
    { 0x1F1D, 0x1F15 },
    { 0x2C2E, 0x2C5E },
    { 0xABA9, 0x13D9 }
};

static const CaseFoldMapping1_16 case_fold1_16_003[] = {
    { 0x0102, 0x0103 },
    { 0x0407, 0x0457 },
    { 0x0506, 0x0507 },
    { 0x1F1C, 0x1F14 },
    { 0xA7A4, 0xA7A5 },
    { 0xABA8, 0x13D8 }
};

static const CaseFoldMapping1_16 case_fold1_16_004[] = {
    { 0x0206, 0x0207 },
    { 0x0400, 0x0450 },
    { 0x1E1A, 0x1E1B },
    { 0x1F1B, 0x1F13 },
    { 0x2C28, 0x2C58 },
    { 0xABAF, 0x13DF }
};

static const CaseFoldMapping1_16 case_fold1_16_005[] = {
    { 0x0104, 0x0105 },
    { 0x0401, 0x0451 },
    { 0x0500, 0x0501 },
    { 0x1F1A, 0x1F12 },
    { 0x2C29, 0x2C59 },
    { 0xA7A2, 0xA7A3 },
    { 0xABAE, 0x13DE }
};

static const CaseFoldMapping1_16 case_fold1_16_006[] = {
    { 0x0204, 0x0205 },
    { 0x0402, 0x0452 },
    { 0x1E18, 0x1E19 },
    { 0x1F19, 0x1F11 },
    { 0x2C2A, 0x2C5A },
    { 0xABAD, 0x13DD }
};

static const CaseFoldMapping1_16 case_fold1_16_007[] = {
    { 0x0106, 0x0107 },
    { 0x0403, 0x0453 },
    { 0x0502, 0x0503 },
    { 0x1F18, 0x1F10 },
    { 0x2126, 0x03C9 },
    { 0x2C2B, 0x2C5B },
    { 0xA7A0, 0xA7A1 },
    { 0xABAC, 0x13DC }
};

static const CaseFoldMapping1_16 case_fold1_16_008[] = {
    { 0x020A, 0x020B },
    { 0x040C, 0x045C },
    { 0x1E16, 0x1E17 },
    { 0x2C24, 0x2C54 },
    { 0xABA3, 0x13D3 }
};

static const CaseFoldMapping1_16 case_fold1_16_009[] = {
    { 0x0108, 0x0109 },
    { 0x040D, 0x045D },
    { 0x050C, 0x050D },
    { 0x2C25, 0x2C55 },
    { 0xABA2, 0x13D2 }
};

static const CaseFoldMapping1_16 case_fold1_16_010[] = {
    { 0x0208, 0x0209 },
    { 0x040E, 0x045E },
    { 0x1E14, 0x1E15 },
    { 0x212B, 0x00E5 },
    { 0x2C26, 0x2C56 },
    { 0xA7AD, 0x026C },
    { 0xABA1, 0x13D1 }
};

static const CaseFoldMapping1_16 case_fold1_16_011[] = {
    { 0x010A, 0x010B },
    { 0x040F, 0x045F },
    { 0x050E, 0x050F },
    { 0x212A, 0x006B },
    { 0x2C27, 0x2C57 },
    { 0xA7AC, 0x0261 },
    { 0xABA0, 0x13D0 }
};

static const CaseFoldMapping1_16 case_fold1_16_012[] = {
    { 0x020E, 0x020F },
    { 0x0408, 0x0458 },
    { 0x1E12, 0x1E13 },
    { 0x2C20, 0x2C50 },
    { 0xA7AB, 0x025C },
    { 0xABA7, 0x13D7 }
};

static const CaseFoldMapping1_16 case_fold1_16_013[] = {
    { 0x010C, 0x010D },
    { 0x0409, 0x0459 },
    { 0x0508, 0x0509 },
    { 0x2C21, 0x2C51 },
    { 0xA7AA, 0x0266 },
    { 0xABA6, 0x13D6 }
};

static const CaseFoldMapping1_16 case_fold1_16_014[] = {
    { 0x020C, 0x020D },
    { 0x040A, 0x045A },
    { 0x1E10, 0x1E11 },
    { 0x2C22, 0x2C52 },
    { 0xABA5, 0x13D5 }
};

static const CaseFoldMapping1_16 case_fold1_16_015[] = {
    { 0x010E, 0x010F },
    { 0x040B, 0x045B },
    { 0x050A, 0x050B },
    { 0x2C23, 0x2C53 },
    { 0xA7A8, 0xA7A9 },
    { 0xABA4, 0x13D4 }
};

static const CaseFoldMapping1_16 case_fold1_16_016[] = {
    { 0x0212, 0x0213 },
    { 0x0414, 0x0434 },
    { 0x1E0E, 0x1E0F },
    { 0x1F0F, 0x1F07 },
    { 0xABBB, 0x13EB }
};

static const CaseFoldMapping1_16 case_fold1_16_017[] = {
    { 0x0110, 0x0111 },
    { 0x0415, 0x0435 },
    { 0x0514, 0x0515 },
    { 0x1F0E, 0x1F06 },
    { 0xA7B6, 0xA7B7 },
    { 0xABBA, 0x13EA }
};

static const CaseFoldMapping1_16 case_fold1_16_018[] = {
    { 0x0210, 0x0211 },
    { 0x0416, 0x0436 },
    { 0x1E0C, 0x1E0D },
    { 0x1F0D, 0x1F05 },
    { 0xABB9, 0x13E9 }
};

static const CaseFoldMapping1_16 case_fold1_16_019[] = {
    { 0x0112, 0x0113 },
    { 0x0417, 0x0437 },
    { 0x0516, 0x0517 },
    { 0x1F0C, 0x1F04 },
    { 0x2132, 0x214E },
    { 0xA7B4, 0xA7B5 },
    { 0xABB8, 0x13E8 }
};

static const CaseFoldMapping1_16 case_fold1_16_020[] = {
    { 0x0216, 0x0217 },
    { 0x0410, 0x0430 },
    { 0x1E0A, 0x1E0B },
    { 0x1F0B, 0x1F03 },
    { 0xA7B3, 0xAB53 },
    { 0xABBF, 0x13EF }
};

static const CaseFoldMapping1_16 case_fold1_16_021[] = {
    { 0x0114, 0x0115 },
    { 0x0411, 0x0431 },
    { 0x0510, 0x0511 },
    { 0x1F0A, 0x1F02 },
    { 0xA7B2, 0x029D },
    { 0xABBE, 0x13EE }
};

static const CaseFoldMapping1_16 case_fold1_16_022[] = {
    { 0x0214, 0x0215 },
    { 0x0412, 0x0432 },
    { 0x1E08, 0x1E09 },
    { 0x1F09, 0x1F01 },
    { 0xA7B1, 0x0287 },
    { 0xABBD, 0x13ED }
};

static const CaseFoldMapping1_16 case_fold1_16_023[] = {
    { 0x0116, 0x0117 },
    { 0x0413, 0x0433 },
    { 0x0512, 0x0513 },
    { 0x1F08, 0x1F00 },
    { 0xA7B0, 0x029E },
    { 0xABBC, 0x13EC }
};

static const CaseFoldMapping1_16 case_fold1_16_024[] = {
    { 0x021A, 0x021B },
    { 0x041C, 0x043C },
    { 0x1E06, 0x1E07 },
    { 0xABB3, 0x13E3 }
};

static const CaseFoldMapping1_16 case_fold1_16_025[] = {
    { 0x0118, 0x0119 },
    { 0x041D, 0x043D },
    { 0x051C, 0x051D },
    { 0xABB2, 0x13E2 }
};

static const CaseFoldMapping1_16 case_fold1_16_026[] = {
    { 0x0218, 0x0219 },
    { 0x041E, 0x043E },
    { 0x1E04, 0x1E05 },
    { 0xABB1, 0x13E1 }
};

static const CaseFoldMapping1_16 case_fold1_16_027[] = {
    { 0x011A, 0x011B },
    { 0x041F, 0x043F },
    { 0x051E, 0x051F },
    { 0xABB0, 0x13E0 }
};

static const CaseFoldMapping1_16 case_fold1_16_028[] = {
    { 0x021E, 0x021F },
    { 0x0418, 0x0438 },
    { 0x1E02, 0x1E03 },
    { 0xABB7, 0x13E7 }
};

static const CaseFoldMapping1_16 case_fold1_16_029[] = {
    { 0x011C, 0x011D },
    { 0x0419, 0x0439 },
    { 0x0518, 0x0519 },
    { 0xABB6, 0x13E6 }
};

static const CaseFoldMapping1_16 case_fold1_16_030[] = {
    { 0x021C, 0x021D },
    { 0x041A, 0x043A },
    { 0x1E00, 0x1E01 },
    { 0xABB5, 0x13E5 }
};

static const CaseFoldMapping1_16 case_fold1_16_031[] = {
    { 0x011E, 0x011F },
    { 0x041B, 0x043B },
    { 0x051A, 0x051B },
    { 0xABB4, 0x13E4 }
};

static const CaseFoldMapping1_16 case_fold1_16_032[] = {
    { 0x0222, 0x0223 },
    { 0x0424, 0x0444 },
    { 0x1E3E, 0x1E3F },
    { 0x1F3F, 0x1F37 },
    { 0x2C0C, 0x2C3C },
    { 0xA686, 0xA687 },
    { 0xAB8B, 0x13BB }
};

static const CaseFoldMapping1_16 case_fold1_16_033[] = {
    { 0x0120, 0x0121 },
    { 0x0425, 0x0445 },
    { 0x0524, 0x0525 },
    { 0x1F3E, 0x1F36 },
    { 0x2C0D, 0x2C3D },
    { 0xA786, 0xA787 },
    { 0xAB8A, 0x13BA }
};

static const CaseFoldMapping1_16 case_fold1_16_034[] = {
    { 0x0220, 0x019E },
    { 0x0426, 0x0446 },
    { 0x1E3C, 0x1E3D },
    { 0x1F3D, 0x1F35 },
    { 0x2C0E, 0x2C3E },
    { 0xA684, 0xA685 },
    { 0xAB89, 0x13B9 }
};

static const CaseFoldMapping1_16 case_fold1_16_035[] = {
    { 0x0122, 0x0123 },
    { 0x0427, 0x0447 },
    { 0x0526, 0x0527 },
    { 0x1F3C, 0x1F34 },
    { 0x2C0F, 0x2C3F },
    { 0xA784, 0xA785 },
    { 0xAB88, 0x13B8 }
};

static const CaseFoldMapping1_16 case_fold1_16_036[] = {
    { 0x0226, 0x0227 },
    { 0x0420, 0x0440 },
    { 0x1E3A, 0x1E3B },
    { 0x1F3B, 0x1F33 },
    { 0x2C08, 0x2C38 },
    { 0xA682, 0xA683 },
    { 0xAB8F, 0x13BF }
};

static const CaseFoldMapping1_16 case_fold1_16_037[] = {
    { 0x0124, 0x0125 },
    { 0x0421, 0x0441 },
    { 0x0520, 0x0521 },
    { 0x1F3A, 0x1F32 },
    { 0x2C09, 0x2C39 },
    { 0xA782, 0xA783 },
    { 0xAB8E, 0x13BE }
};

static const CaseFoldMapping1_16 case_fold1_16_038[] = {
    { 0x0224, 0x0225 },
    { 0x0422, 0x0442 },
    { 0x1E38, 0x1E39 },
    { 0x1F39, 0x1F31 },
    { 0x2C0A, 0x2C3A },
    { 0xA680, 0xA681 },
    { 0xAB8D, 0x13BD }
};

static const CaseFoldMapping1_16 case_fold1_16_039[] = {
    { 0x0126, 0x0127 },
    { 0x0423, 0x0443 },
    { 0x0522, 0x0523 },
    { 0x1F38, 0x1F30 },
    { 0x2C0B, 0x2C3B },
    { 0xA780, 0xA781 },
    { 0xAB8C, 0x13BC }
};

static const CaseFoldMapping1_16 case_fold1_16_040[] = {
    { 0x022A, 0x022B },
    { 0x042C, 0x044C },
    { 0x1E36, 0x1E37 },
    { 0x2C04, 0x2C34 },
    { 0xA68E, 0xA68F },
    { 0xAB83, 0x13B3 }
};

static const CaseFoldMapping1_16 case_fold1_16_041[] = {
    { 0x0128, 0x0129 },
    { 0x042D, 0x044D },
    { 0x052C, 0x052D },
    { 0x2C05, 0x2C35 },
    { 0xAB82, 0x13B2 }
};

static const CaseFoldMapping1_16 case_fold1_16_042[] = {
    { 0x0228, 0x0229 },
    { 0x042E, 0x044E },
    { 0x1E34, 0x1E35 },
    { 0x2C06, 0x2C36 },
    { 0xA68C, 0xA68D },
    { 0xA78D, 0x0265 },
    { 0xAB81, 0x13B1 }
};

static const CaseFoldMapping1_16 case_fold1_16_043[] = {
    { 0x012A, 0x012B },
    { 0x042F, 0x044F },
    { 0x052E, 0x052F },
    { 0x2C07, 0x2C37 },
    { 0xAB80, 0x13B0 }
};

static const CaseFoldMapping1_16 case_fold1_16_044[] = {
    { 0x022E, 0x022F },
    { 0x0428, 0x0448 },
    { 0x1E32, 0x1E33 },
    { 0x2C00, 0x2C30 },
    { 0xA68A, 0xA68B },
    { 0xA78B, 0xA78C },
    { 0xAB87, 0x13B7 }
};

static const CaseFoldMapping1_16 case_fold1_16_045[] = {
    { 0x012C, 0x012D },
    { 0x0429, 0x0449 },
    { 0x0528, 0x0529 },
    { 0x2C01, 0x2C31 },
    { 0xAB86, 0x13B6 }
};

static const CaseFoldMapping1_16 case_fold1_16_046[] = {
    { 0x022C, 0x022D },
    { 0x042A, 0x044A },
    { 0x1E30, 0x1E31 },
    { 0x2C02, 0x2C32 },
    { 0xA688, 0xA689 },
    { 0xAB85, 0x13B5 }
};

static const CaseFoldMapping1_16 case_fold1_16_047[] = {
    { 0x012E, 0x012F },
    { 0x042B, 0x044B },
    { 0x052A, 0x052B },
    { 0x2C03, 0x2C33 },
    { 0xAB84, 0x13B4 }
};

static const CaseFoldMapping1_16 case_fold1_16_048[] = {
    { 0x0232, 0x0233 },
    { 0x0535, 0x0565 },
    { 0x1E2E, 0x1E2F },
    { 0x1F2F, 0x1F27 },
    { 0x2C1C, 0x2C4C },
    { 0xA696, 0xA697 },
    { 0xAB9B, 0x13CB }
};

static const CaseFoldMapping1_16 case_fold1_16_049[] = {
    { 0x0534, 0x0564 },
    { 0x1F2E, 0x1F26 },
    { 0x2C1D, 0x2C4D },
    { 0xA796, 0xA797 },
    { 0xAB9A, 0x13CA }
};

static const CaseFoldMapping1_16 case_fold1_16_050[] = {
    { 0x0230, 0x0231 },
    { 0x0537, 0x0567 },
    { 0x1E2C, 0x1E2D },
    { 0x1F2D, 0x1F25 },
    { 0x2C1E, 0x2C4E },
    { 0xA694, 0xA695 },
    { 0xAB99, 0x13C9 }
};

static const CaseFoldMapping1_16 case_fold1_16_051[] = {
    { 0x0132, 0x0133 },
    { 0x0536, 0x0566 },
    { 0x1F2C, 0x1F24 },
    { 0x2C1F, 0x2C4F },
    { 0xAB98, 0x13C8 }
};

static const CaseFoldMapping1_16 case_fold1_16_052[] = {
    { 0x0531, 0x0561 },
    { 0x1E2A, 0x1E2B },
    { 0x1F2B, 0x1F23 },
    { 0x2C18, 0x2C48 },
    { 0xA692, 0xA693 },
    { 0xAB9F, 0x13CF }
};

static const CaseFoldMapping1_16 case_fold1_16_053[] = {
    { 0x0134, 0x0135 },
    { 0x1F2A, 0x1F22 },
    { 0x2C19, 0x2C49 },
    { 0xA792, 0xA793 },
    { 0xAB9E, 0x13CE }
};

static const CaseFoldMapping1_16 case_fold1_16_054[] = {
    { 0x0533, 0x0563 },
    { 0x1E28, 0x1E29 },
    { 0x1F29, 0x1F21 },
    { 0x2C1A, 0x2C4A },
    { 0xA690, 0xA691 },
    { 0xAB9D, 0x13CD }
};

static const CaseFoldMapping1_16 case_fold1_16_055[] = {
    { 0x0136, 0x0137 },
    { 0x0532, 0x0562 },
    { 0x1F28, 0x1F20 },
    { 0x2C1B, 0x2C4B },
    { 0xA790, 0xA791 },
    { 0xAB9C, 0x13CC }
};

static const CaseFoldMapping1_16 case_fold1_16_056[] = {
    { 0x0139, 0x013A },
    { 0x023A, 0x2C65 },
    { 0x053D, 0x056D },
    { 0x1E26, 0x1E27 },
    { 0x2C14, 0x2C44 },
    { 0xAB93, 0x13C3 }
};

static const CaseFoldMapping1_16 case_fold1_16_057[] = {
    { 0x023B, 0x023C },
    { 0x053C, 0x056C },
    { 0x2C15, 0x2C45 },
    { 0xA79E, 0xA79F },
    { 0xAB92, 0x13C2 }
};

static const CaseFoldMapping1_16 case_fold1_16_058[] = {
    { 0x013B, 0x013C },
    { 0x053F, 0x056F },
    { 0x1E24, 0x1E25 },
    { 0x2C16, 0x2C46 },
    { 0xAB91, 0x13C1 }
};

static const CaseFoldMapping1_16 case_fold1_16_059[] = {
    { 0x053E, 0x056E },
    { 0x2C17, 0x2C47 },
    { 0xA79C, 0xA79D },
    { 0xAB90, 0x13C0 }
};

static const CaseFoldMapping1_16 case_fold1_16_060[] = {
    { 0x013D, 0x013E },
    { 0x023E, 0x2C66 },
    { 0x0539, 0x0569 },
    { 0x1E22, 0x1E23 },
    { 0x2C10, 0x2C40 },
    { 0xA69A, 0xA69B },
    { 0xAB97, 0x13C7 }
};

static const CaseFoldMapping1_16 case_fold1_16_061[] = {
    { 0x0538, 0x0568 },
    { 0x2C11, 0x2C41 },
    { 0xA79A, 0xA79B },
    { 0xAB96, 0x13C6 }
};

static const CaseFoldMapping1_16 case_fold1_16_062[] = {
    { 0x013F, 0x0140 },
    { 0x053B, 0x056B },
    { 0x1E20, 0x1E21 },
    { 0x2C12, 0x2C42 },
    { 0xA698, 0xA699 },
    { 0xAB95, 0x13C5 }
};

static const CaseFoldMapping1_16 case_fold1_16_063[] = {
    { 0x023D, 0x019A },
    { 0x053A, 0x056A },
    { 0x2C13, 0x2C43 },
    { 0xA798, 0xA799 },
    { 0xAB94, 0x13C4 }
};

static const CaseFoldMapping1_16 case_fold1_16_064[] = {
    { 0x0141, 0x0142 },
    { 0x0545, 0x0575 },
    { 0x1E5E, 0x1E5F },
    { 0x1F5F, 0x1F57 },
    { 0x2161, 0x2171 }
};

static const CaseFoldMapping1_16 case_fold1_16_065[] = {
    { 0x0041, 0x0061 },
    { 0x0243, 0x0180 },
    { 0x0544, 0x0574 },
    { 0x2160, 0x2170 },
    { 0x2C6D, 0x0251 }
};

static const CaseFoldMapping1_16 case_fold1_16_066[] = {
    { 0x0042, 0x0062 },
    { 0x0143, 0x0144 },
    { 0x0547, 0x0577 },
    { 0x1E5C, 0x1E5D },
    { 0x1F5D, 0x1F55 },
    { 0x2163, 0x2173 },
    { 0x2C6E, 0x0271 }
};

static const CaseFoldMapping1_16 case_fold1_16_067[] = {
    { 0x0043, 0x0063 },
    { 0x0241, 0x0242 },
    { 0x0546, 0x0576 },
    { 0x2162, 0x2172 },
    { 0x2C6F, 0x0250 }
};

static const CaseFoldMapping1_16 case_fold1_16_068[] = {
    { 0x0044, 0x0064 },
    { 0x0145, 0x0146 },
    { 0x0246, 0x0247 },
    { 0x0541, 0x0571 },
    { 0x1E5A, 0x1E5B },
    { 0x1F5B, 0x1F53 },
    { 0x2165, 0x2175 }
};

static const CaseFoldMapping1_16 case_fold1_16_069[] = {
    { 0x0045, 0x0065 },
    { 0x0540, 0x0570 },
    { 0x2164, 0x2174 },
    { 0x2C69, 0x2C6A }
};

static const CaseFoldMapping1_16 case_fold1_16_070[] = {
    { 0x0046, 0x0066 },
    { 0x0147, 0x0148 },
    { 0x0244, 0x0289 },
    { 0x0345, 0x03B9 },
    { 0x0543, 0x0573 },
    { 0x1E58, 0x1E59 },
    { 0x1F59, 0x1F51 },
    { 0x2167, 0x2177 }
};

static const CaseFoldMapping1_16 case_fold1_16_071[] = {
    { 0x0047, 0x0067 },
    { 0x0245, 0x028C },
    { 0x0542, 0x0572 },
    { 0x2166, 0x2176 },
    { 0x2C6B, 0x2C6C }
};

static const CaseFoldMapping1_16 case_fold1_16_072[] = {
    { 0x0048, 0x0068 },
    { 0x024A, 0x024B },
    { 0x054D, 0x057D },
    { 0x1E56, 0x1E57 },
    { 0x2169, 0x2179 },
    { 0x2C64, 0x027D }
};

static const CaseFoldMapping1_16 case_fold1_16_073[] = {
    { 0x0049, 0x0069 },
    { 0x054C, 0x057C },
    { 0x2168, 0x2178 }
};

static const CaseFoldMapping1_16 case_fold1_16_074[] = {
    { 0x004A, 0x006A },
    { 0x0248, 0x0249 },
    { 0x054F, 0x057F },
    { 0x1E54, 0x1E55 },
    { 0x216B, 0x217B }
};

static const CaseFoldMapping1_16 case_fold1_16_075[] = {
    { 0x004B, 0x006B },
    { 0x014A, 0x014B },
    { 0x054E, 0x057E },
    { 0x216A, 0x217A },
    { 0x2C67, 0x2C68 }
};

static const CaseFoldMapping1_16 case_fold1_16_076[] = {
    { 0x004C, 0x006C },
    { 0x024E, 0x024F },
    { 0x0549, 0x0579 },
    { 0x1E52, 0x1E53 },
    { 0x216D, 0x217D },
    { 0x2C60, 0x2C61 }
};

static const CaseFoldMapping1_16 case_fold1_16_077[] = {
    { 0x004D, 0x006D },
    { 0x014C, 0x014D },
    { 0x0548, 0x0578 },
    { 0x216C, 0x217C }
};

static const CaseFoldMapping1_16 case_fold1_16_078[] = {
    { 0x004E, 0x006E },
    { 0x024C, 0x024D },
    { 0x054B, 0x057B },
    { 0x1E50, 0x1E51 },
    { 0x216F, 0x217F },
    { 0x2C62, 0x026B }
};

static const CaseFoldMapping1_16 case_fold1_16_079[] = {
    { 0x004F, 0x006F },
    { 0x014E, 0x014F },
    { 0x054A, 0x057A },
    { 0x216E, 0x217E },
    { 0x2C63, 0x1D7D }
};

static const CaseFoldMapping1_16 case_fold1_16_080[] = {
    { 0x0050, 0x0070 },
    { 0x0555, 0x0585 },
    { 0x1E4E, 0x1E4F }
};

static const CaseFoldMapping1_16 case_fold1_16_081[] = {
    { 0x0051, 0x0071 },
    { 0x0150, 0x0151 },
    { 0x0554, 0x0584 }
};

static const CaseFoldMapping1_16 case_fold1_16_082[] = {
    { 0x0052, 0x0072 },
    { 0x1E4C, 0x1E4D },
    { 0x1F4D, 0x1F45 },
    { 0x2C7E, 0x023F }
};

static const CaseFoldMapping1_16 case_fold1_16_083[] = {
    { 0x0053, 0x0073 },
    { 0x0152, 0x0153 },
    { 0x0556, 0x0586 },
    { 0x1F4C, 0x1F44 },
    { 0x2C7F, 0x0240 }
};

static const CaseFoldMapping1_16 case_fold1_16_084[] = {
    { 0x0054, 0x0074 },
    { 0x0551, 0x0581 },
    { 0x1E4A, 0x1E4B },
    { 0x1F4B, 0x1F43 }
};

static const CaseFoldMapping1_16 case_fold1_16_085[] = {
    { 0x0055, 0x0075 },
    { 0x0154, 0x0155 },
    { 0x0550, 0x0580 },
    { 0x1F4A, 0x1F42 }
};

static const CaseFoldMapping1_16 case_fold1_16_086[] = {
    { 0x0056, 0x0076 },
    { 0x0553, 0x0583 },
    { 0x1E48, 0x1E49 },
    { 0x1F49, 0x1F41 }
};

static const CaseFoldMapping1_16 case_fold1_16_087[] = {
    { 0x0057, 0x0077 },
    { 0x0156, 0x0157 },
    { 0x0552, 0x0582 },
    { 0x1F48, 0x1F40 }
};

static const CaseFoldMapping1_16 case_fold1_16_088[] = {
    { 0x0058, 0x0078 },
    { 0x1E46, 0x1E47 }
};

static const CaseFoldMapping1_16 case_fold1_16_089[] = {
    { 0x0059, 0x0079 },
    { 0x0158, 0x0159 },
    { 0x2C75, 0x2C76 }
};

static const CaseFoldMapping1_16 case_fold1_16_090[] = {
    { 0x005A, 0x007A },
    { 0x1E44, 0x1E45 }
};

static const CaseFoldMapping1_16 case_fold1_16_091[] = {
    { 0x015A, 0x015B }
};

static const CaseFoldMapping1_16 case_fold1_16_092[] = {
    { 0x1E42, 0x1E43 },
    { 0x2C70, 0x0252 }
};

static const CaseFoldMapping1_16 case_fold1_16_093[] = {
    { 0x015C, 0x015D }
};

static const CaseFoldMapping1_16 case_fold1_16_094[] = {
    { 0x1E40, 0x1E41 },
    { 0x2C72, 0x2C73 }
};

static const CaseFoldMapping1_16 case_fold1_16_095[] = {
    { 0x015E, 0x015F }
};

static const CaseFoldMapping1_16 case_fold1_16_096[] = {
    { 0x0464, 0x0465 },
    { 0x1E7E, 0x1E7F }
};

static const CaseFoldMapping1_16 case_fold1_16_097[] = {
    { 0x0160, 0x0161 }
};

static const CaseFoldMapping1_16 case_fold1_16_098[] = {
    { 0x0466, 0x0467 },
    { 0x1E7C, 0x1E7D }
};

static const CaseFoldMapping1_16 case_fold1_16_099[] = {
    { 0x0162, 0x0163 }
};

static const CaseFoldMapping1_16 case_fold1_16_100[] = {
    { 0x0460, 0x0461 },
    { 0x1E7A, 0x1E7B }
};

static const CaseFoldMapping1_16 case_fold1_16_101[] = {
    { 0x0164, 0x0165 }
};

static const CaseFoldMapping1_16 case_fold1_16_102[] = {
    { 0x0462, 0x0463 },
    { 0x1E78, 0x1E79 }
};

static const CaseFoldMapping1_16 case_fold1_16_103[] = {
    { 0x0166, 0x0167 }
};

static const CaseFoldMapping1_16 case_fold1_16_104[] = {
    { 0x046C, 0x046D },
    { 0x1E76, 0x1E77 }
};

static const CaseFoldMapping1_16 case_fold1_16_105[] = {
    { 0x0168, 0x0169 }
};

static const CaseFoldMapping1_16 case_fold1_16_106[] = {
    { 0x046E, 0x046F },
    { 0x1E74, 0x1E75 }
};

static const CaseFoldMapping1_16 case_fold1_16_107[] = {
    { 0x016A, 0x016B }
};

static const CaseFoldMapping1_16 case_fold1_16_108[] = {
    { 0x0468, 0x0469 },
    { 0x1E72, 0x1E73 }
};

static const CaseFoldMapping1_16 case_fold1_16_109[] = {
    { 0x016C, 0x016D }
};

static const CaseFoldMapping1_16 case_fold1_16_110[] = {
    { 0x046A, 0x046B },
    { 0x1E70, 0x1E71 }
};

static const CaseFoldMapping1_16 case_fold1_16_111[] = {
    { 0x016E, 0x016F }
};

static const CaseFoldMapping1_16 case_fold1_16_112[] = {
    { 0x0474, 0x0475 },
    { 0x1E6E, 0x1E6F },
    { 0x1F6F, 0x1F67 }
};

static const CaseFoldMapping1_16 case_fold1_16_113[] = {
    { 0x0170, 0x0171 },
    { 0x0372, 0x0373 },
    { 0x1F6E, 0x1F66 }
};

static const CaseFoldMapping1_16 case_fold1_16_114[] = {
    { 0x0476, 0x0477 },
    { 0x1E6C, 0x1E6D },
    { 0x1F6D, 0x1F65 }
};

static const CaseFoldMapping1_16 case_fold1_16_115[] = {
    { 0x0172, 0x0173 },
    { 0x0370, 0x0371 },
    { 0x1F6C, 0x1F64 }
};

static const CaseFoldMapping1_16 case_fold1_16_116[] = {
    { 0x0470, 0x0471 },
    { 0x1E6A, 0x1E6B },
    { 0x1F6B, 0x1F63 }
};

static const CaseFoldMapping1_16 case_fold1_16_117[] = {
    { 0x0174, 0x0175 },
    { 0x0376, 0x0377 },
    { 0x1F6A, 0x1F62 }
};

static const CaseFoldMapping1_16 case_fold1_16_118[] = {
    { 0x0472, 0x0473 },
    { 0x1E68, 0x1E69 },
    { 0x1F69, 0x1F61 }
};

static const CaseFoldMapping1_16 case_fold1_16_119[] = {
    { 0x0176, 0x0177 },
    { 0x1F68, 0x1F60 }
};

static const CaseFoldMapping1_16 case_fold1_16_120[] = {
    { 0x0179, 0x017A },
    { 0x047C, 0x047D },
    { 0x1E66, 0x1E67 }
};

static const CaseFoldMapping1_16 case_fold1_16_121[] = {
    { 0x0178, 0x00FF }
};

static const CaseFoldMapping1_16 case_fold1_16_122[] = {
    { 0x017B, 0x017C },
    { 0x047E, 0x047F },
    { 0x1E64, 0x1E65 }
};

static const CaseFoldMapping1_16 case_fold1_16_124[] = {
    { 0x017D, 0x017E },
    { 0x037F, 0x03F3 },
    { 0x0478, 0x0479 },
    { 0x1E62, 0x1E63 }
};

static const CaseFoldMapping1_16 case_fold1_16_126[] = {
    { 0x017F, 0x0073 },
    { 0x047A, 0x047B },
    { 0x1E60, 0x1E61 }
};

static const CaseFoldMapping1_16 case_fold1_16_128[] = {
    { 0x0181, 0x0253 },
    { 0x2CAC, 0x2CAD }
};

static const CaseFoldMapping1_16 case_fold1_16_129[] = {
    { 0xA726, 0xA727 }
};

static const CaseFoldMapping1_16 case_fold1_16_130[] = {
    { 0x2CAE, 0x2CAF }
};

static const CaseFoldMapping1_16 case_fold1_16_131[] = {
    { 0x0182, 0x0183 },
    { 0xA724, 0xA725 }
};

static const CaseFoldMapping1_16 case_fold1_16_132[] = {
    { 0x0480, 0x0481 },
    { 0x2CA8, 0x2CA9 }
};

static const CaseFoldMapping1_16 case_fold1_16_133[] = {
    { 0x0184, 0x0185 },
    { 0x0386, 0x03AC },
    { 0x1E9B, 0x1E61 },
    { 0xA722, 0xA723 }
};

static const CaseFoldMapping1_16 case_fold1_16_134[] = {
    { 0x0187, 0x0188 },
    { 0x2CAA, 0x2CAB }
};

static const CaseFoldMapping1_16 case_fold1_16_135[] = {
    { 0x0186, 0x0254 }
};

static const CaseFoldMapping1_16 case_fold1_16_136[] = {
    { 0x0189, 0x0256 },
    { 0x048C, 0x048D },
    { 0x2CA4, 0x2CA5 }
};

static const CaseFoldMapping1_16 case_fold1_16_137[] = {
    { 0x038A, 0x03AF },
    { 0xA72E, 0xA72F }
};

static const CaseFoldMapping1_16 case_fold1_16_138[] = {
    { 0x018B, 0x018C },
    { 0x0389, 0x03AE },
    { 0x048E, 0x048F },
    { 0x1E94, 0x1E95 },
    { 0x2CA6, 0x2CA7 }
};

static const CaseFoldMapping1_16 case_fold1_16_139[] = {
    { 0x018A, 0x0257 },
    { 0x0388, 0x03AD },
    { 0xA72C, 0xA72D }
};

static const CaseFoldMapping1_16 case_fold1_16_140[] = {
    { 0x038F, 0x03CE },
    { 0x1E92, 0x1E93 },
    { 0x2CA0, 0x2CA1 }
};

static const CaseFoldMapping1_16 case_fold1_16_141[] = {
    { 0x038E, 0x03CD },
    { 0xA72A, 0xA72B }
};

static const CaseFoldMapping1_16 case_fold1_16_142[] = {
    { 0x018F, 0x0259 },
    { 0x048A, 0x048B },
    { 0x1E90, 0x1E91 },
    { 0x2CA2, 0x2CA3 }
};

static const CaseFoldMapping1_16 case_fold1_16_143[] = {
    { 0x018E, 0x01DD },
    { 0x038C, 0x03CC },
    { 0xA728, 0xA729 }
};

static const CaseFoldMapping1_16 case_fold1_16_144[] = {
    { 0x0191, 0x0192 },
    { 0x0393, 0x03B3 },
    { 0x0494, 0x0495 },
    { 0x1E8E, 0x1E8F },
    { 0x2CBC, 0x2CBD }
};

static const CaseFoldMapping1_16 case_fold1_16_145[] = {
    { 0x0190, 0x025B },
    { 0x0392, 0x03B2 },
    { 0xA736, 0xA737 }
};

static const CaseFoldMapping1_16 case_fold1_16_146[] = {
    { 0x0193, 0x0260 },
    { 0x0391, 0x03B1 },
    { 0x0496, 0x0497 },
    { 0x1E8C, 0x1E8D },
    { 0x24B6, 0x24D0 },
    { 0x2CBE, 0x2CBF }
};

static const CaseFoldMapping1_16 case_fold1_16_147[] = {
    { 0x24B7, 0x24D1 },
    { 0xA734, 0xA735 }
};

static const CaseFoldMapping1_16 case_fold1_16_148[] = {
    { 0x0397, 0x03B7 },
    { 0x0490, 0x0491 },
    { 0x1E8A, 0x1E8B },
    { 0x2CB8, 0x2CB9 }
};

static const CaseFoldMapping1_16 case_fold1_16_149[] = {
    { 0x0194, 0x0263 },
    { 0x0396, 0x03B6 },
    { 0xA732, 0xA733 }
};

static const CaseFoldMapping1_16 case_fold1_16_150[] = {
    { 0x0197, 0x0268 },
    { 0x0395, 0x03B5 },
    { 0x0492, 0x0493 },
    { 0x1E88, 0x1E89 },
    { 0x2CBA, 0x2CBB }
};

static const CaseFoldMapping1_16 case_fold1_16_151[] = {
    { 0x0196, 0x0269 },
    { 0x0394, 0x03B4 }
};

static const CaseFoldMapping1_16 case_fold1_16_152[] = {
    { 0x039B, 0x03BB },
    { 0x049C, 0x049D },
    { 0x1E86, 0x1E87 },
    { 0x24BC, 0x24D6 },
    { 0x2CB4, 0x2CB5 }
};

static const CaseFoldMapping1_16 case_fold1_16_153[] = {
    { 0x0198, 0x0199 },
    { 0x039A, 0x03BA },
    { 0x24BD, 0x24D7 },
    { 0xA73E, 0xA73F }
};

static const CaseFoldMapping1_16 case_fold1_16_154[] = {
    { 0x0399, 0x03B9 },
    { 0x049E, 0x049F },
    { 0x1E84, 0x1E85 },
    { 0x24BE, 0x24D8 },
    { 0x2CB6, 0x2CB7 }
};

static const CaseFoldMapping1_16 case_fold1_16_155[] = {
    { 0x0398, 0x03B8 },
    { 0x24BF, 0x24D9 },
    { 0xA73C, 0xA73D }
};

static const CaseFoldMapping1_16 case_fold1_16_156[] = {
    { 0x019D, 0x0272 },
    { 0x039F, 0x03BF },
    { 0x0498, 0x0499 },
    { 0x1E82, 0x1E83 },
    { 0x24B8, 0x24D2 },
    { 0x2CB0, 0x2CB1 }
};

static const CaseFoldMapping1_16 case_fold1_16_157[] = {
    { 0x019C, 0x026F },
    { 0x039E, 0x03BE },
    { 0x24B9, 0x24D3 },
    { 0xA73A, 0xA73B }
};

static const CaseFoldMapping1_16 case_fold1_16_158[] = {
    { 0x019F, 0x0275 },
    { 0x039D, 0x03BD },
    { 0x049A, 0x049B },
    { 0x1E80, 0x1E81 },
    { 0x24BA, 0x24D4 },
    { 0x2CB2, 0x2CB3 }
};

static const CaseFoldMapping1_16 case_fold1_16_159[] = {
    { 0x039C, 0x03BC },
    { 0x24BB, 0x24D5 },
    { 0xA738, 0xA739 }
};

static const CaseFoldMapping1_16 case_fold1_16_160[] = {
    { 0x03A3, 0x03C3 },
    { 0x04A4, 0x04A5 },
    { 0x10B0, 0x2D10 },
    { 0x1EBE, 0x1EBF },
    { 0x2C8C, 0x2C8D }
};

static const CaseFoldMapping1_16 case_fold1_16_161[] = {
    { 0x01A0, 0x01A1 },
    { 0x10B1, 0x2D11 },
    { 0x1FBE, 0x03B9 }
};

static const CaseFoldMapping1_16 case_fold1_16_162[] = {
    { 0x03A1, 0x03C1 },
    { 0x04A6, 0x04A7 },
    { 0x10B2, 0x2D12 },
    { 0x1EBC, 0x1EBD },
    { 0x2183, 0x2184 },
    { 0x2C8E, 0x2C8F }
};

static const CaseFoldMapping1_16 case_fold1_16_163[] = {
    { 0x01A2, 0x01A3 },
    { 0x03A0, 0x03C0 },
    { 0x10B3, 0x2D13 }
};

static const CaseFoldMapping1_16 case_fold1_16_164[] = {
    { 0x03A7, 0x03C7 },
    { 0x04A0, 0x04A1 },
    { 0x10B4, 0x2D14 },
    { 0x1EBA, 0x1EBB },
    { 0x1FBB, 0x1F71 },
    { 0x2C88, 0x2C89 }
};

static const CaseFoldMapping1_16 case_fold1_16_165[] = {
    { 0x01A4, 0x01A5 },
    { 0x03A6, 0x03C6 },
    { 0x10B5, 0x2D15 },
    { 0x1FBA, 0x1F70 }
};

static const CaseFoldMapping1_16 case_fold1_16_166[] = {
    { 0x01A7, 0x01A8 },
    { 0x03A5, 0x03C5 },
    { 0x04A2, 0x04A3 },
    { 0x10B6, 0x2D16 },
    { 0x1EB8, 0x1EB9 },
    { 0x1FB9, 0x1FB1 },
    { 0x2C8A, 0x2C8B }
};

static const CaseFoldMapping1_16 case_fold1_16_167[] = {
    { 0x01A6, 0x0280 },
    { 0x03A4, 0x03C4 },
    { 0x10B7, 0x2D17 },
    { 0x1FB8, 0x1FB0 }
};

static const CaseFoldMapping1_16 case_fold1_16_168[] = {
    { 0x01A9, 0x0283 },
    { 0x03AB, 0x03CB },
    { 0x04AC, 0x04AD },
    { 0x10B8, 0x2D18 },
    { 0x1EB6, 0x1EB7 },
    { 0x2C84, 0x2C85 }
};

static const CaseFoldMapping1_16 case_fold1_16_169[] = {
    { 0x03AA, 0x03CA },
    { 0x10B9, 0x2D19 }
};

static const CaseFoldMapping1_16 case_fold1_16_170[] = {
    { 0x03A9, 0x03C9 },
    { 0x04AE, 0x04AF },
    { 0x10BA, 0x2D1A },
    { 0x1EB4, 0x1EB5 },
    { 0x2C86, 0x2C87 }
};

static const CaseFoldMapping1_16 case_fold1_16_171[] = {
    { 0x03A8, 0x03C8 },
    { 0x10BB, 0x2D1B }
};

static const CaseFoldMapping1_16 case_fold1_16_172[] = {
    { 0x04A8, 0x04A9 },
    { 0x10BC, 0x2D1C },
    { 0x1EB2, 0x1EB3 },
    { 0x2C80, 0x2C81 }
};

static const CaseFoldMapping1_16 case_fold1_16_173[] = {
    { 0x01AC, 0x01AD },
    { 0x10BD, 0x2D1D }
};

static const CaseFoldMapping1_16 case_fold1_16_174[] = {
    { 0x01AF, 0x01B0 },
    { 0x04AA, 0x04AB },
    { 0x10BE, 0x2D1E },
    { 0x1EB0, 0x1EB1 },
    { 0x2C82, 0x2C83 }
};

static const CaseFoldMapping1_16 case_fold1_16_175[] = {
    { 0x01AE, 0x0288 },
    { 0x10BF, 0x2D1F }
};

static const CaseFoldMapping1_16 case_fold1_16_176[] = {
    { 0x01B1, 0x028A },
    { 0x04B4, 0x04B5 },
    { 0x10A0, 0x2D00 },
    { 0x1EAE, 0x1EAF },
    { 0x2C9C, 0x2C9D }
};

static const CaseFoldMapping1_16 case_fold1_16_177[] = {
    { 0x10A1, 0x2D01 }
};

static const CaseFoldMapping1_16 case_fold1_16_178[] = {
    { 0x01B3, 0x01B4 },
    { 0x04B6, 0x04B7 },
    { 0x10A2, 0x2D02 },
    { 0x1EAC, 0x1EAD },
    { 0x2C9E, 0x2C9F }
};

static const CaseFoldMapping1_16 case_fold1_16_179[] = {
    { 0x01B2, 0x028B },
    { 0x10A3, 0x2D03 }
};

static const CaseFoldMapping1_16 case_fold1_16_180[] = {
    { 0x01B5, 0x01B6 },
    { 0x04B0, 0x04B1 },
    { 0x10A4, 0x2D04 },
    { 0x1EAA, 0x1EAB },
    { 0x2C98, 0x2C99 }
};

static const CaseFoldMapping1_16 case_fold1_16_181[] = {
    { 0x00B5, 0x03BC },
    { 0x10A5, 0x2D05 }
};

static const CaseFoldMapping1_16 case_fold1_16_182[] = {
    { 0x01B7, 0x0292 },
    { 0x04B2, 0x04B3 },
    { 0x10A6, 0x2D06 },
    { 0x1EA8, 0x1EA9 },
    { 0x2C9A, 0x2C9B }
};

static const CaseFoldMapping1_16 case_fold1_16_183[] = {
    { 0x10A7, 0x2D07 }
};

static const CaseFoldMapping1_16 case_fold1_16_184[] = {
    { 0x04BC, 0x04BD },
    { 0x10A8, 0x2D08 },
    { 0x1EA6, 0x1EA7 },
    { 0x2C94, 0x2C95 }
};

static const CaseFoldMapping1_16 case_fold1_16_185[] = {
    { 0x01B8, 0x01B9 },
    { 0x10A9, 0x2D09 }
};

static const CaseFoldMapping1_16 case_fold1_16_186[] = {
    { 0x04BE, 0x04BF },
    { 0x10AA, 0x2D0A },
    { 0x1EA4, 0x1EA5 },
    { 0x2C96, 0x2C97 }
};

static const CaseFoldMapping1_16 case_fold1_16_187[] = {
    { 0x10AB, 0x2D0B }
};

static const CaseFoldMapping1_16 case_fold1_16_188[] = {
    { 0x04B8, 0x04B9 },
    { 0x10AC, 0x2D0C },
    { 0x1EA2, 0x1EA3 },
    { 0x2C90, 0x2C91 }
};

static const CaseFoldMapping1_16 case_fold1_16_189[] = {
    { 0x01BC, 0x01BD },
    { 0x10AD, 0x2D0D }
};

static const CaseFoldMapping1_16 case_fold1_16_190[] = {
    { 0x04BA, 0x04BB },
    { 0x10AE, 0x2D0E },
    { 0x1EA0, 0x1EA1 },
    { 0x2C92, 0x2C93 }
};

static const CaseFoldMapping1_16 case_fold1_16_191[] = {
    { 0x10AF, 0x2D0F }
};

static const CaseFoldMapping1_16 case_fold1_16_192[] = {
    { 0x00C0, 0x00E0 },
    { 0x1EDE, 0x1EDF },
    { 0xA666, 0xA667 }
};

static const CaseFoldMapping1_16 case_fold1_16_193[] = {
    { 0x00C1, 0x00E1 },
    { 0x03C2, 0x03C3 },
    { 0x04C5, 0x04C6 },
    { 0x2CED, 0x2CEE },
    { 0xA766, 0xA767 }
};

static const CaseFoldMapping1_16 case_fold1_16_194[] = {
    { 0x00C2, 0x00E2 },
    { 0x1EDC, 0x1EDD },
    { 0xA664, 0xA665 }
};

static const CaseFoldMapping1_16 case_fold1_16_195[] = {
    { 0x00C3, 0x00E3 },
    { 0x04C7, 0x04C8 },
    { 0xA764, 0xA765 }
};

static const CaseFoldMapping1_16 case_fold1_16_196[] = {
    { 0x00C4, 0x00E4 },
    { 0x01C5, 0x01C6 },
    { 0x04C0, 0x04CF },
    { 0x1EDA, 0x1EDB },
    { 0x1FDB, 0x1F77 },
    { 0xA662, 0xA663 }
};

static const CaseFoldMapping1_16 case_fold1_16_197[] = {
    { 0x00C5, 0x00E5 },
    { 0x01C4, 0x01C6 },
    { 0x04C1, 0x04C2 },
    { 0x1FDA, 0x1F76 },
    { 0xA762, 0xA763 },
    { 0xFF3A, 0xFF5A }
};

static const CaseFoldMapping1_16 case_fold1_16_198[] = {
    { 0x00C6, 0x00E6 },
    { 0x01C7, 0x01C9 },
    { 0x1ED8, 0x1ED9 },
    { 0x1FD9, 0x1FD1 },
    { 0xA660, 0xA661 },
    { 0xFF39, 0xFF59 }
};

static const CaseFoldMapping1_16 case_fold1_16_199[] = {
    { 0x00C7, 0x00E7 },
    { 0x04C3, 0x04C4 },
    { 0x1FD8, 0x1FD0 },
    { 0x2CEB, 0x2CEC },
    { 0xA760, 0xA761 },
    { 0xFF38, 0xFF58 }
};

static const CaseFoldMapping1_16 case_fold1_16_200[] = {
    { 0x00C8, 0x00E8 },
    { 0x1ED6, 0x1ED7 },
    { 0xFF37, 0xFF57 }
};

static const CaseFoldMapping1_16 case_fold1_16_201[] = {
    { 0x00C9, 0x00E9 },
    { 0x01C8, 0x01C9 },
    { 0x04CD, 0x04CE },
    { 0xA76E, 0xA76F },
    { 0xFF36, 0xFF56 }
};

static const CaseFoldMapping1_16 case_fold1_16_202[] = {
    { 0x00CA, 0x00EA },
    { 0x01CB, 0x01CC },
    { 0x1ED4, 0x1ED5 },
    { 0xA66C, 0xA66D },
    { 0xFF35, 0xFF55 }
};

static const CaseFoldMapping1_16 case_fold1_16_203[] = {
    { 0x00CB, 0x00EB },
    { 0x01CA, 0x01CC },
    { 0xA76C, 0xA76D },
    { 0xFF34, 0xFF54 }
};

static const CaseFoldMapping1_16 case_fold1_16_204[] = {
    { 0x00CC, 0x00EC },
    { 0x01CD, 0x01CE },
    { 0x03CF, 0x03D7 },
    { 0x1ED2, 0x1ED3 },
    { 0x2CE0, 0x2CE1 },
    { 0xA66A, 0xA66B },
    { 0xFF33, 0xFF53 }
};

static const CaseFoldMapping1_16 case_fold1_16_205[] = {
    { 0x00CD, 0x00ED },
    { 0x04C9, 0x04CA },
    { 0xA76A, 0xA76B },
    { 0xFF32, 0xFF52 }
};

static const CaseFoldMapping1_16 case_fold1_16_206[] = {
    { 0x00CE, 0x00EE },
    { 0x01CF, 0x01D0 },
    { 0x1ED0, 0x1ED1 },
    { 0x2CE2, 0x2CE3 },
    { 0xA668, 0xA669 },
    { 0xFF31, 0xFF51 }
};

static const CaseFoldMapping1_16 case_fold1_16_207[] = {
    { 0x00CF, 0x00EF },
    { 0x04CB, 0x04CC },
    { 0xA768, 0xA769 },
    { 0xFF30, 0xFF50 }
};

static const CaseFoldMapping1_16 case_fold1_16_208[] = {
    { 0x00D0, 0x00F0 },
    { 0x01D1, 0x01D2 },
    { 0x04D4, 0x04D5 },
    { 0x10C0, 0x2D20 },
    { 0x1ECE, 0x1ECF },
    { 0xAB7B, 0x13AB },
    { 0xFF2F, 0xFF4F }
};

static const CaseFoldMapping1_16 case_fold1_16_209[] = {
    { 0x00D1, 0x00F1 },
    { 0x10C1, 0x2D21 },
    { 0xAB7A, 0x13AA },
    { 0xFF2E, 0xFF4E }
};

static const CaseFoldMapping1_16 case_fold1_16_210[] = {
    { 0x00D2, 0x00F2 },
    { 0x01D3, 0x01D4 },
    { 0x03D1, 0x03B8 },
    { 0x04D6, 0x04D7 },
    { 0x10C2, 0x2D22 },
    { 0x1ECC, 0x1ECD },
    { 0xAB79, 0x13A9 },
    { 0xFF2D, 0xFF4D }
};

static const CaseFoldMapping1_16 case_fold1_16_211[] = {
    { 0x00D3, 0x00F3 },
    { 0x03D0, 0x03B2 },
    { 0x10C3, 0x2D23 },
    { 0xAB78, 0x13A8 },
    { 0xFF2C, 0xFF4C }
};

static const CaseFoldMapping1_16 case_fold1_16_212[] = {
    { 0x00D4, 0x00F4 },
    { 0x01D5, 0x01D6 },
    { 0x04D0, 0x04D1 },
    { 0x10C4, 0x2D24 },
    { 0x1ECA, 0x1ECB },
    { 0x1FCB, 0x1F75 },
    { 0xAB7F, 0x13AF },
    { 0xFF2B, 0xFF4B }
};

static const CaseFoldMapping1_16 case_fold1_16_213[] = {
    { 0x00D5, 0x00F5 },
    { 0x03D6, 0x03C0 },
    { 0x10C5, 0x2D25 },
    { 0x1FCA, 0x1F74 },
    { 0xAB7E, 0x13AE },
    { 0xFF2A, 0xFF4A }
};

static const CaseFoldMapping1_16 case_fold1_16_214[] = {
    { 0x00D6, 0x00F6 },
    { 0x01D7, 0x01D8 },
    { 0x03D5, 0x03C6 },
    { 0x04D2, 0x04D3 },
    { 0x1EC8, 0x1EC9 },
    { 0x1FC9, 0x1F73 },
    { 0xAB7D, 0x13AD },
    { 0xFF29, 0xFF49 }
};

static const CaseFoldMapping1_16 case_fold1_16_215[] = {
    { 0x10C7, 0x2D27 },
    { 0x1FC8, 0x1F72 },
    { 0xAB7C, 0x13AC },
    { 0xFF28, 0xFF48 }
};

static const CaseFoldMapping1_16 case_fold1_16_216[] = {
    { 0x00D8, 0x00F8 },
    { 0x01D9, 0x01DA },
    { 0x04DC, 0x04DD },
    { 0x1EC6, 0x1EC7 },
    { 0xAB73, 0x13A3 },
    { 0xFF27, 0xFF47 }
};

static const CaseFoldMapping1_16 case_fold1_16_217[] = {
    { 0x00D9, 0x00F9 },
    { 0x03DA, 0x03DB },
    { 0xA77E, 0xA77F },
    { 0xAB72, 0x13A2 },
    { 0xFF26, 0xFF46 }
};

static const CaseFoldMapping1_16 case_fold1_16_218[] = {
    { 0x00DA, 0x00FA },
    { 0x01DB, 0x01DC },
    { 0x04DE, 0x04DF },
    { 0x1EC4, 0x1EC5 },
    { 0xA77D, 0x1D79 },
    { 0xAB71, 0x13A1 },
    { 0xFF25, 0xFF45 }
};

static const CaseFoldMapping1_16 case_fold1_16_219[] = {
    { 0x00DB, 0x00FB },
    { 0x03D8, 0x03D9 },
    { 0xAB70, 0x13A0 },
    { 0xFF24, 0xFF44 }
};

static const CaseFoldMapping1_16 case_fold1_16_220[] = {
    { 0x00DC, 0x00FC },
    { 0x04D8, 0x04D9 },
    { 0x1EC2, 0x1EC3 },
    { 0xA77B, 0xA77C },
    { 0xAB77, 0x13A7 },
    { 0xFF23, 0xFF43 }
};

static const CaseFoldMapping1_16 case_fold1_16_221[] = {
    { 0x00DD, 0x00FD },
    { 0x03DE, 0x03DF },
    { 0x10CD, 0x2D2D },
    { 0xAB76, 0x13A6 },
    { 0xFF22, 0xFF42 }
};

static const CaseFoldMapping1_16 case_fold1_16_222[] = {
    { 0x00DE, 0x00FE },
    { 0x04DA, 0x04DB },
    { 0x1EC0, 0x1EC1 },
    { 0x2CF2, 0x2CF3 },
    { 0xA779, 0xA77A },
    { 0xAB75, 0x13A5 },
    { 0xFF21, 0xFF41 }
};

static const CaseFoldMapping1_16 case_fold1_16_223[] = {
    { 0x01DE, 0x01DF },
    { 0x03DC, 0x03DD },
    { 0xAB74, 0x13A4 }
};

static const CaseFoldMapping1_16 case_fold1_16_224[] = {
    { 0x04E4, 0x04E5 },
    { 0x1EFE, 0x1EFF },
    { 0x24C4, 0x24DE },
    { 0x2CCC, 0x2CCD },
    { 0xA646, 0xA647 }
};

static const CaseFoldMapping1_16 case_fold1_16_225[] = {
    { 0x01E0, 0x01E1 },
    { 0x03E2, 0x03E3 },
    { 0x24C5, 0x24DF },
    { 0xA746, 0xA747 }
};

static const CaseFoldMapping1_16 case_fold1_16_226[] = {
    { 0x04E6, 0x04E7 },
    { 0x1EFC, 0x1EFD },
    { 0x24C6, 0x24E0 },
    { 0x2CCE, 0x2CCF },
    { 0xA644, 0xA645 }
};

static const CaseFoldMapping1_16 case_fold1_16_227[] = {
    { 0x01E2, 0x01E3 },
    { 0x03E0, 0x03E1 },
    { 0x24C7, 0x24E1 },
    { 0xA744, 0xA745 }
};

static const CaseFoldMapping1_16 case_fold1_16_228[] = {
    { 0x04E0, 0x04E1 },
    { 0x1EFA, 0x1EFB },
    { 0x1FFB, 0x1F7D },
    { 0x24C0, 0x24DA },
    { 0x2CC8, 0x2CC9 },
    { 0xA642, 0xA643 }
};

static const CaseFoldMapping1_16 case_fold1_16_229[] = {
    { 0x01E4, 0x01E5 },
    { 0x03E6, 0x03E7 },
    { 0x1FFA, 0x1F7C },
    { 0x24C1, 0x24DB },
    { 0xA742, 0xA743 }
};

static const CaseFoldMapping1_16 case_fold1_16_230[] = {
    { 0x04E2, 0x04E3 },
    { 0x1EF8, 0x1EF9 },
    { 0x1FF9, 0x1F79 },
    { 0x24C2, 0x24DC },
    { 0x2CCA, 0x2CCB },
    { 0xA640, 0xA641 }
};

static const CaseFoldMapping1_16 case_fold1_16_231[] = {
    { 0x01E6, 0x01E7 },
    { 0x03E4, 0x03E5 },
    { 0x1FF8, 0x1F78 },
    { 0x24C3, 0x24DD },
    { 0xA740, 0xA741 }
};

static const CaseFoldMapping1_16 case_fold1_16_232[] = {
    { 0x04EC, 0x04ED },
    { 0x13FB, 0x13F3 },
    { 0x1EF6, 0x1EF7 },
    { 0x24CC, 0x24E6 },
    { 0x2CC4, 0x2CC5 },
    { 0xA64E, 0xA64F }
};

static const CaseFoldMapping1_16 case_fold1_16_233[] = {
    { 0x01E8, 0x01E9 },
    { 0x03EA, 0x03EB },
    { 0x13FA, 0x13F2 },
    { 0x24CD, 0x24E7 },
    { 0xA74E, 0xA74F }
};

static const CaseFoldMapping1_16 case_fold1_16_234[] = {
    { 0x04EE, 0x04EF },
    { 0x13F9, 0x13F1 },
    { 0x1EF4, 0x1EF5 },
    { 0x24CE, 0x24E8 },
    { 0x2CC6, 0x2CC7 },
    { 0xA64C, 0xA64D }
};

static const CaseFoldMapping1_16 case_fold1_16_235[] = {
    { 0x01EA, 0x01EB },
    { 0x03E8, 0x03E9 },
    { 0x13F8, 0x13F0 },
    { 0x24CF, 0x24E9 },
    { 0xA74C, 0xA74D }
};

static const CaseFoldMapping1_16 case_fold1_16_236[] = {
    { 0x04E8, 0x04E9 },
    { 0x1EF2, 0x1EF3 },
    { 0x24C8, 0x24E2 },
    { 0x2CC0, 0x2CC1 },
    { 0xA64A, 0xA64B }
};

static const CaseFoldMapping1_16 case_fold1_16_237[] = {
    { 0x01EC, 0x01ED },
    { 0x03EE, 0x03EF },
    { 0x24C9, 0x24E3 },
    { 0xA74A, 0xA74B }
};

static const CaseFoldMapping1_16 case_fold1_16_238[] = {
    { 0x04EA, 0x04EB },
    { 0x13FD, 0x13F5 },
    { 0x1EF0, 0x1EF1 },
    { 0x24CA, 0x24E4 },
    { 0x2CC2, 0x2CC3 },
    { 0xA648, 0xA649 }
};

static const CaseFoldMapping1_16 case_fold1_16_239[] = {
    { 0x01EE, 0x01EF },
    { 0x03EC, 0x03ED },
    { 0x13FC, 0x13F4 },
    { 0x24CB, 0x24E5 },
    { 0xA748, 0xA749 }
};

static const CaseFoldMapping1_16 case_fold1_16_240[] = {
    { 0x01F1, 0x01F3 },
    { 0x04F4, 0x04F5 },
    { 0x1EEE, 0x1EEF },
    { 0x2CDC, 0x2CDD },
    { 0xA656, 0xA657 }
};

static const CaseFoldMapping1_16 case_fold1_16_241[] = {
    { 0xA756, 0xA757 }
};

static const CaseFoldMapping1_16 case_fold1_16_242[] = {
    { 0x03F1, 0x03C1 },
    { 0x04F6, 0x04F7 },
    { 0x1EEC, 0x1EED },
    { 0x2CDE, 0x2CDF },
    { 0xA654, 0xA655 }
};

static const CaseFoldMapping1_16 case_fold1_16_243[] = {
    { 0x01F2, 0x01F3 },
    { 0x03F0, 0x03BA },
    { 0x1FEC, 0x1FE5 },
    { 0xA754, 0xA755 }
};

static const CaseFoldMapping1_16 case_fold1_16_244[] = {
    { 0x03F7, 0x03F8 },
    { 0x04F0, 0x04F1 },
    { 0x1EEA, 0x1EEB },
    { 0x1FEB, 0x1F7B },
    { 0x2CD8, 0x2CD9 },
    { 0xA652, 0xA653 }
};

static const CaseFoldMapping1_16 case_fold1_16_245[] = {
    { 0x01F4, 0x01F5 },
    { 0x1FEA, 0x1F7A },
    { 0xA752, 0xA753 }
};

static const CaseFoldMapping1_16 case_fold1_16_246[] = {
    { 0x01F7, 0x01BF },
    { 0x03F5, 0x03B5 },
    { 0x04F2, 0x04F3 },
    { 0x1EE8, 0x1EE9 },
    { 0x1FE9, 0x1FE1 },
    { 0x2CDA, 0x2CDB },
    { 0xA650, 0xA651 }
};

static const CaseFoldMapping1_16 case_fold1_16_247[] = {
    { 0x01F6, 0x0195 },
    { 0x03F4, 0x03B8 },
    { 0x1FE8, 0x1FE0 },
    { 0xA750, 0xA751 }
};

static const CaseFoldMapping1_16 case_fold1_16_248[] = {
    { 0x04FC, 0x04FD },
    { 0x1EE6, 0x1EE7 },
    { 0x2CD4, 0x2CD5 },
    { 0xA65E, 0xA65F }
};

static const CaseFoldMapping1_16 case_fold1_16_249[] = {
    { 0x01F8, 0x01F9 },
    { 0x03FA, 0x03FB },
    { 0xA75E, 0xA75F }
};

static const CaseFoldMapping1_16 case_fold1_16_250[] = {
    { 0x03F9, 0x03F2 },
    { 0x04FE, 0x04FF },
    { 0x1EE4, 0x1EE5 },
    { 0x2CD6, 0x2CD7 },
    { 0xA65C, 0xA65D }
};

static const CaseFoldMapping1_16 case_fold1_16_251[] = {
    { 0x01FA, 0x01FB },
    { 0xA75C, 0xA75D }
};

static const CaseFoldMapping1_16 case_fold1_16_252[] = {
    { 0x03FF, 0x037D },
    { 0x04F8, 0x04F9 },
    { 0x1EE2, 0x1EE3 },
    { 0x2CD0, 0x2CD1 },
    { 0xA65A, 0xA65B }
};

static const CaseFoldMapping1_16 case_fold1_16_253[] = {
    { 0x01FC, 0x01FD },
    { 0x03FE, 0x037C },
    { 0xA75A, 0xA75B }
};

static const CaseFoldMapping1_16 case_fold1_16_254[] = {
    { 0x03FD, 0x037B },
    { 0x04FA, 0x04FB },
    { 0x1EE0, 0x1EE1 },
    { 0x2CD2, 0x2CD3 },
    { 0xA658, 0xA659 }
};

static const CaseFoldMapping1_16 case_fold1_16_255[] = {
    { 0x01FE, 0x01FF },
    { 0xA758, 0xA759 }
};

static const CaseFoldMapping1_32 case_fold1_32_000[] = {
    { 0x10404, 0x1042C },
    { 0x10414, 0x1043C },
    { 0x10424, 0x1044C },
    { 0x10C8C, 0x10CCC },
    { 0x10C9C, 0x10CDC },
    { 0x10CAC, 0x10CEC },
    { 0x118A8, 0x118C8 },
    { 0x118B8, 0x118D8 }
};

static const CaseFoldMapping1_32 case_fold1_32_001[] = {
    { 0x10405, 0x1042D },
    { 0x10415, 0x1043D },
    { 0x10425, 0x1044D },
    { 0x10C8D, 0x10CCD },
    { 0x10C9D, 0x10CDD },
    { 0x10CAD, 0x10CED },
    { 0x118A9, 0x118C9 },
    { 0x118B9, 0x118D9 }
};

static const CaseFoldMapping1_32 case_fold1_32_002[] = {
    { 0x10406, 0x1042E },
    { 0x10416, 0x1043E },
    { 0x10426, 0x1044E },
    { 0x10C8E, 0x10CCE },
    { 0x10C9E, 0x10CDE },
    { 0x10CAE, 0x10CEE },
    { 0x118AA, 0x118CA },
    { 0x118BA, 0x118DA }
};

static const CaseFoldMapping1_32 case_fold1_32_003[] = {
    { 0x10407, 0x1042F },
    { 0x10417, 0x1043F },
    { 0x10427, 0x1044F },
    { 0x10C8F, 0x10CCF },
    { 0x10C9F, 0x10CDF },
    { 0x10CAF, 0x10CEF },
    { 0x118AB, 0x118CB },
    { 0x118BB, 0x118DB }
};

static const CaseFoldMapping1_32 case_fold1_32_004[] = {
    { 0x10400, 0x10428 },
    { 0x10410, 0x10438 },
    { 0x10420, 0x10448 },
    { 0x10C88, 0x10CC8 },
    { 0x10C98, 0x10CD8 },
    { 0x10CA8, 0x10CE8 },
    { 0x118AC, 0x118CC },
    { 0x118BC, 0x118DC }
};

static const CaseFoldMapping1_32 case_fold1_32_005[] = {
    { 0x10401, 0x10429 },
    { 0x10411, 0x10439 },
    { 0x10421, 0x10449 },
    { 0x10C89, 0x10CC9 },
    { 0x10C99, 0x10CD9 },
    { 0x10CA9, 0x10CE9 },
    { 0x118AD, 0x118CD },
    { 0x118BD, 0x118DD }
};

static const CaseFoldMapping1_32 case_fold1_32_006[] = {
    { 0x10402, 0x1042A },
    { 0x10412, 0x1043A },
    { 0x10422, 0x1044A },
    { 0x10C8A, 0x10CCA },
    { 0x10C9A, 0x10CDA },
    { 0x10CAA, 0x10CEA },
    { 0x118AE, 0x118CE },
    { 0x118BE, 0x118DE }
};

static const CaseFoldMapping1_32 case_fold1_32_007[] = {
    { 0x10403, 0x1042B },
    { 0x10413, 0x1043B },
    { 0x10423, 0x1044B },
    { 0x10C8B, 0x10CCB },
    { 0x10C9B, 0x10CDB },
    { 0x10CAB, 0x10CEB },
    { 0x118AF, 0x118CF },
    { 0x118BF, 0x118DF }
};

static const CaseFoldMapping1_32 case_fold1_32_008[] = {
    { 0x1040C, 0x10434 },
    { 0x1041C, 0x10444 },
    { 0x10C84, 0x10CC4 },
    { 0x10C94, 0x10CD4 },
    { 0x10CA4, 0x10CE4 },
    { 0x118A0, 0x118C0 },
    { 0x118B0, 0x118D0 }
};

static const CaseFoldMapping1_32 case_fold1_32_009[] = {
    { 0x1040D, 0x10435 },
    { 0x1041D, 0x10445 },
    { 0x10C85, 0x10CC5 },
    { 0x10C95, 0x10CD5 },
    { 0x10CA5, 0x10CE5 },
    { 0x118A1, 0x118C1 },
    { 0x118B1, 0x118D1 }
};

static const CaseFoldMapping1_32 case_fold1_32_010[] = {
    { 0x1040E, 0x10436 },
    { 0x1041E, 0x10446 },
    { 0x10C86, 0x10CC6 },
    { 0x10C96, 0x10CD6 },
    { 0x10CA6, 0x10CE6 },
    { 0x118A2, 0x118C2 },
    { 0x118B2, 0x118D2 }
};

static const CaseFoldMapping1_32 case_fold1_32_011[] = {
    { 0x1040F, 0x10437 },
    { 0x1041F, 0x10447 },
    { 0x10C87, 0x10CC7 },
    { 0x10C97, 0x10CD7 },
    { 0x10CA7, 0x10CE7 },
    { 0x118A3, 0x118C3 },
    { 0x118B3, 0x118D3 }
};

static const CaseFoldMapping1_32 case_fold1_32_012[] = {
    { 0x10408, 0x10430 },
    { 0x10418, 0x10440 },
    { 0x10C80, 0x10CC0 },
    { 0x10C90, 0x10CD0 },
    { 0x10CA0, 0x10CE0 },
    { 0x10CB0, 0x10CF0 },
    { 0x118A4, 0x118C4 },
    { 0x118B4, 0x118D4 }
};

static const CaseFoldMapping1_32 case_fold1_32_013[] = {
    { 0x10409, 0x10431 },
    { 0x10419, 0x10441 },
    { 0x10C81, 0x10CC1 },
    { 0x10C91, 0x10CD1 },
    { 0x10CA1, 0x10CE1 },
    { 0x10CB1, 0x10CF1 },
    { 0x118A5, 0x118C5 },
    { 0x118B5, 0x118D5 }
};

static const CaseFoldMapping1_32 case_fold1_32_014[] = {
    { 0x1040A, 0x10432 },
    { 0x1041A, 0x10442 },
    { 0x10C82, 0x10CC2 },
    { 0x10C92, 0x10CD2 },
    { 0x10CA2, 0x10CE2 },
    { 0x10CB2, 0x10CF2 },
    { 0x118A6, 0x118C6 },
    { 0x118B6, 0x118D6 }
};

static const CaseFoldMapping1_32 case_fold1_32_015[] = {
    { 0x1040B, 0x10433 },
    { 0x1041B, 0x10443 },
    { 0x10C83, 0x10CC3 },
    { 0x10C93, 0x10CD3 },
    { 0x10CA3, 0x10CE3 },
    { 0x118A7, 0x118C7 },
    { 0x118B7, 0x118D7 }
};

static const CaseFoldMapping2_16 case_fold2_16_000[] = {
    { 0x1E9E, 0x0073, 0x0073 },
    { 0x1F8F, 0x1F07, 0x03B9 },
    { 0x1F9F, 0x1F27, 0x03B9 },
    { 0x1FAF, 0x1F67, 0x03B9 }
};

static const CaseFoldMapping2_16 case_fold2_16_001[] = {
    { 0x0130, 0x0069, 0x0307 },
    { 0x01F0, 0x006A, 0x030C },
    { 0x1F8E, 0x1F06, 0x03B9 },
    { 0x1F9E, 0x1F26, 0x03B9 },
    { 0x1FAE, 0x1F66, 0x03B9 }
};

static const CaseFoldMapping2_16 case_fold2_16_002[] = {
    { 0x0587, 0x0565, 0x0582 },
    { 0x1F8D, 0x1F05, 0x03B9 },
    { 0x1F9D, 0x1F25, 0x03B9 },
    { 0x1FAD, 0x1F65, 0x03B9 }
};

static const CaseFoldMapping2_16 case_fold2_16_003[] = {
    { 0x1F8C, 0x1F04, 0x03B9 },
    { 0x1F9C, 0x1F24, 0x03B9 },
    { 0x1FAC, 0x1F64, 0x03B9 },
    { 0x1FBC, 0x03B1, 0x03B9 },
    { 0x1FCC, 0x03B7, 0x03B9 },
    { 0x1FFC, 0x03C9, 0x03B9 }
};

static const CaseFoldMapping2_16 case_fold2_16_004[] = {
    { 0x1E9A, 0x0061, 0x02BE },
    { 0x1F8B, 0x1F03, 0x03B9 },
    { 0x1F9B, 0x1F23, 0x03B9 },
    { 0x1FAB, 0x1F63, 0x03B9 }
};

static const CaseFoldMapping2_16 case_fold2_16_005[] = {
    { 0x1F8A, 0x1F02, 0x03B9 },
    { 0x1F9A, 0x1F22, 0x03B9 },
    { 0x1FAA, 0x1F62, 0x03B9 }
};

static const CaseFoldMapping2_16 case_fold2_16_006[] = {
    { 0x1E98, 0x0077, 0x030A },
    { 0x1F89, 0x1F01, 0x03B9 },
    { 0x1F99, 0x1F21, 0x03B9 },
    { 0x1FA9, 0x1F61, 0x03B9 }
};

static const CaseFoldMapping2_16 case_fold2_16_007[] = {
    { 0x1E99, 0x0079, 0x030A },
    { 0x1F88, 0x1F00, 0x03B9 },
    { 0x1F98, 0x1F20, 0x03B9 },
    { 0x1FA8, 0x1F60, 0x03B9 }
};

static const CaseFoldMapping2_16 case_fold2_16_008[] = {
    { 0x0149, 0x02BC, 0x006E },
    { 0x1E96, 0x0068, 0x0331 },
    { 0x1F87, 0x1F07, 0x03B9 },
    { 0x1F97, 0x1F27, 0x03B9 },
    { 0x1FA7, 0x1F67, 0x03B9 },
    { 0xFB13, 0x0574, 0x0576 }
};

static const CaseFoldMapping2_16 case_fold2_16_009[] = {
    { 0x1E97, 0x0074, 0x0308 },
    { 0x1F86, 0x1F06, 0x03B9 },
    { 0x1F96, 0x1F26, 0x03B9 },
    { 0x1FA6, 0x1F66, 0x03B9 },
    { 0x1FB6, 0x03B1, 0x0342 },
    { 0x1FC6, 0x03B7, 0x0342 },
    { 0x1FD6, 0x03B9, 0x0342 },
    { 0x1FE6, 0x03C5, 0x0342 },
    { 0x1FF6, 0x03C9, 0x0342 },
    { 0xFB02, 0x0066, 0x006C }
};

static const CaseFoldMapping2_16 case_fold2_16_010[] = {
    { 0x1F85, 0x1F05, 0x03B9 },
    { 0x1F95, 0x1F25, 0x03B9 },
    { 0x1FA5, 0x1F65, 0x03B9 },
    { 0xFB01, 0x0066, 0x0069 }
};

static const CaseFoldMapping2_16 case_fold2_16_011[] = {
    { 0x1F84, 0x1F04, 0x03B9 },
    { 0x1F94, 0x1F24, 0x03B9 },
    { 0x1FA4, 0x1F64, 0x03B9 },
    { 0x1FB4, 0x03AC, 0x03B9 },
    { 0x1FC4, 0x03AE, 0x03B9 },
    { 0x1FE4, 0x03C1, 0x0313 },
    { 0x1FF4, 0x03CE, 0x03B9 },
    { 0xFB00, 0x0066, 0x0066 }
};

static const CaseFoldMapping2_16 case_fold2_16_012[] = {
    { 0x1F83, 0x1F03, 0x03B9 },
    { 0x1F93, 0x1F23, 0x03B9 },
    { 0x1FA3, 0x1F63, 0x03B9 },
    { 0x1FB3, 0x03B1, 0x03B9 },
    { 0x1FC3, 0x03B7, 0x03B9 },
    { 0x1FF3, 0x03C9, 0x03B9 },
    { 0xFB17, 0x0574, 0x056D }
};

static const CaseFoldMapping2_16 case_fold2_16_013[] = {
    { 0x1F82, 0x1F02, 0x03B9 },
    { 0x1F92, 0x1F22, 0x03B9 },
    { 0x1FA2, 0x1F62, 0x03B9 },
    { 0x1FB2, 0x1F70, 0x03B9 },
    { 0x1FC2, 0x1F74, 0x03B9 },
    { 0x1FF2, 0x1F7C, 0x03B9 },
    { 0xFB06, 0x0073, 0x0074 },
    { 0xFB16, 0x057E, 0x0576 }
};

static const CaseFoldMapping2_16 case_fold2_16_014[] = {
    { 0x1F81, 0x1F01, 0x03B9 },
    { 0x1F91, 0x1F21, 0x03B9 },
    { 0x1FA1, 0x1F61, 0x03B9 },
    { 0xFB05, 0x0073, 0x0074 },
    { 0xFB15, 0x0574, 0x056B }
};

static const CaseFoldMapping2_16 case_fold2_16_015[] = {
    { 0x00DF, 0x0073, 0x0073 },
    { 0x1F50, 0x03C5, 0x0313 },
    { 0x1F80, 0x1F00, 0x03B9 },
    { 0x1F90, 0x1F20, 0x03B9 },
    { 0x1FA0, 0x1F60, 0x03B9 },
    { 0xFB14, 0x0574, 0x0565 }
};

static const CaseFoldMapping3_16 case_fold3_16_000[] = {
    { 0x1FB7, 0x03B1, 0x0342, 0x03B9 },
    { 0x1FC7, 0x03B7, 0x0342, 0x03B9 },
    { 0x1FD3, 0x03B9, 0x0308, 0x0301 },
    { 0x1FD7, 0x03B9, 0x0308, 0x0342 },
    { 0x1FE3, 0x03C5, 0x0308, 0x0301 },
    { 0x1FE7, 0x03C5, 0x0308, 0x0342 },
    { 0x1FF7, 0x03C9, 0x0342, 0x03B9 },
    { 0xFB03, 0x0066, 0x0066, 0x0069 }
};

static const CaseFoldMapping3_16 case_fold3_16_001[] = {
    { 0x1F52, 0x03C5, 0x0313, 0x0300 },
    { 0x1F56, 0x03C5, 0x0313, 0x0342 },
    { 0x1FD2, 0x03B9, 0x0308, 0x0300 },
    { 0x1FE2, 0x03C5, 0x0308, 0x0300 }
};

static const CaseFoldMapping3_16 case_fold3_16_003[] = {
    { 0x0390, 0x03B9, 0x0308, 0x0301 },
    { 0x03B0, 0x03C5, 0x0308, 0x0301 },
    { 0x1F54, 0x03C5, 0x0313, 0x0301 },
    { 0xFB04, 0x0066, 0x0066, 0x006C }
};

static const CaseFoldHashBucket1_16 case_fold_hash1_16[] = {
    { case_fold1_16_000, __PHYSFS_ARRAYLEN(case_fold1_16_000) },
    { case_fold1_16_001, __PHYSFS_ARRAYLEN(case_fold1_16_001) },
    { case_fold1_16_002, __PHYSFS_ARRAYLEN(case_fold1_16_002) },
    { case_fold1_16_003, __PHYSFS_ARRAYLEN(case_fold1_16_003) },
    { case_fold1_16_004, __PHYSFS_ARRAYLEN(case_fold1_16_004) },
    { case_fold1_16_005, __PHYSFS_ARRAYLEN(case_fold1_16_005) },
    { case_fold1_16_006, __PHYSFS_ARRAYLEN(case_fold1_16_006) },
    { case_fold1_16_007, __PHYSFS_ARRAYLEN(case_fold1_16_007) },
    { case_fold1_16_008, __PHYSFS_ARRAYLEN(case_fold1_16_008) },
    { case_fold1_16_009, __PHYSFS_ARRAYLEN(case_fold1_16_009) },
    { case_fold1_16_010, __PHYSFS_ARRAYLEN(case_fold1_16_010) },
    { case_fold1_16_011, __PHYSFS_ARRAYLEN(case_fold1_16_011) },
    { case_fold1_16_012, __PHYSFS_ARRAYLEN(case_fold1_16_012) },
    { case_fold1_16_013, __PHYSFS_ARRAYLEN(case_fold1_16_013) },
    { case_fold1_16_014, __PHYSFS_ARRAYLEN(case_fold1_16_014) },
    { case_fold1_16_015, __PHYSFS_ARRAYLEN(case_fold1_16_015) },
    { case_fold1_16_016, __PHYSFS_ARRAYLEN(case_fold1_16_016) },
    { case_fold1_16_017, __PHYSFS_ARRAYLEN(case_fold1_16_017) },
    { case_fold1_16_018, __PHYSFS_ARRAYLEN(case_fold1_16_018) },
    { case_fold1_16_019, __PHYSFS_ARRAYLEN(case_fold1_16_019) },
    { case_fold1_16_020, __PHYSFS_ARRAYLEN(case_fold1_16_020) },
    { case_fold1_16_021, __PHYSFS_ARRAYLEN(case_fold1_16_021) },
    { case_fold1_16_022, __PHYSFS_ARRAYLEN(case_fold1_16_022) },
    { case_fold1_16_023, __PHYSFS_ARRAYLEN(case_fold1_16_023) },
    { case_fold1_16_024, __PHYSFS_ARRAYLEN(case_fold1_16_024) },
    { case_fold1_16_025, __PHYSFS_ARRAYLEN(case_fold1_16_025) },
    { case_fold1_16_026, __PHYSFS_ARRAYLEN(case_fold1_16_026) },
    { case_fold1_16_027, __PHYSFS_ARRAYLEN(case_fold1_16_027) },
    { case_fold1_16_028, __PHYSFS_ARRAYLEN(case_fold1_16_028) },
    { case_fold1_16_029, __PHYSFS_ARRAYLEN(case_fold1_16_029) },
    { case_fold1_16_030, __PHYSFS_ARRAYLEN(case_fold1_16_030) },
    { case_fold1_16_031, __PHYSFS_ARRAYLEN(case_fold1_16_031) },
    { case_fold1_16_032, __PHYSFS_ARRAYLEN(case_fold1_16_032) },
    { case_fold1_16_033, __PHYSFS_ARRAYLEN(case_fold1_16_033) },
    { case_fold1_16_034, __PHYSFS_ARRAYLEN(case_fold1_16_034) },
    { case_fold1_16_035, __PHYSFS_ARRAYLEN(case_fold1_16_035) },
    { case_fold1_16_036, __PHYSFS_ARRAYLEN(case_fold1_16_036) },
    { case_fold1_16_037, __PHYSFS_ARRAYLEN(case_fold1_16_037) },
    { case_fold1_16_038, __PHYSFS_ARRAYLEN(case_fold1_16_038) },
    { case_fold1_16_039, __PHYSFS_ARRAYLEN(case_fold1_16_039) },
    { case_fold1_16_040, __PHYSFS_ARRAYLEN(case_fold1_16_040) },
    { case_fold1_16_041, __PHYSFS_ARRAYLEN(case_fold1_16_041) },
    { case_fold1_16_042, __PHYSFS_ARRAYLEN(case_fold1_16_042) },
    { case_fold1_16_043, __PHYSFS_ARRAYLEN(case_fold1_16_043) },
    { case_fold1_16_044, __PHYSFS_ARRAYLEN(case_fold1_16_044) },
    { case_fold1_16_045, __PHYSFS_ARRAYLEN(case_fold1_16_045) },
    { case_fold1_16_046, __PHYSFS_ARRAYLEN(case_fold1_16_046) },
    { case_fold1_16_047, __PHYSFS_ARRAYLEN(case_fold1_16_047) },
    { case_fold1_16_048, __PHYSFS_ARRAYLEN(case_fold1_16_048) },
    { case_fold1_16_049, __PHYSFS_ARRAYLEN(case_fold1_16_049) },
    { case_fold1_16_050, __PHYSFS_ARRAYLEN(case_fold1_16_050) },
    { case_fold1_16_051, __PHYSFS_ARRAYLEN(case_fold1_16_051) },
    { case_fold1_16_052, __PHYSFS_ARRAYLEN(case_fold1_16_052) },
    { case_fold1_16_053, __PHYSFS_ARRAYLEN(case_fold1_16_053) },
    { case_fold1_16_054, __PHYSFS_ARRAYLEN(case_fold1_16_054) },
    { case_fold1_16_055, __PHYSFS_ARRAYLEN(case_fold1_16_055) },
    { case_fold1_16_056, __PHYSFS_ARRAYLEN(case_fold1_16_056) },
    { case_fold1_16_057, __PHYSFS_ARRAYLEN(case_fold1_16_057) },
    { case_fold1_16_058, __PHYSFS_ARRAYLEN(case_fold1_16_058) },
    { case_fold1_16_059, __PHYSFS_ARRAYLEN(case_fold1_16_059) },
    { case_fold1_16_060, __PHYSFS_ARRAYLEN(case_fold1_16_060) },
    { case_fold1_16_061, __PHYSFS_ARRAYLEN(case_fold1_16_061) },
    { case_fold1_16_062, __PHYSFS_ARRAYLEN(case_fold1_16_062) },
    { case_fold1_16_063, __PHYSFS_ARRAYLEN(case_fold1_16_063) },
    { case_fold1_16_064, __PHYSFS_ARRAYLEN(case_fold1_16_064) },
    { case_fold1_16_065, __PHYSFS_ARRAYLEN(case_fold1_16_065) },
    { case_fold1_16_066, __PHYSFS_ARRAYLEN(case_fold1_16_066) },
    { case_fold1_16_067, __PHYSFS_ARRAYLEN(case_fold1_16_067) },
    { case_fold1_16_068, __PHYSFS_ARRAYLEN(case_fold1_16_068) },
    { case_fold1_16_069, __PHYSFS_ARRAYLEN(case_fold1_16_069) },
    { case_fold1_16_070, __PHYSFS_ARRAYLEN(case_fold1_16_070) },
    { case_fold1_16_071, __PHYSFS_ARRAYLEN(case_fold1_16_071) },
    { case_fold1_16_072, __PHYSFS_ARRAYLEN(case_fold1_16_072) },
    { case_fold1_16_073, __PHYSFS_ARRAYLEN(case_fold1_16_073) },
    { case_fold1_16_074, __PHYSFS_ARRAYLEN(case_fold1_16_074) },
    { case_fold1_16_075, __PHYSFS_ARRAYLEN(case_fold1_16_075) },
    { case_fold1_16_076, __PHYSFS_ARRAYLEN(case_fold1_16_076) },
    { case_fold1_16_077, __PHYSFS_ARRAYLEN(case_fold1_16_077) },
    { case_fold1_16_078, __PHYSFS_ARRAYLEN(case_fold1_16_078) },
    { case_fold1_16_079, __PHYSFS_ARRAYLEN(case_fold1_16_079) },
    { case_fold1_16_080, __PHYSFS_ARRAYLEN(case_fold1_16_080) },
    { case_fold1_16_081, __PHYSFS_ARRAYLEN(case_fold1_16_081) },
    { case_fold1_16_082, __PHYSFS_ARRAYLEN(case_fold1_16_082) },
    { case_fold1_16_083, __PHYSFS_ARRAYLEN(case_fold1_16_083) },
    { case_fold1_16_084, __PHYSFS_ARRAYLEN(case_fold1_16_084) },
    { case_fold1_16_085, __PHYSFS_ARRAYLEN(case_fold1_16_085) },
    { case_fold1_16_086, __PHYSFS_ARRAYLEN(case_fold1_16_086) },
    { case_fold1_16_087, __PHYSFS_ARRAYLEN(case_fold1_16_087) },
    { case_fold1_16_088, __PHYSFS_ARRAYLEN(case_fold1_16_088) },
    { case_fold1_16_089, __PHYSFS_ARRAYLEN(case_fold1_16_089) },
    { case_fold1_16_090, __PHYSFS_ARRAYLEN(case_fold1_16_090) },
    { case_fold1_16_091, __PHYSFS_ARRAYLEN(case_fold1_16_091) },
    { case_fold1_16_092, __PHYSFS_ARRAYLEN(case_fold1_16_092) },
    { case_fold1_16_093, __PHYSFS_ARRAYLEN(case_fold1_16_093) },
    { case_fold1_16_094, __PHYSFS_ARRAYLEN(case_fold1_16_094) },
    { case_fold1_16_095, __PHYSFS_ARRAYLEN(case_fold1_16_095) },
    { case_fold1_16_096, __PHYSFS_ARRAYLEN(case_fold1_16_096) },
    { case_fold1_16_097, __PHYSFS_ARRAYLEN(case_fold1_16_097) },
    { case_fold1_16_098, __PHYSFS_ARRAYLEN(case_fold1_16_098) },
    { case_fold1_16_099, __PHYSFS_ARRAYLEN(case_fold1_16_099) },
    { case_fold1_16_100, __PHYSFS_ARRAYLEN(case_fold1_16_100) },
    { case_fold1_16_101, __PHYSFS_ARRAYLEN(case_fold1_16_101) },
    { case_fold1_16_102, __PHYSFS_ARRAYLEN(case_fold1_16_102) },
    { case_fold1_16_103, __PHYSFS_ARRAYLEN(case_fold1_16_103) },
    { case_fold1_16_104, __PHYSFS_ARRAYLEN(case_fold1_16_104) },
    { case_fold1_16_105, __PHYSFS_ARRAYLEN(case_fold1_16_105) },
    { case_fold1_16_106, __PHYSFS_ARRAYLEN(case_fold1_16_106) },
    { case_fold1_16_107, __PHYSFS_ARRAYLEN(case_fold1_16_107) },
    { case_fold1_16_108, __PHYSFS_ARRAYLEN(case_fold1_16_108) },
    { case_fold1_16_109, __PHYSFS_ARRAYLEN(case_fold1_16_109) },
    { case_fold1_16_110, __PHYSFS_ARRAYLEN(case_fold1_16_110) },
    { case_fold1_16_111, __PHYSFS_ARRAYLEN(case_fold1_16_111) },
    { case_fold1_16_112, __PHYSFS_ARRAYLEN(case_fold1_16_112) },
    { case_fold1_16_113, __PHYSFS_ARRAYLEN(case_fold1_16_113) },
    { case_fold1_16_114, __PHYSFS_ARRAYLEN(case_fold1_16_114) },
    { case_fold1_16_115, __PHYSFS_ARRAYLEN(case_fold1_16_115) },
    { case_fold1_16_116, __PHYSFS_ARRAYLEN(case_fold1_16_116) },
    { case_fold1_16_117, __PHYSFS_ARRAYLEN(case_fold1_16_117) },
    { case_fold1_16_118, __PHYSFS_ARRAYLEN(case_fold1_16_118) },
    { case_fold1_16_119, __PHYSFS_ARRAYLEN(case_fold1_16_119) },
    { case_fold1_16_120, __PHYSFS_ARRAYLEN(case_fold1_16_120) },
    { case_fold1_16_121, __PHYSFS_ARRAYLEN(case_fold1_16_121) },
    { case_fold1_16_122, __PHYSFS_ARRAYLEN(case_fold1_16_122) },
    { NULL, 0 },
    { case_fold1_16_124, __PHYSFS_ARRAYLEN(case_fold1_16_124) },
    { NULL, 0 },
    { case_fold1_16_126, __PHYSFS_ARRAYLEN(case_fold1_16_126) },
    { NULL, 0 },
    { case_fold1_16_128, __PHYSFS_ARRAYLEN(case_fold1_16_128) },
    { case_fold1_16_129, __PHYSFS_ARRAYLEN(case_fold1_16_129) },
    { case_fold1_16_130, __PHYSFS_ARRAYLEN(case_fold1_16_130) },
    { case_fold1_16_131, __PHYSFS_ARRAYLEN(case_fold1_16_131) },
    { case_fold1_16_132, __PHYSFS_ARRAYLEN(case_fold1_16_132) },
    { case_fold1_16_133, __PHYSFS_ARRAYLEN(case_fold1_16_133) },
    { case_fold1_16_134, __PHYSFS_ARRAYLEN(case_fold1_16_134) },
    { case_fold1_16_135, __PHYSFS_ARRAYLEN(case_fold1_16_135) },
    { case_fold1_16_136, __PHYSFS_ARRAYLEN(case_fold1_16_136) },
    { case_fold1_16_137, __PHYSFS_ARRAYLEN(case_fold1_16_137) },
    { case_fold1_16_138, __PHYSFS_ARRAYLEN(case_fold1_16_138) },
    { case_fold1_16_139, __PHYSFS_ARRAYLEN(case_fold1_16_139) },
    { case_fold1_16_140, __PHYSFS_ARRAYLEN(case_fold1_16_140) },
    { case_fold1_16_141, __PHYSFS_ARRAYLEN(case_fold1_16_141) },
    { case_fold1_16_142, __PHYSFS_ARRAYLEN(case_fold1_16_142) },
    { case_fold1_16_143, __PHYSFS_ARRAYLEN(case_fold1_16_143) },
    { case_fold1_16_144, __PHYSFS_ARRAYLEN(case_fold1_16_144) },
    { case_fold1_16_145, __PHYSFS_ARRAYLEN(case_fold1_16_145) },
    { case_fold1_16_146, __PHYSFS_ARRAYLEN(case_fold1_16_146) },
    { case_fold1_16_147, __PHYSFS_ARRAYLEN(case_fold1_16_147) },
    { case_fold1_16_148, __PHYSFS_ARRAYLEN(case_fold1_16_148) },
    { case_fold1_16_149, __PHYSFS_ARRAYLEN(case_fold1_16_149) },
    { case_fold1_16_150, __PHYSFS_ARRAYLEN(case_fold1_16_150) },
    { case_fold1_16_151, __PHYSFS_ARRAYLEN(case_fold1_16_151) },
    { case_fold1_16_152, __PHYSFS_ARRAYLEN(case_fold1_16_152) },
    { case_fold1_16_153, __PHYSFS_ARRAYLEN(case_fold1_16_153) },
    { case_fold1_16_154, __PHYSFS_ARRAYLEN(case_fold1_16_154) },
    { case_fold1_16_155, __PHYSFS_ARRAYLEN(case_fold1_16_155) },
    { case_fold1_16_156, __PHYSFS_ARRAYLEN(case_fold1_16_156) },
    { case_fold1_16_157, __PHYSFS_ARRAYLEN(case_fold1_16_157) },
    { case_fold1_16_158, __PHYSFS_ARRAYLEN(case_fold1_16_158) },
    { case_fold1_16_159, __PHYSFS_ARRAYLEN(case_fold1_16_159) },
    { case_fold1_16_160, __PHYSFS_ARRAYLEN(case_fold1_16_160) },
    { case_fold1_16_161, __PHYSFS_ARRAYLEN(case_fold1_16_161) },
    { case_fold1_16_162, __PHYSFS_ARRAYLEN(case_fold1_16_162) },
    { case_fold1_16_163, __PHYSFS_ARRAYLEN(case_fold1_16_163) },
    { case_fold1_16_164, __PHYSFS_ARRAYLEN(case_fold1_16_164) },
    { case_fold1_16_165, __PHYSFS_ARRAYLEN(case_fold1_16_165) },
    { case_fold1_16_166, __PHYSFS_ARRAYLEN(case_fold1_16_166) },
    { case_fold1_16_167, __PHYSFS_ARRAYLEN(case_fold1_16_167) },
    { case_fold1_16_168, __PHYSFS_ARRAYLEN(case_fold1_16_168) },
    { case_fold1_16_169, __PHYSFS_ARRAYLEN(case_fold1_16_169) },
    { case_fold1_16_170, __PHYSFS_ARRAYLEN(case_fold1_16_170) },
    { case_fold1_16_171, __PHYSFS_ARRAYLEN(case_fold1_16_171) },
    { case_fold1_16_172, __PHYSFS_ARRAYLEN(case_fold1_16_172) },
    { case_fold1_16_173, __PHYSFS_ARRAYLEN(case_fold1_16_173) },
    { case_fold1_16_174, __PHYSFS_ARRAYLEN(case_fold1_16_174) },
    { case_fold1_16_175, __PHYSFS_ARRAYLEN(case_fold1_16_175) },
    { case_fold1_16_176, __PHYSFS_ARRAYLEN(case_fold1_16_176) },
    { case_fold1_16_177, __PHYSFS_ARRAYLEN(case_fold1_16_177) },
    { case_fold1_16_178, __PHYSFS_ARRAYLEN(case_fold1_16_178) },
    { case_fold1_16_179, __PHYSFS_ARRAYLEN(case_fold1_16_179) },
    { case_fold1_16_180, __PHYSFS_ARRAYLEN(case_fold1_16_180) },
    { case_fold1_16_181, __PHYSFS_ARRAYLEN(case_fold1_16_181) },
    { case_fold1_16_182, __PHYSFS_ARRAYLEN(case_fold1_16_182) },
    { case_fold1_16_183, __PHYSFS_ARRAYLEN(case_fold1_16_183) },
    { case_fold1_16_184, __PHYSFS_ARRAYLEN(case_fold1_16_184) },
    { case_fold1_16_185, __PHYSFS_ARRAYLEN(case_fold1_16_185) },
    { case_fold1_16_186, __PHYSFS_ARRAYLEN(case_fold1_16_186) },
    { case_fold1_16_187, __PHYSFS_ARRAYLEN(case_fold1_16_187) },
    { case_fold1_16_188, __PHYSFS_ARRAYLEN(case_fold1_16_188) },
    { case_fold1_16_189, __PHYSFS_ARRAYLEN(case_fold1_16_189) },
    { case_fold1_16_190, __PHYSFS_ARRAYLEN(case_fold1_16_190) },
    { case_fold1_16_191, __PHYSFS_ARRAYLEN(case_fold1_16_191) },
    { case_fold1_16_192, __PHYSFS_ARRAYLEN(case_fold1_16_192) },
    { case_fold1_16_193, __PHYSFS_ARRAYLEN(case_fold1_16_193) },
    { case_fold1_16_194, __PHYSFS_ARRAYLEN(case_fold1_16_194) },
    { case_fold1_16_195, __PHYSFS_ARRAYLEN(case_fold1_16_195) },
    { case_fold1_16_196, __PHYSFS_ARRAYLEN(case_fold1_16_196) },
    { case_fold1_16_197, __PHYSFS_ARRAYLEN(case_fold1_16_197) },
    { case_fold1_16_198, __PHYSFS_ARRAYLEN(case_fold1_16_198) },
    { case_fold1_16_199, __PHYSFS_ARRAYLEN(case_fold1_16_199) },
    { case_fold1_16_200, __PHYSFS_ARRAYLEN(case_fold1_16_200) },
    { case_fold1_16_201, __PHYSFS_ARRAYLEN(case_fold1_16_201) },
    { case_fold1_16_202, __PHYSFS_ARRAYLEN(case_fold1_16_202) },
    { case_fold1_16_203, __PHYSFS_ARRAYLEN(case_fold1_16_203) },
    { case_fold1_16_204, __PHYSFS_ARRAYLEN(case_fold1_16_204) },
    { case_fold1_16_205, __PHYSFS_ARRAYLEN(case_fold1_16_205) },
    { case_fold1_16_206, __PHYSFS_ARRAYLEN(case_fold1_16_206) },
    { case_fold1_16_207, __PHYSFS_ARRAYLEN(case_fold1_16_207) },
    { case_fold1_16_208, __PHYSFS_ARRAYLEN(case_fold1_16_208) },
    { case_fold1_16_209, __PHYSFS_ARRAYLEN(case_fold1_16_209) },
    { case_fold1_16_210, __PHYSFS_ARRAYLEN(case_fold1_16_210) },
    { case_fold1_16_211, __PHYSFS_ARRAYLEN(case_fold1_16_211) },
    { case_fold1_16_212, __PHYSFS_ARRAYLEN(case_fold1_16_212) },
    { case_fold1_16_213, __PHYSFS_ARRAYLEN(case_fold1_16_213) },
    { case_fold1_16_214, __PHYSFS_ARRAYLEN(case_fold1_16_214) },
    { case_fold1_16_215, __PHYSFS_ARRAYLEN(case_fold1_16_215) },
    { case_fold1_16_216, __PHYSFS_ARRAYLEN(case_fold1_16_216) },
    { case_fold1_16_217, __PHYSFS_ARRAYLEN(case_fold1_16_217) },
    { case_fold1_16_218, __PHYSFS_ARRAYLEN(case_fold1_16_218) },
    { case_fold1_16_219, __PHYSFS_ARRAYLEN(case_fold1_16_219) },
    { case_fold1_16_220, __PHYSFS_ARRAYLEN(case_fold1_16_220) },
    { case_fold1_16_221, __PHYSFS_ARRAYLEN(case_fold1_16_221) },
    { case_fold1_16_222, __PHYSFS_ARRAYLEN(case_fold1_16_222) },
    { case_fold1_16_223, __PHYSFS_ARRAYLEN(case_fold1_16_223) },
    { case_fold1_16_224, __PHYSFS_ARRAYLEN(case_fold1_16_224) },
    { case_fold1_16_225, __PHYSFS_ARRAYLEN(case_fold1_16_225) },
    { case_fold1_16_226, __PHYSFS_ARRAYLEN(case_fold1_16_226) },
    { case_fold1_16_227, __PHYSFS_ARRAYLEN(case_fold1_16_227) },
    { case_fold1_16_228, __PHYSFS_ARRAYLEN(case_fold1_16_228) },
    { case_fold1_16_229, __PHYSFS_ARRAYLEN(case_fold1_16_229) },
    { case_fold1_16_230, __PHYSFS_ARRAYLEN(case_fold1_16_230) },
    { case_fold1_16_231, __PHYSFS_ARRAYLEN(case_fold1_16_231) },
    { case_fold1_16_232, __PHYSFS_ARRAYLEN(case_fold1_16_232) },
    { case_fold1_16_233, __PHYSFS_ARRAYLEN(case_fold1_16_233) },
    { case_fold1_16_234, __PHYSFS_ARRAYLEN(case_fold1_16_234) },
    { case_fold1_16_235, __PHYSFS_ARRAYLEN(case_fold1_16_235) },
    { case_fold1_16_236, __PHYSFS_ARRAYLEN(case_fold1_16_236) },
    { case_fold1_16_237, __PHYSFS_ARRAYLEN(case_fold1_16_237) },
    { case_fold1_16_238, __PHYSFS_ARRAYLEN(case_fold1_16_238) },
    { case_fold1_16_239, __PHYSFS_ARRAYLEN(case_fold1_16_239) },
    { case_fold1_16_240, __PHYSFS_ARRAYLEN(case_fold1_16_240) },
    { case_fold1_16_241, __PHYSFS_ARRAYLEN(case_fold1_16_241) },
    { case_fold1_16_242, __PHYSFS_ARRAYLEN(case_fold1_16_242) },
    { case_fold1_16_243, __PHYSFS_ARRAYLEN(case_fold1_16_243) },
    { case_fold1_16_244, __PHYSFS_ARRAYLEN(case_fold1_16_244) },
    { case_fold1_16_245, __PHYSFS_ARRAYLEN(case_fold1_16_245) },
    { case_fold1_16_246, __PHYSFS_ARRAYLEN(case_fold1_16_246) },
    { case_fold1_16_247, __PHYSFS_ARRAYLEN(case_fold1_16_247) },
    { case_fold1_16_248, __PHYSFS_ARRAYLEN(case_fold1_16_248) },
    { case_fold1_16_249, __PHYSFS_ARRAYLEN(case_fold1_16_249) },
    { case_fold1_16_250, __PHYSFS_ARRAYLEN(case_fold1_16_250) },
    { case_fold1_16_251, __PHYSFS_ARRAYLEN(case_fold1_16_251) },
    { case_fold1_16_252, __PHYSFS_ARRAYLEN(case_fold1_16_252) },
    { case_fold1_16_253, __PHYSFS_ARRAYLEN(case_fold1_16_253) },
    { case_fold1_16_254, __PHYSFS_ARRAYLEN(case_fold1_16_254) },
    { case_fold1_16_255, __PHYSFS_ARRAYLEN(case_fold1_16_255) },
};

static const CaseFoldHashBucket1_32 case_fold_hash1_32[] = {
    { case_fold1_32_000, __PHYSFS_ARRAYLEN(case_fold1_32_000) },
    { case_fold1_32_001, __PHYSFS_ARRAYLEN(case_fold1_32_001) },
    { case_fold1_32_002, __PHYSFS_ARRAYLEN(case_fold1_32_002) },
    { case_fold1_32_003, __PHYSFS_ARRAYLEN(case_fold1_32_003) },
    { case_fold1_32_004, __PHYSFS_ARRAYLEN(case_fold1_32_004) },
    { case_fold1_32_005, __PHYSFS_ARRAYLEN(case_fold1_32_005) },
    { case_fold1_32_006, __PHYSFS_ARRAYLEN(case_fold1_32_006) },
    { case_fold1_32_007, __PHYSFS_ARRAYLEN(case_fold1_32_007) },
    { case_fold1_32_008, __PHYSFS_ARRAYLEN(case_fold1_32_008) },
    { case_fold1_32_009, __PHYSFS_ARRAYLEN(case_fold1_32_009) },
    { case_fold1_32_010, __PHYSFS_ARRAYLEN(case_fold1_32_010) },
    { case_fold1_32_011, __PHYSFS_ARRAYLEN(case_fold1_32_011) },
    { case_fold1_32_012, __PHYSFS_ARRAYLEN(case_fold1_32_012) },
    { case_fold1_32_013, __PHYSFS_ARRAYLEN(case_fold1_32_013) },
    { case_fold1_32_014, __PHYSFS_ARRAYLEN(case_fold1_32_014) },
    { case_fold1_32_015, __PHYSFS_ARRAYLEN(case_fold1_32_015) },
};

static const CaseFoldHashBucket2_16 case_fold_hash2_16[] = {
    { case_fold2_16_000, __PHYSFS_ARRAYLEN(case_fold2_16_000) },
    { case_fold2_16_001, __PHYSFS_ARRAYLEN(case_fold2_16_001) },
    { case_fold2_16_002, __PHYSFS_ARRAYLEN(case_fold2_16_002) },
    { case_fold2_16_003, __PHYSFS_ARRAYLEN(case_fold2_16_003) },
    { case_fold2_16_004, __PHYSFS_ARRAYLEN(case_fold2_16_004) },
    { case_fold2_16_005, __PHYSFS_ARRAYLEN(case_fold2_16_005) },
    { case_fold2_16_006, __PHYSFS_ARRAYLEN(case_fold2_16_006) },
    { case_fold2_16_007, __PHYSFS_ARRAYLEN(case_fold2_16_007) },
    { case_fold2_16_008, __PHYSFS_ARRAYLEN(case_fold2_16_008) },
    { case_fold2_16_009, __PHYSFS_ARRAYLEN(case_fold2_16_009) },
    { case_fold2_16_010, __PHYSFS_ARRAYLEN(case_fold2_16_010) },
    { case_fold2_16_011, __PHYSFS_ARRAYLEN(case_fold2_16_011) },
    { case_fold2_16_012, __PHYSFS_ARRAYLEN(case_fold2_16_012) },
    { case_fold2_16_013, __PHYSFS_ARRAYLEN(case_fold2_16_013) },
    { case_fold2_16_014, __PHYSFS_ARRAYLEN(case_fold2_16_014) },
    { case_fold2_16_015, __PHYSFS_ARRAYLEN(case_fold2_16_015) },
};

static const CaseFoldHashBucket3_16 case_fold_hash3_16[] = {
    { case_fold3_16_000, __PHYSFS_ARRAYLEN(case_fold3_16_000) },
    { case_fold3_16_001, __PHYSFS_ARRAYLEN(case_fold3_16_001) },
    { NULL, 0 },
    { case_fold3_16_003, __PHYSFS_ARRAYLEN(case_fold3_16_003) },
};


#endif  /* _INCLUDE_PHYSFS_CASEFOLDING_H_ */

/* end of physfs_casefolding.h ... */

