# GCC target-specific configuration file.
# Copyright 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004
# Free Software Foundation, Inc.

#This file is part of GCC.

#GCC is free software; you can redistribute it and/or modify it under
#the terms of the GNU General Public License as published by the Free
#Software Foundation; either version 2, or (at your option) any later
#version.

#GCC is distributed in the hope that it will be useful, but WITHOUT
#ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
#FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
#for more details.

#You should have received a copy of the GNU General Public License
#along with GCC; see the file COPYING.  If not, write to the Free
#Software Foundation, 59 Temple Place - Suite 330, Boston, MA
#02111-1307, USA.

# This is the GCC target-specific configuration file
# where a configuration type is mapped to different system-specific
# definitions and files.  This is invoked by the autoconf-generated
# configure script.  Putting it in a separate shell file lets us skip
# running autoconf when modifying target-specific information.

# This file switches on the shell variable ${target}, and also uses the
# following shell variables:
#
#  with_*		Various variables as set by configure.
#
#  enable_threads_flag	Either the name, yes or no depending on whether
#			threads support was requested.
#
#  default_use_cxa_atexit
#			"no" by default, can be set to "yes" if a target
#			wishes to use __cxa_atexit() by default if the
#			$enable___cxa_atexit variable is not set.
#
#  gas_flag		Either yes or no depending on whether GNU as was
#			requested.
#
#  gnu_ld_flag		Either yes or no depending on whether GNU ld was
#			requested.

# This file sets the following shell variables for use by the
# autoconf-generated configure script:
#
#  cpu_type		The name of the cpu, if different from the first
#			chunk of the canonical target name.
#
#  tm_defines		List of target macros to define for all compilations.
#
#  tm_file		A list of target macro files, if different from
#			"$cpu_type/$cpu_type.h". Usually it's constructed
#			per target in a way like this:
#			tm_file="${tm_file} dbxelf.h elfos.h svr4.h ${cpu_type.h}/elf.h"
#			Note that the preferred order is:
#			- specific target header "${cpu_type}/${cpu_type.h}"
#			- generic headers like dbxelf.h elfos.h, netware.h, etc.
#			- specializing target headers like ${cpu_type.h}/elf.h
#			This helps to keep OS specific stuff out of the CPU
#			defining header ${cpu_type}/${cpu_type.h}.
#
#  tm_p_file		Location of file with declarations for functions
#			in $out_file.
#
#  out_file		The name of the machine description C support
#			file, if different from "$cpu_type/$cpu_type.c".
#
#  md_file		The name of the machine-description file, if
#			different from "$cpu_type/$cpu_type.md".
#
#  tmake_file		A list of machine-description-specific
#			makefile-fragments, if different from
#			"$cpu_type/t-$cpu_type".
#
#  extra_modes          The name of the file containing a list of extra
#                       machine modes, if necessary and different from
#                       "$cpu_type/$cpu_type-modes.def".
#
#  extra_objs		List of extra objects that should be linked into
#			the compiler proper (cc1, cc1obj, cc1plus)
#			depending on target.
#
#  extra_gcc_objs	List of extra objects that should be linked into
#			the compiler driver (gcc) depending on target.
#
#  extra_headers	List of used header files from the directory
#			config/${cpu_type}.
#
#  extra_passes		List of extra executables compiled for this target
#			machine, used for compiling from source to object.
#
#  extra_parts		List of extra object files that should be compiled
#			for this target machine.
#
#  extra_programs	Like extra_passes, but these are used when linking.
#
#  c_target_objs	List of extra target-dependent objects that be
#			linked into the C compiler only.
#
#  cxx_target_objs	List of extra target-dependent objects that be
#			linked into the C++ compiler only.
#
#  target_gtfiles       List of extra source files with type information.
#
#  xm_defines		List of macros to define when compiling for the
#			target machine.
#
#  xm_file		List of files to include when compiling for the
#			target machine.
#
#  use_collect2		Set to yes or no, depending on whether collect2
#			will be used.
#
#  target_cpu_default	Set to override the default target model.
#
#  gdb_needs_out_file_path
#			Set to yes if gdb needs a dir command with
#			`dirname $out_file`.
#
#  thread_file		Set to control which thread package to use.
#
#  gas			Set to yes or no depending on whether the target
#			system normally uses GNU as.
#
#  need_64bit_hwint	Set to yes if HOST_WIDE_INT must be 64 bits wide
#			for this target.  This is true iff
#			MAX_LONG_TYPE_SIZE is 64.  (The code which
#			determines the underlying integral type for
#			HOST_WIDE_INT cannot see the definition of
#			MAX_LONG_TYPE_SIZE.)
#
#  configure_default_options
#			Set to an initializer for configure_default_options
#			in configargs.h, based on --with-cpu et cetera.
#
#  use_fixproto		Set to "yes" if fixproto should be run normally,
#			"no" if fixproto should never be run.

# The following variables are used in each case-construct to build up the
# outgoing variables:
#
#  gnu_ld		Set to yes or no depending on whether the target
#			system normally uses GNU ld.

out_file=
tmake_file=
extra_headers=
extra_passes=
extra_parts=
extra_programs=
extra_objs=
extra_gcc_objs=
c_target_objs=
cxx_target_objs=
tm_defines=
xm_defines=
# Set this to force installation and use of collect2.
use_collect2=
# Set this to override the default target model.
target_cpu_default=
# Set this if gdb needs a dir command with `dirname $out_file`
gdb_needs_out_file_path=
# Set this to control which thread package will be used.
thread_file=
# Reinitialize these from the flag values every loop pass, since some
# configure entries modify them.
gas="$gas_flag"
gnu_ld="$gnu_ld_flag"
enable_threads=$enable_threads_flag
default_use_cxa_atexit=no
target_gtfiles=
need_64bit_hwint=

# Default to not using fixproto.  Targets which need fixproto should
# specifically set this to 'yes'.
use_fixproto=no

# Don't carry these over build->host->target.  Please.
xm_file=
md_file=

# Obsolete configurations.
case ${target} in
 d30v-* | \
 dsp16xx-* | \
 i370-* | \
 i960-* | \
 i?86-moss-msdos | i?86-*-moss* | \
 i?86-ncr-sysv4* | \
 i?86-*-netware | \
 i?86-*-freebsd2* | i?86-*-freebsd*aout* | \
 i?86-*-linux*aout* | \
 i?86-*-linux*libc1* | \
 i?86-*-interix | \
 i?86-*-mach* | \
 i?86-*-udk* | \
 i?86-*-sysv[123]* | \
 i386-*-vsta | \
 m68k-hp-hpux* | m68000-hp-hpux* | \
 m68k-*-sysv4*)
    if test "x$enable_obsolete" != xyes; then
      echo "*** Configuration ${target} is obsolete." >&2
      echo "*** Specify --enable-obsolete to build it anyway." >&2
      echo "*** Support will be REMOVED in the next major release of GCC," >&2
      echo "*** unless a maintainer comes forward." >&2
      exit 1
    fi;;
esac

# Unsupported targets list.  Do not put an entry in this list unless
# it would otherwise be caught by a more permissive pattern.  The list
# should be in alphabetical order.
case ${target} in
   alpha*-*-linux*libc1*		\
 | i[34567]86-sequent-sysv		\
 | i[34567]86-sequent-sysv[123]*	\
 | i[34567]86-go32-*			\
 | i[34567]86-*-go32*			\
 | m68k-*-linux*aout*			\
 | m68k-*-linux*libc1*			\
 | mips64orion*-*-rtems*		\
 | powerpc-*-linux*libc1*		\
 | sparc-*-linux*aout*			\
 | sparc-*-linux*libc1*			\
 | sparc-hal-solaris2*			\
 | thumb-*-*				\
 | *-*-linux*coff*			\
 | *-*-linux*oldld*			\
 | *-*-rtemsaout*			\
 | *-*-rtemscoff*			\
 | vax-*-vms*				\
 )
	echo "*** Configuration ${target} not supported" 1>&2
	exit 1
	;;
esac

# Set default cpu_type, tm_file, tm_p_file and xm_file so it can be
# updated in each machine entry.  Also set default extra_headers for some
# machines.
tm_p_file=
cpu_type=`echo ${target} | sed 's/-.*$//'`
case ${target} in
alpha*-*-*)
	cpu_type=alpha
	need_64bit_hwint=yes
	;;
am33_2.0-*-linux*)
	cpu_type=mn10300
	;;
strongarm*-*-*)
	cpu_type=arm
	;;
arm*-*-*)
	cpu_type=arm
	extra_headers="mmintrin.h"
	;;
ep9312*-*-*)
	cpu_type=arm
	;;
xscale-*-*)
	cpu_type=arm
	extra_headers="mmintrin.h"
	;;
i[34567]86-*-*)
	cpu_type=i386
	extra_headers="mmintrin.h xmmintrin.h emmintrin.h pmmintrin.h"
	;;
x86_64-*-*)
	cpu_type=i386
	extra_headers="mmintrin.h xmmintrin.h emmintrin.h pmmintrin.h"
	need_64bit_hwint=yes
	;;
ia64-*-*)
	extra_headers=ia64intrin.h
	need_64bit_hwint=yes
	;;
hppa*-*-* | parisc*-*-*)
	cpu_type=pa
	;;
m32r*-*-*)
        cpu_type=m32r
        ;;
m680[012]0-*-*)
	cpu_type=m68k
	extra_headers=math-68881.h
	;;
m68k-*-*)
	extra_headers=math-68881.h
	;;
mips*-*-*)
	cpu_type=mips
	need_64bit_hwint=yes
	;;
powerpc*-*-*)
	cpu_type=rs6000
	extra_headers="ppc-asm.h altivec.h spe.h"
	need_64bit_hwint=yes
	;;
rs6000*-*-*)
	need_64bit_hwint=yes
	;;
sparc64*-*-*)
	cpu_type=sparc
	need_64bit_hwint=yes
	;;
sparc*-*-*)
	cpu_type=sparc
	;;
s390*-*-*)
	need_64bit_hwint=yes
	;;
# Note the 'l'; we need to be able to match e.g. "shle" or "shl".
sh[123456789l]*-*-*)
	cpu_type=sh
	need_64bit_hwint=yes
	;;
tic4x-*-*)
        cpu_type=c4x
        ;;
esac

tm_file=${cpu_type}/${cpu_type}.h
if test -f ${srcdir}/config/${cpu_type}/${cpu_type}-protos.h
then
	tm_p_file=${cpu_type}/${cpu_type}-protos.h
fi
extra_modes=
if test -f ${srcdir}/config/${cpu_type}/${cpu_type}-modes.def
then
	extra_modes=${cpu_type}/${cpu_type}-modes.def
fi

case ${target} in
x86_64-*-*)
	tm_file="i386/biarch64.h ${tm_file}"
	;;
esac

# On a.out targets, we need to use collect2.
case ${target} in
*-*-*aout*)
	use_collect2=yes
	;;
esac

# Common parts for widely ported systems.
case ${target} in
*-*-darwin*)
  tm_file="${tm_file} darwin.h"
  tm_p_file="${tm_p_file} darwin-protos.h"
  tmake_file="t-darwin"
  target_gtfiles="\$(srcdir)/config/darwin.c"
  c_target_objs="darwin-c.o"
  cxx_target_objs="darwin-c.o"
  extra_parts="crt2.o"
  extra_objs="darwin.o"
  case ${enable_threads} in
    "" | yes | posix) thread_file='posix' ;;
  esac
  ;;
*-*-freebsd[12] | *-*-freebsd[12].* | *-*-freebsd*aout*)
  # This is the place-holder for the generic a.out configuration
  # of FreeBSD.  No actual configuration resides here since
  # there was only ever a bare-bones ix86 configuration for
  # a.out and it exists solely in the machine-specific section.
  # This place-holder must exist to avoid dropping into
  # the generic ELF configuration of FreeBSD (i.e. it must be
  # ordered before that section).
  ;;
*-*-freebsd*)
  # This is the generic ELF configuration of FreeBSD.  Later
  # machine-specific sections may refine and add to this
  # configuration.
  #
  # Due to tm_file entry ordering issues that vary between cpu
  # architectures, we only define fbsd_tm_file to allow the
  # machine-specific section to dictate the final order of all
  # entries of tm_file with the minor exception that components
  # of the tm_file set here will always be of the form:
  #
  # freebsd<version_number>.h [freebsd-<conf_option>.h ...] freebsd-spec.h freebsd.h
  #
  # The machine-specific section should not tamper with this
  # ordering but may order all other entries of tm_file as it
  # pleases around the provided core setting.
  gas=yes
  gnu_ld=yes
  extra_parts="crtbegin.o crtend.o crtbeginS.o crtendS.o"
  case ${target} in
    *-*-freebsd3 | *-*-freebsd[3].*)
      tm_defines="${tm_defines} FBSD_MAJOR=3" ;;
    *-*-freebsd4 | *-*-freebsd[4].*)
      tm_defines="${tm_defines} FBSD_MAJOR=4" ;;
    *-*-freebsd5 | *-*-freebsd[5].*)
      tm_defines="${tm_defines} FBSD_MAJOR=5" ;;
    *-*-freebsd6 | *-*-freebsd[6].*)
      tm_defines="${tm_defines} FBSD_MAJOR=6" ;;
    *)
      echo 'Please update *-*-freebsd* in gcc/config.gcc'
      exit 1
      ;;
  esac
  tmake_file="t-slibgcc-elf-ver t-freebsd"
  case ${enable_threads} in
    no)
      fbsd_tm_file="${fbsd_tm_file} freebsd-nthr.h"
      ;;
    "" | yes | posix)
      thread_file='posix'
      tmake_file="${tmake_file} t-freebsd-thread"
      # Before 5.0, FreeBSD can't bind shared libraries to -lc
      # when "optionally" threaded via weak pthread_* checks.
      case ${target} in
        *-*-freebsd[34] | *-*-freebsd[34].*)
          tmake_file="${tmake_file} t-slibgcc-nolc-override"
          ;;
      esac
      ;;
    *) 
      echo 'Unknown thread configuration for FreeBSD'
      exit 1
      ;;
  esac
  fbsd_tm_file="${fbsd_tm_file} freebsd-spec.h freebsd.h"
  ;;
*-*-kfreebsd*-gnu)
  # Must come before *-*-gnu*
  xm_defines=POSIX # needed for cross-compiling from FreeBSD?
  extra_parts="crtbegin.o crtbeginS.o crtbeginT.o crtend.o crtendS.o"
  # GNU tools are the only tools.
  gas=yes
  gnu_ld=yes
  case ${enable_threads} in
    "" | yes | posix) thread_file='posix' ;;
  esac
  ;;
*-*-linux*libc1* | *-*-linux*aout*)
  # Avoid the generic linux case.
  ;;
*-*-linux*)
  # Must come before *-*-gnu* (because of *-*-linux-gnu* systems).
  extra_parts="crtbegin.o crtbeginS.o crtbeginT.o crtend.o crtendS.o"
  gas=yes
  gnu_ld=yes
  case ${enable_threads} in
    "" | yes | posix) thread_file='posix' ;;
  esac
  ;;
*-*-gnu*)
  # On the Hurd, the setup is just about the same on
  # each different CPU.  The specific machines that we
  # support are matched above and just set $cpu_type.
  tm_file="${cpu_type}/gnu.h"
  extra_parts="crtbegin.o crtend.o crtbeginS.o crtendS.o crtbeginT.o"
  # GNU tools are the only tools.
  gas=yes
  gnu_ld=yes
  # These details are the same as for Linux.
  # But here we need a little extra magic.
  tmake_file="t-slibgcc-elf-ver t-linux t-gnu"
  case ${target} in
    alpha*)
      tm_file="${cpu_type}/${cpu_type}.h alpha/elf.h alpha/linux.h alpha/linux-elf.h gnu.h ${tm_file}"
      ;;
    i[34567]86-*-*)
      tm_file="${cpu_type}/${cpu_type}.h i386/unix.h i386/att.h dbxelf.h elfos.h svr4.h linux.h i386/linux.h gnu.h ${tm_file}"
      ;;
  esac
  ;;
*-*-netbsd*)
  tmake_file="t-slibgcc-elf-ver t-libc-ok t-netbsd t-libgcc-pic"
  gas=yes
  gnu_ld=yes

  # NetBSD 2.0 and later get POSIX threads enabled by default.
  # Allow them to be explicitly enabled on any other version.
  case ${enable_threads} in
    "")
      case ${target} in
        *-*-netbsd[2-9]* | *-*-netbsdelf[2-9]*)
          thread_file='posix'
          tm_defines="${tm_defines} NETBSD_ENABLE_PTHREADS"
          ;;
      esac
      ;;
    yes | posix)
      thread_file='posix'
      tm_defines="${tm_defines} NETBSD_ENABLE_PTHREADS"
      ;;
  esac

  # NetBSD 1.7 and later are set up to use GCC's crtstuff for
  # ELF configurations.  We will clear extra_parts in the
  # a.out configurations.
  case ${target} in
    *-*-netbsd*1.[7-9]* | *-*-netbsd[2-9]* | *-*-netbsdelf[2-9]*)
      extra_parts="crtbegin.o crtend.o crtbeginS.o crtendS.o crtbeginT.o"
      ;;
  esac

  # NetBSD 2.0 and later provide __cxa_atexit(), which we use by
  # default (unless overridden by --disable-__cxa_atexit).
  case ${target} in
    *-*-netbsd[2-9]* | *-*-netbsdelf[2-9]*)
      default_use_cxa_atexit=yes
      ;;
  esac
  ;;
*-*-openbsd*)
  tmake_file="t-libc-ok t-openbsd t-libgcc-pic"
  case ${enable_threads} in
    yes)
      thread_file='posix'
      tmake_file="${tmake_file} t-openbsd-thread"
      ;;
  esac
  ;;
*-*-rtems*)
  case ${enable_threads} in
    yes) thread_file='rtems' ;;
  esac
  ;;
*-*-vxworks*)
  tmake_file=t-vxworks
  tm_file="${tm_file} elfos.h svr4.h vxworks.h"
  case ${enable_threads} in
    no) ;;
    "" | yes | vxworks) thread_file='vxworks' ;;
    *) echo 'Unknown thread configuration for VxWorks'; exit 1 ;;
  esac
  use_collect2=yes
  xm_defines=POSIX
  ;;
esac

case ${target} in
# Support site-specific machine types.
*local*)
	rest=`echo ${target} | sed -e "s/$cpu_type-//"`
	tm_file=${cpu_type}/$rest.h
	if test -f $srcdir/config/${cpu_type}/xm-$rest.h
	then xm_file=${cpu_type}/xm-$rest.h
	fi
	if test -f $srcdir/config/${cpu_type}/t-$rest
	then tmake_file=${cpu_type}/t-$rest
	fi
	;;
alpha*-*-unicosmk*)
	use_collect2=yes
	tm_file="${tm_file} alpha/unicosmk.h"

	# Don't include t-ieee for now because we don't support that yet
	# tmake_file="alpha/t-ieee"
	tmake_file="alpha/t-unicosmk"
	use_fixproto=yes
	;;
alpha*-*-linux*)
	tm_file="${tm_file} alpha/elf.h alpha/linux.h alpha/linux-elf.h"
	target_cpu_default="MASK_GAS"
	tmake_file="t-slibgcc-elf-ver t-linux alpha/t-crtfm alpha/t-alpha alpha/t-ieee"
	;;
alpha*-*-gnu*)
	target_cpu_default="MASK_GAS"
	tmake_file="${tmake_file} alpha/t-crtfm alpha/t-alpha alpha/t-ieee"
	;;
alpha*-*-freebsd*)
	tm_file="${tm_file} ${fbsd_tm_file} alpha/elf.h alpha/freebsd.h"
	target_cpu_default="MASK_GAS"
	tmake_file="${tmake_file} alpha/t-crtfm alpha/t-alpha alpha/t-ieee"
	extra_parts="crtbegin.o crtend.o crtbeginS.o crtendS.o crtbeginT.o"
	;;
alpha*-*-netbsd*)
	tm_file="${tm_file} netbsd.h alpha/elf.h netbsd-elf.h alpha/netbsd.h"
	target_cpu_default="MASK_GAS"
	tmake_file="${tmake_file} alpha/t-alpha alpha/t-ieee"
	;;
alpha*-*-openbsd*)
	tm_defines="OBSD_NO_DYNAMIC_LIBRARIES OBSD_HAS_DECLARE_FUNCTION_NAME OBSD_HAS_DECLARE_FUNCTION_SIZE OBSD_HAS_DECLARE_OBJECT"
	tm_file="alpha/alpha.h openbsd.h alpha/openbsd.h"
	# default x-alpha is only appropriate for dec-osf.
	target_cpu_default="MASK_GAS"
	tmake_file="alpha/t-alpha alpha/t-ieee"
	;;
alpha*-dec-osf[45]*)
	if test x$stabs = xyes
	then
		tm_file="${tm_file} dbx.h"
	fi
	if test x$gas != xyes
	then
		extra_passes="mips-tfile mips-tdump"
	fi
	use_collect2=yes
	tmake_file="alpha/t-alpha alpha/t-ieee alpha/t-crtfm alpha/t-osf4"
	tm_file="${tm_file} alpha/osf.h"
	extra_headers=va_list.h
	case ${target} in
	  *-*-osf4*)
	    # Set target_cpu_default except on 4.0a.
	    case ${target} in
		*-*-osf4.0a) ;;
		*) target_cpu_default=MASK_SUPPORT_ARCH
	    esac
	    ;;
	  *-*-osf5*)
	    tm_file="${tm_file} alpha/osf5.h"
	    target_cpu_default=MASK_SUPPORT_ARCH
	    ;;
	esac
	case ${enable_threads} in
	  "" | yes | posix)
	    thread_file='posix'
	    tmake_file="${tmake_file} alpha/t-osf-pthread"
	    ;;
	esac
	;;
alpha64-dec-*vms*)
	tm_file="${tm_file} alpha/vms.h alpha/vms64.h"
	xm_file="alpha/xm-vms.h"
	tmake_file="alpha/t-alpha alpha/t-vms alpha/t-vms64 alpha/t-ieee"
	prefix=/gnu
	local_prefix=/gnu
	;;
alpha*-dec-*vms*)
	tm_file="${tm_file} alpha/vms.h"
	xm_file=alpha/xm-vms.h
	tmake_file="alpha/t-alpha alpha/t-vms alpha/t-ieee"
	prefix=/gnu
	local_prefix=/gnu
	;;
arc-*-elf*)
	tm_file="dbxelf.h elfos.h svr4.h ${tm_file}"
	extra_parts="crtinit.o crtfini.o"
	use_fixproto=yes
	;;
arm-*-coff* | armel-*-coff*)
	tm_file="arm/semi.h arm/aout.h arm/arm.h arm/coff.h dbxcoff.h"
	tmake_file=arm/t-arm-coff
	;;
arm-semi-aof | armel-semi-aof)
	tm_file="arm/semiaof.h arm/aof.h arm/arm.h"
	tmake_file=arm/t-semi
	;;
arm-wrs-vxworks)
	tm_file="dbxelf.h elfos.h svr4.h vxworks.h arm/elf.h arm/aout.h arm/arm.h arm/vxworks.h"
	tmake_file="${tmake_file} arm/t-vxworks"
	;;
arm*-*-freebsd*|strongarm*-*-freebsd*)
	tm_file="dbxelf.h elfos.h ${fbsd_tm_file} arm/elf.h arm/aout.h arm/freebsd.h arm/arm.h"
	tmake_file="${tmake_file} arm/t-strongarm-elf"
	;;
arm*-*-netbsdelf*)
	tm_file="dbxelf.h elfos.h netbsd.h netbsd-elf.h arm/elf.h arm/aout.h arm/arm.h arm/netbsd-elf.h"
	tmake_file="${tmake_file} arm/t-netbsd"
	;;
arm*-*-netbsd*)
	tm_file="arm/aout.h arm/arm.h netbsd.h netbsd-aout.h arm/netbsd.h"
	tmake_file="t-netbsd arm/t-netbsd"
	extra_parts=""
	use_collect2=yes
	;;
arm*-*-linux*)			# ARM GNU/Linux with ELF
	tm_file="dbxelf.h elfos.h linux.h arm/elf.h  arm/linux-gas.h arm/linux-elf.h arm/aout.h arm/arm.h"
	tmake_file="t-slibgcc-elf-ver t-linux arm/t-linux"
	extra_parts="crtbegin.o crtbeginS.o crtend.o crtendS.o"
	gnu_ld=yes
	;;
arm*-*-uclinux*)		# ARM ucLinux
	tm_file="dbxelf.h elfos.h arm/unknown-elf.h arm/elf.h arm/aout.h arm/arm.h arm/linux-gas.h arm/linux-elf.h arm/uclinux-elf.h"
	tmake_file=arm/t-arm-elf
	;;
arm*-*-ecos-elf)
	tm_file="dbxelf.h elfos.h arm/unknown-elf.h arm/elf.h arm/aout.h arm/arm.h arm/ecos-elf.h"
	tmake_file=arm/t-arm-elf
	;;
arm*-*-rtems*)
	tm_file="dbxelf.h elfos.h arm/unknown-elf.h arm/elf.h arm/aout.h arm/arm.h arm/rtems-elf.h rtems.h"
	tmake_file="arm/t-arm-elf t-rtems"
	;;
arm*-*-elf | ep9312-*-elf)
	tm_file="dbxelf.h elfos.h arm/unknown-elf.h arm/elf.h arm/aout.h arm/arm.h"
	tmake_file=arm/t-arm-elf
	;;
arm*-wince-pe*)
	tm_file="arm/semi.h arm/aout.h arm/arm.h arm/coff.h dbxcoff.h arm/pe.h arm/wince-pe.h"
	tmake_file=arm/t-wince-pe
	extra_objs="pe.o"
	;;
arm-*-pe*)
	tm_file="arm/semi.h arm/aout.h arm/arm.h arm/coff.h dbxcoff.h arm/pe.h"
	tmake_file=arm/t-pe
	extra_objs="pe.o"
	;;
arm*-*-kaos*)
	tm_file="dbxelf.h elfos.h arm/unknown-elf.h arm/elf.h arm/aout.h arm/arm.h kaos.h arm/kaos-arm.h"
	tmake_file=arm/t-arm-elf
	;;
avr-*-*)
	tm_file="avr/avr.h dbxelf.h"
	use_fixproto=yes
	;;
c4x-*-rtems* | tic4x-*-rtems*)
	tmake_file="c4x/t-c4x t-rtems"
	tm_file="c4x/c4x.h c4x/rtems.h rtems.h"
	c_target_objs="c4x-c.o"
	cxx_target_objs="c4x-c.o"
	;;
c4x-* | tic4x-*)
	tmake_file=c4x/t-c4x
	c_target_objs="c4x-c.o"
	cxx_target_objs="c4x-c.o"
	;;
cris-*-aout)
	tm_file="dbxelf.h ${tm_file} cris/aout.h"
	gas=yes
	tmake_file="cris/t-cris cris/t-aout"
	;;
cris-*-elf | cris-*-none)
	tm_file="dbxelf.h elfos.h ${tm_file}"
	tmake_file="cris/t-cris cris/t-elfmulti"
	gas=yes
	;;
cris-*-linux*)
	tm_file="dbxelf.h elfos.h svr4.h ${tm_file} linux.h cris/linux.h"
	tmake_file="cris/t-cris t-slibgcc-elf-ver cris/t-linux"
	;;
d30v-*)
	tm_file="dbxelf.h elfos.h svr4.h ${tm_file}"
	;;
dsp16xx-*)
	use_fixproto=yes
	;;
fr30-*-elf)
	tm_file="dbxelf.h elfos.h svr4.h ${tm_file}"
	tmake_file=fr30/t-fr30
	extra_parts="crti.o crtn.o crtbegin.o crtend.o"
	use_fixproto=yes
	;;
frv-*-elf)
	tm_file="dbxelf.h elfos.h svr4.h ${tm_file} frv/frv-abi.h"
	tmake_file=frv/t-frv
	use_fixproto=yes
	;;
h8300-*-rtems*)
	tmake_file="h8300/t-h8300 t-rtems h8300/t-rtems"
	tm_file="h8300/h8300.h dbxcoff.h h8300/coff.h h8300/rtems.h rtems.h"
	;;
h8300-*-elf*)
	tmake_file="h8300/t-h8300 h8300/t-elf"
	tm_file="h8300/h8300.h dbxelf.h elfos.h h8300/elf.h"
	use_fixproto=yes
	;;
h8300-*-*)
	tm_file="h8300/h8300.h dbxcoff.h h8300/coff.h"
	use_fixproto=yes
	;;
hppa*64*-*-linux* | parisc*64*-*-linux*)
	target_cpu_default="(MASK_PA_11 | MASK_PA_20)"
	tm_file="pa/pa64-start.h ${tm_file} dbxelf.h elfos.h svr4.h linux.h \
		 pa/pa-linux.h pa/pa64-regs.h pa/pa-64.h pa/pa64-linux.h"
	tmake_file="t-slibgcc-elf-ver t-linux pa/t-linux64"
	gas=yes gnu_ld=yes
	need_64bit_hwint=yes
	;;
hppa*-*-linux* | parisc*-*-linux*)
	target_cpu_default="MASK_PA_11 | MASK_NO_SPACE_REGS"
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h linux.h pa/pa-linux.h \
		 pa/pa32-regs.h pa/pa32-linux.h"
	tmake_file="t-slibgcc-elf-ver t-linux pa/t-linux"
	# if not configured with --enable-sjlj-exceptions, bump the
	# libgcc version number
	if test x$sjlj != x1; then
	    tmake_file="$tmake_file pa/t-slibgcc-elf-ver"
	fi
	;;
# port not yet contributed.
#hppa*-*-openbsd*)
#	target_cpu_default="MASK_PA_11"
#	;;
hppa1.1-*-pro*)
	target_cpu_default="(MASK_JUMP_IN_DELAY | MASK_PORTABLE_RUNTIME | MASK_GAS | MASK_NO_SPACE_REGS | MASK_SOFT_FLOAT)"
	tm_file="${tm_file} pa/pa32-regs.h dbxelf.h elfos.h pa/elf.h pa/pa-pro-end.h libgloss.h"
	tmake_file="pa/t-pro"
	;;
hppa1.1-*-osf*)
	target_cpu_default="MASK_PA_11"
	tm_file="${tm_file} pa/pa32-regs.h dbxelf.h pa/som.h pa/pa-osf.h"
	tmake_file="pa/t-pa"
	use_collect2=yes
	;;
hppa1.1-*-rtems*)
	target_cpu_default="(MASK_JUMP_IN_DELAY | MASK_PORTABLE_RUNTIME | MASK_GAS | MASK_NO_SPACE_REGS | MASK_SOFT_FLOAT)"
	tm_file="${tm_file} pa/pa32-regs.h dbxelf.h elfos.h pa/elf.h pa/pa-pro-end.h libgloss.h pa/rtems.h rtems.h"
	tmake_file="pa/t-pro t-rtems"
	;;
hppa1.1-*-bsd*)
	tm_file="${tm_file} pa/pa32-regs.h dbxelf.h pa/som.h"
	target_cpu_default="MASK_PA_11"
	tmake_file="pa/t-pa"
	use_collect2=yes
	;;
hppa1.1-*-hpux10* | hppa2*-*-hpux10*)
	target_cpu_default="MASK_PA_11"
	tm_file="${tm_file} pa/pa32-regs.h dbxelf.h pa/som.h pa/pa-hpux.h pa/pa-hpux10.h"
	tmake_file="pa/t-pa pa/t-pa-hpux pa/t-hpux-shlib"
	if test x$enable_threads = x; then
	    enable_threads=$have_pthread_h
	fi
	case x${enable_threads} in
	xyes | xdce)
		tmake_file="${tmake_file} pa/t-dce-thr"
		;;
	esac
	use_collect2=yes
	use_fixproto=yes
	;;
hppa1.0-*-hpux10*)
	tm_file="${tm_file} pa/pa32-regs.h dbxelf.h pa/som.h pa/pa-hpux.h pa/pa-hpux10.h"
	tmake_file="pa/t-pa pa/t-pa-hpux pa/t-hpux-shlib"
	if test x$enable_threads = x; then
	    enable_threads=$have_pthread_h
	fi
	case x${enable_threads} in
	xyes | xdce)
		tmake_file="${tmake_file} pa/t-dce-thr"
		;;
	esac
	use_collect2=yes
	use_fixproto=yes
	;;
hppa*64*-*-hpux11*)
	if test x$gas = xyes
	then
		tm_file="pa/pa64-start.h ${tm_file} dbxelf.h elfos.h  \
			 pa/pa64-regs.h pa/pa-hpux.h \
			 pa/pa-hpux11.h pa/pa-64.h pa/pa64-hpux.h"
	else
		tm_file="pa/pa64-start.h ${tm_file} dbxelf.h pa/elf.h \
			 pa/pa64-regs.h pa/pa-hpux.h \
			 pa/pa-hpux11.h pa/pa-64.h pa/pa64-hpux.h"
	fi
	need_64bit_hwint=yes
	tmake_file="pa/t-pa64 pa/t-pa-hpux"
	target_cpu_default="(MASK_PA_11|MASK_PA_20|MASK_GAS)"
	extra_parts="crtbegin.o crtend.o crtbeginS.o crtendS.o crtbeginT.o"
	if test x$gnu_ld = xyes
	then
		target_cpu_default="${target_cpu_default}|MASK_GNU_LD"
	fi
	case x${enable_threads} in
	xyes | xposix )
		thread_file=posix 
		;;
	esac
	;;
hppa1.1-*-hpux11* | hppa2*-*-hpux11*)
	target_cpu_default="MASK_PA_11"
	tm_file="${tm_file} pa/pa32-regs.h dbxelf.h pa/som.h pa/pa-hpux.h pa/pa-hpux11.h"
	tmake_file="pa/t-pa pa/t-pa-hpux pa/t-hpux-shlib"
	case x${enable_threads} in
	xyes | xposix )
		thread_file=posix 
		;;
	esac
	use_collect2=yes
	;;
hppa1.0-*-hpux11*)
	tm_file="${tm_file} pa/pa32-regs.h dbxelf.h pa/som.h pa/pa-hpux.h pa/pa-hpux11.h"
	tmake_file="pa/t-pa pa/t-pa-hpux pa/t-hpux-shlib"
	case x${enable_threads} in
	xyes | xposix )
		thread_file=posix 
		;;
	esac
	use_collect2=yes
	;;
i370-*-opened*)			 # IBM 360/370/390 Architecture
	xm_defines='FATAL_EXIT_CODE=12'
	tm_file="i370/oe.h i370/i370.h"
	tmake_file="i370/t-i370"
	c_target_objs="i370-c.o"
	cxx_target_objs="i370-c.o"
	# Don't bother fixing up header files; they're weird.
	;;
i370-*-mvs*)
	xm_defines='FATAL_EXIT_CODE=12'
	tm_file="i370/mvs.h i370/i370.h"
	tmake_file="i370/t-i370"
	c_target_objs="i370-c.o"
	cxx_target_objs="i370-c.o"
	use_fixproto=yes
	;;
i370-*-linux*)
	tm_file="dbxelf.h elfos.h svr4.h linux.h i370/linux.h i370/i370.h"
	tmake_file="t-slibgcc-elf-ver t-linux"
	# broken_install=yes
	;;
i[34567]86-*-darwin*)
	tm_file="${tm_file} i386/darwin.h"
	;;
i[34567]86-*-elf*)
	tm_file="${tm_file} i386/unix.h i386/att.h dbxelf.h elfos.h i386/i386elf.h"
	tmake_file="i386/t-i386elf t-svr4"
	use_fixproto=yes
	;;
i[34567]86-ncr-sysv4*)		# NCR 3000 - ix86 running system V.4
	xm_defines="SMALL_ARG_MAX"
	tm_file="${tm_file} i386/unix.h i386/att.h dbxelf.h elfos.h svr4.h i386/sysv4.h i386/sysv4-cpp.h"
	extra_parts="crtbegin.o crtend.o"
	tmake_file=i386/t-crtpic
	use_fixproto=yes
	;;
i[34567]86-*-netware)		# Intel 80386's running netware
	tm_file="${tm_file} i386/unix.h i386/att.h dbxelf.h elfos.h svr4.h i386/sysv4.h netware.h i386/netware.h"
	;;
i[34567]86-sequent-ptx4* | i[34567]86-sequent-sysv4*)
	if test x$gas = xyes
	then
		tm_file="${tm_file} usegas.h"
	fi
	xm_defines="SMALL_ARG_MAX"
	tm_file="${tm_file} i386/unix.h i386/att.h dbxelf.h elfos.h ptx4.h i386/ptx4-i.h"
	tmake_file=t-svr4
	extra_parts="crtbegin.o crtend.o"
	use_fixproto=yes
	;;
i[34567]86-*-aout*)
	tm_file="${tm_file} i386/unix.h i386/bsd.h i386/gas.h i386/gstabs.h i386/i386-aout.h"
	use_fixproto=yes
	;;
i[34567]86-*-beoself* | i[34567]86-*-beos*)
	tmake_file='i386/t-beos i386/t-crtpic'
	tm_file="${tm_file} i386/unix.h i386/att.h dbxelf.h elfos.h svr4.h i386/beos-elf.h"
	extra_parts='crtbegin.o crtend.o'
	;;
i[34567]86-*-freebsd2 | i[34567]86-*-freebsd2.* | i[34567]86-*-freebsd*aout*)
	tm_file="${tm_file} i386/unix.h i386/bsd.h i386/gas.h i386/gstabs.h i386/freebsd-aout.h"
	tmake_file=t-freebsd
	;;
i[34567]86-*-freebsd*)
	tm_file="${tm_file} i386/unix.h i386/att.h dbxelf.h elfos.h ${fbsd_tm_file} i386/freebsd.h"
	;;
x86_64-*-freebsd*)
	tm_file="${tm_file} i386/unix.h i386/att.h dbxelf.h elfos.h ${fbsd_tm_file} i386/x86-64.h i386/freebsd.h i386/freebsd64.h"
	;;
i[34567]86-*-netbsdelf*)
	tm_file="${tm_file} i386/unix.h i386/att.h dbxelf.h elfos.h netbsd.h netbsd-elf.h i386/netbsd-elf.h"
	;;
i[34567]86-*-netbsd*)
	tm_file="${tm_file} i386/unix.h i386/bsd.h i386/gas.h i386/gstabs.h netbsd.h netbsd-aout.h i386/netbsd.h"
	tmake_file=t-netbsd
	extra_parts=""
	use_collect2=yes
	;;
x86_64-*-netbsd*)
	tm_file="${tm_file} i386/unix.h i386/att.h dbxelf.h elfos.h netbsd.h netbsd-elf.h i386/x86-64.h i386/netbsd64.h"
	;;
i[34567]86-*-openbsd*)
	tm_file="i386/i386.h i386/unix.h i386/bsd.h i386/gas.h i386/gstabs.h openbsd-oldgas.h openbsd.h i386/openbsd.h"
	# needed to unconfuse gdb
	tmake_file="t-libc-ok t-openbsd i386/t-openbsd"
	# we need collect2 until our bug is fixed...
	use_collect2=yes
	;;
i[34567]86-*-coff*)
	tm_file="${tm_file} i386/unix.h i386/bsd.h i386/gas.h dbxcoff.h i386/i386-coff.h"
	use_fixproto=yes
	;;
i[34567]86-*-linux*aout*)	# Intel 80386's running GNU/Linux
				# with a.out format
	tmake_file="i386/t-crtstuff"
	tm_file="${tm_file} i386/unix.h i386/bsd.h i386/gas.h i386/gstabs.h linux-aout.h i386/linux-aout.h"
	gnu_ld=yes
	;;
i[34567]86-*-linux*libc1)	# Intel 80386's running GNU/Linux
				# with ELF format using the
				# GNU/Linux C library 5
	tm_file="${tm_file} i386/unix.h i386/att.h dbxelf.h elfos.h svr4.h linux.h i386/linux.h"
	tmake_file="t-slibgcc-elf-ver t-linux t-linux-gnulibc1 i386/t-crtstuff"
	extra_parts="crtbegin.o crtbeginS.o crtend.o crtendS.o"
	gnu_ld=yes
	if test x$enable_threads = xyes; then
		thread_file='single'
	fi
	;;
i[34567]86-*-linux*)	# Intel 80386's running GNU/Linux
			# with ELF format using glibc 2
			# aka GNU/Linux C library 6
	tm_file="${tm_file} i386/unix.h i386/att.h dbxelf.h elfos.h svr4.h linux.h i386/linux.h"
	tmake_file="t-slibgcc-elf-ver t-linux i386/t-crtstuff"
	;;
x86_64-*-linux*)
	tm_file="${tm_file} i386/unix.h i386/att.h dbxelf.h elfos.h svr4.h linux.h \
		 i386/x86-64.h i386/linux64.h"
	tmake_file="t-slibgcc-elf-ver t-linux i386/t-linux64"
	;;
i[34567]86-*-kfreebsd*-gnu) # must be before i[34567]86-*-gnu*
	tm_file="${tm_file} i386/unix.h i386/att.h dbxelf.h elfos.h svr4.h linux.h i386/linux.h kfreebsdgnu.h i386/kfreebsdgnu.h"
	tmake_file="t-slibgcc-elf-ver t-kfreebsd-gnu i386/t-crtstuff"
	float_format=i386
	use_fixproto=no
	;;
i[34567]86-*-gnu*)
	;;
i[34567]86-pc-msdosdjgpp*)
	xm_file=i386/xm-djgpp.h
	tm_file="dbxcoff.h ${tm_file} i386/unix.h i386/bsd.h i386/gas.h i386/djgpp.h"
	tmake_file=i386/t-djgpp
	gnu_ld=yes
	gas=yes
	;;
i[34567]86-moss-msdos* | i[34567]86-*-moss*)
	tm_file="${tm_file} i386/unix.h i386/att.h dbxelf.h elfos.h svr4.h linux.h i386/linux.h i386/moss.h"
	tmake_file=t-libc-ok
	gnu_ld=yes
	gas=yes
	use_fixproto=yes
	;;
i[34567]86-*-lynxos*)
	if test x$gas = xyes
	then
		tm_file="${tm_file} i386/unix.h i386/bsd.h i386/gas.h i386/gstabs.h svr3.h lynx.h i386/lynx.h"
	else
		tm_file="${tm_file} i386/unix.h i386/bsd.h i386/gas.h i386/gstabs.h lynx-ng.h i386/lynx-ng.h"
	fi
	use_fixproto=yes
	;;
i[34567]86-*-mach*)
	tm_file="${tm_file} i386/unix.h i386/bsd.h i386/gas.h i386/gstabs.h i386/mach.h"
#	tmake_file=t-libc-ok
	use_collect2=yes
	use_fixproto=yes
	;;
i[34567]86-*-nto-qnx*)
	tm_file="${tm_file} i386/att.h dbxelf.h tm-dwarf2.h elfos.h svr4.h i386/unix.h i386/nto.h"
	tmake_file=i386/t-nto
	gnu_ld=yes
	gas=yes
	;;
i[34567]86-*-rtems*)
	tm_file="${tm_file} i386/unix.h i386/att.h dbxelf.h elfos.h i386/i386elf.h i386/rtemself.h rtems.h"
	extra_parts="crtbegin.o crtend.o crti.o crtn.o"
	tmake_file="i386/t-rtems-i386 i386/t-crtstuff t-rtems"
	;;
i[34567]86-*-sco3.2v5*)	# 80386 running SCO Open Server 5
	tm_file="${tm_file} i386/unix.h i386/att.h dbxelf.h elfos.h i386/sco5.h"
	if test x$gas = xyes
	then
		tm_file="usegas.h ${tm_file}"
	fi
	tmake_file=i386/t-sco5
	extra_parts="crtbegin.o crtend.o"
	use_fixproto=yes
	;;
i[34567]86-*-solaris2*)
	xm_defines="SMALL_ARG_MAX"
	tm_file="${tm_file} i386/unix.h i386/att.h dbxelf.h elfos.h svr4.h i386/sysv4.h sol2.h i386/sol2.h"
	tmake_file="i386/t-sol2 t-svr4"
	if test x$gnu_ld = xyes; then
		tmake_file="$tmake_file t-slibgcc-elf-ver"
	else
		tmake_file="$tmake_file t-slibgcc-sld"
	fi
	case ${target} in
	*-*-solaris2.[789] | *-*-solaris2.1[0-9])
		tm_file="$tm_file tm-dwarf2.h"
		;;
	esac
	extra_parts="crt1.o crti.o crtn.o gcrt1.o gmon.o crtbegin.o crtend.o"
	if test x${enable_threads} = x; then
	    enable_threads=$have_pthread_h
	    if test x${enable_threads} = x; then
		enable_threads=$have_thread_h
	    fi
	fi
	if test x${enable_threads} = xyes; then
	    if test x${have_pthread_h} = xyes; then
		thread_file='posix'
	    else
		thread_file='solaris'
	    fi
	fi
	;;
i[34567]86-*-sysv5*)           # Intel x86 on System V Release 5
       tm_file="${tm_file} i386/unix.h i386/att.h dbxelf.h elfos.h svr4.h i386/sysv4.h i386/sysv5.h"
       if test x$stabs = xyes
       then
               tm_file="${tm_file} dbx.h"
       fi
       tmake_file="i386/t-crtpic t-svr4"
       extra_parts="crtbegin.o crtend.o"
       if test x$enable_threads = xyes; then
	       thread_file='posix'
       fi
	use_fixproto=yes
       ;;
i[34567]86-*-sysv4*)		# Intel 80386's running system V.4
	xm_defines="SMALL_ARG_MAX"
	tm_file="${tm_file} i386/unix.h i386/att.h dbxelf.h elfos.h svr4.h i386/sysv4.h i386/sysv4-cpp.h"
	if test x$stabs = xyes
	then
		tm_file="${tm_file} dbx.h"
	fi
	tmake_file="i386/t-crtpic t-svr4"
	extra_parts="crtbegin.o crtend.o"
	use_fixproto=yes
	;;
i[34567]86-*-udk*)      # Intel x86 on SCO UW/OSR5 Dev Kit
	tm_file="${tm_file} i386/unix.h i386/att.h dbxelf.h elfos.h svr4.h i386/sysv4.h i386/sysv5.h i386/udk.h"
	tmake_file="i386/t-crtpic i386/t-udk t-svr4"
	extra_parts="crtbegin.o crtend.o"
	use_fixproto=yes
	;;
i[34567]86-*-sysv*)		# Intel 80386's running system V
	if test x$gas = xyes
	then
		if test x$stabs = xyes
		then
			tm_file="${tm_file} i386/unix.h i386/bsd.h i386/gas.h i386/svr3gas.h i386/svr3dbx.h"
			tmake_file=i386/t-svr3dbx
			extra_parts="svr3.ifile svr3z.ifile"
		else
			tm_file="${tm_file} i386/unix.h i386/bsd.h i386/gas.h i386/svr3gas.h"
			extra_parts="crtbegin.o crtend.o"
			tmake_file=i386/t-crtstuff
		fi
	else
		tm_file="${tm_file} svr3.h i386/unix.h i386/att.h i386/sysv3.h"
		extra_parts="crtbegin.o crtend.o"
		tmake_file=i386/t-crtstuff
	fi
	tmake_file="$tmake_file i386/t-crtpic"
	use_fixproto=yes
	;;
i386-*-vsta)			# Intel 80386's running VSTa kernel
	xm_file="i386/xm-vsta.h"
	tm_file="${tm_file} i386/unix.h i386/bsd.h i386/gas.h i386/vsta.h"
	use_fixproto=yes
	;;
i[4567]86-wrs-vxworks)
	tm_file="${tm_file} i386/sysv4.h i386/unix.h i386/vxworks.h"
	tmake_file="${tmake_file} i386/t-vxworks"
	;;
i[34567]86-*-pe | i[34567]86-*-cygwin*)
	tm_file="${tm_file} i386/unix.h i386/bsd.h i386/gas.h dbxcoff.h i386/cygming.h i386/cygwin.h"
	target_gtfiles="\$(srcdir)/config/i386/winnt.c"
	xm_file=i386/xm-cygwin.h
	tmake_file="i386/t-cygwin i386/t-cygming"
	extra_objs=winnt.o
	c_target_objs=cygwin2.o
	cxx_target_objs=cygwin2.o
	extra_gcc_objs=cygwin1.o
	if test x$enable_threads = xyes; then
		thread_file='posix'
	fi
	;;
i[34567]86-*-mingw32*)
	tm_file="${tm_file} i386/unix.h i386/bsd.h i386/gas.h dbxcoff.h i386/cygming.h i386/mingw32.h"
	xm_file=i386/xm-mingw32.h
	tmake_file="i386/t-cygming i386/t-mingw32"
	target_gtfiles="\$(srcdir)/config/i386/winnt.c"
	extra_objs=winnt.o
	extra_parts="crtbegin.o crtend.o"
	target_cpu_default=TARGET_CPU_DEFAULT_pentiumpro
	if test x$enable_threads = xyes; then
		thread_file='win32'
	fi
	case ${target} in
		*mingw32crt*)
			tm_file="${tm_file} i386/crtdll.h"
			;;
		*mingw32msv* | *mingw32*)
			;;
	esac
	;;
i[34567]86-*-uwin*)
	tm_file="${tm_file} i386/unix.h i386/bsd.h i386/gas.h dbxcoff.h i386/cygwin.h i386/uwin.h"
	tmake_file="i386/t-cygwin i386/t-uwin"
	target_gtfiles="\$(srcdir)/config/i386/winnt.c"
	extra_objs=winnt.o
	if test x$enable_threads = xyes; then
		thread_file='win32'
	fi
	use_fixproto=yes
	;;
i[34567]86-*-interix3*)
	tm_file="${tm_file} i386/unix.h i386/bsd.h i386/gas.h i386/i386-interix.h i386/i386-interix3.h interix.h interix3.h"
	tmake_file="i386/t-interix"
	extra_objs=winnt.o
	target_gtfiles="\$(srcdir)/config/i386/winnt.c"
	if test x$enable_threads = xyes ; then
		thread_file='posix'
	fi
	if test x$stabs = xyes ; then
		tm_file="${tm_file} dbxcoff.h"
	fi
	;;
i[34567]86-*-interix*)
	tm_file="${tm_file} i386/unix.h i386/bsd.h i386/gas.h i386/i386-interix.h interix.h"
	tmake_file="i386/t-interix"
	extra_objs=winnt.o
	if test x$enable_threads = xyes ; then
		thread_file='posix'
	fi
	if test x$stabs = xyes ; then
		tm_file="${tm_file} dbxcoff.h"
	fi
	;;
i[34567]86-*-kaos*)
	tm_file="${tm_file} i386/unix.h i386/att.h dbxelf.h elfos.h i386/i386elf.h kaos.h i386/kaos-i386.h"
	tmake_file="i386/t-i386elf t-svr4"
	;;
i860-*-sysv4*)
        tm_file="${tm_file} elfos.h svr4.h i860/sysv4.h"
        tmake_file="i860/t-i860 i860/t-svr4"
        extra_parts="crtbegin.o crtend.o"
	use_fixproto=yes
        ;;
i960-*-coff*)
	tm_file="${tm_file} dbxcoff.h i960/i960-coff.h libgloss.h"
	tmake_file=i960/t-960bare
	c_target_objs="i960-c.o"
	cxx_target_objs="i960-c.o"
	;;
i960-*-rtems)
	tmake_file="i960/t-960bare t-rtems"
	tm_file="${tm_file} dbxcoff.h i960/i960-coff.h i960/rtems.h rtems.h"
	c_target_objs="i960-c.o"
	cxx_target_objs="i960-c.o"
	;;
i960-*-*)			# Default i960 environment.
	use_collect2=yes
	tmake_file=i960/t-960bare
	c_target_objs="i960-c.o"
	cxx_target_objs="i960-c.o"
	use_fixproto=yes
	;;
ia64*-*-elf*)
	tm_file="${tm_file} dbxelf.h elfos.h ia64/sysv4.h ia64/elf.h"
	tmake_file="ia64/t-ia64"
	target_cpu_default="0"
	if test x$gas = xyes
	then
		target_cpu_default="${target_cpu_default}|MASK_GNU_AS"
	fi
	if test x$gnu_ld = xyes
	then
		target_cpu_default="${target_cpu_default}|MASK_GNU_LD"
	fi
	extra_parts="crtbegin.o crtend.o crtbeginS.o crtendS.o crtfastmath.o"
	use_fixproto=yes
	;;
ia64*-*-freebsd*)
	tm_file="${tm_file} dbxelf.h elfos.h ${fbsd_tm_file} ia64/sysv4.h ia64/freebsd.h"
	target_cpu_default="MASK_GNU_AS|MASK_GNU_LD"
	tmake_file="${tmake_file} ia64/t-ia64"
	extra_parts="crtbegin.o crtend.o crtbeginS.o crtendS.o crtfastmath.o"
	;;
ia64*-*-linux*)
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h linux.h ia64/sysv4.h ia64/linux.h"
	tmake_file="t-slibgcc-elf-ver t-linux ia64/t-ia64 ia64/t-glibc"
	target_cpu_default="MASK_GNU_AS|MASK_GNU_LD"
	extra_parts="crtbegin.o crtend.o crtbeginS.o crtendS.o crtfastmath.o"
	if test x"$use_libunwind_exceptions" = xyes; then
	  tmake_file="$tmake_file t-libunwind"
	fi
	;;
ia64*-*-hpux*)
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h ia64/sysv4.h ia64/hpux.h"
	tmake_file="ia64/t-ia64 ia64/t-hpux"
	target_cpu_default="MASK_GNU_AS"
	case x$enable_threads in
	xyes | xposix )
		thread_file=posix
		;;
	esac
	use_collect2=no
	c_target_objs="ia64-c.o"
	cxx_target_objs="ia64-c.o"
	# If we decide to run fixproto we should define FIXPROTO_DEFINES
	# in ia64/t-hpux, and also fix the definition of putenv in
	# sys-protos.h (const char not char).
	;;
ip2k-*-elf)
	tm_file="elfos.h ${tm_file}"
	use_fixproto=yes
	;;
iq2000*-*-elf*)
        tm_file="svr4.h elfos.h iq2000/iq2000.h"
        tmake_file=iq2000/t-iq2000
        out_file=iq2000/iq2000.c
        md_file=iq2000/iq2000.md
	use_fixproto=yes
        ;;
m32r-*-elf*)
	tm_file="dbxelf.h elfos.h svr4.h ${tm_file}"
	extra_parts="crtinit.o crtfini.o"
	use_fixproto=yes
 	;;
m32rle-*-elf*)
	tm_file="dbxelf.h elfos.h svr4.h m32r/little.h ${tm_file}"
	extra_parts="crtinit.o crtfini.o m32rx/crtinit.o m32rx/crtfini.o"
	use_fixproto=yes
	;;
m32r-*-linux*)
	tm_file="dbxelf.h elfos.h svr4.h linux.h ${tm_file} m32r/linux.h"
	extra_parts="crtbegin.o crtbeginS.o crtend.o crtendS.o"
	tmake_file="m32r/t-linux"
	gnu_ld=yes
	use_fixproto=yes
	if test x$enable_threads = xyes; then
		thread_file='posix'
	fi
 	;;
m32rle-*-linux*)
	tm_file="dbxelf.h elfos.h svr4.h linux.h m32r/little.h ${tm_file} m32r/linux.h"
	extra_parts="crtbegin.o crtbeginS.o crtend.o crtendS.o"
	tmake_file="m32r/t-linux"
	gnu_ld=yes
	use_fixproto=yes
	if test x$enable_threads = xyes; then
		thread_file='posix'
	fi
	;;
# m68hc11 and m68hc12 share the same machine description.
m68hc11-*-*|m6811-*-*)
	tm_file="dbxelf.h elfos.h m68hc11/m68hc11.h"
	tm_p_file="m68hc11/m68hc11-protos.h"
	md_file="m68hc11/m68hc11.md"
	out_file="m68hc11/m68hc11.c"
	tmake_file="m68hc11/t-m68hc11-gas"
	use_fixproto=yes
        ;;
m68hc12-*-*|m6812-*-*)
	tm_file="m68hc11/m68hc12.h dbxelf.h elfos.h m68hc11/m68hc11.h"
	tm_p_file="m68hc11/m68hc11-protos.h"
	md_file="m68hc11/m68hc11.md"
	out_file="m68hc11/m68hc11.c"
	tmake_file="m68hc11/t-m68hc11-gas"
	use_fixproto=yes
        ;;
m68000-hp-hpux*)		# HP 9000 series 300
	tm_file="m68k/hp320base.h m68k/m68k.h m68k/hp320.h m68k/hp310.h"
	tm_defines="TARGET_DEFAULT=0" # 68000, no 68881, no bitfield ops
	if test x$gas = xyes
	then
		tm_defines="${tm_defines} DBX_DEBUGGING_INFO=1 USE_GAS"
	fi
	tmake_file=m68k/t-hp320
	use_collect2=yes
	use_fixproto=yes
	;;
m68k-hp-hpux7*)	# HP 9000 series 300 running HPUX version 7.
	tm_file="m68k/hp320base.h m68k/m68k.h m68k/hp320.h"
	if test x$gas = xyes
	then
		tm_defines="DBX_DEBUGGING_INFO=1 USE_GAS"
	else
		tm_defines="NO_DOT_IN_LABEL NO_BUGS"
	fi
	use_collect2=yes
	use_fixproto=yes
	;;
m68k-hp-hpux*)	# HP 9000 series 300
	tm_file="m68k/hp320base.h m68k/m68k.h m68k/hp320.h"
	if test x$gas = xyes
	then
		tm_defines="DBX_DEBUGGING_INFO=1 USE_GAS"
	fi
	use_collect2=yes
	use_fixproto=yes
	;;
m68k-*-aout*)
	tmake_file=m68k/t-m68kbare
	tm_file="m68k/m68k.h m68k/m68k-none.h m68k/m68kemb.h m68k/m68k-aout.h libgloss.h"
	;;
m68k-*-coff*)
	tmake_file=m68k/t-m68kbare
	tm_defines="MOTOROLA USE_GAS"
	tm_file="m68k/m68k.h m68k/m68k-none.h m68k/m68kemb.h dbxcoff.h m68k/coff.h dbx.h"
	use_fixproto=yes
	;;
m68020-*-elf* | m68k-*-elf*)
	tm_file="m68k/m68k.h m68k/m68k-none.h m68k/m68kelf.h dbxelf.h elfos.h m68k/m68kemb.h m68k/m68020-elf.h"
	tm_defines="MOTOROLA USE_GAS"
	tmake_file=m68k/t-m68kelf
	extra_parts="crtbegin.o crtend.o"
	use_fixproto=yes
	;;
m68010-*-netbsdelf* | m68k*-*-netbsdelf*)
	tm_file="${tm_file} dbxelf.h elfos.h netbsd.h netbsd-elf.h m68k/netbsd-elf.h"
	tm_defines="MOTOROLA USE_GAS"
	case ${target} in
	m68010*)
		target_cpu_default="0"
		;;
	*)
		target_cpu_default="MASK_68020|MASK_68881|MASK_BITFIELD"
		;;
	esac
	;;
m68k*-*-netbsd*)
    if test "x$enable_obsolete" != xyes; then
      echo "*** Configuration ${target} is obsolete." >&2
      echo "*** Specify --enable-obsolete to build it anyway." >&2
      echo "*** Support will be REMOVED in the next major release of GCC," >&2
      echo "*** unless a maintainer comes forward." >&2
      exit 1
    fi
	tm_file="m68k/m68k.h netbsd.h netbsd-aout.h m68k/netbsd.h"
	tmake_file=t-netbsd
	extra_parts=""
	use_collect2=yes
	;;
m68k*-*-openbsd*)
	# needed to unconfuse gdb
	tm_defines="OBSD_OLD_GAS TARGET_DEFAULT=(MASK_68020|MASK_68881|MASK_BITFIELD)"
	tm_file="m68k/m68k.h openbsd.h m68k/openbsd.h"
	tmake_file="t-libc-ok t-openbsd m68k/t-openbsd"
	# we need collect2 until our bug is fixed...
	use_collect2=yes
	;;
m68k-*-sysv4*)			# Motorola m68k's running system V.4
	tm_file="m68k/m68k.h m68k/sgs.h dbxelf.h elfos.h svr4.h m68k/m68kv4.h"
	tm_defines="MOTOROLA SGS SGS_CMP_ORDER SGS_SWITCH_TABLES"
	tmake_file=t-svr4
	extra_parts="crtbegin.o crtend.o"
	use_fixproto=yes
	;;
m68k-*-uclinux*)		# Motorola m68k/ColdFire running uClinux with uClibc
	tm_file="m68k/m68k.h m68k/m68k-none.h m68k/m68kelf.h dbxelf.h elfos.h m68k/uclinux.h"
 	tm_defines="MOTOROLA USE_GAS"
	tmake_file=m68k/t-uclinux
	use_fixproto=no
	;;
m68k-*-linux*)		# Motorola m68k's running GNU/Linux
				# with ELF format using glibc 2
				# aka the GNU/Linux C library 6.
	tm_file="m68k/m68k.h dbxelf.h elfos.h svr4.h linux.h m68k/linux.h"
	tm_defines="MOTOROLA USE_GAS"
	tmake_file="t-slibgcc-elf-ver t-linux"
	# if not configured with --enable-sjlj-exceptions, bump the
	# libgcc version number
	if test x$sjlj != x1; then
	    tmake_file="$tmake_file m68k/t-slibgcc-elf-ver"
	fi
	;;
m68k-*-rtems*)
	tmake_file="m68k/t-m68kbare m68k/t-crtstuff t-rtems m68k/t-rtems"
	tm_file="m68k/m68k.h m68k/m68k-none.h m68k/m68kelf.h dbxelf.h elfos.h m68k/m68kemb.h m68k/m68020-elf.h m68k/rtemself.h rtems.h"
	tm_defines="MOTOROLA USE_GAS"
	extra_parts="crtbegin.o crtend.o"
	;;
mcore-*-elf)
	tm_file="dbxelf.h elfos.h svr4.h ${tm_file} mcore/mcore-elf.h"
	tmake_file=mcore/t-mcore
	use_fixproto=yes
	;;
mcore-*-pe*)
	tm_file="svr3.h dbxcoff.h ${tm_file} mcore/mcore-pe.h"
	tmake_file=mcore/t-mcore-pe
	use_fixproto=yes
	;;
mips-sgi-irix6*)		# SGI System V.4., IRIX 6
	tm_file="${tm_file} mips/iris5.h mips/iris6.h"
	tmake_file="mips/t-iris mips/t-iris5-6 mips/t-iris6"
	if test x$gas = xyes
	then
		tm_file="${tm_file} mips/iris6gas.h"
	fi
	if test "x$gnu_ld" = xyes
	then
		tm_file="${tm_file} mips/iris6gld.h"
		tmake_file="$tmake_file mips/t-irix-gld"
	fi
	target_cpu_default="MASK_ABICALLS|MASK_FLOAT64|MASK_64BIT"
	tm_defines="MIPS_ISA_DEFAULT=3 MIPS_ABI_DEFAULT=ABI_N32"
	# See comment in mips/iris5.h file.  Only enabled for O32 ABI
	# without GNU as.
	if test x$gas = xno
	then
		use_collect2=yes
	fi
#	if test x$enable_threads = xyes; then
#		thread_file='irix'
#	fi
	use_fixproto=yes
	;;
mips-sgi-irix5cross64)		# Irix5 host, Irix 6 target, cross64
	tm_file="${tm_file} mips/iris5.h mips/iris6.h mips/cross64.h"
	tmake_file="mips/t-iris mips/t-cross64"
	target_cpu_default="MASK_ABICALLS|MASK_FLOAT64|MASK_64BIT"
	tm_defines="MIPS_ISA_DEFAULT=3 MIPS_ABI_DEFAULT=ABI_N32"
	# See comment in mips/iris[56].h files.
	use_collect2=yes
#	if test x$enable_threads = xyes; then
#		thread_file='irix'
#	fi
	use_fixproto=yes
	;;
mips-sgi-irix5*)		# SGI System V.4., IRIX 5
	tm_file="${tm_file} mips/iris5.h"
	if test x$gas = xyes
	then
		tm_file="${tm_file} mips/sdb.h mips/iris5gas.h"
		if test x$stabs = xyes
		then
			tm_file="${tm_file} dbx.h mips/dbxmdebug.h"
		fi
		tmake_file=mips/t-iris5-gas
	else
		tmake_file=mips/t-iris5-as
	fi
	if test "x$gnu_ld" = xyes
	then
		tm_file="${tm_file} mips/iris5gld.h"
		tmake_file="$tmake_file mips/t-irix-gld"
	fi
	tmake_file="${tmake_file} mips/t-iris mips/t-iris5-6"
	target_cpu_default="MASK_ABICALLS"
	# mips-tfile doesn't work yet
	# See comment in mips/iris5.h file.
	if test x$gas = xno
	then
		use_collect2=yes
	fi
#	if test x$enable_threads = xyes; then
#		thread_file='irix'
#	fi
	use_fixproto=yes
	;;
mips*-*-netbsd*)			# NetBSD/mips, either endian.
	target_cpu_default="MASK_GAS|MASK_ABICALLS"
	tm_file="elfos.h ${tm_file} mips/elf.h netbsd.h netbsd-elf.h mips/netbsd.h"
	;;
mips64*-*-linux*)
	tm_file="dbxelf.h elfos.h svr4.h linux.h ${tm_file} mips/linux.h mips/linux64.h"
	tmake_file="t-slibgcc-elf-ver t-linux mips/t-linux64"

	# This default ABI is a partial lie: t-linux64 overrides the
	# DRIVER_SELF_SPEC that sets the default abi, in the spec file
	# that is installed.  What GCC thinks of as the default must
	# remain as ABI_32 such that the SONAMEs of the libgcc shared
	# libraries remain compatible with those of mips-linux-gnu.
	tm_defines="MIPS_ISA_DEFAULT=1 MIPS_ABI_DEFAULT=ABI_32"
	target_cpu_default="MASK_ABICALLS|MASK_FLOAT64|MASK_64BIT"
	extra_parts="crtbegin.o crtbeginS.o crtbeginT.o crtend.o crtendS.o"
	gnu_ld=yes
	gas=yes
	;;
mips*-*-linux*)				# Linux MIPS, either endian.
        tm_file="dbxelf.h elfos.h svr4.h linux.h ${tm_file} mips/linux.h"
	case ${target} in
        mipsisa32*-*)
                target_cpu_default="MASK_SOFT_FLOAT"
		tm_defines="MIPS_ISA_DEFAULT=32"
                ;;
        esac
	tmake_file="t-slibgcc-elf-ver t-linux"
	;;
mips*-*-openbsd*)
	tm_defines="OBSD_HAS_DECLARE_FUNCTION_NAME OBSD_HAS_DECLARE_OBJECT OBSD_HAS_CORRECT_SPECS"
	target_cpu_default="MASK_GAS|MASK_ABICALLS"
	tm_file="mips/mips.h openbsd.h mips/openbsd.h mips/sdb.h"
	case ${target} in
	mips*el-*-openbsd*) 
	    tm_defines="${tm_defines} TARGET_ENDIAN_DEFAULT=0";;
	*)  tm_defines="${tm_defines} TARGET_ENDIAN_DEFAULT=MASK_BIG_ENDIAN";;
        esac
	;;
mipsisa32-*-elf* | mipsisa32el-*-elf*)
	tm_file="${tm_file} mips/elf.h"
	tmake_file=mips/t-isa3264
	tm_defines="MIPS_ISA_DEFAULT=32 MIPS_ABI_DEFAULT=ABI_EABI"
	use_fixproto=yes
	;;
mipsisa32r2-*-elf* | mipsisa32r2el-*-elf*)
	tm_file="${tm_file} mips/elf.h"
	tmake_file=mips/t-isa3264
	tm_defines="MIPS_ISA_DEFAULT=33 MIPS_ABI_DEFAULT=ABI_EABI"
	use_fixproto=yes
	;;
mipsisa64-*-elf* | mipsisa64el-*-elf*)
	tm_file="${tm_file} mips/elf.h"
	tmake_file=mips/t-isa3264
	target_cpu_default="MASK_64BIT|MASK_FLOAT64|MASK_GAS"
	tm_defines="MIPS_ISA_DEFAULT=64 MIPS_ABI_DEFAULT=ABI_EABI"
	use_fixproto=yes
	;;
mipsisa64sr71k-*-elf*)
        tm_file="${tm_file} mips/elf.h"
        tmake_file=mips/t-sr71k
	target_cpu_default="MASK_64BIT|MASK_FLOAT64|MASK_GAS"
	tm_defines="MIPS_ISA_DEFAULT=64 MIPS_CPU_STRING_DEFAULT=\\\"sr71000\\\" MIPS_ABI_DEFAULT=ABI_EABI"
	use_fixproto=yes
        ;;
mipsisa64sb1-*-elf* | mipsisa64sb1el-*-elf*)
	tm_file="${tm_file} mips/elf.h"
	tmake_file=mips/t-elf
	target_cpu_default="MASK_64BIT|MASK_FLOAT64|MASK_GAS"
	tm_defines="MIPS_ISA_DEFAULT=64 MIPS_CPU_STRING_DEFAULT=\\\"sb1\\\" MIPS_ABI_DEFAULT=ABI_O64"
	use_fixproto=yes
	;;
mips-*-elf* | mipsel-*-elf*)
	tm_file="${tm_file} mips/elf.h"
	tmake_file=mips/t-elf
	use_fixproto=yes
	;;
mips64-*-elf* | mips64el-*-elf*)
	tm_file="${tm_file} mips/elf64.h"
	tmake_file=mips/t-elf
	target_cpu_default="MASK_64BIT|MASK_FLOAT64|MASK_GAS"
	tm_defines="MIPS_ISA_DEFAULT=3 MIPS_ABI_DEFAULT=ABI_O64"
	use_fixproto=yes
	;;
mips64vr-*-elf* | mips64vrel-*-elf*)
        tm_file="mips/vr.h ${tm_file} mips/elf64.h"
        tm_defines="MIPS_ABI_DEFAULT=ABI_O64 MIPS_MARCH_CONTROLS_SOFT_FLOAT=1"
        tmake_file=mips/t-vr
	use_fixproto=yes
        ;;
mips64orion-*-elf* | mips64orionel-*-elf*)
	tm_file="${tm_file} mips/elforion.h mips/elf64.h"
	tmake_file=mips/t-elf
	tmake_file=mips/t-elf
	target_cpu_default="MASK_64BIT|MASK_FLOAT64|MASK_GAS"
	tm_defines="MIPS_ISA_DEFAULT=3 MIPS_ABI_DEFAULT=ABI_O64"
	use_fixproto=yes
	;;
mips*-*-rtems*)
	tm_file="${tm_file} mips/elf.h mips/rtems.h rtems.h"
	tmake_file="mips/t-elf t-rtems mips/t-rtems"
	;;
mips-wrs-vxworks)
	# We want vxworks.h after mips/elf.h, which unfortunately means we
	# have to redo the tm_file list from scratch.
	tm_file="elfos.h mips/mips.h svr4.h mips/elf.h vxworks.h mips/vxworks.h"
	tmake_file="${tmake_file} mips/t-vxworks"
	target_cpu_default="MASK_GAS"
	;;
mips-wrs-windiss)	# Instruction-level simulator for VxWorks.
	xm_defines=POSIX
	tm_file="elfos.h mips/mips.h svr4.h mips/elf.h windiss.h mips/windiss.h"
	tmake_file="${tmake_file} mips/t-elf"
	target_cpu_default="MASK_GAS"
	thread_file=
	;;
mipstx39-*-elf* | mipstx39el-*-elf*)
	tm_file="${tm_file} mips/r3900.h mips/elf.h"
	tmake_file=mips/t-r3900
	use_fixproto=yes
	;;
mmix-knuth-mmixware)
	need_64bit_hwint=yes
	;;
mn10300-*-*)
	tm_file="dbxelf.h elfos.h svr4.h ${tm_file}"
	if test x$stabs = xyes
	then
		tm_file="${tm_file} dbx.h"
	fi
	use_collect2=no
	use_fixproto=yes
	;;
ns32k-*-netbsdelf*)
	echo "GCC does not yet support the ${target} target"; exit 1
	;;
ns32k-*-netbsd*)
	tm_file="${tm_file} netbsd.h netbsd-aout.h ns32k/netbsd.h"
	# On NetBSD, the headers are already okay, except for math.h.
	tmake_file="t-netbsd ns32k/t-ns32k"
	extra_parts=""
	use_collect2=yes
	;;
pdp11-*-bsd)
	tm_file="${tm_file} pdp11/2bsd.h"
	use_fixproto=yes
        ;;
pdp11-*-*)
	use_fixproto=yes
	;;
avr-*-*)
	use_fixproto=yes
	;;
# port not yet contributed
#powerpc-*-openbsd*)
#	tmake_file="${tmake_file} rs6000/t-fprules "
#	extra_headers=
#	;;
powerpc64-*-linux*)
	tm_file="rs6000/biarch64.h ${tm_file} dbxelf.h elfos.h svr4.h freebsd-spec.h rs6000/sysv4.h"
	case x$with_cpu in
	x|xpowerpc64|xdefault64) tm_file="${tm_file} rs6000/default64.h";;
	esac
	tm_file="${tm_file} rs6000/linux64.h"
	tmake_file="rs6000/t-fprules t-slibgcc-elf-ver t-linux rs6000/t-ppccomm rs6000/t-linux64"
	;;
powerpc64-*-gnu*)
	tm_file="${cpu_type}/${cpu_type}.h elfos.h svr4.h freebsd-spec.h gnu.h rs6000/sysv4.h rs6000/linux64.h rs6000/gnu.h"
	tmake_file="rs6000/t-fprules t-slibgcc-elf-ver t-gnu rs6000/t-linux64"
	;;
powerpc-*-beos*)
	tm_file="${tm_file} rs6000/aix.h rs6000/beos.h rs6000/xcoff.h"
	tmake_file="rs6000/t-fprules rs6000/t-beos"
	extra_headers=
	use_fixproto=yes
	;;
powerpc-*-darwin*)
	tm_file="${tm_file} rs6000/darwin.h"
	tmake_file="t-darwin t-slibgcc-darwin rs6000/t-darwin"
	extra_headers=altivec.h
	;;
powerpc*-*-freebsd*)
	tm_file="${tm_file} dbxelf.h elfos.h ${fbsd_tm_file} rs6000/sysv4.h rs6000/freebsd.h"
	tmake_file="rs6000/t-fprules rs6000/t-ppcos ${tmake_file} rs6000/t-ppccomm"
	;;
powerpc-*-netbsd*)
	tm_file="${tm_file} dbxelf.h elfos.h netbsd.h netbsd-elf.h freebsd-spec.h rs6000/sysv4.h rs6000/netbsd.h"
	tmake_file="${tmake_file} rs6000/t-netbsd"
	;;
powerpc-*-chorusos*)
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h freebsd-spec.h rs6000/sysv4.h chorus.h"
	tmake_file="rs6000/t-fprules rs6000/t-ppcos rs6000/t-ppccomm"
	case ${enable_threads} in
	  yes | posix)
	    thread_file='posix'
	    ;;
	esac
	use_fixproto=yes
	;;
powerpc-*-eabispe*)
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h freebsd-spec.h rs6000/sysv4.h rs6000/eabi.h rs6000/eabispe.h"
	tmake_file="rs6000/t-spe rs6000/t-ppccomm"
	;;
powerpc-*-eabisimaltivec*)
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h freebsd-spec.h rs6000/sysv4.h rs6000/eabi.h rs6000/eabisim.h rs6000/eabialtivec.h"
	tmake_file="rs6000/t-fprules rs6000/t-ppcendian rs6000/t-ppccomm"
	;;
powerpc-*-eabisim*)
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h freebsd-spec.h rs6000/sysv4.h rs6000/eabi.h rs6000/eabisim.h"
	tmake_file="rs6000/t-fprules rs6000/t-ppcgas rs6000/t-ppccomm"
	;;
powerpc-*-elf*)
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h freebsd-spec.h rs6000/sysv4.h"
	tmake_file="rs6000/t-fprules rs6000/t-ppcgas rs6000/t-ppccomm"
	use_fixproto=yes
	;;
powerpc-*-eabialtivec*)
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h freebsd-spec.h rs6000/sysv4.h rs6000/eabi.h rs6000/eabialtivec.h"
	tmake_file="rs6000/t-fprules rs6000/t-ppcendian rs6000/t-ppccomm"
	;;
powerpc-*-eabi*)
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h freebsd-spec.h rs6000/sysv4.h rs6000/eabi.h"
	tmake_file="rs6000/t-fprules rs6000/t-ppcgas rs6000/t-ppccomm"
	;;
powerpc-*-rtems*)
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h freebsd-spec.h rs6000/sysv4.h rs6000/eabi.h rs6000/rtems.h rtems.h"
	tmake_file="rs6000/t-fprules rs6000/t-rtems t-rtems rs6000/t-ppccomm"
	;;
powerpc-*-linux*altivec*)
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h freebsd-spec.h rs6000/sysv4.h rs6000/linux.h rs6000/linuxaltivec.h"
	tmake_file="rs6000/t-fprules rs6000/t-ppcos t-slibgcc-elf-ver t-linux rs6000/t-ppccomm"
	;;
powerpc-*-linux*spe*)
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h freebsd-spec.h rs6000/sysv4.h rs6000/linux.h rs6000/linuxspe.h"
	tmake_file="rs6000/t-fprules rs6000/t-ppcos t-slibgcc-elf-ver t-linux rs6000/t-ppccomm"
	;;
powerpc-*-linux*)
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h freebsd-spec.h rs6000/sysv4.h rs6000/linux.h"
	tmake_file="rs6000/t-fprules rs6000/t-ppcos t-slibgcc-elf-ver t-linux rs6000/t-ppccomm"
	;;
powerpc-*-gnu-gnualtivec*)
	tm_file="${cpu_type}/${cpu_type}.h elfos.h svr4.h freebsd-spec.h gnu.h rs6000/sysv4.h rs6000/linux.h rs6000/linuxaltivec.h rs6000/gnu.h"
	tmake_file="rs6000/t-fprules rs6000/t-ppcos t-slibgcc-elf-ver t-gnu rs6000/t-ppccomm"
	if test x$enable_threads = xyes; then
		thread_file='posix'
	fi
	;;
powerpc-*-gnu*)
	tm_file="${cpu_type}/${cpu_type}.h elfos.h svr4.h freebsd-spec.h gnu.h rs6000/sysv4.h rs6000/linux.h rs6000/gnu.h"
	tmake_file="rs6000/t-fprules rs6000/t-ppcos t-slibgcc-elf-ver t-gnu rs6000/t-ppccomm"
	if test x$enable_threads = xyes; then
		thread_file='posix'
	fi
	;;
powerpc-wrs-vxworks*)
	# We want vxworks.h after rs6000/sysv4.h, which unfortunately
	# means we have to redo the tm_file list from scratch.
	tm_file="rs6000/rs6000.h elfos.h svr4.h freebsd-spec.h rs6000/sysv4.h"
	tm_file="${tm_file} vxworks.h rs6000/vxworks.h"
	tmake_file="${tmake_file} rs6000/t-fprules rs6000/t-ppccomm rs6000/t-vxworks"
	extra_headers=ppc-asm.h
	;;
powerpc-wrs-windiss*)	# Instruction-level simulator for VxWorks.
	tm_file="${tm_file} elfos.h svr4.h freebsd-spec.h rs6000/sysv4.h rs6000/windiss.h"
        tmake_file="rs6000/t-fprules rs6000/t-ppcgas rs6000/t-ppccomm"
        thread_file=""
	use_fixproto=yes
        ;;
powerpcle-*-sysv*)
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h freebsd-spec.h rs6000/sysv4.h rs6000/sysv4le.h"
	tmake_file="rs6000/t-fprules rs6000/t-ppcos rs6000/t-ppccomm"
	use_fixproto=yes
	;;
powerpcle-*-elf*)
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h freebsd-spec.h rs6000/sysv4.h rs6000/sysv4le.h"
	tmake_file="rs6000/t-fprules rs6000/t-ppcgas rs6000/t-ppccomm"
	use_fixproto=yes
	;;
powerpcle-*-eabisim*)
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h freebsd-spec.h rs6000/sysv4.h rs6000/sysv4le.h rs6000/eabi.h rs6000/eabisim.h"
	tmake_file="rs6000/t-fprules rs6000/t-ppcgas rs6000/t-ppccomm"
	;;
powerpcle-*-eabi*)
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h freebsd-spec.h rs6000/sysv4.h rs6000/sysv4le.h rs6000/eabi.h"
	tmake_file="rs6000/t-fprules rs6000/t-ppcgas rs6000/t-ppccomm"
	;;
powerpc-*-kaos*)
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h freebsd-spec.h rs6000/sysv4.h kaos.h rs6000/kaos-ppc.h"
	tmake_file="rs6000/t-fprules rs6000/t-ppcgas rs6000/t-ppccomm"
	;;
powerpcle-*-kaos*)
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h freebsd-spec.h rs6000/sysv4.h rs6000/sysv4le.h kaos.h rs6000/kaos-ppc.h"
	tmake_file="rs6000/t-fprules rs6000/t-ppcgas rs6000/t-ppccomm"
	;;
rs6000-ibm-aix4.[12]* | powerpc-ibm-aix4.[12]*)
	tm_file="${tm_file} rs6000/aix.h rs6000/aix41.h rs6000/xcoff.h"
	tmake_file="rs6000/t-fprules rs6000/t-newas"
	use_collect2=yes
	extra_headers=
	use_fixproto=yes
	;;
rs6000-ibm-aix4.[3456789]* | powerpc-ibm-aix4.[3456789]*)
	tm_file="rs6000/biarch64.h ${tm_file} rs6000/aix.h rs6000/aix43.h rs6000/xcoff.h"
	tmake_file=rs6000/t-aix43
	use_collect2=yes
	thread_file='aix'
	extra_headers=
	;;
rs6000-ibm-aix5.1.* | powerpc-ibm-aix5.1.*)
	tm_file="rs6000/biarch64.h ${tm_file} rs6000/aix.h rs6000/aix51.h rs6000/xcoff.h"
	tmake_file=rs6000/t-aix43
	use_collect2=yes
	thread_file='aix'
	extra_headers=
	;;
rs6000-ibm-aix[56789].* | powerpc-ibm-aix[56789].*)
	tm_file="${tm_file} rs6000/aix.h rs6000/aix52.h rs6000/xcoff.h"
	tmake_file=rs6000/t-aix52
	use_collect2=yes
	thread_file='aix'
	extra_headers=
	;;
rs6000-*-lynxos*)
	tm_file="svr3.h lynx.h rs6000/lynxbase.h rs6000/rs6000.h rs6000/lynx.h"
	tmake_file=rs6000/t-fprules
	use_collect2=yes
	use_fixproto=yes
	;;
s390-*-linux*)
	tm_file="s390/s390.h dbxelf.h elfos.h svr4.h linux.h s390/linux.h"
	tmake_file="t-slibgcc-elf-ver t-linux s390/t-crtstuff"
	;;
s390x-*-linux*)
	tm_file="s390/s390x.h s390/s390.h dbxelf.h elfos.h svr4.h linux.h s390/linux.h"
	tm_p_file=s390/s390-protos.h
	md_file=s390/s390.md
	extra_modes=s390/s390-modes.def
	out_file=s390/s390.c
	tmake_file="t-slibgcc-elf-ver t-linux s390/t-crtstuff s390/t-linux64"
	;;
s390x-ibm-tpf*)
	tm_file="s390/s390x.h s390/s390.h dbxelf.h elfos.h svr4.h s390/tpf.h"
	tm_p_file=s390/s390-protos.h
	md_file=s390/s390.md
	extra_modes=s390/s390-modes.def
	extra_parts="crtbegin.o crtbeginS.o crtbeginT.o crtend.o crtendS.o"
	out_file=s390/s390.c
	tmake_file="t-slibgcc-elf-ver s390/t-crtstuff s390/t-tpf"
	;;
sh-*-elf* | sh[2346l]*-*-elf* | sh*-*-kaos*)
	tmake_file="sh/t-sh sh/t-elf"
	case ${target} in
	shl* | sh64l*)
		tm_file="sh/little.h ${tm_file}"
		tmake_file="${tmake_file} sh/t-le"
		;;
	esac
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h sh/elf.h sh/embed-elf.h"
	case ${target} in
	sh64*)
		tmake_file="${tmake_file} sh/t-sh64"
		tm_file="${tm_file} sh/sh64.h"
		extra_headers="shmedia.h ushmedia.h sshmedia.h"
		;;
	sh4_single*)  target_cpu_default="SELECT_SH4_SINGLE" ;;
	sh4*)  target_cpu_default="SELECT_SH4" ;;
	sh3e*) target_cpu_default="SELECT_SH3E" ;;
	sh3*)  target_cpu_default="SELECT_SH3" ;;
	sh2e*) target_cpu_default="SELECT_SH2E" ;;
	sh2*)  target_cpu_default="SELECT_SH2" ;;
	esac
	case ${target} in
	sh[234]*) tmake_file="${tmake_file} sh/t-monolib" ;;
	esac
	case ${target} in
	sh*-*-kaos*) tm_file="${tm_file} kaos.h sh/kaos-sh.h" ;;
	esac
	use_fixproto=yes
	;;
sh-*-rtemscoff*)
	tmake_file="sh/t-sh t-rtems"
	tm_file="${tm_file} dbxcoff.h sh/coff.h sh/rtems.h rtems.h"
	;;
sh-*-rtems*)
	tmake_file="sh/t-sh sh/t-elf t-rtems"
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h sh/elf.h sh/embed-elf.h sh/rtemself.h rtems.h"
	;;
sh-*-linux* | sh[2346lbe]*-*-linux*)
	tmake_file="sh/t-sh sh/t-elf t-slibgcc-elf-ver t-linux"
	case ${target} in
	sh*be-*-* | sh*eb-*-*) ;;
	*)
		tm_file="sh/little.h ${tm_file}"
		tmake_file="${tmake_file} sh/t-le"
		;;
	esac
	tmake_file="${tmake_file} sh/t-linux"
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h sh/elf.h sh/linux.h"
	case ${target} in
	sh64*)
		tmake_file="${tmake_file} sh/t-sh64"
		tm_file="${tm_file} sh/sh64.h"
		extra_headers="shmedia.h ushmedia.h sshmedia.h"
		;;
	sh4_single*) target_cpu_default="SELECT_SH4_SINGLE" ;;
	sh4*) target_cpu_default="SELECT_SH4" ;;
	sh3e[lb]e*) target_cpu_default="SELECT_SH3E" ;;
	sh3e[lb]*) target_cpu_default="SELECT_SH3" ;;
	sh3e*) target_cpu_default="SELECT_SH3E" ;;
	sh3*) target_cpu_default="SELECT_SH3" ;;
	sh2e[lb]e*) target_cpu_default="SELECT_SH2E" ;;
	sh2e[lb]*) target_cpu_default="SELECT_SH2" ;;
	sh2e*) target_cpu_default="SELECT_SH2E" ;;
	sh2*) target_cpu_default="SELECT_SH2" ;;
	esac
	case ${target} in
	sh[234]*) tmake_file="${tmake_file} sh/t-monolib" ;;
	esac
	;;
sh-*-netbsdelf* | shl*-*-netbsdelf* | sh5-*-netbsd* | sh5l*-*-netbsd* | \
  sh64-*-netbsd* | sh64l*-*-netbsd*)
	tm_file="${tm_file} dbxelf.h elfos.h sh/elf.h netbsd.h netbsd-elf.h sh/netbsd-elf.h"
	tmake_file="${tmake_file} sh/t-sh sh/t-elf"
	case ${target} in
	sh*l*-*)
		tm_file="sh/little.h ${tm_file}"
		tmake_file="${tmake_file} sh/t-le"
		;;
	*)
		tmake_file="${tmake_file} sh/t-be"
		;;
	esac
	case ${target} in
	sh5*-*)
		# SHmedia, 32-bit ABI
		target_cpu_default="SH5_BIT|SH4_BIT|SH3_BIT|SH_E_BIT"
		tmake_file="${tmake_file} sh/t-sh64 sh/t-netbsd-sh5"
		;;
	sh64*-*)
		# SHmedia, 64-bit ABI
		target_cpu_default="SH5_BIT|SH4_BIT"
		tmake_file="${tmake_file} sh/t-sh64 sh/t-netbsd-sh5 sh/t-netbsd-sh5-64"
		;;
	*)
		# SH3, software floating point
		target_cpu_default="SH1_BIT|SH2_BIT|SH3_BIT"
		tmake_file="${tmake_file} sh/t-netbsd"
		;;
	esac
	;;
sh-wrs-vxworks)
	tmake_file="$tmake_file sh/t-sh sh/t-elf sh/t-vxworks"
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h sh/embed-elf.h sh/vxworks.h"
	;;
sh-*-*)
	tm_file="${tm_file} dbxcoff.h sh/coff.h"
	use_fixproto=yes
	;;
sparc-tti-*)
	tm_file="${tm_file} sparc/pbd.h"
	use_fixproto=yes
	;;
sparc-*-netbsdelf*)
	tm_file="${tm_file} elfos.h svr4.h sparc/sysv4.h netbsd.h netbsd-elf.h sparc/netbsd-elf.h"
	;;
sparc-*-openbsd*)
	tm_defines=OBSD_OLD_GAS
	tm_file="sparc/sparc.h openbsd.h sparc/openbsd.h"
	# needed to unconfuse gdb
	tmake_file="t-libc-ok t-openbsd sparc/t-openbsd"
	# we need collect2 until our bug is fixed...
	use_collect2=yes
	;;
sparc64-*-openbsd*)
	tm_file="sparc/openbsd1-64.h sparc/sparc.h elfos.h svr4.h sparc/sysv4.h sparc/sp64-elf.h openbsd.h sparc/openbsd64.h"
	gas=yes gnu_ld=yes
	with_cpu=ultrasparc
	;;
sparc-*-elf*)
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h sparc/sysv4.h sol2.h sparc/sol2.h sparc/elf.h"
	tmake_file="sparc/t-elf sparc/t-crtfm"
	extra_parts="crti.o crtn.o crtbegin.o crtend.o"
	use_fixproto=yes
	;;
sparc-*-linux*)		# SPARC's running GNU/Linux, libc6
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h sparc/sysv4.h sparc/linux.h"
	tmake_file="t-slibgcc-elf-ver t-linux sparc/t-crtfm"
	;;
sparc-*-rtems*)
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h sparc/sysv4.h sol2.h sparc/sol2.h sparc/elf.h sparc/rtemself.h rtems.h"
	tmake_file="sparc/t-elf sparc/t-crtfm t-rtems"
	extra_parts="crti.o crtn.o crtbegin.o crtend.o"
	;;
sparc64-*-solaris2* | sparcv9-*-solaris2*)
	tm_file="sparc/biarch64.h ${tm_file} dbxelf.h elfos.h svr4.h sparc/sysv4.h sol2.h sparc/sol2.h sparc/sol2-64.h sparc/sol2-bi.h"
	if test x$gnu_ld = xyes; then
		tm_file="${tm_file} sparc/sol2-gld.h sparc/sol2-gld-bi.h"
	fi
	if test x$gas = xyes; then
		tm_file="${tm_file} sparc/sol2-gas-bi.h"
	fi
	tmake_file="sparc/t-sol2 sparc/t-sol2-64 sparc/t-crtfm"
	if test x$gnu_ld = xyes; then
		tmake_file="$tmake_file t-slibgcc-elf-ver"
	else
		tmake_file="$tmake_file t-slibgcc-sld"
	fi
	extra_parts="crt1.o crti.o crtn.o gcrt1.o crtbegin.o crtend.o"
	if test x${enable_threads} = x ; then
	    enable_threads=$have_pthread_h
	    if test x${enable_threads} = x ; then
		enable_threads=$have_thread_h
	    fi
	fi
	if test x${enable_threads} = xyes ; then
	    if test x${have_pthread_h} = xyes ; then
		thread_file='posix'
	    else
		thread_file='solaris'
	    fi
	fi
	need_64bit_hwint=yes
	;;
sparc-*-solaris2*)
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h sparc/sysv4.h sol2.h sparc/sol2.h"
	if test x$gnu_ld = xyes; then
		tm_file="${tm_file} sparc/sol2-gld.h"
	fi
	tmake_file="sparc/t-sol2 sparc/t-crtfm"
	if test x$gnu_ld = xyes; then
		tmake_file="$tmake_file t-slibgcc-elf-ver"
	else
		tmake_file="$tmake_file t-slibgcc-sld"
	fi
	case ${target} in
	*-*-solaris2.[0-6] | *-*-solaris2.[0-6].*)
		if test x$gnu_ld = xno; then
			tm_file="${tm_file} sparc/sol26-sld.h"
		fi
		;;
	*-*-solaris2.[789] | *-*-solaris2.1[0-9])
		tm_file="sparc/biarch64.h ${tm_file} sparc/sol2-bi.h"
		if test x$gnu_ld = xyes; then
			tm_file="${tm_file} sparc/sol2-gld-bi.h"
		fi
		if test x$gas = xyes; then
			tm_file="${tm_file} sparc/sol2-gas-bi.h"
		fi
		tmake_file="$tmake_file sparc/t-sol2-64"
		need_64bit_hwint=yes
		;;
	esac
	extra_parts="crt1.o crti.o crtn.o gcrt1.o gmon.o crtbegin.o crtend.o"
	if test x${enable_threads} = x; then
	    enable_threads=$have_pthread_h
	    if test x${enable_threads} = x; then
		enable_threads=$have_thread_h
	    fi
	fi
	if test x${enable_threads} = xyes; then
	    if test x${have_pthread_h} = xyes; then
		thread_file='posix'
	    else
		thread_file='solaris'
	    fi
	fi
	;;
sparc-*-sysv4*)
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h sparc/sysv4.h sparc/sysv4-only.h"
	tmake_file=t-svr4
	extra_parts="crtbegin.o crtend.o"
	use_fixproto=yes
	;;
sparclite-*-coff*)
	tm_file="${tm_file} sparc/lite.h svr3.h sparc/litecoff.h dbxcoff.h libgloss.h"
	tmake_file=sparc/t-sparclite
	;;
sparclite-*-elf*)
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h sparc/sysv4.h sol2.h sparc/sol2.h sparc/elf.h sparc/liteelf.h"
	tmake_file="sparc/t-sparclite sparc/t-crtfm"
        extra_parts="crtbegin.o crtend.o"
	use_fixproto=yes
	;;
sparc86x-*-elf*)
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h sparc/sysv4.h sol2.h sparc/sol2.h sparc/elf.h sparc/sp86x-elf.h"
	tmake_file="sparc/t-sp86x sparc/t-crtfm"
        extra_parts="crtbegin.o crtend.o"
	use_fixproto=yes
	;;
sparc64-*-aout*)
	tm_file="sparc/sparc.h sparc/aout.h sparc/sp64-aout.h"
	use_fixproto=yes
	;;
sparc64-*-elf*)
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h sparc/sysv4.h sol2.h sparc/sol2.h sparc/sp64-elf.h"
	tmake_file="${tmake_file} sparc/t-crtfm"
	extra_parts="crtbegin.o crtend.o"
	use_fixproto=yes
	;;
sparc64-*-freebsd*|ultrasparc-*-freebsd*)
	tm_file="${tm_file} ${fbsd_tm_file} dbxelf.h elfos.h sparc/sysv4.h sparc/freebsd.h"
	tmake_file="${tmake_file} sparc/t-crtfm"
	case "x$with_cpu" in
		xultrasparc) ;;
		x) with_cpu=ultrasparc ;;
		*) echo "$with_cpu not supported for freebsd target"; exit 1 ;;
	esac
	need_64bit_hwint=yes
	;;
sparc64-*-linux*)		# 64-bit SPARC's running GNU/Linux
	tmake_file="t-slibgcc-elf-ver t-linux sparc/t-linux64 sparc/t-crtfm"
	tm_file="sparc/biarch64.h ${tm_file} dbxelf.h elfos.h svr4.h sparc/sysv4.h sparc/linux64.h"
	;;
sparc64-*-netbsd*)
	tmake_file="${tmake_file} sparc/t-netbsd64"
	tm_file="sparc/biarch64.h ${tm_file}"
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h sparc/sysv4.h netbsd.h netbsd-elf.h sparc/netbsd-elf.h"
	;;
strongarm-*-elf*)
	tm_file="arm/strongarm-elf.h dbxelf.h elfos.h arm/unknown-elf.h arm/elf.h arm/aout.h arm/arm.h"
	tmake_file=arm/t-strongarm-elf
	out_file=arm/arm.c
	md_file=arm/arm.md
	extra_modes=arm/arm-modes.def
	use_fixproto=yes
	;;
strongarm-*-pe)
	tm_file="arm/semi.h arm/aout.h arm/coff.h dbxcoff.h arm/strongarm-coff.h arm/arm.h arm/pe.h arm/strongarm-pe.h"
	tmake_file=arm/t-strongarm-pe
	out_file=arm/arm.c
	md_file=arm/arm.md
	extra_modes=arm/arm-modes.def
	extra_objs=pe.o
	use_fixproto=yes
	;;
strongarm-*-kaos*)
	tm_file="arm/strongarm-elf.h dbxelf.h elfos.h arm/unknown-elf.h arm/elf.h arm/aout.h arm/arm.h kaos.h arm/kaos-strongarm.h"
	tmake_file=arm/t-strongarm-elf
	out_file=arm/arm.c
	md_file=arm/arm.md
	extra_modes=arm/arm-modes.def
	;;
v850e1-*-*)
	target_cpu_default="TARGET_CPU_v850e1"
	tm_file="dbxelf.h elfos.h svr4.h v850/v850.h"
	tm_p_file=v850/v850-protos.h
	tmake_file=v850/t-v850e
	md_file=v850/v850.md
	out_file=v850/v850.c
	if test x$stabs = xyes
	then
		tm_file="${tm_file} dbx.h"
	fi
	use_collect2=no
	c_target_objs="v850-c.o"
	cxx_target_objs="v850-c.o"
	use_fixproto=yes
	;;
v850e-*-*)
	target_cpu_default="TARGET_CPU_v850e"
	tm_file="dbxelf.h elfos.h svr4.h v850/v850.h"
	tm_p_file=v850/v850-protos.h
	tmake_file=v850/t-v850e
	md_file=v850/v850.md
	out_file=v850/v850.c
	if test x$stabs = xyes
	then
		tm_file="${tm_file} dbx.h"
	fi
	use_collect2=no
	c_target_objs="v850-c.o"
	cxx_target_objs="v850-c.o"
	use_fixproto=yes
	;;
v850-*-*)
	target_cpu_default="TARGET_CPU_generic"
	tm_file="dbxelf.h elfos.h svr4.h ${tm_file}"
	tmake_file=v850/t-v850
	if test x$stabs = xyes
	then
		tm_file="${tm_file} dbx.h"
	fi
	use_collect2=no
	c_target_objs="v850-c.o"
	cxx_target_objs="v850-c.o"
	use_fixproto=yes
	;;
vax-*-bsd*)			# VAXen running BSD
	tm_file="${tm_file} vax/bsd.h"
	use_collect2=yes
	use_fixproto=yes
	;;
vax-*-sysv*)			# VAXen running system V
	tm_file="${tm_file} vax/vaxv.h"
	use_fixproto=yes
	;;
vax-*-netbsdelf*)
	tm_file="${tm_file} elfos.h netbsd.h netbsd-elf.h vax/elf.h vax/netbsd-elf.h"
	;;
vax-*-netbsd*)
	tm_file="${tm_file} netbsd.h netbsd-aout.h vax/netbsd.h"
	tmake_file=t-netbsd
	extra_parts=""
	use_collect2=yes
	;;
vax-*-openbsd*)
	tm_file="vax/vax.h vax/openbsd1.h openbsd.h vax/openbsd.h"
	use_collect2=yes
	;;
vax-*-ultrix*)			# VAXen running ultrix
	tm_file="${tm_file} vax/ultrix.h"
	use_fixproto=yes
	;;
vax-*-*)			# VAX default entry
    if test "x$enable_obsolete" != xyes; then
      echo "*** Configuration ${target} is obsolete." >&2
      echo "*** Specify --enable-obsolete to build it anyway." >&2
      echo "*** Support will be REMOVED in the next major release of GCC," >&2
      echo "*** unless a maintainer comes forward." >&2
      exit 1
    fi
	use_fixproto=yes
	;;
xscale-*-elf)
	tm_file="arm/xscale-elf.h dbxelf.h elfos.h arm/unknown-elf.h arm/elf.h arm/aout.h arm/arm.h"
	tmake_file=arm/t-xscale-elf
	out_file=arm/arm.c
	md_file=arm/arm.md
	extra_modes=arm/arm-modes.def
	use_fixproto=yes
	;;
xscale-*-coff)
	tm_file="arm/semi.h arm/aout.h arm/coff.h dbxcoff.h arm/xscale-coff.h arm/arm.h"
	tmake_file=arm/t-xscale-coff
	out_file=arm/arm.c
	md_file=arm/arm.md
	extra_modes=arm/arm-modes.def
	use_fixproto=yes
	;;
xstormy16-*-elf)
	# For historical reasons, the target files omit the 'x'.
	tm_file="dbxelf.h elfos.h svr4.h stormy16/stormy16.h"
	tm_p_file=stormy16/stormy16-protos.h
	md_file=stormy16/stormy16.md
	out_file=stormy16/stormy16.c
	tmake_file="stormy16/t-stormy16"
	extra_parts="crtbegin.o crtend.o"
	use_fixproto=yes
	;;
xtensa-*-elf*)
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h xtensa/elf.h"
	tmake_file="xtensa/t-xtensa xtensa/t-elf"
	;;
xtensa-*-linux*)
	tm_file="${tm_file} dbxelf.h elfos.h svr4.h linux.h xtensa/linux.h"
	tmake_file="t-slibgcc-elf-ver t-linux xtensa/t-xtensa xtensa/t-linux"
	;;
am33_2.0-*-linux*)
	tm_file="mn10300/mn10300.h dbxelf.h elfos.h linux.h mn10300/linux.h"
	tmake_file="t-slibgcc-elf-ver t-linux mn10300/t-linux"
	gas=yes gnu_ld=yes
	extra_parts="crtbegin.o crtend.o crtbeginS.o crtendS.o"
	use_collect2=no
	;;
*)
	echo "*** Configuration ${target} not supported" 1>&2
	exit 1
	;;
esac

# Support for --with-cpu and related options (and a few unrelated options,
# too).
case ${with_cpu} in
  yes | no)
    echo "--with-cpu must be passed a value" 1>&2
    exit 1
    ;;
esac

# If there is no $with_cpu option, try to infer one from ${target}.
# This block sets nothing except for with_cpu.
if test x$with_cpu = x ; then
  case ${target} in
    ep9312-*-*)
      # A Cirrus ARM variant.
      with_cpu="ep9312"
      ;;
    i486-*-*)
      with_cpu=i486
      ;;
    i586-*-*)
      case ${target_noncanonical} in
        k6_2-*)
          with_cpu=k6-2
          ;;
        k6_3-*)
          with_cpu=k6-3
          ;;
        k6-*)
          with_cpu=k6
          ;;
        pentium_mmx-*|winchip_c6-*|winchip2-*|c3-*)
          with_cpu=pentium-mmx
          ;;
        *)
          with_cpu=pentium
          ;;
      esac
      ;;
    i686-*-* | i786-*-*)
      case ${target_noncanonical} in
        k8-*|opteron-*|athlon_64-*)
          with_cpu=k8
          ;;
        athlon_xp-*|athlon_mp-*|athlon_4-*)
          with_cpu=athlon-4
          ;;
        athlon_tbird-*|athlon-*)
          with_cpu=athlon
          ;;
        pentium2-*)
          with_cpu=pentium2
          ;;
        pentium3-*|pentium3m-*)
          with_cpu=pentium3
          ;;
        pentium4-*|pentium4m-*)
          with_cpu=pentium4
          ;;
        prescott-*)
          with_cpu=prescott
          ;;
        nocona-*)
          with_cpu=nocona
          ;;
        pentium_m-*)
          with_cpu=pentium-m
          ;;
        *)
          with_cpu=pentiumpro
          ;;
      esac
      ;;
    x86_64-*-*)
      with_cpu=k8
      ;;
    alphaev6[78]*-*-*)
      with_cpu=ev67
      ;;
    alphaev6*-*-*)
      with_cpu=ev6
      ;;
    alphapca56*-*-*)
      with_cpu=pca56
      ;;
    alphaev56*-*-*)
      with_cpu=ev56
      ;;
    alphaev5*-*-*)
      with_cpu=ev5
      ;;
    sparc*-*-*)
      with_cpu="`echo ${target} | sed 's/-.*$//'`"
      if [ x$with_cpu = xsparc64 ]; then
        with_cpu=v9
      fi
      ;;
  esac
fi

	# Similarly for --with-schedule.
	if test x$with_schedule = x; then
		case ${target} in
		hppa1* | parisc1*)
			# Override default PA8000 scheduling model.
			with_schedule=7100LC
			;;
		esac
	fi

	# Validate and mark as valid any --with options supported
	# by this target.  In order to use a particular --with option
	# you must list it in supported_defaults; validating the value
	# is optional.  This case statement should set nothing besides
	# supported_defaults.

	supported_defaults=
	case "${target}" in
	alpha*-*-*)
		supported_defaults="cpu tune"
		for which in cpu tune; do
			eval "val=\$with_$which"
			case "$val" in
			"" \
			| ev4 | ev45 | 21064 | ev5 | 21164 | ev56 | 21164a \
			| pca56 | 21164PC | 21164pc | ev6 | 21264 | ev67 \
			| 21264a)
				;;
			*)
				echo "Unknown CPU used in --with-$which=$val" 1>&2
				exit 1
				;;
			esac
		done
		;;

	arm*-*-*)
		supported_defaults="arch cpu float tune"
		for which in cpu tune; do
			eval "val=\$with_$which"
			case "$val" in
			"" \
			| arm[236789] | arm250 | arm[67][01]0 \
			| arm60 | arm620 | arm7d | arm7di \
			| arm7m | arm7dm | arm7dmi | arm[79]tdmi \
			| arm70 | arm700i | arm710t | arm720 \
			| arm720t | arm740t | arm710c | arm920 \
			| arm920t | arm926ejs | arm940t | arm9e | arm10tdmi \
			| arm7100 | arm7500 | arm7500fe | arm810 \
			| arm1026ejs | arm1020t | arm1136js | arm1136jfs \
			| xscale | iwmmxt \
			| ep9312 \
			| strongarm | strongarm110 | strongarm11[01]0)
				# OK
				;;
			*)
				echo "Unknown CPU used in --with-$which=$val" 1>&2
				exit 1
				;;
			esac
		done

		case "$with_arch" in
		"" \
		| armv[2345] | armv2a | armv3m | armv4t | armv5t \
		| armv5te | armv6j | ep9312)
			# OK
			;;
		*)
			echo "Unknown arch used in --with-arch=$with_arch" 1>&2
			exit 1
			;;
		esac

		case "$with_float" in
		"" \
		| soft | hard)
			# OK
			;;
		*)
			echo "Unknown floating point type used in --with-float=$with_float" 1>&2
			exit 1
			;;
		esac

		if test "x$with_arch" != x && test "x$with_cpu" != x; then
			echo "Warning: --with-arch overrides --with-cpu" 1>&2
		fi
		;;

	hppa*-*-* | parisc*-*-*)
		supported_defaults="arch schedule"

		case "$with_arch" in
		"" | 1.0 | 1.1 | 2.0)
			# OK
			;;
		*)
			echo "Unknown architecture used in --with-arch=$with_arch" 1>&2
			exit 1
			;;
		esac

		case "$with_schedule" in
		"" | 700 | 7100 | 7100LC | 7200 | 7300 | 8000)
			# OK
			;;
		*)
			echo "Unknown processor used in --with-schedule=$with_schedule." 1>&2
			exit 1
			;;
		esac
		;;

	i[34567]86-*-* | x86_64-*-*)
		supported_defaults="arch cpu tune"
		for which in arch cpu tune; do
			eval "val=\$with_$which"
			case ${val} in
			"" | i386 | i486 \
			| i586 | pentium | pentium-mmx | winchip-c6 | winchip2 \
			| c3 | c3-2 | i686 | pentiumpro | pentium2 | pentium3 \
			| pentium4 | k6 | k6-2 | k6-3 | athlon | athlon-tbird \
			| athlon-4 | athlon-xp | athlon-mp | k8 | opteron \
			| athlon64 | athlon-fx | prescott | pentium-m \
			| pentium4m | pentium3m| nocona)
				# OK
				;;
			*)
				echo "Unknown CPU given in --with-$which=$val." 1>&2
				exit 1
				;;
			esac
		done
		;;

	mips*-*-*)
		supported_defaults="abi arch float tune"

		case ${with_float} in
		"" | soft | hard)
			# OK
			;;
		*)
			echo "Unknown floating point type used in --with-float=$with_float" 1>&2
			exit 1
			;;
		esac

		case ${with_abi} in
		"" | 32 | o64 | n32 | 64 | eabi)
			# OK
			;;
		*)
			echo "Unknown ABI used in --with-abi=$with_abi" 1>&2
			exit 1
			;;
		esac
		;;

	powerpc*-*-* | rs6000-*-*)
		supported_defaults="cpu float tune"

		for which in cpu tune; do
			eval "val=\$with_$which"
			case ${val} in
			default32 | default64)
				with_which="with_$which"
				eval $with_which=
				;;
			"" | common \
			| power | power2 | power3 | power4 \
			| powerpc | powerpc64 \
			| rios | rios1 | rios2 | rsc | rsc1 | rs64a \
			| 401 | 403 | 405 | 405fp | 440 | 440fp | 505 \
			| 601 | 602 | 603 | 603e | ec603e | 604 \
			| 604e | 620 | 630 | 740 | 750 | 7400 | 7450 \
			| 8540 | 801 | 821 | 823 | 860 | 970 | G3 | G4 | G5)
				# OK
				;;
			*)
				echo "Unknown cpu used in --with-$which=$val." 1>&2
				exit 1
				;;
			esac
		done
		;;

	s390*-*-*)
		supported_defaults="arch mode tune"

		for which in arch tune; do
			eval "val=\$with_$which"
			case ${val} in
			"" | g5 | g6 | z900 | z990)
				# OK
				;;
			*)
				echo "Unknown cpu used in --with-$which=$val." 1>&2
				exit 1
				;;
			esac
		done

		case ${with_mode} in
		"" | esa | zarch)
			# OK
			;;
		*)
			echo "Unknown architecture mode used in --with-mode=$with_mode." 1>&2
			exit 1
			;;
		esac
		;;

	sparc*-*-*)
		supported_defaults="cpu float tune"

		for which in cpu tune; do
			eval "val=\$with_$which"
			case ${val} in
			"" | sparc | sparcv9 | sparc64 | sparc86x \
			| v7 | cypress | v8 | supersparc | sparclite | f930 \
			| f934 | hypersparc | sparclite86x | sparclet | tsc701 \
			| v9 | ultrasparc | ultrasparc3)
				# OK
				;;
			*)
				echo "Unknown cpu used in --with-$which=$val" 1>&2
				exit 1
				;;
			esac
		done

		case ${with_float} in
		"" | soft | hard)
			# OK
			;;
		*)
			echo "Unknown floating point type used in --with-float=$with_float" 1>&2
			exit 1
			;;
		esac
		;;

	v850*-*-*)
		supported_defaults=cpu
		case ${with_cpu} in
		"" | v850e | v850e1)
			# OK
			;;
		*)
			echo "Unknown cpu used in --with-cpu=$with_cpu" 1>&2
			exit 1
			;;
		esac
		;;
	esac

	# Set some miscellaneous flags for particular targets.
	target_cpu_default2=
	case ${target} in
	alpha*-*-*)
		if test x$gas = xyes
		then
			target_cpu_default2="MASK_GAS"
		fi
		;;

	arm*-*-*)
		case "x$with_cpu" in
		x)
			# The most generic
			target_cpu_default2="TARGET_CPU_generic"
			;;

		*)
			target_cpu_default2="TARGET_CPU_$with_cpu"
			;;
		esac
		;;

	hppa*-*-* | parisc*-*-*)
		if test x$gas = xyes
		then
			target_cpu_default2="MASK_GAS|MASK_JUMP_IN_DELAY"
		fi
		;;

	mips*-*-*)
		case ${target} in
		mips*-*-ecoff* | mips*-*-elf*)
			if test x$gas = xyes
			then
				if test x$gnu_ld = xyes
				then
					target_cpu_default2="MASK_GAS|MASK_SPLIT_ADDR"
				else
					target_cpu_default2="MASK_GAS"
				fi
			fi
			;;
		mips*-*-*)
			if test x$gas = xyes
			then
				target_cpu_default2="MASK_GAS"
			fi
			;;
		esac
		case ${target} in
			mips*el-*-*)
				tm_defines="TARGET_ENDIAN_DEFAULT=0 $tm_defines"
				;;
		esac
		case $tm_file in
			*mips/elf.h* | *mips/elf64.h*)
				tm_defines="OBJECT_FORMAT_ELF $tm_defines"
				;;
		esac
		if test "x$enable_gofast" = xyes
		then
			tm_defines="US_SOFTWARE_GOFAST $tm_defines"
			tmake_file="mips/t-gofast $tmake_file"
		else
			tmake_file="mips/t-mips $tmake_file"
		fi
		;;

	powerpc*-*-* | rs6000-*-*)
		if test x$enable_altivec = xyes
		then
			tm_file="$tm_file rs6000/altivec-defs.h"
		fi
		# FIXME: The PowerPC port uses the value set at compile time,
		# although it's only cosmetic.
		if test "x$with_cpu" != x
		then
			target_cpu_default2="\\\"$with_cpu\\\""
		fi
		out_file=rs6000/rs6000.c
		c_target_objs="${c_target_objs} rs6000-c.o"
		cxx_target_objs="${cxx_target_objs} rs6000-c.o"
		tmake_file="rs6000/t-rs6000 ${tmake_file}"
		;;

	sparc*-*-*)
		# Some standard aliases.
		case x$with_cpu in
		xsparc)
			with_cpu=v7
			;;
		xsparc86x)
			with_cpu=sparclite86x
			;;
		xsparcv9 | xsparc64)
			with_cpu=v9
			;;
		esac

		# The Sparc port checks this value at compile-time.
		target_cpu_default2="TARGET_CPU_$with_cpu"
		;;
	v850*-*-*)
		# FIXME: The v850 is "special" in that it does not support
		# runtime CPU selection, only --with-cpu.
		case "x$with_cpu" in
		x)
			;;
		xv850e)
			target_cpu_default2="TARGET_CPU_$with_cpu"
			;;
		esac
		;;
	esac

	t=
	all_defaults="abi cpu arch tune schedule float mode"
	for option in $all_defaults
	do
		eval "val=\$with_$option"
		if test -n "$val"; then
			case " $supported_defaults " in
			*" $option "*)
				;;
			*)
				echo "This target does not support --with-$option." 2>&1
				exit 1
				;;
			esac

			if test "x$t" = x
			then
				t="{ \"$option\", \"$val\" }"
			else
				t="${t}, { \"$option\", \"$val\" }"
			fi
		fi
	done
	if test "x$t" = x
	then
		configure_default_options="{ { NULL, NULL} }"
	else
		configure_default_options="{ ${t} }"
	fi

	if test "$target_cpu_default2" != ""
	then
		if test "$target_cpu_default" != ""
		then
			target_cpu_default="(${target_cpu_default}|${target_cpu_default2})"
		else
			target_cpu_default=$target_cpu_default2
		fi
	fi
