/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * Copyright (C) chaitanya chandel 2009 <cchandel@yahoo.com>
 * 
 * db_sqlite.h is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * db_sqlite.h is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
#include <sqlite3.h>
#include <stdio.h>
#include <Elementary.h>

#define LISTVIEW 0
#define ALBUM_ART 1
#define LYRICS 2

#define IDLE -1
#define PLAYING 1
#define PAUSE 0

void save_state(void);
void restore_state(void);
int add_playlist(char *playlist);
void add_songs(char *, char* , char*);
void update_album_list(Elm_Genlist_Item_Class *cl, Evas_Object *li);
void remove_album(char *album);
void add_default_playlist(void);
void populate_play_list(Evas_Object *list);
void populate_playlist_songs(Evas_Object *list);
void populate_main_list(Evas_Object *list);
void populate_create_play_list(Evas_Object *list);
int count_albums(void);
int get_song_pos(char *path);
void del_playlist(char *list);
void save_playlist(char *playlist, Evas_Object *li);
void begin_transaction(void);
void commit_transaction(void);
void add_songs_from_album(char *album, Evas_Object *list);
void first_run(void);
void set_no_songs(void);
void populate_filter_list(char *type, Evas_Object *list);
void populate_filter_final_list(char *type, char *name, Evas_Object *list);
char *clean_string(char *str);

extern void gl_sel(void *data, Evas_Object *obj, void *event_info);
extern void song_select(void *data, Evas_Object *obj, void *event_info);
extern void randomize_list (void);
extern void start_mplayer_bt(void);
extern void sel_playlist_button_clicked(void *data, Evas_Object *obj, void *event_info);

extern char cur_playlist[254], (*path_songs)[254], songs_dir[254], cur_song[254], cur_artist[254], order_by[254];
extern int song_index, vol, no_songs, bass, treble, next_song_random, priority, pid, version, bt;
extern Elm_Object_Item *song_list[10000], *old_song;
extern Ecore_Timer *timer1;
extern int pos_time, view, seek, pos_time, play_state, song_dur, finger, loop, randomize, *seq, sys_vol, pl_info;
extern Elm_Genlist_Item_Class itc_list, itc_album_list, itc_c_play_list, itc_dir_list, itc_play_list, itc_add_album_list, itc_filter_list;
extern Elm_Genlist_Item_Class itc_home_list, itc_filter_final;
extern Evas_Object *play_list, *list, *ic_playlist, *ic_albums, *add_page_win, *manage_playlist_page_win, *win, *play_button;
sqlite3 *songs;
char home_dir[255], intone_dir[255], tag_artist[255], tag_song[255], tag_album[255];
char (*del_pl)[255];

typedef struct {
	char path[255];
	int type;
} _dir;
extern _dir dir_gl_entry[254]; //directory entries genlist struct

extern _dir *pl_data; //playlist entries struct

typedef struct {
	char name[255];
	char path[255];
} _str2;
extern _str2 name_path[254];
