/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.out;

import java.io.IOException;
import ucar.netcdf.Dimension;
import visad.data.netcdf.out.VisADAccessor;

abstract class DataAccessor
implements VisADAccessor {
    protected final int localRank;
    protected final Dimension[] localDims;
    protected volatile int[] localIndexes;
    protected final VisADAccessor outerAccessor;
    protected final int outerRank;
    protected volatile int[] outerIndexes;

    protected DataAccessor(Dimension[] localDims, VisADAccessor outerAccessor) {
        this.localRank = localDims.length;
        this.outerRank = outerAccessor.getRank();
        this.localDims = localDims;
        this.localIndexes = new int[this.localRank];
        this.outerIndexes = new int[this.outerRank];
        this.outerAccessor = outerAccessor;
    }

    public int getRank() {
        return this.outerRank + this.localRank;
    }

    public Dimension[] getDimensions() {
        Dimension[] dims = new Dimension[this.getRank()];
        System.arraycopy(this.outerAccessor.getDimensions(), 0, dims, 0, this.outerRank);
        System.arraycopy(this.localDims, 0, dims, this.outerRank, this.localRank);
        return dims;
    }

    public int[] getLengths() {
        int[] lengths = new int[this.getRank()];
        Dimension[] outerDims = this.getDimensions();
        for (int i = 0; i < lengths.length; ++i) {
            lengths[i] = outerDims[i].getLength();
        }
        return lengths;
    }

    public Object get(int[] indexes) throws IOException {
        System.arraycopy(indexes, 0, this.outerIndexes, 0, this.outerRank);
        System.arraycopy(indexes, this.outerRank, this.localIndexes, 0, this.localRank);
        return this.get();
    }

    protected abstract Object get() throws IOException;
}

