/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanCreationNotAllowedException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.core.CollectionFactory;
import org.springframework.core.SimpleAliasRegistry;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultSingletonBeanRegistry
extends SimpleAliasRegistry
implements SingletonBeanRegistry {
    protected static final Object NULL_OBJECT = new Object();
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Map singletonObjects = CollectionFactory.createConcurrentMapIfPossible(16);
    private final Map singletonFactories = new HashMap();
    private final Map earlySingletonObjects = new HashMap();
    private final Set registeredSingletons = new LinkedHashSet(16);
    private final Set singletonsCurrentlyInCreation = Collections.synchronizedSet(new HashSet());
    private List suppressedExceptions;
    private boolean singletonsCurrentlyInDestruction = false;
    private final Map disposableBeans = new LinkedHashMap(16);
    private final Map dependentBeanMap = CollectionFactory.createConcurrentMapIfPossible(16);
    private final Map dependenciesForBeanMap = CollectionFactory.createConcurrentMapIfPossible(16);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSingleton(String beanName, Object singletonObject) throws IllegalStateException {
        Assert.notNull(beanName, "'beanName' must not be null");
        Map map = this.singletonObjects;
        synchronized (map) {
            Object oldObject = this.singletonObjects.get(beanName);
            if (oldObject != null) {
                throw new IllegalStateException("Could not register object [" + singletonObject + "] under bean name '" + beanName + "': there is already object [" + oldObject + "] bound");
            }
            this.addSingleton(beanName, singletonObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSingleton(String beanName, Object singletonObject) {
        Map map = this.singletonObjects;
        synchronized (map) {
            this.singletonObjects.put(beanName, singletonObject != null ? singletonObject : NULL_OBJECT);
            this.singletonFactories.remove(beanName);
            this.earlySingletonObjects.remove(beanName);
            this.registeredSingletons.add(beanName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSingletonFactory(String beanName, ObjectFactory singletonFactory) {
        Assert.notNull(singletonFactory, "Singleton factory must not be null");
        Map map = this.singletonObjects;
        synchronized (map) {
            if (!this.singletonObjects.containsKey(beanName)) {
                this.singletonFactories.put(beanName, singletonFactory);
                this.earlySingletonObjects.remove(beanName);
                this.registeredSingletons.add(beanName);
            }
        }
    }

    public Object getSingleton(String beanName) {
        return this.getSingleton(beanName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getSingleton(String beanName, boolean allowEarlyReference) {
        Object singletonObject = this.singletonObjects.get(beanName);
        if (singletonObject == null) {
            Map map = this.singletonObjects;
            synchronized (map) {
                ObjectFactory singletonFactory;
                singletonObject = this.earlySingletonObjects.get(beanName);
                if (singletonObject == null && allowEarlyReference && (singletonFactory = (ObjectFactory)this.singletonFactories.remove(beanName)) != null) {
                    singletonObject = singletonFactory.getObject();
                    this.earlySingletonObjects.put(beanName, singletonObject);
                }
            }
        }
        return singletonObject != NULL_OBJECT ? singletonObject : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSingleton(String beanName, ObjectFactory singletonFactory) {
        Assert.notNull(beanName, "'beanName' must not be null");
        Map map = this.singletonObjects;
        synchronized (map) {
            Object singletonObject = this.singletonObjects.get(beanName);
            if (singletonObject == null) {
                boolean recordSuppressedExceptions;
                if (this.singletonsCurrentlyInDestruction) {
                    throw new BeanCreationNotAllowedException(beanName, "Singleton bean creation not allowed while the singletons of this factory are in destruction (Do not request a bean from a BeanFactory in a destroy method implementation!)");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Creating shared instance of singleton bean '" + beanName + "'");
                }
                this.beforeSingletonCreation(beanName);
                boolean bl = recordSuppressedExceptions = this.suppressedExceptions == null;
                if (recordSuppressedExceptions) {
                    this.suppressedExceptions = new LinkedList();
                }
                try {
                    try {
                        singletonObject = singletonFactory.getObject();
                    }
                    catch (BeanCreationException ex) {
                        Iterator it = this.suppressedExceptions.iterator();
                        while (it.hasNext()) {
                            ex.addRelatedCause((Exception)it.next());
                        }
                        throw ex;
                    }
                    Object var9_6 = null;
                    if (recordSuppressedExceptions) {
                        this.suppressedExceptions = null;
                    }
                    this.afterSingletonCreation(beanName);
                }
                catch (Throwable throwable) {
                    Object var9_7 = null;
                    if (recordSuppressedExceptions) {
                        this.suppressedExceptions = null;
                    }
                    this.afterSingletonCreation(beanName);
                    throw throwable;
                }
                this.addSingleton(beanName, singletonObject);
            }
            return singletonObject != NULL_OBJECT ? singletonObject : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onSuppressedException(Exception ex) {
        Map map = this.singletonObjects;
        synchronized (map) {
            if (this.suppressedExceptions != null) {
                this.suppressedExceptions.add(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSingleton(String beanName) {
        Map map = this.singletonObjects;
        synchronized (map) {
            this.singletonObjects.remove(beanName);
            this.singletonFactories.remove(beanName);
            this.earlySingletonObjects.remove(beanName);
            this.registeredSingletons.remove(beanName);
        }
    }

    public boolean containsSingleton(String beanName) {
        return this.singletonObjects.containsKey(beanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSingletonNames() {
        Map map = this.singletonObjects;
        synchronized (map) {
            return StringUtils.toStringArray(this.registeredSingletons);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSingletonCount() {
        Map map = this.singletonObjects;
        synchronized (map) {
            return this.registeredSingletons.size();
        }
    }

    protected void beforeSingletonCreation(String beanName) {
        if (!this.singletonsCurrentlyInCreation.add(beanName)) {
            throw new BeanCurrentlyInCreationException(beanName);
        }
    }

    protected void afterSingletonCreation(String beanName) {
        if (!this.singletonsCurrentlyInCreation.remove(beanName)) {
            throw new IllegalStateException("Singleton '" + beanName + "' isn't currently in creation");
        }
    }

    public final boolean isSingletonCurrentlyInCreation(String beanName) {
        return this.singletonsCurrentlyInCreation.contains(beanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDisposableBean(String beanName, DisposableBean bean) {
        Map map = this.disposableBeans;
        synchronized (map) {
            this.disposableBeans.put(beanName, bean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDependentBean(String beanName, String dependentBeanName) {
        Map map = this.dependentBeanMap;
        synchronized (map) {
            LinkedHashSet<String> dependentBeans = (LinkedHashSet<String>)this.dependentBeanMap.get(beanName);
            if (dependentBeans == null) {
                dependentBeans = new LinkedHashSet<String>(8);
                this.dependentBeanMap.put(beanName, dependentBeans);
            }
            dependentBeans.add(dependentBeanName);
        }
        map = this.dependenciesForBeanMap;
        synchronized (map) {
            LinkedHashSet<String> dependenciesForBean = (LinkedHashSet<String>)this.dependenciesForBeanMap.get(dependentBeanName);
            if (dependenciesForBean == null) {
                dependenciesForBean = new LinkedHashSet<String>(8);
                this.dependenciesForBeanMap.put(dependentBeanName, dependenciesForBean);
            }
            dependenciesForBean.add(beanName);
        }
    }

    protected boolean hasDependentBean(String beanName) {
        return this.dependentBeanMap.containsKey(beanName);
    }

    public String[] getDependentBeans(String beanName) {
        Set dependentBeans = (Set)this.dependentBeanMap.get(beanName);
        if (dependentBeans == null) {
            return new String[0];
        }
        return dependentBeans.toArray(new String[dependentBeans.size()]);
    }

    public String[] getDependenciesForBean(String beanName) {
        Set dependenciesForBean = (Set)this.dependenciesForBeanMap.get(beanName);
        if (dependenciesForBean == null) {
            return new String[0];
        }
        return dependenciesForBean.toArray(new String[dependenciesForBean.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySingletons() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Destroying singletons in " + this);
        }
        Map map = this.singletonObjects;
        synchronized (map) {
            this.singletonsCurrentlyInDestruction = true;
        }
        map = this.disposableBeans;
        synchronized (map) {
            String[] disposableBeanNames = StringUtils.toStringArray(this.disposableBeans.keySet());
            for (int i = disposableBeanNames.length - 1; i >= 0; --i) {
                this.destroySingleton(disposableBeanNames[i]);
            }
        }
        map = this.singletonObjects;
        synchronized (map) {
            this.singletonObjects.clear();
            this.singletonFactories.clear();
            this.earlySingletonObjects.clear();
            this.registeredSingletons.clear();
            this.singletonsCurrentlyInDestruction = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySingleton(String beanName) {
        this.removeSingleton(beanName);
        DisposableBean disposableBean = null;
        Map map = this.disposableBeans;
        synchronized (map) {
            disposableBean = (DisposableBean)this.disposableBeans.remove(beanName);
        }
        this.destroyBean(beanName, disposableBean);
    }

    protected void destroyBean(String beanName, DisposableBean bean) {
        Set dependencies = (Set)this.dependentBeanMap.remove(beanName);
        if (dependencies != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Retrieved dependent beans for bean '" + beanName + "': " + dependencies);
            }
            Iterator it = dependencies.iterator();
            while (it.hasNext()) {
                String dependentBeanName = (String)it.next();
                this.destroySingleton(dependentBeanName);
            }
        }
        if (bean != null) {
            try {
                bean.destroy();
            }
            catch (Throwable ex) {
                this.logger.error("Destroy method on bean with name '" + beanName + "' threw an exception", ex);
            }
        }
    }

    protected final Object getSingletonMutex() {
        return this.singletonObjects;
    }
}

