/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.asynchronous;

import java.io.Serializable;
import java.rmi.dgc.VMID;
import java.util.Date;
import java.util.Queue;
import java.util.Stack;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.asynchronous.AsynchronousCommandException;
import net.sf.ehcache.constructs.asynchronous.Command;
import net.sf.ehcache.constructs.asynchronous.CommandNotFoundInCacheException;
import net.sf.ehcache.constructs.asynchronous.RetryAttemptTooSoonException;
import net.sf.ehcache.constructs.asynchronous.TooManyRetriesException;

public final class AsynchronousCommandExecutor {
    public static final String MESSAGE_CACHE = "net.sf.ehcache.constructs.asynchronous.MessageCache";
    public static final String SUCCESSFUL_EXECUTION = "Successful execution";
    public static final int DEFAULT_DISPATCHER_THREAD_INTERVAL_SECONDS = 60;
    public static final int MINIMUM_SAFE_DISPATCHER_THREAD_INTERVAL = 30;
    public static final String QUEUE_KEY = "QueueKey";
    private static final long WAIT_FOR_THREAD_INITIALIZATION = 5L;
    private static final Logger LOG = Logger.getLogger(AsynchronousCommandExecutor.class.getName());
    private static final int MS_PER_SECOND = 1000;
    private static AsynchronousCommandExecutor singleton;
    private static CacheManager cacheManager;
    private boolean active;
    private Thread dispatcherThread;
    private long dispatcherThreadIntervalSeconds;

    private AsynchronousCommandExecutor() throws CacheException {
        cacheManager = CacheManager.getInstance();
        this.addShutdownHook();
        this.active = true;
        this.dispatcherThreadIntervalSeconds = 60L;
        this.dispatcherThread = new DispatcherThread();
        this.dispatcherThread.start();
        try {
            Thread.sleep(5L);
        }
        catch (InterruptedException e) {
            LOG.log(Level.WARNING, "Interrupted while initiliazing", e);
        }
    }

    public static synchronized AsynchronousCommandExecutor getInstance() throws AsynchronousCommandException {
        if (singleton == null) {
            try {
                singleton = new AsynchronousCommandExecutor();
            }
            catch (CacheException e) {
                throw new AsynchronousCommandException("Cannot create CacheManager. Detailed message is: " + e.getMessage(), e);
            }
        }
        return singleton;
    }

    synchronized Queue getQueue() throws AsynchronousCommandException {
        Queue queue;
        Element element;
        Ehcache cache = this.getMessageCache();
        try {
            element = cache.get((Serializable)((Object)QUEUE_KEY));
        }
        catch (CacheException e) {
            throw new AsynchronousCommandException("Unable to retrieve queue.", e);
        }
        if (element == null) {
            queue = new ConcurrentLinkedQueue();
            Element queueElement = new Element(QUEUE_KEY, queue);
            cache.put(queueElement);
        } else {
            queue = (Queue)((Object)element.getValue());
        }
        return queue;
    }

    public Ehcache getMessageCache() throws AsynchronousCommandException {
        Ehcache cache = cacheManager.getEhcache(MESSAGE_CACHE);
        if (cache == null) {
            throw new AsynchronousCommandException("ehcache.xml with a configuration entry for net.sf.ehcache.constructs.asynchronous.MessageCache was not found in the classpath.");
        }
        return cache;
    }

    public synchronized String queueForExecution(Command command) throws AsynchronousCommandException {
        InstrumentedCommand instrumentedCommand = new InstrumentedCommand(command);
        String uid = this.storeCommandToCache(instrumentedCommand);
        this.enqueue(uid);
        this.notifyAll();
        return uid;
    }

    private void enqueue(String uid) throws AsynchronousCommandException {
        Queue queue = this.getQueue();
        queue.add(uid);
    }

    public synchronized int getExecuteAttemptsForCommand(String uid) throws CommandNotFoundInCacheException, AsynchronousCommandException {
        InstrumentedCommand instrumentedCommand = this.retrieveInstrumentedCommandFromCache(uid);
        if (instrumentedCommand == null) {
            throw new CommandNotFoundInCacheException("Command " + uid + " + was not found in the messageCache");
        }
        return instrumentedCommand.getExecuteAttempts();
    }

    private synchronized void dispatcherThreadMain() {
        while (true) {
            try {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "dispatcherThreadIntervalSeconds: " + this.dispatcherThreadIntervalSeconds);
                }
                this.wait(this.dispatcherThreadIntervalSeconds * 1000L);
            }
            catch (InterruptedException e) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "messageCache: Dispatcher thread interrupted on Disk Store.");
                }
                return;
            }
            if (!this.active) {
                return;
            }
            this.executeCommands();
        }
    }

    private synchronized void executeCommands() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "executeCommands invoked. " + this.countCachedPublishCommands() + " messages to be sent.");
        }
        Queue queue = null;
        InstrumentedCommand instrumentedCommand = null;
        try {
            queue = this.getQueue();
        }
        catch (AsynchronousCommandException e) {
            LOG.log(Level.SEVERE, "Unable to access the cache to retrieve commands. ", e);
        }
        Object object = null;
        while ((object = queue.peek()) != null) {
            String uid = object;
            try {
                try {
                    instrumentedCommand = this.retrieveInstrumentedCommandFromCache(uid);
                    instrumentedCommand.attemptExecution();
                    this.remove(queue, uid, SUCCESSFUL_EXECUTION);
                }
                catch (RetryAttemptTooSoonException e) {
                    if (!LOG.isLoggable(Level.FINE)) break;
                    LOG.log(Level.FINE, e.getMessage(), e);
                    break;
                }
                catch (TooManyRetriesException e) {
                    this.remove(queue, uid, e.getMessage());
                }
                catch (CommandNotFoundInCacheException e) {
                    this.remove(queue, uid, e.getMessage());
                }
            }
            catch (Throwable throwable) {
                boolean match = this.checkIfRetryOnThrowable(throwable, instrumentedCommand);
                if (!match) {
                    this.remove(queue, uid, throwable.getMessage());
                    continue;
                }
                if (!LOG.isLoggable(Level.INFO)) break;
                LOG.log(Level.INFO, "Publishing attempt number " + instrumentedCommand.getExecuteAttempts() + " failed. " + throwable.getMessage(), throwable);
                break;
            }
        }
    }

    private boolean checkIfRetryOnThrowable(Throwable throwable, InstrumentedCommand instrumentedCommand) {
        Command command = instrumentedCommand.command;
        Class[] retryThrowables = command.getThrowablesToRetryOn();
        if (retryThrowables == null) {
            return false;
        }
        boolean match = false;
        for (int i = 0; i < retryThrowables.length; ++i) {
            Class retryThrowable = retryThrowables[i];
            if (!retryThrowable.isInstance(throwable)) continue;
            match = true;
        }
        return match;
    }

    private void remove(Queue queue, String uid, String reason) {
        queue.remove();
        Ehcache cache = null;
        try {
            cache = this.getMessageCache();
        }
        catch (AsynchronousCommandException e) {
            LOG.log(Level.SEVERE, "Unable to get cache + " + e.getMessage(), e);
        }
        cache.remove((Serializable)((Object)uid));
        if (reason.equals(SUCCESSFUL_EXECUTION)) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Deleting command with uid " + uid + ". " + reason);
            }
        } else {
            LOG.log(Level.SEVERE, "Deleting command with uid " + uid + ".  " + reason);
        }
    }

    private InstrumentedCommand retrieveInstrumentedCommandFromCache(String uid) throws CommandNotFoundInCacheException {
        Element element = null;
        try {
            Ehcache cache = this.getMessageCache();
            element = cache.get((Serializable)((Object)uid));
        }
        catch (Exception e) {
            throw new CommandNotFoundInCacheException("Cache error while retrieving command", e);
        }
        if (element == null) {
            throw new CommandNotFoundInCacheException("Command " + uid + " not found in cache.");
        }
        return (InstrumentedCommand)element.getValue();
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (AsynchronousCommandExecutor.this.active) {
                        LOG.log(Level.INFO, "VM shutting down with the MessageDispatcher active. There are " + AsynchronousCommandExecutor.this.countCachedPublishCommands() + " messages which will be cached to disk for delivery on VM restart.");
                        AsynchronousCommandExecutor.this.dispose();
                    }
                }
            }
        });
    }

    public synchronized int countCachedPublishCommands() {
        int messageCount = 0;
        try {
            Ehcache cache = this.getMessageCache();
            messageCount = cache.getSize();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Unable to determine the number of messages in the messageCache.", e);
        }
        if (messageCount != 0) {
            --messageCount;
        }
        return messageCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose() {
        int messages = this.countCachedPublishCommands();
        LOG.log(Level.INFO, "Shutting down Message Dispatcher. " + messages + " messages remaining.");
        if (!this.active) {
            return;
        }
        try {
            if (this.dispatcherThread != null) {
                this.dispatcherThread.interrupt();
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Could not shut down MessageDispatcher", e);
        }
        finally {
            this.active = false;
            this.notifyAll();
        }
    }

    String storeCommandToCache(InstrumentedCommand instrumentedCommand) throws AsynchronousCommandException {
        String uid = this.generateUniqueIdentifier();
        Element element = new Element((Serializable)((Object)uid), instrumentedCommand);
        Ehcache messageCache = this.getMessageCache();
        messageCache.put(element);
        return uid;
    }

    String generateUniqueIdentifier() {
        VMID guid = new VMID();
        return guid.toString();
    }

    public void setDispatcherThreadIntervalSeconds(long dispatcherThreadIntervalSeconds) throws IllegalArgumentException {
        if (dispatcherThreadIntervalSeconds < 30L) {
            throw new IllegalArgumentException("Must be greater than 30 seconds to avoid high cpu load");
        }
        this.setUnsafeDispatcherThreadIntervalSeconds(dispatcherThreadIntervalSeconds);
    }

    public void setUnsafeDispatcherThreadIntervalSeconds(long dispatcherThreadIntervalSeconds) {
        this.dispatcherThreadIntervalSeconds = dispatcherThreadIntervalSeconds;
    }

    private static final class InstrumentedCommand
    implements Serializable {
        private Command command;
        private Stack executeAttempts;

        private InstrumentedCommand(Command command) {
            this.command = command;
            this.executeAttempts = new Stack();
        }

        private void registerExecutionAttempt() {
            Date date = new Date();
            this.executeAttempts.add(date);
        }

        private void attemptExecution() throws Throwable, TooManyRetriesException, RetryAttemptTooSoonException {
            this.checkAttemptNotTooSoon();
            this.checkNotTooManyAttempts();
            this.command.execute();
        }

        private void checkAttemptNotTooSoon() throws RetryAttemptTooSoonException {
            if (!this.executeAttempts.empty()) {
                Date lastAttempt = (Date)this.executeAttempts.peek();
                long delay = this.command.getDelayBetweenAttemptsInSeconds() * 1000;
                Date now = new Date();
                Date nextAttemptDue = new Date(lastAttempt.getTime() + delay);
                if (now.before(nextAttemptDue)) {
                    throw new RetryAttemptTooSoonException("Attempt to execute command before it is due is being ignored.");
                }
            }
        }

        private void checkNotTooManyAttempts() throws TooManyRetriesException {
            this.registerExecutionAttempt();
            if (this.getExecuteAttempts() > this.command.getNumberOfAttempts()) {
                throw new TooManyRetriesException("Retry attempt number " + this.getExecuteAttempts() + " is greater than " + " the number permitted of " + this.command.getNumberOfAttempts() + ".\n" + this);
            }
        }

        private int getExecuteAttempts() {
            if (this.executeAttempts.empty()) {
                return 0;
            }
            return this.executeAttempts.size();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("InstrumentedCommand: \n").append(super.toString()).append("Previous Execution Attempts: \n");
            if (this.getExecuteAttempts() > 0) {
                for (int i = 0; i < this.getExecuteAttempts(); ++i) {
                    Date date = (Date)this.executeAttempts.get(i);
                    buffer.append(date).append(" ");
                }
            }
            buffer.append("Command: \n").append(this.command);
            return buffer.toString();
        }
    }

    private class DispatcherThread
    extends Thread {
        public DispatcherThread() {
            super("Message Dispatcher Thread");
            this.setDaemon(true);
        }

        public void run() {
            AsynchronousCommandExecutor.this.dispatcherThreadMain();
        }
    }
}

