/*
 * This file is automatically generated, do not edit directly.
 * Generated Sun Aug 27 22:16:27 2006 by ./txt2h.pl.
 */

/* Generated from "../search_help.txt" */
#define SEARCH_HELP_TXT_STRING  \
    "\n"\
    "Searching\n"\
    "+++++++++\n"\
    "\n"\
    "When a \"_search\" directory is present, it indicates that the UPnP device \n"\
    "supports some kind of searching.\n"\
    "\n"\
    "Searching is done in \"_search\" by entering a sub-directory name with\n"\
    "a specific search syntax : see \"Basic search\" and \"Advanced search\" below.\n"\
    "\n"\
    "Each search (basic or advanced) can be refined using the sub-directories \n"\
    "\"_and\" and \"_or\" found in results. These are equivalent to a single search \n"\
    "grouping the previous search and the new search using the 'and' and 'or' \n"\
    "logical operators.\n"\
    "For example:\n"\
    "	$ cd 's1'\n"\
    "	$ cd _and\n"\
    "	$ cd 's2'\n"\
    "is equivalent to searching for both criteria 's1' and 's2'.\n"\
    "\n"\
    "When a search returns no result, no sub-directory is created :\n"\
    "   $ cd _search/non_existant_criteria\n"\
    "cd: _search/non_existant_criteria: No such file or directory\n"\
    "\n"\
    "\n"\
    "\n"\
    "A) Basic search\n"\
    "===============\n"\
    "\n"\
    "Searching is done in \"_search\" by entering a sub-directory name with only\n"\
    "*one* word. This word is searched in common properties for the objects \n"\
    "(title, creator name, artists names, album name). It is ok to match only \n"\
    "a part of these strings, and the match is case-insensitive.\n"\
    "\n"\
    "For example, to search for all objects where the title, creator, artist or\n"\
    "album names contain the string \"head\" :\n"\
    "   $ cd _search\n"\
    "   $ cd head\n"\
    "\n"\
    "This would match for example any track by group \"Motorhead\", or a track named \n"\
    "\"Can't Get You Out Of My Head\", or any track from album \"Head First\".\n"\
    "\n"\
    "To further refine the search, it is possible to use the \"_and\" and \"_or\"\n"\
    "sub-directories, as explained above.\n"\
    "\n"\
    "Starting from the preceding example, to keep only only the \"Motorhead\" tracks,\n"\
    "one could do :\n"\
    "   $ cd _and\n"\
    "   $ cd mot\n"\
    "\n"\
    "\n"\
    "\n"\
    "B) Advanced search\n"\
    "==================\n"\
    "\n"\
    "Searching is done in \"_search\" by entering a sub-directory name with\n"\
    "a specific search syntax : see \"Search criteria\" below.\n"\
    "\n"\
    "For example, to search for all objects where the title contains the string \"by\"\n"\
    "(note the single-quote around the criteria necessary for the shell) :\n"\
    "   $ cd _search\n"\
    "   $ ls 'dc:title contains \"by\"'\n"\
    "\n"\
    "See more examples at the end of this document.\n"\
    "\n"\
    "\n"\
    "Advanced search criteria syntax \n"\
    "-------------------------------\n"\
    "\n"\
    "SearchCriteria directory names shall follow the following pseudo-grammar\n"\
    "(this grammar follows the SearchCriteria defined in the UPnP AV standard, \n"\
    "as defined in the \"ContentDirectory:1 Service Template Version 1.01\" document).\n"\
    "\n"\
    "Characters between 'single quote' must appear literally.\n"\
    "\n"\
    "\n"\
    "searchCriteria	::= searchExp | '*'\n"\
    "searchExp    	::= relExp | \n"\
    "		    searchExp space+ logicalOp space+ searchExp | \n"\
    "		    '(' space* searchExp space* ')' \n"\
    "logicalOp	::= 'and' | 'or' \n"\
    "relExp	     	::= property space+ binOp space+ quotedString | \n"\
    "		    property space+ existsOp space+ boolean \n"\
    "binOp	    	::= relOp | stringOp \n"\
    "relOp		::= '=' | '!=' | '<' | '<=' | '>' | '>=' \n"\
    "stringOp	::= 'contains' | 'doesNotContain' | 'derivedfrom' \n"\
    "existsOp	::= 'exists' \n"\
    "boolean		::= 'true' | 'false' \n"\
    "space		::= ' '\n"\
    "quotedString	::= (1)\n"\
    "property	::= (2)\n"\
    "\n"\
    "\n"\
    "(1) a \"quotedString\" is a string enclosed within double-quotes '\"'. Inside such\n"\
    "    strings, double-quote themselves shall be escaped e.g. represented as \\\" .\n"\
    "\n"\
    "(2) a \"property\" represents a characteristic of an UPnP object. \n"\
    "    Standard property names are normally defined, but are not necessarily \n"\
    "    implemented by all devices (also, non-standard properties can be added) :\n"\
    "    see \"Search capabilities\" below for examples of standard properties.\n"\
    "\n"\
    "\n"\
    "Notes on search criteria\n"\
    "------------------------\n"\
    "\n"\
    "- Search criteria expressions contain special characters that shall be quoted\n"\
    "  when used on the shell command line (e.g. '*', '<', '(', '\"', ...). The\n"\
    "  easiest method is to enclose the whole criteria within 'single quote',\n"\
    "  as in the example in this document.\n"\
    "\n"\
    "- double-quote (\") shall be escaped within quotedString e.g. represented as \\\"\n"\
    "\n"\
    "- Operator precedence, highest to lowest, is: \n"\
    "	double quoting \n"\
    "	( ) \n"\
    "	binOp, existsOp \n"\
    "	'and' \n"\
    "	'or' \n"\
    "  For example,\n"\
    "	$ cd 's1 and s2 or s3 or s4 and s5' \n"\
    "  is equivalent to\n"\
    "	$ cd '((s1 and s2) or s3) or (s4 and s5)'\n"\
    "\n"\
    "- Return all : the special criteria '*' means \"find everything\", or \n"\
    "  \"return all objects that exist beneath the selected starting directory\"\n"\
    "  (beware of performances on large collections). \n"\
    "\n"\
    "- Property existence is queried for by using the 'exists' binary operator. \n"\
    "  The criteria \"actor exists true\" is true for every object that has at least \n"\
    "  one occurrence of the actor property. It is false for any object that has no\n"\
    "  actor property. Similarly, the criteria \"actor exists false\" is false for \n"\
    "  every object that has at least one occurrence of the actor property. It is \n"\
    "  true for any object that has no actor property. \n"\
    "\n"\
    "- Property omission : any property value query (as distinct from an existence \n"\
    "  query) applied to an object that does not have that property, evaluates \n"\
    "  to false. \n"\
    "\n"\
    "- Class derivation (see \"Class hierarchy\" below) : the 'derivedfrom' operator\n"\
    "  allows to query the existence of objects whose class is derived from some \n"\
    "  base class specification. For example 'upnp:class derivedfrom \"object.item\"'\n"\
    "  is true for all objects whose class is, or begins with, \"object.item\".\n"\
    "\n"\
    "- Numeric comparisons : when an operator in a criteria is a relOp ('=', '<',\n"\
    "  '<=', ...), the quotedString can be a decimal integer (sequence of decimal\n"\
    "  digits with an optional leading sign '+' or '-'). The comparison will be\n"\
    "  done numerically if the actual property is also a decimal integer. In all \n"\
    "  other cases, the comparison is done by treating both values as strings.\n"\
    "\n"\
    "- String comparisons : all operators when applied to strings use \n"\
    "  case-insensitive comparisons. \n"\
    "\n"\
    "\n"\
    "Advanced search capabilities\n"\
    "----------------------------\n"\
    "\n"\
    "The \"search_capabilities\" file is a list of property names that can be used \n"\
    "in search criteria. A wild-card ('*') indicates that the device supports \n"\
    "search queries using all tags present in the device.\n"\
    "\n"\
    "Some common properties are (not necessarily supported by all UPnP devices) :\n"\
    "\n"\
    "dc:title 	Name of the object\n"\
    "dc:creator	Primary content creator or owner of the object \n"\
    "upnp:artist	Name of an artist\n"\
    "upnp:genre	Name of the genre to which an object belongs \n"\
    "upnp:album	Title of the album to which the object belongs\n"\
    "dc:date		Date of the object, of the form \"YYYY-MM-DD\" (ISO 8601 format) \n"\
    "upnp:class	Class of the object\n"\
    "@id		An identifier for the object, unique within the UPnP device.\n"\
    "\n"\
    "\n"\
    "Advanced class hierarchy\n"\
    "------------------------\n"\
    "\n"\
    "A class is used to assign a type to an object in an UPnP device, and identifies\n"\
    "the set of properties present on that object. Classes are organized in a \n"\
    "hierarchy with certain classes being derived from others as in a typical object\n"\
    "oriented system. At the root of the class hierarchy is the 'object' base class.\n"\
    "\n"\
    "Each class is named using a string in \"dotted\" notation:\n"\
    "     derivedName ::= ( 'object' | derivedName ) '.' shortName \n"\
    "Some example are 'object', 'object.item', 'object.container', \n"\
    "'object.item.audioItem.musicTrack' and 'object.container.album.musicAlbum'.\n"\
    "\n"\
    "The UPnP AV standard defines a number of class descriptions that are derived \n"\
    "from either the 'item' or 'container' classes : see figure below (only \n"\
    "shortNames are displayed in the tree).\n"\
    "Device vendors are free to extend this list with other classes or properties.\n"\
    " \n"\
    " \n"\
    "  object\n"\
    "    |___ item\n"\
    "    |     |___ audioItem\n"\
    "    |     |      |___ musicTrack\n"\
    "    |     |      |___ audioBroadcast\n"\
    "    |     |      \\___ audioBook\n"\
    "    |     |\n"\
    "    |     |___ videoItem\n"\
    "    |     |      |___ movie\n"\
    "    |     |      |___ videoBroadcast\n"\
    "    |     |      \\___ musicVideoClip\n"\
    "    |     |\n"\
    "    |     |___ imageItem\n"\
    "    |     |      \\___ photo\n"\
    "    |     |\n"\
    "    |     |___ playlistItem\n"\
    "    |     |\n"\
    "    |     \\___ textItem\n"\
    "    |\n"\
    "    \\___ container\n"\
    "          |___ album\n"\
    "          |      |___ musicAlbum\n"\
    "          |      \\___ photoAlbum\n"\
    "          |\n"\
    "          |___ genre\n"\
    "          |      |___ musicGenre\n"\
    "          |      \\___ movieGenre\n"\
    "          |\n"\
    "          |___ playlistContainer\n"\
    "          |\n"\
    "          |___ person\n"\
    "          |      \\___ musicArtist\n"\
    "          |\n"\
    "          |___ storageSystem\n"\
    "          |___ storageVolume\n"\
    "          \\___ storageFolder\n"\
    " \n"\
    "\n"\
    "\n"\
    "Notes on these standard classes :\n"\
    "\n"\
    "- 'item' : a derived class of 'object' used to represent \"atomic\" \n"\
    "  content objects, i.e. object that don't contain other objects, for example, \n"\
    "  a music track on an audio CD\n"\
    "\n"\
    "- 'container' : a derived class of 'object' used to represent \n"\
    "  containers e.g. a music album. In djmount, each container is mapped to a \n"\
    "  directory.\n"\
    "  \n"\
    "- 'audioItem' : a piece of content that, when rendered, generates some audio. \n"\
    "  Note that movies, TV broadcasts, etc., that also contain an audio track \n"\
    "  are excluded from this definition : those objects should be classified \n"\
    "  under 'videoItem' (see below).\n"\
    "  Standard derived classes are 'musicTrack' (audio that should be interpreted  \n"\
    "  as music e.g. a song), 'audioBroadcast' (a continuous stream of audio that \n"\
    "  should be interpreted as an audio broadcast) and 'audioBook' (audio that\n"\
    "  should be interpreted as a book).\n"\
    "\n"\
    "- 'videoItem' : a piece of content that, when rendered, generates some video. \n"\
    "  Standard derived classes are 'movie' (video that should be interpreted \n"\
    "  as a movie), 'videoBroadcast' (a continuous stream of video that should be \n"\
    "  interpreted as a broadcast e.g. a conventional TV channel or a Webcast),\n"\
    "  and 'musicVideoClip' (video that should be interpreted as a clip supporting \n"\
    "  a song).\n"\
    "\n"\
    "- 'imageItem' : a piece of content that, when rendered, generates some still \n"\
    "  image. A standard derived class is 'photo' (image that should be interpreted \n"\
    "  as a photo, as opposed to, for example, an icon).\n"\
    "\n"\
    "- 'playlistItem' : a playable sequence of resources. It is different from \n"\
    "  'musicAlbum' in the sense that a 'playlistItem' may contain a mix \n"\
    "  of audio, video and images and is typically created by a user, while an \n"\
    "  'album' is typically a fixed published sequence of songs (e.g. an audio CD).\n"\
    "  A 'playlistItem' item is typically a reference to a playlist file \n"\
    "  (e.g. an external M3U file). \n"\
    "\n"\
    "- 'textItem' : a piece of content that, when rendered, is readable as text.\n"\
    "\n"\
    "- 'album' : an ordered collection of 'objects'. \n"\
    "  Standard derived classes are 'musicAlbum' (which contains items of class \n"\
    "  'musicTrack', or 'sub'-albums of class 'musicAlbum', e.g. an audio-CD) \n"\
    "  and 'photoAlbum' (which contains items of class 'photo', or 'sub'-albums \n"\
    "  of class 'photoAlbum').\n"\
    "\n"\
    "- 'genre' : an unordered collection of 'objects' that \"belong\" to the genre,\n"\
    "  in a loose sense. \n"\
    "  Standard derived classes are 'musicGenre' (genre which should be interpreted\n"\
    "  as a \"style of music\" e.g. \"Rock\") and 'movieGenre' (genre which should be \n"\
    "  interpreted as a \"style of movies\" e.g. \"Western\").\n"\
    "\n"\
    "- 'playlistContainer' : a collection of 'objects'. It is different from \n"\
    "  'musicAlbum' in the sense that a 'playlistContainer' may contain a mix \n"\
    "  of audio, video and images and is typically created by a user, while an\n"\
    "  'album' is typically a fixed published sequence of songs (e.g. an audio CD).\n"\
    "  \n"\
    "- 'person' : an unordered collection of 'objects' that \"belong\" to some people,\n"\
    "  in a loose sense. A standard derived class is 'musicArtist' (a music artist).\n"\
    "\n"\
    "- 'storageSystem' : a potentially heterogeneous collection of storage media. \n"\
    "  An example is a CD Jukebox.\n"\
    "\n"\
    "- 'storageVolume' : some physical storage unit of a single type. Examples are \n"\
    "  a Hard Disk Drive, a CD-Audio disc, or a Flash memory card.\n"\
    "\n"\
    "- 'storageFolder' : a collection of objects stored on some storage medium. \n"\
    "  Examples are a directory on a Hard Disk Drive, or a directory on CD-Rom.\n"\
    "\n"\
    "\n"\
    "\n"\
    "Advanced search examples \n"\
    "------------------------\n"\
    "\n"\
    "a) Search for all content by singer Renaud\n"\
    "   i.e. search for all objects where 'dc:creator' is Renaud\n"\
    "\n"\
    "   $ cd _search\n"\
    "   $ ls 'dc:creator = \"Renaud\"'\n"\
    "\n"\
    "   Note that this is equivalent to 'dc:creator = \"renaud\"' because comparisons\n"\
    "   are case-insensitive.\n"\
    "\n"\
    " \n"\
    "b) Search for all photos taken during October 2005\n"\
    "   i.e. search for all photo objects whose 'dc:date' is in October 2005\n"\
    "\n"\
    "   $ cd _search\n"\
    "   $ ls 'upnp:class = \"object.item.imageItem.photo\" and ( dc:date >= \"2005-10-01\" and dc:date <= \"2005-10-31\" )'\n"\
    "\n"\
    "   Note that this is equivalent to the following breakdown, using \"_and\"\n"\
    "   sub-directories :\n"\
    "\n"\
    "   $ cd _search\n"\
    "   $ cd 'upnp:class = \"object.item.imageItem.photo\"'\n"\
    "   $ cd _and\n"\
    "   $ ls 'dc:date >= \"2005-10-01\"/_and/dc:date <= \"2005-10-31\"'\n"\
    "\n"\
    "\n"\
    "c) Search for all objects in the My Photos folder containing the word Paris\n"\
    "   i.e. search for all objects where the 'dc:title' contains Paris under the \n"\
    "   \"My Photos\" directory.\n"\
    "\n"\
    "   $ cd \"My Photos/_search\"\n"\
    "   $ ls 'dc:title contains \"Paris\"'\n"\
    "\n"\
    "\n"\
    "d) Search for all album objects in the device\n"\
    "   i.e. search for all objects that are derived from object.container.album. \n"\
    "\n"\
    "   $ cd _search\n"\
    "   $ ls 'upnp:class derivedfrom \"object.container.album\"'\n"\
    "\n"\
    "\n"\
    "\n"\

#define SEARCH_HELP_TXT_LENGTH  12826

