# HDRL_CHECK([location])
# ----------------------
# Sets build variables required to build and link hdrl
# the argument defines the relative location of the hdrl external in the source
# tree
AC_DEFUN([HDRL_CHECK],
[
    HDRL_LOCATION="$1"
    AC_MSG_CHECKING([HDRL in $HDRL_LOCATION])

    # visibility hidden to not expose any hdrl symbols in the pipeline shared
    # libraries
    HDRL_INTERNAL_CFLAGS="-std=c99 -fvisibility=hidden"
    # requires cpl and libm as it is a static library
    HDRL_LIBS="-lhdrl -lcplcore -lcpldrs -lcplui -lcpldfs -lcext -lm"
    # la file to be added to DEPENDENCIES libtool doesn't track static libs
    LIBHDRL="\$(top_builddir)/$HDRL_LOCATION/libhdrl.la"
    HDRL_LDFLAGS="-L\$(top_builddir)/$HDRL_LOCATION"
    HDRL_INCLUDES="-I\$(top_srcdir)/$HDRL_LOCATION"

    AC_SUBST(HDRL_LIBS)
    AC_SUBST(LIBHDRL)
    AC_SUBST(HDRL_LDFLAGS)
    AC_SUBST(HDRL_INTERNAL_CFLAGS)
    AC_SUBST(HDRL_INCLUDES)

    AC_MSG_RESULT([ok])
])
