;;; -*- Mode: LISP; Syntax: ANSI-Common-Lisp; Package: STREAM -*-
;;;

(ext:file-comment
 "$Header: src/pcl/simple-stream-stub.lisp $")

;;; This is a collection of stubs for simple-stream methods to get rid
;;; of compiler warnings about undefined simple stream functions when
;;; compiling stream code.
;;;
;;; When simple-streams are loaded, they will overwrite these methods.

(in-package "STREAM")

(defun %input-stream-p (stream)
  (declare (type simple-stream stream))
  t)

(defun %output-stream-p (stream)
  (declare (type simple-stream stream))
  t)

(defun %open-stream-p (stream)
  (declare (type simple-stream stream))
  t)

(defun %interactive-stream-p (stream)
  (declare (type simple-stream stream))
  t)

(defun %interactive-stream-y (stream)
  (declare (type simple-stream stream))
  t)

(defun %interactive-stream-n (stream)
  (declare (type simple-stream stream))
  t)

(defun %stream-external-format (stream)
  (declare (type simple-stream stream))
  t)

(defun %charpos (stream)
  (declare (type simple-stream stream))
  t)

(defun %file-position (stream position)
  (declare (type simple-stream stream)
	   (type (or (integer 0 *) (member nil :start :end)) position))
  t)

(defun %file-length (stream)
  (declare (type simple-stream stream))
  t)

(defun %file-name (stream)
  (declare (type simple-stream stream))
  t)

(defun %file-rename (stream new-name)
  (declare (type simple-stream stream))
  t)

(defun %file-string-length (stream object)
  (declare (type simple-stream stream))
  t)

(defun %read-line (stream eof-error-p eof-value recursive-p)
  (declare (optimize (speed 3) (space 1) (safety 0))
	   (type simple-stream stream)
	   (ignore recursive-p))
  t)

(defun %read-char (stream eof-error-p eof-value recursive-p blocking-p)
  (declare (type simple-stream stream)
	   (ignore recursive-p))
  t)

(defun %unread-char (stream character)
  (declare (type simple-stream stream) (ignore character))
  t)

(defun %peek-char (stream peek-type eof-error-p eof-value recursive-p)
  (declare (type simple-stream stream)
	   (ignore recursive-p))
  t)

(defun %listen (stream width)
  (declare (type simple-stream stream))
  t)

(defun %clear-input (stream buffer-only)
  (declare (type simple-stream stream))
  t)

(defun %read-byte (stream eof-error-p eof-value)
  (declare (type simple-stream stream))
  t)

(defun %write-char (stream character)
  (declare (type simple-stream stream))
  t)

(defun %fresh-line (stream)
  (declare (type simple-stream stream))
  t)

(defun %write-string (stream string start end)
  (declare (type simple-stream stream))
  t)

(defun %line-length (stream)
  (declare (type simple-stream stream))
  ;; implement me
  nil)


(defun %finish-output (stream)
  (declare (type simple-stream stream))
  nil)

(defun %force-output (stream)
  (declare (type simple-stream stream))
  nil)

(defun %clear-output (stream)
  (declare (type simple-stream stream))
  t)

(defun %write-byte (stream integer)
  (declare (type simple-stream stream))
  t)

(defun %read-sequence (stream seq start end partial-fill)
  (declare (type simple-stream stream)
	   (type sequence seq)
	   (type lisp::index start)
	   (type (or null lisp::index) end)
	   (type boolean partial-fill))
  t)

(defun %write-sequence (stream seq start end)
  (declare (type simple-stream stream)
	   (type sequence seq)
	   (type lisp::index start)
	   (type (or null lisp::index) end))
  seq)
