/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

/* Copyright (C) 2018-2020 Hans Petter Jansson
 *
 * This file is part of Chafa, a program that turns images into character art.
 *
 * Chafa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Chafa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Chafa.  If not, see <http://www.gnu.org/licenses/>. */

#ifndef __GIF_LOADER_H__
#define __GIF_LOADER_H__

#include <glib.h>
#include "file-mapping.h"

G_BEGIN_DECLS

typedef struct GifLoader GifLoader;

GifLoader *gif_loader_new_from_mapping (FileMapping *mapping);
void gif_loader_destroy (GifLoader *loader);

void gif_loader_get_geometry (GifLoader *loader, gint *width_out, gint *height_out);
gint gif_loader_get_n_frames (GifLoader *loader);

const guint8 *gif_loader_get_frame_data (GifLoader *loader, gint *post_frame_delay_hs_out);

void gif_loader_first_frame (GifLoader *loader);
gboolean gif_loader_next_frame (GifLoader *loader);

G_END_DECLS

#endif /* __GIF_LOADER_H__ */
