/***************************************************************************
 *   Copyright (C) 2005-2006 Gao Xianchao                                  *
 *                 2007 Gao Xianchao gnap_an linux_lyb ahlongxp            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * Author:	gxc
 * Create data:	2005-12-04 16:09
 */
 
#include <unistd.h>
#include "NewTaskWindow.h"
#include "utils.h"
#include "log.h"

const char* encodings[] =
{
	"BIG5",
	"GB2312",
	"GB18030",
	"GBK",
	"UTF-8",
	NULL
};

enum
{
	ID_COLUMN,
	TOGGLE_COLUMN,
	SIZE_COLUMN,
	NAME_COLUMN,
	N_COLUMN
};

CNewTaskWindow::CNewTaskWindow()
{
}

CNewTaskWindow::~CNewTaskWindow()
{
}

void CNewTaskWindow::toggle_event(GtkCellRendererToggle*cell_renderer, gchar *path, gpointer user_data)
{
	CNewTaskWindow*self = (CNewTaskWindow*)user_data;
	GtkTreeIter iter;
	GtkTreePath *treePath = gtk_tree_path_new_from_string (path);
  	gtk_tree_model_get_iter (GTK_TREE_MODEL (self->_store),
  		&iter,
        treePath);	
        
    gboolean seted = FALSE;
        
    gtk_tree_model_get(GTK_TREE_MODEL (self->_store),
    	&iter,
    	TOGGLE_COLUMN, &seted,
    	-1);
        
	gtk_list_store_set (self->_store, &iter,
		TOGGLE_COLUMN, !seted,
		-1);
		
	self->updateSelectedSize();	
}

void CNewTaskWindow::select_dir_event(GtkWidget* widget, gpointer data)
{
	CNewTaskWindow*self = (CNewTaskWindow*)data;
	
	std::string destPath;
	if(self->_task->getTorrentFile()->IsUTF8Valid())
	{
		destPath = self->getUserInputDestPath(self->_task->getTorrentFile()->getNameUTF8().c_str());
	}
	else
	{
		destPath = self->getUserInputDestPath(self->_task->getTorrentFile()->getName().c_str());
	}
	
	gtk_entry_set_text(GTK_ENTRY(self->_downloadToEntry), destPath.c_str());
}

void CNewTaskWindow:: encoding_changed(GtkComboBox *widget, gpointer user_data)
{
	CNewTaskWindow*self = (CNewTaskWindow*)user_data;
	std::string aa = self->_task->getTorrentFile()->getComment();
	gchar* enc = gtk_combo_box_get_active_text(GTK_COMBO_BOX(self->_encodingComboBox));
	self->_task->getTorrentFile()->setCharacterEncoding(enc);
	self->updateEncoding();
	g_free(enc);
}

void CNewTaskWindow::select_all_cb (GtkWidget *widget, gpointer data)
{
	CNewTaskWindow *self = (CNewTaskWindow*)data;
    GtkListStore *_store = self -> get_store (); 	
    GtkTreeIter iter;
	
    bool notEof = gtk_tree_model_get_iter_first(GTK_TREE_MODEL (_store), &iter);
	while(notEof)
	{
	    gtk_list_store_set (_store, &iter,
		    TOGGLE_COLUMN, TRUE,
		    -1);
        
	    notEof = gtk_tree_model_iter_next(GTK_TREE_MODEL (_store), &iter);
	}
	self->updateSelectedSize();	
}

void CNewTaskWindow::unselect_all_cb (GtkWidget *widget, gpointer data)
{
	CNewTaskWindow *self = (CNewTaskWindow*)data;
    GtkListStore *_store = self -> get_store (); 	
    GtkTreeIter iter;
	
    bool notEof = gtk_tree_model_get_iter_first(GTK_TREE_MODEL (_store), &iter);
	while(notEof)
	{
	    gtk_list_store_set (_store, &iter,
		    TOGGLE_COLUMN, FALSE,
		    -1);
        
	    notEof = gtk_tree_model_iter_next(GTK_TREE_MODEL (_store), &iter);
	}
	self->updateSelectedSize();	
}

void CNewTaskWindow::reverse_selected_cb (GtkWidget *widget, gpointer data)
{
	CNewTaskWindow *self = (CNewTaskWindow*)data;
    GtkListStore *_store = self -> get_store (); 	
    GtkTreeIter iter;
    gboolean seted = FALSE;
    bool notEof = gtk_tree_model_get_iter_first(GTK_TREE_MODEL (_store), &iter);
	while(notEof)
	{
        gtk_tree_model_get (GTK_TREE_MODEL(_store), &iter,
            TOGGLE_COLUMN, &seted,
            -1);

	    gtk_list_store_set (_store, &iter,
		    TOGGLE_COLUMN, !seted,
		    -1);
        
	    notEof = gtk_tree_model_iter_next(GTK_TREE_MODEL (_store), &iter);
	}
	self->updateSelectedSize();	
}

void CNewTaskWindow::createWindow()
{
   _dialog = gtk_dialog_new_with_buttons (_task->getTorrentFile()->getName().c_str(),
                                         NULL,
                                         GTK_DIALOG_MODAL,
                                         GTK_STOCK_CANCEL,
                                         GTK_RESPONSE_NONE,                                         
                                         GTK_STOCK_OK,
                                         GTK_RESPONSE_ACCEPT,
                                         NULL);	
    gtk_container_set_border_width(GTK_CONTAINER(_dialog), 10);	

	std::string title;
	if(_task->getTorrentFile()->IsUTF8Valid())
	{
		title = _task->getTorrentFile()->getNameUTF8() + " - BitStorm Lite";
	}
	else
	{
		title = _task->getTorrentFile()->getName() + " - BitStorm Lite";
	}        
    gtk_window_set_title(GTK_WINDOW(_dialog), title.c_str());                             

	GtkWidget* hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_set_spacing(GTK_BOX(hbox), 5);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(_dialog)->vbox), hbox, FALSE, FALSE, 5);	
	
	GtkWidget* downloadToLabel = gtk_label_new(_("Download to : "));	
	gtk_box_pack_start(GTK_BOX(hbox), downloadToLabel, FALSE, FALSE, 0);
	
	char buf[1024];
	getcwd(buf, sizeof(buf));
	_downloadToEntry = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(_downloadToEntry), buf);
	gtk_box_pack_start(GTK_BOX(hbox), _downloadToEntry, TRUE, TRUE, 0);
	
	GtkWidget* button = gtk_button_new_with_label("...");
	gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 0);
	g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(select_dir_event), this);
	
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_set_spacing(GTK_BOX(hbox), 15);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(_dialog)->vbox), hbox, FALSE, FALSE, 0);	
    
    GtkWidget *selectAllButton = gtk_button_new_with_label (_("Select All"));
    g_signal_connect (G_OBJECT(selectAllButton), "clicked", G_CALLBACK(select_all_cb), this);
    gtk_box_pack_start (GTK_BOX(hbox), selectAllButton, FALSE, FALSE, 0);

    GtkWidget *unselectAllButton = gtk_button_new_with_label (_("Unselect All"));
    g_signal_connect (G_OBJECT(unselectAllButton), "clicked", G_CALLBACK(unselect_all_cb), this);
    gtk_box_pack_start (GTK_BOX(hbox), unselectAllButton, FALSE, FALSE, 0);
    
    GtkWidget *reverseSelectedButton = gtk_button_new_with_label (_("Reverse Selected"));
    g_signal_connect (G_OBJECT(reverseSelectedButton), "clicked", G_CALLBACK(reverse_selected_cb), this);
    gtk_box_pack_start (GTK_BOX(hbox), reverseSelectedButton, FALSE, FALSE, 0);
	
    GtkWidget* label = gtk_label_new(_("Total size :"));	
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
	GtkWidget* totalSizeLabel = gtk_label_new(byteCount2Str(_task->getTorrentFile()->getTotalSize()).c_str());	
	gtk_box_pack_start(GTK_BOX(hbox), totalSizeLabel, FALSE, FALSE, 0);		
	
	label = gtk_label_new(_("Selected size :"));	
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
	_selectedSizeLabel = gtk_label_new(byteCount2Str(_task->getTorrentFile()->getTotalSize()).c_str());	
	gtk_box_pack_start(GTK_BOX(hbox), _selectedSizeLabel, FALSE, FALSE, 0);			
	
	createFileList();
	
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_set_spacing(GTK_BOX(hbox), 15);
	gtk_box_pack_end(GTK_BOX(GTK_DIALOG(_dialog)->vbox), hbox, FALSE, FALSE, 0);
	
	_encodingComboBox = gtk_combo_box_new_text();
	gtk_box_pack_end(GTK_BOX(hbox), _encodingComboBox, FALSE, FALSE, 0);
	
	int i = 0;
	while(encodings[i] != NULL)
	{
		gtk_combo_box_insert_text(GTK_COMBO_BOX(_encodingComboBox), 0, encodings[i]);		
		i++;
	}
	gtk_combo_box_set_active (GTK_COMBO_BOX(_encodingComboBox), 0);
	
	g_signal_connect(G_OBJECT(_encodingComboBox), "changed", G_CALLBACK(encoding_changed), this);
			
	label = gtk_label_new(_("If file name is shown incorrectly, please select other encoding"));	
	gtk_box_pack_end(GTK_BOX(hbox), label, FALSE, FALSE, 0);
}

void CNewTaskWindow::createFileList()
{
	_store = gtk_list_store_new(N_COLUMN,
		G_TYPE_INT,
		G_TYPE_BOOLEAN,
		G_TYPE_STRING,
		G_TYPE_STRING);
	
	GtkTreeIter iter;
	
	for(unsigned int i=0; i<_task->getTorrentFile()->getFileCount(); ++i)
	{
		TFileInfo fileInfo = _task->getTorrentFile()->getFileInfo(i);
		gtk_list_store_append(_store, &iter);
		gtk_list_store_set(_store,
			&iter,
			ID_COLUMN, i,
			TOGGLE_COLUMN, TRUE,
			SIZE_COLUMN, byteCount2Str(fileInfo.size).c_str(),
			NAME_COLUMN, fileInfo.nameUTF8.c_str(),
			-1);
	}
	
	GtkTreeModel* model = GTK_TREE_MODEL(_store);
	_view = gtk_tree_view_new_with_model(model);
	GtkCellRenderer* render = gtk_cell_renderer_text_new();
	GtkTreeViewColumn* column = gtk_tree_view_column_new_with_attributes(
		_("Index"), render, "text", ID_COLUMN, NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(_view), column);
	
	render = gtk_cell_renderer_toggle_new();
	gtk_cell_renderer_toggle_set_radio(GTK_CELL_RENDERER_TOGGLE(render), FALSE);
	g_signal_connect(G_OBJECT(render), "toggled", G_CALLBACK(toggle_event), this);
	column = gtk_tree_view_column_new_with_attributes(
		_("Download"), render, "active", TOGGLE_COLUMN, NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(_view), column);
	
	
	render = gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new_with_attributes(
		_("Size"), render, "text", SIZE_COLUMN, NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(_view), column);	
	
	render = gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new_with_attributes(
		_("File"), render, "text", NAME_COLUMN, NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(_view), column);
	
	GtkWidget* swindow = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_add(GTK_CONTAINER(swindow), _view);	
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(_dialog)->vbox), swindow, TRUE, TRUE, 3);	
}

bool CNewTaskWindow::show(IBTTask* task)
{
	_task = task;
	createWindow();
	
	gtk_window_set_default_size(GTK_WINDOW(_dialog), 500, 400);
	gtk_window_set_position(GTK_WINDOW(_dialog), GTK_WIN_POS_CENTER);	
	gtk_widget_show_all(_dialog);	
	
	if(GTK_RESPONSE_ACCEPT != gtk_dialog_run(GTK_DIALOG(_dialog)))
	{
		gtk_widget_destroy(_dialog);
		return false;
	}	
	
	
	_task->setDestPath(gtk_entry_get_text(GTK_ENTRY(_downloadToEntry)));
	
	TBanedFileList bandFileList;
	GtkTreeIter iter;
	unsigned int i = 0;
	bool notEof = gtk_tree_model_get_iter_first(GTK_TREE_MODEL (_store), &iter);
	while(notEof)
	{
	    gboolean seted = TRUE;
	        
	    gtk_tree_model_get(GTK_TREE_MODEL (_store),
	    	&iter,
	    	TOGGLE_COLUMN, &seted,
	    	-1);		
	    
	    if(!seted)
	    {
	    	bandFileList.push_back(i);
	    }
	    
	    i++;
	    notEof = gtk_tree_model_iter_next(GTK_TREE_MODEL (_store), &iter);
	}
	
	_task->setBanedFileList(bandFileList);
	
	gtk_widget_destroy(_dialog);
	
	return true;
}

std::string CNewTaskWindow::getUserInputDestPath(const char* fileName)
{
	GtkWidget *dialog;
	char *destDir = "";
	
	dialog = gtk_file_chooser_dialog_new (_("Please select a directory to save file"),
					      GTK_WINDOW(_dialog),
					      GTK_FILE_CHOOSER_ACTION_SAVE,
					      GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
					      GTK_STOCK_SAVE, GTK_FILE_CHOOSER_ACTION_SAVE,
					      NULL);
					      
	gtk_file_chooser_set_current_name(GTK_FILE_CHOOSER (dialog), fileName);
	
	if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_FILE_CHOOSER_ACTION_SAVE)
	{
	    destDir = gtk_file_chooser_get_current_folder (GTK_FILE_CHOOSER (dialog));
	}
	
	gtk_widget_destroy (dialog);
	
	std::string result = locale_to_utf8(destDir);
	if(result[result.size() -1] != '/')
	{
		result.append("/");
	}
  
  	return result;
}

void CNewTaskWindow::updateSelectedSize()
{
	GtkTreeIter iter;
	unsigned int i = 0;
	unsigned int selectedSize = 0;
	bool notEof = gtk_tree_model_get_iter_first(GTK_TREE_MODEL (_store), &iter);
	while(notEof)
	{
	    gboolean seted = FALSE;
	        
	    gtk_tree_model_get(GTK_TREE_MODEL (_store),
	    	&iter,
	    	TOGGLE_COLUMN, &seted,
	    	-1);		
	    
	    if(seted)
	    {
	    	selectedSize += _task->getTorrentFile()->getFileInfo(i).size;
	    }
	    
	    i++;
	    notEof = gtk_tree_model_iter_next(GTK_TREE_MODEL (_store), &iter);
	}
	
	gtk_label_set_text(GTK_LABEL(_selectedSizeLabel), 	byteCount2Str(selectedSize).c_str());
}

void CNewTaskWindow::updateEncoding()
{
	std::string title;
	if(_task->getTorrentFile()->IsUTF8Valid())
	{
		title = _task->getTorrentFile()->getNameUTF8() + " - BitStorm Lite";
	}
	else
	{
		title = _task->getTorrentFile()->getName() + " - BitStorm Lite";
	}        
    gtk_window_set_title(GTK_WINDOW(_dialog), title.c_str());     
    	
	GtkTreeIter iter;
	unsigned int i = 0;
	bool notEof = gtk_tree_model_get_iter_first(GTK_TREE_MODEL (_store), &iter);
	while(notEof)
	{
		gtk_list_store_set (_store, &iter,
			NAME_COLUMN, _task->getTorrentFile()->getFileInfo(i).nameUTF8.c_str(),
			-1);
			
		i++;
	    notEof = gtk_tree_model_iter_next(GTK_TREE_MODEL (_store), &iter);
	}		
}

