/*
Copyright (©) 2003-2018 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
  
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


function checksum_receive (data)
{
  var lines = data.split ("\n");
  var checksum = lines [0];
  lines.splice (0, 2);
  data = lines.join ("\n");
  if (checksum != checksum_get (data)) return false;
  return data;
}


// Checksum = length in bytes.
function checksum_get (data)
{
  var checksum = unescape (encodeURIComponent (data)).length;
  return checksum;
}


function checksum_readwrite (data)
{
  var lines = data.split ("\n");
  var readwrite = !(lines [1] == "0");
  return readwrite;
}
