/* -*- c-file-style: "GNU" -*- */
/*
 * Copyright (C) CNRS, INRIA, Universite Bordeaux 1, Telecom SudParis
 * See COPYING in top-level directory.
 */

#ifndef __EV_CODES_H__
#define __EV_CODES_H__

#define NB_BITS 24
#define NB_BITS_PREFIX 8
#define NB_BITS_EVENTS (NB_BITS - NB_BITS_PREFIX)

#define SYSTEM_MODULE_MASK (0<<(NB_BITS_PREFIX-1))
#define USER_MODULE_MASK (1<<(NB_BITS_PREFIX-1))

#define USER_MODULE_ID(id)   (id | USER_MODULE_MASK)
#define SYSTEM_MODULE_ID(id) (id | SYSTEM_MODULE_MASK)

#define GENERATE_USER_MODULE_PREFIX(id)   ((id) << NB_BITS_EVENTS)
#define GENERATE_SYSTEM_MODULE_PREFIX(id) ((id) << NB_BITS_EVENTS)

#define PTHREAD_CORE_EVENTS_ID 0x00
#define PTHREAD_CORE_PREFIX    GENERATE_SYSTEM_MODULE_PREFIX(PTHREAD_CORE_EVENTS_ID)

#define USER_CORE_EVENTS_ID    0x08
#define USER_CORE_PREFIX       GENERATE_SYSTEM_MODULE_PREFIX(USER_CORE_EVENTS_ID)

/* thread creation/destruction */
#define EZTRACE_NEW_THREAD          (PTHREAD_CORE_PREFIX | 0x0001)
#define EZTRACE_END_THREAD          (PTHREAD_CORE_PREFIX | 0x0002)
#define EZTRACE_START_THREAD_JOIN   (PTHREAD_CORE_PREFIX | 0x0004)
#define EZTRACE_STOP_THREAD_JOIN    (PTHREAD_CORE_PREFIX | 0x0005)
#define EZTRACE_START_THREAD_CREATE (PTHREAD_CORE_PREFIX | 0x0006)
#define EZTRACE_STOP_THREAD_CREATE  (PTHREAD_CORE_PREFIX | 0x0007)

#define EZTRACE_SIGNAL_RECEIVED     (PTHREAD_CORE_PREFIX | 0xf000)
#define EZTRACE_BACKTRACE_DEPTH     (PTHREAD_CORE_PREFIX | 0xf001)
#define EZTRACE_CALLING_FUNCTION    (PTHREAD_CORE_PREFIX | 0xf002)

#define EZTRACE_START_FLUSH_CODE                           0xfff5
#define EZTRACE_STOP_FLUSH_CODE                            0xfff4

#define EZTRACE_ENTER_EVENT_RED     (USER_CORE_PREFIX | 0x0008)
#define EZTRACE_ENTER_EVENT_YELLOW  (USER_CORE_PREFIX | 0x0010)
#define EZTRACE_ENTER_EVENT_BLUE    (USER_CORE_PREFIX | 0x0011)
#define EZTRACE_ENTER_EVENT_PINK    (USER_CORE_PREFIX | 0x0012)
#define EZTRACE_ENTER_EVENT_GREEN   (USER_CORE_PREFIX | 0x0013)
#define EZTRACE_LEAVE_EVENT         (USER_CORE_PREFIX | 0x0009)

#endif	/*  __EV_CODES_H__ */
