/****************************************************************************
 *																			*
 *  Copyright (c) 1999-2000 FGL Graphics, a division of SONICblue Inc.   	*
 *  All Rights Reserved.													*
 *																			*
 *  This software and its associated documentation contains proprietary,	*
 *  confidential and trade secret information of FGL Graphics,				*
 *  a division of SONICblue Inc.											*
 *																			*
 *  a)  no part may be disclosed, distributed, reproduced, transmitted,		*
 *      transcribed, stored in a retrieval system, adapted or translated	*
 *      in any form or by any means electronic, mechanical, magnetic,		*
 *      optical, chemical, manual or otherwise,								*
 *																			*
 *  and																		*
 *																			*
 *  b)  the recipient is not entitled to discover through reverse			*
 *      engineering or reverse compiling or other such techniques or		*
 *      processes the trade secrets contained therein or in the				*
 *		documentation.														*
 *																			*
 ****************************************************************************/

#ifndef _FIREGL_DRMP_H_
#define _FIREGL_DRMP_H_

#define BLOCK_ALL_SIGNALS_ON_LOCK

#define NULL ((void*)0)

#include "firegl_wrap.h"


#define u8                      __ke_u8
#define u16                     __ke_u16
#define u32                     __ke_u32
#define __u8                      __ke_u8
#define __u16                     __ke_u16
#define __u32                     __ke_u32
#define u64                     __ke_u64
#define size_t                  __ke_size_t
#define off_t                   __ke_off_t

#ifndef ULONG_PTR
typedef unsigned long ULONG_PTR;
#define ULONG_PTR           ULONG_PTR
#endif

#define PCI_FUNC(devfn)		((devfn) & 0x07)



/*****************************************************************************/

typedef struct { volatile unsigned int counter; } atomic_t;
typedef struct { volatile unsigned int pgprot; } pgprot_t;

#define FIREGL_VMA_INFO  1                  // enable /proc/dri/0/vma

#define drm_flags                           __ke_moduleflags
#define HZ                                  __ke_HZ
#define UTS_RELEASE                         __ke_UTS_RELEASE
#define LINUX_VERSION_CODE                  __ke_LINUX_VERSION_CODE

#if 1
// better use real constant defines than a reference to
// a variable - but check for a matach at init stage

#if defined(__i386__)

#define PAGE_SHIFT	12    // this is a fixed value for Linux on i386!
#define PAGE_SIZE	(1UL << PAGE_SHIFT)
#define PAGE_MASK	(~(PAGE_SIZE-1))

#elif defined(__x86_64__)
#define PAGE_SHIFT	12    // this is a fixed value for Linux on i386!
#define PAGE_SIZE	(1UL << PAGE_SHIFT)
#define PAGE_MASK	(~(PAGE_SIZE-1))

#elif defined(__ia64__)
#define PAGE_SHIFT	14    // TODO check whether this is always correct 
#define PAGE_SIZE	(1UL << PAGE_SHIFT)
#define PAGE_MASK	(~(PAGE_SIZE-1))

#else
// this section is todo for, alpha and other architectures
int x = 1/0; // raise compile time fault
#endif

#else // #if 1
// dont use this coding, it wont cope with firegl_sarea.h 
// because the encoded variables are illegal for array size defines.

#define PAGE_SHIFT                          __ke_PAGE_SHIFT
#define PAGE_SIZE                           __ke_PAGE_SIZE
#define PAGE_MASK                           __ke_PAGE_MASK

#endif // #if 1

#define MODVERSIONS_State                   __ke_MODVERSIONS_State
#define SMP_State                           __ke_SMP_State

#define __cmpxchg                           __ke__cmpxchg
#define cmpxchg                             __ke_cmpxchg

//agpgart modules
#define KERN_WARNING                        __KE_KERN_WARNING
#define KERN_ERR                            __KE_KERN_ERR
#define KERN_INFO                           __KE_KERN_INFO

#define PCI_BASE_ADDRESS_MEM_MASK           __KE_PCI_BASE_ADDRESS_MEM_MASK
#define GFP_KERNEL                          __KE_GFP_KERNEL

#define PAGE_KERNEL_NOCACHE                 __KE_PAGE_KERNEL_NOCACHE
#define PAGE_KERNEL                         __KE_PAGE_KERNEL

#define PCI_CAP_LIST_ID			    __KE_PCI_CAP_LIST_ID
#define PCI_CAP_ID_PM			    __KE_PCI_CAP_ID_PM
#define PCI_CAP_ID_AGP			    __KE_PCI_CAP_ID_AGP
#define PCI_CAP_ID_VPD			    __KE_PCI_CAP_ID_VPD
#define PCI_CAP_ID_SLOT_ID		    __KE_PCI_CAP_ID_SLOT_ID
#define PCI_CAP_ID_MSI			    __KE_PCI_CAP_ID_MSI
#define PCI_CAP_ID_CHSWP		    __KE_PCI_CAP_ID_CHSWP
#define PCI_CAP_ID_PCIX			    __KE_PCI_CAP_ID_PCIX
#define PCI_CAP_ID_SHPC			    __KE_PCI_CAP_ID_SHPC
#define PCI_CAP_ID_EXP			    __KE_PCI_CAP_ID_EXP
#define PCI_CAP_ID_MSIX			    __KE_PCI_CAP_ID__MSIX
#define PCI_CAP_LIST_NEXT		    __KE_PCI_CAP_LIST_NEXT
#define PCI_CAP_FLAGS		   	    __KE_PCI_CAP_LIST_FLAGS
#define PCI_CAP_SIZEOF		            __KE_PCI_CAP_LIST_SIZEOF

#define PCI_AGP_STATUS			    __KE_PCI_AGP_STATUS
#define PCI_AGP_COMMAND 		    __KE_PCI_AGP_COMMAND


#define EBUSY					            __ke_error_code(__KE_EBUSY)
#define EINVAL					            __ke_error_code(__KE_EINVAL)
#define EACCES					            __ke_error_code(__KE_EACCES)
#define EFAULT					            __ke_error_code(__KE_EFAULT)
#define EIO						            __ke_error_code(__KE_EIO)
#define EBADSLT					            __ke_error_code(__KE_EBADSLT)
#define ENOMEM					            __ke_error_code(__KE_ENOMEM)
#define EPERM					            __ke_error_code(__KE_EPERM)
#define ENODEV					            __ke_error_code(__KE_ENODEV)
#define EINTR                               __ke_error_code(__KE_EINTR)
#define ERESTARTSYS                         __ke_error_code(__KE_ERESTARTSYS)
#define ELIBBAD                             __ke_error_code(__KE_ELIBBAD)

#define MOD_INC_USE_COUNT		            __ke_mod_inc_use_count()
#define MOD_DEC_USE_COUNT		            __ke_mod_dec_use_count()

#define sema_init(_sem, _val)               __ke_sema_init(_sem, _val)
#define sema_size()                         __ke_sema_size()
#define down(_sem)				            __ke_down(_sem)
#define up(_sem)				            __ke_up(_sem)

#define down_struct_sem(_ndx)               __ke_down_struct_sem(dev->public, _ndx)
#define up_struct_sem(_ndx)                 __ke_up_struct_sem(dev->public, _ndx)
    #define STRUCT_SEM                      0
    #define DEAD_BUFQUEUE_SEM               1 // WARNING: see __KE_MAX_SEMAPHORES


#define atomic_inc(_p)			            __ke_atomic_inc(_p)
#define atomic_dec(_p)			            __ke_atomic_dec(_p)
#define atomic_add(_v, _p)                  __ke_atomic_add(_v, _p)
#define atomic_sub(_v, _p)                  __ke_atomic_sub(_v, _p)
#define atomic_read(_p)			            __ke_atomic_read(_p)
#define atomic_set(_p, _v)		            __ke_atomic_set(_p, _v)

#define spin_lock(_ndx)			            __ke_spin_lock(dev->public, _ndx)
#define spin_unlock(_ndx)		            __ke_spin_unlock(dev->public, _ndx)
    #define COUNT_LOCK				        0
    #define MEMORY_LOCK				        1
    #define PAGE_HEAP_LOCK			        2
    #define MAGIC_LOCK			            3
    #define CTX_LOCK			            4
    #define DRMLOCK_LOCK			        5 // WARNING: see __KE_MAX_SPINLOCKS


#define lock_kernel()	                    __ke_lock_kernel()
#define unlock_kernel()	                    __ke_unlock_kernel()

// wait queues
#define alloc_wait_queue_head_struct()      __ke_alloc_wait_queue_head_struct()
#define free_wait_queue_head_struct(_queue_head) __ke_free_wait_queue_head_struct(_queue_head)

#define alloc_wait_queue_struct()           __ke_alloc_wait_queue_struct()
#define free_wait_queue_struct(_queue)      __ke_free_wait_queue_struct(_queue)

#define add_wait_queue(_queue_head, _entry) __ke_add_wait_queue(_queue_head, _entry)
#define remove_wait_queue(_queue_head, _entry) __ke_remove_wait_queue(_queue_head, _entry)
#define wake_up_interruptible(_queue_head)  __ke_wake_up_interruptible(_queue_head)

// scheduler
#define schedule()                          __ke_schedule()
#define signal_pending()                    __ke_signal_pending()
#define yield()                             __ke_yield()

#define set_current_state_task_interruptible()  __ke_set_current_state_task_interruptible()
#define set_current_state_task_running()        __ke_set_current_state_task_running()
#define configure_sigmask(_pSigMask)            __ke_configure_sigmask(_pSigMask)
#define block_all_signals(_pCallback, _pPriv, _pSigMask) \
            __ke_block_all_signals(_pCallback, _pPriv, _pSigMask)
#define unblock_all_signals()               __ke_unblock_all_signals()
#define capable(_cap)			            __ke_capable(_cap)
#define cap_effective_raise(_cap)			__ke_cap_effective_raise(_cap)
    #define CAP_SYS_ADMIN			            __KE_CAP_SYS_ADMIN
    #define CAP_IPC_LOCK			            __KE_CAP_IPC_LOCK
#define get_cap_effective()                 __ke_get_cap_effective()
#define set_cap_effective(_cap)             __ke_set_cap_effective(_cap)

#define module_parm()                       __ke_module_parm()
#define getpid()                            __ke_getpid()
#define geteuid()                           __ke_geteuid()
#define jiffies()                           __ke_jiffies()
#define udelay(_usec)                       __ke_udelay(_usec)
#define mdelay(_msec)                       __ke_mdelay(_msec)


#if defined(__x86_64__) || defined(__ia64__)
#define pci_alloc_consistent(dev, s, h)		__ke_pci_alloc_consistent(dev, s, h)
#define pci_free_consistent(dev, s, a, h)	__ke_pci_free_consistent(dev, s, a, h)
#endif

#define virt_to_bus(_p)			            __ke_virt_to_bus(_p)
#define virt_to_phys(_p)		            __ke_virt_to_phys(_p)
#define phys_to_virt(_p)		            __ke_phys_to_virt(_p)
#define high_memory()                       __ke_high_memory()
#define getdevice(_dev)                     __ke_getdevice(_dev)
#define ram_available()                     __ke_ram_available()
#define inode_rdev_minor(_inode)            __ke_inode_rdev_minor(_inode)
#define get_file_priv(_f)                   __ke_get_file_priv(_f)
#define set_file_priv(_f, _p)               __ke_set_file_priv(_f, _p)
#define file_excl_open(_f)                  __ke_file_excl_open(_f)
#define file_rw_open(_f)                    __ke_file_rw_open(_f)
#define file_counter(_f)                    __ke_file_counter(_f)

#define set_bit(_nr, _addr)                 __ke_set_bit(_nr, _addr)
#define clear_bit(_nr, _addr)               __ke_clear_bit(_nr, _addr)

#define flush_cache()                       __ke_flush_cache()

#define config_mtrr()                       __ke_config_mtrr()
#define mtrr_add_wc(_o, _n)	                __ke_mtrr_add_wc(_o, _n)
#define mtrr_del(_p, _o, _n)	            __ke_mtrr_del(_p, _o, _n)

#ifdef __x86_64__
#define config_iommu()                       __ke_config_iommu()
#define no_iommu()                           __ke_no_iommu()
#endif

#define check_pci(_b, _d, _f, _v, _pd, _pi)         __ke_check_pci(_b, _d, _f, _v, _pd, _pi)
#define pci_get_irq(_dev, _pi)                      __ke_pci_get_irq(_dev, _pi)
#define pci_find_device(_vendor, _device, _from)    __ke_pci_find_device(_vendor, _device, _from)
#define pci_read_config_byte(_dev, _where, _val)    __ke_pci_read_config_byte(_dev, _where, _val)
#define pci_read_config_word(_dev, _where, _val)    __ke_pci_read_config_word(_dev, _where, _val)
#define pci_read_config_dword(_dev, _where, _val)   __ke_pci_read_config_dword(_dev, _where, _val)
#define pci_write_config_byte(_dev, _where, _val)   __ke_pci_write_config_byte(_dev, _where, _val)
#define pci_write_config_word(_dev, _where, _val)   __ke_pci_write_config_word(_dev, _where, _val)
#define pci_write_config_dword(_dev, _where, _val)  __ke_pci_write_config_dword(_dev, _where, _val)
#define pci_enable_device(_dev)                     __ke_pci_enable_device(_dev)
#define pci_find_capability(_dev, _val)		    __ke_pci_find_capability(_dev, _val)

#define pci_get_drvdata		            __ke_pci_get_drvdata
#define pci_set_drvdata		            __ke_pci_set_drvdata
#define pci_find_class		            __ke_pci_find_class


#define outb(_value, _port)                         __ke_outb(_value, _port)
#define outw(_value, _port)                         __ke_outw(_value, _port)
#define outl(_value, _port)                         __ke_outl(_value, _port)
#define inb(_port)                                  __ke_inb(_port)
#define inw(_port)                                  __ke_inw(_port)
#define inl(_port)                                  __ke_inl(_port)

#define vma_file_priv(_vma)					__ke_vma_file_priv(_vma)
#define vm_start(_vma)                      __ke_vm_start(_vma)
#define vm_end(_vma)                        __ke_vm_end(_vma)
#define vm_flags_str(_vma, _s)              __ke_vm_flags_str(_vma, _s)
#define vm_page_prot_str(_vma, _s)          __ke_vm_page_prot_str(_vma, _s)
#define vm_phys_addr_str(_vma, _s, _l, _p)  __ke_vm_phys_addr_str(_vma, _s, _l, _p)

#define vm_map(_f, _vma, _t, _ro)           __ke_vm_map(_f, _vma, _t, _ro)
    #define VM_ADPT                             __KE_ADPT
    #define VM_SHM                              __KE_SHM
    #define VM_CTX                              __KE_CTX
    #define VM_PCI_BQS                          __KE_PCI_BQS
    #define VM_AGP_BQS                          __KE_AGP_BQS
    #define VM_AGP                              __KE_AGP
    #define VM_SG                               __KE_SG

#define memset(_p, _v, _n)		            __ke_memset(_p, _v, _n)
#define memcpy(_d, _s, _n)                  __ke_memcpy(_d, _s, _n)
#define strlen(_s)						    __ke_strlen(_s)
#define strcpy(_d, _s)						__ke_strcpy(_d, _s)
#define strncpy(_d, _s, _n)					__ke_strncpy(_d, _s, _n)
#define strcmp(_s1, _s2)                    __ke_strcmp(_s1, _s2)
#define strncmp(_s1, _s2, _n)               __ke_strncmp(_s1, _s2, _n)
#define sprintf                             __ke_sprintf
#define kmalloc(_n)                         __ke_malloc(_n)
#define kfree_s(_p, _n)                     __ke_free_s(_p, _n)
#define vmalloc(_n)                         __ke_vmalloc(_n)
#define vmalloc_32(_n)                      __ke_vmalloc_32(_n)
#define vfree(_p)                           __ke_vfree(_p)
#define get_free_page()                     __ke_get_free_page()
#define get_free_pages(_n)                  __ke_get_free_pages(_n)
#define free_page(_p)                       __ke_free_page(_p)
#define free_pages(_p, _n)                  __ke_free_pages(_p, _n)
#define get_page(_p)                        __ke_get_page(_p)
#define put_page(_p)                        __ke_put_page(_p)
#define mem_map_reserve(_p)                 __ke_mem_map_reserve(_p)
#define mem_map_unreserve(_p)               __ke_mem_map_unreserve(_p)
#define virt_reserve(_p)                    __ke_virt_reserve(_p)
#define lock_page(_p)                       __ke_lock_page(_p)
#define virt_unreserve(_p)                  __ke_virt_unreserve(_p)
#define unlock_page(_p)                     __ke_unlock_page(_p)
#define PageCompound(_p)                    __ke_PageCompound(_p)
#define ioremap(_o, _n)                     __ke_ioremap(_o, _n)
#define ioremap_nocache(_o, _n)             __ke_ioremap_nocache(_o, _n)
#define iounmap(_p)                         __ke_iounmap(_p)
#define verify_read_access(_p, _n)          __ke_verify_read_access(_p, _n)
#define verify_write_access(_p, _n)         __ke_verify_write_access(_p, _n)
#define init_mm()                           __ke_init_mm()
#define current_mm()                        __ke_current_mm()
#define get_vm_phys_addr(_mm, _p)           __ke_get_vm_phys_addr(_mm, _p)
#define get_vm_phys_addr_list(_mm, _p, _pg) __ke_get_vm_phys_addr_list(_mm, _p, _pg)
#define get_vmptr(_m)						__ke_get_vmptr( _m )

#define agp_try_unsupported                     __ke_agp_try_unsupported
#define agp_available(_u)                       __ke_agp_available(_u)
#define agp_uninit()                            __ke_agp_uninit()
#ifdef FGL
#define agp_allocate_memory_phys_list(_n, _t, _l)   __ke_agp_allocate_memory_phys_list(_n, _t, _l)
#endif /* FGL */
#define agp_free_memory(_h)                     __ke_agp_free_memory(_h)
#define agp_allocate_memory(_n, _t)             __ke_agp_allocate_memory(_n, _t)
#define agp_bind_memory(_h, _o)                 __ke_agp_bind_memory(_h, _o)
#define agp_unbind_memory(_h)                   __ke_agp_unbind_memory(_h)
#define agp_enable(_m)                          __ke_agp_enable(_m)
#define agp_acquire()                           __ke_agp_acquire()
#define agp_release()                           __ke_agp_release()
#define agp_read_caps_registers(_d, _p)         __ke_read_agp_caps_registers(_d, _p)
#define agp_copy_info(_p)                       __ke_agp_copy_info(_p)
#define agp_memory_handle(_h)                   __ke_agp_memory_handle(_h)
#define agp_memory_page_count(_h)               __ke_agp_memory_page_count(_h)
                                                
#define copy_to_user(to, from, n)               __ke_copy_to_user(to, from, n)
#define copy_from_user(to, from, n)             __ke_copy_from_user(to, from, n)
#define verify_area(type, addr, size)           __ke_verify_area(type, addr, size)

#define enable_irq(_irq)                        __ke_enable_irq(_irq)
#define disable_irq(_irq)                       __ke_disable_irq(_irq)
#define request_irq(_irq,_handler,_name,_id)    __ke_request_irq(_irq, _handler, _name, _id)
#define free_irq(_irq,_id)                      __ke_free_irq(_irq, _id)

#define has_PSE()                               __ke_has_PSE()
#define amd_adv_spec_cache_feature()            __ke_amd_adv_spec_cache_feature()
#define is_athlon()							    __ke_is_athlon()
#define smp_call_function(_f)                   __ke_smp_call_function(_f)
#define smp_processor_id()					    __ke_smp_processor_id()

#define pci_map_single(_p, _b, _s, _d)          __ke_pci_map_single(_p, _b, _s, _d)
#define pci_unmap_single(_p, _a, _s, _d)        __ke_pci_unmap_single(_p, _a, _s, _d)
#define pci_map_page(_p, _b, _o, _s, _d)        __ke_pci_map_page(_p, _b, _o, _s, _d)
#define pci_unmap_page(_p, _a, _s, _d)          __ke_pci_unmap_page(_p, _a, _s, _d)
#define PCI_DMA_TODEVICE                        __ke_PCI_DMA_TODEVICE

#define log2(_p)                                __ke_log2(_p)

#define find_first_zero_bit			__ke_find_first_zero_bit

#define copy_to_user_ret(to, from, n, retval)           \
    do                                                  \
    {                                                   \
	    if (copy_to_user(to, from, n))					\
		    return retval;								\
    } while (0)

#define copy_from_user_ret(to, from, n, retval)         \
    do                                                  \
    {                                                   \
	    if (copy_from_user(to,from,n))					\
		    return retval;								\
    } while (0)

#define sys_mlock(_o, _n)                   __ke_sys_mlock(_o, _n)
#define sys_munlock(_o, _n)                 __ke_sys_munlock(_o, _n)

#define sys_modify_ldt(_f, _p, _bc)         __ke_sys_modify_ldt(_f, _p, _bc)

#define VM_OFFSET(_vma)			            __ke_vm_offset(_vma)

#if 0 /* TODO is this needed*/
#define readb			            __ke_readb
#define readw                               __ke_readw
#define readl                               __ke_readl

#define writeb			            __ke_writeb
#define writew                              __ke_writew
#define writel                              __ke_writel
#endif
#define readb(addr) (*(volatile unsigned char *) (addr))
#define readw(addr) (*(volatile unsigned short *) (addr))
#define readl(addr) (*(volatile unsigned int *) (addr))


#define writeb(b,addr)(*(volatile unsigned char *) (addr) = (b))
#define writew(b,addr)(*(volatile unsigned short *) (addr) = (b))
#define writel(b,addr)(*(volatile unsigned int *) (addr) = (b))




#define device_t                            __ke_device_t
#define pci_dev_t                           __ke_pci_dev_t
#define wait_queue_head_t                   __ke_wait_queue_head_t
#define wait_queue_t                        __ke_wait_queue_t
#define agp_kern_info_t                     __ke_agp_kern_info_t
#define read_proc_t                         __ke_read_proc_t
#define sigset_t                            __ke_sigset_t
#define list_head_t			    __ke_list_head_t
#define resource_t			    __ke_resource_t
#define pci_device_id_t                     __ke_pci_device_id_t
#define pci_driver_t                        __ke_pci_driver_t
#define device_driver_t			    __ke_device_driver_t
#define pci_dynids_t                        __ke_pci_dynids_t
#define num_phys_pages		            __ke_numphys_pages

#define cpu_to_le32(_u)                     __ke_cpu_to_le32(_u)
#define cpu_to_le64(_u)                     __ke_cpu_to_le64(_u)
#define le32_to_cpu(_u)                     __ke_le32_to_cpu(_u)

#define register_ioctl32_conversion(_u, _f) __ke_register_ioctl32_conversion(_u, _f)
#define unregister_ioctl32_conversion(_u)   __ke_unregister_ioctl32_conversion(_u)

#define sys_ioctl(_fd, _cmd, _arg)          __ke_sys_ioctl(_fd, _cmd, _arg)

#define remap_pfn_range(_v,_f,_p,_s,_pr)    __ke_remap_pfn_range(_v,_f,_p,_s,_pr)
#define page_address(pt)                    __ke_page_address(pt)

#define max_t 				    __ke_max_t
#define min_t 				    __ke_min_t
#define THIS_MODULE			    __KE_THIS_MODULE

#define printk				    __ke_printk

#define AGPGART_MINOR 175


#endif /* _FIREGL_DRMP_H_ */
