%% common settings

image {
   resolution 800 600
   aa 0 2
   filter mitchell
}

%% camera

camera {
   type pinhole
   eye    2.11420178413 -2.16678905487 2.85471820831
   target 1.61420178413 -1.66678917408 2.14761137962
   up -0.500000119209 0.5 0.70710670948
   fov 49.1343426412
   aspect 1.333333
}


%% light sources

light {
   type point
   color 1 1 1
   power 100
   p 4.07624530792 1.00545394421 5.90386199951
}

light {
   type meshlight
   name "meshlight"
   emit 1 1 1
   radiance 15
   samples 16
   points 4
      0.999999940395 -1.40001678467 2.67206859589
      0.999999940395 -2.93210554123 1.38649308681
      -1 -2.93210530281 1.38649332523
      -0.999999642372 -1.40001630783 2.6720688343
   triangles 2
      0 1 2
      0 2 3
}


%% geometry

object {
   shader "boxes"
   type generic-mesh
   name "Cube.001"
   points 96
      0.138345018029 -0.227277860045 0
      0.221101045609 -0.428005725145 0
      0.0203731656075 -0.510761737823 0
      -0.0623828358948 -0.31003382802 0
      0.138345077634 -0.227277889848 0.228717163205
      -0.062382850796 -0.310033887625 0.228717163205
      0.0203731264919 -0.510761737823 0.228717163205
      0.221101000905 -0.428005814552 0.228717163205
      0.143706768751 -0.225067317486 0.00579956267029
      0.143706843257 -0.225067347288 0.222917601466
      0.226462751627 -0.425795257092 0.222917601466
      0.22646279633 -0.425795167685 0.00579956267029
      0.223311588168 -0.433367490768 0.00579956267029
      0.223311543465 -0.433367580175 0.222917601466
      0.0225836634636 -0.516123473644 0.222917601466
      0.0225836969912 -0.516123473644 0.00579956267029
      0.0150113971904 -0.512972295284 0.00579956267029
      0.0150113645941 -0.512972295284 0.222917601466
      -0.0677446126938 -0.312244415283 0.222917601466
      -0.067744590342 -0.312244385481 0.00579956267029
      0.136134535074 -0.221916139126 0.222917601466
      0.13613447547 -0.221916109324 0.00579956267029
      -0.0645933821797 -0.304672092199 0.00579956267029
      -0.0645933896303 -0.304672122002 0.222917601466
      0.140633285046 -0.226334452629 0.00102522643283
      0.14275893569 -0.225458100438 0.0033244471997
      0.225514963269 -0.426185965538 0.0033244471997
      0.223389312625 -0.427062302828 0.00102522643283
      0.0213165674359 -0.513050019741 0.00102522643283
      0.222044438124 -0.430294007063 0.00102522643283
      0.222920805216 -0.432419657707 0.0033244471997
      0.0221929308027 -0.515175640583 0.0033244471997
      -0.0646711066365 -0.310977250338 0.00102522643283
      -0.0667967572808 -0.31185361743 0.0033244471997
      0.0159592293203 -0.512581527233 0.0033244471997
      0.0180848892778 -0.511705160141 0.00102522643283
      -0.0633262395859 -0.307745575905 0.00102522643283
      -0.064202606678 -0.305619925261 0.0033244471997
      0.136525243521 -0.222863942385 0.0033244471997
      0.137401610613 -0.224989593029 0.00102522643283
      0.137401670218 -0.224989622831 0.227691933513
      0.136525303125 -0.222863972187 0.225392714143
      -0.0642026215792 -0.305619955063 0.225392714143
      -0.063326254487 -0.307745605707 0.227691933513
      -0.0646711215377 -0.310977309942 0.227691933513
      -0.066796772182 -0.311853677034 0.225392714143
      0.0159591976553 -0.512581527233 0.225392714143
      0.0180848501623 -0.511705160141 0.227691933513
      0.0213165264577 -0.513050019741 0.227691933513
      0.0221928916872 -0.515175640583 0.225392714143
      0.222920775414 -0.432419747114 0.225392714143
      0.222044408321 -0.430294066668 0.227691933513
      0.14063334465 -0.226334482431 0.227691933513
      0.223389267921 -0.427062392235 0.227691933513
      0.225514918566 -0.426186025143 0.225392714143
      0.142759010196 -0.225458115339 0.225392714143
      0.141815528274 -0.223169833422 0.00579956267029
      0.141815602779 -0.223169848323 0.222917601466
      0.138813585043 -0.221920564771 0.222917601466
      0.138813510537 -0.221920534968 0.00579956267029
      0.226458325982 -0.42847430706 0.222917601466
      0.226458370686 -0.428474217653 0.00579956267029
      0.225209072232 -0.43147623539 0.00579956267029
      0.22520904243 -0.431476324797 0.222917601466
      0.0199046544731 -0.516119062901 0.00579956267029
      0.0199046209455 -0.516119062901 0.222917601466
      0.0169026050717 -0.514869749546 0.222917601466
      0.0169026367366 -0.514869809151 0.00579956267029
      -0.0677401870489 -0.309565395117 0.222917601466
      -0.0677401646972 -0.309565335512 0.00579956267029
      -0.066490881145 -0.306563317776 0.00579956267029
      -0.0664908885956 -0.30656337738 0.222917601466
      0.139776051044 -0.223839104176 0.00236766319722
      0.140513986349 -0.223534867167 0.00316583854146
      0.139471814036 -0.223101168871 0.00316583854146
      0.224539801478 -0.429436773062 0.00236766319722
      0.224844038486 -0.430174678564 0.00316583854146
      0.225277736783 -0.429132521152 0.00316583854146
      0.0189421158284 -0.514200508595 0.00236766319722
      0.0192463472486 -0.514938414097 0.00316584529355
      0.0182041879743 -0.514504730701 0.00316584529355
      -0.0658216029406 -0.308602809906 0.00236766319722
      -0.0661258324981 -0.307864874601 0.00316584529355
      -0.066559523344 -0.308907032013 0.00316584529355
      0.13977612555 -0.223839119077 0.226349502802
      0.139471888542 -0.223101198673 0.225551322103
      0.140514045954 -0.22353489697 0.225551322103
      -0.0658216103911 -0.308602839708 0.226349502802
      -0.0661258473992 -0.307864904404 0.225551322103
      -0.0665595382452 -0.308907091618 0.225551322103
      0.0189420767128 -0.514200508595 0.226349502802
      0.0182041563094 -0.514504730701 0.225551322103
      0.0192463062704 -0.514938414097 0.225551322103
      0.224539771676 -0.429436862469 0.226349502802
      0.224843993783 -0.430174767971 0.225551322103
      0.22527769208 -0.429132610559 0.225551322103
   triangles 188
      0 1 2
      0 2 3
      4 5 6
      4 6 7
      8 9 10
      8 10 11
      12 13 14
      12 14 15
      16 17 18
      16 18 19
      20 21 22
      20 22 23
      24 25 26
      24 26 27
      28 29 30
      28 30 31
      32 35 34
      32 34 33
      36 37 38
      36 38 39
      40 41 42
      40 42 43
      44 45 46
      44 46 47
      48 49 50
      48 50 51
      52 53 54
      52 54 55
      56 59 58
      56 58 57
      60 63 62
      60 62 61
      64 65 66
      64 66 67
      68 71 70
      68 70 69
      72 74 73
      75 77 76
      78 79 80
      81 83 82
      84 86 85
      87 88 89
      90 91 92
      93 94 95
      0 24 27
      0 27 1
      1 29 28
      1 28 2
      3 2 35
      3 35 32
      0 3 36
      0 36 39
      5 4 40
      5 40 43
      6 5 44
      6 44 47
      7 6 48
      7 48 51
      7 53 52
      7 52 4
      8 56 57
      8 57 9
      10 9 55
      10 55 54
      10 60 61
      10 61 11
      8 11 26
      8 26 25
      13 12 62
      13 62 63
      13 50 49
      13 49 14
      15 14 65
      15 65 64
      15 31 30
      15 30 12
      17 16 67
      17 67 66
      17 46 45
      17 45 18
      18 68 69
      18 69 19
      16 19 33
      16 33 34
      20 58 59
      20 59 21
      21 38 37
      21 37 22
      23 22 70
      23 70 71
      20 23 42
      20 42 41
      24 72 73
      24 73 25
      27 26 77
      27 77 75
      30 29 75
      30 75 76
      31 79 78
      31 78 28
      33 83 81
      33 81 32
      34 35 78
      34 78 80
      36 81 82
      36 82 37
      39 38 74
      39 74 72
      40 84 85
      40 85 41
      42 88 87
      42 87 43
      44 87 89
      44 89 45
      47 46 91
      47 91 90
      49 48 90
      49 90 92
      51 50 94
      51 94 93
      54 53 93
      54 93 95
      55 86 84
      55 84 52
      58 85 86
      58 86 57
      56 73 74
      56 74 59
      62 76 77
      62 77 61
      60 95 94
      60 94 63
      66 65 92
      66 92 91
      64 67 80
      64 80 79
      69 70 82
      69 82 83
      71 68 89
      71 89 88
      0 39 72
      0 72 24
      1 27 75
      1 75 29
      2 28 78
      2 78 35
      3 32 81
      3 81 36
      4 52 84
      4 84 40
      5 43 87
      5 87 44
      6 47 90
      6 90 48
      7 51 93
      7 93 53
      8 25 73
      8 73 56
      9 57 86
      9 86 55
      10 54 95
      10 95 60
      11 61 77
      11 77 26
      12 30 76
      12 76 62
      13 63 94
      13 94 50
      14 49 92
      14 92 65
      15 64 79
      15 79 31
      16 34 80
      16 80 67
      17 66 91
      17 91 46
      18 45 89
      18 89 68
      19 69 83
      19 83 33
      20 41 85
      20 85 58
      21 59 74
      21 74 38
      22 37 82
      22 82 70
      23 71 88
      23 88 42
   normals vertex
      0.107654057443 0.25869050622 -0.959942698479
      0.258690476418 -0.107654057443 -0.959942579269
      -0.107654057443 -0.25869050622 -0.959942698479
      -0.258690476418 0.107654057443 -0.959942579269
      0.107654057443 0.25869050622 0.959942698479
      -0.258690476418 0.107654057443 0.959942579269
      -0.107654057443 -0.25869050622 0.959942698479
      0.258690476418 -0.107654057443 0.959942579269
      0.811958730221 0.549061000347 -0.198128953576
      0.811958730221 0.549061000347 0.198128953576
      0.962995111942 0.182716459036 0.198128953576
      0.962995111942 0.182716459036 -0.198128953576
      0.549061059952 -0.811958730221 -0.198128953576
      0.549061059952 -0.811958730221 0.198128953576
      0.182716488838 -0.962995111942 0.198128953576
      0.182716488838 -0.962995111942 -0.198128953576
      -0.811958730221 -0.549061000347 -0.198128953576
      -0.811958730221 -0.549061000347 0.198128953576
      -0.962995111942 -0.182716459036 0.198128953576
      -0.962995111942 -0.182716459036 -0.198128953576
      -0.182716488838 0.962995111942 0.198128953576
      -0.182716488838 0.962995111942 -0.198128953576
      -0.549061059952 0.811958730221 -0.198128953576
      -0.549061059952 0.811958730221 0.198128953576
      0.444815903902 0.374091744423 -0.813753128052
      0.685122609138 0.473165333271 -0.553824603558
      0.81952393055 0.14716988802 -0.553824603558
      0.579217255116 0.0480963252485 -0.813753187656
      0.0480963438749 -0.579217255116 -0.813753187656
      0.374091744423 -0.444815903902 -0.813753128052
      0.473165392876 -0.685122609138 -0.553824603558
      0.147169917822 -0.81952393055 -0.553824603558
      -0.579217255116 -0.0480963252485 -0.813753187656
      -0.81952393055 -0.14716988802 -0.553824603558
      -0.685122609138 -0.473165333271 -0.553824603558
      -0.444815903902 -0.374091744423 -0.813753128052
      -0.374091744423 0.444815903902 -0.813753128052
      -0.473165392876 0.685122609138 -0.553824603558
      -0.147169917822 0.81952393055 -0.553824603558
      -0.0480963438749 0.579217255116 -0.813753187656
      -0.0480963438749 0.579217255116 0.813753187656
      -0.147169917822 0.81952393055 0.553824603558
      -0.473165392876 0.685122609138 0.553824603558
      -0.374091744423 0.444815903902 0.813753128052
      -0.579217255116 -0.0480963252485 0.813753187656
      -0.81952393055 -0.14716988802 0.553824603558
      -0.685122609138 -0.473165333271 0.553824603558
      -0.444815903902 -0.374091744423 0.813753128052
      0.0480963438749 -0.579217255116 0.813753187656
      0.147169917822 -0.81952393055 0.553824603558
      0.473165392876 -0.685122609138 0.553824603558
      0.374091744423 -0.444815903902 0.813753128052
      0.444815903902 0.374091744423 0.813753128052
      0.579217255116 0.0480963252485 0.813753187656
      0.81952393055 0.14716988802 0.553824603558
      0.685122609138 0.473165333271 0.553824603558
      0.541229188442 0.822184205055 -0.176307082176
      0.541229188442 0.822184205055 0.176307082176
      0.201848968863 0.963417291641 0.176307082176
      0.201848968863 0.963417291641 -0.176307082176
      0.963417291641 -0.201848953962 0.176307052374
      0.963417291641 -0.201848953962 -0.176307052374
      0.822184205055 -0.541229188442 -0.176307082176
      0.822184205055 -0.541229188442 0.176307082176
      -0.201848968863 -0.963417291641 -0.176307082176
      -0.201848968863 -0.963417291641 0.176307082176
      -0.541229188442 -0.822184205055 0.176307082176
      -0.541229188442 -0.822184205055 -0.176307082176
      -0.963417291641 0.201848953962 0.176307052374
      -0.963417291641 0.201848953962 -0.176307052374
      -0.822184205055 0.541229188442 -0.176307082176
      -0.822184205055 0.541229188442 0.176307082176
      0.269953370094 0.648692369461 -0.711564004421
      0.468478769064 0.730540394783 -0.49682828784
      0.188105359674 0.847217857838 -0.49682828784
      0.648692369461 -0.269953370094 -0.711564004421
      0.730540394783 -0.468478828669 -0.49682828784
      0.847217857838 -0.188105374575 -0.49682828784
      -0.269953370094 -0.648692369461 -0.711564004421
      -0.188105359674 -0.847217857838 -0.49682828784
      -0.468478769064 -0.730540394783 -0.49682828784
      -0.648692369461 0.269953370094 -0.711564004421
      -0.730540394783 0.468478828669 -0.49682828784
      -0.847217857838 0.188105374575 -0.49682828784
      0.269953370094 0.648692369461 0.711564004421
      0.188105359674 0.847217857838 0.49682828784
      0.468478769064 0.730540394783 0.49682828784
      -0.648692369461 0.269953370094 0.711564004421
      -0.730540394783 0.468478828669 0.49682828784
      -0.847217857838 0.188105374575 0.49682828784
      -0.269953370094 -0.648692369461 0.711564004421
      -0.468478769064 -0.730540394783 0.49682828784
      -0.188105359674 -0.847217857838 0.49682828784
      0.648692369461 -0.269953370094 0.711564004421
      0.730540394783 -0.468478828669 0.49682828784
      0.847217857838 -0.188105374575 0.49682828784
   uvs none
}


object {
   shader "ground"
   type generic-mesh
   name "Plane"
   points 4
      1 0.999999940395 0
      1 -1 0
      -1.00000011921 -0.999999821186 0
      -0.999999642372 1.00000035763 0
   triangles 2
      0 3 2
      0 2 1
   normals none
   uvs none
}


object {
   shader "boxes"
   type generic-mesh
   name "Cube"
   points 96
      0.18985722959 0.18985722959 0
      0.18985722959 -0.18985722959 0
      -0.18985722959 -0.189857199788 0
      -0.189857169986 0.189857289195 0
      0.189857304096 0.189857125282 0.40000000596
      -0.18985722959 0.18985722959 0.40000000596
      -0.189857289195 -0.189857169986 0.40000000596
      0.189857110381 -0.189857333899 0.40000000596
      0.20000000298 0.189857214689 0.0101427678019
      0.200000092387 0.189857125282 0.389857262373
      0.19999986887 -0.1898573488 0.389857262373
      0.20000000298 -0.18985722959 0.0101427678019
      0.18985722959 -0.20000000298 0.0101427678019
      0.189857110381 -0.20000012219 0.389857262373
      -0.189857304096 -0.199999928474 0.389857262373
      -0.189857259393 -0.199999973178 0.0101427678019
      -0.200000032783 -0.189857199788 0.0101427678019
      -0.200000077486 -0.189857169986 0.389857262373
      -0.199999988079 0.18985722959 0.389857262373
      -0.199999928474 0.189857304096 0.0101427678019
      0.189857333899 0.199999898672 0.389857262373
      0.18985722959 0.199999988079 0.0101427678019
      -0.189857169986 0.200000077486 0.0101427678019
      -0.189857214689 0.20000000298 0.389857262373
      0.19418592751 0.189857214689 0.00179300305899
      0.198207005858 0.189857214689 0.00581407546997
      0.198207005858 -0.18985722959 0.00581407546997
      0.19418592751 -0.18985722959 0.00179300305899
      -0.189857244492 -0.194185897708 0.00179300305899
      0.18985722959 -0.19418592751 0.00179300305899
      0.18985722959 -0.198207005858 0.00581407546997
      -0.189857244492 -0.198206961155 0.00581407546997
      -0.194185853004 0.189857289195 0.00179300305899
      -0.198206931353 0.189857289195 0.00581407546997
      -0.19820702076 -0.189857199788 0.00581407546997
      -0.194185942411 -0.189857199788 0.00179300305899
      -0.189857169986 0.194185987115 0.00179300305899
      -0.189857169986 0.198207065463 0.00581407546997
      0.18985722959 0.198206990957 0.00581407546997
      0.18985722959 0.194185912609 0.00179300305899
      0.189857318997 0.194185823202 0.398207008839
      0.189857318997 0.198206886649 0.39418593049
      -0.189857214689 0.198207005858 0.39418593049
      -0.189857214689 0.194185912609 0.398207008839
      -0.194185912609 0.18985722959 0.398207008839
      -0.198206990957 0.18985722959 0.39418593049
      -0.198207065463 -0.189857169986 0.39418593049
      -0.194186002016 -0.189857169986 0.398207008839
      -0.189857304096 -0.194185853004 0.398207008839
      -0.189857304096 -0.198206931353 0.39418593049
      0.189857110381 -0.198207125068 0.39418593049
      0.189857110381 -0.194186031818 0.398207008839
      0.194186016917 0.189857125282 0.398207008839
      0.1941857934 -0.1898573488 0.398207008839
      0.198206871748 -0.1898573488 0.39418593049
      0.198207095265 0.189857125282 0.39418593049
      0.198207005858 0.194185897708 0.0101427678019
      0.198207095265 0.194185823202 0.389857262373
      0.194186016917 0.198206886649 0.389857262373
      0.19418592751 0.198206990957 0.0101427678019
      0.198206871748 -0.194186031818 0.389857262373
      0.198207005858 -0.19418592751 0.0101427678019
      0.194185912609 -0.198207005858 0.0101427678019
      0.1941857934 -0.198207125068 0.389857262373
      -0.194185957313 -0.198206961155 0.0101427678019
      -0.194186002016 -0.198206931353 0.389857262373
      -0.198207065463 -0.194185853004 0.389857262373
      -0.19820702076 -0.194185897708 0.0101427678019
      -0.198206990957 0.19418592751 0.389857262373
      -0.198206931353 0.194186002016 0.0101427678019
      -0.194185853004 0.198207065463 0.0101427678019
      -0.194185897708 0.198207005858 0.389857262373
      0.194463297725 0.194463297725 0.00414077052847
      0.195859238505 0.194463297725 0.00553668756038
      0.194463297725 0.195859223604 0.00553668756038
      0.194463297725 -0.194463297725 0.00414077052847
      0.194463297725 -0.195859238505 0.00553668756038
      0.195859238505 -0.194463297725 0.00553668756038
      -0.194463327527 -0.194463282824 0.00414077052847
      -0.194463327527 -0.195859193802 0.00553669920191
      -0.195859253407 -0.194463282824 0.00553669920191
      -0.19446323812 0.194463372231 0.00414077052847
      -0.19446323812 0.19585929811 0.00553669920191
      -0.195859164 0.194463372231 0.00553669920191
      0.194463402033 0.194463208318 0.395859241486
      0.194463402033 0.195859119296 0.394463300705
      0.195859327912 0.194463208318 0.394463300705
      -0.194463297725 0.194463297725 0.395859241486
      -0.194463297725 0.195859238505 0.394463300705
      -0.195859223604 0.194463297725 0.394463300705
      -0.194463387132 -0.19446323812 0.395859241486
      -0.19585929811 -0.19446323812 0.394463300705
      -0.194463387132 -0.195859164 0.394463300705
      0.194463178515 -0.194463416934 0.395859241486
      0.194463178515 -0.195859342813 0.394463300705
      0.195859104395 -0.194463416934 0.394463300705
   triangles 188
      0 1 2
      0 2 3
      4 5 6
      4 6 7
      8 9 10
      8 10 11
      12 13 14
      12 14 15
      16 17 18
      16 18 19
      20 21 22
      20 22 23
      24 25 26
      24 26 27
      28 29 30
      28 30 31
      32 35 34
      32 34 33
      36 37 38
      36 38 39
      40 41 42
      40 42 43
      44 45 46
      44 46 47
      48 49 50
      48 50 51
      52 53 54
      52 54 55
      56 59 58
      56 58 57
      60 63 62
      60 62 61
      64 65 66
      64 66 67
      68 71 70
      68 70 69
      72 74 73
      75 77 76
      78 79 80
      81 83 82
      84 86 85
      87 88 89
      90 91 92
      93 94 95
      0 24 27
      0 27 1
      1 29 28
      1 28 2
      3 2 35
      3 35 32
      0 3 36
      0 36 39
      5 4 40
      5 40 43
      6 5 44
      6 44 47
      7 6 48
      7 48 51
      7 53 52
      7 52 4
      8 56 57
      8 57 9
      10 9 55
      10 55 54
      10 60 61
      10 61 11
      8 11 26
      8 26 25
      13 12 62
      13 62 63
      13 50 49
      13 49 14
      15 14 65
      15 65 64
      15 31 30
      15 30 12
      17 16 67
      17 67 66
      17 46 45
      17 45 18
      18 68 69
      18 69 19
      16 19 33
      16 33 34
      20 58 59
      20 59 21
      21 38 37
      21 37 22
      23 22 70
      23 70 71
      20 23 42
      20 42 41
      24 72 73
      24 73 25
      27 26 77
      27 77 75
      30 29 75
      30 75 76
      31 79 78
      31 78 28
      33 83 81
      33 81 32
      34 35 78
      34 78 80
      36 81 82
      36 82 37
      39 38 74
      39 74 72
      40 84 85
      40 85 41
      42 88 87
      42 87 43
      44 87 89
      44 89 45
      47 46 91
      47 91 90
      49 48 90
      49 90 92
      51 50 94
      51 94 93
      54 53 93
      54 93 95
      55 86 84
      55 84 52
      58 85 86
      58 86 57
      56 73 74
      56 74 59
      62 76 77
      62 77 61
      60 95 94
      60 94 63
      66 65 92
      66 92 91
      64 67 80
      64 80 79
      69 70 82
      69 82 83
      71 68 89
      71 89 88
      0 39 72
      0 72 24
      1 27 75
      1 75 29
      2 28 78
      2 78 35
      3 32 81
      3 81 36
      4 52 84
      4 84 40
      5 43 87
      5 87 44
      6 47 90
      6 90 48
      7 51 93
      7 93 53
      8 25 73
      8 73 56
      9 57 86
      9 86 55
      10 54 95
      10 95 60
      11 61 77
      11 77 26
      12 30 76
      12 76 62
      13 63 94
      13 94 50
      14 49 92
      14 92 65
      15 64 79
      15 79 31
      16 34 80
      16 80 67
      17 66 91
      17 91 46
      18 45 89
      18 89 68
      19 69 83
      19 83 33
      20 41 85
      20 85 58
      21 59 74
      21 74 38
      22 37 82
      22 82 70
      23 71 88
      23 88 42
   normals vertex
      0.198128953576 0.198128953576 -0.959942638874
      0.198128953576 -0.198128953576 -0.959942638874
      -0.198128953576 -0.198128953576 -0.959942638874
      -0.198128953576 0.198128953576 -0.959942638874
      0.198128953576 0.198128953576 0.959942638874
      -0.198128953576 0.198128953576 0.959942638874
      -0.198128953576 -0.198128953576 0.959942638874
      0.198128953576 -0.198128953576 0.959942638874
      0.959942638874 0.198128953576 -0.198128953576
      0.959942638874 0.198128953576 0.198128953576
      0.959942638874 -0.198128953576 0.198128953576
      0.959942638874 -0.198128953576 -0.198128953576
      0.198128953576 -0.959942638874 -0.198128953576
      0.198128953576 -0.959942638874 0.198128953576
      -0.198128953576 -0.959942638874 0.198128953576
      -0.198128953576 -0.959942638874 -0.198128953576
      -0.959942638874 -0.198128953576 -0.198128953576
      -0.959942638874 -0.198128953576 0.198128953576
      -0.959942638874 0.198128953576 0.198128953576
      -0.959942638874 0.198128953576 -0.198128953576
      0.198128953576 0.959942638874 0.198128953576
      0.198128953576 0.959942638874 -0.198128953576
      -0.198128953576 0.959942638874 -0.198128953576
      -0.198128953576 0.959942638874 0.198128953576
      0.553824543953 0.176307052374 -0.813753128052
      0.813753128052 0.176307052374 -0.553824543953
      0.813753128052 -0.176307052374 -0.553824543953
      0.553824543953 -0.176307052374 -0.813753128052
      -0.176307052374 -0.553824543953 -0.813753128052
      0.176307052374 -0.553824543953 -0.813753128052
      0.176307052374 -0.813753128052 -0.553824543953
      -0.176307052374 -0.813753128052 -0.553824543953
      -0.553824543953 0.176307052374 -0.813753128052
      -0.813753128052 0.176307052374 -0.553824543953
      -0.813753128052 -0.176307052374 -0.553824543953
      -0.553824543953 -0.176307052374 -0.813753128052
      -0.176307052374 0.553824543953 -0.813753128052
      -0.176307052374 0.813753128052 -0.553824543953
      0.176307052374 0.813753128052 -0.553824543953
      0.176307052374 0.553824543953 -0.813753128052
      0.176307052374 0.553824543953 0.813753128052
      0.176307052374 0.813753128052 0.553824543953
      -0.176307052374 0.813753128052 0.553824543953
      -0.176307052374 0.553824543953 0.813753128052
      -0.553824543953 0.176307052374 0.813753128052
      -0.813753128052 0.176307052374 0.553824543953
      -0.813753128052 -0.176307052374 0.553824543953
      -0.553824543953 -0.176307052374 0.813753128052
      -0.176307052374 -0.553824543953 0.813753128052
      -0.176307052374 -0.813753128052 0.553824543953
      0.176307052374 -0.813753128052 0.553824543953
      0.176307052374 -0.553824543953 0.813753128052
      0.553824543953 0.176307052374 0.813753128052
      0.553824543953 -0.176307052374 0.813753128052
      0.813753128052 -0.176307052374 0.553824543953
      0.813753128052 0.176307052374 0.553824543953
      0.813753128052 0.553824543953 -0.176307052374
      0.813753128052 0.553824543953 0.176307052374
      0.553824543953 0.813753128052 0.176307052374
      0.553824543953 0.813753128052 -0.176307052374
      0.813753128052 -0.553824543953 0.176307052374
      0.813753128052 -0.553824543953 -0.176307052374
      0.553824543953 -0.813753128052 -0.176307052374
      0.553824543953 -0.813753128052 0.176307052374
      -0.553824543953 -0.813753128052 -0.176307052374
      -0.553824543953 -0.813753128052 0.176307052374
      -0.813753128052 -0.553824543953 0.176307052374
      -0.813753128052 -0.553824543953 -0.176307052374
      -0.813753128052 0.553824543953 0.176307052374
      -0.813753128052 0.553824543953 -0.176307052374
      -0.553824543953 0.813753128052 -0.176307052374
      -0.553824543953 0.813753128052 0.176307052374
      0.496828258038 0.496828258038 -0.711564004421
      0.711564004421 0.496828258038 -0.496828258038
      0.496828258038 0.711564004421 -0.496828258038
      0.496828258038 -0.496828258038 -0.711564004421
      0.496828258038 -0.711564004421 -0.496828258038
      0.711564004421 -0.496828258038 -0.496828258038
      -0.496828258038 -0.496828258038 -0.711564004421
      -0.496828258038 -0.711564004421 -0.496828258038
      -0.711564004421 -0.496828258038 -0.496828258038
      -0.496828258038 0.496828258038 -0.711564004421
      -0.496828258038 0.711564004421 -0.496828258038
      -0.711564004421 0.496828258038 -0.496828258038
      0.496828258038 0.496828258038 0.711564004421
      0.496828258038 0.711564004421 0.496828258038
      0.711564004421 0.496828258038 0.496828258038
      -0.496828258038 0.496828258038 0.711564004421
      -0.496828258038 0.711564004421 0.496828258038
      -0.711564004421 0.496828258038 0.496828258038
      -0.496828258038 -0.496828258038 0.711564004421
      -0.711564004421 -0.496828258038 0.496828258038
      -0.496828258038 -0.711564004421 0.496828258038
      0.496828258038 -0.496828258038 0.711564004421
      0.496828258038 -0.711564004421 0.496828258038
      0.711564004421 -0.496828258038 0.496828258038
   uvs none
}


object {
   shader "left_sphere"
   type generic-mesh
   name "Sphere"
   points 382
      -0.263569533825 -0.345212072134 0.285924524069
      -0.241991117597 -0.345212072134 0.280744016171
      -0.221488773823 -0.345212072134 0.272251665592
      -0.202567338943 -0.345212072134 0.26065659523
      -0.185692727566 -0.345212072134 0.246244311333
      -0.171280428767 -0.345212072134 0.229369699955
      -0.159685373306 -0.345212072134 0.210448265076
      -0.151193007827 -0.345212072134 0.189945921302
      -0.146012499928 -0.345212072134 0.168367475271
      -0.144271358848 -0.345212072134 0.146244287491
      -0.146012499928 -0.345212072134 0.124121114612
      -0.151193022728 -0.345212072134 0.102542676032
      -0.159685388207 -0.345212072134 0.0820403173566
      -0.171280473471 -0.345212072134 0.0631188824773
      -0.185692772269 -0.345212072134 0.0462442673743
      -0.202567398548 -0.345212072134 0.0318319946527
      -0.221488848329 -0.345212072134 0.0202369261533
      -0.241991207004 -0.345212072134 0.0117445867509
      -0.263569653034 -0.345212072134 0.00656407279894
      -0.264652431011 -0.338375657797 0.00656406069174
      -0.244130119681 -0.331707566977 0.0117445867509
      -0.224631205201 -0.325371980667 0.0202369373292
      -0.206635847688 -0.319524943829 0.0318319946527
      -0.190587118268 -0.314310371876 0.0462442561984
      -0.176880210638 -0.30985674262 0.0631188824773
      -0.165852636099 -0.306273669004 0.0820403248072
      -0.15777592361 -0.303649365902 0.102542683482
      -0.152848944068 -0.302048504353 0.124121114612
      -0.151193022728 -0.301510453224 0.146244287491
      -0.152848944068 -0.302048504353 0.168367475271
      -0.157775908709 -0.303649365902 0.189945921302
      -0.165852621198 -0.306273669004 0.210448265076
      -0.176880165935 -0.309856712818 0.229369699955
      -0.190587073565 -0.314310371876 0.246244311333
      -0.206635773182 -0.319524914026 0.26065659523
      -0.224631130695 -0.325371950865 0.272251665592
      -0.244130030274 -0.331707537174 0.280744016171
      -0.264652341604 -0.338375627995 0.285924524069
      -0.267794698477 -0.332208395004 0.285924524069
      -0.250337392092 -0.319524914026 0.280744016171
      -0.233750641346 -0.307473927736 0.272251665592
      -0.218442872167 -0.296352177858 0.26065659523
      -0.204791039228 -0.286433547735 0.246244311333
      -0.193131253123 -0.277962207794 0.229369699955
      -0.183750659227 -0.271146804094 0.210448265076
      -0.176880180836 -0.266155123711 0.189945921302
      -0.172689065337 -0.263110101223 0.168367475271
      -0.17128045857 -0.262086689472 0.146244287491
      -0.172689065337 -0.263110101223 0.124121114612
      -0.176880195737 -0.266155123711 0.102542683482
      -0.183750659227 -0.271146804094 0.0820403248072
      -0.193131282926 -0.277962237597 0.0631188824773
      -0.204791069031 -0.286433577538 0.0462442561984
      -0.218442931771 -0.296352237463 0.0318319946527
      -0.233750700951 -0.307473987341 0.0202369373292
      -0.250337451696 -0.319524973631 0.0117445867509
      -0.267794787884 -0.332208454609 0.00656406069174
      -0.28569278121 -0.345212161541 0.0048229615204
      -0.27268910408 -0.327314138412 0.00656406069174
      -0.260005623102 -0.309856802225 0.0117445867509
      -0.247954636812 -0.293270051479 0.0202369373292
      -0.236832886934 -0.277962267399 0.0318319946527
      -0.22691424191 -0.264310419559 0.0462442561984
      -0.218442901969 -0.252650618553 0.0631188824773
      -0.211627483368 -0.243269994855 0.0820403248072
      -0.206635802984 -0.236399531364 0.102542683482
      -0.203590765595 -0.232208386064 0.124121114612
      -0.202567368746 -0.230799779296 0.146244287491
      -0.203590765595 -0.232208386064 0.168367475271
      -0.206635802984 -0.236399516463 0.189945921302
      -0.211627483368 -0.243269979954 0.210448265076
      -0.218442887068 -0.252650588751 0.229369699955
      -0.226914212108 -0.264310359955 0.246244311333
      -0.236832857132 -0.277962207794 0.26065659523
      -0.247954592109 -0.293269991875 0.272251665592
      -0.260005563498 -0.30985674262 0.280744016171
      -0.272689044476 -0.327314049006 0.285924524069
      -0.278856277466 -0.324171692133 0.285924524069
      -0.272188186646 -0.303649365902 0.280744016171
      -0.265852630138 -0.284150481224 0.272251665592
      -0.260005563498 -0.266155123711 0.26065659523
      -0.254791051149 -0.250106424093 0.246244311333
      -0.250337392092 -0.236399516463 0.229369699955
      -0.246754348278 -0.225371971726 0.210448265076
      -0.244130045176 -0.217295259237 0.189945921302
      -0.242529183626 -0.212368279696 0.168367475271
      -0.2419911623 -0.210712373257 0.146244287491
      -0.242529183626 -0.212368279696 0.124121114612
      -0.244130060077 -0.217295274138 0.102542683482
      -0.246754333377 -0.225371986628 0.0820403248072
      -0.250337421894 -0.236399561167 0.0631188824773
      -0.254791051149 -0.250106483698 0.0462442561984
      -0.2600055933 -0.266155183315 0.0318319946527
      -0.265852659941 -0.284150540829 0.0202369373292
      -0.272188216448 -0.303649455309 0.0117445867509
      -0.278856307268 -0.32417178154 0.00656406069174
      -0.285692721605 -0.323089003563 0.00656406069174
      -0.285692721605 -0.301510572433 0.0117445867509
      -0.285692751408 -0.281008183956 0.0202369373292
      -0.285692751408 -0.262086749077 0.0318319946527
      -0.285692751408 -0.245212137699 0.0462442561984
      -0.285692751408 -0.230799838901 0.0631188824773
      -0.285692751408 -0.219204753637 0.0820403248072
      -0.285692751408 -0.210712403059 0.102542683482
      -0.285692751408 -0.205531850457 0.124121114612
      -0.285692751408 -0.203790739179 0.146244287491
      -0.285692751408 -0.205531850457 0.168367475271
      -0.285692751408 -0.210712388158 0.189945921302
      -0.285692751408 -0.219204753637 0.210448265076
      -0.285692751408 -0.230799794197 0.229369699955
      -0.285692751408 -0.245212078094 0.246244311333
      -0.285692751408 -0.262086689472 0.26065659523
      -0.285692751408 -0.281008124352 0.272251665592
      -0.285692721605 -0.301510483027 0.280744016171
      -0.285692721605 -0.323088884354 0.285924524069
      -0.292529165745 -0.324171692133 0.285924524069
      -0.299197256565 -0.303649395704 0.280744016171
      -0.305532842875 -0.284150511026 0.272251665592
      -0.311379909515 -0.266155153513 0.26065659523
      -0.316594451666 -0.250106453896 0.246244311333
      -0.321048080921 -0.236399546266 0.229369699955
      -0.324631154537 -0.225372001529 0.210448265076
      -0.327255427837 -0.217295274138 0.189945921302
      -0.328856319189 -0.212368294597 0.168367475271
      -0.329394370317 -0.21071241796 0.146244287491
      -0.328856319189 -0.212368294597 0.124121114612
      -0.327255427837 -0.21729528904 0.102542683482
      -0.324631154537 -0.225372001529 0.0820403248072
      -0.321048080921 -0.236399576068 0.0631188824773
      -0.316594421864 -0.250106483698 0.0462442561984
      -0.311379879713 -0.266155213118 0.0318319946527
      -0.305532842875 -0.284150570631 0.0202369373292
      -0.299197226763 -0.303649485111 0.0117445867509
      -0.292529135942 -0.32417178154 0.00656406069174
      -0.29869633913 -0.327314138412 0.00656406069174
      -0.311379820108 -0.309856832027 0.0117445867509
      -0.323430836201 -0.293270051479 0.0202369373292
      -0.334552586079 -0.277962297201 0.0318319946527
      -0.344471246004 -0.264310449362 0.0462442561984
      -0.352942585945 -0.252650648355 0.0631188824773
      -0.359757989645 -0.243270024657 0.0820403248072
      -0.364749670029 -0.236399576068 0.102542683482
      -0.367794722319 -0.232208430767 0.124121114612
      -0.368818134069 -0.230799838901 0.146244287491
      -0.367794722319 -0.232208430767 0.168367475271
      -0.364749670029 -0.236399576068 0.189945921302
      -0.359757989645 -0.243270039558 0.210448265076
      -0.352942585945 -0.252650618553 0.229369699955
      -0.344471275806 -0.264310419559 0.246244311333
      -0.334552615881 -0.277962237597 0.26065659523
      -0.323430866003 -0.293270021677 0.272251665592
      -0.311379879713 -0.30985674262 0.280744016171
      -0.298696398735 -0.327314049006 0.285924524069
      -0.303590744734 -0.332208395004 0.285924524069
      -0.321048080921 -0.319524914026 0.280744016171
      -0.337634801865 -0.307473957539 0.272251665592
      -0.352942585945 -0.296352237463 0.26065659523
      -0.366594433784 -0.286433577538 0.246244311333
      -0.378254204988 -0.277962267399 0.229369699955
      -0.387634813786 -0.271146863699 0.210448265076
      -0.394505262375 -0.266155183315 0.189945921302
      -0.398696422577 -0.263110160828 0.168367475271
      -0.400104999542 -0.262086749077 0.146244287491
      -0.398696422577 -0.263110160828 0.124121114612
      -0.394505262375 -0.266155183315 0.102542683482
      -0.387634813786 -0.271146863699 0.0820403248072
      -0.378254175186 -0.277962297201 0.0631188824773
      -0.36659437418 -0.28643360734 0.0462442561984
      -0.35294252634 -0.296352267265 0.0318319946527
      -0.337634772062 -0.307474017143 0.0202369373292
      -0.321047991514 -0.319524973631 0.0117445867509
      -0.303590655327 -0.332208454609 0.00656406069174
      -0.306733012199 -0.338375687599 0.00656406069174
      -0.32725533843 -0.331707566977 0.0117445867509
      -0.346754252911 -0.325372010469 0.0202369373292
      -0.364749610424 -0.319524973631 0.0318319946527
      -0.380798310041 -0.31431043148 0.0462442561984
      -0.394505232573 -0.309856802225 0.0631188824773
      -0.405532807112 -0.306273728609 0.0820403248072
      -0.4136095047 -0.303649455309 0.102542683482
      -0.418536514044 -0.302048563957 0.124121114612
      -0.42019239068 -0.301510542631 0.146244287491
      -0.418536514044 -0.302048563957 0.168367475271
      -0.413609534502 -0.303649425507 0.189945921302
      -0.405532807112 -0.306273728609 0.210448265076
      -0.394505262375 -0.309856802225 0.229369699955
      -0.380798369646 -0.31431043148 0.246244311333
      -0.364749670029 -0.319524943829 0.26065659523
      -0.346754312515 -0.325371980667 0.272251665592
      -0.327255427837 -0.331707537174 0.280744016171
      -0.306733101606 -0.338375657797 0.285924524069
      -0.307815909386 -0.345212072134 0.285924524069
      -0.329394310713 -0.345212101936 0.280744016171
      -0.349896639585 -0.345212101936 0.272251665592
      -0.368818104267 -0.345212101936 0.26065659523
      -0.385692685843 -0.345212131739 0.246244311333
      -0.40010496974 -0.345212131739 0.229369699955
      -0.411700040102 -0.345212131739 0.210448265076
      -0.42019239068 -0.345212131739 0.189945921302
      -0.425372928381 -0.345212161541 0.168367475271
      -0.42711403966 -0.345212131739 0.146244287491
      -0.425372928381 -0.345212161541 0.124121114612
      -0.42019239068 -0.345212131739 0.102542683482
      -0.411700040102 -0.345212131739 0.0820403248072
      -0.400104939938 -0.345212131739 0.0631188824773
      -0.38569265604 -0.345212131739 0.0462442561984
      -0.368818044662 -0.345212101936 0.0318319946527
      -0.349896579981 -0.345212101936 0.0202369373292
      -0.329394221306 -0.345212101936 0.0117445867509
      -0.307815790176 -0.345212072134 0.00656406069174
      -0.306733012199 -0.352048486471 0.00656406069174
      -0.327255308628 -0.358716607094 0.0117445867509
      -0.346754223108 -0.365052193403 0.0202369373292
      -0.364749580622 -0.370899260044 0.0318319946527
      -0.380798280239 -0.376113802195 0.0462442561984
      -0.394505172968 -0.380567461252 0.0631188824773
      -0.405532777309 -0.384150534868 0.0820403248072
      -0.413609474897 -0.386774808168 0.102542683482
      -0.418536454439 -0.38837569952 0.124121114612
      -0.420192331076 -0.388913720846 0.146244287491
      -0.418536454439 -0.38837569952 0.168367475271
      -0.413609474897 -0.386774808168 0.189945921302
      -0.405532777309 -0.384150534868 0.210448265076
      -0.394505232573 -0.380567461252 0.229369699955
      -0.380798339844 -0.376113802195 0.246244311333
      -0.364749640226 -0.370899260044 0.26065659523
      -0.346754282713 -0.365052223206 0.272251665592
      -0.327255398035 -0.358716636896 0.280744016171
      -0.306733101606 -0.352048516273 0.285924524069
      -0.303590744734 -0.358215749264 0.285924524069
      -0.321048051119 -0.370899230242 0.280744016171
      -0.337634772062 -0.382950216532 0.272251665592
      -0.35294252634 -0.394071996212 0.26065659523
      -0.36659437418 -0.403990626335 0.246244311333
      -0.378254145384 -0.412461966276 0.229369699955
      -0.387634724379 -0.419277369976 0.210448265076
      -0.39450520277 -0.42426905036 0.189945921302
      -0.39869633317 -0.42731410265 0.168367475271
      -0.400104910135 -0.428337484598 0.146244287491
      -0.39869633317 -0.42731410265 0.124121114612
      -0.394505172968 -0.42426905036 0.102542683482
      -0.387634724379 -0.419277369976 0.0820403248072
      -0.378254115582 -0.412461936474 0.0631188824773
      -0.366594314575 -0.403990596533 0.0462442561984
      -0.352942466736 -0.394071936607 0.0318319946527
      -0.337634712458 -0.382950186729 0.0202369373292
      -0.321047961712 -0.370899200439 0.0117445867509
      -0.303590655327 -0.358215689659 0.00656406069174
      -0.298696309328 -0.363110005856 0.00656406069174
      -0.311379790306 -0.380567342043 0.0117445867509
      -0.323430776596 -0.397154122591 0.0202369373292
      -0.334552496672 -0.412461876869 0.0318319946527
      -0.344471156597 -0.426113754511 0.0462442561984
      -0.352942466736 -0.437773525715 0.0631188824773
      -0.359757900238 -0.447154164314 0.0820403248072
      -0.364749580622 -0.454024612904 0.102542683482
      -0.367794603109 -0.458215773106 0.124121114612
      -0.368817985058 -0.459624350071 0.146244287491
      -0.367794603109 -0.458215773106 0.168367475271
      -0.364749580622 -0.454024642706 0.189945921302
      -0.359757900238 -0.447154164314 0.210448265076
      -0.352942496538 -0.43777358532 0.229369699955
      -0.344471186399 -0.426113784313 0.246244311333
      -0.334552556276 -0.412461936474 0.26065659523
      -0.323430806398 -0.397154152393 0.272251665592
      -0.311379849911 -0.38056743145 0.280744016171
      -0.298696398735 -0.363110095263 0.285924524069
      -0.292529135942 -0.366252452135 0.285924524069
      -0.299197226763 -0.386774778366 0.280744016171
      -0.30553278327 -0.406273633242 0.272251665592
      -0.311379820108 -0.424269020557 0.26065659523
      -0.316594362259 -0.440317720175 0.246244311333
      -0.321047961712 -0.454024612904 0.229369699955
      -0.324631035328 -0.46505215764 0.210448265076
      -0.32725533843 -0.473128885031 0.189945921302
      -0.32885619998 -0.478055864573 0.168367475271
      -0.329394191504 -0.479711741209 0.146244287491
      -0.32885619998 -0.478055864573 0.124121114612
      -0.327255308628 -0.473128855228 0.102542683482
      -0.324631035328 -0.46505215764 0.0820403248072
      -0.321047961712 -0.454024583101 0.0631188824773
      -0.316594332457 -0.44031766057 0.0462442561984
      -0.311379790306 -0.424268960953 0.0318319946527
      -0.305532753468 -0.406273603439 0.0202369373292
      -0.29919719696 -0.386774688959 0.0117445867509
      -0.29252910614 -0.366252362728 0.00656406069174
      -0.285692691803 -0.367335140705 0.00656406069174
      -0.285692691803 -0.388913571835 0.0117445867509
      -0.285692662001 -0.40941593051 0.0202369373292
      -0.285692662001 -0.428337365389 0.0318319946527
      -0.285692632198 -0.445211976767 0.0462442561984
      -0.285692632198 -0.459624290466 0.0631188824773
      -0.285692632198 -0.471219360828 0.0820403248072
      -0.285692632198 -0.479711711407 0.102542683482
      -0.285692632198 -0.48489227891 0.124121114612
      -0.285692602396 -0.486633360386 0.146244287491
      -0.285692632198 -0.48489227891 0.168367475271
      -0.285692632198 -0.479711741209 0.189945921302
      -0.285692632198 -0.471219360828 0.210448265076
      -0.285692632198 -0.459624320269 0.229369699955
      -0.285692662001 -0.445212036371 0.246244311333
      -0.285692662001 -0.428337424994 0.26065659523
      -0.285692662001 -0.409415990114 0.272251665592
      -0.285692691803 -0.388913661242 0.280744016171
      -0.285692691803 -0.367335230112 0.285924524069
      -0.278856277466 -0.366252452135 0.285924524069
      -0.272188156843 -0.386774748564 0.280744016171
      -0.265852570534 -0.406273603439 0.272251665592
      -0.260005503893 -0.424268960953 0.26065659523
      -0.254790961742 -0.44031766057 0.246244311333
      -0.250337302685 -0.454024553299 0.229369699955
      -0.246754229069 -0.465052098036 0.210448265076
      -0.244129955769 -0.473128825426 0.189945921302
      -0.242529064417 -0.478055804968 0.168367475271
      -0.24199102819 -0.479711681604 0.146244287491
      -0.242529064417 -0.478055804968 0.124121114612
      -0.244129955769 -0.473128795624 0.102542683482
      -0.24675424397 -0.465052098036 0.0820403248072
      -0.250337332487 -0.454024523497 0.0631188824773
      -0.254790961742 -0.440317630768 0.0462442561984
      -0.260005533695 -0.424268901348 0.0318319946527
      -0.265852600336 -0.406273543835 0.0202369373292
      -0.272188186646 -0.386774659157 0.0117445867509
      -0.278856307268 -0.366252362728 0.00656406069174
      -0.27268910408 -0.363110005856 0.00656406069174
      -0.2600055933 -0.380567312241 0.0117445867509
      -0.247954592109 -0.397154062986 0.0202369373292
      -0.236832842231 -0.412461817265 0.0318319946527
      -0.226914182305 -0.426113665104 0.0462442561984
      -0.218442842364 -0.437773436308 0.0631188824773
      -0.211627423763 -0.447154045105 0.0820403248072
      -0.20663574338 -0.454024493694 0.102542683482
      -0.203590676188 -0.458215653896 0.124121114612
      -0.202567279339 -0.459624230862 0.146244287491
      -0.203590676188 -0.458215653896 0.168367475271
      -0.206635728478 -0.454024523497 0.189945921302
      -0.211627408862 -0.447154045105 0.210448265076
      -0.218442827463 -0.43777346611 0.229369699955
      -0.226914152503 -0.426113694906 0.246244311333
      -0.236832797527 -0.412461847067 0.26065659523
      -0.247954562306 -0.397154092789 0.272251665592
      -0.260005533695 -0.380567371845 0.280744016171
      -0.272689044476 -0.363110095263 0.285924524069
      -0.267794698477 -0.358215719461 0.285924524069
      -0.250337362289 -0.370899200439 0.280744016171
      -0.233750626445 -0.382950127125 0.272251665592
      -0.218442857265 -0.394071877003 0.26065659523
      -0.204791009426 -0.403990507126 0.246244311333
      -0.193131223321 -0.412461817265 0.229369699955
      -0.183750614524 -0.419277220964 0.210448265076
      -0.176880165935 -0.424268901348 0.189945921302
      -0.172689005733 -0.427313923836 0.168367475271
      -0.171280428767 -0.428337305784 0.146244287491
      -0.172689005733 -0.427313923836 0.124121114612
      -0.176880165935 -0.424268871546 0.102542683482
      -0.183750614524 -0.419277220964 0.0820403248072
      -0.193131253123 -0.412461817265 0.0631188824773
      -0.204791039228 -0.403990477324 0.0462442561984
      -0.218442901969 -0.3940718472 0.0318319946527
      -0.233750671148 -0.382950097322 0.0202369373292
      -0.250337451696 -0.370899140835 0.0117445867509
      -0.267794787884 -0.358215659857 0.00656406069174
      -0.264652431011 -0.352048456669 0.00656406069174
      -0.244130119681 -0.358716547489 0.0117445867509
      -0.224631205201 -0.365052103996 0.0202369373292
      -0.206635847688 -0.370899140835 0.0318319946527
      -0.190587118268 -0.376113653183 0.0462442561984
      -0.176880225539 -0.380567282438 0.0631188824773
      -0.165852636099 -0.384150356054 0.0820403248072
      -0.157775938511 -0.386774629354 0.102542683482
      -0.152848929167 -0.388375490904 0.124121114612
      -0.15119305253 -0.38891351223 0.146244287491
      -0.152848929167 -0.388375490904 0.168367475271
      -0.15777592361 -0.386774629354 0.189945921302
      -0.165852636099 -0.384150356054 0.210448265076
      -0.176880195737 -0.380567282438 0.229369699955
      -0.190587073565 -0.376113682985 0.246244311333
      -0.206635788083 -0.370899140835 0.26065659523
      -0.224631160498 -0.365052103996 0.272251665592
      -0.244130030274 -0.358716577291 0.280744016171
      -0.264652341604 -0.352048486471 0.285924524069
      -0.285692721605 -0.345212072134 0.28766566515
   triangles 760
      57 19 18
      18 19 20
      18 20 17
      17 20 21
      17 21 16
      16 21 22
      16 22 15
      15 22 23
      15 23 14
      14 23 24
      14 24 13
      13 24 25
      13 25 12
      12 25 26
      12 26 11
      11 26 27
      11 27 10
      10 27 28
      10 28 9
      9 28 29
      9 29 8
      8 29 30
      8 30 7
      7 30 31
      7 31 6
      6 31 32
      6 32 5
      5 32 33
      5 33 4
      4 33 34
      4 34 3
      3 34 35
      3 35 2
      2 35 36
      2 36 1
      37 0 1
      37 1 36
      0 37 381
      37 38 381
      36 39 38
      36 38 37
      35 40 39
      35 39 36
      34 41 40
      34 40 35
      33 42 41
      33 41 34
      32 43 42
      32 42 33
      31 44 43
      31 43 32
      30 45 44
      30 44 31
      29 46 45
      29 45 30
      28 47 46
      28 46 29
      27 48 47
      27 47 28
      26 49 48
      26 48 27
      25 50 49
      25 49 26
      24 51 50
      24 50 25
      23 52 51
      23 51 24
      22 53 52
      22 52 23
      21 54 53
      21 53 22
      20 55 54
      20 54 21
      19 56 55
      19 55 20
      57 56 19
      57 58 56
      56 58 59
      56 59 55
      55 59 60
      55 60 54
      54 60 61
      54 61 53
      53 61 62
      53 62 52
      52 62 63
      52 63 51
      51 63 64
      51 64 50
      50 64 65
      50 65 49
      49 65 66
      49 66 48
      48 66 67
      48 67 47
      47 67 68
      47 68 46
      46 68 69
      46 69 45
      45 69 70
      45 70 44
      44 70 71
      44 71 43
      43 71 72
      43 72 42
      42 72 73
      42 73 41
      41 73 74
      41 74 40
      40 74 75
      40 75 39
      39 75 76
      39 76 38
      38 76 381
      76 77 381
      75 78 77
      75 77 76
      74 79 78
      74 78 75
      73 80 79
      73 79 74
      72 81 80
      72 80 73
      71 82 81
      71 81 72
      70 83 82
      70 82 71
      69 84 83
      69 83 70
      68 85 84
      68 84 69
      67 86 85
      67 85 68
      66 87 86
      66 86 67
      65 88 87
      65 87 66
      64 89 88
      64 88 65
      63 90 89
      63 89 64
      62 91 90
      62 90 63
      61 92 91
      61 91 62
      60 93 92
      60 92 61
      59 94 93
      59 93 60
      58 95 94
      58 94 59
      57 95 58
      57 96 95
      95 96 97
      95 97 94
      94 97 98
      94 98 93
      93 98 99
      93 99 92
      92 99 100
      92 100 91
      91 100 101
      91 101 90
      90 101 102
      90 102 89
      89 102 103
      89 103 88
      88 103 104
      88 104 87
      87 104 105
      87 105 86
      86 105 106
      86 106 85
      85 106 107
      85 107 84
      84 107 108
      84 108 83
      83 108 109
      83 109 82
      82 109 110
      82 110 81
      81 110 111
      81 111 80
      80 111 112
      80 112 79
      79 112 113
      79 113 78
      78 113 114
      78 114 77
      77 114 381
      114 115 381
      113 116 115
      113 115 114
      112 117 116
      112 116 113
      111 118 117
      111 117 112
      110 119 118
      110 118 111
      109 120 119
      109 119 110
      108 121 120
      108 120 109
      107 122 121
      107 121 108
      106 123 122
      106 122 107
      105 124 123
      105 123 106
      104 125 124
      104 124 105
      103 126 125
      103 125 104
      102 127 126
      102 126 103
      101 128 127
      101 127 102
      100 129 128
      100 128 101
      99 130 129
      99 129 100
      98 131 130
      98 130 99
      97 132 131
      97 131 98
      96 133 132
      96 132 97
      57 133 96
      57 134 133
      133 134 135
      133 135 132
      132 135 136
      132 136 131
      131 136 137
      131 137 130
      130 137 138
      130 138 129
      129 138 139
      129 139 128
      128 139 140
      128 140 127
      127 140 141
      127 141 126
      126 141 142
      126 142 125
      125 142 143
      125 143 124
      124 143 144
      124 144 123
      123 144 145
      123 145 122
      122 145 146
      122 146 121
      121 146 147
      121 147 120
      120 147 148
      120 148 119
      119 148 149
      119 149 118
      118 149 150
      118 150 117
      117 150 151
      117 151 116
      116 151 152
      116 152 115
      115 152 381
      152 153 381
      151 154 153
      151 153 152
      150 155 154
      150 154 151
      149 156 155
      149 155 150
      148 157 156
      148 156 149
      147 158 157
      147 157 148
      146 159 158
      146 158 147
      145 160 159
      145 159 146
      144 161 160
      144 160 145
      143 162 161
      143 161 144
      142 163 162
      142 162 143
      141 164 163
      141 163 142
      140 165 164
      140 164 141
      139 166 165
      139 165 140
      138 167 166
      138 166 139
      137 168 167
      137 167 138
      136 169 168
      136 168 137
      135 170 169
      135 169 136
      134 171 170
      134 170 135
      57 171 134
      57 172 171
      171 172 173
      171 173 170
      170 173 174
      170 174 169
      169 174 175
      169 175 168
      168 175 176
      168 176 167
      167 176 177
      167 177 166
      166 177 178
      166 178 165
      165 178 179
      165 179 164
      164 179 180
      164 180 163
      163 180 181
      163 181 162
      162 181 182
      162 182 161
      161 182 183
      161 183 160
      160 183 184
      160 184 159
      159 184 185
      159 185 158
      158 185 186
      158 186 157
      157 186 187
      157 187 156
      156 187 188
      156 188 155
      155 188 189
      155 189 154
      154 189 190
      154 190 153
      153 190 381
      190 191 381
      189 192 191
      189 191 190
      188 193 192
      188 192 189
      187 194 193
      187 193 188
      186 195 194
      186 194 187
      185 196 195
      185 195 186
      184 197 196
      184 196 185
      183 198 197
      183 197 184
      182 199 198
      182 198 183
      181 200 199
      181 199 182
      180 201 200
      180 200 181
      179 202 201
      179 201 180
      178 203 202
      178 202 179
      177 204 203
      177 203 178
      176 205 204
      176 204 177
      175 206 205
      175 205 176
      174 207 206
      174 206 175
      173 208 207
      173 207 174
      172 209 208
      172 208 173
      57 209 172
      57 210 209
      209 210 211
      209 211 208
      208 211 212
      208 212 207
      207 212 213
      207 213 206
      206 213 214
      206 214 205
      205 214 215
      205 215 204
      204 215 216
      204 216 203
      203 216 217
      203 217 202
      202 217 218
      202 218 201
      201 218 219
      201 219 200
      200 219 220
      200 220 199
      199 220 221
      199 221 198
      198 221 222
      198 222 197
      197 222 223
      197 223 196
      196 223 224
      196 224 195
      195 224 225
      195 225 194
      194 225 226
      194 226 193
      193 226 227
      193 227 192
      192 227 228
      192 228 191
      191 228 381
      228 229 381
      227 230 229
      227 229 228
      226 231 230
      226 230 227
      225 232 231
      225 231 226
      224 233 232
      224 232 225
      223 234 233
      223 233 224
      222 235 234
      222 234 223
      221 236 235
      221 235 222
      220 237 236
      220 236 221
      219 238 237
      219 237 220
      218 239 238
      218 238 219
      217 240 239
      217 239 218
      216 241 240
      216 240 217
      215 242 241
      215 241 216
      214 243 242
      214 242 215
      213 244 243
      213 243 214
      212 245 244
      212 244 213
      211 246 245
      211 245 212
      210 247 246
      210 246 211
      57 247 210
      57 248 247
      247 248 249
      247 249 246
      246 249 250
      246 250 245
      245 250 251
      245 251 244
      244 251 252
      244 252 243
      243 252 253
      243 253 242
      242 253 254
      242 254 241
      241 254 255
      241 255 240
      240 255 256
      240 256 239
      239 256 257
      239 257 238
      238 257 258
      238 258 237
      237 258 259
      237 259 236
      236 259 260
      236 260 235
      235 260 261
      235 261 234
      234 261 262
      234 262 233
      233 262 263
      233 263 232
      232 263 264
      232 264 231
      231 264 265
      231 265 230
      230 265 266
      230 266 229
      229 266 381
      266 267 381
      265 268 267
      265 267 266
      264 269 268
      264 268 265
      263 270 269
      263 269 264
      262 271 270
      262 270 263
      261 272 271
      261 271 262
      260 273 272
      260 272 261
      259 274 273
      259 273 260
      258 275 274
      258 274 259
      257 276 275
      257 275 258
      256 277 276
      256 276 257
      255 278 277
      255 277 256
      254 279 278
      254 278 255
      253 280 279
      253 279 254
      252 281 280
      252 280 253
      251 282 281
      251 281 252
      250 283 282
      250 282 251
      249 284 283
      249 283 250
      248 285 284
      248 284 249
      57 285 248
      57 286 285
      285 286 287
      285 287 284
      284 287 288
      284 288 283
      283 288 289
      283 289 282
      282 289 290
      282 290 281
      281 290 291
      281 291 280
      280 291 292
      280 292 279
      279 292 293
      279 293 278
      278 293 294
      278 294 277
      277 294 295
      277 295 276
      276 295 296
      276 296 275
      275 296 297
      275 297 274
      274 297 298
      274 298 273
      273 298 299
      273 299 272
      272 299 300
      272 300 271
      271 300 301
      271 301 270
      270 301 302
      270 302 269
      269 302 303
      269 303 268
      268 303 304
      268 304 267
      267 304 381
      304 305 381
      303 306 305
      303 305 304
      302 307 306
      302 306 303
      301 308 307
      301 307 302
      300 309 308
      300 308 301
      299 310 309
      299 309 300
      298 311 310
      298 310 299
      297 312 311
      297 311 298
      296 313 312
      296 312 297
      295 314 313
      295 313 296
      294 315 314
      294 314 295
      293 316 315
      293 315 294
      292 317 316
      292 316 293
      291 318 317
      291 317 292
      290 319 318
      290 318 291
      289 320 319
      289 319 290
      288 321 320
      288 320 289
      287 322 321
      287 321 288
      286 323 322
      286 322 287
      57 323 286
      57 324 323
      323 324 325
      323 325 322
      322 325 326
      322 326 321
      321 326 327
      321 327 320
      320 327 328
      320 328 319
      319 328 329
      319 329 318
      318 329 330
      318 330 317
      317 330 331
      317 331 316
      316 331 332
      316 332 315
      315 332 333
      315 333 314
      314 333 334
      314 334 313
      313 334 335
      313 335 312
      312 335 336
      312 336 311
      311 336 337
      311 337 310
      310 337 338
      310 338 309
      309 338 339
      309 339 308
      308 339 340
      308 340 307
      307 340 341
      307 341 306
      306 341 342
      306 342 305
      305 342 381
      342 343 381
      341 344 343
      341 343 342
      340 345 344
      340 344 341
      339 346 345
      339 345 340
      338 347 346
      338 346 339
      337 348 347
      337 347 338
      336 349 348
      336 348 337
      335 350 349
      335 349 336
      334 351 350
      334 350 335
      333 352 351
      333 351 334
      332 353 352
      332 352 333
      331 354 353
      331 353 332
      330 355 354
      330 354 331
      329 356 355
      329 355 330
      328 357 356
      328 356 329
      327 358 357
      327 357 328
      326 359 358
      326 358 327
      325 360 359
      325 359 326
      324 361 360
      324 360 325
      57 361 324
      57 362 361
      361 362 363
      361 363 360
      360 363 364
      360 364 359
      359 364 365
      359 365 358
      358 365 366
      358 366 357
      357 366 367
      357 367 356
      356 367 368
      356 368 355
      355 368 369
      355 369 354
      354 369 370
      354 370 353
      353 370 371
      353 371 352
      352 371 372
      352 372 351
      351 372 373
      351 373 350
      350 373 374
      350 374 349
      349 374 375
      349 375 348
      348 375 376
      348 376 347
      347 376 377
      347 377 346
      346 377 378
      346 378 345
      345 378 379
      345 379 344
      344 379 380
      344 380 343
      343 380 381
      380 0 381
      0 380 379
      0 379 1
      378 2 1
      378 1 379
      377 3 2
      377 2 378
      376 4 3
      376 3 377
      375 5 4
      375 4 376
      374 6 5
      374 5 375
      373 7 6
      373 6 374
      372 8 7
      372 7 373
      371 9 8
      371 8 372
      370 10 9
      370 9 371
      369 11 10
      369 10 370
      368 12 11
      368 11 369
      367 13 12
      367 12 368
      366 14 13
      366 13 367
      365 15 14
      365 14 366
      364 16 15
      364 15 365
      363 17 16
      363 16 364
      362 18 17
      362 17 363
      57 18 362
   normals vertex
      0.156410768628 1.49164929297e-008 0.987692058086
      0.308976322412 2.94662800826e-008 0.951069712639
      0.453939527273 4.32910454151e-008 0.891032516956
      0.587732434273 5.60505348801e-008 0.809055328369
      0.707045733929 6.74291413816e-008 0.707167804241
      0.808980226517 7.71503607666e-008 0.587835967541
      0.890982866287 8.49707433304e-008 0.454036861658
      0.951048851013 9.06990891281e-008 0.309040516615
      0.987687349319 9.41932114529e-008 0.156440541148
      1 9.53674330617e-008 0
      0.987687349319 9.41932114529e-008 -0.156440541148
      0.951048851013 9.06990891281e-008 -0.309040516615
      0.890982866287 8.49707433304e-008 -0.454036861658
      0.808980226517 7.71503607666e-008 -0.587835967541
      0.707045733929 6.74291413816e-008 -0.707167804241
      0.587732434273 5.60505348801e-008 -0.809055328369
      0.453939527273 4.32910454151e-008 -0.891032516956
      0.308976322412 2.94662800826e-008 -0.951069712639
      0.156410768628 1.49164929297e-008 -0.987692058086
      0.148750737309 0.0483119599521 -0.98769390583
      0.293840557337 0.0954646393657 -0.951075315475
      0.431722313166 0.140265539289 -0.891033828259
      0.558957576752 0.181619301438 -0.809061765671
      0.672455072403 0.218485400081 -0.707155168056
      0.769390821457 0.249983429909 -0.587831676006
      0.847376942635 0.275317490101 -0.454040259123
      0.904506981373 0.293872535229 -0.309040635824
      0.939352631569 0.305192798376 -0.156441763043
      0.951060712337 0.309004038572 0
      0.939352631569 0.305192798376 0.156441763043
      0.904506981373 0.293872535229 0.309040635824
      0.847376942635 0.275317490101 0.454040259123
      0.769390821457 0.249983429909 0.587831676006
      0.672455072403 0.218485400081 0.707155168056
      0.558957576752 0.181619301438 0.809061765671
      0.431722313166 0.140265539289 0.891033828259
      0.293840557337 0.0954646393657 0.951075315475
      0.148750737309 0.0483119599521 0.98769390583
      0.126532748342 0.0919239446521 0.987693965435
      0.249954178929 0.181590661407 0.951077103615
      0.367238491774 0.266799598932 0.891040921211
      0.475487202406 0.345445483923 0.809060752392
      0.57202398777 0.415581882 0.707163572311
      0.654489457607 0.475493013859 0.587835013866
      0.720826148987 0.523704528809 0.454029858112
      0.769414067268 0.559016287327 0.309035211802
      0.799060463905 0.580541193485 0.156442731619
      0.809030234814 0.587767004967 0
      0.799060463905 0.580541193485 -0.156442731619
      0.769414067268 0.559016287327 -0.309035211802
      0.720826148987 0.523704528809 -0.454029858112
      0.654489457607 0.475493013859 -0.587835013866
      0.57202398777 0.415581882 -0.707163572311
      0.475487202406 0.345445483923 -0.809060752392
      0.367238491774 0.266799598932 -0.891040921211
      0.249954178929 0.181590661407 -0.951077103615
      0.126532748342 0.0919239446521 -0.987693965435
      0 0 -1
      0.0919239372015 0.126532748342 -0.987693965435
      0.181590646505 0.24995419383 -0.951077103615
      0.266799539328 0.367238521576 -0.891040921211
      0.345445424318 0.475487262011 -0.809060752392
      0.415581852198 0.57202398777 -0.707163572311
      0.475492924452 0.654489517212 -0.587835013866
      0.523704528809 0.720826208591 -0.454029858112
      0.559016168118 0.769414126873 -0.309035181999
      0.580541133881 0.799060463905 -0.156442731619
      0.587766945362 0.809030294418 0
      0.580541133881 0.799060463905 0.156442731619
      0.559016168118 0.769414126873 0.309035181999
      0.523704528809 0.720826208591 0.454029858112
      0.475492924452 0.654489517212 0.587835013866
      0.415581852198 0.57202398777 0.707163572311
      0.345445424318 0.475487262011 0.809060752392
      0.266799539328 0.367238521576 0.891040921211
      0.181590646505 0.24995419383 0.951077103615
      0.0919239372015 0.126532748342 0.987693965435
      0.048311945051 0.148750752211 0.98769390583
      0.0954646095634 0.293840587139 0.951075315475
      0.140265509486 0.43172237277 0.891033828259
      0.181619256735 0.558957576752 0.809061765671
      0.218485325575 0.672455072403 0.707155168056
      0.249983355403 0.769390881062 0.587831676006
      0.275317400694 0.847377061844 0.454040259123
      0.293872416019 0.904506981373 0.309040606022
      0.305192708969 0.939352631569 0.156441763043
      0.309003889561 0.951060712337 0
      0.305192708969 0.939352631569 -0.156441763043
      0.293872416019 0.904506981373 -0.309040606022
      0.275317400694 0.847377061844 -0.454040259123
      0.249983355403 0.769390881062 -0.587831676006
      0.218485325575 0.672455072403 -0.707155168056
      0.181619256735 0.558957576752 -0.809061765671
      0.140265509486 0.43172237277 -0.891033828259
      0.0954646095634 0.293840587139 -0.951075315475
      0.048311945051 0.148750752211 -0.98769390583
      0 0.156410768628 -0.987692058086
      0 0.308976322412 -0.951069712639
      0 0.453939527273 -0.891032516956
      0 0.587732434273 -0.809055328369
      0 0.707045733929 -0.707167804241
      0 0.808980226517 -0.587835967541
      0 0.890982866287 -0.454036861658
      0 0.951048851013 -0.309040516615
      0 0.987687349319 -0.156440541148
      0 1 0
      0 0.987687349319 0.156440541148
      0 0.951048851013 0.309040516615
      0 0.890982866287 0.454036861658
      0 0.808980226517 0.587835967541
      0 0.707045733929 0.707167804241
      0 0.587732434273 0.809055328369
      0 0.453939527273 0.891032516956
      0 0.308976322412 0.951069712639
      0 0.156410768628 0.987692058086
      -0.048311945051 0.148750737309 0.98769390583
      -0.0954646095634 0.293840557337 0.951075315475
      -0.140265509486 0.431722313166 0.891033828259
      -0.181619256735 0.558957576752 0.809061765671
      -0.218485325575 0.672455072403 0.707155168056
      -0.249983355403 0.769390821457 0.587831676006
      -0.275317400694 0.847376942635 0.454040259123
      -0.293872445822 0.904506981373 0.309040635824
      -0.305192738771 0.939352631569 0.156441777945
      -0.309003949165 0.951060771942 0
      -0.305192738771 0.939352631569 -0.156441777945
      -0.293872445822 0.904506981373 -0.309040635824
      -0.275317400694 0.847376942635 -0.454040259123
      -0.249983355403 0.769390821457 -0.587831676006
      -0.218485325575 0.672455072403 -0.707155168056
      -0.181619256735 0.558957576752 -0.809061765671
      -0.140265509486 0.431722313166 -0.891033828259
      -0.0954646095634 0.293840557337 -0.951075315475
      -0.048311945051 0.148750737309 -0.98769390583
      -0.0919239372015 0.12653273344 -0.987693965435
      -0.181590646505 0.249954149127 -0.951077103615
      -0.266799539328 0.367238491774 -0.891040921211
      -0.345445454121 0.475487262011 -0.809060811996
      -0.415581852198 0.572023928165 -0.707163572311
      -0.475492954254 0.654489517212 -0.587835073471
      -0.52371609211 0.720811545849 -0.454039901495
      -0.559016287327 0.769414126873 -0.309035241604
      -0.580541193485 0.799060463905 -0.15644274652
      -0.587767004967 0.809030294418 0
      -0.580541193485 0.799060463905 0.15644274652
      -0.559016287327 0.769414126873 0.309035241604
      -0.523704528809 0.720826148987 0.454029917717
      -0.475492954254 0.654489517212 0.587835073471
      -0.415581852198 0.572023928165 0.707163572311
      -0.345445454121 0.475487262011 0.809060811996
      -0.266799539328 0.367238491774 0.891040921211
      -0.181590646505 0.249954149127 0.951077103615
      -0.0919239372015 0.12653273344 0.987693965435
      -0.126532748342 0.0919239223003 0.987693965435
      -0.249954178929 0.181590616703 0.951077103615
      -0.367238491774 0.266799509525 0.891040921211
      -0.475487262011 0.345445424318 0.809060811996
      -0.57202398777 0.415581792593 0.707163572311
      -0.654489457607 0.475492864847 0.587835013866
      -0.720826208591 0.523704528809 0.454029917717
      -0.769414126873 0.559016168118 0.309035241604
      -0.79906052351 0.580541133881 0.15644274652
      -0.809030294418 0.587766885757 0
      -0.79906052351 0.580541133881 -0.15644274652
      -0.769414126873 0.559016168118 -0.309035241604
      -0.720826208591 0.523704528809 -0.454029917717
      -0.654489457607 0.475492864847 -0.587835013866
      -0.57202398777 0.415581792593 -0.707163572311
      -0.475487262011 0.345445424318 -0.809060811996
      -0.367238491774 0.266799509525 -0.891040921211
      -0.249954178929 0.181590616703 -0.951077103615
      -0.126532748342 0.0919239223003 -0.987693965435
      -0.148750737309 0.0483119301498 -0.98769390583
      -0.293840557337 0.095464579761 -0.951075315475
      -0.431722313166 0.140265449882 -0.891033828259
      -0.558957576752 0.181619212031 -0.809061765671
      -0.672455072403 0.218485280871 -0.707155168056
      -0.769390821457 0.249983280897 -0.587831676006
      -0.847377002239 0.275317341089 -0.454040288925
      -0.904506981373 0.293872386217 -0.309040635824
      -0.939352691174 0.305192619562 -0.156441777945
      -0.951060771942 0.309003859758 0
      -0.939352691174 0.305192619562 0.156441777945
      -0.904506981373 0.293872386217 0.309040635824
      -0.847377002239 0.275317341089 0.454040288925
      -0.769390821457 0.249983280897 0.587831676006
      -0.672455072403 0.218485280871 0.707155168056
      -0.558957576752 0.181619212031 0.809061765671
      -0.431722313166 0.140265449882 0.891033828259
      -0.293840557337 0.095464579761 0.951075315475
      -0.148750737309 0.0483119301498 0.98769390583
      -0.156410768628 -1.49164929297e-008 0.987692058086
      -0.308976322412 -2.94662800826e-008 0.951069712639
      -0.453939527273 -4.32910454151e-008 0.891032516956
      -0.587732434273 -5.60505348801e-008 0.809055328369
      -0.707061052322 -6.74305979942e-008 0.707152605057
      -0.808980226517 -7.71503607666e-008 0.587835967541
      -0.890982866287 -8.49707433304e-008 0.454036861658
      -0.951048851013 -9.06990891281e-008 0.309040516615
      -0.987687349319 -9.41932114529e-008 0.156440541148
      -1 -9.53674330617e-008 0
      -0.987687349319 -9.41932114529e-008 -0.156440541148
      -0.951048851013 -9.06990891281e-008 -0.309040516615
      -0.890982866287 -8.49707433304e-008 -0.454036861658
      -0.808980226517 -7.71503607666e-008 -0.587835967541
      -0.707045733929 -6.74291413816e-008 -0.707167804241
      -0.587732434273 -5.60505348801e-008 -0.809055328369
      -0.453939527273 -4.32910454151e-008 -0.891032516956
      -0.308976322412 -2.94662800826e-008 -0.951069712639
      -0.156410768628 -1.49164929297e-008 -0.987692058086
      -0.148750737309 -0.0483119599521 -0.98769390583
      -0.293840557337 -0.0954646393657 -0.951075315475
      -0.431722313166 -0.140265539289 -0.891033828259
      -0.558957576752 -0.181619301438 -0.809061765671
      -0.672455072403 -0.218485400081 -0.707155168056
      -0.769390821457 -0.249983429909 -0.587831676006
      -0.847376942635 -0.275317490101 -0.454040259123
      -0.904506981373 -0.293872535229 -0.309040635824
      -0.939352631569 -0.305192798376 -0.156441763043
      -0.951060712337 -0.309004038572 0
      -0.939352631569 -0.305192798376 0.156441763043
      -0.904506981373 -0.293872535229 0.309040635824
      -0.847376942635 -0.275317490101 0.454040259123
      -0.769390821457 -0.249983429909 0.587831676006
      -0.672455072403 -0.218485400081 0.707155168056
      -0.558957576752 -0.181619301438 0.809061765671
      -0.431722313166 -0.140265539289 0.891033828259
      -0.293840557337 -0.0954646393657 0.951075315475
      -0.148750737309 -0.0483119599521 0.98769390583
      -0.126532748342 -0.0919239446521 0.987693965435
      -0.249954178929 -0.181590661407 0.951077103615
      -0.367238491774 -0.266799598932 0.891040921211
      -0.475487202406 -0.345445483923 0.809060752392
      -0.57202398777 -0.415581882 0.707163572311
      -0.654489457607 -0.475493013859 0.587835013866
      -0.720811486244 -0.52371609211 0.454039871693
      -0.769414067268 -0.559016287327 0.309035211802
      -0.799060463905 -0.580541193485 0.156442731619
      -0.809030234814 -0.587767004967 0
      -0.799060463905 -0.580541193485 -0.156442731619
      -0.769414067268 -0.559016287327 -0.309035211802
      -0.720811486244 -0.52371609211 -0.454039871693
      -0.654489457607 -0.475493013859 -0.587835013866
      -0.57202398777 -0.415581882 -0.707163572311
      -0.475487202406 -0.345445483923 -0.809060752392
      -0.367238491774 -0.266799598932 -0.891040921211
      -0.249954178929 -0.181590661407 -0.951077103615
      -0.126532748342 -0.0919239446521 -0.987693965435
      -0.0919239372015 -0.126532748342 -0.987693965435
      -0.181590646505 -0.24995419383 -0.951077103615
      -0.266799539328 -0.367238521576 -0.891040921211
      -0.345445424318 -0.475487262011 -0.809060752392
      -0.415581852198 -0.57202398777 -0.707163572311
      -0.475492924452 -0.654489517212 -0.587835013866
      -0.523704528809 -0.720826208591 -0.454029858112
      -0.559016168118 -0.769414126873 -0.309035181999
      -0.580541133881 -0.799060463905 -0.156442731619
      -0.587766945362 -0.809030294418 0
      -0.580541133881 -0.799060463905 0.156442731619
      -0.559016168118 -0.769414126873 0.309035181999
      -0.523704528809 -0.720826208591 0.454029858112
      -0.475492924452 -0.654489517212 0.587835013866
      -0.415581852198 -0.57202398777 0.707163572311
      -0.345445424318 -0.475487262011 0.809060752392
      -0.266799539328 -0.367238521576 0.891040921211
      -0.181590646505 -0.24995419383 0.951077103615
      -0.0919239372015 -0.126532748342 0.987693965435
      -0.048311945051 -0.148750752211 0.98769390583
      -0.0954646095634 -0.293840587139 0.951075315475
      -0.140265509486 -0.43172237277 0.891033828259
      -0.181619256735 -0.558957576752 0.809061765671
      -0.218485325575 -0.672455072403 0.707155168056
      -0.249983355403 -0.769390881062 0.587831676006
      -0.275317400694 -0.847377061844 0.454040259123
      -0.293872416019 -0.904506981373 0.309040606022
      -0.305192708969 -0.939352631569 0.156441763043
      -0.309003889561 -0.951060712337 0
      -0.305192708969 -0.939352631569 -0.156441763043
      -0.293872416019 -0.904506981373 -0.309040606022
      -0.275317400694 -0.847377061844 -0.454040259123
      -0.249983355403 -0.769390881062 -0.587831676006
      -0.218485325575 -0.672455072403 -0.707155168056
      -0.181619256735 -0.558957576752 -0.809061765671
      -0.140265509486 -0.43172237277 -0.891033828259
      -0.0954646095634 -0.293840587139 -0.951075315475
      -0.048311945051 -0.148750752211 -0.98769390583
      0 -0.156410768628 -0.987692058086
      0 -0.308976322412 -0.951069712639
      0 -0.453939527273 -0.891032516956
      0 -0.587732434273 -0.809055328369
      0 -0.707045733929 -0.707167804241
      0 -0.808980226517 -0.587835967541
      0 -0.890982866287 -0.454036861658
      0 -0.951048851013 -0.309040516615
      0 -0.987687349319 -0.156440541148
      0 -1 0
      0 -0.987687349319 0.156440541148
      0 -0.951048851013 0.309040516615
      0 -0.890982866287 0.454036861658
      0 -0.808980226517 0.587835967541
      0 -0.707061052322 0.707152605057
      0 -0.587732434273 0.809055328369
      0 -0.453939527273 0.891032516956
      0 -0.308976322412 0.951069712639
      0 -0.156410768628 0.987692058086
      0.048311945051 -0.148750737309 0.98769390583
      0.0954646095634 -0.293840557337 0.951075315475
      0.140265509486 -0.431722313166 0.891033828259
      0.181619256735 -0.558957576752 0.809061765671
      0.218485325575 -0.672455072403 0.707155168056
      0.249983355403 -0.769390821457 0.587831676006
      0.275317400694 -0.847376942635 0.454040259123
      0.293872445822 -0.904506981373 0.309040635824
      0.305192738771 -0.939352631569 0.156441777945
      0.309003949165 -0.951060771942 0
      0.305192738771 -0.939352631569 -0.156441777945
      0.293872445822 -0.904506981373 -0.309040635824
      0.275317400694 -0.847376942635 -0.454040259123
      0.249983355403 -0.769390821457 -0.587831676006
      0.218485325575 -0.672455072403 -0.707155168056
      0.181619256735 -0.558957576752 -0.809061765671
      0.140265509486 -0.431722313166 -0.891033828259
      0.0954646095634 -0.293840557337 -0.951075315475
      0.048311945051 -0.148750737309 -0.98769390583
      0.0919239372015 -0.12653273344 -0.987693965435
      0.181590646505 -0.249954149127 -0.951077103615
      0.266799539328 -0.367238491774 -0.891040921211
      0.345445454121 -0.475487262011 -0.809060811996
      0.415581852198 -0.572023928165 -0.707163572311
      0.475492954254 -0.654489517212 -0.587835073471
      0.52371609211 -0.720811545849 -0.454039901495
      0.559016287327 -0.769414126873 -0.309035241604
      0.580541193485 -0.799060463905 -0.15644274652
      0.587767004967 -0.809030294418 0
      0.580541193485 -0.799060463905 0.15644274652
      0.559016287327 -0.769414126873 0.309035241604
      0.52371609211 -0.720811545849 0.454039901495
      0.475492954254 -0.654489517212 0.587835073471
      0.415581852198 -0.572023928165 0.707163572311
      0.345445454121 -0.475487262011 0.809060811996
      0.266799539328 -0.367238491774 0.891040921211
      0.181590646505 -0.249954149127 0.951077103615
      0.0919239372015 -0.12653273344 0.987693965435
      0.126532748342 -0.0919239223003 0.987693965435
      0.249954178929 -0.181590616703 0.951077103615
      0.367238491774 -0.266799509525 0.891040921211
      0.475487262011 -0.345445424318 0.809060811996
      0.57202398777 -0.415581792593 0.707163572311
      0.654489457607 -0.475492864847 0.587835013866
      0.720826208591 -0.523704528809 0.454029917717
      0.769414126873 -0.559016168118 0.309035241604
      0.79906052351 -0.580541133881 0.15644274652
      0.809030294418 -0.587766885757 0
      0.79906052351 -0.580541133881 -0.15644274652
      0.769414126873 -0.559016168118 -0.309035241604
      0.720826208591 -0.523704528809 -0.454029917717
      0.654489457607 -0.475492864847 -0.587835013866
      0.57202398777 -0.415581792593 -0.707163572311
      0.475487262011 -0.345445424318 -0.809060811996
      0.367238491774 -0.266799509525 -0.891040921211
      0.249954178929 -0.181590616703 -0.951077103615
      0.126532748342 -0.0919239223003 -0.987693965435
      0.148750737309 -0.0483119301498 -0.98769390583
      0.293840557337 -0.095464579761 -0.951075315475
      0.431722313166 -0.140265449882 -0.891033828259
      0.558957576752 -0.181619212031 -0.809061765671
      0.672455072403 -0.218485280871 -0.707155168056
      0.769390821457 -0.249983280897 -0.587831676006
      0.847377002239 -0.275317341089 -0.454040288925
      0.904506981373 -0.293872386217 -0.309040635824
      0.939352691174 -0.305192619562 -0.156441777945
      0.951060771942 -0.309003859758 0
      0.939352691174 -0.305192619562 0.156441777945
      0.904506981373 -0.293872386217 0.309040635824
      0.847377002239 -0.275317341089 0.454040288925
      0.769390821457 -0.249983280897 0.587831676006
      0.672455072403 -0.218485280871 0.707155168056
      0.558957576752 -0.181619212031 0.809061765671
      0.431722313166 -0.140265449882 0.891033828259
      0.293840557337 -0.095464579761 0.951075315475
      0.148750737309 -0.0483119301498 0.98769390583
      0 0 1
   uvs none
}


object {
   shader "right_sphere"
   type generic-mesh
   name "Sphere.001"
   points 382
      0.474470019341 0.0277756750584 0.285924524069
      0.49604845047 0.0277756750584 0.280744016171
      0.516550779343 0.0277756750584 0.272251665592
      0.535472214222 0.0277756750584 0.26065659523
      0.5523468256 0.0277756750584 0.246244311333
      0.566759109497 0.0277756750584 0.229369699955
      0.578354179859 0.0277756750584 0.210448265076
      0.586846530437 0.0277756750584 0.189945921302
      0.592027068138 0.0277756750584 0.168367475271
      0.593768179417 0.0277756750584 0.146244287491
      0.592027068138 0.0277756750584 0.124121114612
      0.586846530437 0.0277756750584 0.102542676032
      0.578354179859 0.0277756750584 0.0820403173566
      0.566759109497 0.0277756750584 0.0631188824773
      0.552346765995 0.0277756750584 0.0462442673743
      0.535472154617 0.0277756750584 0.0318319946527
      0.516550719738 0.0277756750584 0.0202369261533
      0.496048331261 0.0277756750584 0.0117445867509
      0.474469900131 0.0277756750584 0.00656407279894
      0.473387122154 0.0346120819449 0.00656406069174
      0.493909448385 0.0412801876664 0.0117445867509
      0.513408362865 0.0476157665253 0.0202369373292
      0.531403720379 0.0534628145397 0.0318319946527
      0.547452449799 0.0586773641407 0.0462442561984
      0.56115937233 0.0631310045719 0.0631188824773
      0.572186946869 0.0667140856385 0.0820403248072
      0.580263614655 0.0693383738399 0.102542683482
      0.585190594196 0.0709392428398 0.124121114612
      0.586846530437 0.071477279067 0.146244287491
      0.585190594196 0.0709392428398 0.168367475271
      0.580263674259 0.0693383738399 0.189945921302
      0.572186946869 0.0667140930891 0.210448265076
      0.56115937233 0.0631310194731 0.229369699955
      0.547452509403 0.0586773790419 0.246244311333
      0.531403779984 0.0534628368914 0.26065659523
      0.51340842247 0.047615788877 0.272251665592
      0.493909537792 0.0412802137434 0.280744016171
      0.473387211561 0.0346121117473 0.285924524069
      0.470244854689 0.0407793521881 0.285924524069
      0.487702161074 0.0534628368914 0.280744016171
      0.504288911819 0.0655138194561 0.272251665592
      0.5195966959 0.0766355544329 0.26065659523
      0.533248543739 0.0865542069077 0.246244311333
      0.544908285141 0.0950255319476 0.229369699955
      0.55428892374 0.101840935647 0.210448265076
      0.56115937233 0.106832623482 0.189945921302
      0.565350472927 0.109877660871 0.168367475271
      0.566759109497 0.110901072621 0.146244287491
      0.565350472927 0.109877660871 0.124121114612
      0.56115937233 0.106832616031 0.102542683482
      0.55428892374 0.101840935647 0.0820403248072
      0.544908285141 0.0950255095959 0.0631188824773
      0.533248484135 0.0865541771054 0.0462442561984
      0.519596636295 0.07663551718 0.0318319946527
      0.504288852215 0.0655137747526 0.0202369373292
      0.487702101469 0.0534627810121 0.0117445867509
      0.470244765282 0.0407792925835 0.00656406069174
      0.452346771955 0.0277755837888 0.0048229615204
      0.465350449085 0.0456736162305 0.00656406069174
      0.478033930063 0.0631309375167 0.0117445867509
      0.490084916353 0.0797177106142 0.0202369373292
      0.501206636429 0.0950254797935 0.0318319946527
      0.511125326157 0.108677335083 0.0462442561984
      0.519596636295 0.120337128639 0.0631188824773
      0.526412069798 0.129717752337 0.0820403248072
      0.531403720379 0.136588215828 0.102542683482
      0.534448802471 0.140779361129 0.124121114612
      0.535472214222 0.142187967896 0.146244287491
      0.534448802471 0.140779361129 0.168367475271
      0.531403779984 0.136588230729 0.189945921302
      0.526412069798 0.129717767239 0.210448265076
      0.5195966959 0.120337158442 0.229369699955
      0.511125326157 0.108677379787 0.246244311333
      0.501206696033 0.0950255319476 0.26065659523
      0.490084946156 0.0797177702188 0.272251665592
      0.478033989668 0.0631310194731 0.280744016171
      0.46535050869 0.0456737019122 0.285924524069
      0.4591832757 0.0488160662353 0.285924524069
      0.46585136652 0.0693383663893 0.280744016171
      0.472186923027 0.0888372585177 0.272251665592
      0.478033989668 0.106832616031 0.26065659523
      0.483248502016 0.122881323099 0.246244311333
      0.487702161074 0.136588230729 0.229369699955
      0.491285204887 0.147615775466 0.210448265076
      0.49390950799 0.155692487955 0.189945921302
      0.495510369539 0.160619467497 0.168367475271
      0.496048390865 0.162275373936 0.146244287491
      0.495510369539 0.160619467497 0.124121114612
      0.49390950799 0.155692473054 0.102542683482
      0.491285204887 0.147615760565 0.0820403248072
      0.487702131271 0.136588186026 0.0631188824773
      0.483248502016 0.122881270945 0.0462442561984
      0.478033959866 0.106832556427 0.0318319946527
      0.472186893225 0.0888371989131 0.0202369373292
      0.465851336718 0.0693382769823 0.0117445867509
      0.459183245897 0.0488159656525 0.00656406069174
      0.45234683156 0.0498987436295 0.00656406069174
      0.45234683156 0.0714771822095 0.0117445867509
      0.452346801758 0.0919795557857 0.0202369373292
      0.452346801758 0.110900990665 0.0318319946527
      0.452346801758 0.127775609493 0.0462442561984
      0.452346801758 0.142187908292 0.0631188824773
      0.452346801758 0.153782993555 0.0820403248072
      0.452346801758 0.162275344133 0.102542683482
      0.452346801758 0.167455896735 0.124121114612
      0.452346801758 0.169197008014 0.146244287491
      0.452346801758 0.167455896735 0.168367475271
      0.452346801758 0.162275359035 0.189945921302
      0.452346801758 0.153782993555 0.210448265076
      0.452346801758 0.142187952995 0.229369699955
      0.452346801758 0.127775669098 0.246244311333
      0.452346801758 0.11090105772 0.26065659523
      0.452346801758 0.0919796153903 0.272251665592
      0.45234683156 0.071477279067 0.280744016171
      0.45234683156 0.0498988479376 0.285924524069
      0.445510387421 0.04881606251 0.285924524069
      0.4388422966 0.0693383663893 0.280744016171
      0.432506710291 0.0888372436166 0.272251665592
      0.42665964365 0.106832608581 0.26065659523
      0.4214451015 0.122881308198 0.246244311333
      0.416991472244 0.136588200927 0.229369699955
      0.413408398628 0.147615745664 0.210448265076
      0.410784125328 0.155692473054 0.189945921302
      0.409183233976 0.160619452596 0.168367475271
      0.408645182848 0.162275329232 0.146244287491
      0.409183233976 0.160619452596 0.124121114612
      0.410784125328 0.155692458153 0.102542683482
      0.413408398628 0.147615745664 0.0820403248072
      0.416991472244 0.136588171124 0.0631188824773
      0.421445131302 0.122881256044 0.0462442561984
      0.426659673452 0.106832541525 0.0318319946527
      0.432506710291 0.0888371840119 0.0202369373292
      0.438842326403 0.0693382769823 0.0117445867509
      0.445510417223 0.0488159619272 0.00656406069174
      0.439343214035 0.0456736087799 0.00656406069174
      0.426659733057 0.0631309300661 0.0117445867509
      0.414608716965 0.0797176882625 0.0202369373292
      0.403486967087 0.0950254499912 0.0318319946527
      0.393568307161 0.108677297831 0.0462442561984
      0.38509696722 0.120337091386 0.0631188824773
      0.37828156352 0.129717722535 0.0820403248072
      0.373289883137 0.136588171124 0.102542683482
      0.370244830847 0.140779316425 0.124121114612
      0.369221419096 0.142187908292 0.146244287491
      0.370244830847 0.140779316425 0.168367475271
      0.373289883137 0.136588171124 0.189945921302
      0.37828156352 0.129717707634 0.210448265076
      0.38509696722 0.120337121189 0.229369699955
      0.393568277359 0.108677342534 0.246244311333
      0.403486937284 0.0950255021453 0.26065659523
      0.414608687162 0.0797177404165 0.272251665592
      0.426659673452 0.0631310045719 0.280744016171
      0.43934315443 0.0456736944616 0.285924524069
      0.434448808432 0.0407793447375 0.285924524069
      0.416991472244 0.053462818265 0.280744016171
      0.400404751301 0.0655137822032 0.272251665592
      0.38509696722 0.0766355246305 0.26065659523
      0.371445119381 0.0865541622043 0.246244311333
      0.359785348177 0.095025472343 0.229369699955
      0.35040473938 0.101840876043 0.210448265076
      0.343534290791 0.106832556427 0.189945921302
      0.339343130589 0.109877593815 0.168367475271
      0.337934553623 0.110900990665 0.146244287491
      0.339343130589 0.109877593815 0.124121114612
      0.343534290791 0.106832556427 0.102542683482
      0.35040473938 0.101840876043 0.0820403248072
      0.359785377979 0.0950254574418 0.0631188824773
      0.371445178986 0.0865541324019 0.0462442561984
      0.385097026825 0.0766354799271 0.0318319946527
      0.400404781103 0.0655137449503 0.0202369373292
      0.416991561651 0.0534627623856 0.0117445867509
      0.434448897839 0.0407792814076 0.00656406069174
      0.431306540966 0.0346120707691 0.00656406069174
      0.410784214735 0.0412801653147 0.0117445867509
      0.391285300255 0.0476157329977 0.0202369373292
      0.373289942741 0.0534627735615 0.0318319946527
      0.357241243124 0.0586773119867 0.0462442561984
      0.343534320593 0.0631309449673 0.0631188824773
      0.332506746054 0.0667140260339 0.0820403248072
      0.324430048466 0.0693383067846 0.102542683482
      0.319503039122 0.070939168334 0.124121114612
      0.317847162485 0.0714772045612 0.146244287491
      0.319503039122 0.070939168334 0.168367475271
      0.324430018663 0.0693383067846 0.189945921302
      0.332506746054 0.0667140185833 0.210448265076
      0.343534290791 0.0631309524179 0.229369699955
      0.357241183519 0.0586773268878 0.246244311333
      0.373289883137 0.0534627959132 0.26065659523
      0.39128524065 0.0476157516241 0.272251665592
      0.410784125328 0.041280195117 0.280744016171
      0.431306451559 0.0346121042967 0.285924524069
      0.43022364378 0.0277756657451 0.285924524069
      0.408645242453 0.0277756564319 0.280744016171
      0.38814291358 0.0277756415308 0.272251665592
      0.369221448898 0.0277756340802 0.26065659523
      0.352346867323 0.0277756284922 0.246244311333
      0.337934583426 0.0277756117284 0.229369699955
      0.326339513063 0.0277756117284 0.210448265076
      0.317847162485 0.0277756154537 0.189945921302
      0.312666624784 0.0277756005526 0.168367475271
      0.310925513506 0.0277756024152 0.146244287491
      0.312666624784 0.0277756005526 0.124121114612
      0.317847162485 0.0277756154537 0.102542683482
      0.326339513063 0.0277756173164 0.0820403248072
      0.337934613228 0.0277756210417 0.0631188824773
      0.352346897125 0.0277756284922 0.0462442561984
      0.369221508503 0.0277756340802 0.0318319946527
      0.388142973185 0.0277756415308 0.0202369373292
      0.40864533186 0.0277756564319 0.0117445867509
      0.430223762989 0.0277756638825 0.00656406069174
      0.431306540966 0.0209392607212 0.00656406069174
      0.410784244537 0.0142711484805 0.0117445867509
      0.391285330057 0.00793555378914 0.0202369373292
      0.373289972544 0.00208849878982 0.0318319946527
      0.357241272926 -0.00312604941428 0.0462442561984
      0.343534380198 -0.00757969962433 0.0631188824773
      0.332506775856 -0.0111627848819 0.0820403248072
      0.324430078268 -0.0137870674953 0.102542683482
      0.319503098726 -0.015387958847 0.124121114612
      0.31784722209 -0.0159259866923 0.146244287491
      0.319503098726 -0.015387958847 0.168367475271
      0.324430078268 -0.0137870702893 0.189945921302
      0.332506775856 -0.0111627914011 0.210448265076
      0.343534320593 -0.00757972337306 0.229369699955
      0.357241213322 -0.00312606431544 0.246244311333
      0.373289912939 0.00208847783506 0.26065659523
      0.391285270452 0.00793553516269 0.272251665592
      0.41078415513 0.0142711186782 0.280744016171
      0.431306451559 0.0209392271936 0.285924524069
      0.434448808432 0.014771990478 0.285924524069
      0.416991502047 0.00208850461058 0.280744016171
      0.400404781103 -0.0099624786526 0.272251665592
      0.385097026825 -0.0210842341185 0.26065659523
      0.371445178986 -0.0310028791428 0.246244311333
      0.359785407782 -0.0394742190838 0.229369699955
      0.350404828787 -0.0462896227837 0.210448265076
      0.343534350395 -0.0512813031673 0.189945921302
      0.339343219995 -0.0543263554573 0.168367475271
      0.33793464303 -0.0553497523069 0.146244287491
      0.339343219995 -0.0543263554573 0.124121114612
      0.343534380198 -0.0512812994421 0.102542683482
      0.350404828787 -0.0462896190584 0.0820403248072
      0.359785437584 -0.0394741892815 0.0631188824773
      0.37144523859 -0.0310028493404 0.0462442561984
      0.38509708643 -0.0210841968656 0.0318319946527
      0.400404840708 -0.00996244326234 0.0202369373292
      0.416991591454 0.00208855839446 0.0117445867509
      0.434448897839 0.0147720528767 0.00656406069174
      0.439343243837 0.00987773109227 0.00656406069174
      0.426659762859 -0.0075795953162 0.0117445867509
      0.414608776569 -0.0241663698107 0.0202369373292
      0.403487056494 -0.0394741408527 0.0318319946527
      0.393568396568 -0.0531259961426 0.0462442561984
      0.38509708643 -0.0647857934237 0.0631188824773
      0.378281652927 -0.0741664096713 0.0820403248072
      0.373289972544 -0.0810368731618 0.102542683482
      0.370244950056 -0.0852280333638 0.124121114612
      0.369221568108 -0.0866366103292 0.146244287491
      0.370244950056 -0.0852280333638 0.168367475271
      0.373289972544 -0.081036888063 0.189945921302
      0.378281652927 -0.0741664245725 0.210448265076
      0.385097056627 -0.0647858306766 0.229369699955
      0.393568366766 -0.0531260371208 0.246244311333
      0.403486996889 -0.039474196732 0.26065659523
      0.414608746767 -0.0241664182395 0.272251665592
      0.426659703255 -0.00757966982201 0.280744016171
      0.43934315443 0.00987764447927 0.285924524069
      0.445510417223 0.0067352829501 0.285924524069
      0.438842326403 -0.0137870172039 0.280744016171
      0.432506769896 -0.0332858972251 0.272251665592
      0.426659733057 -0.0512812696397 0.26065659523
      0.421445190907 -0.0673299655318 0.246244311333
      0.416991591454 -0.0810368582606 0.229369699955
      0.413408517838 -0.0920644104481 0.210448265076
      0.410784214735 -0.100141130388 0.189945921302
      0.409183353186 -0.10506811738 0.168367475271
      0.408645361662 -0.106723994017 0.146244287491
      0.409183353186 -0.10506811738 0.124121114612
      0.410784244537 -0.100141115487 0.102542683482
      0.413408517838 -0.0920644104481 0.0820403248072
      0.416991591454 -0.0810368284583 0.0631188824773
      0.421445220709 -0.0673299208283 0.0462442561984
      0.426659762859 -0.0512812025845 0.0318319946527
      0.432506799698 -0.0332858450711 0.0202369373292
      0.438842356205 -0.0137869277969 0.0117445867509
      0.445510447025 0.0067353839986 0.00656406069174
      0.452346861362 0.00565260928124 0.00656406069174
      0.452346861362 -0.0159258227795 0.0117445867509
      0.452346891165 -0.0364281907678 0.0202369373292
      0.452346891165 -0.0553496256471 0.0318319946527
      0.452346920967 -0.0722242444754 0.0462442561984
      0.452346920967 -0.0866365358233 0.0631188824773
      0.452346920967 -0.0982316210866 0.0820403248072
      0.452346920967 -0.106723971665 0.102542683482
      0.452346920967 -0.111904524267 0.124121114612
      0.452346950769 -0.113645605743 0.146244287491
      0.452346920967 -0.111904524267 0.168367475271
      0.452346920967 -0.106723986566 0.189945921302
      0.452346920967 -0.0982316210866 0.210448265076
      0.452346920967 -0.0866365656257 0.229369699955
      0.452346891165 -0.0722242891788 0.246244311333
      0.452346891165 -0.0553496927023 0.26065659523
      0.452346891165 -0.0364282429218 0.272251665592
      0.452346861362 -0.0159259140491 0.280744016171
      0.452346861362 0.00565250311047 0.285924524069
      0.4591832757 0.00673529459164 0.285924524069
      0.465851396322 -0.0137869957834 0.280744016171
      0.472186982632 -0.0332858636975 0.272251665592
      0.478034049273 -0.051281221211 0.26065659523
      0.483248591423 -0.0673299208283 0.246244311333
      0.487702250481 -0.081036798656 0.229369699955
      0.491285324097 -0.0920643508434 0.210448265076
      0.493909597397 -0.100141070783 0.189945921302
      0.495510488749 -0.105068050325 0.168367475271
      0.496048510075 -0.106723926961 0.146244287491
      0.495510488749 -0.105068050325 0.124121114612
      0.493909597397 -0.100141055882 0.102542683482
      0.491285324097 -0.0920643508434 0.0820403248072
      0.487702220678 -0.0810367763042 0.0631188824773
      0.483248591423 -0.0673298761249 0.0462442561984
      0.47803401947 -0.0512811616063 0.0318319946527
      0.472186952829 -0.0332858078182 0.0202369373292
      0.46585136652 -0.0137869091704 0.0117445867509
      0.459183245897 0.00673539470881 0.00656406069174
      0.465350449085 0.00987774971873 0.00656406069174
      0.478033959866 -0.00757955946028 0.0117445867509
      0.490084946156 -0.0241663046181 0.0202369373292
      0.501206696033 -0.0394740588963 0.0318319946527
      0.511125385761 -0.0531259067357 0.0462442561984
      0.5195966959 -0.0647856965661 0.0631188824773
      0.526412129402 -0.0741663053632 0.0820403248072
      0.531403839588 -0.0810367539525 0.102542683482
      0.534448862076 -0.0852278992534 0.124121114612
      0.535472273827 -0.0866364762187 0.146244287491
      0.534448862076 -0.0852278992534 0.168367475271
      0.531403839588 -0.0810367688537 0.189945921302
      0.526412129402 -0.0741663053632 0.210448265076
      0.519596755505 -0.0647857114673 0.229369699955
      0.511125385761 -0.0531259477139 0.246244311333
      0.501206755638 -0.0394741110504 0.26065659523
      0.49008500576 -0.0241663530469 0.272251665592
      0.47803401947 -0.00757963396609 0.280744016171
      0.46535050869 0.00987766496837 0.285924524069
      0.470244854689 0.0147720174864 0.285924524069
      0.487702190876 0.00208855234087 0.280744016171
      0.504288911819 -0.0099623920396 0.272251665592
      0.5195966959 -0.0210841242224 0.26065659523
      0.533248543739 -0.0310027599335 0.246244311333
      0.544908344746 -0.0394740663469 0.229369699955
      0.55428892374 -0.0462894625962 0.210448265076
      0.56115937233 -0.0512811429799 0.189945921302
      0.565350532532 -0.0543261766434 0.168367475271
      0.566759109497 -0.0553495660424 0.146244287491
      0.565350532532 -0.0543261766434 0.124121114612
      0.56115937233 -0.0512811392546 0.102542683482
      0.55428892374 -0.0462894625962 0.0820403248072
      0.544908285141 -0.0394740588963 0.0631188824773
      0.533248543739 -0.0310027301311 0.0462442561984
      0.519596636295 -0.0210840851068 0.0318319946527
      0.504288852215 -0.00996235664934 0.0202369373292
      0.487702101469 0.00208860891871 0.0117445867509
      0.470244765282 0.014772079885 0.00656406069174
      0.473387122154 0.0209392923862 0.00656406069174
      0.493909418583 0.0142712052912 0.0117445867509
      0.513408362865 0.00793565157801 0.0202369373292
      0.531403720379 0.00208862079307 0.0318319946527
      0.547452449799 -0.00312590948306 0.0462442561984
      0.561159312725 -0.00757954781875 0.0631188824773
      0.572186946869 -0.0111626097932 0.0820403248072
      0.580263614655 -0.0137868886814 0.102542683482
      0.585190653801 -0.0153877502307 0.124121114612
      0.586846530437 -0.0159257743508 0.146244287491
      0.585190653801 -0.0153877502307 0.168367475271
      0.580263614655 -0.0137868886814 0.189945921302
      0.572186946869 -0.0111626097932 0.210448265076
      0.56115937233 -0.00757954781875 0.229369699955
      0.547452449799 -0.00312592741102 0.246244311333
      0.531403779984 0.00208860309795 0.26065659523
      0.51340842247 0.00793563202024 0.272251665592
      0.49390950799 0.0142711745575 0.280744016171
      0.473387211561 0.0209392588586 0.285924524069
      0.45234683156 0.0277756750584 0.28766566515
   triangles 760
      57 19 18
      18 19 20
      18 20 17
      17 20 21
      17 21 16
      16 21 22
      16 22 15
      15 22 23
      15 23 14
      14 23 24
      14 24 13
      13 24 25
      13 25 12
      12 25 26
      12 26 11
      11 26 27
      11 27 10
      10 27 28
      10 28 9
      9 28 29
      9 29 8
      8 29 30
      8 30 7
      7 30 31
      7 31 6
      6 31 32
      6 32 5
      5 32 33
      5 33 4
      4 33 34
      4 34 3
      3 34 35
      3 35 2
      2 35 36
      2 36 1
      37 0 1
      37 1 36
      0 37 381
      37 38 381
      36 39 38
      36 38 37
      35 40 39
      35 39 36
      34 41 40
      34 40 35
      33 42 41
      33 41 34
      32 43 42
      32 42 33
      31 44 43
      31 43 32
      30 45 44
      30 44 31
      29 46 45
      29 45 30
      28 47 46
      28 46 29
      27 48 47
      27 47 28
      26 49 48
      26 48 27
      25 50 49
      25 49 26
      24 51 50
      24 50 25
      23 52 51
      23 51 24
      22 53 52
      22 52 23
      21 54 53
      21 53 22
      20 55 54
      20 54 21
      19 56 55
      19 55 20
      57 56 19
      57 58 56
      56 58 59
      56 59 55
      55 59 60
      55 60 54
      54 60 61
      54 61 53
      53 61 62
      53 62 52
      52 62 63
      52 63 51
      51 63 64
      51 64 50
      50 64 65
      50 65 49
      49 65 66
      49 66 48
      48 66 67
      48 67 47
      47 67 68
      47 68 46
      46 68 69
      46 69 45
      45 69 70
      45 70 44
      44 70 71
      44 71 43
      43 71 72
      43 72 42
      42 72 73
      42 73 41
      41 73 74
      41 74 40
      40 74 75
      40 75 39
      39 75 76
      39 76 38
      38 76 381
      76 77 381
      75 78 77
      75 77 76
      74 79 78
      74 78 75
      73 80 79
      73 79 74
      72 81 80
      72 80 73
      71 82 81
      71 81 72
      70 83 82
      70 82 71
      69 84 83
      69 83 70
      68 85 84
      68 84 69
      67 86 85
      67 85 68
      66 87 86
      66 86 67
      65 88 87
      65 87 66
      64 89 88
      64 88 65
      63 90 89
      63 89 64
      62 91 90
      62 90 63
      61 92 91
      61 91 62
      60 93 92
      60 92 61
      59 94 93
      59 93 60
      58 95 94
      58 94 59
      57 95 58
      57 96 95
      95 96 97
      95 97 94
      94 97 98
      94 98 93
      93 98 99
      93 99 92
      92 99 100
      92 100 91
      91 100 101
      91 101 90
      90 101 102
      90 102 89
      89 102 103
      89 103 88
      88 103 104
      88 104 87
      87 104 105
      87 105 86
      86 105 106
      86 106 85
      85 106 107
      85 107 84
      84 107 108
      84 108 83
      83 108 109
      83 109 82
      82 109 110
      82 110 81
      81 110 111
      81 111 80
      80 111 112
      80 112 79
      79 112 113
      79 113 78
      78 113 114
      78 114 77
      77 114 381
      114 115 381
      113 116 115
      113 115 114
      112 117 116
      112 116 113
      111 118 117
      111 117 112
      110 119 118
      110 118 111
      109 120 119
      109 119 110
      108 121 120
      108 120 109
      107 122 121
      107 121 108
      106 123 122
      106 122 107
      105 124 123
      105 123 106
      104 125 124
      104 124 105
      103 126 125
      103 125 104
      102 127 126
      102 126 103
      101 128 127
      101 127 102
      100 129 128
      100 128 101
      99 130 129
      99 129 100
      98 131 130
      98 130 99
      97 132 131
      97 131 98
      96 133 132
      96 132 97
      57 133 96
      57 134 133
      133 134 135
      133 135 132
      132 135 136
      132 136 131
      131 136 137
      131 137 130
      130 137 138
      130 138 129
      129 138 139
      129 139 128
      128 139 140
      128 140 127
      127 140 141
      127 141 126
      126 141 142
      126 142 125
      125 142 143
      125 143 124
      124 143 144
      124 144 123
      123 144 145
      123 145 122
      122 145 146
      122 146 121
      121 146 147
      121 147 120
      120 147 148
      120 148 119
      119 148 149
      119 149 118
      118 149 150
      118 150 117
      117 150 151
      117 151 116
      116 151 152
      116 152 115
      115 152 381
      152 153 381
      151 154 153
      151 153 152
      150 155 154
      150 154 151
      149 156 155
      149 155 150
      148 157 156
      148 156 149
      147 158 157
      147 157 148
      146 159 158
      146 158 147
      145 160 159
      145 159 146
      144 161 160
      144 160 145
      143 162 161
      143 161 144
      142 163 162
      142 162 143
      141 164 163
      141 163 142
      140 165 164
      140 164 141
      139 166 165
      139 165 140
      138 167 166
      138 166 139
      137 168 167
      137 167 138
      136 169 168
      136 168 137
      135 170 169
      135 169 136
      134 171 170
      134 170 135
      57 171 134
      57 172 171
      171 172 173
      171 173 170
      170 173 174
      170 174 169
      169 174 175
      169 175 168
      168 175 176
      168 176 167
      167 176 177
      167 177 166
      166 177 178
      166 178 165
      165 178 179
      165 179 164
      164 179 180
      164 180 163
      163 180 181
      163 181 162
      162 181 182
      162 182 161
      161 182 183
      161 183 160
      160 183 184
      160 184 159
      159 184 185
      159 185 158
      158 185 186
      158 186 157
      157 186 187
      157 187 156
      156 187 188
      156 188 155
      155 188 189
      155 189 154
      154 189 190
      154 190 153
      153 190 381
      190 191 381
      189 192 191
      189 191 190
      188 193 192
      188 192 189
      187 194 193
      187 193 188
      186 195 194
      186 194 187
      185 196 195
      185 195 186
      184 197 196
      184 196 185
      183 198 197
      183 197 184
      182 199 198
      182 198 183
      181 200 199
      181 199 182
      180 201 200
      180 200 181
      179 202 201
      179 201 180
      178 203 202
      178 202 179
      177 204 203
      177 203 178
      176 205 204
      176 204 177
      175 206 205
      175 205 176
      174 207 206
      174 206 175
      173 208 207
      173 207 174
      172 209 208
      172 208 173
      57 209 172
      57 210 209
      209 210 211
      209 211 208
      208 211 212
      208 212 207
      207 212 213
      207 213 206
      206 213 214
      206 214 205
      205 214 215
      205 215 204
      204 215 216
      204 216 203
      203 216 217
      203 217 202
      202 217 218
      202 218 201
      201 218 219
      201 219 200
      200 219 220
      200 220 199
      199 220 221
      199 221 198
      198 221 222
      198 222 197
      197 222 223
      197 223 196
      196 223 224
      196 224 195
      195 224 225
      195 225 194
      194 225 226
      194 226 193
      193 226 227
      193 227 192
      192 227 228
      192 228 191
      191 228 381
      228 229 381
      227 230 229
      227 229 228
      226 231 230
      226 230 227
      225 232 231
      225 231 226
      224 233 232
      224 232 225
      223 234 233
      223 233 224
      222 235 234
      222 234 223
      221 236 235
      221 235 222
      220 237 236
      220 236 221
      219 238 237
      219 237 220
      218 239 238
      218 238 219
      217 240 239
      217 239 218
      216 241 240
      216 240 217
      215 242 241
      215 241 216
      214 243 242
      214 242 215
      213 244 243
      213 243 214
      212 245 244
      212 244 213
      211 246 245
      211 245 212
      210 247 246
      210 246 211
      57 247 210
      57 248 247
      247 248 249
      247 249 246
      246 249 250
      246 250 245
      245 250 251
      245 251 244
      244 251 252
      244 252 243
      243 252 253
      243 253 242
      242 253 254
      242 254 241
      241 254 255
      241 255 240
      240 255 256
      240 256 239
      239 256 257
      239 257 238
      238 257 258
      238 258 237
      237 258 259
      237 259 236
      236 259 260
      236 260 235
      235 260 261
      235 261 234
      234 261 262
      234 262 233
      233 262 263
      233 263 232
      232 263 264
      232 264 231
      231 264 265
      231 265 230
      230 265 266
      230 266 229
      229 266 381
      266 267 381
      265 268 267
      265 267 266
      264 269 268
      264 268 265
      263 270 269
      263 269 264
      262 271 270
      262 270 263
      261 272 271
      261 271 262
      260 273 272
      260 272 261
      259 274 273
      259 273 260
      258 275 274
      258 274 259
      257 276 275
      257 275 258
      256 277 276
      256 276 257
      255 278 277
      255 277 256
      254 279 278
      254 278 255
      253 280 279
      253 279 254
      252 281 280
      252 280 253
      251 282 281
      251 281 252
      250 283 282
      250 282 251
      249 284 283
      249 283 250
      248 285 284
      248 284 249
      57 285 248
      57 286 285
      285 286 287
      285 287 284
      284 287 288
      284 288 283
      283 288 289
      283 289 282
      282 289 290
      282 290 281
      281 290 291
      281 291 280
      280 291 292
      280 292 279
      279 292 293
      279 293 278
      278 293 294
      278 294 277
      277 294 295
      277 295 276
      276 295 296
      276 296 275
      275 296 297
      275 297 274
      274 297 298
      274 298 273
      273 298 299
      273 299 272
      272 299 300
      272 300 271
      271 300 301
      271 301 270
      270 301 302
      270 302 269
      269 302 303
      269 303 268
      268 303 304
      268 304 267
      267 304 381
      304 305 381
      303 306 305
      303 305 304
      302 307 306
      302 306 303
      301 308 307
      301 307 302
      300 309 308
      300 308 301
      299 310 309
      299 309 300
      298 311 310
      298 310 299
      297 312 311
      297 311 298
      296 313 312
      296 312 297
      295 314 313
      295 313 296
      294 315 314
      294 314 295
      293 316 315
      293 315 294
      292 317 316
      292 316 293
      291 318 317
      291 317 292
      290 319 318
      290 318 291
      289 320 319
      289 319 290
      288 321 320
      288 320 289
      287 322 321
      287 321 288
      286 323 322
      286 322 287
      57 323 286
      57 324 323
      323 324 325
      323 325 322
      322 325 326
      322 326 321
      321 326 327
      321 327 320
      320 327 328
      320 328 319
      319 328 329
      319 329 318
      318 329 330
      318 330 317
      317 330 331
      317 331 316
      316 331 332
      316 332 315
      315 332 333
      315 333 314
      314 333 334
      314 334 313
      313 334 335
      313 335 312
      312 335 336
      312 336 311
      311 336 337
      311 337 310
      310 337 338
      310 338 309
      309 338 339
      309 339 308
      308 339 340
      308 340 307
      307 340 341
      307 341 306
      306 341 342
      306 342 305
      305 342 381
      342 343 381
      341 344 343
      341 343 342
      340 345 344
      340 344 341
      339 346 345
      339 345 340
      338 347 346
      338 346 339
      337 348 347
      337 347 338
      336 349 348
      336 348 337
      335 350 349
      335 349 336
      334 351 350
      334 350 335
      333 352 351
      333 351 334
      332 353 352
      332 352 333
      331 354 353
      331 353 332
      330 355 354
      330 354 331
      329 356 355
      329 355 330
      328 357 356
      328 356 329
      327 358 357
      327 357 328
      326 359 358
      326 358 327
      325 360 359
      325 359 326
      324 361 360
      324 360 325
      57 361 324
      57 362 361
      361 362 363
      361 363 360
      360 363 364
      360 364 359
      359 364 365
      359 365 358
      358 365 366
      358 366 357
      357 366 367
      357 367 356
      356 367 368
      356 368 355
      355 368 369
      355 369 354
      354 369 370
      354 370 353
      353 370 371
      353 371 352
      352 371 372
      352 372 351
      351 372 373
      351 373 350
      350 373 374
      350 374 349
      349 374 375
      349 375 348
      348 375 376
      348 376 347
      347 376 377
      347 377 346
      346 377 378
      346 378 345
      345 378 379
      345 379 344
      344 379 380
      344 380 343
      343 380 381
      380 0 381
      0 380 379
      0 379 1
      378 2 1
      378 1 379
      377 3 2
      377 2 378
      376 4 3
      376 3 377
      375 5 4
      375 4 376
      374 6 5
      374 5 375
      373 7 6
      373 6 374
      372 8 7
      372 7 373
      371 9 8
      371 8 372
      370 10 9
      370 9 371
      369 11 10
      369 10 370
      368 12 11
      368 11 369
      367 13 12
      367 12 368
      366 14 13
      366 13 367
      365 15 14
      365 14 366
      364 16 15
      364 15 365
      363 17 16
      363 16 364
      362 18 17
      362 17 363
      57 18 362
   normals vertex
      0.156410753727 0 0.987692058086
      0.308976322412 0 0.951069712639
      0.453939467669 0 0.891032516956
      0.587732434273 0 0.809055328369
      0.707045733929 0 0.707167804241
      0.808980226517 0 0.587835967541
      0.890982866287 0 0.454036861658
      0.951048851013 0 0.309040516615
      0.987687349319 0 0.156440541148
      1 0 0
      0.987687349319 0 -0.156440541148
      0.951048851013 0 -0.309040516615
      0.890982866287 0 -0.454036861658
      0.808980226517 0 -0.587835967541
      0.707045793533 0 -0.707167804241
      0.587732493877 0 -0.809055328369
      0.453939527273 0 -0.891032516956
      0.308976352215 0 -0.951069712639
      0.15641079843 0 -0.987692058086
      0.148750752211 0.048311945051 -0.98769390583
      0.293840587139 0.0954646095634 -0.951075315475
      0.43172237277 0.140265509486 -0.891033828259
      0.558957576752 0.181619256735 -0.809061765671
      0.672455072403 0.218485325575 -0.707155168056
      0.769390881062 0.249983355403 -0.587831676006
      0.847376942635 0.275317400694 -0.454040259123
      0.904506981373 0.293872445822 -0.309040635824
      0.939352631569 0.305192708969 -0.156441763043
      0.951060771942 0.309003949165 0
      0.939352631569 0.305192708969 0.156441763043
      0.904506981373 0.293872445822 0.309040635824
      0.847376942635 0.275317400694 0.454040259123
      0.769390821457 0.249983355403 0.587831676006
      0.672455072403 0.218485325575 0.707155168056
      0.558957576752 0.181619256735 0.809061765671
      0.431722313166 0.140265509486 0.891033828259
      0.293840527534 0.0954646095634 0.951075315475
      0.148750707507 0.048311945051 0.98769390583
      0.12653273344 0.0919239446521 0.987694084644
      0.249954149127 0.181590646505 0.951077103615
      0.367238491774 0.266799539328 0.891040921211
      0.475487262011 0.345445454121 0.809060811996
      0.57202398777 0.415581852198 0.707163572311
      0.654489517212 0.475492954254 0.587835073471
      0.720826208591 0.523704528809 0.454029917717
      0.769414067268 0.559016227722 0.309035211802
      0.799060463905 0.580541133881 0.156442731619
      0.809030294418 0.587766945362 0
      0.799060463905 0.580541133881 -0.156442731619
      0.769414126873 0.559016227722 -0.309035211802
      0.720826208591 0.523704528809 -0.454029917717
      0.654489457607 0.475492924452 -0.587835013866
      0.57202398777 0.415581852198 -0.707163572311
      0.475487262011 0.345445424318 -0.809060752392
      0.367238521576 0.266799539328 -0.891040921211
      0.24995419383 0.181590646505 -0.951077103615
      0.126532763243 0.0919239372015 -0.987693965435
      2.38418582654e-008 0 -1
      0.0919239595532 0.126532748342 -0.987693965435
      0.181590661407 0.249954178929 -0.951077103615
      0.26679956913 0.367238491774 -0.891040921211
      0.345445454121 0.475487202406 -0.809060752392
      0.415581882 0.57202398777 -0.707163572311
      0.475492954254 0.654489457607 -0.587835013866
      0.523704528809 0.720826208591 -0.454029917717
      0.559016227722 0.769414067268 -0.309035211802
      0.580541133881 0.799060463905 -0.156442731619
      0.587766945362 0.809030294418 0
      0.580541133881 0.799060463905 0.156442731619
      0.559016227722 0.769414126873 0.309035241604
      0.523704528809 0.720826208591 0.454029917717
      0.475492924452 0.654489457607 0.587835013866
      0.415581852198 0.57202398777 0.707163572311
      0.345445454121 0.475487262011 0.809060811996
      0.266799509525 0.367238491774 0.891040921211
      0.181590616703 0.249954178929 0.951077103615
      0.0919239223003 0.126532763243 0.987694084644
      0.0483119189739 0.148750737309 0.98769390583
      0.0954645872116 0.293840557337 0.951075315475
      0.140265479684 0.431722313166 0.891033828259
      0.181619226933 0.558957576752 0.809061765671
      0.218485325575 0.672455072403 0.707155168056
      0.249983340502 0.769390821457 0.587831676006
      0.275317400694 0.847376942635 0.454040259123
      0.293872445822 0.904506981373 0.309040635824
      0.305192708969 0.939352631569 0.156441763043
      0.309003949165 0.951060771942 0
      0.305192708969 0.939352631569 -0.156441763043
      0.293872475624 0.904506981373 -0.309040635824
      0.275317400694 0.847376942635 -0.454040259123
      0.249983385205 0.769390821457 -0.587831676006
      0.218485355377 0.672455072403 -0.707155168056
      0.181619271636 0.558957576752 -0.809061765671
      0.140265524387 0.431722313166 -0.891033828259
      0.0954646393657 0.293840557337 -0.951075315475
      0.0483119674027 0.148750737309 -0.98769390583
      2.35484147737e-008 0.156410768628 -0.987692058086
      2.26752696619e-008 0.308976322412 -0.951069712639
      2.12438706626e-008 0.453939527273 -0.891032516956
      1.92893825357e-008 0.587732434273 -0.809055328369
      1.68601950179e-008 0.707045733929 -0.707167804241
      1.40151010797e-008 0.808980226517 -0.587835967541
      1.0825082164e-008 0.890982866287 -0.454036861658
      7.36810035207e-009 0.951048851013 -0.309040516615
      3.72983333108e-009 0.987687349319 -0.156440541148
      0 1 0
      -3.72983333108e-009 0.987687349319 0.156440541148
      -7.36810035207e-009 0.951048851013 0.309040516615
      -1.0825082164e-008 0.890982866287 0.454036861658
      -1.40151010797e-008 0.808980226517 0.587835967541
      -1.68601950179e-008 0.707045733929 0.707167804241
      -1.92893825357e-008 0.587732434273 0.809055328369
      -2.12438706626e-008 0.453939527273 0.891032516956
      -2.26752696619e-008 0.308976322412 0.951069712639
      -2.35484147737e-008 0.156410768628 0.987692058086
      -0.0483119674027 0.148750737309 0.98769390583
      -0.0954646393657 0.293840557337 0.951075315475
      -0.140265524387 0.431722313166 0.891033828259
      -0.181619271636 0.558957576752 0.809061765671
      -0.218485355377 0.672455072403 0.707155168056
      -0.249983385205 0.769390821457 0.587831676006
      -0.275317400694 0.847376942635 0.454040259123
      -0.293872475624 0.904506981373 0.309040635824
      -0.305192708969 0.939352631569 0.156441763043
      -0.309003949165 0.951060771942 0
      -0.305192708969 0.939352631569 -0.156441763043
      -0.293872445822 0.904506981373 -0.309040635824
      -0.275317400694 0.847376942635 -0.454040259123
      -0.249983340502 0.769390821457 -0.587831676006
      -0.218485325575 0.672455072403 -0.707155168056
      -0.181619226933 0.558957576752 -0.809061765671
      -0.140265479684 0.431722313166 -0.891033828259
      -0.0954645872116 0.293840557337 -0.951075315475
      -0.0483119189739 0.148750737309 -0.98769390583
      -0.0919239223003 0.126532763243 -0.987694084644
      -0.181590616703 0.249954178929 -0.951077103615
      -0.266799509525 0.367238491774 -0.891040921211
      -0.345445454121 0.475487262011 -0.809060811996
      -0.415581852198 0.57202398777 -0.707163572311
      -0.475492924452 0.654489457607 -0.587835013866
      -0.523716032505 0.720811486244 -0.454039871693
      -0.559016227722 0.769414126873 -0.309035241604
      -0.580541133881 0.799060463905 -0.156442731619
      -0.587766945362 0.809030294418 0
      -0.580541133881 0.799060463905 0.156442731619
      -0.559016227722 0.769414067268 0.309035211802
      -0.523704528809 0.720826208591 0.454029917717
      -0.475492954254 0.654489457607 0.587835013866
      -0.415581882 0.57202398777 0.707163572311
      -0.345445454121 0.475487202406 0.809060752392
      -0.26679956913 0.367238491774 0.891040921211
      -0.181590661407 0.249954178929 0.951077103615
      -0.0919239595532 0.126532748342 0.987693965435
      -0.126532763243 0.0919239372015 0.987693965435
      -0.24995419383 0.181590646505 0.951077103615
      -0.367238521576 0.266799539328 0.891040921211
      -0.475487262011 0.345445424318 0.809060752392
      -0.57202398777 0.415581852198 0.707163572311
      -0.654489457607 0.475492924452 0.587835013866
      -0.720826208591 0.523704528809 0.454029917717
      -0.769414126873 0.559016227722 0.309035211802
      -0.799060463905 0.580541133881 0.156442731619
      -0.809030294418 0.587766945362 0
      -0.799060463905 0.580541133881 -0.156442731619
      -0.769414067268 0.559016227722 -0.309035211802
      -0.720826208591 0.523704528809 -0.454029917717
      -0.654489517212 0.475492954254 -0.587835073471
      -0.57202398777 0.415581852198 -0.707163572311
      -0.475487262011 0.345445454121 -0.809060811996
      -0.367238491774 0.266799539328 -0.891040921211
      -0.249954149127 0.181590646505 -0.951077103615
      -0.12653273344 0.0919239446521 -0.987694084644
      -0.148750707507 0.048311945051 -0.98769390583
      -0.293840527534 0.0954646095634 -0.951075315475
      -0.431722313166 0.140265509486 -0.891033828259
      -0.558957576752 0.181619256735 -0.809061765671
      -0.672455072403 0.218485325575 -0.707155168056
      -0.769390821457 0.249983355403 -0.587831676006
      -0.847376942635 0.275317400694 -0.454040259123
      -0.904506981373 0.293872445822 -0.309040635824
      -0.939352631569 0.305192708969 -0.156441763043
      -0.951060771942 0.309003949165 0
      -0.939352631569 0.305192708969 0.156441763043
      -0.904506981373 0.293872445822 0.309040635824
      -0.847376942635 0.275317400694 0.454040259123
      -0.769390881062 0.249983355403 0.587831676006
      -0.672455072403 0.218485325575 0.707155168056
      -0.558957576752 0.181619256735 0.809061765671
      -0.43172237277 0.140265509486 0.891033828259
      -0.293840587139 0.0954646095634 0.951075315475
      -0.148750752211 0.048311945051 0.98769390583
      -0.15641079843 0 0.987692058086
      -0.308976352215 0 0.951069712639
      -0.453939527273 0 0.891032516956
      -0.587732493877 0 0.809055328369
      -0.707060992718 0 0.707152545452
      -0.808980226517 0 0.587835967541
      -0.890982866287 0 0.454036861658
      -0.951048851013 0 0.309040516615
      -0.987687349319 0 0.156440541148
      -1 0 0
      -0.987687349319 0 -0.156440541148
      -0.951048851013 0 -0.309040516615
      -0.890982866287 0 -0.454036861658
      -0.808980226517 0 -0.587835967541
      -0.707045733929 0 -0.707167804241
      -0.587732434273 0 -0.809055328369
      -0.453939467669 0 -0.891032516956
      -0.308976322412 0 -0.951069712639
      -0.156410753727 0 -0.987692058086
      -0.148750707507 -0.048311945051 -0.98769390583
      -0.293840527534 -0.0954646095634 -0.951075315475
      -0.431722313166 -0.140265509486 -0.891033828259
      -0.558957576752 -0.181619256735 -0.809061765671
      -0.672455072403 -0.218485325575 -0.707155168056
      -0.769390821457 -0.249983355403 -0.587831676006
      -0.847376942635 -0.275317400694 -0.454040259123
      -0.904506981373 -0.293872445822 -0.309040635824
      -0.939352631569 -0.305192708969 -0.156441763043
      -0.951060771942 -0.309003949165 0
      -0.939352631569 -0.305192708969 0.156441763043
      -0.904506981373 -0.293872445822 0.309040635824
      -0.847376942635 -0.275317400694 0.454040259123
      -0.769390881062 -0.249983355403 0.587831676006
      -0.672455072403 -0.218485325575 0.707155168056
      -0.558957576752 -0.181619256735 0.809061765671
      -0.43172237277 -0.140265509486 0.891033828259
      -0.293840587139 -0.0954646095634 0.951075315475
      -0.148750752211 -0.048311945051 0.98769390583
      -0.126532763243 -0.0919239372015 0.987693965435
      -0.24995419383 -0.181590646505 0.951077103615
      -0.367238521576 -0.266799539328 0.891040921211
      -0.475487262011 -0.345445424318 0.809060752392
      -0.57202398777 -0.415581852198 0.707163572311
      -0.654489457607 -0.475492924452 0.587835013866
      -0.720811486244 -0.523716032505 0.454039871693
      -0.769414126873 -0.559016227722 0.309035211802
      -0.799060463905 -0.580541133881 0.156442731619
      -0.809030294418 -0.587766945362 0
      -0.799060463905 -0.580541133881 -0.156442731619
      -0.769414067268 -0.559016227722 -0.309035211802
      -0.720811486244 -0.523716032505 -0.454039871693
      -0.654489517212 -0.475492954254 -0.587835073471
      -0.57202398777 -0.415581852198 -0.707163572311
      -0.475487262011 -0.345445454121 -0.809060811996
      -0.367238491774 -0.266799539328 -0.891040921211
      -0.249954149127 -0.181590646505 -0.951077103615
      -0.12653273344 -0.0919239446521 -0.987694084644
      -0.0919239223003 -0.126532763243 -0.987694084644
      -0.181590616703 -0.249954178929 -0.951077103615
      -0.266799509525 -0.367238491774 -0.891040921211
      -0.345445454121 -0.475487262011 -0.809060811996
      -0.415581852198 -0.57202398777 -0.707163572311
      -0.475492924452 -0.654489457607 -0.587835013866
      -0.523704528809 -0.720826208591 -0.454029917717
      -0.559016227722 -0.769414126873 -0.309035241604
      -0.580541133881 -0.799060463905 -0.156442731619
      -0.587766945362 -0.809030294418 0
      -0.580541133881 -0.799060463905 0.156442731619
      -0.559016227722 -0.769414067268 0.309035211802
      -0.523704528809 -0.720826208591 0.454029917717
      -0.475492954254 -0.654489457607 0.587835013866
      -0.415581882 -0.57202398777 0.707163572311
      -0.345445454121 -0.475487202406 0.809060752392
      -0.26679956913 -0.367238491774 0.891040921211
      -0.181590661407 -0.249954178929 0.951077103615
      -0.0919239595532 -0.126532748342 0.987693965435
      -0.0483119674027 -0.148750737309 0.98769390583
      -0.0954646393657 -0.293840557337 0.951075315475
      -0.140265524387 -0.431722313166 0.891033828259
      -0.181619271636 -0.558957576752 0.809061765671
      -0.218485355377 -0.672455072403 0.707155168056
      -0.249983385205 -0.769390821457 0.587831676006
      -0.275317400694 -0.847376942635 0.454040259123
      -0.293872475624 -0.904506981373 0.309040635824
      -0.305192708969 -0.939352631569 0.156441763043
      -0.309003949165 -0.951060771942 0
      -0.305192708969 -0.939352631569 -0.156441763043
      -0.293872445822 -0.904506981373 -0.309040635824
      -0.275317400694 -0.847376942635 -0.454040259123
      -0.249983340502 -0.769390821457 -0.587831676006
      -0.218485325575 -0.672455072403 -0.707155168056
      -0.181619226933 -0.558957576752 -0.809061765671
      -0.140265479684 -0.431722313166 -0.891033828259
      -0.0954645872116 -0.293840557337 -0.951075315475
      -0.0483119189739 -0.148750737309 -0.98769390583
      2.35484147737e-008 -0.156410768628 -0.987692058086
      2.26752696619e-008 -0.308976322412 -0.951069712639
      2.12438706626e-008 -0.453939527273 -0.891032516956
      1.92893825357e-008 -0.587732434273 -0.809055328369
      1.68601950179e-008 -0.707045733929 -0.707167804241
      1.40151010797e-008 -0.808980226517 -0.587835967541
      1.0825082164e-008 -0.890982866287 -0.454036861658
      7.36810035207e-009 -0.951048851013 -0.309040516615
      3.72983333108e-009 -0.987687349319 -0.156440541148
      0 -1 0
      -3.72983333108e-009 -0.987687349319 0.156440541148
      -7.36810035207e-009 -0.951048851013 0.309040516615
      -1.0825082164e-008 -0.890982866287 0.454036861658
      -1.40151010797e-008 -0.808980226517 0.587835967541
      -1.68598326411e-008 -0.707061052322 0.707152605057
      -1.92893825357e-008 -0.587732434273 0.809055328369
      -2.12438706626e-008 -0.453939527273 0.891032516956
      -2.26752696619e-008 -0.308976322412 0.951069712639
      -2.35484147737e-008 -0.156410768628 0.987692058086
      0.0483119189739 -0.148750737309 0.98769390583
      0.0954645872116 -0.293840557337 0.951075315475
      0.140265479684 -0.431722313166 0.891033828259
      0.181619226933 -0.558957576752 0.809061765671
      0.218485325575 -0.672455072403 0.707155168056
      0.249983340502 -0.769390821457 0.587831676006
      0.275317400694 -0.847376942635 0.454040259123
      0.293872445822 -0.904506981373 0.309040635824
      0.305192708969 -0.939352631569 0.156441763043
      0.309003949165 -0.951060771942 0
      0.305192708969 -0.939352631569 -0.156441763043
      0.293872475624 -0.904506981373 -0.309040635824
      0.275317400694 -0.847376942635 -0.454040259123
      0.249983385205 -0.769390821457 -0.587831676006
      0.218485355377 -0.672455072403 -0.707155168056
      0.181619271636 -0.558957576752 -0.809061765671
      0.140265524387 -0.431722313166 -0.891033828259
      0.0954646393657 -0.293840557337 -0.951075315475
      0.0483119674027 -0.148750737309 -0.98769390583
      0.0919239595532 -0.126532748342 -0.987693965435
      0.181590661407 -0.249954178929 -0.951077103615
      0.26679956913 -0.367238491774 -0.891040921211
      0.345445454121 -0.475487202406 -0.809060752392
      0.415581882 -0.57202398777 -0.707163572311
      0.475492954254 -0.654489457607 -0.587835013866
      0.523716032505 -0.720811486244 -0.454039871693
      0.559016227722 -0.769414067268 -0.309035211802
      0.580541133881 -0.799060463905 -0.156442731619
      0.587766945362 -0.809030294418 0
      0.580541133881 -0.799060463905 0.156442731619
      0.559016227722 -0.769414126873 0.309035241604
      0.523716032505 -0.720811486244 0.454039871693
      0.475492924452 -0.654489457607 0.587835013866
      0.415581852198 -0.57202398777 0.707163572311
      0.345445454121 -0.475487262011 0.809060811996
      0.266799509525 -0.367238491774 0.891040921211
      0.181590616703 -0.249954178929 0.951077103615
      0.0919239223003 -0.126532763243 0.987694084644
      0.12653273344 -0.0919239446521 0.987694084644
      0.249954149127 -0.181590646505 0.951077103615
      0.367238491774 -0.266799539328 0.891040921211
      0.475487262011 -0.345445454121 0.809060811996
      0.57202398777 -0.415581852198 0.707163572311
      0.654489517212 -0.475492954254 0.587835073471
      0.720826208591 -0.523704528809 0.454029917717
      0.769414067268 -0.559016227722 0.309035211802
      0.799060463905 -0.580541133881 0.156442731619
      0.809030294418 -0.587766945362 0
      0.799060463905 -0.580541133881 -0.156442731619
      0.769414126873 -0.559016227722 -0.309035211802
      0.720826208591 -0.523704528809 -0.454029917717
      0.654489457607 -0.475492924452 -0.587835013866
      0.57202398777 -0.415581852198 -0.707163572311
      0.475487262011 -0.345445424318 -0.809060752392
      0.367238521576 -0.266799539328 -0.891040921211
      0.24995419383 -0.181590646505 -0.951077103615
      0.126532763243 -0.0919239372015 -0.987693965435
      0.148750752211 -0.048311945051 -0.98769390583
      0.293840587139 -0.0954646095634 -0.951075315475
      0.43172237277 -0.140265509486 -0.891033828259
      0.558957576752 -0.181619256735 -0.809061765671
      0.672455072403 -0.218485325575 -0.707155168056
      0.769390881062 -0.249983355403 -0.587831676006
      0.847376942635 -0.275317400694 -0.454040259123
      0.904506981373 -0.293872445822 -0.309040635824
      0.939352631569 -0.305192708969 -0.156441763043
      0.951060771942 -0.309003949165 0
      0.939352631569 -0.305192708969 0.156441763043
      0.904506981373 -0.293872445822 0.309040635824
      0.847376942635 -0.275317400694 0.454040259123
      0.769390821457 -0.249983355403 0.587831676006
      0.672455072403 -0.218485325575 0.707155168056
      0.558957576752 -0.181619256735 0.809061765671
      0.431722313166 -0.140265509486 0.891033828259
      0.293840527534 -0.0954646095634 0.951075315475
      0.148750707507 -0.048311945051 0.98769390583
      -2.38418582654e-008 0 1
   uvs none
}


object {
   shader "top_sphere"
   type generic-mesh
   name "Sphere.002"
   points 382
      0.0300586204976 0.00794982910156 0.682720065117
      0.0516370497644 0.00794982910156 0.677539587021
      0.0721393972635 0.00794982910156 0.669047176838
      0.0910608321428 0.00794982910156 0.657452106476
      0.107935443521 0.00794982910156 0.643039882183
      0.122347734869 0.00794982910156 0.626165270805
      0.133942782879 0.00794982910156 0.607243835926
      0.142435148358 0.00794982910156 0.586741447449
      0.147615671158 0.00794982910156 0.565163016319
      0.149356797338 0.00794982910156 0.543039858341
      0.147615671158 0.00794982910156 0.520916640759
      0.142435133457 0.00794982910156 0.499338209629
      0.133942782879 0.00794982910156 0.478835850954
      0.122347697616 0.00794982910156 0.459914416075
      0.107935398817 0.00794982910156 0.443039804697
      0.0910607725382 0.00794982910156 0.428627550602
      0.0721393227577 0.00794982910156 0.41703248024
      0.0516369566321 0.00794982910156 0.408540129662
      0.0300585161895 0.00794982910156 0.403359621763
      0.0289757344872 0.0147862350568 0.403359591961
      0.049498051405 0.021454339847 0.408540129662
      0.0689969584346 0.0277899205685 0.41703248024
      0.0869923233986 0.0336369685829 0.428627550602
      0.103041045368 0.0388515181839 0.443039804697
      0.116747960448 0.0433051623404 0.459914416075
      0.127775534987 0.046888243407 0.478835880756
      0.135852247477 0.0495125278831 0.499338209629
      0.140779227018 0.051113396883 0.520916640759
      0.142435133457 0.0516514368355 0.543039858341
      0.140779227018 0.051113396883 0.565163016319
      0.135852262378 0.0495125316083 0.586741447449
      0.127775549889 0.046888243407 0.607243835926
      0.116747997701 0.0433051735163 0.626165270805
      0.103041097522 0.0388515330851 0.643039882183
      0.0869923904538 0.0336369909346 0.657452106476
      0.0689970329404 0.0277899447829 0.669047176838
      0.0494981408119 0.0214543696493 0.677539587021
      0.02897583507 0.0147862667218 0.682720065117
      0.0258334688842 0.0209535062313 0.682720065117
      0.0432907864451 0.0336369909346 0.677539587021
      0.059877526015 0.045687969774 0.669047176838
      0.0751852914691 0.0568097122014 0.657452106476
      0.0888371318579 0.0667283609509 0.643039882183
      0.100496917963 0.0751996859908 0.626165270805
      0.109877511859 0.0820150896907 0.607243835926
      0.1167479828 0.0870067775249 0.586741447449
      0.120939105749 0.0900518149137 0.565163016319
      0.122347705066 0.0910752266645 0.543039858341
      0.120939105749 0.0900518149137 0.520916640759
      0.116747967899 0.0870067700744 0.499338209629
      0.109877511859 0.0820150896907 0.478835880756
      0.100496888161 0.0751996636391 0.459914416075
      0.088837094605 0.0667283311486 0.443039804697
      0.075185239315 0.0568096749485 0.428627550602
      0.0598774664104 0.0456879250705 0.41703248024
      0.043290708214 0.0336369350553 0.408540129662
      0.0258333850652 0.020953444764 0.403359591961
      0.00793537870049 0.00794973690063 0.401618510485
      0.0209390576929 0.0258477702737 0.403359591961
      0.0336225442588 0.0433050952852 0.408540129662
      0.0456735268235 0.0598918609321 0.41703248024
      0.0567952767015 0.0751996338367 0.428627550602
      0.0667139217257 0.0888514891267 0.443039804697
      0.0751852616668 0.100511282682 0.459914416075
      0.0820006802678 0.109891906381 0.478835880756
      0.0869923606515 0.116762362421 0.499338209629
      0.0900373980403 0.120953515172 0.520916640759
      0.0910608023405 0.122362114489 0.543039858341
      0.0900373980403 0.120953515172 0.565163016319
      0.0869923681021 0.116762377322 0.586741447449
      0.0820006802678 0.109891913831 0.607243835926
      0.0751852840185 0.100511312485 0.626165270805
      0.0667139515281 0.0888515338302 0.643039882183
      0.0567953139544 0.0751996859908 0.657452106476
      0.045673571527 0.0598919205368 0.669047176838
      0.0336226001382 0.043305169791 0.677539587021
      0.0209391191602 0.0258478559554 0.682720065117
      0.014771877788 0.0289902202785 0.682720065117
      0.0214399769902 0.0495125241578 0.677539587021
      0.0277755428106 0.0690114125609 0.669047176838
      0.0336225889623 0.0870067700744 0.657452106476
      0.0388371236622 0.103055477142 0.643039882183
      0.0432907603681 0.116762377322 0.626165270805
      0.0468738265336 0.127789929509 0.607243835926
      0.0494981184602 0.135866641998 0.586741447449
      0.0510989800096 0.14079362154 0.565163016319
      0.0516370125115 0.142449527979 0.543039858341
      0.0510989800096 0.14079362154 0.520916640759
      0.0494981072843 0.135866627097 0.499338209629
      0.0468738302588 0.127789914608 0.478835880756
      0.0432907566428 0.116762340069 0.459914416075
      0.0388371087611 0.103055424988 0.443039804697
      0.0336225703359 0.0870067104697 0.428627550602
      0.0277755204588 0.0690113529563 0.41703248024
      0.0214399490505 0.0495124347508 0.408540129662
      0.014771846123 0.0289901196957 0.403359591961
      0.00793544016778 0.0300728976727 0.403359591961
      0.00793543737382 0.0516513362527 0.408540129662
      0.00793542806059 0.0721537098289 0.41703248024
      0.00793542619795 0.0910751447082 0.428627550602
      0.00793542247266 0.107949763536 0.443039804697
      0.00793542154133 0.122362069786 0.459914416075
      0.00793541874737 0.133957147598 0.478835880756
      0.00793541409075 0.142449498177 0.499338209629
      0.00793540850282 0.147630050778 0.520916640759
      0.00793540664017 0.149371162057 0.543039858341
      0.00793540850282 0.147630050778 0.565163016319
      0.00793541874737 0.142449513078 0.586741447449
      0.00793541222811 0.133957147598 0.607243835926
      0.00793541688472 0.122362099588 0.626165270805
      0.00793542061001 0.107949815691 0.643039882183
      0.00793542806059 0.0910752117634 0.657452106476
      0.00793542806059 0.0721537694335 0.669047176838
      0.00793543644249 0.0516514293849 0.677539587021
      0.00793544016778 0.0300730038434 0.682720065117
      0.00109900231473 0.0289902146906 0.682720065117
      -0.00556910270825 0.0495125167072 0.677539587021
      -0.0119046829641 0.0690113976598 0.669047176838
      -0.0177517309785 0.0870067626238 0.657452106476
      -0.0229662787169 0.103055462241 0.643039882183
      -0.0274199228734 0.11676235497 0.626165270805
      -0.0310029946268 0.127789899707 0.607243835926
      -0.0336272716522 0.135866627097 0.586741447449
      -0.0352281592786 0.140793606639 0.565163016319
      -0.0357661917806 0.142449483275 0.543039858341
      -0.0352281592786 0.140793606639 0.520916640759
      -0.0336272716522 0.135866612196 0.499338209629
      -0.0310029871762 0.127789899707 0.478835880756
      -0.0274199079722 0.116762317717 0.459914416075
      -0.0229662600905 0.103055410087 0.443039804697
      -0.017751712352 0.0870066955686 0.428627550602
      -0.011904662475 0.0690113380551 0.41703248024
      -0.00556907150894 0.0495124273002 0.408540129662
      0.00109903584234 0.0289901159704 0.403359591961
      -0.00506817363203 0.0258477628231 0.403359591961
      -0.0177516657859 0.043305080384 0.408540129662
      -0.0298026632518 0.0598918385804 0.41703248024
      -0.040924411267 0.0751996040344 0.428627550602
      -0.0508430674672 0.0888514518738 0.443039804697
      -0.0593144074082 0.10051124543 0.459914416075
      -0.0661298260093 0.109891869128 0.478835880756
      -0.071121506393 0.116762317717 0.499338209629
      -0.0741665661335 0.120953463018 0.520916640759
      -0.0751899704337 0.122362054884 0.543039858341
      -0.0741665661335 0.120953463018 0.565163016319
      -0.0711215138435 0.116762332618 0.586741447449
      -0.0661298260093 0.109891854227 0.607243835926
      -0.05931442976 0.100511275232 0.626165270805
      -0.0508430972695 0.0888514965773 0.643039882183
      -0.0409244485199 0.0751996561885 0.657452106476
      -0.0298027023673 0.0598918907344 0.669047176838
      -0.0177517216653 0.0433051586151 0.677539587021
      -0.00506823603064 0.0258478485048 0.682720065117
      -0.0099625820294 0.0209534969181 0.682720065117
      -0.027419898659 0.0336369723082 0.677539587021
      -0.0440066456795 0.0456879362464 0.669047176838
      -0.0593144185841 0.0568096749485 0.657452106476
      -0.0729662626982 0.0667283162475 0.643039882183
      -0.0846260488033 0.0751996263862 0.626165270805
      -0.0940066426992 0.082015030086 0.607243835926
      -0.10087710619 0.0870067104697 0.586741447449
      -0.105068251491 0.0900517478585 0.565163016319
      -0.106476843357 0.0910751447082 0.543039858341
      -0.105068251491 0.0900517478585 0.520916640759
      -0.100877091289 0.0870067104697 0.499338209629
      -0.0940066426992 0.082015030086 0.478835880756
      -0.0846260115504 0.075199611485 0.459914416075
      -0.0729662179947 0.0667282864451 0.443039804697
      -0.05931436643 0.0568096376956 0.428627550602
      -0.0440065935254 0.0456878952682 0.41703248024
      -0.0274198222905 0.0336369164288 0.408540129662
      -0.00996249727905 0.0209534354508 0.403359591961
      -0.0131048448384 0.0147862238809 0.403359591961
      -0.0336271561682 0.0214543193579 0.408540129662
      -0.0531260743737 0.0277898889035 0.41703248024
      -0.0711214393377 0.0336369276047 0.428627550602
      -0.0871701464057 0.0388514660299 0.443039804697
      -0.100877054036 0.0433051027358 0.459914416075
      -0.111904643476 0.0468881800771 0.478835880756
      -0.119981348515 0.0495124571025 0.499338209629
      -0.124908350408 0.0511133223772 0.520916640759
      -0.126564234495 0.0516513548791 0.543039858341
      -0.124908350408 0.0511133223772 0.565163016319
      -0.119981355965 0.0495124608278 0.586741447449
      -0.111904643476 0.0468881726265 0.607243835926
      -0.10087710619 0.0433051101863 0.626165270805
      -0.0871701985598 0.038851480931 0.643039882183
      -0.0711214989424 0.0336369499564 0.657452106476
      -0.0531261339784 0.02778990753 0.669047176838
      -0.0336272493005 0.0214543491602 0.677539587021
      -0.0131049454212 0.0147862574086 0.682720065117
      -0.0141877271235 0.00794981885701 0.682720065117
      -0.0357661508024 0.00794980954379 0.677539587021
      -0.0562684834003 0.00794979557395 0.669047176838
      -0.0751899331808 0.00794978905469 0.657452106476
      -0.0920645296574 0.00794978253543 0.643039882183
      -0.106476813555 0.00794976577163 0.626165270805
      -0.118071861565 0.00794976577163 0.607243835926
      -0.126564219594 0.00794976949692 0.586741447449
      -0.131744757295 0.00794975459576 0.565163016319
      -0.133485868573 0.0079497564584 0.543039858341
      -0.131744757295 0.00794975459576 0.520916640759
      -0.126564219594 0.00794977042824 0.499338209629
      -0.118071861565 0.00794977135956 0.478835880756
      -0.106476768851 0.00794977508485 0.459914416075
      -0.0920644775033 0.00794978346676 0.443039804697
      -0.0751898661256 0.00794978719205 0.428627550602
      -0.0562684237957 0.00794979557395 0.41703248024
      -0.0357660539448 0.00794981047511 0.408540129662
      -0.014187621884 0.00794981792569 0.403359591961
      -0.0131048373878 0.0011134139495 0.403359591961
      -0.0336271449924 -0.00555469701067 0.408540129662
      -0.053126052022 -0.0118902921677 0.41703248024
      -0.0711214095354 -0.0177373476326 0.428627550602
      -0.0871701166034 -0.0229518953711 0.443039804697
      -0.100877016783 -0.0274055451155 0.459914416075
      -0.111904606223 -0.03098863177 0.478835880756
      -0.119981311262 -0.0336129143834 0.499338209629
      -0.124908298254 -0.0352138057351 0.520916640759
      -0.126564174891 -0.0357518307865 0.543039858341
      -0.124908298254 -0.0352138057351 0.565163016319
      -0.119981318712 -0.0336129181087 0.586741447449
      -0.111904606223 -0.030988637358 0.607243835926
      -0.100877054036 -0.0274055693299 0.626165270805
      -0.0871701687574 -0.0229519102722 0.643039882183
      -0.0711214765906 -0.0177373681217 0.657452106476
      -0.0531261116266 -0.0118903107941 0.669047176838
      -0.0336272343993 -0.00555472681299 0.677539587021
      -0.013104938902 0.00111338193528 0.682720065117
      -0.00996256992221 -0.00505385547876 0.682720065117
      -0.027419872582 -0.0177373420447 0.677539587021
      -0.044006600976 -0.0297883246094 0.669047176838
      -0.05931436643 -0.0409100800753 0.657452106476
      -0.0729662030935 -0.0508287250996 0.643039882183
      -0.0846259668469 -0.0593000650406 0.626165270805
      -0.0940065607429 -0.0661154687405 0.607243835926
      -0.100877031684 -0.0711071491241 0.586741447449
      -0.105068169534 -0.0741522014141 0.565163016319
      -0.106476731598 -0.0751755982637 0.543039858341
      -0.105068169534 -0.0741522014141 0.520916640759
      -0.100877016783 -0.0711071416736 0.499338209629
      -0.0940065607429 -0.0661154612899 0.478835880756
      -0.0846259444952 -0.0593000352383 0.459914416075
      -0.0729661509395 -0.0508286952972 0.443039804697
      -0.0593143105507 -0.0409100428224 0.428627550602
      -0.0440065525472 -0.0297882892191 0.41703248024
      -0.0274197980762 -0.017737288028 0.408540129662
      -0.00996248330921 -0.00505379308015 0.403359591961
      -0.00506815547124 -0.00994811486453 0.403359591961
      -0.0177516322583 -0.0274054408073 0.408540129662
      -0.0298026073724 -0.0439922176301 0.41703248024
      -0.0409243404865 -0.0592999868095 0.428627550602
      -0.0508429780602 -0.0729518458247 0.443039804697
      -0.0593143105507 -0.0846116393805 0.459914416075
      -0.0661297217011 -0.0939922556281 0.478835880756
      -0.0711214020848 -0.100862719119 0.499338209629
      -0.0741664469242 -0.105053879321 0.520916640759
      -0.0751898214221 -0.106462456286 0.543039858341
      -0.0741664469242 -0.105053879321 0.565163016319
      -0.071121416986 -0.10086273402 0.586741447449
      -0.0661297217011 -0.0939922705293 0.607243835926
      -0.0593143254519 -0.0846116766334 0.626165270805
      -0.0508430153131 -0.0729518830776 0.643039882183
      -0.0409243777394 -0.0593000426888 0.657452106476
      -0.0298026390374 -0.0439922623336 0.669047176838
      -0.017751686275 -0.0274055153131 0.677539587021
      -0.00506821833551 -0.00994820147753 0.682720065117
      0.00109902315307 -0.0130905630067 0.682720065117
      -0.00556906405836 -0.0336128622293 0.677539587021
      -0.0119046131149 -0.0531117431819 0.669047176838
      -0.0177516508847 -0.0711071118712 0.657452106476
      -0.0229661799967 -0.0871558114886 0.643039882183
      -0.0274198036641 -0.100862704217 0.626165270805
      -0.0310028661042 -0.111890256405 0.607243835926
      -0.0336271598935 -0.119966976345 0.586741447449
      -0.0352280214429 -0.124893963337 0.565163016319
      -0.0357660353184 -0.126549839973 0.543039858341
      -0.0352280214429 -0.124893963337 0.520916640759
      -0.0336271524429 -0.119966961443 0.499338209629
      -0.0310028716922 -0.111890256405 0.478835880756
      -0.0274198036641 -0.100862674415 0.459914416075
      -0.0229661595076 -0.0871557667851 0.443039804697
      -0.017751628533 -0.0711070522666 0.428627550602
      -0.0119045972824 -0.0531116910279 0.41703248024
      -0.00556903565302 -0.0336127728224 0.408540129662
      0.00109905586578 -0.0130904614925 0.403359591961
      0.0079354615882 -0.0141732366756 0.403359591961
      0.00793547276407 -0.0357516668737 0.408540129662
      0.00793549418449 -0.0562540367246 0.41703248024
      0.00793550815433 -0.0751754716039 0.428627550602
      0.00793552305549 -0.0920500904322 0.443039804697
      0.00793552212417 -0.10646238178 0.459914416075
      0.00793553516269 -0.118057467043 0.478835880756
      0.00793553609401 -0.126549825072 0.499338209629
      0.00793554540724 -0.131730362773 0.520916640759
      0.00793555658311 -0.13347145915 0.543039858341
      0.00793554540724 -0.131730362773 0.565163016319
      0.0079355314374 -0.126549825072 0.586741447449
      0.00793554075062 -0.118057467043 0.607243835926
      0.00793553330004 -0.106462411582 0.626165270805
      0.00793551746756 -0.0920501351357 0.643039882183
      0.00793550908566 -0.0751755386591 0.657452106476
      0.00793549511582 -0.0562540888786 0.669047176838
      0.0079354736954 -0.035751760006 0.677539587021
      0.0079354615882 -0.0141733428463 0.682720065117
      0.0147718973458 -0.0130905508995 0.682720065117
      0.0214400086552 -0.0336128436029 0.677539587021
      0.0277755968273 -0.0531117096543 0.669047176838
      0.0336226597428 -0.0711070671678 0.657452106476
      0.0388372056186 -0.0871557667851 0.643039882183
      0.0432908609509 -0.100862644613 0.626165270805
      0.046873934567 -0.1118901968 0.607243835926
      0.0494982115924 -0.11996691674 0.586741447449
      0.0510990992188 -0.124893896282 0.565163016319
      0.0516371354461 -0.126549765468 0.543039858341
      0.0510990992188 -0.124893896282 0.520916640759
      0.0494982115924 -0.119966901839 0.499338209629
      0.0468739308417 -0.1118901968 0.478835880756
      0.0432908423245 -0.100862622261 0.459914416075
      0.038837198168 -0.0871557220817 0.443039804697
      0.0336226411164 -0.0711070075631 0.428627550602
      0.0277755800635 -0.053111653775 0.41703248024
      0.0214399788529 -0.0336127541959 0.408540129662
      0.0147718647495 -0.013090451248 0.403359591961
      0.0209390707314 -0.00994809623808 0.403359591961
      0.0336225666106 -0.0274054054171 0.408540129662
      0.045673571527 -0.0439921505749 0.41703248024
      0.0567953251302 -0.0592999048531 0.428627550602
      0.066713988781 -0.0729517564178 0.443039804697
      0.0751853212714 -0.0846115425229 0.459914416075
      0.082000747323 -0.09399215132 0.478835880756
      0.0869924277067 -0.100862599909 0.499338209629
      0.0900374948978 -0.10505374521 0.520916640759
      0.0910608917475 -0.106462322176 0.543039858341
      0.0900374948978 -0.10505374521 0.565163016319
      0.0869924351573 -0.10086261481 0.586741447449
      0.0820007547736 -0.09399215132 0.607243835926
      0.0751853436232 -0.0846115574241 0.626165270805
      0.0667140111327 -0.0729517936707 0.643039882183
      0.0567953661084 -0.0592999570072 0.657452106476
      0.0456736050546 -0.0439921990037 0.669047176838
      0.0336226187646 -0.0274054799229 0.677539587021
      0.0209391340613 -0.00994818098843 0.682720065117
      0.0258334763348 -0.00505382893607 0.682720065117
      0.0432907901704 -0.0177372936159 0.677539587021
      0.0598775371909 -0.0297882389277 0.669047176838
      0.0751853138208 -0.0409099720418 0.657452106476
      0.0888371616602 -0.0508286058903 0.643039882183
      0.100496940315 -0.0592999123037 0.626165270805
      0.109877549112 -0.0661153122783 0.607243835926
      0.116748005152 -0.071106992662 0.586741447449
      0.120939165354 -0.0741520226002 0.565163016319
      0.122347742319 -0.0751754119992 0.543039858341
      0.120939165354 -0.0741520226002 0.520916640759
      0.116747997701 -0.0711069852114 0.499338209629
      0.109877549112 -0.0661153122783 0.478835880756
      0.100496917963 -0.0592999048531 0.459914416075
      0.0888371318579 -0.050828576088 0.443039804697
      0.0751852616668 -0.0409099310637 0.428627550602
      0.0598774924874 -0.0297882035375 0.41703248024
      0.0432907156646 -0.0177372377366 0.408540129662
      0.0258333925158 -0.0050537660718 0.403359591961
      0.0289757344872 0.00111344596371 0.403359591961
      0.0494980439544 -0.00555464066565 0.408540129662
      0.0689969584346 -0.0118901943788 0.41703248024
      0.086992315948 -0.0177372246981 0.428627550602
      0.103041045368 -0.0229517556727 0.443039804697
      0.116747945547 -0.0274053942412 0.459914416075
      0.127775534987 -0.0309884548187 0.478835880756
      0.135852217674 -0.0336127355695 0.499338209629
      0.14077924192 -0.0352135971189 0.520916640759
      0.142435118556 -0.0357516221702 0.543039858341
      0.14077924192 -0.0352135971189 0.565163016319
      0.135852232575 -0.0336127355695 0.586741447449
      0.127775534987 -0.0309884548187 0.607243835926
      0.116747967899 -0.0274053942412 0.626165270805
      0.103041090071 -0.0229517724365 0.643039882183
      0.0869923830032 -0.0177372433245 0.657452106476
      0.0689970105886 -0.0118902139366 0.669047176838
      0.0494981333613 -0.00555467186496 0.677539587021
      0.0289758369327 0.0011134124361 0.682720065117
      0.00793544575572 0.00794982910156 0.684461236
   triangles 760
      57 19 18
      18 19 20
      18 20 17
      17 20 21
      17 21 16
      16 21 22
      16 22 15
      15 22 23
      15 23 14
      14 23 24
      14 24 13
      13 24 25
      13 25 12
      12 25 26
      12 26 11
      11 26 27
      11 27 10
      10 27 28
      10 28 9
      9 28 29
      9 29 8
      8 29 30
      8 30 7
      7 30 31
      7 31 6
      6 31 32
      6 32 5
      5 32 33
      5 33 4
      4 33 34
      4 34 3
      3 34 35
      3 35 2
      2 35 36
      2 36 1
      37 0 1
      37 1 36
      0 37 381
      37 38 381
      36 39 38
      36 38 37
      35 40 39
      35 39 36
      34 41 40
      34 40 35
      33 42 41
      33 41 34
      32 43 42
      32 42 33
      31 44 43
      31 43 32
      30 45 44
      30 44 31
      29 46 45
      29 45 30
      28 47 46
      28 46 29
      27 48 47
      27 47 28
      26 49 48
      26 48 27
      25 50 49
      25 49 26
      24 51 50
      24 50 25
      23 52 51
      23 51 24
      22 53 52
      22 52 23
      21 54 53
      21 53 22
      20 55 54
      20 54 21
      19 56 55
      19 55 20
      57 56 19
      57 58 56
      56 58 59
      56 59 55
      55 59 60
      55 60 54
      54 60 61
      54 61 53
      53 61 62
      53 62 52
      52 62 63
      52 63 51
      51 63 64
      51 64 50
      50 64 65
      50 65 49
      49 65 66
      49 66 48
      48 66 67
      48 67 47
      47 67 68
      47 68 46
      46 68 69
      46 69 45
      45 69 70
      45 70 44
      44 70 71
      44 71 43
      43 71 72
      43 72 42
      42 72 73
      42 73 41
      41 73 74
      41 74 40
      40 74 75
      40 75 39
      39 75 76
      39 76 38
      38 76 381
      76 77 381
      75 78 77
      75 77 76
      74 79 78
      74 78 75
      73 80 79
      73 79 74
      72 81 80
      72 80 73
      71 82 81
      71 81 72
      70 83 82
      70 82 71
      69 84 83
      69 83 70
      68 85 84
      68 84 69
      67 86 85
      67 85 68
      66 87 86
      66 86 67
      65 88 87
      65 87 66
      64 89 88
      64 88 65
      63 90 89
      63 89 64
      62 91 90
      62 90 63
      61 92 91
      61 91 62
      60 93 92
      60 92 61
      59 94 93
      59 93 60
      58 95 94
      58 94 59
      57 95 58
      57 96 95
      95 96 97
      95 97 94
      94 97 98
      94 98 93
      93 98 99
      93 99 92
      92 99 100
      92 100 91
      91 100 101
      91 101 90
      90 101 102
      90 102 89
      89 102 103
      89 103 88
      88 103 104
      88 104 87
      87 104 105
      87 105 86
      86 105 106
      86 106 85
      85 106 107
      85 107 84
      84 107 108
      84 108 83
      83 108 109
      83 109 82
      82 109 110
      82 110 81
      81 110 111
      81 111 80
      80 111 112
      80 112 79
      79 112 113
      79 113 78
      78 113 114
      78 114 77
      77 114 381
      114 115 381
      113 116 115
      113 115 114
      112 117 116
      112 116 113
      111 118 117
      111 117 112
      110 119 118
      110 118 111
      109 120 119
      109 119 110
      108 121 120
      108 120 109
      107 122 121
      107 121 108
      106 123 122
      106 122 107
      105 124 123
      105 123 106
      104 125 124
      104 124 105
      103 126 125
      103 125 104
      102 127 126
      102 126 103
      101 128 127
      101 127 102
      100 129 128
      100 128 101
      99 130 129
      99 129 100
      98 131 130
      98 130 99
      97 132 131
      97 131 98
      96 133 132
      96 132 97
      57 133 96
      57 134 133
      133 134 135
      133 135 132
      132 135 136
      132 136 131
      131 136 137
      131 137 130
      130 137 138
      130 138 129
      129 138 139
      129 139 128
      128 139 140
      128 140 127
      127 140 141
      127 141 126
      126 141 142
      126 142 125
      125 142 143
      125 143 124
      124 143 144
      124 144 123
      123 144 145
      123 145 122
      122 145 146
      122 146 121
      121 146 147
      121 147 120
      120 147 148
      120 148 119
      119 148 149
      119 149 118
      118 149 150
      118 150 117
      117 150 151
      117 151 116
      116 151 152
      116 152 115
      115 152 381
      152 153 381
      151 154 153
      151 153 152
      150 155 154
      150 154 151
      149 156 155
      149 155 150
      148 157 156
      148 156 149
      147 158 157
      147 157 148
      146 159 158
      146 158 147
      145 160 159
      145 159 146
      144 161 160
      144 160 145
      143 162 161
      143 161 144
      142 163 162
      142 162 143
      141 164 163
      141 163 142
      140 165 164
      140 164 141
      139 166 165
      139 165 140
      138 167 166
      138 166 139
      137 168 167
      137 167 138
      136 169 168
      136 168 137
      135 170 169
      135 169 136
      134 171 170
      134 170 135
      57 171 134
      57 172 171
      171 172 173
      171 173 170
      170 173 174
      170 174 169
      169 174 175
      169 175 168
      168 175 176
      168 176 167
      167 176 177
      167 177 166
      166 177 178
      166 178 165
      165 178 179
      165 179 164
      164 179 180
      164 180 163
      163 180 181
      163 181 162
      162 181 182
      162 182 161
      161 182 183
      161 183 160
      160 183 184
      160 184 159
      159 184 185
      159 185 158
      158 185 186
      158 186 157
      157 186 187
      157 187 156
      156 187 188
      156 188 155
      155 188 189
      155 189 154
      154 189 190
      154 190 153
      153 190 381
      190 191 381
      189 192 191
      189 191 190
      188 193 192
      188 192 189
      187 194 193
      187 193 188
      186 195 194
      186 194 187
      185 196 195
      185 195 186
      184 197 196
      184 196 185
      183 198 197
      183 197 184
      182 199 198
      182 198 183
      181 200 199
      181 199 182
      180 201 200
      180 200 181
      179 202 201
      179 201 180
      178 203 202
      178 202 179
      177 204 203
      177 203 178
      176 205 204
      176 204 177
      175 206 205
      175 205 176
      174 207 206
      174 206 175
      173 208 207
      173 207 174
      172 209 208
      172 208 173
      57 209 172
      57 210 209
      209 210 211
      209 211 208
      208 211 212
      208 212 207
      207 212 213
      207 213 206
      206 213 214
      206 214 205
      205 214 215
      205 215 204
      204 215 216
      204 216 203
      203 216 217
      203 217 202
      202 217 218
      202 218 201
      201 218 219
      201 219 200
      200 219 220
      200 220 199
      199 220 221
      199 221 198
      198 221 222
      198 222 197
      197 222 223
      197 223 196
      196 223 224
      196 224 195
      195 224 225
      195 225 194
      194 225 226
      194 226 193
      193 226 227
      193 227 192
      192 227 228
      192 228 191
      191 228 381
      228 229 381
      227 230 229
      227 229 228
      226 231 230
      226 230 227
      225 232 231
      225 231 226
      224 233 232
      224 232 225
      223 234 233
      223 233 224
      222 235 234
      222 234 223
      221 236 235
      221 235 222
      220 237 236
      220 236 221
      219 238 237
      219 237 220
      218 239 238
      218 238 219
      217 240 239
      217 239 218
      216 241 240
      216 240 217
      215 242 241
      215 241 216
      214 243 242
      214 242 215
      213 244 243
      213 243 214
      212 245 244
      212 244 213
      211 246 245
      211 245 212
      210 247 246
      210 246 211
      57 247 210
      57 248 247
      247 248 249
      247 249 246
      246 249 250
      246 250 245
      245 250 251
      245 251 244
      244 251 252
      244 252 243
      243 252 253
      243 253 242
      242 253 254
      242 254 241
      241 254 255
      241 255 240
      240 255 256
      240 256 239
      239 256 257
      239 257 238
      238 257 258
      238 258 237
      237 258 259
      237 259 236
      236 259 260
      236 260 235
      235 260 261
      235 261 234
      234 261 262
      234 262 233
      233 262 263
      233 263 232
      232 263 264
      232 264 231
      231 264 265
      231 265 230
      230 265 266
      230 266 229
      229 266 381
      266 267 381
      265 268 267
      265 267 266
      264 269 268
      264 268 265
      263 270 269
      263 269 264
      262 271 270
      262 270 263
      261 272 271
      261 271 262
      260 273 272
      260 272 261
      259 274 273
      259 273 260
      258 275 274
      258 274 259
      257 276 275
      257 275 258
      256 277 276
      256 276 257
      255 278 277
      255 277 256
      254 279 278
      254 278 255
      253 280 279
      253 279 254
      252 281 280
      252 280 253
      251 282 281
      251 281 252
      250 283 282
      250 282 251
      249 284 283
      249 283 250
      248 285 284
      248 284 249
      57 285 248
      57 286 285
      285 286 287
      285 287 284
      284 287 288
      284 288 283
      283 288 289
      283 289 282
      282 289 290
      282 290 281
      281 290 291
      281 291 280
      280 291 292
      280 292 279
      279 292 293
      279 293 278
      278 293 294
      278 294 277
      277 294 295
      277 295 276
      276 295 296
      276 296 275
      275 296 297
      275 297 274
      274 297 298
      274 298 273
      273 298 299
      273 299 272
      272 299 300
      272 300 271
      271 300 301
      271 301 270
      270 301 302
      270 302 269
      269 302 303
      269 303 268
      268 303 304
      268 304 267
      267 304 381
      304 305 381
      303 306 305
      303 305 304
      302 307 306
      302 306 303
      301 308 307
      301 307 302
      300 309 308
      300 308 301
      299 310 309
      299 309 300
      298 311 310
      298 310 299
      297 312 311
      297 311 298
      296 313 312
      296 312 297
      295 314 313
      295 313 296
      294 315 314
      294 314 295
      293 316 315
      293 315 294
      292 317 316
      292 316 293
      291 318 317
      291 317 292
      290 319 318
      290 318 291
      289 320 319
      289 319 290
      288 321 320
      288 320 289
      287 322 321
      287 321 288
      286 323 322
      286 322 287
      57 323 286
      57 324 323
      323 324 325
      323 325 322
      322 325 326
      322 326 321
      321 326 327
      321 327 320
      320 327 328
      320 328 319
      319 328 329
      319 329 318
      318 329 330
      318 330 317
      317 330 331
      317 331 316
      316 331 332
      316 332 315
      315 332 333
      315 333 314
      314 333 334
      314 334 313
      313 334 335
      313 335 312
      312 335 336
      312 336 311
      311 336 337
      311 337 310
      310 337 338
      310 338 309
      309 338 339
      309 339 308
      308 339 340
      308 340 307
      307 340 341
      307 341 306
      306 341 342
      306 342 305
      305 342 381
      342 343 381
      341 344 343
      341 343 342
      340 345 344
      340 344 341
      339 346 345
      339 345 340
      338 347 346
      338 346 339
      337 348 347
      337 347 338
      336 349 348
      336 348 337
      335 350 349
      335 349 336
      334 351 350
      334 350 335
      333 352 351
      333 351 334
      332 353 352
      332 352 333
      331 354 353
      331 353 332
      330 355 354
      330 354 331
      329 356 355
      329 355 330
      328 357 356
      328 356 329
      327 358 357
      327 357 328
      326 359 358
      326 358 327
      325 360 359
      325 359 326
      324 361 360
      324 360 325
      57 361 324
      57 362 361
      361 362 363
      361 363 360
      360 363 364
      360 364 359
      359 364 365
      359 365 358
      358 365 366
      358 366 357
      357 366 367
      357 367 356
      356 367 368
      356 368 355
      355 368 369
      355 369 354
      354 369 370
      354 370 353
      353 370 371
      353 371 352
      352 371 372
      352 372 351
      351 372 373
      351 373 350
      350 373 374
      350 374 349
      349 374 375
      349 375 348
      348 375 376
      348 376 347
      347 376 377
      347 377 346
      346 377 378
      346 378 345
      345 378 379
      345 379 344
      344 379 380
      344 380 343
      343 380 381
      380 0 381
      0 380 379
      0 379 1
      378 2 1
      378 1 379
      377 3 2
      377 2 378
      376 4 3
      376 3 377
      375 5 4
      375 4 376
      374 6 5
      374 5 375
      373 7 6
      373 6 374
      372 8 7
      372 7 373
      371 9 8
      371 8 372
      370 10 9
      370 9 371
      369 11 10
      369 10 370
      368 12 11
      368 11 369
      367 13 12
      367 12 368
      366 14 13
      366 13 367
      365 15 14
      365 14 366
      364 16 15
      364 15 365
      363 17 16
      363 16 364
      362 18 17
      362 17 363
      57 18 362
   normals vertex
      0.156410768628 0 0.987692058086
      0.308976322412 0 0.951069712639
      0.453939527273 0 0.891032516956
      0.587732434273 0 0.809055328369
      0.707045733929 0 0.707167863846
      0.808980226517 0 0.587835967541
      0.890982866287 0 0.454036861658
      0.951048851013 0 0.309040516615
      0.987687349319 0 0.156440541148
      1 0 1.49011614159e-009
      0.987687349319 0 -0.156440541148
      0.951048851013 0 -0.309040516615
      0.890982866287 0 -0.454036861658
      0.808980226517 0 -0.587835967541
      0.707045733929 0 -0.707167804241
      0.587732434273 0 -0.809055328369
      0.453939527273 0 -0.891032516956
      0.308976322412 0 -0.951069712639
      0.156410768628 0 -0.987692058086
      0.148750737309 0.048311945051 -0.98769390583
      0.293840557337 0.0954646095634 -0.951075315475
      0.431722313166 0.140265509486 -0.891033828259
      0.558957576752 0.181619256735 -0.809061765671
      0.672455072403 0.218485325575 -0.707155168056
      0.769390821457 0.249983355403 -0.587831676006
      0.847376942635 0.275317400694 -0.454040259123
      0.904506981373 0.293872445822 -0.309040635824
      0.939352631569 0.305192708969 -0.156441763043
      0.951060771942 0.309003949165 1.87764270798e-009
      0.939352631569 0.305192708969 0.156441763043
      0.904506981373 0.293872445822 0.309040635824
      0.847376942635 0.275317400694 0.454040259123
      0.769390821457 0.249983355403 0.587831676006
      0.672455012798 0.218485310674 0.707155108452
      0.558957576752 0.181619256735 0.809061765671
      0.431722313166 0.140265509486 0.891033828259
      0.293840557337 0.0954646095634 0.951075315475
      0.148750737309 0.048311945051 0.98769390583
      0.126532748342 0.0919239372015 0.987693965435
      0.249954178929 0.181590646505 0.951077103615
      0.367238491774 0.266799539328 0.891040921211
      0.475487262011 0.345445454121 0.809060811996
      0.57202398777 0.415581852198 0.707163631916
      0.654489457607 0.475492924452 0.587835013866
      0.720826208591 0.523704528809 0.454029917717
      0.769414067268 0.559016227722 0.309035211802
      0.799060463905 0.580541133881 0.156442731619
      0.809030294418 0.587766945362 2.08139017133e-009
      0.799060463905 0.580541133881 -0.156442731619
      0.769414067268 0.559016227722 -0.309035211802
      0.720826208591 0.523704528809 -0.454029917717
      0.654489457607 0.475492924452 -0.587835013866
      0.57202398777 0.415581852198 -0.707163572311
      0.475487262011 0.345445454121 -0.809060811996
      0.367238491774 0.266799539328 -0.891040921211
      0.249954178929 0.181590646505 -0.951077103615
      0.126532748342 0.0919239372015 -0.987693965435
      0 0 -1
      0.0919239372015 0.126532748342 -0.987693965435
      0.181590646505 0.249954178929 -0.951077103615
      0.266799539328 0.367238491774 -0.891040921211
      0.345445454121 0.475487262011 -0.809060811996
      0.415581852198 0.57202398777 -0.707163572311
      0.475492924452 0.654489457607 -0.587835013866
      0.523704528809 0.720826208591 -0.454029917717
      0.559016227722 0.769414067268 -0.309035211802
      0.580541133881 0.799060463905 -0.156442731619
      0.587766945362 0.809030294418 2.08139017133e-009
      0.580541133881 0.799060463905 0.156442731619
      0.559016227722 0.769414067268 0.309035211802
      0.523704528809 0.720826208591 0.454029917717
      0.475492924452 0.654489457607 0.587835013866
      0.415581852198 0.57202398777 0.707163631916
      0.345445454121 0.475487262011 0.809060811996
      0.266799539328 0.367238491774 0.891040921211
      0.181590646505 0.249954178929 0.951077103615
      0.0919239372015 0.126532748342 0.987693965435
      0.048311945051 0.148750737309 0.98769390583
      0.0954646095634 0.293840557337 0.951075315475
      0.140265509486 0.431722313166 0.891033828259
      0.181619256735 0.558957576752 0.809061765671
      0.218485310674 0.672455012798 0.707155108452
      0.249983355403 0.769390821457 0.587831676006
      0.275317400694 0.847376942635 0.454040259123
      0.293872445822 0.904506981373 0.309040635824
      0.305192708969 0.939352631569 0.156441763043
      0.309003949165 0.951060771942 1.87764270798e-009
      0.305192708969 0.939352631569 -0.156441763043
      0.293872445822 0.904506981373 -0.309040635824
      0.275317400694 0.847376942635 -0.454040259123
      0.249983355403 0.769390821457 -0.587831676006
      0.218485325575 0.672455072403 -0.707155168056
      0.181619256735 0.558957576752 -0.809061765671
      0.140265509486 0.431722313166 -0.891033828259
      0.0954646095634 0.293840557337 -0.951075315475
      0.048311945051 0.148750737309 -0.98769390583
      0 0.156410768628 -0.987692058086
      0 0.308976322412 -0.951069712639
      0 0.453939527273 -0.891032516956
      0 0.587732434273 -0.809055328369
      0 0.707045733929 -0.707167804241
      0 0.808980226517 -0.587835967541
      0 0.890982866287 -0.454036861658
      0 0.951048851013 -0.309040516615
      0 0.987687349319 -0.156440541148
      0 1 1.49011614159e-009
      0 0.987687349319 0.156440541148
      0 0.951048851013 0.309040516615
      0 0.890982866287 0.454036861658
      0 0.808980226517 0.587835967541
      0 0.707045733929 0.707167863846
      0 0.587732434273 0.809055328369
      0 0.453939527273 0.891032516956
      0 0.308976322412 0.951069712639
      0 0.156410768628 0.987692058086
      -0.048311945051 0.148750737309 0.98769390583
      -0.0954646095634 0.293840557337 0.951075315475
      -0.140265509486 0.431722313166 0.891033828259
      -0.181619256735 0.558957576752 0.809061765671
      -0.218485310674 0.672455012798 0.707155108452
      -0.249983355403 0.769390821457 0.587831676006
      -0.275317400694 0.847376942635 0.454040259123
      -0.293872445822 0.904506981373 0.309040635824
      -0.305192708969 0.939352631569 0.156441763043
      -0.309003949165 0.951060771942 9.56739243385e-010
      -0.305192708969 0.939352631569 -0.156441763043
      -0.293872445822 0.904506981373 -0.309040635824
      -0.275317400694 0.847376942635 -0.454040259123
      -0.249983355403 0.769390821457 -0.587831676006
      -0.218485325575 0.672455072403 -0.707155168056
      -0.181619256735 0.558957576752 -0.809061765671
      -0.140265509486 0.431722313166 -0.891033828259
      -0.0954646095634 0.293840557337 -0.951075315475
      -0.048311945051 0.148750737309 -0.98769390583
      -0.0919239372015 0.126532748342 -0.987693965435
      -0.181590646505 0.249954178929 -0.951077103615
      -0.266799539328 0.367238491774 -0.891040921211
      -0.345445454121 0.475487262011 -0.809060811996
      -0.415581852198 0.57202398777 -0.707163572311
      -0.475492924452 0.654489457607 -0.587835013866
      -0.523716032505 0.720811486244 -0.454039871693
      -0.559016227722 0.769414067268 -0.309035211802
      -0.580541133881 0.799060463905 -0.156442731619
      -0.587766945362 0.809030294418 3.29708038649e-010
      -0.580541133881 0.799060463905 0.156442731619
      -0.559016227722 0.769414067268 0.309035211802
      -0.523704528809 0.720826208591 0.454029917717
      -0.475492924452 0.654489457607 0.587835013866
      -0.415581852198 0.57202398777 0.707163631916
      -0.345445454121 0.475487262011 0.809060811996
      -0.266799539328 0.367238491774 0.891040921211
      -0.181590646505 0.249954178929 0.951077103615
      -0.0919239372015 0.126532748342 0.987693965435
      -0.126532748342 0.0919239372015 0.987693965435
      -0.249954178929 0.181590646505 0.951077103615
      -0.367238491774 0.266799539328 0.891040921211
      -0.475487262011 0.345445454121 0.809060811996
      -0.57202398777 0.415581852198 0.707163572311
      -0.654489457607 0.475492924452 0.587835013866
      -0.720826208591 0.523704528809 0.454029917717
      -0.769414067268 0.559016227722 0.309035211802
      -0.799060463905 0.580541133881 0.156442731619
      -0.809030294418 0.587766945362 -3.29708038649e-010
      -0.799060463905 0.580541133881 -0.156442731619
      -0.769414067268 0.559016227722 -0.309035211802
      -0.720826208591 0.523704528809 -0.454029917717
      -0.654489457607 0.475492924452 -0.587835013866
      -0.57202398777 0.415581852198 -0.707163631916
      -0.475487262011 0.345445454121 -0.809060811996
      -0.367238491774 0.266799539328 -0.891040921211
      -0.249954178929 0.181590646505 -0.951077103615
      -0.126532748342 0.0919239372015 -0.987693965435
      -0.148750737309 0.048311945051 -0.98769390583
      -0.293840557337 0.0954646095634 -0.951075315475
      -0.431722313166 0.140265509486 -0.891033828259
      -0.558957576752 0.181619256735 -0.809061765671
      -0.672455012798 0.218485310674 -0.707155108452
      -0.769390821457 0.249983355403 -0.587831676006
      -0.847376942635 0.275317400694 -0.454040259123
      -0.904506981373 0.293872445822 -0.309040635824
      -0.939352631569 0.305192708969 -0.156441763043
      -0.951060771942 0.309003949165 -9.56739243385e-010
      -0.939352631569 0.305192708969 0.156441763043
      -0.904506981373 0.293872445822 0.309040635824
      -0.847376942635 0.275317400694 0.454040259123
      -0.769390821457 0.249983355403 0.587831676006
      -0.672455072403 0.218485325575 0.707155168056
      -0.558957576752 0.181619256735 0.809061765671
      -0.431722313166 0.140265509486 0.891033828259
      -0.293840557337 0.0954646095634 0.951075315475
      -0.148750737309 0.048311945051 0.98769390583
      -0.156410768628 0 0.987692058086
      -0.308976322412 0 0.951069712639
      -0.453939527273 0 0.891032516956
      -0.587732434273 0 0.809055328369
      -0.707061052322 0 0.707152605057
      -0.808980226517 0 0.587835967541
      -0.890982866287 0 0.454036861658
      -0.951048851013 0 0.309040516615
      -0.987687349319 0 0.156440541148
      -1 0 -1.49011614159e-009
      -0.987687349319 0 -0.156440541148
      -0.951048851013 0 -0.309040516615
      -0.890982866287 0 -0.454036861658
      -0.808980226517 0 -0.587835967541
      -0.707045733929 0 -0.707167863846
      -0.587732434273 0 -0.809055328369
      -0.453939527273 0 -0.891032516956
      -0.308976322412 0 -0.951069712639
      -0.156410768628 0 -0.987692058086
      -0.148750737309 -0.048311945051 -0.98769390583
      -0.293840557337 -0.0954646095634 -0.951075315475
      -0.431722313166 -0.140265509486 -0.891033828259
      -0.558957576752 -0.181619256735 -0.809061765671
      -0.672455012798 -0.218485310674 -0.707155108452
      -0.769390821457 -0.249983355403 -0.587831676006
      -0.847376942635 -0.275317400694 -0.454040259123
      -0.904506981373 -0.293872445822 -0.309040635824
      -0.939352631569 -0.305192708969 -0.156441763043
      -0.951060771942 -0.309003949165 -1.87764270798e-009
      -0.939352631569 -0.305192708969 0.156441763043
      -0.904506981373 -0.293872445822 0.309040635824
      -0.847376942635 -0.275317400694 0.454040259123
      -0.769390821457 -0.249983355403 0.587831676006
      -0.672455072403 -0.218485325575 0.707155168056
      -0.558957576752 -0.181619256735 0.809061765671
      -0.431722313166 -0.140265509486 0.891033828259
      -0.293840557337 -0.0954646095634 0.951075315475
      -0.148750737309 -0.048311945051 0.98769390583
      -0.126532748342 -0.0919239372015 0.987693965435
      -0.249954178929 -0.181590646505 0.951077103615
      -0.367238491774 -0.266799539328 0.891040921211
      -0.475487262011 -0.345445454121 0.809060811996
      -0.57202398777 -0.415581852198 0.707163572311
      -0.654489457607 -0.475492924452 0.587835013866
      -0.720811486244 -0.523716032505 0.454039871693
      -0.769414067268 -0.559016227722 0.309035211802
      -0.799060463905 -0.580541133881 0.156442731619
      -0.809030294418 -0.587766945362 -2.08139017133e-009
      -0.799060463905 -0.580541133881 -0.156442731619
      -0.769414067268 -0.559016227722 -0.309035211802
      -0.720811486244 -0.523716032505 -0.454039871693
      -0.654489457607 -0.475492924452 -0.587835013866
      -0.57202398777 -0.415581852198 -0.707163631916
      -0.475487262011 -0.345445454121 -0.809060811996
      -0.367238491774 -0.266799539328 -0.891040921211
      -0.249954178929 -0.181590646505 -0.951077103615
      -0.126532748342 -0.0919239372015 -0.987693965435
      -0.0919239372015 -0.126532748342 -0.987693965435
      -0.181590646505 -0.249954178929 -0.951077103615
      -0.266799539328 -0.367238491774 -0.891040921211
      -0.345445454121 -0.475487262011 -0.809060811996
      -0.415581852198 -0.57202398777 -0.707163631916
      -0.475492924452 -0.654489457607 -0.587835013866
      -0.523704528809 -0.720826208591 -0.454029917717
      -0.559016227722 -0.769414067268 -0.309035211802
      -0.580541133881 -0.799060463905 -0.156442731619
      -0.587766945362 -0.809030294418 -2.08139017133e-009
      -0.580541133881 -0.799060463905 0.156442731619
      -0.559016227722 -0.769414067268 0.309035211802
      -0.523704528809 -0.720826208591 0.454029917717
      -0.475492924452 -0.654489457607 0.587835013866
      -0.415581852198 -0.57202398777 0.707163572311
      -0.345445454121 -0.475487262011 0.809060811996
      -0.266799539328 -0.367238491774 0.891040921211
      -0.181590646505 -0.249954178929 0.951077103615
      -0.0919239372015 -0.126532748342 0.987693965435
      -0.048311945051 -0.148750737309 0.98769390583
      -0.0954646095634 -0.293840557337 0.951075315475
      -0.140265509486 -0.431722313166 0.891033828259
      -0.181619256735 -0.558957576752 0.809061765671
      -0.218485325575 -0.672455072403 0.707155168056
      -0.249983355403 -0.769390821457 0.587831676006
      -0.275317400694 -0.847376942635 0.454040259123
      -0.293872445822 -0.904506981373 0.309040635824
      -0.305192708969 -0.939352631569 0.156441763043
      -0.309003949165 -0.951060771942 -1.87764270798e-009
      -0.305192708969 -0.939352631569 -0.156441763043
      -0.293872445822 -0.904506981373 -0.309040635824
      -0.275317400694 -0.847376942635 -0.454040259123
      -0.249983355403 -0.769390821457 -0.587831676006
      -0.218485310674 -0.672455012798 -0.707155108452
      -0.181619256735 -0.558957576752 -0.809061765671
      -0.140265509486 -0.431722313166 -0.891033828259
      -0.0954646095634 -0.293840557337 -0.951075315475
      -0.048311945051 -0.148750737309 -0.98769390583
      0 -0.156410768628 -0.987692058086
      0 -0.308976322412 -0.951069712639
      0 -0.453939527273 -0.891032516956
      0 -0.587732434273 -0.809055328369
      0 -0.707045733929 -0.707167863846
      0 -0.808980226517 -0.587835967541
      0 -0.890982866287 -0.454036861658
      0 -0.951048851013 -0.309040516615
      0 -0.987687349319 -0.156440541148
      0 -1 -1.49011614159e-009
      0 -0.987687349319 0.156440541148
      0 -0.951048851013 0.309040516615
      0 -0.890982866287 0.454036861658
      0 -0.808980226517 0.587835967541
      0 -0.707061052322 0.707152605057
      0 -0.587732434273 0.809055328369
      0 -0.453939527273 0.891032516956
      0 -0.308976322412 0.951069712639
      0 -0.156410768628 0.987692058086
      0.048311945051 -0.148750737309 0.98769390583
      0.0954646095634 -0.293840557337 0.951075315475
      0.140265509486 -0.431722313166 0.891033828259
      0.181619256735 -0.558957576752 0.809061765671
      0.218485325575 -0.672455072403 0.707155168056
      0.249983355403 -0.769390821457 0.587831676006
      0.275317400694 -0.847376942635 0.454040259123
      0.293872445822 -0.904506981373 0.309040635824
      0.305192708969 -0.939352631569 0.156441763043
      0.309003949165 -0.951060771942 -9.56739243385e-010
      0.305192708969 -0.939352631569 -0.156441763043
      0.293872445822 -0.904506981373 -0.309040635824
      0.275317400694 -0.847376942635 -0.454040259123
      0.249983355403 -0.769390821457 -0.587831676006
      0.218485310674 -0.672455012798 -0.707155108452
      0.181619256735 -0.558957576752 -0.809061765671
      0.140265509486 -0.431722313166 -0.891033828259
      0.0954646095634 -0.293840557337 -0.951075315475
      0.048311945051 -0.148750737309 -0.98769390583
      0.0919239372015 -0.126532748342 -0.987693965435
      0.181590646505 -0.249954178929 -0.951077103615
      0.266799539328 -0.367238491774 -0.891040921211
      0.345445454121 -0.475487262011 -0.809060811996
      0.415581852198 -0.57202398777 -0.707163631916
      0.475492924452 -0.654489457607 -0.587835013866
      0.523716032505 -0.720811486244 -0.454039871693
      0.559016227722 -0.769414067268 -0.309035211802
      0.580541133881 -0.799060463905 -0.156442731619
      0.587766945362 -0.809030294418 -3.29708038649e-010
      0.580541133881 -0.799060463905 0.156442731619
      0.559016227722 -0.769414067268 0.309035211802
      0.523716032505 -0.720811486244 0.454039871693
      0.475492924452 -0.654489457607 0.587835013866
      0.415581852198 -0.57202398777 0.707163572311
      0.345445454121 -0.475487262011 0.809060811996
      0.266799539328 -0.367238491774 0.891040921211
      0.181590646505 -0.249954178929 0.951077103615
      0.0919239372015 -0.126532748342 0.987693965435
      0.126532748342 -0.0919239372015 0.987693965435
      0.249954178929 -0.181590646505 0.951077103615
      0.367238491774 -0.266799539328 0.891040921211
      0.475487262011 -0.345445454121 0.809060811996
      0.57202398777 -0.415581852198 0.707163631916
      0.654489457607 -0.475492924452 0.587835013866
      0.720826208591 -0.523704528809 0.454029917717
      0.769414067268 -0.559016227722 0.309035211802
      0.799060463905 -0.580541133881 0.156442731619
      0.809030294418 -0.587766945362 3.29708038649e-010
      0.799060463905 -0.580541133881 -0.156442731619
      0.769414067268 -0.559016227722 -0.309035211802
      0.720826208591 -0.523704528809 -0.454029917717
      0.654489457607 -0.475492924452 -0.587835013866
      0.57202398777 -0.415581852198 -0.707163572311
      0.475487262011 -0.345445454121 -0.809060811996
      0.367238491774 -0.266799539328 -0.891040921211
      0.249954178929 -0.181590646505 -0.951077103615
      0.126532748342 -0.0919239372015 -0.987693965435
      0.148750737309 -0.048311945051 -0.98769390583
      0.293840557337 -0.0954646095634 -0.951075315475
      0.431722313166 -0.140265509486 -0.891033828259
      0.558957576752 -0.181619256735 -0.809061765671
      0.672455072403 -0.218485325575 -0.707155168056
      0.769390821457 -0.249983355403 -0.587831676006
      0.847376942635 -0.275317400694 -0.454040259123
      0.904506981373 -0.293872445822 -0.309040635824
      0.939352631569 -0.305192708969 -0.156441763043
      0.951060771942 -0.309003949165 9.56739243385e-010
      0.939352631569 -0.305192708969 0.156441763043
      0.904506981373 -0.293872445822 0.309040635824
      0.847376942635 -0.275317400694 0.454040259123
      0.769390821457 -0.249983355403 0.587831676006
      0.672455012798 -0.218485310674 0.707155108452
      0.558957576752 -0.181619256735 0.809061765671
      0.431722313166 -0.140265509486 0.891033828259
      0.293840557337 -0.0954646095634 0.951075315475
      0.148750737309 -0.048311945051 0.98769390583
      0 0 1
   uvs none
}
