(load "SYS:CONTRIB;ASDF;ASDF.FASL")

(let ((asdf:*central-registry* nil))
  (push :sb-building-contrib *features*)
  (asdf:operate 'asdf:load-op *system*)
  (let ((stub (make-pathname :name *system* :type "lisp")))
    (when (probe-file (compile-file-pathname stub))
      (error "fasl file exists"))
    (with-open-file (s stub :direction :output :if-exists :error)
      (print '(unless (member "ASDF" *modules* :test #'string=)
               (require :asdf))
             s)
      ;; we find our contribs without reference to *central-registry*.
      (print `(let ((asdf:*central-registry* nil))
               (asdf::module-provide-asdf ,*system*))
             s))
    (compile-file stub)
    (delete-file stub)))
