/*
 * SARG Squid Analysis Report Generator      http://sarg.sourceforge.net
 *                                                            1998, 2010
 *
 * SARG donations:
 *      please look at http://sarg.sourceforge.net/donations.php
 * Support:
 *     http://sourceforge.net/projects/sarg/forums/forum/363374
 * ---------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#include "include/conf.h"
#include "include/defs.h"

static char *DownloadSuffix=NULL;
static char **DownloadSuffixIndex=NULL;
static int NDownloadSuffix=0;

void download_report(void)
{

   FILE *fp_in = NULL, *fp_ou = NULL;

   char url[2*MAXLEN];
   char report_in[MAXLEN];
   char wdirname[MAXLEN];
   char report[MAXLEN];
   char period[100];
   char ip[MAXLEN];
   char oip[MAXLEN];
   char user[MAXLEN];
   char ouser[MAXLEN];
   char ouser2[MAXLEN];
   char data[15];
   char hora[15];
   char *str;
   int  z=0;
   int  count=0;
   int i;
   struct getwordstruct gwarea;

   ouser[0]='\0';
   ouser2[0]='\0';

   sprintf(report_in,"%s/sarg/download.log",TempDir);
   if(access(report_in, R_OK) != 0)
      return;

   strcpy(wdirname,dirname);
   sprintf(report,"%s/download.html",wdirname);
   strcat(wdirname,"/");
   strcat(wdirname,"sarg-period");

   if ((fp_in = fopen(wdirname, "r")) == 0) {
      fprintf(stderr, "SARG: (download) %s: %s\n",text[45],wdirname);
      exit(1);
   }

   if (!fgets(period,sizeof(period),fp_in)) {
      fprintf(stderr,"SARG: (download) read error in %s\n",wdirname);
      exit(1);
   }
   fclose(fp_in);

   if((fp_in=MY_FOPEN(report_in,"r"))==NULL) {
     fprintf(stderr, "SARG: (download) %s: %s\n",text[8],report_in);
     exit(1);
   }

   if((fp_ou=MY_FOPEN(report,"w"))==NULL) {
     fprintf(stderr, "SARG: (download) %s: %s\n",text[8],report);
     exit(1);
   }

   fprintf(fp_ou, "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html>\n<head>\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=%s\">\n",CharSet);
   css(fp_ou);
   fputs("</head>\n",fp_ou);

   fprintf(fp_ou,"<body bgcolor=\"%s\" text=\"%s\" background=\"%s\">\n",BgColor,TxColor,BgImage);

   write_logo_image(fp_ou);

   if(strcmp(IndexTree,"date") == 0)
      show_sarg(fp_ou, "../../..");
   else
      show_sarg(fp_ou, "..");

   fputs("<div align=\"center\"><table cellpadding=\"0\" cellspacing=\"0\">\n",fp_ou);
   fprintf(fp_ou,"<tr><th class=\"title\">%s</th></tr>\n",Title);

   fprintf(fp_ou,"<tr><td class=\"header\">%s: %s</td></tr>\n",text[89],period);
   fprintf(fp_ou,"<tr><th class=\"header3\">%s</th></tr>\n",text[125]);
   fputs("</table></div>\n",fp_ou);

   fputs("<div align=\"center\"><table cellpadding=\"0\" cellspacing=\"2\">\n",fp_ou);
   fputs("<tr><td></td></tr>\n",fp_ou);
   fprintf(fp_ou,"<tr><th class=\"header\">%s</th><th class=\"header\">%s</th><th class=\"header\">%s</th><th class=\"header\">%s</th></tr>\n",text[98],text[111],text[110],text[91]);

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      getword_start(&gwarea,buf);
      if (getword(data,sizeof(data),&gwarea,'\t')<0 || getword(hora,sizeof(hora),&gwarea,'\t')<0 ||
          getword(user,sizeof(user),&gwarea,'\t')<0 || getword(ip,sizeof(ip),&gwarea,'\t')<0 ||
          getword(url,sizeof(url),&gwarea,'\t')<0) {
         printf("SARG: Maybe you have a broken record or garbage in your %s file.\n",report_in);
         exit(1);
      }

      if((str=(char *) strstr(user, "_")) != (char *) NULL ) {
         if((str=(char *) strstr(str+1, "_")) != (char *) NULL )
            fixip(user);
      }

      if(Ip2Name)
         ip2name(ip,sizeof(ip));

      if(!z) {
         strcpy(ouser,user);
         strcpy(oip,ip);
         z++;
      } else {
         if(strcmp(ouser,user) == 0)
            user[0]='\0';
         if(user[0] != '\0')
            strcpy(ouser,user);
         if(strcmp(oip,ip) == 0)
            ip[0]='\0';
         if(ip[0] != '\0')
            strcpy(oip,ip);
      }

      get_usertab_name(user,name,sizeof(name));

      if(dotinuser && strchr(name,'_')) {
         subs(name,sizeof(name),"_",".");
      }

      if(DownloadReportLimit) {
         if(strcmp(ouser2,name) == 0) {
            count++;
         } else {
            count=1;
            strcpy(ouser2,name);
         }
         if(count >= DownloadReportLimit)
            continue;
      }

      for (i=strlen(url)-1 ; i>=0 && (unsigned char)url[i]<' ' ; i--) url[i]='\0';

      fprintf(fp_ou,"<tr><td class=\"data\">%s</td><td class=\"data\">%s</td><td class=\"data\">%s-%s</td><td class=\"data2\">",name,ip,data,hora);
      if(BlockIt[0]!='\0')
         fprintf(fp_ou,"<a href=\"%s%s?url=%s\"><img src=\"%s/sarg-squidguard-block.png\" border=\"0\"></a>&nbsp;",wwwDocumentRoot,BlockIt,url,ImageFile);
      fprintf(fp_ou,"<a href=\"%s\">",url);
      output_html_string(fp_ou,url);
      fputs("</a></td></tr>\n",fp_ou);
   }

   fputs("</table>\n",fp_ou);

   show_info(fp_ou);
   fputs("</body>\n</html>\n",fp_ou);

   fclose(fp_in);
   fclose(fp_ou);

   unlink(report_in);

   return;
}

void free_download(void)
{
   if (DownloadSuffix) {
      free(DownloadSuffix);
      DownloadSuffix=NULL;
   }
   if (DownloadSuffixIndex) {
      free(DownloadSuffixIndex);
      DownloadSuffixIndex=NULL;
   }
   NDownloadSuffix=0;
}

void set_download_suffix(const char *list)
{
   char *str;
   int i, j, k;
   int cmp;

   free_download();

   DownloadSuffix=strdup(list);
   if (!DownloadSuffix) {
      fprintf(stderr,"SARG: Download suffix list too long\n");
      exit(1);
   }
   j = 1;
   for (i=0 ; list[i] ; i++)
      if (list[i] == ',') j++;
   DownloadSuffixIndex=malloc(j*sizeof(char *));
   if (!DownloadSuffixIndex) {
      fprintf(stderr,"SARG: Too many download suffixes\n");
      exit(1);
   }

   str = DownloadSuffix;
   for (i=0 ; DownloadSuffix[i] ; i++) {
      if (DownloadSuffix[i] == ',') {
         DownloadSuffix[i] = '\0';
         if (*str) {
            cmp = -1;
            for (j=0 ; j<NDownloadSuffix && (cmp=strcasecmp(str,DownloadSuffixIndex[j]))>0 ; j++);
            if (cmp != 0) {
               for (k=NDownloadSuffix ; k>j ; k--)
                  DownloadSuffixIndex[k]=DownloadSuffixIndex[k-1];
               NDownloadSuffix++;
               DownloadSuffixIndex[j]=str;
            }
         }
         str=DownloadSuffix+i+1;
      }
   }

   if (*str) {
      cmp = -1;
      for (j=0 ; j<NDownloadSuffix && (cmp=strcasecmp(str,DownloadSuffixIndex[j]))>0 ; j++);
      if (cmp != 0) {
         for (k=NDownloadSuffix ; k>j ; k--)
            DownloadSuffixIndex[k]=DownloadSuffixIndex[k-1];
         NDownloadSuffix++;
         DownloadSuffixIndex[j]=str;
      }
   }
}

int is_download_suffix(const char *url)
{
   int urllen;
   int i;
   int down, up, center;
   const char *suffix;
   int cmp;
   const int max_suffix=10;

   if (DownloadSuffix == NULL || NDownloadSuffix == 0) return(0);

   urllen=strlen(url)-1;
   if (urllen<=0) return(0);
   if (url[urllen] == '.') return(0); //reject a single trailing dot
   for (i=0 ; i<urllen && (url[i]!='/' || url[i+1]=='/') && url[i]!='?' ; i++);
   if (i>=urllen) return(0); // url is a hostname without any path or file to download

   for (i=0 ; i<=max_suffix && i<urllen && url[urllen-i]!='.' ; i++)
      if (url[urllen-i] == '/' || url[urllen-i] == '?') return(0);
   if (i>max_suffix || i>=urllen) return(0);

   suffix=url+urllen-i+1;
   down=0;
   up=NDownloadSuffix-1;
   while (down<=up) {
      center=(down+up)/2;
      cmp=strcasecmp(suffix,DownloadSuffixIndex[center]);
      if (cmp == 0) return(1);
      if (cmp < 0)
         up = center-1;
      else
         down = center+1;
   }
   return(0);
}

