/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: transferable.cxx,v $
 * $Revision: 1.4 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_dtrans.hxx"
#include "transferable.hxx"

//----------------------------------------------------------------
//	ctor
//----------------------------------------------------------------



CTransferable::CTransferable( wchar_t* dataString ) :
	m_seqDFlv( 1 ),
	m_Data( dataString )
{
	DataFlavor df;
	
	/*
	df.MimeType = L"text/plain; charset=unicode";
	df.DataType = getCppuType( ( OUString* )0 );

	m_seqDFlv[0] = df;
	*/
	
	//df.MimeType = L"text/plain; charset=windows1252";
	df.MimeType = L"text/plain";
	df.DataType = getCppuType( ( Sequence< sal_Int8 >* )0 );


	m_seqDFlv[0] = df;	
}

//----------------------------------------------------------------
//	getTransferData
//----------------------------------------------------------------

Any SAL_CALL CTransferable::getTransferData( const DataFlavor& aFlavor ) 
	throw(UnsupportedFlavorException, IOException, RuntimeException)
{	
	Any anyData;

	/*if ( aFlavor == m_seqDFlv[0] )
	{
		anyData = makeAny( m_Data );
	}
	else*/ if ( aFlavor == m_seqDFlv[0] )
	{
		OString aStr( m_Data.getStr( ), m_Data.getLength( ), 1252 );
		Sequence< sal_Int8 > sOfChars( aStr.getLength( ) );
		sal_Int32 lenStr = aStr.getLength( );

		for ( sal_Int32 i = 0; i < lenStr; ++i )
			sOfChars[i] = aStr[i];

		anyData = makeAny( sOfChars );
	}

	return anyData;
}

//----------------------------------------------------------------
//	getTransferDataFlavors
//----------------------------------------------------------------

Sequence< DataFlavor > SAL_CALL CTransferable::getTransferDataFlavors(  ) 
	throw(RuntimeException)
{
	return m_seqDFlv;
}

//----------------------------------------------------------------
//	isDataFlavorSupported
//----------------------------------------------------------------

sal_Bool SAL_CALL CTransferable::isDataFlavorSupported( const DataFlavor& aFlavor ) 
	throw(RuntimeException)
{
	sal_Int32 nLength = m_seqDFlv.getLength( );
	sal_Bool bRet     = sal_False;

	for ( sal_Int32 i = 0; i < nLength; ++i )
	{
		if ( m_seqDFlv[i] == aFlavor )
		{
			bRet = sal_True;
			break;
		}
	}

	return bRet;
}

//----------------------------------------------------------------
//	lostOwnership
//----------------------------------------------------------------

void SAL_CALL CTransferable::lostOwnership( const Reference< XClipboard >& xClipboard, const Reference< XTransferable >& xTrans ) 
	throw(RuntimeException)
{
}
