/* Copyright (C) 2006 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#ifndef _MWSYNCHRONIZEDATABASE_H_
#define _MWSYNCHRONIZEDATABASE_H__

#include <MySQLGRT/MGRTWizardBase.h>

#include <gtkmm/liststore.h>
#include <gtkmm/treestore.h>
#include <gtkmm/sizegroup.h>

#include "MGCellRenderer.h"

class MGGladeXML;
class MGRTRevEngFilterPane;

class MWSynchronizeDatabase : public MGRTWizardBase {
  protected:
    class Columns : public Gtk::TreeModel::ColumnRecord {
      public:
        Columns() {
          add(icon); add(text); add(value);
        };
        Gtk::TreeModelColumn<Glib::RefPtr<Gdk::Pixbuf> > icon;
        Gtk::TreeModelColumn<Glib::ustring> text;
        Gtk::TreeModelColumn<MGRTValue> value;
    } _columns;

    class ActionColumns : public Gtk::TreeModel::ColumnRecord {
      public:
        ActionColumns() {
          add(icon); 
          add(db_object);
          add(model_object);
          add(action_text);
          add(value);
        };
        Gtk::TreeModelColumn<Glib::RefPtr<Gdk::Pixbuf> > icon;
        Gtk::TreeModelColumn<Glib::ustring> db_object;
        Gtk::TreeModelColumn<Glib::ustring> model_object;
        Gtk::TreeModelColumn<Glib::ustring> action_text;
        Gtk::TreeModelColumn<MGRTValue> value;
    } _acolumns;

    MGRTConnectDialog *_conn_panel;

    MGRTValue *_schema_list;
    MGRTValue *_catalog;
    MGRTValue *_changes_tree;
   
    bool _connect_ok;
    
    Glib::RefPtr<Gtk::TreeStore> _action_store;
    Glib::RefPtr<Gtk::ListStore> _schema_store;

    virtual void setup();
   
    void action_toggled(const Glib::ustring &path);

    void changed_schema_selection();
    void changes_get_done(const MGRTValue &result, bool error, void *data);
    void schemata_fetches_done(const MGRTValue &result, bool error, void *data);
    void perform_schemata_fetches(bool back);
    void refresh_schemata_list();
    
    void perform_schemata_selection(bool back);
    bool build_object_selection();
    
    void reverse_engineering_done(const MGRTValue &result, bool error, void *data);
    void perform_reverse_engineering(bool back);

    void show_script_preview();

    void sync_data_done(const MGRTValue &result, bool error, void *data);
    void perform_action_selection(bool back);
    
    void finalize_done(const MGRTValue &result, bool error, void *data);
    void finalize_synchronization();
    
    bool collect_and_show_errors(MGRTValue tree);

    Glib::ustring collect_sql_script(MGRTValue tree);

    void set_action_text(Gtk::TreeRow &row, const MGRTValue &value);
    void fill_action_tree(Gtk::TreeIter iter, MGRTValue value);
    void refresh_action_list();

    void connect_ready_changed(bool ready);
   
    virtual bool validate_section();
    virtual void update_advanced();
    virtual void update_section(bool back);

  public:
    MWSynchronizeDatabase(GtkWindow *win);
    virtual ~MWSynchronizeDatabase();

    static MWSynchronizeDatabase *create(MGRT *grt);
    
    virtual void set_grt(MGRT *grt);
};

#endif /* __MWSYNCHRONIZEDATABASE_H__ */
