/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#ifndef _KDISSERT_H
#define _KDISSERT_H

#include <qvaluelist.h>

#include <kapplication.h>
#include <kmdimainfrm.h>
#include <kurl.h>

class KToggleAction;
class KRecentFilesAction;
class KMdiChildView;
class QWidgetStack;
class KDissertView;
class TextProperties;
class MiscProperties;
class Systray;

/**
 * This class serves as the main window for kdissert.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author Thomas Nagy <tnagy2^8@yahoo.fr>
 * @version 0.3.1
 */
class KDissert : public KMdiMainFrm
{
    Q_OBJECT
    public:
	KDissert( KMdi::MdiMode mode );
	virtual ~KDissert();
	void showTipOnStart();

    public slots:
	void slotFileNew();
	void openURL( const KURL& );
    	void slotFocusOnTPanel();
	void slotFocusOnMap();
	void slotSetStatusBarText(const QString &);

    protected:
	virtual void dragEnterEvent(QDragEnterEvent *event);
	virtual void dropEvent(QDropEvent *event);
	virtual bool queryClose();

    private slots:
	void slotFileOpen();
	void slotFileClose();
	void slotFileQuit();

	/// this is called when a new file is saved
	void slotFileOpened(const KURL & url);

	void showTip();

	void optionsShowToolbar();
	void optionsShowStatusbar();
	void optionsConfigureKeys();
	void optionsConfigureToolbars();
	void optionsPreferences();
	//void newToolbarConfig();

	//void changeCaption(const QString& text);

	void currentChanged( KMdiChildView *current );
	bool requestClose(KMdiChildView* view);

	void settingsChanged();

    private:
	void setupAccel();
	void setupActions();

	QValueList<KDissertView*> m_views;
	
	KToggleAction *m_toolbarAction;
	KToggleAction *m_statusbarAction;
	KRecentFilesAction *m_openRecentAction;

	KParts::PartManager *m_manager;

	QWidgetStack *m_treeviewstack;
	QWidgetStack *m_navigationstack;
	TextProperties *m_textproperties;
	MiscProperties *m_miscproperties;

	QFrame *m_lframe;
	QFrame *m_cframe;
	KMdiToolViewAccessor* m_textpropertiestoolview;
	KMdiToolViewAccessor* m_listtoolview;
	KMdiToolViewAccessor* m_navtoolview;
	KMdiToolViewAccessor* m_misctoolview;
};

#endif // _KDISSERT_H
