#ifndef KADU_COLOR_SELECTOR_H
#define KADU_COLOR_SELECTOR_H

#include <qpushbutton.h>
#include <qcolor.h>
#include <qwidget.h>

class QCloseEvent;

extern const char colors[16][8];

/**
	\class ColorSelectorButton
	\brief Klasa do wyboru koloru za pomoc przycisku
**/
class ColorSelectorButton : public QPushButton
{
	Q_OBJECT

	private:
		QColor color; /*!< kolor czcionki */

	private slots:
		/**
			\fn void buttonClicked()
			Slot obsugujcy nacinicie przycisku
		**/
		void buttonClicked();

	public:
		/**
			\fn ColorSelectorButton(QWidget* parent, const QColor& qcolor, int width=1, const char *name=0)
			Konstruktor tworzcy okno do wyboru koloru
			\param parent rodzic okna
			\param qcolor kolor
			\param width
			\param name nazwa obiektu
		**/
		ColorSelectorButton(QWidget* parent, const QColor& qcolor, int width=1, const char *name=0);

	signals:
		/**
			\fn void clicked(const QColor& color)
			Sygna zostaje wysany po wybraniu koloru
		**/
		void clicked(const QColor& color);
};

/**
	\class ColorSelector
	\brief Klasa do wyboru kolorw
**/
class ColorSelector : public QWidget
{
	Q_OBJECT

	private slots:
		/**
			\fn void iconClicked(const QColor& color);
			Slot obsugujcy wybranie koloru
			\param color wybrany kolor
		**/
		void iconClicked(const QColor& color);

	protected:
		/**
			\fn void closeEvent(QCloseEvent*)
			Funkcja obsugujca zamknicie okna wyboru kolorw
		**/
		void closeEvent(QCloseEvent*);

	public:
		/**
			\fn ColorSelector(const QColor &defColor, QWidget* parent = 0, const char* name = 0)
			Konstruktor obiektu do wyboru kolorw
			\param defColor
			\param parent rodzic okna
			\param name nazwa obiektu
		**/
		ColorSelector(const QColor &defColor, QWidget* parent = 0, const char* name = 0);

	public slots:
		/**
			\fn void alignTo(QWidget* w)
		  	Slot wyrwnuje pozycj do widgeta
			\param w wkanik do obiektu ktorego bdziemy wyrwnywac
		**/
		void alignTo(QWidget* w);

	signals:
		/**
			\fn void aboutToClose()
			Sygna jest emitowany gdy zamykany jest wybr kolorw
		**/
		void aboutToClose();

		/**
			\fn void colorSelect(const QColor&)
			Sygna jest emitowany gdy wybrano kolor

		**/
		void colorSelect(const QColor&);
};

#endif
