#ifndef KADU_CHAT_COLORS_H
#define KADU_CHAT_COLORS_H

#include <qcolor.h>

/**
	Klasa opisujca kolory wykorzystywane
	w oknie rozmowy.
	\class ChatColors
	\brief Kolory w oknie Chat
**/
class ChatColors
{
	private:
		QColor BackgroundColor; /*!< kolor ta */
		QColor FontColor; /*!< kolor czcionki */
		QColor NickColor; /*!< kolor nicku */

	public:
		/**
			Konstruktor kolorw dla okna Chat
			\fn ChatColors(const QColor& background_color,
				const QColor& font_color,
				const QColor& nick_color)
			\param background_color kolor ta
			\param font_color kolor czcionki
			\param nick_color kolor nicku
		**/
		ChatColors(const QColor& background_color,
			const QColor& font_color,
			const QColor& nick_color);

		/**
			\fn const QColor& backgroundColor() const
			Zwraca kolor ta
		**/
		const QColor& backgroundColor() const;

		/**
			\fn const QColor& fontColor() const
			Zwraca kolor czcionki
		**/
		const QColor& fontColor() const;

		/**
			\fn const QColor& nickColor() const
			Zwraca kolor nicku
		**/
		const QColor& nickColor() const;
};

/**
	Klasa opisujca kolory wasne uytkownika
	\class OwnChatColors
	\brief Kolory wasne
**/
class OwnChatColors : public ChatColors
{
	public:
		/**
			\fn UserChatColors()
			Konstruktor kolorw wasnych
		**/
		OwnChatColors();
};

/**
	Klasa opisujca kolory rozmwcy
	\class UserChatColors
	\brief Kolory rozmwcy
**/
class UserChatColors : public ChatColors
{
	public:
		/**
			\fn UserChatColors()
			Konstruktor kolorw rozmwcy
		**/
		UserChatColors();
};

#endif
