/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "formula_view.h"

#include "debug.h"

const int FormulaView::margin = 5;

FormulaView::FormulaView(QString fileName, QWidget *parent, const char *name)
: QWidget(parent, name)
{
	kdebugf();
	tmpFileName = fileName;
	formulaPixmap.load(tmpFileName);
	resize(width(), height());
	fillView();
	kdebugf2();
}

FormulaView::~FormulaView()
{
	kdebugf();
	kdebugf();
}

void FormulaView::cleanView()
{
	kdebugf();
	QPixmap::setDefaultOptimization(QPixmap::MemoryOptim);
	cleanPixmap.resize(width(), height());
	cleanPixmap.fill(Qt::white);
	bitBlt(this, 0, 0, &cleanPixmap, 0, 0, -1, -1, Qt::CopyROP, FALSE);
	kdebugf2();
}

void FormulaView::fillView()
{
	kdebugf();
	const int formulaViewMinWidth = 300;
	const int formulaViewMinHeight = 250;
	cleanView();
	formulaPixmap.fill(Qt::white);
	formulaPixmap.load(tmpFileName);
	if(formulaPixmap.width() > formulaViewMinWidth)
	{
		kdebugm(KDEBUG_INFO, "Zmieniam szerokosc formulaView na %d\n", formulaPixmap.width());
		setMinimumWidth(formulaPixmap.width());
	}
	if(formulaPixmap.height() > formulaViewMinHeight)
	{
		kdebugm(KDEBUG_INFO, "Zmieniam wysokosc formulaView na %d\n", formulaPixmap.height());
		setMinimumHeight(formulaPixmap.height());
	}
	bitBlt(this, margin, margin, &formulaPixmap, 0, 0, -1, -1, Qt::CopyROP, FALSE);
	kdebugf2();
}

void FormulaView::paintEvent (QPaintEvent *paintEvent)
{
	kdebugf();
	fillView();
	kdebugf2();
}
