/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 /*
 * autor:
 * Tomasz "Dorr(egaray)" Rostański
 * rozteck (at) interia.pl
 *
 * najnowsza wersja zawsze dostepna pod adresem: 
 * http://www.kadu.net/~dorr/pcspeaker_current.tar.gz
 *
 * wersja 0.5.0.3
 */
 
#include "pcspeaker.h"
#include "debug.h"
#include "config_dialog.h"
#include "misc.h"
#include <modules.h>
#include <qlineedit.h>
#include <qslider.h>
#include <qvgroupbox.h>
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <unistd.h>

//czestotliwosci dzwiekow
//wiersze - dzwieki: C, C#, D, D#, E, F, F#, G, G#, A, A#, B
//kolumny to oktawy - od 0 do 7
int dzwieki[96]={
	16,33, 65,131,262,523,1046,2093,
	17,35, 69,139,277,554,1109,2217,
	18,37, 73,147,294,587,1175,2349,
	19,39, 78,155,311,622,1244,2489,
	21,41, 82,165,330,659,1328,2637,
	22,44, 87,175,349,698,1397,2794,
	23,46, 92,185,370,740,1480,2960,
	24,49, 98,196,392,784,1568,3136,
	26,52,104,208,415,831,1661,3322,
	27,55,110,220,440,880,1760,3520,
	29,58,116,233,466,932,1865,3729,
	31,62,123,245,494,988,1975,3951};

PCSpeaker *PCSpeakerObj;

void PCSpeaker::beep(int pitch, int duration)
{	
	if (pitch == 0) 
		usleep(duration*200);
	else
	{  	
		XKeyboardState s;						//zachowuje stare parametry dzwieku
		XGetKeyboardControl(xdisplay, &s);
		XKeyboardControl v;					//dla 0 nie wysyla zadnego dzwieku tylko odczekuje podany czas
    	v.bell_pitch=pitch;					//dzwiek w Hz
		v.bell_duration=duration;			//czas trwania w ms
		v.bell_percent=100;					//ustawiamy glosnosc na maks				
    	XChangeKeyboardControl(xdisplay, (KBBellPitch | KBBellDuration | KBBellPercent), &v); //ustawia parametry dzwieku
    	XBell(xdisplay, volume);  			//robimy pik skalujac glosnosc wzgledem maksa
		XFlush(xdisplay);					//czysci bufor wywalajac na display i powodujac de facto pik
		usleep(pitch*100);					//poczeka az skonczy pipac
		v.bell_pitch=s.bell_pitch;			//odzyskuje stare parametry
		v.bell_duration=s.bell_duration;
		v.bell_percent=s.bell_percent;
		XChangeKeyboardControl(xdisplay, (KBBellPitch | KBBellDuration | KBBellPercent), &v); //ustawia poprzednie parametry dzwieku
	}
}

extern "C" int pcspeaker_init()
{  	
	kdebugf();
	PCSpeakerObj = new PCSpeaker();
	//podpina sie pod sygnaly z Kadu
	ConfigDialog::connectSlot("PC Speaker", "Test1", SIGNAL(clicked()), PCSpeakerObj, SLOT(test1()));
	ConfigDialog::connectSlot("PC Speaker", "Test2", SIGNAL(clicked()), PCSpeakerObj, SLOT(test2()));
	ConfigDialog::connectSlot("PC Speaker", "Test3", SIGNAL(clicked()), PCSpeakerObj, SLOT(test3()));
	ConfigDialog::connectSlot("PC Speaker", "Test4", SIGNAL(clicked()), PCSpeakerObj, SLOT(test4()));
	ConfigDialog::connectSlot("PC Speaker", "Test5", SIGNAL(clicked()), PCSpeakerObj, SLOT(test5()));

	//ConfigDialog::registerSlotOnCreate(PCSpeakerObj, SLOT(OpenConfig()));
	ConfigDialog::registerSlotOnCreateTab("PC Speaker", PCSpeakerObj, SLOT(OpenConfig()));
	
	kdebugf2();
   	return 0;
}


extern "C" 
void pcspeaker_close()
{	
	kdebugf();
	//odlacza sie od sygnalow
	ConfigDialog::disconnectSlot("PC Speaker", "Test1", SIGNAL(clicked()), PCSpeakerObj, SLOT(test1()));
	ConfigDialog::disconnectSlot("PC Speaker", "Test2", SIGNAL(clicked()), PCSpeakerObj, SLOT(test2()));
	ConfigDialog::disconnectSlot("PC Speaker", "Test3", SIGNAL(clicked()), PCSpeakerObj, SLOT(test3()));
	ConfigDialog::disconnectSlot("PC Speaker", "Test4", SIGNAL(clicked()), PCSpeakerObj, SLOT(test4()));
	ConfigDialog::disconnectSlot("PC Speaker", "Test5", SIGNAL(clicked()), PCSpeakerObj, SLOT(test5()));

	//ConfigDialog::unregisterSlotOnCreate(PCSpeakerObj, SLOT(OpenConfig()));
	ConfigDialog::unregisterSlotOnCreateTab("PC Speaker", PCSpeakerObj, SLOT(OpenConfig()));
	
	delete(PCSpeakerObj);
	kdebugf2();
} 


PCSpeaker::PCSpeaker()
{	
	//dodaje pozycje do konfiguracji
	ConfigDialog::addTab("PC Speaker", "SoundsTab");
	ConfigDialog::addHBox("PC Speaker", "PC Speaker", "SpeakerVolume");		
	ConfigDialog::addGrid("PC Speaker", "SpeakerVolume", "volume", 40);
	ConfigDialog::addLabel("PC Speaker", "SpeakerVolume", QT_TRANSLATE_NOOP("@default","Speaker volume"));
	ConfigDialog::addSlider("PC Speaker", "SpeakerVolume", "slider", "SpeakerVolume", -100, 100, 40, 100);
	ConfigDialog::addVGroupBox("PC Speaker", "PC Speaker", QT_TRANSLATE_NOOP("@default","Sounds"));
	ConfigDialog::addLineEdit("PC Speaker", "Sounds", QT_TRANSLATE_NOOP("@default", "On message play"), "OnMessagePlayString", "D4/4",
        QT_TRANSLATE_NOOP("@default", "Put the played sounds separate by space, _ for pause, eg. D2 C1# G0"));
	ConfigDialog::addPushButton("PC Speaker", "Sounds", QT_TRANSLATE_NOOP("@default", "Test1"));	
	ConfigDialog::addLineEdit("PC Speaker", "Sounds", QT_TRANSLATE_NOOP("@default", "On chat play"), "OnChatPlayString", "A4/4",
        QT_TRANSLATE_NOOP("@default", "Put the played sounds separate by space, _ for pause, eg. D2 C1# G0"));	
	ConfigDialog::addPushButton("PC Speaker", "Sounds", QT_TRANSLATE_NOOP("@default", "Test2"));
	ConfigDialog::addLineEdit("PC Speaker", "Sounds", QT_TRANSLATE_NOOP("@default", "On nofify play"), "OnNotifyPlayString", "E4/4",
        QT_TRANSLATE_NOOP("@default", "Put the played sounds separate by space, _ for pause, eg. D2 C1# G0"));
	ConfigDialog::addPushButton("PC Speaker", "Sounds", QT_TRANSLATE_NOOP("@default", "Test3"));
	ConfigDialog::addLineEdit("PC Speaker", "Sounds", QT_TRANSLATE_NOOP("@default", "On connection error play"), "OnConnectionErrorPlayString", "F4/4",
        QT_TRANSLATE_NOOP("@default", "Put the played sounds separate by space, _ for pause, eg. D2 C1# G0"));
	ConfigDialog::addPushButton("PC Speaker", "Sounds", QT_TRANSLATE_NOOP("@default", "Test4"));
	ConfigDialog::addLineEdit("PC Speaker", "Sounds", QT_TRANSLATE_NOOP("@default", "On other messages play"), "OnOtherMessagePlayString", "F4/4",
        QT_TRANSLATE_NOOP("@default", "Put the played sounds separate by space, _ for pause, eg. D2 C1# G0"));
	ConfigDialog::addPushButton("PC Speaker", "Sounds", QT_TRANSLATE_NOOP("@default", "Test5"));
	ConfigDialog::addHBox("PC Speaker", "PC Speaker", "Info");	
	ConfigDialog::addLabel("PC Speaker", "Info", QT_TRANSLATE_NOOP("@default", "Please select events you want to be notified on using Notify tab in Configuration window."));
	
	QMap<QString, QString> s;
	s["NewChat"]=SLOT(newChat(Protocol *, UserListElements, const QString &, time_t));
	s["NewMessage"]=SLOT(newMessage(Protocol *, UserListElements, const QString &, time_t, bool &));
	s["ConnError"]=SLOT(connectionError(Protocol *, const QString &));
	s["toAvailable"]=SLOT(userChangedStatusToAvailable(const QString &, UserListElement));
	s["toBusy"]=SLOT(userChangedStatusToBusy(const QString &, UserListElement));
	s["toInvisible"]=SLOT(userChangedStatusToInvisible(const QString &, UserListElement));
	s["toNotAvailable"]=SLOT(userChangedStatusToNotAvailable(const QString &, UserListElement));

	s["StatusChanged"]=SLOT(userStatusChanged(UserListElement, QString, const UserStatus &));
	s["Message"]=SLOT(message(const QString &, const QString &, const QMap<QString, QVariant> *, const UserListElement *));
	s["fileTransferIncomingFile"]=SLOT(externalEvent(const QString &notifyType, const QString &msg, const UserListElements &ules));

	notify->registerNotifier(QT_TRANSLATE_NOOP("@default", "PC Speaker"), this, s);
}


PCSpeaker::~PCSpeaker()
{	
	//usuniecie pozycji z konfiguracji
	ConfigDialog::removeControl("PC Speaker", "On message play");
	ConfigDialog::removeControl("PC Speaker", "Test1");
    	ConfigDialog::removeControl("PC Speaker", "On chat play");
	ConfigDialog::removeControl("PC Speaker", "Test2");
	ConfigDialog::removeControl("PC Speaker", "On nofify play");
	ConfigDialog::removeControl("PC Speaker", "Test3");
	ConfigDialog::removeControl("PC Speaker", "On connection error play");
	ConfigDialog::removeControl("PC Speaker", "Test4");
	ConfigDialog::removeControl("PC Speaker", "On other messages play");
	ConfigDialog::removeControl("PC Speaker", "Test5");
	ConfigDialog::removeControl("PC Speaker", "slider");
	ConfigDialog::removeControl("PC Speaker", "volume");
	ConfigDialog::removeControl("PC Speaker", "Speaker volume");
	ConfigDialog::removeControl("PC Speaker", "SpeakerVolume");
	ConfigDialog::removeControl("PC Speaker", "Sounds");
	ConfigDialog::removeControl("PC Speaker", "Please select events you want to be notified on using Notify tab in Configuration window.");
	ConfigDialog::removeControl("PC Speaker", "Info");
   	 ConfigDialog::removeTab("PC Speaker");
	
	notify->unregisterNotifier("PC Speaker");
}

void PCSpeaker::newMessage(Protocol *protocol, UserListElements senders, const QString &msg, time_t t, bool &grab)
{	
	kdebugf();
	QString linia = config_file.readEntry("PC Speaker", "OnMessagePlayString");
	if (linia.length()>0)
		parseAndPlay(linia);	
	kdebugf2();	
}

void PCSpeaker::newChat(Protocol *protocol, UserListElements senders, const QString &msg, time_t t)
{	
	kdebugf();
	QString linia = config_file.readEntry("PC Speaker", "OnChatPlayString");
	if (linia.length()>0)
		parseAndPlay(linia);
	kdebugf2();
}

void PCSpeaker::userStatusChanged(UserListElement ule, QString protocolName, const UserStatus &oldStatus)
{	
	kdebugf();
	QString linia = config_file.readEntry("PC Speaker", "OnNotifyPlayString");
	if (linia.length()>0)
		parseAndPlay(linia);
	kdebugf2();
}

void PCSpeaker::userChangedStatusToAvailable(const QString &protocolName, UserListElement)
{	
	kdebugf();
	QString linia = config_file.readEntry("PC Speaker", "OnNotifyPlayString");
	if (linia.length()>0)
		parseAndPlay(linia);
	kdebugf2();
}

void PCSpeaker::userChangedStatusToBusy(const QString &protocolName, UserListElement)
{	
	kdebugf();
	QString linia = config_file.readEntry("PC Speaker", "OnNotifyPlayString");
	if (linia.length()>0)
		parseAndPlay(linia);
	kdebugf2();
}

void PCSpeaker::userChangedStatusToInvisible(const QString &protocolName, UserListElement)
{	
	kdebugf();
	QString linia = config_file.readEntry("PC Speaker", "OnNotifyPlayString");
	if (linia.length()>0)
		parseAndPlay(linia);
	kdebugf2();
}

void PCSpeaker::userChangedStatusToNotAvailable(const QString &protocolName, UserListElement)
{	
	kdebugf();
	QString linia = config_file.readEntry("PC Speaker", "OnNotifyPlayString");
	if (linia.length()>0)
		parseAndPlay(linia);
	kdebugf2();
}


void PCSpeaker::connectionError(Protocol *protocol, const QString &message)
{
	kdebugf();
	QString linia = config_file.readEntry("PC Speaker", "OnConnectionErrorPlayString");
	if (linia.length()>0)
		parseAndPlay(linia);
	kdebugf2();
}

void PCSpeaker::message(const QString &from, const QString &message, const QMap<QString, QVariant> *parameters, const UserListElement *ule)
{
	kdebugf();
	QString linia = config_file.readEntry("PC Speaker", "OnOtherMessagePlayString");
	if (linia.length()>0)
		parseAndPlay(linia);
	kdebugf2();
}	

void PCSpeaker::externalEvent(const QString &notifyType, const QString &msg, const UserListElements &ules)
{
	kdebugf();

	QString linia = config_file.readEntry("PC Speaker", "OnOtherMessagePlayString");
	if (linia.length()>0)
		parseAndPlay(linia);

	kdebugf2();
}


void PCSpeaker::ParseStringToSound(QString linia, int tablica[21], int tablica2[21])
{	
	unsigned int dlugosc = linia.length();
	linia = linia.upper();					//zamienia na wielkie litery
	int pom, k=0;							//k - indeksuje tablice dzwiekow a pom przechowuje indeks dzwieku w tabl.
	char znak, pom3;						//aktualny znak przetwazanego Qstringa
	unsigned int i;
	if (dlugosc>0)
	for (i=0; i<dlugosc; ++i)				//dla kazdego dzwieku
		{	if (k == 20) break;
			znak=linia[i].latin1();
			switch (znak)					//oblicz przesuniecie w tabl. dzwiekow
			{
				case 'C':  pom=0;	break;
				case 'D':  pom=2;	break;
				case 'E':  pom=4;	break;
				case 'F':  pom=5;	break;
				case 'G':  pom=7;	break;
				case 'A':  pom=9;	break;	 	
				case 'B':  pom=11;	break;
				case '_':  {	tablica[k]=0; 				//jak _ to zrob pauze
							pom=-1;
							if (linia[i+1]=='/')			//to jest ustawienie dlugosci pauzy
							{	if (linia[i+2]=='F') pom3=16;
								else if ((linia[i+2]>='1') && (linia[i+2]<='8')) 
									pom3=linia[i+2].latin1()-48;
								else pom3=1;
								tablica2[k]=(1000/pom3);
								i+=2;
							}
							else tablica2[k]=1000;				//jak nie podana to 1000			
							++k;
						} break;	
				default: pom=-1;					
			}
			if (pom>=0)
				{	pom*=8;
					if (linia[i+1]=='#')						//jak byl polton
						{	pom+=8;								//ustaw przesuniecie
							++i;								//przeskocz dalej
						}
					if ((linia[i+1]>='0') && (linia[i+1]<='7'))	
					 	{ 	pom+=linia[i+1].latin1()-48;		//ustaw przesuniecie o podana oktawe				
							++i;								//przeskocz dalej
						}
					if (linia[i+1]=='#')						//jak byl polton
						{	pom+=8;								//ustaw przesuniecie
							++i;								//przeskocz dalej
						}
					tablica[k]=dzwieki[pom];					//wpisz do tablicy czestotliwosc dzwieku
					if (linia[i+1]=='/')
						{	pom3=0;								//ustaw dlugosc dzwieku
							if (linia[i+2]=='F') pom3=16;
							else if ((linia[i+2]>='1') && (linia[i+2]<='8')) pom3=linia[i+2].latin1()-48;
								else pom3=1;
							tablica2[k]=(1000/pom3);
							i+=2;
						}
					else tablica2[k]=1000;						//jak nie podana to walnij 1000
					++k;										//przeskocz dalej w tablicy dzwiekow
				}													
		}
	tablica[k]=-1;												//na koncu zawsze musi byc -1
}

void PCSpeaker::test1()
{	
	QString linia=ConfigDialog::getLineEdit("PC Speaker", "On message play")->text();
	volume=ConfigDialog::getSlider("PC Speaker", "slider")->value();
	if (linia.length()>0)
		parseAndPlay(linia);
}

void PCSpeaker::test2()
{	
	QString linia=ConfigDialog::getLineEdit("PC Speaker", "On chat play")->text();
	volume=ConfigDialog::getSlider("PC Speaker", "slider")->value();
	if (linia.length()>0)
		parseAndPlay(linia);
}

void PCSpeaker::test3()
{	
	QString linia=ConfigDialog::getLineEdit("PC Speaker", "On nofify play")->text();
	volume=ConfigDialog::getSlider("PC Speaker", "slider")->value();
	if (linia.length()>0)
		parseAndPlay(linia);
}

void PCSpeaker::test4()
{	
	QString linia=ConfigDialog::getLineEdit("PC Speaker", "On connection error play")->text();
	volume=ConfigDialog::getSlider("PC Speaker", "slider")->value();
	if (linia.length()>0)
		parseAndPlay(linia);
}

void PCSpeaker::test5()
{	
	QString linia=ConfigDialog::getLineEdit("PC Speaker", "On other messages play")->text();
	volume=ConfigDialog::getSlider("PC Speaker", "slider")->value();
	if (linia.length()>0)
		parseAndPlay(linia);
}

void PCSpeaker::OpenConfig()
{
	QVGroupBox *groupBox = ConfigDialog::getVGroupBox("PC Speaker", "Sounds");
	if (groupBox != NULL)
	{
		groupBox->setInsideMargin(10);
		groupBox->setColumns(2);
		groupBox->setInsideSpacing(4);
	}
}

void PCSpeaker::play(int sound[21], int soundlength[20])
{
	xdisplay = XOpenDisplay(NULL);
	for (int i=0; i<20; ++i)
	{	
		if (sound[i] == -1) break;	
			beep(sound[i], soundlength[i]);
	}
	XCloseDisplay(PCSpeakerObj->xdisplay);	
}

void PCSpeaker::parseAndPlay(QString linia) 
{
	volume = config_file.readNumEntry("PC Speaker", "SpeakerVolume");	
	int sound[21], soundLength[20];
	ParseStringToSound(linia, sound, soundLength);
	play(sound, soundLength);	
}
