/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * autor
 * Michal Podsiadlik
 * michal at gov.one.pl 
 */
#include <qpopupmenu.h>
#include <qtooltip.h>

#include <gadu.h>
#include <debug.h>
#include <config_dialog.h>
#include <userbox.h>
#include <kadu_text_browser.h>
#include <icons_manager.h>
#include <action.h>

#include "tabs.h"

extern "C" int tabs_init()
{
	tabs_manager=new TabsManager();
	return 0;
}

extern "C" void tabs_close()
{
	delete tabs_manager;
}

TabsManager::TabsManager() : QObject()
{
	kdebugf();

	connect(chat_manager, SIGNAL(chatCreated(const UserGroup*)),
				this, SLOT(onNewChat(const UserGroup*)));
	connect(chat_manager, SIGNAL(chatDestroying(const UserGroup*)),
				this, SLOT(onDestroyChat(const UserGroup*)));
	connect(chat_manager, SIGNAL(chatOpen(UserListElements)),
				this, SLOT(onOpenChat(UserListElements)));


	connect(userlist, SIGNAL(statusChanged(UserListElement, QString, const UserStatus &, bool, bool)),
		this, SLOT(onStatusChanged(UserListElement, QString, const UserStatus &, bool, bool)));
        connect(gadu, SIGNAL(chatMsgReceived1(Protocol*, UserListElements, const QString&, time_t, bool&)),
                this, SLOT(onChatMsgReceived(Protocol*, UserListElements, const QString&, time_t, bool&)));

	connect(&timer, SIGNAL(timeout()),
			this, SLOT(onTimer()));

	ConfigDialog::addVGroupBox("Chat", "Chat",
			QT_TRANSLATE_NOOP("@default", "Tabs"));
	ConfigDialog::addCheckBox("Chat", "Tabs",
			QT_TRANSLATE_NOOP("@default", "Use tabs by default"), "DefaultTabs");
	ConfigDialog::addCheckBox("Chat", "Tabs",
			QT_TRANSLATE_NOOP("@default", "Tabs below chats"), "TabsBelowChats");
	ConfigDialog::addCheckBox("Chat", "Tabs", 
			QT_TRANSLATE_NOOP("@default", "Auto tab change"), "AutoTabChange");
	ConfigDialog::addSpinBox("Chat", "Tabs", 
			QT_TRANSLATE_NOOP("@default", "Mininum number ob tabs"), "MinTabs", 0, 255, 1, 2);
	ConfigDialog::addHotKeyEdit("Chat", "Tabs",
			QT_TRANSLATE_NOOP("@default", "Move tab left"), "MoveTabLeft");
	ConfigDialog::addHotKeyEdit("Chat", "Tabs",
			QT_TRANSLATE_NOOP("@default", "Move tab right"), "MoveTabRight");
	ConfigDialog::addHotKeyEdit("Chat", "Tabs",
			QT_TRANSLATE_NOOP("@default", "Switch to prev. tab"), "SwitchTabLeft");
	ConfigDialog::addHotKeyEdit("Chat", "Tabs",
			QT_TRANSLATE_NOOP("@default", "Switch to next tab"), "SwitchTabRight");

        ConfigDialog::registerSlotOnApplyTab("Chat", this, SLOT(onApplyConfig()));
	
	UserBox::userboxmenu->addItemAtPos(1, "OpenChat",
			tr("Open in new tab"), this, SLOT(onNewTab()));
	menuitem=UserBox::userboxmenu->getItem(tr("Open in new tab"));

	Action* action = new Action(
		QPixmap(dataPath("kadu/modules/data/tabs/attach.png")),
		tr("Attach this chat to tabs"), "tab_attach_action", Action::TypeChat);

	connect(action, SIGNAL(activated(const UserGroup*,const QWidget*,bool)),
		this, SLOT(onTabAttach(const UserGroup*)));

	KaduActions.insert("tab_attach_action", action);

	tabdialog=new TabWidget();
	connect(tabdialog, SIGNAL(currentChanged(QWidget *)),
			this, SLOT(onTabChange(QWidget *)));
	connect(tabdialog, SIGNAL(contextMenu(QWidget*,const QPoint&)),
			this, SLOT(onContextMenu(QWidget*,const QPoint&)));

	loadGeometry(tabdialog, "Chat", "TabWindowsGeometry", 30, 30, 400, 400);

	connect(UserBox::userboxmenu, SIGNAL(popup()), this, SLOT(onPopupMenu()));

	// pozycja tabw
	onApplyConfig();

	// zrb mi menu :>
	makePopupMenu();

	no_tabs=false;
}

TabsManager::~TabsManager()
{
	kdebugf();

	KaduActions.remove("tab_attach_action");
	
	UserBox::userboxmenu->removeItem(menuitem);

	ConfigDialog::unregisterSlotOnApplyTab("Chat", this, SLOT(onApplyConfig()));

	ConfigDialog::removeControl("Chat", "Move tab left");
	ConfigDialog::removeControl("Chat", "Move tab right");
	ConfigDialog::removeControl("Chat", "Switch to prev. tab");
	ConfigDialog::removeControl("Chat", "Switch to next tab");
	ConfigDialog::removeControl("Chat", "Mininum number ob tabs");
	ConfigDialog::removeControl("Chat", "Auto tab change");
	ConfigDialog::removeControl("Chat", "Tabs below chats");
        ConfigDialog::removeControl("Chat", "Use tabs by default");
        ConfigDialog::removeControl("Chat", "Tabs");

	disconnect(UserBox::userboxmenu, 0, this, 0);
	disconnect(chat_manager, 0, this, 0);
	disconnect(gadu, 0, this, 0);

	saveGeometry(tabdialog, "Chat", "TabWindowsGeometry");
	delete tabdialog;
}

void TabsManager::onNewChat(const UserGroup* senders)
{
	kdebugf();

	Chat* chat=chat_manager->findChat(senders);

	if(no_tabs){
		no_tabs=false;
		return;
	}


	if(senders->count()==1 && config_file.readBoolEntry("Chat", "DefaultTabs"))
		if(newchats.count() >= (config_file.readNumEntry("Chat", "MinTabs", 2)-1) ||
			tabdialog->count() >= (config_file.readNumEntry("Chat", "MinTabs", 2)-1)){
			insertTab(chat);
			UserListElements::iterator it;
			UserListElements uins;
			for(it=newchats.begin();it!=newchats.end();++it){
				// ehh, tyle kombinowania dla takiej prostej rzeczy
				uins.clear();
				uins.append(*it);
				chat=chat_manager->findChat(uins);
				if(chat)
					insertTab(chat);
			}
			newchats.clear();
		}
		else 
			newchats.append(*(senders->begin()));
	
}

void TabsManager::onDestroyChat(const UserGroup* senders)
{
	kdebugf();
	Chat* chat=chat_manager->findChat(senders);
	if(tabdialog->indexOf(chat)!=-1)
		tabdialog->removePage(chat);
	if(!tabdialog->count())
		tabdialog->hide();
	newchats.remove(*(senders->begin()));

}

/*
 * XXX: jak bedzie obsluga wielu protokolow to to bedzie trzeba lekko przerobic
 */
void TabsManager::onStatusChanged(UserListElement ule, QString protocolName, const UserStatus &, bool, bool)
{
	kdebugf();
	UserListElements ules;
	ules.append(ule);
	Chat* chat=chat_manager->findChat(ules);

	if(tabdialog->indexOf(chat)!=-1){
		tabdialog->setTabToolTip(chat, chat->title());
		if(tabdialog->currentPage()==chat){
			tabdialog->setCaption(chat->title());
			tabdialog->setIcon(ule.status(protocolName).pixmap());
		}
		tabdialog->changeTab(chat,  ule.status(protocolName).pixmap(),  ule.altNick());
	}
	
}

void TabsManager::onTabChange(QWidget* w)
{
	Chat* chat=(Chat*)w;
	UserListElement ule=(*(chat->users())->toUserListElements().begin());

	// czy jest na licie uin-w z nowymi wiadomociami
	if(newmsgs.contains(ule))
		newmsgs.remove(ule);

	tabdialog->setTabToolTip(chat, chat->title());
	tabdialog->setCaption(chat->title());
	tabdialog->setIcon(*(w->icon()));
	tabdialog->changeTab(chat, *(w->icon()),  ule.altNick());

}

void TabsManager::onOpenChat(UserListElements senders)
{
	Chat* chat=chat_manager->findChat(senders);
	if(chat){
		if(tabdialog->indexOf(chat)!=-1){
//			if(config_file.readBoolEntry("Chat","AutoTabChange"))
				tabdialog->setCurrentPage(tabdialog->indexOf(chat));
			tabdialog->raise();
		}
	}
	else
		autoswith=true;
}

void TabsManager::onChatMsgReceived(Protocol* protocol, UserListElements senders, const QString& msg, time_t time, bool& grab)
{
	// konferencji nie ma w tabach
	if(senders.size()!=1)
		return;

	Chat* chat=chat_manager->findChat(senders);
	if(chat)
		if((tabdialog->indexOf(chat)!=-1) && !(newmsgs.contains(senders[0])) &&
		(!tabdialog->isActiveWindow() || (tabdialog->currentPage()!=chat))){
			newmsgs.append(senders[0]);
			if(!timer.isActive())
				timer.start(500);
		}
}

void TabsManager::onApplyConfig()
{
	kdebugf();
	if(!config_file.readBoolEntry("Chat", "TabsBelowChats"))
		tabdialog->setTabPosition(QTabWidget::Top);
	else
		tabdialog->setTabPosition(QTabWidget::Bottom);			
}

void TabsManager::onNewTab()
{
	kdebugf();
	UserBox *activeUserBox = UserBox::activeUserBox();
	if (activeUserBox==NULL)
		return;
	UserListElements users = activeUserBox->selectedUsers();
	bool defaulttabs=config_file.readBoolEntry("Chat", "DefaultTabs");
	Chat* chat=chat_manager->findChat(users);
	
	// istniej = ola
	if(chat)
		return;

	if(defaulttabs)
		no_tabs=true;
	
	// nie istnieje to sie stworzy
	chat_manager->openPendingMsgs(users);
	
	// i rcznie doda
	if(!defaulttabs && users.size()==1){
		chat=chat_manager->findChat(users);
		insertTab(chat);
	}
}

void TabsManager::insertTab(Chat* chat)
{
	UserListElement ule=(*(chat->users())->toUserListElements().begin());
	QValueList<ToolButton*> buttons = KaduActions["tab_attach_action"]->toolButtonsForUserListElements((chat->users())->toUserListElements());

	for (QValueList<ToolButton*>::iterator i = buttons.begin(); i != buttons.end(); i++)
		(*i)->setEnabled(false);

	tabdialog->addTab(chat, *(chat->icon()),  ule.altNick());
	if(config_file.readBoolEntry("Chat","AutoTabChange") || autoswith)
		tabdialog->setCurrentPage(tabdialog->indexOf(chat));
	tabdialog->show();
	tabdialog->raise();
	if(config_file.readBoolEntry("Chat","ScrollDown"))
		chat->scrollHistoryToBottom();
	autoswith=false;
}

void TabsManager::onPopupMenu()
{
	kdebugf();
	UserBox *activeUserBox = UserBox::activeUserBox();
	if (activeUserBox==NULL)
		return;
	UserListElements users = activeUserBox->selectedUsers();

	if(users.size()!=1 && !config_file.readBoolEntry("Chat", "DefaultTabs"))
		UserBox::userboxmenu->setItemEnabled(menuitem, false);
	
	// jestemy normalni nie rozmawiamy ze sob ;)
	// XXX
/*	if(users[0]==(UinType)config_file.readNumEntry("General", "UIN"))
		UserBox::userboxmenu->setItemEnabled(menuitem, false);*/

	if(config_file.readBoolEntry("Chat", "DefaultTabs"))
		UserBox::userboxmenu->changeItem(menuitem, tr("Open in new window"));
	else
		UserBox::userboxmenu->changeItem(menuitem, tr("Open in new tab"));
}

// uff, troche dziwne to ale dziaa tak jak trzeba
void TabsManager::onTimer()
{
	kdebugf();
	Chat* chat;
	static bool msg, wasactive=1;
	
	// sprawdzaj wszystkie okna ktre s w tabach
	for(int i=tabdialog->count()-1;i>=0;i--){
		chat=(Chat*)tabdialog->page(i);
		UserListElement ule=(*(chat->users())->toUserListElements().begin());

		// czy trzeba co robi ?
		if(newmsgs.contains(ule)){

			// okno nieaktywne to trzeba co zrobi
			if(!tabdialog->isActiveWindow())
				if(tabdialog->currentPage()==chat | !msg)
					tabdialog->setCaption(chat->caption()); // bdzie miga tak jak osobne okno
				else if(msg)
					tabdialog->setCaption(tr("NEW MESSAGE(S)"));
	

			// tab aktualnie nieaktywny to ustaw ikonke
			if(tabdialog->currentPage()!=chat)
				if(msg)
					tabdialog->setTabIconSet(chat,
						icons_manager->loadIcon("Message"));
				else
					tabdialog->setTabIconSet(chat,
						*(chat->icon()));
			else if(tabdialog->currentPage()==chat && 
					tabdialog->isActiveWindow())
					newmsgs.remove(ule); // wywal go z listy uin-w z nowymi wiadomociami
		}
		
		if(tabdialog->isActiveWindow()) 
			if(tabdialog->currentPage()==chat)
				tabdialog->setCaption(chat->title()); // a tutaj przywr tytu
			else if(newmsgs.count()==1 && !wasactive)
				tabdialog->setCurrentPage(tabdialog->indexOf(chat));
	}


	if(newmsgs.size()==0)
		timer.stop();

	wasactive=tabdialog->isActiveWindow();		
	msg=!msg;	
}

void TabsManager::onTabAttach(const UserGroup* users)
{
/*	QPushButton* button=(QPushButton*)sender();
	Chat* chat=TabButtonChat[button];*/
	Chat* chat= chat_manager->findChat(users);
	UserListElements senders=chat->users()->toUserListElements();

	// czyli ju istnieje
	if(tabdialog->indexOf(chat)!=-1)
		return;
	
	if(senders.size()==1){
		insertTab(chat);
//		button->setEnabled(false);
	} 
}

void TabsManager::onContextMenu(QWidget* w, const QPoint& pos)
{
	kdebugf();
	selectedchat=(Chat*)w;
	menu->popup(pos);
}

void TabsManager::makePopupMenu()
{
	kdebugf();
	menu=new QPopupMenu();
	menu->insertItem(tr("Detach"), 0);
	menu->insertItem(tr("Close"), 1);
	menu->insertItem(tr("Close all"), 2);
	connect(menu, SIGNAL(activated(int)), this, SLOT(onMenu(int)));
}

void TabsManager::onMenu(int id)
{
	UserListElements uins=selectedchat->users()->toUserListElements();
	switch(id){
		case 0:
			delete selectedchat;
			// i tak zawsze jest tylko jeden ;)
			no_tabs=true;
			chat_manager->openPendingMsgs(uins);
			break;
		case 1:
			delete selectedchat;
			break;
		case 2:
			for(int i=tabdialog->count();i>=0;i--)
				delete tabdialog->page(i);
			break;
	}
}

TabsManager* tabs_manager;
