package GCPlugins::GCAniDB;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;

use GCPlugins::GCPluginsBase;

{
    package GCPlugins::GCPluginAniDB;

    use base qw(GCPluginParser);

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
        $self->{inside}->{$tagname}++;

        if ($self->{parsingEnded})
        {
            if ($tagname eq "a")
            {
                if ($attr->{href} =~ m/animedb\.pl\?show=animeatt&aid=([0-9]*)/)
                {
                    $self->{movieIdx} = 0;
                    $self->{movieList}[0]->{"url"} = "animedb\.pl\?show=anime&aid=" . $1;
                }
            }
            return;
        }

        if ($self->{parsingList})
        {
            if ($tagname eq "a")
            {
                if ($attr->{href} =~ m/animedb\.pl\?show=anime&aid=[0-9]*/)
                {
                    $self->{isMovie} = 1;
                    $self->{isInfo} = 1;
                    $self->{movieIdx}++ if ($self->{movieIdx} < 0) || ($attr->{href} ne $self->{movieList}[$self->{movieIdx}]->{"url"});
                    $self->{movieList}[$self->{movieIdx}]->{'url'} = $attr->{href};
                }
            }
            elsif ($tagname eq "td")
            {
                $self->{couldBeYear} = 1 if ($attr->{align} eq "center");
            }
            elsif ($tagname eq "h1")
            {
                $self->{insideHeadline} = 1;
            }
        }
        else
        {
            if ($tagname eq "img")
            {
                if (($attr->{src} =~ m/http\:\/\/img[0-9]\.anidb\.info\/pics\/anime\/[0-9]*\.jpg/) && ($attr->{border} eq "0"))
                {
                    $self->{curInfo}->{image} = $attr->{src} if !$self->{curInfo}->{image};
                }
            }
            elsif ($tagname eq "div")
            {
                if ($attr->{class} eq "synopsis")
                {
                    $self->{insideSynopsis} = 1;
                }
            }
        }
    }

    sub end
    {
		my ($self, $tagname) = @_;

        $self->{inside}->{$tagname}--;
    }

    sub text
    {
        my ($self, $origtext) = @_;

        return if ($self->{parsingEnded});

        if ($self->{parsingList})
        {
            if ($self->{insideHeadline})
            {
                $self->{parsingEnded} = 1 if $origtext !~ m/Anime List - Search for:/;
                $self->{insideHeadline} = 0;
            }

            if ($self->{isMovie})
            {
                $self->{movieList}[$self->{movieIdx}]->{"title"} = $origtext;
                $self->{isMovie} = 0;
                $self->{isInfo} = 1;
                return;
            }
            elsif ($self->{couldBeYear})
            {
                $self->{movieList}[$self->{movieIdx}]->{"year"} = $origtext if $origtext =~ m/^ [0-9]{4}(-[0-9]{4})? $/;
                $self->{couldBeYear} = 0;
            }
        }
        else
        {
            if ($self->{insideSynopsis})
            {
                ($self->{curInfo}->{synopsis} = $origtext) =~ s/\s{2,}/ /g;
                $self->{curInfo}->{synopsis} =~ s|GCBRGC|<br>|g;
                $self->{curInfo}->{synopsis} =~ s/^\s*//;
                $self->{insideSynopsis} = 0;
            }
            elsif ($self->{inside}->{div})
            {
                $self->{curInfo}->{title} = $1 if $origtext =~ m/Title: (.*) /;
                if ($origtext =~ m/(?:Jap. Kanji|English): (.*) /)
                {
                    #print "Before : $1\n";
                    #my $text = pack "U0C*", unpack "C*", $1;
                    #print "After 1 : $text\n";
                    #$text = Encode::encode_utf8($text);
                    #print "After 2 : $text\n";
                    #$self->{curInfo}->{orig} = Encode::encode('UTF-8', $1);
                    $self->{curInfo}->{orig} = $1;
                }
                $self->{curInfo}->{date} = $1 if $origtext =~ m/Year: (.*)/;
                $self->{curInfo}->{director} = $1 if $origtext =~ m/Companies: (.*) /;
                if ($origtext =~ m/Genre: (.*)/)
                {
                    $self->{curInfo}->{type} = $1;
                    $self->{curInfo}->{type} =~ s/ - //;
                }
            }
        }
    } 

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{isInfo} = 0;
        $self->{isMovie} = 0;
        $self->{curName} = undef;
        $self->{curUrl} = undef;

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;

        #use Compress::Zlib;

        #my $html = Compress::Zlib::memGunzip($html);

        $self->{parsingEnded} = 0;

        $html =~ s/<a href="animedb\.pl\?show=producer&prid=[0-9]*" title="[^"]*">([^<]*)<\/a>/$1/g;
        #"
        $html =~ s/<a href="animedb\.pl\?show=genre" target="_blank">(Genre:)<\/a>/$1/g;
        $html =~ s/<a href="animedb\.pl\?show=animelist&genid=[^"]*" title="[^"]*">([^<]*)<\/a>/$1/g;
        $html =~ s/ - <a href="animedb\.pl\?show=search&do\.search=1(&search\.anime.genre.[0-9]*=on){1,}" title="search for other animes with all of these genres">\[similar\]<\/a> //;
        $html =~ s/<td> ([^:]*): <\/td>\s*<td> ([^<]*) ?<\/td>/<div>$1: $2<\/div>/g;
        $html =~ s/<br \/>/GCBRGC/g;
        $html =~ s/<b>Awards:<\/b><br><a href="[^"]*" target="_blank"><img src="[^"]*" border=0 alt="[^"]*" title="[^"]*"><\/a> <hr>//g;
        #$html =~ s/([^<]*<\/table>[^<]*<\/td>[^<]*<\/tr>[^<]*<\/table>[^<]*<\/td>[^<]*<\/tr>[^<]*<tr>[^<]*<td>\s*)([^<]*)(<\/td>[^<]*<\/tr>[^<]*<\/table>[^<]*<hr>[^<]*<table border=0>[^<]*<tr>[^<]*<td bgcolor="#b0b0b0">[^<]*<b>Group&nbsp;Info:<\/b>[^<]*<\/td>[^<]*<td bgcolor="#b0b0b0"> Group <\/td>[^<]*<td bgcolor="#b0b0b0" align="center"> Last Ep <\/td>[^<]*<td bgcolor="#b0b0b0" align="center"> State <\/td>[^<]*<td bgcolor="#b0b0b0" align="center"> Last Update <\/td>[^<]*<td bgcolor="#b0b0b0" align="center"> Rating <\/td>[^<]*<td bgcolor="#b0b0b0" align="center"> Cmts <\/td>[^<]*<td bgcolor="#b0b0b0" align="center"> Action <\/td>[^<]*<\/tr>)/$1<div class="synopsis">$2<\/div>$3/m;
        #$html =~ s/([^<]*)(<\/td>[^<]*<\/tr>[^<]*<\/table>[^<]*<hr>[^<]*<table border=0>[^<]*<tr>[^<]*<td bgcolor="#b0b0b0">[^<]*<b>Group&nbsp;Info:<\/b>[^<]*<\/td>[^<]*<td bgcolor="#b0b0b0"> Group <\/td>[^<]*<td bgcolor="#b0b0b0" align="center"> Last Ep <\/td>[^<]*<td bgcolor="#b0b0b0" align="center"> State <\/td>[^<]*<td bgcolor="#b0b0b0" align="center"> Last Update <\/td>[^<]*<td bgcolor="#b0b0b0" align="center"> Rating <\/td>[^<]*<td bgcolor="#b0b0b0" align="center"> Cmts <\/td>[^<]*<td bgcolor="#b0b0b0" align="center"> Action <\/td>[^<]*<\/tr>)/$1<div class="synopsis">$1<\/div>$2/m;

        #Removed italic strings (useful for synopsis source)
        $html =~ s|<i>(.*?)</i>|$1|g;
        #Extract synopsis
        $html =~ s|<td>([^<]*?)</td>\s*?</tr>\s*?</table>\s*?<hr>|<div class="synopsis">$1</div>|ms;
        
        #Remove Headline tag
        $html =~ s/>\W*?<!-- headline -->/>/;

        return $html;
    }
    
    sub getSearchUrl
    {
		my ($self, $word) = @_;
	
        return "http://anidb.info/perl-bin/animedb.pl?show=animelist&adb.search=$word";
    }
    
    sub getMovieUrl
    {
		my ($self, $url) = @_;
		
        return 'http://anidb.info/perl-bin/' . $url;
    }

    sub getName
    {
        return "AniDB";
    }
    
    sub getImageFile
    {
        return "anidb.png";
    }

    sub getAuthor
    {
        return 'MeV';
    }
    
    sub getLang
    {
        return 'EN';
    }
    
#    sub getCharset
#    {
#        my $self = shift;
#    
#        return "UTF-8";
#    }

    sub getNotConverted
    {
        my $self = shift;
        return ['orig'];
    }

    sub hasSearchActors
    {
        return 0;
    }

    sub hasSearchDirector
    {
        return 0;
    }
}

1;
